 $PASCAL '92084-1X719 REV.5020 <891027.1350>'  !{****************************************************************  ! !*                                                               *  ! !*  (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1981. ALL RIGHTS       *  ! !*  RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,        *  ! !*  REPRODUCED OR TRANSLATED TO ANOTHER PROGRAMMING LANGUAGE     *  ! !*  WITHOUT THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD     *  ! !*  COMPANY.                                                     *  ! !*                                                               *  ! !*****************************************************************  ! *   	*    NAME:  CMAIN  	 *  SOURCE:  92084-18719   *   RELOC:  part of 92084-12050   *    PGMR:  J.L.M., D.N., W.J.A., ANT   *   *  10DEC87 ANT Alter to CI file name conventions  *   }   $AUTOPAGE ON$   $SUBPROGRAM$  { modified program name to work with new pascal jaf2540 }   PROGRAM CMAIN_P;   {Include type definitions and external procedure declarations.}    $list off$    CONST       max_number_subchannels=64;      $INCLUDE 'SMTPS.pasi'$  $INCLUDE 'TMTPS.pasi'$  $INCLUDE 'DBTPS.pasi'$  $INCLUDE 'COTPS.pasi'$  $list on$   $PAGE$  #{These next procedures are written in FORTRAN, PASCAL or ASMB for the  # 
 backup utilities.}  
 'PROCEDURE add_track $ALIAS 'ADDTR'$ (VAR track,sector,next_track,next_sector,  ' "            blocks,sectors_per_track,total_tracks:integer);external; "     PROCEDURE define_track_maps $ALIAS 'UDTRM'$   
     (VAR log_lu:integer;  
       VAR track_map:disc_parameters_type;         max_subchannels:integer;  "      VAR num_defined,disc_code, disc_lu,status:integer); external;  "             &PROCEDURE put_track_map $ALIAS 'PUTRM'$(VAR track_map:disc_parameters_type;  & "                     VAR disc_code,disc_lu,status:integer);external; "      PROCEDURE output_string $ALIAS 'DIALG'$ (VAR output:string_type;             output_length:integer);external;      PROCEDURE skip_line $ALIAS 'DIALG'$ (spaces:ascii_word_type;                                     length:integer);external;       PROCEDURE print $ALIAS 'DIALG'$ (print_buffer:error_string_type;   !                                 buffer_length:integer);external;  !     "PROCEDURE logit(VAR list_lu,log_lu:integer; VAR string:string_type;  "                 string_length:integer);external;  !PROCEDURE short_logit $ALIAS 'LOGIT'$ (VAR list_lu,log_lu:integer; !                 string:error_string_type; buffer_length:integer);                                                           external;       PROCEDURE disc_params_check $ALIAS 'DPCHK'$       (VAR source_prams,dest_prams:disc_parameters_type;       abort_flag:boolean; VAR minimum_of_tracks:integer;        backup_utility:backup_utility_type;       VAR options:current_options_type);external;      PROCEDURE disc_write_error $ALIAS 'DWERR'$                     (VAR list_lu,disc_lu,track,sector:integer);  #                                                             external; # PROCEDURE disc_read_error $ALIAS 'DRERR'$   "               (VAR list_lu,disc_lu,track,sector:integer);external;  "     #FUNCTION get_buffer_address $ALIAS 'GPNTR'$ (VAR first_word:integer):  # $                                           data_buffer_pointer;external; $     %PROCEDURE get_record_size $ALIAS 'GTRSZ'$ (VAR sectors_per_track:integer;  % !            max_verify_length:integer;  VAR actual_verify_length,  !             blocking_factor:integer);external;          !PROCEDURE lock_discs $ALIAS 'LCKDI'$ (VAR disc_lus:disc_lus_type;  !             backup_utility:backup_utility_type;   #            VAR options:current_options_type; VAR string:string_type); #                                                     external;       PROCEDURE mount_check $ALIAS 'MTCHK'$       (VAR disc_LUs : disc_LUs_type;       VAR options : current_options_type;       VAR string : string_type;       VAR system_lu_found : boolean);      EXTERNAL;       &PROCEDURE spare (VAR disc_lu,list_lu:integer; option,lu_un:ascii_word_type;  &                  VAR status:integer); external;       PROCEDURE error $ALIAS 'RPERR'$ (name:name_string_type;   !                        error_return:error_return_type);external;  !     PROCEDURE read_disc $ALIAS 'RDISC'$ (VAR disc_lu:integer;   &            VAR buffer:general_buffer_type; VAR track,sector,length:integer; &             VAR checksums:checksum_buffer_type;                VAR error_flag:integer; VAR verify:ascii_word_type;    !            VAR sectors_per_track,total_tracks:integer);external;  !     PROCEDURE write_disc $ALIAS 'WDISC'$ (VAR disc_lu:integer;              VAR buffer:general_buffer_type; VAR track,sector,   #            block_length:integer; VAR checksums:checksum_buffer_type;  #              VAR error_flag:integer; VAR verify:ascii_word_type;                VAR verify_buffer:data_buffer_type;   "            VAR verify_block_length:integer; VAR sectors_per_track,  "             total_tracks:integer);external;       {Force my small error catcher to be pulled in.}   PROCEDURE catch_errors $ALIAS 'PAS.ERRORCATCHER'$;external;       {The following declarations are calls to various system, disc,   and FMP library routines which are supported under RTE-6 and    RTE-XL.}       {Returns false when break flag is set.}   FUNCTION ifbrk:boolean;external;      %PROCEDURE dscpr(VAR disc_lu:integer; VAR disc_params:disc_parameters_type; %                 VAR status:integer);external;   !FUNCTION ldtyp (VAR lu,lu_code:integer):ascii_word_type;external;  !     %PROCEDURE lurq (VAR lock_code:lurq_type; VAR lu:integer; num_lus:integer); % "                                                           external; " PROCEDURE namr (VAR namr_buffer:namr_parse_buffer_type;   !                VAR buffer:string_type; max_buffer_length:integer; !                 VAR starting_character:integer);external;   #PROCEDURE cnumd(VAR number:integer; VAR dec_string:name_string_type);  # !                                                         external; ! PROCEDURE double_int_to_ascii $ALIAS '.D2AD'$   $    (VAR number:double_int; VAR string:double_int_string_type);external; $     $PAGE$  {CMAIN performs the online or offline disc copy option.}      PROCEDURE cmain(VAR disc_lus:disc_lus_type;   "   VAR io_buffer:general_buffer_type; VAR io_buffer_length:integer;  "    VAR list_lu,source_disc_lu,destination_disc_lu:integer;     VAR options:current_options_type;     VAR common:common_block_pointers_type);        LABEL 99;         CONST       VE_='VE';         VAR           system_lu_found : boolean;      special_string:string_type;           lu_locking_code:lurq_type;          verify_buffer:data_buffer_pointer;          checksums:checksum_buffer_type;       
    offline:boolean; 
         source_disc_parameters,       destination_disc_parameters:disc_parameters_type;           nmemonic:ascii_word_type;       
    current_sector,  
 	    current_track, 	     destination_disc_code,      {Disc type of destination LU.}      i,  "    io_blocking_factor,         {Number of io transfers per track.}  " !    io_buffer_size,             {Number of 128 word blocks in each !                                  standard disc write.}      log_lu,                     {Login lu.}        num_defined,                {Number disc subchannels defined                                    offline.}      read_writes_remaining,      {Number of io sequences in the                                   copy.}       sectors_remaining,          {Sectors left in restore.}      source_disc_code,           {Disc type of source lu.}        status,                     {For various external routines.}       tracks_to_write,            {Actual number of tracks which                                   must be written to for the                                    current restore operation.}       verify_blocking_factor,     {Number of verify buffer blocks                                     per track (unused).}   #    verify_buffer_length,       {Words availiable for verify buffer.}  #     verify_buffer_size:integer; {Blocks in verify buffer.}      temp: double_int;           {Temporary working storage.}      $PAGE$        {print_error outputs an error message to the hard copy     device, and calls error (RPERR) to post the error code      and terminate when running online.  The routine     has been optimized for max_error_string_length=26.}         PROCEDURE print_error(error_return:error_return_type);$direct$       LABEL 1;          BEGIN   
      CASE error_return OF 
 	        no_error:  	 %            print('PCOPY NORMAL END OF JOB   ',-max_error_string_length);  %     
        not_enough_memory: 
 %            print('SIZE UP THE PROGRAM!      ',-max_error_string_length);  %     
        invalid_parameter: 
 %            print('INVALID PARAMETER         ',-max_error_string_length);  %     
        too_few_tmt_defs:  
 %            print('NOT ENOUGH SUBCHANNELS    ',-max_error_string_length);  %     	        br_sensed: 	 %            print('BREAK SENSED              ',-max_error_string_length);  %             no_disc_params:   %            print('NO DISC PARAMETERS        ',-max_error_string_length);  %     
        spare_fail:  
           BEGIN   %            print('SPARE ATTEMPT FAILED      ',-max_error_string_length);  % 
            goto 1;  
           END;              bad_lu:   %            print('BAD LU WAS ACCESSED       ',-max_error_string_length);  %              unexpected_exec_failure:             {should not occur.}   %            print('EXEC CALL FAILED          ',-max_error_string_length);  %     	        OTHERWISE  	 %            print('UNEXPECTED ERROR!!        ',-max_error_string_length);  %     	      END; {CASE}  	           error('CMAIN ',error_return);         goto 99;  {Returns if online.}           {Several error options might cause a return        to the caller.}           1:          END; {print_error}         {All debug assertions filter through this routine.}     PROCEDURE debug; $direct$       BEGIN         print_error(unexpected_error);        END;          {Unlock all locked LUs.}          PROCEDURE unlock; $direct$        BEGIN         WITH lu_locking_code.unlocking DO           BEGIN             unlock_all:=true;             no_abort:=false;   
           is_disc:=true;  
            lock:=false;            END;              lurq(lu_locking_code,destination_disc_lu,1);   	     END; {unlock} 	         {Interprets status returned by disc_write.}       PROCEDURE disc_write_status_check(VAR disc_lu:integer);         BEGIN           CASE status OF            -3:print_error(unexpected_exec_failure);                -1,1: {Hardware or verify errors are                   indicated, but copy continues.}                   disc_write_error(list_lu,disc_lu,                                current_track,current_sector);  
           0:; {No error}  
 
          OTHERWISE debug; 
 
        END; {CASE}  
       END;      {Interprests status returned by disc_read.}       PROCEDURE disc_read_status_check(VAR disc_lu:integer);        BEGIN           CASE status OF            -4:print_error(unexpected_exec_failure);             -3,-2:  {Unrecoverable retry or hardware failure.}                disc_read_error(list_lu,disc_lu,                                current_track,current_sector);   
        0,-1:; {No error.} 
     
          OTHERWISE debug; 
         END;        END;  	  BEGIN  {cmain.}  	         {Initialize variables.  When used offline, all       data especially must be initialized, but this       is done in all cases.}           IF common.iprog_label^.iprog<0        THEN offline:=true  
      ELSE offline:=false; 
         current_track:=0;   {Current track.}      current_sector:=0;   {Current sector.}          log_lu:=common.talk_label^.log;           nmemonic:=ldtyp(source_disc_lu,source_disc_code);        nmemonic:=ldtyp(destination_disc_lu,destination_disc_code);            options[lu_un_pb_mu_se].ascii:='LU';          IF offline        THEN          BEGIN  {Define track maps.}   $          print('DEFINE SOURCE TRACK MAP   ',-max_error_string_length);  $           define_track_maps(log_lu,source_disc_parameters,1,  !              num_defined,source_disc_code,source_disc_lu,status); !               IF status<>0 THEN debug;             IF num_defined<>1 THEN print_error(too_few_tmt_defs);                  skip_line('  ',-2);       $          print('DEFINE DEST. TRACK MAP    ',-max_error_string_length);  $ !          define_track_maps(log_lu,destination_disc_parameters,1,  ! &             num_defined,destination_disc_code,destination_disc_lu,status);  &           IF status<>0 THEN debug;             IF num_defined<>1 THEN print_error(too_few_tmt_defs);            END         ELSE          BEGIN  {Get the track maps.}            {After locking and trying to mount the discs.}            mount_check (disc_lus, options, special_string,                  system_lu_found);             lock_discs (disc_lus, psave, options, special_string);   !          dscpr (source_disc_lu, source_disc_parameters, status);  !           IF status <> 0 THEN print_error (no_disc_params);   &          dscpr (destination_disc_lu, destination_disc_parameters, status);  &           IF status <> 0 THEN print_error (no_disc_params);            END;           {Check for disc format compatability.        Does not return upon errors.}      %    disc_params_check(source_disc_parameters,destination_disc_parameters,  %           false,tracks_to_write,psave,options);           {Get the optimal transfer size.  If verifying, split free        memory in half.  One half is used for the actual        io, the other half for verification.}          IF (options[ve].ascii=VE_)        THEN temp:=io_buffer_length DIV 2   
      ELSE temp:=0;  
         {Note that sectors per track must be the same on source        and destination.  So the first parameter here could be        either.}       #    get_record_size(source_disc_parameters.not_cs80.sectors_per_track, #                     io_buffer_length-temp,io_buffer_size,                       io_blocking_factor);          {Convert size into 128 word blocks.}          io_buffer_size:=io_buffer_size DIV 128;       IF (io_buffer_size=0) OR (io_blocking_factor=0)         THEN print_error(not_enough_memory);          {Get the verify buffer address even if the user is not       verifying.  This prevents possible nil pointer run time       errors when write_disc is called below.}           temp:=io_buffer_size*128;   #    verify_buffer:=get_buffer_address(io_buffer.data_buffer[temp+1]);  #         IF (options[ve].ascii=VE_)        THEN          BEGIN                 {Get verify buffer length in words.}                get_record_size(source_disc_parameters.                            not_cs80.sectors_per_track,                           (io_buffer_length-temp),   #                         verify_buffer_length,verify_blocking_factor); #               {Convert verify buffer length into blocks.}                 verify_buffer_size:=verify_buffer_length DIV 128;                 {Terminate if verification is impossible due to              memory constraints.  This should not occur due              to previous checks.}                 IF (verify_blocking_factor=0) OR               (verify_buffer_size=0)               THEN print_error(not_enough_memory);      
          IF offline 
 
          THEN BEGIN 
                put_track_map (destination_disc_parameters,  $                    destination_disc_code, destination_disc_lu, status); $                IF (status <> 0) THEN debug;             END;           {Spare destination disc depending on system type   
          and disc type.}  
           spare(destination_disc_lu,list_lu,'SP','LU',status);            IF status<>0 THEN print_error(spare_fail);          END         ELSE verify_buffer_size:=0;       $      temp := (source_disc_parameters.not_cs80.sectors_per_track DIV 2)  $           * tracks_to_write;            read_writes_remaining := temp DIV io_buffer_size;             IF (read_writes_remaining = 1)        THEN io_buffer_size := temp;            FOR i:=1 to read_writes_remaining DO          BEGIN             IF ifbrk THEN print_error(br_sensed);                 {Initialize source track map.}  
          IF offline 
             THEN  
              BEGIN  
                 put_track_map(source_disc_parameters,   #                              source_disc_code,source_disc_lu,status); #                 IF status<>0 THEN debug;  	              END; 	                read_disc(source_disc_lu,io_buffer,  #                current_track,current_sector,io_buffer_size,checksums, #                 status,options[ve].ascii,   !                source_disc_parameters.not_cs80.sectors_per_track, !                 tracks_to_write);              disc_read_status_check(source_disc_lu);                 IF offline   	             THEN  	 
               BEGIN 
                  put_track_map(destination_disc_parameters,   $                     destination_disc_code,destination_disc_lu,status);  $                  IF status<>0 THEN debug;   
               END;  
                write_disc(destination_disc_lu,io_buffer,  $                 current_track,current_sector,io_buffer_size,checksums,  $                  status,options[ve].ascii,verify_buffer^,                    verify_buffer_size,  $                 destination_disc_parameters.not_cs80.sectors_per_track, $                  tracks_to_write);             disc_write_status_check(destination_disc_lu);                    add_track(current_track,current_sector,current_track,                        current_sector,io_buffer_size,   $                     source_disc_parameters.not_cs80.sectors_per_track,  $                      tracks_to_write);          END;      99:           unlock;           print_error(no_error);       $list_code on$     END;. {CMAIN}      