 $PASCAL '91790-1X216 REV.4010 <860423.1418> '   $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	     MODULE tcpinit;   	$ALIAS 'N$tcpinit' 	     {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {     NAME:   TCPINIT   
{     SOURCE: 91790-18216  
 	{     RELOC:  NONE 	 	{     PGMR:   EMS  	 {}      {}  {   {  This module contains the TCP initialization routines   {  for NSINIT.  {   {}      {------------------------------------------------------------      MODIFICATION HISTORY      DATE    PGMR     DESCRIPTION      850520  ems      Changed max seg size to 4064.       850528  ems      Changed PR_MAXMSGLEN from MAX_USER_BYTES TO                         32767.      860210  ems      Add Heap 0 compiler directive (n314).       860228  ems      Initialize result in syntcp, clean up error                        handling in inittcp (n356).   !   860402  mcl      PCO 2626. Change default retransmit algorithm  ! !                    configuration parameter from linear (wrong) to !                     exponential (right).     860411  mcl      made tcp segment size lower limit be 1024   $                    so that it does not violate MM allocation assumption $                     PCO 2626   ------------------------------------------------------------}      IMPORT     $SEARCH 'phtm/bodec.rel'      bodec,      $SEARCH 'phtm/SODEC.rel'      sodec,      $SEARCH 'phtm/mmdec.rel'      mmdec,      $SEARCH 'phtm/mmext.rel'      ds_mm,      $SEARCH 'phtm/trcmod.rel'     trcmod,     $SEARCH 'phtm/SIGMOD.rel'     sigmod,     $SEARCH 'phtm/init_dec.rel'     init_dec,     $SEARCH 'phtm/initmulti.xpt'      initmulti,      $SEARCH 'phtm/parsdd.xpt'     parser,     $SEARCH 'phtm/filemad.xpt'      fileman,      $SEARCH 'phtm/tmrdec.rel'     tmrdec,     $SEARCH 'phtm/tuser.rel'      tuser,      $SEARCH 'phtm/TCPGB.rel'      tg,     $SEARCH 'phtm/TCPLB.rel'      tl;              $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {                                                        }  {          EXPORT   PROCEDURES                           }  {                                                        }  {--------------------------------------------------------}          	PROCEDURE SynCkTCP 	    (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);           
PROCEDURE ShutdnTCP  
    (    trustvar    : TrustType;      VAR result      : Int16);           	PROCEDURE InitTCP  	    (VAR ierr : Int16);              {----------------------------------------------------}  {               Implement Section                    }  {----------------------------------------------------}      IMPLEMENT       VAR      tcpgblk     : TCPListBufType;          $SUBTITLE 'TCP Syntax Check routine', PAGE$   {-------------------------------------------}   {              SynCkTCP                     }   {-------------------------------------------}       	PROCEDURE SynCkTCP 	    (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);           {}  !{ Description: Get user input to TCP configuration items; perform  !  {   validity check on the inputs; returns DSAM Table size to the   {   caller.   {   { Parameters:   !{   dsamtbsize (output)    Rreturn number of word required for TCP ! {                          tables (paths, pcbs and globals).  ${   socketcnt  (output)    Used by TCP to calculate its DSAM table size. $ {   classcnt   (output)    Ignored, not used for TCP  {   rsncnt     (output)    Ignored, not used for TCP  {   smbsize    (output)    Ignored, not used for TCP  {   result     (output)    Set to zero if successfull.  #{                          Return 'SYNCKERRR' if user input is invalid # #{                          or error returned from the Syntax checker.  # {}      LABEL      99;      CONST   	   TCPLINECNT = 6; 	     TYPE         TCPoptType = Array[1..TCPLINECNT] OF IStringType;      CONST      TCPPrintArray = TCPoptType[  IStringType[     '*++    Transmission Control Protocol (TCP)  ++*'],  IStringType[     '*'],  IStringType[     '* Initial Segment Size in bytes:                  4096'],   IStringType[  "   '* Retransmission Backoff Algorithm:               Exponential'], " IStringType[     '* Retransmission Smoothing parameter Alpha:       9'],  IStringType[     '* Retransmission Smoothing parameter Beta:        20']];         OPTPROMPT =     '* Do you want to modify these values? [Y/(N)]:_';      SEGPROMPT =     '* Enter the initial segment size [1024..(4096)..8000]:_';      BKOFFPROMPT =  "   '* Do you want Exponential (E) or Linear (L) backoff [(E)/L]:_';  "    ALPHAPROMPT =     '* Enter the value for Alpha [1..(9)..10]:_';     BETAPROMPT  =     '* Enter the value for Beta [1..(20)..20]:_';             INITTCPGBLS = TCPListBufType        [i_phead    : 1,  {indeterminant path list}        d_phead    : 2,  {determinant path list  }        f_phead    : 3,  {free path struct list  }        f_thead    : 2,  {free tcb list          }        i_thead    : 1,  {in_use tcb list        }        tcpsocket  : 0,  {tcp socket ID          }        {No exp. backoff retrx; not in debug mode}        segsize    : 4096,        max_pcbs   : 18,   {*}        max_paths  : 18,   {*}        no_delay   : 1,    { }        wnd_ps     : 35,   { }        tcp_alpha  : 0.9,  { }        tcp_beta   : 2.0,  { }        init_to    : 5,    {in seconds}         expbkof    : 1,         port_addr  : MIN_DYNAMIC,         tcp_debug  : 0,         stats      : TCPStatType                     [badsum : 0, badoff : 0, hdrop : 0,                      badsegs: 0, unack  : 0]];           VAR   
  inputline : IStringType; 
 
  input_char: OneCharType; 
 
  input_int : Int16; 
 
  bannercount:Int16; 
 
  error_rtn : Int16; 
 
  lo_val    : Int16; 
 
  hi_val    : Int16; 
   prm_flag  : Boolean;    default   : Boolean;    terminator: Boolean;  
  stgtoken:   IStringType; 
 
  term:       TEXT;  
     BEGIN {syncktcp}  result := GOOD;   {Clear all variables}   prm_flag    := false;       {Initialize the tcp options to their defaults}  tcpgblk     := INITTCPGBLS;       {Get maximum number of connection from ipc}   IF initglobals.IG_tot_nodal_sockets > 0 THEN     BEGIN { good connection count }     {Remember the max number of connections}      tcpgblk.max_pcbs  := initglobals.IG_tot_nodal_sockets;      tcpgblk.max_paths := initglobals.IG_tot_nodal_sockets;      dsamtbsize := initglobals.IG_tot_nodal_sockets *   "                   (SIZEOFTCPSV + SIZEOFTCPPATH) + SIZEOFTCPLISTHD;  "        {Print TCP default option values}     For bannercount := 1 TO TCPLINECNT DO        BEGIN    { print option values }      "      PrintPrompt( prm_flag, TCPPrintArray[bannercount], error_rtn); "       IF error_rtn <> GOOD THEN GOTO 99;        END;     { print option values }         {Prompt user for option changes}      default    := true;     YesNoInput( OPTPROMPT, default, input_char, error_rtn);     IF error_rtn <> 0 THEN GOTO 99;         IF default THEN input_char := 'N';          IF input_char = 'Y' THEN         BEGIN  { prompt items }             default := TRUE;  
      terminator := false; 
           {Prompt for segment size}         lo_val  := 1024;        hi_val  := 8000;         IntInput( SEGPROMPT, default, terminator, hi_val, lo_val,                         tcpgblk.segsize, error_rtn);         IF error_rtn <> GOOD THEN GOTO 99;      
      {Check default case} 
       IF default THEN tcpgblk.segsize := 4096;            { Set the initial timeout}        tcpgblk.init_to := 5;             {Prompt for backoff algorithm}        default := true;        stgtoken := 'L,E';        WordInput( BKOFFPROMPT, default, stgtoken, inputline,                           error_rtn);         IF error_rtn <> GOOD THEN GOTO 99;      
      IF NOT default THEN  
          IF inputline[1] = 'G' THEN               tcpgblk.expbkof := 0;             {Prompt for alpha and beta values}  
      lo_val  := 1;  
 
      hi_val  := 10; 
 
      default    := true;  
 
      terminator := FALSE; 
 !      IntInput( ALPHAPROMPT, default, terminator, hi_val, lo_val,  !                         input_int, error_rtn);        IF error_rtn <> GOOD THEN GOTO 99;            {Check for default of alpha}  
      IF NOT default THEN  
                tcpgblk.tcp_alpha := input_int / 10.0;       
      lo_val  := 1;  
 
      hi_val  := 20; 
 
      default    := true;  
 
      terminator := FALSE; 
        IntInput( BETAPROMPT, default, terminator, hi_val, lo_val,                              input_int, error_rtn);             IF (error_rtn = 0) AND NOT default THEN                  tcpgblk.tcp_beta := input_int / 10.0;        END    { prompt items }      END   { good connection count }    ELSE     BEGIN    { internal problem: no socket count }          error_rtn := ERRTCPNOSOCK;      END;     { internal problem: no socket count }       99:;      
result := error_rtn; 
 END;  {syncktcp}              $SUBTITLE 'TCP Shutdown module', PAGE$  {-------------------------------------------}   {              ShutdnTCP                    }   {-------------------------------------------}       
PROCEDURE ShutdnTCP  
    (    trustvar    : TrustType;      VAR result      : Int16);       {}  { Description: Module to be called by the NS/1000 Shutdown  {    program; TCP does not require any system resources on its  {    own; so its shutdown procedure do nothing.   {   { Parameters:   {    trustvar   (input)  Indicates potential corruption of  {                        data structures. For TCP there no  {                        recovery and hence does not have   {                        to worry.  {   {    result     (output) Always returns successful.   {   {}      BEGIN {shutdown}  {Always return successfully}  result := 0;  END;  {shutdown}                  $SUBTITLE 'Initialize TCP stuffs', PAGE$  {-------------------------------------------}   {              InitTCP                      }   {-------------------------------------------}       	PROCEDURE InitTCP  	    {VAR ierr : Int16};      {}  { The routine does the following:   {  1. Allocate tcp path structures.   {  2. Allocate tcp control blocks.  {  3. Allocate tcp list record and misc. globals  {  4. Initialize path and pcb list pointers.  {  5. Create pcb and path free list.  {  6. Initialize HP domain record   {  7. Initialize IPC's protocol record.   {   {}      LABEL 44;       VAR      i            : Int16;     path_buffer  : TCPPathRecType;      tcp_listbuf  : TCPListBufType;      error        : Int16;     domainrec    : DomainRecord;      protorec     : ProtocolRecord;           
PROCEDURE ExitInit;  
    BEGIN    { ExitInit }         DS_InitLeaveCritical( tcp_wkmap );      GOTO 44;          END;     { ExitInit }      $ SUBTITLE 'InitTcp', PAGE $  BEGIN { init }  error := 0;   tcp_ierr := 0;      {Go critical while we building our tables}  DS_InitEnterCritical ( tcp_wkmap, tcp_ierr );   IF tcp_ierr <> SUCCESSFUL THEN GOTO 44;       {Get tcp list head pointers and misc. record}   DS_GetTableSpace(DS_TCP_LISTHDTD, 1, 1,                         SIZEOFTCPLISTHD, error);  IF error <> GOOD THEN ExitInit;       {Get tcp control structures}  DS_GetTableSpace(DS_TCP_TCBTD, 1, tcpgblk.max_pcbs,                       SIZEOFTCPSV, error);  IF error <> GOOD THEN ExitInit;       
{Get tcp path structures}  
 DS_GetTableSpace(DS_TCP_PATHTD, 1, tcpgblk.max_paths,                         SIZEOFTCPPATH, error);  IF error <> GOOD THEN ExitInit;       {initialize the lists }       WITH tcpgblk DO      BEGIN    { WITH tcpgblk }     {Get tcp's sbufid from ipc's table}     DS_FetchElement ( DS_TrackTD, TL_TCP_SOCKET, tcpsocket );             DS_StoreElement(DS_TCP_LISTHDTD, 1, tcpgblk.int);         {initialize pointers}  
   WITH path_buffer, sv DO 
       BEGIN       { WITH path_buffer, sv }        {initialize all path records}         path_buffer := INITTCPPATH;       
      {free path sentinel} 
       p_pre_ptr := f_phead;         p_nxt_ptr := p_pre_ptr;          DS_StoreElement(DS_TCP_PATHTD, f_phead, path_buffer.int);              {i_path sentinel}         p_pre_ptr := i_phead;         p_nxt_ptr := p_pre_ptr;          DS_StoreElement(DS_TCP_PATHTD, i_phead, path_buffer.int);              {d_path sentinel}         p_pre_ptr  := d_phead;        p_nxt_ptr  := p_pre_ptr;         DS_StoreElement(DS_TCP_PATHTD, d_phead, path_buffer.int);        
      {free tcb sentinel}  
       sv         := INITSTATEVECTOR;        sv_pre_ptr := f_thead;        sv_nxt_ptr := sv_pre_ptr;         DS_StoreElement(DS_TCP_TCBTD, f_thead, sv.int);             {in_use tcb sentinel}         sv_pre_ptr := i_thead;        sv_nxt_ptr := sv_pre_ptr;         DS_StoreElement(DS_TCP_TCBTD, i_thead, sv.int);             {Initialize the tcb and path free lists}        FOR i := 4 TO tcpgblk.max_paths DO           BEGIN {free path list}                InsertList(DS_tcp_pathtd, f_phead, i);            END;  {free path list}             FOR i := 3 TO tcpgblk.max_pcbs DO   
         BEGIN    { FOR }  
              InsertList(DS_TCP_TCBTD, f_thead, i);  
         END;     { FOR }  
       END;       { WITH path_buffer, sv }      END;     { WITH tcpgblk }      { Initialize the TCP protocol record.}      DS_FetchElement (DS_ProtosTD, TCP, protorec.int);       WITH protorec DO     BEGIN    { WITH protorec }   
   pr_rnd := RND_OUTBOUND; 
    pr_services.bits[CALL] := TRUE;  
   pr_maxmsglen := 32767;  
 
   pr_default_incc := 100; 
    pr_default_outcc := 100;      pr_default_timeout := 600;      END;    { WITH protorec }      DS_StoreElement (DS_ProtosTD, TCP, protorec.int);       { Modify the HPDSN domain record to reflect TCP's role within}  { the domain.                                                }      DS_FetchElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);      	WITH domainrec DO  	    BEGIN { WITH domainrec }      dr_ipcpids.bits[TCP] := TRUE;     dr_memberpids.bits[TCP] := TRUE;   
   END; { WITH domainrec } 
     DS_StoreElement (DS_DomainsTD, HPDSN_DOMAIN, domainrec.int);      { Update the IPC protocol record to reflect the fact that TCP}  { is one of IPC's direct supporters.                         }      DS_FetchElement ( DS_ProtosTD, IPC, protorec.int);  protorec.pr_supportingpids.bits[TCP] := TRUE;   DS_StoreElement (DS_ProtosTD, IPC, protorec.int);       44: ;       	{Return any error} 	 ierr := error;  {Leave critical before we return control to caller}   DS_InitLeaveCritical ( tcp_wkmap );       END; { init }   END   .  