 $PASCAL ' 91790-1X211 REV.4010 <851217.0814> '      $ TITLE 'NS String Routines '$  $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 0  $   $ DEBUG $   $ CODE_INFO ON $      MODULE StrRout;   	$ALIAS 'N$StrRout' 	     {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: StrRout 
 {    SOURCE: 91790-18211  	{     RELOC: NONE  	 {      PGMR: EMS  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {  This module contains general purpose routines that Parser  {  and FileMan need.   Currently these routines are:  {     Upshift a string  {     Convert a string to a 16-bit Integer  {   {}          IMPORT         { basic memory manager declarations }  $ SEARCH 'phtm/bodec.rel' $      bodec,          { basic initialization declarations. }   $ SEARCH 'phtm/init_dec.rel' $     init_dec;      $ SUBTITLE 'Exported Routines ', PAGE $       EXPORT      PROCEDURE ExtractString     (VAR input_string: String;     VAR lastpos:      Int16;      VAR stringtocheck:String;     VAR parsedstring: String;     VAR passed_result:Int16);  &{ Extract a number from input_string.  Check that it is within the range. }  &     PROCEDURE ExtractNumber     (VAR input_string: String;     VAR lastpos:      Int16;          hi_value:     Int16;          lo_value:     Int16;      VAR parsednumber: Int16;      VAR passed_result:Int16);  ${ Extract a string from input_string.  Check that it is parsedstring. }  $     IMPLEMENT   { Module StrRout }      CONST      INVALIDSTRING = -333;  
   NOTFOUND = -331;  
    OUTOFRANGE = -332;      INT16LEN = 5;      	$ FIXED_STRING ON  	 PROCEDURE PutInCommas      ( VAR stringa: String );      EXTERNAL;  	$ FIXED_STRING OFF 	 #   { RTE-A routine : changes token delimiters from spaces to commas }  #     $ SUBTITLE 'ExtractString', PAGE $  {------------------------------------------------------------}  {                                                            }  {                    ExtractString                           }  {                                                            }  {------------------------------------------------------------}      PROCEDURE ExtractString     (VAR input_string: String;     VAR lastpos:      Int16;      VAR stringtocheck:String;     VAR parsedstring: String;     VAR passed_result:Int16);          VAR      len:           Int16;     next:          Int16;     tempstring:    IStringType;      
   BEGIN { ExtractString } 
 
   passed_result := GOOD;  
    parsedstring := '';  
   tempstring := ''; 
        { fix string position if it's wierd. }      IF lastpos < 0 THEN lastpos := 0;         IF lastpos = 0 THEN        BEGIN    { new string }              { This is the first time we've extracted from this string.   !      Set it up properly.                                       }  !           PutInCommas( input_string );        input_string := Strrtrim( input_string );             IF input_string = '' THEN            BEGIN    { no string }            passed_result := ERREND_STR;            END      { no string }           ELSE           BEGIN    { fix lastpos }            lastpos := 1;           END;     { fix lastpos }         END;     { new string }          IF lastpos > Strlen( input_string ) THEN         BEGIN    { past end-of-string }         passed_result := ERREND_STR;        END;     { past end-of-string }          IF passed_result = GOOD THEN         BEGIN    { continue extraction }            { get ending position of string }         next := Strpos( input_string, ',' );        IF next > 0 THEN           BEGIN    { have end of token }            { set token for strwrite }            input_string[next] := ' ';            END      { have end of token }           ELSE           BEGIN    { assume token is till end-of-string }           next := Strlen( input_string ) +1;            END;     { assume token is till end-of-string }            { save string for caller }  #      Strmove( next-lastpos, input_string, lastpos, parsedstring, 1 ); #           { update the lastpos }  
      lastpos := next + 1; 
     !      { This test works because putincommas puts all blanks in the ! $         string at the end of the string.                             }  $       IF parsedstring = '' THEN            BEGIN    { null parsed string }           passed_result := ERRNULLSTR;            END      { null parsed string }          ELSE           IF stringtocheck <> '' THEN              BEGIN    { check string matches stringtocheck }       "            IF Strlen( parsedstring ) < Strlen( stringtocheck ) THEN "                   len := Strlen( parsedstring )                    ELSE                     len := Strlen( stringtocheck );                   tempstring := Str( parsedstring, 1, len );              IF tempstring <> stringtocheck THEN                  BEGIN    { invalid string }                 passed_result := INVALIDSTRING;                 END;     { invalid string }                  END;     { check string matches stringtocheck }         END;     { continue extraction }  
   END;  { ExtractString } 
     $ SUBTITLE 'ExtractNumber', PAGE $  {------------------------------------------------------------}  {                                                            }  {                    ExtractNumber                           }  {                                                            }  {------------------------------------------------------------}      PROCEDURE ExtractNumber     (VAR input_string: String;     VAR lastpos:      Int16;          hi_value:     Int16;          lo_value:     Int16;      VAR parsednumber: Int16;      VAR passed_result:Int16);  ${ Extract a string from input_string.  Check that it is parsedstring. }  $     VAR      stringtocheck:    OneCharType;      dummy:            Int16;      internal_result:  Int16;      numberasstring:   IStringType;          BEGIN    { ExtractNumber }      internal_result := GOOD;          stringtocheck := '';   $   ExtractString( input_string, lastpos, stringtocheck, numberasstring,  $          internal_result );      IF internal_result = GOOD THEN         BEGIN    { convert ascii to numeric }         IF Strlen( numberasstring ) > INT16LEN THEN            BEGIN    { number too big }           internal_result := INVALIDINT;            END      { number too big }          ELSE           BEGIN    { continue checking }                converting := TRUE;           Strread( numberasstring, 1, dummy, parsednumber );            converting := FALSE;   
         IF hiterror THEN  
             BEGIN    { string not a number }              hiterror := FALSE;              internal_result := INVALIDINT;              END      { string not a number }             ELSE               BEGIN    { check all chars converted }  "            { Strread only converts as many characters as are valid. " &              Make sure all characters in the ascii string were converted. } &             IF dummy < Strlen( numberasstring ) +1 THEN                  BEGIN    { all chars not numeric }                      internal_result := INVALIDINT;                  END;     { all chars not numeric }               END;     { check all chars converted }           END;     { continue checking }         END;     { convert ascii to numeric }          IF internal_result = GOOD THEN         BEGIN    { check the range }        IF NOT (( parsednumber <= hi_value ) AND                ( parsednumber >= lo_value )) THEN           BEGIN    { number not in range }            internal_result := OUTOFRANGE;            END;     { number not in range }         END;     { check the range }         passed_result := internal_result;         END;     { ExtractNumber }       END        { module StrRout }   .  