 $PASCAL ',7 91790-1X125 REV.4010 <860313.1238> '  $STANDARD_LEVEL 'HP1000'  $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	     MODULE Moninit;   	$ALIAS 'N$MONINIT' 	     {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {     NAME:   MONINIT   
{     SOURCE: 91790-18125  
 	{     RELOC:  NONE 	 	{     PGMR:   EMS  	 {}  {}      {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {  860225 lms   Enhance init/shutdown error handling (n356).  {  860305 lms   Correct part number (n365).   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {   {     This module contains the monitor code for NSINIT.   {   {}      $ PAGE $      IMPORT  $SEARCH 'phtm/bodec.rel'     bodec,   
$SEARCH 'phtm/mmdec.rel' $ 
    mmdec,   
$SEARCH 'phtm/mmext.rel' $ 
    ds_mm,   $SEARCH 'phtm/init_dec.rel'      init_dec,  $SEARCH 'phtm/initmulti.xpt'     initmulti,   
$SEARCH 'phtm/parsdd.xpt'  
    parser,  
$SEARCH 'phtm/filemad.xpt' 
    fileman,   $SEARCH 'phtm/SODEC.REL'     sodec,   
$SEARCH 'phtm/TRCMOD.REL'  
    trcmod,  
$SEARCH 'phtm/SIGMOD.REL'  
    sigmod,  $SEARCH 'phtm/LKLB.REL'      lk,  
$SEARCH 'phtm/TMRDEC.REL'  
    tmrdec,  $SEARCH 'phtm/TCPGB.REL'     tg,  $SEARCH 'phtm/TUSER.REL'     tuser,   $SEARCH 'phtm/IPDEC.REL,phtm/IPLIB.REL,phtm/IPDB.REL'      iplib,   $SEARCH 'phtm/IPPATH.REL,phtm/IPPCTL.REL,phtm/IPACTP.REL'      ippath,  $SEARCH 'phtm/TCPLB.REL'     tl,  $SEARCH 'phtm/PXPLB.REL'     px,  $SEARCH 'phtm/sreglib.xpt, phtm/lan8.xpt'      sreglib,   
$SEARCH 'phtm/dres.xpt' $  
    dres,  $SEARCH 'phtm/init_rte_if.xpt' $     init_rte_if;           $SUBTITLE ' Export procedures ', PAGE$      EXPORT      {--------------------------------------------------------}  {                                                        }  {          EXPORT   PROCEDURES                           }  {                                                        }  {--------------------------------------------------------}          PROCEDURE SynMon     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);           	PROCEDURE ShutMon  	    (    trustvar    : TrustType;      VAR result      : Int16);           	PROCEDURE InitMon  	    (VAR result : Int16);          {----------------------------------------------------}  {               Implement Section                    }  {----------------------------------------------------}      IMPLEMENT       CONST      ABORTIFNOTPRESENT = TRUE;     DS_AS_INT         = 17491;          EXECTIMESCHED = 12;     TIMEINSECONDS = 2;       VAR      a_reg:         Int16OrCharType;     b_reg:         Int16OrCharType;  $   dummy:      Int16;      { used for strwrite return parm and as a 0 }  $    inproclass:    Int16;     outproclass:   Int16;     message:       IStringType;      PROCEDURE ABReg   	$ HEAPPARMS OFF $  	 (VAR a_reg:    Int16;    VAR b_reg:    Int16 );   $ HEAPPARMS ON $     EXTERNAL;      PROCEDURE RTEClassAccess                   $ ALIAS 'CLRQ' $   $ NOABORT $   
  (    fncode:      Int16; 
 
   VAR classnumber: Int16; 
        parm1:       Int16 );     EXTERNAL;      PROCEDURE Pgmad   	$ HEAPPARMS OFF $  	 (    nametocheck:    PNameType );   $ HEAPPARMS ON $     EXTERNAL;      PROCEDURE Exec  	$ HEAPPARMS OFF $  	 $ NOABORT $   (    icode:          Int16;        progname:       PNameType;        units:          Int16;        howoften:       Int16;        whentostart:    Int16 );   $ HEAPPARMS ON $     EXTERNAL;      $SUBTITLE 'SynMon',PAGE$  {-------------------------------------------}   {              SynMon                       }   {-------------------------------------------}       PROCEDURE SynMon     (VAR smbsize     : Int16;      VAR dsamtbsize  : Int16;      VAR socketcnt   : Int16;      VAR classcnt    : Int16;      VAR rsncnt      : Int16;      VAR result      : Int16);       BEGIN { SynMon}       { no questions to ask }       { need class numbers for inpro and outpro }   classcnt := 2;      
{ need one RN for outpro } 
 rsncnt := 1;      { If we need queue we also need qclm, which takes 1 class }   IF initglobals.IG_need_queue THEN classcnt := classcnt +1;          END;  { SynMon }          
$SUBTITLE 'ShutMon', PAGE$ 
 {-------------------------------------------}   {              ShutMon                    }   {-------------------------------------------}       	PROCEDURE ShutMon  	    (    trustvar    : TrustType;      VAR result      : Int16);       LABEL      99;      VAR      ierr:       Int16;      wkmap:      Int16;       BEGIN {shutdown}  ierr := GOOD;   result := GOOD;       { need to shut down UPLIN }   DS_StopMonitor( 'UPLIN', ierr );  	{ ignore errors }  	     { also stop INPRO and OUTPRO }  DS_StopMonitor( 'INPRO', ierr );  	{ ignore errors }  	     DS_StopMonitor( 'OUTPRO', ierr );   	{ ignore errors }  	     DS_StopMonitor( 'QCLM ', ierr );  DS_RetClass( NSINIT_AdrOf( Lb_QCLM ), 0, ierr );      !{ Stop MATIC so it won't get into the tables and find a problem }  ! DS_StopMonitor( 'MATIC ', ierr );       IF trustvar = TRUST THEN     BEGIN    { get the class numbers from DSAM }      dummy := 0;         DS_InitEnterCritical( wkmap, ierr );      IF ierr <> GOOD THEN         BEGIN    { error }        result := CANT_ENTER_CRIT;        GOTO 99;        END;     { error }         DS_FetchGlobal( DS_Inpro_Class, 1, inproclass );      DS_StoreGlobal( DS_Inpro_Class, 1, dummy );         DS_FetchGlobal( DS_Outpro_Class, 1, outproclass );      DS_StoreGlobal( DS_Outpro_Class, 1, dummy );          DS_InitLeaveCritical( wkmap );          RTEClassAccess( DEALLOCCLASS + CL_NO_WAIT + CL_NO_ABORT,                                                    inproclass, 0 );         BEGIN    { clrq error }         { ignore errors }         END;     { clrq error }          RTEClassAccess( DEALLOCCLASS + CL_NO_WAIT + CL_NO_ABORT,   !                                                outproclass, 0 );  !       BEGIN    { clrq error }         { ignore errors }         END;     { clrq error }          { clear inpro's class number in RES.  Note that although         Inpro is placed in the slave monitor list it is not a true          slave monitor for DS/1000-IV so the class number allocation   !     and scheduling are handled here instead of in init_streams. } !     !   DS_StoreResElement( NSINIT_AdrOf( Lb_ST13 ), CLASSOFFSET, 0 );  !        END      { get the class numbers from DSAM }     ELSE     BEGIN    { get inpro's class from RES }          DS_RetClass( NSINIT_AdrOf( Lb_ST13 ), CLASSOFFSET, result );    
   { ignore errors } 
    END;     { get inpro's class from RES }      99:       { always move zeros over inpro's name in res }  DS_MoveCharsToRes( NSINIT_AdrOf( Lb_ST13 ), NAMEOFFSET,             PNAMEZEROED.PNAsCharType, PNAMELEN DIV 2 );       	END;  { ShutMon }  	         
$SUBTITLE 'InitMon', PAGE$ 
 {------------------------------------------------------------}  {                 InitMon                                    }  {------------------------------------------------------------}      	PROCEDURE InitMon  	    (VAR result:       Int16);       LABEL      99;      VAR      ierr:       Int16;      wkmap:      Int16;       $ SUBTITLE 'ScheduleQclm', PAGE $   PROCEDURE ScheduleQCLM     ( VAR result:     Int16 );   LABEL      89;      VAR      classnum:      Int16;         BEGIN    { ScheduleQCLM }      
   { Get the class } 
    DS_GetClass( NSINIT_AdrOf( Lb_QCLM), 0,  #                       SAVECLASSNUMBIT + CL_NO_WAIT, classnum, ierr ); #    IF ierr <> GOOD THEN GOTO 89;         { Schedule the monitor }      DS_StartMonitor( 'QCLM ', classnum, TRUE, ierr );     IF ierr = NOTDORMANT THEN GOTO 89;      IF ierr <> GOOD THEN         BEGIN    { scheduling error }             result := GOOD;         PrintError( NO_REQ_MONMSG, result );        { hand any errors back to the caller }        END;     { scheduling error }       89:      END;     { ScheduleQCLM }      	BEGIN { InitMon }  	     result := GOOD;           { If we have router/bisync/gwy: verify that QUEUE is present.      Also need QCLM if we have QUEUE.                            }    IF initglobals.IG_need_queue THEN      BEGIN    { check for queue }          DS_CheckIDSeg( 'QUEUE', ABORTIFNOTPRESENT, result );   
   IF result <> GOOD THEN  
       BEGIN    { must abort }          { already printed error message, tell main not to print }          result := ERR_ALREADY_PRINTED;        GOTO 99;        END;     { must abort }       
   ScheduleQCLM( result ); 
    IF result <> GOOD THEN GOTO 99;     END;     { check for queue }       { If we have lan (IEEE-802): verify that READ1 is present }   IF initglobals.IG_have_IEEE802 THEN      BEGIN    { Check for readr }          { Note that readr's name is READ1 when it is RPd. }     DS_CheckIDSeg( 'READ1 ', ABORTIFNOTPRESENT, result );  
   IF result <> GOOD THEN  
       BEGIN    { must abort }          { already printed error message, tell main not to print }          result := ERR_ALREADY_PRINTED;        GOTO 99;        END;     { must abort }      END;     { Check for readr }       { Now initialize the path report templates.  This is done here     to make sure all protocols have built their paths.           }   
SregIpcTemplates( ierr );  
 
IF ierr <> GOOD THEN 
    BEGIN    { template error }     MsgFilePrint( SREGIPCTEMPLERR, PMT_ERROR, ierr, result );     { ignore any error messages printing }      result := ERR_ALREADY_PRINTED;      GOTO 99;      END;     { template error }      { get inpro a class number and put it in RES }  &DS_GetClass( NSINIT_AdrOf( Lb_ST13 ), CLASSOFFSET, 0, inproclass, result );  & IF result <> GOOD THEN GOTO 99;       { get outpro a class number }   RTEClassAccess( ALLOCCLASS + CL_NO_ABORT + CL_NO_WAIT,                                                 outproclass, 0 );    
   BEGIN    { clrq error } 
    ABReg( a_reg.IIorCType, b_reg.IIorCType );   $   Strwrite( message, 1, dummy, '** (203) NS: Error ', a_reg.CIorCType,  $      b_reg.CIorCType,       ' allocating class number (CLRQ).**' );      PrintError( message, result );      result := ERR_ALREADY_PRINTED;      GOTO 99;   
   END;     { clrq error } 
     { go critical to save the classes }   DS_InitEnterCritical( wkmap, ierr );  
IF ierr <> GOOD THEN 
    BEGIN    { error }      DS_InitLeaveCritical( wkmap );   	   result := ierr; 	    GOTO 99;      END;     { error }       
{ save the class numbers } 
 DS_StoreGlobal( DS_Inpro_Class, 1, inproclass );  DS_StoreGlobal( DS_Outpro_Class, 1, outproclass );      DS_InitLeaveCritical( wkmap );      { move the name 'INPRO' into the slave stream list in res }   DS_MoveCharsToRes( NSINIT_AdrOf( Lb_ST13 ), NAMEOFFSET,                         'INPRO' , PNAMELEN DIV 2 );       
{ start up outpro }  
 DS_StartMonitor( 'OUTPRO', outproclass, TRUE, result );   IF result = NOTDORMANT THEN GOTO 99;  IF result <> GOOD THEN  
   BEGIN    { no OUTPRO }  
        { outpro is a required monitor.  Abort }      PrintError( NO_REQ_MON_ABORTMSG, result );          result := ERR_ALREADY_PRINTED;      GOTO 99;       
   END;     { no OUTPRO }  
     	{ start up inpro } 	 DS_StartMonitor( 'INPRO', inproclass, TRUE, result );   IF result = NOTDORMANT THEN GOTO 99;  IF result <> GOOD THEN     BEGIN    { no INPRO }         { inpro is a required monitor.  Abort }     PrintError( NO_REQ_MON_ABORTMSG, result );          result := ERR_ALREADY_PRINTED;      GOTO 99;          END;     { no INPRO }      !  { start UPLIN, it will do it's environment check, waiting for NS ! #    to be ready for UPLIN to run.                                   }  #    DS_StartMonitor( 'UPLIN ', DS_AS_INT, TRUE, result );     IF result = NOTDORMANT THEN GOTO 99;   
   IF result <> GOOD THEN  
       BEGIN    { error starting uplin }         PrintError( NO_REQ_MON_ABORTMSG, result );            result := ERR_ALREADY_PRINTED;        END;     { error starting uplin }           99:       
END;     { InitMon } 
 END   .  