 $PASCAL '91790-1X086 REV.4010 <860327.1310> '   $STANDARD_LEVEL 'HP1000'  $debug$   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	     
MODULE init_rte_if;  
 $ALIAS 'N$init_rte_if'      {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  
{     NAME:   INIT_RTE_IF  
 
{     SOURCE: 91790-18086  
 	{     RELOC:  NONE 	 	{     PGMR:   EMS  	 {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {   Date      Prgmr  Description   {  2/28/86     lms   Initialized ierr in DS_StopMonitor (n356).    {  3/12/86     lms   Set nosuspendbit and print error messages  !{                        in Disconnect_LU.  Add HandleAbortReturn  ! {                        abd CheckXLUEXCall (n370).   {}      {}  {  This module contains interface routines to RTE subroutines   {  for NSINIT, the NS/1000 initialization program.  {   {}      IMPORT  
$SEARCH 'phtm/bodec.rel'$  
    bodec,       $SEARCH 'phtm/init_dec.rel'$     init_dec,      
$SEARCH 'phtm/dres.xpt' $  
    dres,  $SEARCH 'phtm/initmulti.xpt'$      initmulti,   $SEARCH 'phtm/filemad.xpt'$      fileman,   $SEARCH 'phtm/parsdd.xpt' $      parser;      $ SUBTITLE 'Export' $   EXPORT  CONST   %   NO_REQ_MONMSG = '** (200) NS: WARNING: Required monitor not found. **'; %    NO_REQ_MON_ABORTMSG =  #  '** (201) NSINIT: ERROR: Necessary monitor not found. Aborting. **'; #    MON_ACTIVE_ABORTMSG =  %  '** (211) NSINIT: ERROR: Desired monitor already active.  Aborting. **'; %        EXEC_NO_WAIT = BIT14;      PROCEDURE CheckXLUEXCall   (     areg:            Int16OrCharType;         breg:            Int16OrCharType;         lu:              Int16;         dvr_errstring:   IStringType;     VAR ierr:            Int16 );  $ { check a and b registers for errors in XLUEX call from RTE & driver }  $ $ { Print an error message for an RTE error.  If dvr_errstring <> ''   }  $ $ { and there is a driver error, print that error.  Set ierr to a      }  $ $ { value NSINIT can understand if there is an error.                  }  $     PROCEDURE Disconnect_Lu   
   (    lu_number : Int16; 
     VAR result    : Int16);   "{ Disconnect a driver 66 LU, print an error if there is a problem. } "     PROCEDURE DS_CheckIDSeg   (     progname:      PNameType;         fatalerrflag:  Boolean;   
  VAR ierr:       Int16 ); 
 ${ See if the program name's ID segment exists, print error information } $ ${ Used during initialization for programs that are not started but     } $ ${ whose ID segments need to be there, like TIMER, QUEUE, and READ1.    } $     PROCEDURE DS_GetClass   
   (     ResAccess: Int16; 
          resoffset:     Int16;           classwdflags:  Int16;       VAR classnum:      Int16;       VAR result:        Int16 );  &{ Get a class number and put it in RES, at the location ResAccess+offset. }  & &{ Print an error indication if class cannot be allocated, set result <> 0.}  &     PROCEDURE DS_RetClass   
   (     ResAccess: Int16; 
          resoffset:     Int16;       VAR result:        Int16 );  ${ Return a class number and clear the location ResAccess+offset in RES } $     	PROCEDURE DS_GetRN 	 
   (     ResAccess: Int16; 
          resoffset:     Int16;       VAR rn:            Int16;       VAR result:        Int16 );  &{ Get a resource number and put it in RES at the location resAccess+offset.} & &{ Print error indication if cannot allocate an RN, set result <> 0         } &     	PROCEDURE DS_RetRN 	 
   (     ResAccess: Int16; 
          resoffset:     Int16;       VAR result:        Int16 );  &{ Return a resource number and clear the res location ResAccess+resoffset }  &     
PROCEDURE DS_StartMonitor  
  (     monitorname:     PNameType;         parm1:           Int16;         printerrorflag:  Boolean;     VAR ierr:            Int16 );  ${ Start a program, hand it parm1.  Print error indication if          }  $ ${ printerrorflag= TRUE.  Hand error indication back to caller if any. }  $     PROCEDURE DS_StopMonitor   (     monitorname:     PNameType;     VAR ierr:            Int16 );  ${ Stop a monitor by calling MESSS.  No error is possible on this call }  $     PROCEDURE HandleAbortReturn    (     areg:    Int16OrCharType;         breg:    Int16OrCharType;     VAR lu:      Int16;     VAR ierr:    Int16 );  %{ Print error message, hit abort return for XLUEX call.  The caller has }  % %{ called abreg, print the error message by concatenating A & B as chars }  % %{ into the error string, adding the LU passed by the caller.  Set ierr  }  % %{ to a value NSINIT understands: HAR_XLUEXABORT.                        }  %         $ SUBTITLE 'Implement', PAGE $  IMPLEMENT       CONST      NOIDSEGMSG1 = '** (202) NS: Error- No ID Segment for ';     NOIDSEGMSG2 = ' (PGMAD).**';       TYPE     ControlWordType = PACKED ARRAY [1..2] OF Int16;     XluexErr_IndType = PACKED RECORD   
      upperbyte:     Byte; 
       driver_error:  PosInt4;         nop_bit1:      Boolean;         nop_bit2:      Boolean;         dvr_err_bit:   Boolean;         rte_err_bit:   Boolean;         END;         RegType = RECORD CASE Int16 OF            1: (RT_int:    Int16);            2: (RT_chars:  Packed Array[1..2] OF Char);           3: (RT_errind: XluexErr_indType);        END;          VAR      a_reg   :   Int16OrCharType;      b_reg   :   Int16OrCharType;      message :   IStringType;       PROCEDURE ABReg      ( VAR a_reg:   Int16;  
     VAR b_reg:   Int16 ); 
    EXTERNAL;     { get the A and B registers for errors on RTE calls }      PROCEDURE Messs      ( VAR buffer:  PCharType;  
         buflen:  Int16 ); 
    EXTERNAL;      PROCEDURE Pgmad   (    nametocheck:    PNameType );      EXTERNAL;      PROCEDURE RTEClassAccess                   $ ALIAS 'CLRQ' $   $ NOABORT $   
  (    fncode:      Int16; 
 
   VAR classnumber: Int16; 
        parm1:       Int16 );     EXTERNAL;      PROCEDURE RteRNAccess                      $ ALIAS 'RNRQ' $   $ NOABORT $   
  (    fncode:      Int16; 
 
   VAR rn:          Int16; 
    VAR statretn:    Int16 );     EXTERNAL;      PROCEDURE Xluex   $ NOABORT $     (    ecode : Int16;          cntwd : ControlWordType);     EXTERNAL;      FUNCTION IAND   $ DIRECT $  (  firstint:      Int16;     secondint:     Int16 ): Int16;      EXTERNAL;      FUNCTION IOR  $ DIRECT $  (  firstint:      Int16;     secondint:     Int16 ): Int16;      EXTERNAL;      PROCEDURE  ExecSchedule               $ ALIAS 'EXEC' $  $ NOABORT $   
  (    typeofsched: Int16; 
        monitorname: PNameType;  
       parm1:       Int16; 
 
       parm2:       Int16; 
 
       parm3:       Int16; 
 
       parm4:       Int16; 
        parm5:       Int16 );     EXTERNAL;      $ SUBTITLE 'CheckXLUEXCall', PAGE $   PROCEDURE CheckXLUEXCall   (     areg:            Int16OrCharType;         breg:            Int16OrCharType;         lu:              Int16;         dvr_errstring:   IStringType;     VAR ierr:            Int16 );      $ { check a and b registers for errors in XLUEX call from RTE & driver }  $ $ { Print an error message for an RTE error.  If dvr_errstring <> ''   }  $ $ { and there is a driver error, print that error.  Set ierr to a      }  $ $ { value NSINIT can understand if there is an error.                  }  $     VAR      c_error:          Int16;      xluex_return:     RegType;      errstring:        IStringType;          BEGIN    { CheckXLUEXCall }     xluex_return.RT_int := areg.IIOrCType;   
   errstring := '';  
    ierr := GOOD;         IF xluex_return.RT_errind.rte_err_bit THEN         BEGIN    { RTE error }            Strwrite( errstring, 1, c_error,  #           '** (518) NSINIT: RTE error indication on XLUEX call. ' );  #           { set error return for caller }         ierr := CXC_RTEERROR;         END      { RTE error }       ELSE IF xluex_return.RT_errind.dvr_err_bit THEN           BEGIN    { driver error }           IF dvr_errstring <> '' THEN              BEGIN    { report driver error }              { caller wants this error reported }              Strwrite( errstring, 1, c_error, dvr_errstring,   "                      xluex_return.RT_errind.driver_error:1, '. ' ); "             { set error return for caller }               ierr := CXC_DVRERROR;               END;     { report driver error }           END;     { driver error }         IF Strlen( errstring ) <> 0 THEN         BEGIN    { have error to print }        { always append the LU to the error string }        Strwrite( errstring, Strlen( errstring ) +1, c_error,                  'LU is:', lu:1, ' (XLUEX) **' );             PrintError( errstring, c_error );         { return error indication to caller, if any }         END;     { have error to print }         END;     { CheckXLUEXCall }          $ SUBTITLE 'DS_CheckIDSeg', PAGE $  PROCEDURE DS_CheckIDSeg   (     progname:      PNameType;         fatalerrflag:  Boolean;   
  VAR ierr:       Int16 ); 
 ${ See if the program name's ID segment exists, print error information } $ ${ Used during initialization for programs that are not started but     } $ ${ whose ID segments need to be there, like TIMER, QUEUE, and READ1.    } $         LABEL      99;      VAR      dummy:         Int16;     result:        Int16;         BEGIN    { DS_CheckIDSeg }   	   result := GOOD; 	        { Verify that the program is present in the system }      Pgmad( progname );      ABReg( a_reg.IIOrCType, b_reg.IIorCType );      IF a_reg.IIOrCType = 0 THEN        BEGIN    { no program }   
      message := ''; 
     $      Strwrite( message, 1, dummy, NOIDSEGMSG1, progname, NOIDSEGMSG2 ); $       PrintError( message, result );        IF result <> GOOD THEN GOTO 99;             IF fatalerrflag THEN message := NO_REQ_MON_ABORTMSG        ELSE message := NO_REQ_MONMSG;             { warn him that it is a required monitor }        PrintError( message, result );        IF result <> GOOD THEN GOTO 99;       
      result := NOTSCHED;  
       END;     { no program }   99:   	   ierr := result; 	        END;     { DS_CheckIDSeg }       $ SUBTITLE 'DS_GetClass', PAGE $  PROCEDURE DS_GetClass   
   (     ResAccess: Int16; 
          resoffset:     Int16;           classwdflags:  Int16;       VAR classnum:      Int16;       VAR result:        Int16 );      &{ Get a class number and put it in RES, at the location ResAccess+offset. }  & &{ Print an error indication if class cannot be allocated, set result <> 0.}  &     VAR     dummy: int16;      { used only for strwrite output }         BEGIN    { DS_GetClass }          result := 0;   	   classnum := 0;  	 	   message := '';  	        RTEClassAccess( ALLOCCLASS + CL_NO_ABORT + CL_NO_WAIT,                                                   classnum, 0 );        BEGIN    { error }            ABReg( a_reg.IIorCType, b_reg.IIorCType );  %      Strwrite( message, 1, dummy, '** (203) NS: Error ', a_reg.CIorCType, %         b_reg.CIorCType,         ' allocating class number (CLRQ).**' );        PrintError( message, result );        { ignore errors }             result := NOCLASS;        END;     { error }         IF result = 0 THEN         BEGIN    { save number }            { clear bits 12-15 in the class word }        classnum := IAND( classnum, CLEAR12To15 );            { OR in the flag bits the caller desires. }         classnum := IOR( classnum, classwdflags );            DS_StoreResElement( ResAccess, resoffset, classnum );         END;     { save number }         END;     { DS_GetClass }       $SUBTITLE 'DS_ReturnClass', PAGE $  PROCEDURE DS_RetClass   
   (     ResAccess: Int16; 
          resoffset:     Int16;       VAR result:        Int16 );      ${ Return a class number and clear the location ResAccess+offset in RES } $     VAR      classnum:      Int16;     dummy:         Int16;         BEGIN    { DS_ReturnClass }         result := 0;          { get the classnumber that the caller wants to deallocate }     DS_GetResElement( ResAccess, resoffset, classnum );     IF classnum <> 0 THEN        BEGIN    { do deallocation }            { clear the res entry point that had the class number }         DS_StoreResElement( ResAccess, resoffset, 0 );      
      message := ''; 
           RteClassAccess( DEALLOCCLASS + CL_NO_WAIT + CL_NO_ABORT,  !                                                    classnum, 0 ); !          BEGIN    { error }            ABReg( a_reg.IIorCType, b_reg.IIorCType );   '         Strwrite( message, 1, dummy, '** (204) NS: Error ', a_reg.CIorCType,  '           b_reg.CIorCType, ' deallocating class number ',             classnum:1, ' (CLRQ). **' );               PrintError( message, result );   
         { ignore errors } 
              result := CLASSDEALLERROR;            END;     { error }         END;     { do deallocation }     END;     { DS_ReturnClass }      $SUBTITLE 'DS_GetRN', PAGE $  	PROCEDURE DS_GetRN 	 
   (     ResAccess: Int16; 
          resoffset:     Int16;       VAR rn:            Int16;       VAR result:        Int16 );      &{ Get a resource number and put it in RES at the location resAccess+offset.} & &{ Print error indication if cannot allocate an RN, set result <> 0         } & VAR      dummy:      Int16;      statreturn: Int16;          BEGIN    { DS_GetRN }         result := 0;   	   message := '';  	        RteRNAccess( ALLOCRNGLOBALLY + LOCLOCK + RN_NO_ABORT,  "                                                  rn, statreturn );  "       BEGIN    { error }            ABReg( a_reg.IIorCType, b_reg.IIorCType );  %      Strwrite( message, 1, dummy, '** (205) NS: Error ', a_reg.CIorCType, %         b_reg.CIorCType,         ' allocating resource number (RNRQ).**' );             PrintError( message, result );        { ignore errors }             result := NORN;         END;     { error }         IF result = 0 THEN         BEGIN    { save number }        IF statreturn = SUCCESSRNLOCLOCK  THEN           BEGIN    { have rn, & it's locked }           DS_StoreResElement( ResAccess, resoffset, rn );           END      { have rn, & it's locked }          ELSE           BEGIN    { rn lock error }   $         Strwrite( message, 1, dummy, '** (206) NS: Error locking rn. ', $ !            'Status returned was: ', statreturn:1, ' (RNRQ).**' ); !              PrintError( message, result );   
         { ignore errors } 
              { try deallocating this rn, but ignore errors }           IF rn <> 0 THEN              BEGIN    { do dealloc }               RteRNAccess( DEALLOCRN + RN_NO_WAIT + RN_NO_ABORT,  !                                                 rn, statreturn ); !                BEGIN    { dealloc error }                  END;     { dealloc error }               END;     { do dealloc }       
         result := RNERR;  
          END;     { rn lock error }         END;     { save number }     END;     { DS_GetRN }      $SUBTITLE 'DS_ReturnRN', PAGE $   	PROCEDURE DS_RetRN 	 
   (     ResAccess: Int16; 
          resoffset:     Int16;       VAR result:        Int16 );      &{ Return a resource number and clear the res location ResAccess+resoffset }  &     VAR      dummy:      Int16;      rn:         Int16;      statreturn: Int16;          BEGIN    { DS_ReturnRN }          result := 0;       !   { get the resource number that the caller wants to deallocate } !    DS_GetResElement( ResAccess, resoffset, rn );  	   IF rn <> 0 THEN 	       BEGIN    { do deallocation }            { clear the res entry point that had the rn }         DS_StoreResElement( ResAccess, resoffset, 0 );      
      message := ''; 
           RteRNAccess( DEALLOCRN + RN_NO_WAIT + RN_NO_ABORT,  !                                                 rn, statreturn ); !          BEGIN    { error }            ABReg( a_reg.IIorCType, b_reg.IIorCType );            Strwrite( message, 1, dummy, '** (207) NS: Error ',             a_reg.CIOrCType, b_reg.CIorCType,  !          ' deallocating resource number ', rn:1, ' (RNRQ). **' ); !              PrintError( message, result );   
         { ignore errors } 
              result := RNDEALLERROR;           END;     { error }             IF result = GOOD THEN            BEGIN    { check status return }            IF statreturn <> SUCCESSRNDEALL THEN               BEGIN    { dealloc error }              Strwrite( message, 1, dummy,                 '** (208) NS: Error Deallocating ',                 'rn. Status returned was: ', statreturn:1,                  ' (RNRQ) . **' );                  PrintError( message, result );              { ignore errors }                   result := RNDEALLERRSTAT;               END;     { dealloc error }           END;     { check status return }         END;     { do deallocation }     END;     { DS_ReturnRN }       $ SUBTITLE 'DS_StartMonitor', PAGE $  
PROCEDURE DS_StartMonitor  
  (     monitorname:     PNameType;         parm1:           Int16;         printerrorflag:  Boolean;     VAR ierr:            Int16 );      ${ Start a program, hand it parm1.  Print error indication if          }  $ ${ printerrorflag= TRUE.  Hand error indication back to caller if any. }  $         VAR   	   dummy:  Int16;  	        BEGIN    { DS_StartMonitor }      ierr := 0;   	   message := '';  	     "   ExecSchedule( IMMEDIATE + EXEC_NO_WAIT + NOABORTBIT, monitorname, " 
      parm1, 0, 0, 0, 0 ); 
       BEGIN    { error }        ABReg( a_reg.IIorCType, b_reg.IIorCType );        IF printerrorflag THEN           BEGIN    { print error }            Strwrite( message, 1, dummy,               '** (209) NS: Error ', a_reg.CIorCType,   $            b_reg.CIorCType, ' scheduling ', monitorname, '(EXEC).**' ); $          PrintError( message, ierr );   
         { ignore errors } 
          END;     { print error }             ierr := NOTSCHED;         END;     { error }          { Get a & b registers before they change, use values only if          didn't hit no-abort return on exec call.                  }      ABReg( a_reg.IIorCType, b_reg.IIorCType );   
   IF ierr = 0 THEN  
       BEGIN    { Verify dormancy }            { Verify monitor was not already scheduled. }         IF a_reg.IIorCType <> 0 THEN           BEGIN    { wasn't dormant }           IF printerrorflag THEN               BEGIN    { print error }  
            message := ''; 
              Strwrite( message, 1, dummy, '** (210) NS: ERROR ',                   monitorname, ' not dormant. (EXEC). **' );               PrintError( message, ierr );              END;     { print error }               ierr := NOTDORMANT;           END;     { wasn't dormant }        END;     { Verify dormancy }     END;     { DS_StartMonitor }       $SUBTITLE 'DS_StopMonitor', PAGE $  PROCEDURE DS_StopMonitor   (     monitorname:     PNameType;     VAR ierr:            Int16 );      ${ Stop a monitor by calling MESSS.  No error is possible on this call }  $     CONST   	   OFBUFLEN = 12;  	    PNAMEPOS = 4;     IDSEGNAMELEN = PNAMELEN;   
   OFBUF = 'OF,      ,FL'; 
     VAR   
   messsbuf :  PCharType;  
        BEGIN    { DS_StopMonitor }     ierr := GOOD;      !   { Note that MESSS is used because EXEC only lets programs stop  ! #      child program execution.                                      }  #     $   { prepare the messs buffer ( it can get altered by the messs call ) } $    messsbuf := OFBUF;       !   { move the enough characters of the prog name the caller passed ! "      to match the ID segment into the messs buffer.               } "     Strmove( IDSEGNAMELEN, monitorname, 1, messsbuf, PNAMEPOS );           { OF the program, saving the ID segment }     Messs( messsbuf, OFBUFLEN );   
   { ignore errors } 
        END;     { DS_StopMonitor }      ${---------------------------------------------------------------------}  $ ${                      Disconnect_Lu                                  }  $ ${---------------------------------------------------------------------}  $ PROCEDURE Disconnect_Lu (    lu_number : Int16;                            VAR result    : Int16);  ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${ PURPOSE :                                                           }  $ ${   Issues a control 31 (dissconnect) request to the specified LU.    }  $ ${                                                                     }  $ ${ PRAMETERS :                                                         }  $ ${   lu_number     INPUT     LU number                                 }  $ ${   result        OUTPUT    error return                              }  $ ${                                                                     }  $ ${ ERROR HANDLING :                                                    }  $ ${   If the XLUEX call fails (takes the error return) the value in     }  $ ${   the A register is returned. No other errors are generated or      }  $ ${   returned.                                                         }  $ ${                                                                     }  $ ${ NOTES:                                                              }  $ ${   The format of the control word should be as follows for the XLUEX }  $ ${   call:                                                             }  $ ${                                                                     }  $ ${  15 14 13 12 11 10 9  8  7  6  5  4  3  2  1  0                     }  $ ${ |-----------------------------------------------|                   }  $ ${ |ov|os|    reserved     | logical unit #        |                   }  $ ${ |-----------------------------------------------|                   }  $ ${ |  misc.    | function (31B) |     reserved     |                   }  $ ${ |-----------------------------------------------|                   }  $ ${---------------------------------------------------------------------}  $     CONST       %   NO_ABORT_CONTROL = -32765; { = OCT 100003 = control with no-abort bit}  % #   CONTROL_31 = 1600;         { = OCT 3100 = 31B left shifted 6 bits } #     VAR      control_word : ControlWordType;         BEGIN { PROCEDURE Disconnect_Lu }     control_word[1] := lu_number;     control_word[2] := CONTROL_31;      result := 0;      XLUEX(NO_ABORT_CONTROL+NOSUSPENDBIT, control_word);        BEGIN { handling XLUEX error }            ABReg(a_reg.IIOrCType, b_reg.IIOrCType);        HandleAbortReturn( a_reg, b_reg, lu_number, result );         result := ERR_ALREADY_PRINTED;        END;  { handling XLUEX error }         { If LU went down because of this control request,   }      { that's ok. Don't attempt to print an error messge. }      END;  { PROCEDURE Disconnect_Lu }      $SUBTITLE 'HandleAbortReturn', PAGE $   PROCEDURE HandleAbortReturn    (     areg:    Int16OrCharType;         breg:    Int16OrCharType;     VAR lu:      Int16;     VAR ierr:    Int16 );  %{ Print error message, hit abort return for XLUEX call.  The caller has }  % %{ called abreg, print the error message by concatenating A & B as chars }  % %{ into the error string, adding the LU passed by the caller.  Set ierr  }  % %{ to a value NSINIT understands: HAR_XLUEXABORT.                        }  %         VAR      errstring:     IStringType;     npos:          Int16;         BEGIN    { HandleAbortReturn }   
   errstring := '';  
         Strwrite( errstring, 1, npos, '** (517) NSINIT: RTE error ',                     areg.CIOrCType, breg.CIOrCType,                   ' on XLUEX call.  LU is:', lu:1, '**' );          PrintError( errstring, ierr );       
   ierr := HAR_XLUEXABORT; 
    END;     { HandleAbortReturn }       END   { init_rte_if }   .  