 $PASCAL '91790-1X055 REV.4010 <860321.1739> '   $ TITLE 'NS File Initialization Module'$  $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 0  $   $ DEBUG $   $ CODE_INFO ON $      {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  
{      NAME: FileMan 
 {    SOURCE: 91790-18055  	{     RELOC: NONE  	 {      PGMR: EMS  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {  860210 lms   Do left trim on input lines (n314).   {   {------------------------------------------------------------   {}      {}  { Description:  !{     This module contains the file manipulation routines required ! {     by the NS initialization routines, including Parser, and  {     NSINIT, the main program.   {   ${  WARNING: ***********************************************************  $ {  The boolean filemaninit from Init_dec MUST be initialized  !{  to false prior to calling any routines in this module.  Failure !  {  to initialize the variable will cause unpredictable results.    {   "{  Furthermore, the Open routines MUST be called prior to attempting "  {  to use the related Write or Read routine.  Failure to do this   {  will also cause unpredictable results.   ${  *********************************************************END WARNING. $ {}  MODULE FileMan;   	$ALIAS 'N$FileMan' 	     $ SUBTITLE 'Import ', PAGE $          IMPORT         { memory manager declarations }  $SEARCH 'phtm/bodec.rel ' $      bodec,          { Global Declarations (mostly types ) }  $SEARCH 'phtm/init_dec.rel'$     Init_Dec,         { NS General Purpose routines }  $SEARCH 'phtm/Init_General.rel'$     Init_General;      $ SUBTITLE 'Export', PAGE $       EXPORT  
FUNCTION FileExists  
   (    filename:     FileNType;      VAR result:       Int16 ):  Boolean;      { see if a given filename exists }       FUNCTION FileInteractive    (    whichfile:    InputOrLogType): Boolean;     { Determine whether a given file (LU) is interactive }       PROCEDURE HandleDefFileName     (VAR filename:     FileNType;          name_base:    IStringType;      VAR result:       Int16 );   &   { If file name is "/D" make it name_base+number & see it doesn't exist }  &     
PROCEDURE OpenInput  
    (VAR result: Int16);   
   { Open the input file } 
     	PROCEDURE OpenLog  	    (VAR result: Int16);      { Open the log file }      
PROCEDURE OpenOutput 
    (VAR result: Int16);      { Open the output (answer) file }      
PROCEDURE PrintError 
   (    error_msg:    PromptType;     VAR result:       Int16 );   %   { Print caller's error on all devices; checking for duplicate prints }  %     (*  PROCEDURE ReadFromLog     (VAR input_string: String;     VAR result:       Int16);     { Get a line of input from the log device/file. }  *)      
PROCEDURE ReadInput  
   (VAR input_string: String;     VAR result:       Int16);     { Get a line of input from the input device/file. }      PROCEDURE SayOutputNeedsEdit;   $   { print "output file needs editing" on input, output, & log devices } $     (*  PROCEDURE SayUsingInputAgain;      { print "using input device for input" on log device.   }  *)      PROCEDURE WriteOnInput    (    write_string: PromptType;     VAR result:       Int16 );      { write string on input device }       
PROCEDURE WriteOnLog 
   (    write_string: PromptType;     VAR result:       Int16 );      { write string on log device }       PROCEDURE WriteOnOutput     (    write_string: PromptType;     VAR result:       Int16 );      { write string on output device }      $ SUBTITLE 'Implement', PAGE $  IMPLEMENT   { Module FileMan }      CONST      SHARED_NOCCTL = 'SHARED,NOCCTL';      SHARED = 'SHARED';       VAR          errormsg:         IStringType;   (*  &   firstlog_read:    Boolean;     { TRUE if have not read from log device }  & *)  '   first_read:       Boolean;     { TRUE if have not read from input device }  ' %   input_is_output:  Boolean;     { TRUE if input device = output device } %     '   inputf:           TEXT;        { input device used to read input         }  ' &   input_print:      TEXT;        { input device: used to print messages if  & '                                       input device is interactive          }  ' '   log:              TEXT;        { log device used to print messages       }  '     '   log_is_input:     Boolean;     { TRUE if log device = input device       }  ' '   log_is_output:    Boolean;     { TRUE if log device = output device      }  ' '   log_open:         Boolean;     { TRUE if log device is writeable         }  '     (*  '   log_read:         TEXT;        { log device used to read if input errors }  ' *)      '   output_open:      Boolean;     { TRUE if the output device is writeable  }  ' '   outputf:          TEXT;        { output device: used to print messages   }  '    read_string:      PCharType;       
PROCEDURE CheckDuplicates; 
    FORWARD;      { Check if log = input, log = output, and input = output }       PROCEDURE DoFilemanInit;     FORWARD;   !   { Initialize fileman's internal variables. See warning above }  !     FUNCTION FmpInteractive     (VAR dcb:    DcbType):   Int16;      EXTERNAL;  !   { Find out if a file associated with this DCB is interactive }  !      PROCEDURE GetDCBAddr                 $ ALIAS 'PAS.DCBADDRESS1' $     (VAR dcbp:    DcbPtr;      VAR afile:  TEXT );     EXTERNAL;     { Get an FMP dcb for a Pascal file }       PROCEDURE TestInputRead     (    read_string:     PCharType;     VAR input_string:    String;      VAR result:          Int16 );     FORWARD;       $ SUBTITLE 'CheckDuplicates', PAGE $  {------------------------------------------------------------}  {                                                            }  {                CheckDuplicates                             }  {                                                            }  {------------------------------------------------------------}  {  Purpose:  To check for duplicate file names and set  {     internal flags to stop printing messages on the same  {     device more than once.  {   
{   Input parameters: none 
 {   Output parameters: none   {   Global variables used, but not changed: none  {   Global variables changed:   {   %{      These variables have spaces trimmed, but are not otherwise altered. % {      from Init_Dec:    inputfile- name of input file  {                        logfile- name of log file  {                        outputfile- name of output file  {   {      These variables are initialized by CheckDuplicates   {      from FileMan:     log_is_input - input=log flag  {                        log_is_output - output=log flag  {   
{  SideEffect: none  
 
{  Routines called:  none  
 {  Called by:   {     OpenInput, OpenLog, and OpenOutput.   {   {}  
PROCEDURE CheckDuplicates; 
        BEGIN    { CheckDuplicates }          { test for duplicate file names }         IF initglobals.IG_logfile = initglobals.IG_inputfile THEN        BEGIN  { log file = input file }        log_is_input := TRUE;         END    { log file = input file }       ELSE         BEGIN  { log file <> input file }         log_is_input := FALSE;        END;   { log file <> input file }          IF initglobals.IG_logfile = initglobals.IG_outputfile THEN         BEGIN { log file = output file }        log_is_output := TRUE;        END   { log file = output file }      ELSE        BEGIN  { log file <> output file }        log_is_output := FALSE;         END;   { log file <> output file }          IF initglobals.IG_inputfile = initglobals.IG_outputfile THEN          BEGIN  { input file = output file }         input_is_output := TRUE;        END    { input file = output file }        ELSE         BEGIN  { input file = output file }         input_is_output := FALSE;         END;   { input file = output file }          END;     { CheckDuplicates }       $ SUBTITLE 'DoFilemanInit', PAGE $  {------------------------------------------------------------}  {                                                            }  {                    DoFilemanInit                           }  {                                                            }  {------------------------------------------------------------}  PROCEDURE DoFilemanInit;      #{  Purpose: To initialize the internal variables used within FileMan.  # !{  This routine will be called by most of the routines within the  ! {  module if the boolean filemaninit if FALSE.  {    {  Users of the file I/O routines should take care to initialize    {  filemaninit to FALSE prior to calling any subroutines within    {  this module.   {   {  Input:   none  	{  Output:   none  	 {   {  Global Variables accessed:   {     from Init_Dec:    none  {   {     from FileMan:     log_open, output_open, log_is_input,  "{                       log_is_output, input_is_output, first_read.  " {   {  Side Effects: none   {}         BEGIN    { DoFilemanInit }          { Initialize FileMan's internal variables. }          { set flag so this routine won't be called again. }     initglobals.IG_filemaninit := TRUE;         { neither log nor output file is open }     log_open := FALSE;      output_open := FALSE;         { No duplicate print places; no files open }   
   log_is_input := FALSE;  
 
   log_is_output := FALSE; 
    input_is_output := FALSE;         { haven't read from input or log dev }      first_read := TRUE;  (*  
   firstlog_read := TRUE;  
 *)         { set global flags to false }     initglobals.IG_interactive := FALSE;      initglobals.IG_save_in_out := FALSE;          END;     { DoFilemanInit }           $ SUBTITLE 'FileExists', PAGE $   {------------------------------------------------------------}  {                                                            }  {                      FileExists                            }  {                                                            }  {------------------------------------------------------------}  
FUNCTION FileExists  
   (    filename:     FileNType;      VAR result:       Int16 ):    Boolean;       {}  {  Purpose: To see if the file named "filename" exists.   {   !{  Description: This routine attempts to open the file by the name !  {  of filename.  If the open is sucessful, the functional return   "{  is set to TRUE.  Otherwise the functional return is set to FALSE. " {    {  The file is only checked if it is not an LU (eg not numeric).   {   {  Input:   {     filename:      Name of file to be checked.  {   {  Output:  !{     result:        <>0 if an error occurred while attempting to  ! {                    check the file.   {     FUNCTIONAL Return:   TRUE if file Exists, FALSE otherwise.   {   {  Global Variables Accessed/Changed:   {     From Init_Dec: Pascal error catcher variables (hiterror,  {                             pascal_error, opening ).  {   {  Side Effects:  "{     The routine assumes there will be a user-supplied Pascal Error "  {     Catcher that will set hiterror to TRUE if an error occurs    {     while attempting to open the file.  If no error occurs,   {     the routine assumes the file exists.  {   {}      VAR   
   dummy:            TEXT; 
     BEGIN    { FileExists }       
FileExists := FALSE; 
 result := GOOD;       { clear pascal error indication flags }   	hiterror := FALSE; 	 opening := TRUE;      IF (( filename[1] < '0' ) OR ( filename[1] > '9' )) THEN  
   BEGIN    { check file } 
        RESET( dummy, filename, SHARED );      
   opening := FALSE; 
        IF NOT hiterror THEN         BEGIN    { file exists }  
      FileExists := TRUE;  
           END      { file exists }       ELSE         BEGIN    { file doesn't exist }             hiterror := FALSE;        result := INITPASCALE + pascal_error.ernumber;        pascal_error.ernumber := 0;             END;     { file doesn't exist }   
   END;     { check file } 
     CLOSE( dummy );       END;     { FileExists }       $ SUBTITLE 'FileInteractive', PAGE $  {------------------------------------------------------------}  {                                                            }  {                 FileInteractive                            }  {                                                            }  {------------------------------------------------------------}  FUNCTION FileInteractive    (    whichfile:  InputOrLogType ):   Boolean;       {}  { Purpose: To determine if a file name (LU) is interactive.   #{  The routine returns TRUE if the LU is interactive, FALSE otherwise  # {   
{  input parameters: 
  {     whichfile:  enumerated type for file to be checked, either   {        input file or log file.  {   {  output parameters:   {     Boolean FUNCTIONAL RETURN:      TRUE if lu interactive.   {   {  global parameters used but not changed: none   {  global parameters changed: none  {   {  Side Effects:  none  ${  Routines Called:  Pas.DCBAddress( alias GetDCBAddr ), FmpInteractive  $ {}          CONST   $   LUNOTINTERACTIVE = 0;    { FmpInteractive returning NOT interactive } $     VAR   %   fmp_return:          Int16;        { return value from FmpInteractive } %    dcbp:                DcbPtr;          BEGIN   { FileInteractive }         IF whichfile = FILEISIN THEN         BEGIN    { use input text file }        GetDCBAddr( dcbp, inputf );         END      { use input text file }       ELSE         BEGIN    { use log text file }        GetDCBAddr( dcbp, log );        END;     { use log text file }         fmp_return := FmpInteractive( dcbp^ );          IF fmp_return = LUNOTINTERACTIVE THEN        BEGIN    { lu not interactive }         FileInteractive := FALSE;         END      { lu not interactive }        ELSE         BEGIN    { file not an lu }         FileInteractive := TRUE;        END;     { file not an lu }          END;    { FileInteractive }      $ SUBTITLE 'HandleDefFileName', PAGE $  {------------------------------------------------------------}  {                                                            }  {             HandleDefFileName                              }  {                                                            }  {------------------------------------------------------------}      PROCEDURE HandleDefFileName     (VAR filename:     FileNType;          name_base:    IStringType;      VAR result:       Int16 );   &   { If file name is "/D" make it name_base+number & see it doesn't exist }  & {}  %{  Description: If filename = '/D' this routine attempts to open the file: % !{  namebase + xx.  Namebase is a string used as the base filename. ! #{  XX is a number from 1 to 99.  The routine starts with the filename  # #{  namebase1.  It attempts to open this filename.  If the file already # #{  exists the number will be incremented until a non-existing filename # {  is found, or the number is >99.  {   {  Input:   {     filename:      string to be tested for '/D'   &{     name_base:     String to be used as base for file name to be checked.  & {   {  Output:   {     filename:      name of file that does not currently exist    !{     result:        <> 0 if error, 0 otherwise ( possible errors: ! {                          nameno>99 )  {   {  Global Variables Accessed:  none   {   {  Routines called: FileExists  {   {}      VAR      exists:           Boolean;      goodresponse:     Boolean;      internal_result:  Int16;      nameno:           Int16;      next:             Int16;          BEGIN    { HandleDefFileName }          { Initialize internal variables if necessary }      IF NOT initglobals.IG_filemaninit THEN DoFilemanInit;         internal_result := GOOD;       
   IF filename = '/D' THEN 
 
      BEGIN    { default } 
     	      nameno := 1; 	       goodresponse := FALSE;        name_base := Strltrim( name_base );         name_base := Strrtrim( name_base );             REPEAT               Strwrite( filename, 1, next, name_base, nameno:1 );               exists := FileExists( filename, internal_result );   !         { if internal_result <> GOOD then exists will be FALSE }  !               IF (( internal_result = INITPASCALE + NOSUCHFILE ) AND                                         ( NOT exists )) THEN               BEGIN    { doesn't exist }              { no file exists by the file name in filename }               goodresponse := TRUE;               internal_result := GOOD;              END;     { doesn't exist }               nameno := nameno + 1;               { is this test sufficient?  Do I want to bail out           if internal_result <> GOOD?                      }                UNTIL (( goodresponse ) OR ( nameno > 99 ));       
      IF nameno > 99 THEN  
          BEGIN    { can't find non-existent file }  
         PrintError( 
 #   '** (9011) NS Error: All 99 default files exist.  Terminating. **', #            internal_result );                internal_result := ERRDEF_ALL_EXIST;            END;     { can't find non-existent file }      
      END;     { default } 
    result := internal_result;          END;     { HandleDefFileName }           $ SUBTITLE 'OpenInput', PAGE $  {------------------------------------------------------------}  {                                                            }  {                      OpenInput                             }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE OpenInput  
      (VAR result:    Int16);      {}  { Purpose: Open input device.   {   
{  input parameters: none  
 {  output parameters:   {     result:           <0 if error =0 if no error  {   {  global variables used but not changed:   	{     From FileMan 	 {         log_open      used to test if errors can be printed   {         log           used to print errors  {   {  global variables changed:  
{     From Init_Dec: 
  {        inputfile - name of input file ( blank trimmed, set to    !{                          LU 1 if error or input file not init. ) ! {        opening -   flag to trap pascal open errors  ${        hiterror and pascal_error to coordinate with Pas.ErrorCatcher.  $ {   	{     From FileMan 	 #{        inputf -      TEXT file (for input) initialized by OpenInput  # ${        input_print - TEXT file (to print on input) init. by OpenInput  $ ${        first_read -  flag to handle EOLN case initialized by OpenInput $ {   {   "{  Side Effects:  Calls CheckDuplicates which initializes duplicate  " {     flags, interaction with Pas.ErrorCatcher.   {  Routines called:  CheckDuplicates  {   {}      VAR      dummynext:         Int16;  !   in_name_len:       Int16;         { length of input file name } ! %   internal_result:   Int16;         { internal value of error parameter } %     
BEGIN       { OpenInput }  
     { Initialize Fileman's internal variables if necessary }  IF NOT initglobals.IG_filemaninit THEN DoFilemanInit;       internal_result := GOOD;      { trim leading and trailing blanks }  !initglobals.IG_inputfile := Strltrim( initglobals.IG_inputfile );  ! !initglobals.IG_inputfile := Strrtrim( initglobals.IG_inputfile );  !     in_name_len := Strlen( initglobals.IG_inputfile );      IF in_name_len <= 0 THEN     BEGIN   { No input name provided }   	   { Use default } 	    initglobals.IG_inputfile := DEFAULT_LU;  
   in_name_len := 1; 
    END;    { No input name provided }       { set flags for opening file }  	hiterror := FALSE; 	 opening := TRUE;      RESET ( inputf, initglobals.IG_inputfile, SHARED );   	opening := FALSE;  	     IF hiterror THEN     BEGIN   { Error opening input }     hiterror := FALSE;       	   errormsg := ''; 	    Strwrite( errormsg, 1, dummynext, '** (9005) NS: ERROR ',           pascal_error.ernumber:1,' opening ',            initglobals.IG_inputfile:in_name_len, '**' );         PrintError( errormsg, internal_result );   
   { ignore errors } 
        internal_result :=  NOTOPEN;      pascal_error.ernumber := 0;         END     { Error opening input }    ELSE     BEGIN    { continue checking file }     initglobals.IG_interactive := FileInteractive( FILEISIN );          IF initglobals.IG_interactive THEN         BEGIN    { input device is interactive }        { open input device as output device to print to }            hiterror := FALSE;        opening := TRUE;            REWRITE( input_print, DEFAULT_LU );             opening := FALSE;         IF hiterror THEN           BEGIN       { opening error }           hiterror := FALSE;                errormsg := '';      %         { if have problems here, there will be problems later. Give up }  %     !         Strwrite( errormsg, 1, dummynext, '** (9006) NS: Error ', !            pascal_error.ernumber:1,               ' Opening input device for writing.  Aborting. **');                 PrintError( errormsg, internal_result );                pascal_error.ernumber := 0;           internal_result := ERR_ALREADY_PRINTED;               END;        { opening error }        END      { input device is interactive }       ELSE             BEGIN    { input device is NOT interactive }            initglobals.IG_interactive := FALSE;        END;     { input device is NOT interactive }          { Set up first_read flag to circumvent EOLN test in ReadInput   !     the first time a read is done on an interactive device      } !    first_read := TRUE;         { check for duplicate devices }  
   CheckDuplicates;  
    END;     { continue checking file }      
result := internal_result; 
     
END;        { OpenInput }  
     $ SUBTITLE 'OpenLog ', PAGE $   {------------------------------------------------------------}  {                                                            }  {                      OpenLog                               }  {                                                            }  {------------------------------------------------------------}  	PROCEDURE OpenLog  	      (VAR result:    Int16);      {}  { Purpose: Open log device.   {   
{  input parameters: none  
 {  output parameters:   {     result:     =0 if no error <0 if error  {   {  global variables used but not changed:   none  {  global variables changed:  
{     From Init_Dec  
 {           logfile  -  ascii name of log file to be opened,  {                       spaces trimmed from name  {           opening  -  used to handle pascal open errors   {           hiterror -  used to indicate pascal open error  {   	{     From FileMan 	 {           log -       TEXT file initialized by OpenLog  #{           log_open -  flag to indicate log dev open- init by OpenLog # {   %{  Side Effects:  Calls CheckDuplicates which initializes duplicate flags, % {     interaction with Pas.ErrorCatcher.  {  Routines Called:  CheckDuplicates.   {   {}         CONST  %      DEFAULT_LU = '1';             { Use LU 1 when no log name provided } %        VAR         log_name_len:     Int16;      { length of log file name }          dummynext:        Int16;  #      internal_result:  Int16;      { internal value of error param. } #       used_default:     Boolean;      (*  $ SUBTITLE 'OpenLogForRead (OpenLog)', PAGE $   {------------------------------------------------------------}  {  ( LOCAL )   OpenLogForRead         ( LOCAL )              }  {------------------------------------------------------------}  
PROCEDURE OpenLogForRead;  
     {}  {  Purpose: To open the log device for reading input if it is   {  interactive.   {   {  Input:   none  {  Output:  none  {  Global variables accessed:   {     From Fileman:  log_read   {     From Init_Dec: log_read, hiterror, pascal_error   {   {  Side Effects: interaction with Pas.ErrorCatcher.   {}            BEGIN  { OpenLogForRead }             hiterror := FALSE;        opening := TRUE;            RESET( log_read, initglobals.IG_logfile, SHARED );        opening := FALSE;             IF hiterror THEN           BEGIN    { had error }            hiterror := FALSE;            pascal_error.ernumber := 0;               errormsg := LOGREADERR;           WRITELN( log, errormsg );  
         { ignore errors } 
              internal_result := ERR_ALREADY_PRINTED;               END      { had error }           ELSE           BEGIN    { log open for reading }               firstlog_read := TRUE;                END;     { log open for reading }        END;     { OpenLogForRead }   *)      $ SUBTITLE 'TryOpeningDefault (OpenLog)', PAGE $  {------------------------------------------------------------}  {  ( LOCAL )   TryOpeningDefault      ( LOCAL )              }  {------------------------------------------------------------}  PROCEDURE TryOpeningDefault;      {}  {  Purpose:   {     To attempt to open the default file for the log device.   {   {  Input:   none  {  Output:  none  {  Global variables accessed:   {     From Fileman:  log, errromsg  {     From InitDec:  logfile, hiterror, pascal_error.   {   {  Side Effects:  interaction with Pas.ErrorCatcher.  {}            BEGIN { TryOpeningDefault }             hiterror := FALSE;            IF initglobals.IG_logfile = DEFAULT_LU THEN            BEGIN    { bail out, no log file possible }               { this should never happen }            internal_result := ERROPENLU1;            pascal_error.ernumber := 0;               END      { bail out, no log file possible }          ELSE           BEGIN    { open default LU, tell user }               { build an error message }            errormsg := '';                { NOTE THIS ERROR MESSAGE DEPENDS ON DEFAULT_LU = 1. }        !         Strwrite( errormsg, 1, dummynext, '** (9007) NS ERROR ',  !           pascal_error.ernumber:1, ' opening ',            initglobals.IG_logfile:log_name_len,             '. Opened LU 1 as log file. **' );               pascal_error.ernumber := 0;  
         opening := TRUE;  
              initglobals.IG_logfile := DEFAULT_LU;               REWRITE( log, initglobals.IG_logfile, SHARED );  
         opening := FALSE; 
              IF NOT hiterror THEN               BEGIN    { tell user about default lu }               { use message already built }               WRITELN( log, errormsg );               { no error check here !! }                  initglobals.IG_logfile := DEFAULT_LU;                   log_open := TRUE;               used_default := TRUE;                   END      { tell user about default lu }              ELSE               BEGIN    { error opening default lu }                   { this should never happen }              { no where to print error message. Give up }              hiterror := FALSE;              pascal_error.ernumber := 0;               internal_result := ERROPENLU1;              END;     { error opening default lu }                END;     { open default, tell user }         END;  { TryOpeningDefault }       $ SUBTITLE 'OpenLog', PAGE $     BEGIN  { OpenLog }          { initialize fileman's internal variables if necessary }      IF NOT initglobals.IG_filemaninit THEN DoFilemanInit;         { assume no errors }      internal_result := GOOD;          { strip leading and trailing blanks from name }      initglobals.IG_logfile := Strltrim( initglobals.IG_logfile );       initglobals.IG_logfile := Strrtrim( initglobals.IG_logfile );          log_name_len := Strlen( initglobals.IG_logfile );         IF log_name_len <= 0 THEN        BEGIN    { No log name provided }         { Use default }         initglobals.IG_logfile := DEFAULT_LU;         log_name_len := 1;        used_default := TRUE;         END      { No log name provided }        ELSE         BEGIN    { default NOT used }         used_default := FALSE;        END;     { default NOT used }          hiterror := FALSE;   
   opening := TRUE;  
        REWRITE( log , initglobals.IG_logfile, SHARED );   
   opening := FALSE; 
     
   IF hiterror THEN  
       BEGIN   { Error opening log device }            TryOpeningDefault;        END     { Error opening log device }       ELSE         BEGIN    { log file is open }             log_open := TRUE;         END;     { log file is open }          IF (( log_open ) AND ( internal_result = GOOD )) THEN        BEGIN    { finish log set up }            CheckDuplicates;      
      IF used_default THEN 
          BEGIN    { tell caller }            internal_result := OPENEDDEF;           END      { tell caller }         END;     { finish log set up }         result := internal_result;          END;   { OpenLog }       $ SUBTITLE 'OpenOutput ', PAGE $  {------------------------------------------------------------}  {                                                            }  {                      OpenOutput                            }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE OpenOutput 
 
   (VAR result:    Int16); 
    { Open the output (answer) file }      {}  { Purpose: Open Output device.  {   {  Input:   none  {  Output:  {     result  -   =0 if no error, <0 if error   {   {  global variables used but not changed:   	{     From FileMan 	 {        log_open flag to indicate whether log device is open   {        log -    log device used to print errors   {   {  global variables changed:  
{     From Init_Dec  
 {        outputfile  - ascii name of output file to be opened   {        opening     - used to handle pascal open errors  {        hiterror - used to indicate pascal open errors   	{     From FileMan 	 {        output_open -  flag to indicate output device open    {        outputf -      TEXT file used to print on output device   {   {  Side Effects:   Calls CheckDuplicates, which initializes   {        duplicate flags.  This routine relies on output_open   {        being initialized to FALSE by PASCAL.  {   
{  Routines called:  none  
 {   {}      CONST       #   NOCCTL = 'NOCCTL';          { No carriage control on output file }  #     VAR   $   internal_result:   Int16;      { internal value of error parameter }  $    dummynext:        Int16;       out_name_len:      Int16;      { length of output file name }          BEGIN  { OpenOutput }         { Initialize fileman's internal variables if necessary }      IF NOT initglobals.IG_filemaninit THEN DoFilemanInit;         internal_result := GOOD;          { strip leading and trailing blanks }  #   initglobals.IG_outputfile := Strltrim( initglobals.IG_outputfile ); # #   initglobals.IG_outputfile := Strrtrim( initglobals.IG_outputfile ); #        out_name_len := Strlen( initglobals.IG_outputfile );          IF out_name_len > 0 THEN   
      BEGIN { open file }  
       hiterror := FALSE;        opening := TRUE;      "      REWRITE( outputf, initglobals.IG_outputfile, SHARED_NOCCTL );  "       opening := FALSE;             IF hiterror THEN           BEGIN { opening error }           output_open := FALSE;           hiterror := FALSE;                errormsg := '';      !         Strwrite( errormsg, 1, dummynext, '** (9005) NS: ERROR ', !             pascal_error.ernumber:1,  %            ' opening ', initglobals.IG_outputfile:out_name_len, '.**' );  %              pascal_error.ernumber := 0;               PrintError( errormsg, internal_result );   
         { ignore errors } 
              internal_result := NOTOPEN;               END   { opening error }          ELSE               BEGIN { no errors: file open }            { no errors, have answer file }           output_open := TRUE;                { check for duplicate devices }  
         CheckDuplicates;  
              END;  { no errors: file open }   
      END;  { open file }  
        result := internal_result;          END;  { OpenOutput }       $ SUBTITLE 'PrintError', PAGE $   {------------------------------------------------------------}  {                                                            }  {                       PrintError                           }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE PrintError 
   (    error_msg:    PromptType;     VAR result:       Int16 );   #   { Print caller's error; checking for duplicate prints on a device } # {   "{  Description: Print a string on the input, output, and log devices " {     under the following conditions:   {   {     Input: If interactive   ${     Output: If the output device is open AND save_in_out flag is TRUE  $ {     Log: If log device is open  {   #{  The routine also ensures that the same message is not printed more  # {  than once on any device.   {   {  Input:   #{     error_msg:     String to be printed.  NOTE that no length check  # #{                    is done. Callers should be careful not to exceed  # !{                    79 characters on writes to output.  The files ! {                    look messy if the len it too large.  {  Output:  ${     result:        <> 0 if error, 0 otherwise.  Possible error returns $ ${                    include: hit pascal errorcatcher ( hiterrro TRUE ), $ %{                             internal var. uninit  (filemaninit FALSE ),  % {   {  Global variables Accessed:   
{     from FileMan:  
 
{        filemaninit 
 '{        output_open, log_open, input_is_output, log_is_input, log_is_output,  ' {        three TEXT files: outputf, log, input_print  {   
{     from Init_Dec: 
 {        interactive, save_in_out flags.  {   {  Side Effects:  none  {   {}      VAR          internal_result:     Int16;     print_in:            Boolean;     print_log:           Boolean;     print_out:           Boolean;      $ SUBTITLE 'StopDuplicatePrints ( PrintError )' , PAGE $  {------------------------------------------------------------}  {  ( LOCAL )  StopDuplicatePrints     ( LOCAL )              }  {------------------------------------------------------------}         PROCEDURE StopDuplicatePrints;             BEGIN    { StopDuplicatePrints }            IF ( log_is_input AND                print_log AND  print_in ) THEN                BEGIN    { delete input device from print }               print_in := FALSE;            END;     { delete input device from print }            IF ( log_is_output  AND                 print_log  AND  print_out ) THEN               BEGIN    { delete output device from print }                print_out := FALSE;           END;     { delete output device from print }             IF ( input_is_output AND                 print_in AND print_out ) THEN           BEGIN    { delete output device from print }                print_out := FALSE;           END;     { delete output device from print }             END;     { StopDuplicatePrints }      $ SUBTITLE 'PrintError', PAGE $      BEGIN { PrintError }          IF NOT initglobals.IG_filemaninit THEN         BEGIN             { files not init: error. }        { internal variables uninitialzed.  Bail out. }         internal_result := FILESNOTINIT;        END               { files not init: error. }       ELSE         BEGIN       { do print }            internal_result := GOOD;      #      { Set flags to print places if global flags indicate to print }  #           { if interactive print on input }         print_in := initglobals.IG_interactive;       '      { if output device open and want to save this message print on output }  ' !      print_out := ( output_open AND initglobals.IG_save_in_out ); !           { if log device open print on log }         print_log := log_open;      $      { change flags so message is printed at most once on each device } $ 
      StopDuplicatePrints; 
           IF print_in  THEN            BEGIN       { print on input }                WRITELN( input_print, error_msg );            END;        { print on input }             IF print_log THEN            BEGIN       { print on log }                WRITELN( log, error_msg );            END;        { print on log }             IF print_out THEN            BEGIN       { print on output }               WRITELN( outputf, error_msg );            END;        { print on output }            END;        { do print }         result := internal_result;          END;  { PrintError }       $ SUBTITLE 'ReadFromLog', PAGE $  (*  {------------------------------------------------------------}  {                                                            }  {                      ReadFromLog                           }  {                                                            }  {------------------------------------------------------------}  PROCEDURE ReadFromLog     (VAR input_string: String;     VAR result:       Int16);  {    Get a line of input from the log device.}      {}  { Description: Read a line from file "log." Check for "/A"  "{    ("/a, ab, Ab, aB, AB") & set result = ABORT if any was entered. " {   !{  This routine will be called during error recovery from previous !  {  user input when the input device is not interactive.  The log    {  device will be used temporarily to get good input.  When the    !{  input has been read and tests out, the input device will again  ! {  be used for input.   {   {    If null input was read set input_string to "/D".   {   
{ Input parameters:  none  
 
{ Output parameters: 
 {       input_string - 80 char string which contains the  {           line that was read.   "{           If result <> GOOD, input_string will be null, except if  " {              result = IABORT, when string will be 'AB'.   {   "{       result - return parameter.  0 if no problems, IABORT if "/A" " {           was entered, <0 if other problems.  {   {   {  Global variables used but not changed:   	{     From FileMan 	 {        log_read    TEXT file to read from   {   {  Global variables changed:  
{     From Init_Dec  
 {        hiterror-   used to handle pascal reading errors   {        reading -   used to handle pascal reading errors   	{     From FileMan 	 "{        firstlog_read - used to handle EOLN problem on first read.  " {        read_string-    where input is read into   {  Side Effects:  pascal error catcher may be envoked.  {  Routines called:  TestInputRead.   {   {}      VAR       &   internal_result: Int16;           { internal value for result parameter } &        BEGIN    { ReadFromLog }          SetStrlen( input_string, 0 );         IF NOT initglobals.IG_filemaninit THEN         BEGIN       { files not init: error. }            internal_result := FILESNOTINIT;        END         { files not init: error. }       ELSE         BEGIN       { read from log }             { start out without any errors }        internal_result := GOOD;            IF firstlog_read THEN            BEGIN    { clear first read from log flag }               { this flag is used to circumvent a PASCAL I/O            "feature".  See ReadInput for description.     }                firstlog_read := FALSE;               END      { clear first read from log flag }          ELSE           BEGIN    { delete "EOLN" from buffer }                READLN( log_read );               END;     { delete "EOLN" from buffer }             reading := TRUE;        READ( log_read, read_string );        reading := FALSE;             { Check input read for pascal read errors, 'ab', etc.           Move read_string into input_string if test ok.     }      !      TestInputRead( read_string, input_string, internal_result ); !           END;        { read input from log }          result := internal_result;          END;     { ReadFromLog }   *)      $ SUBTITLE 'ReadInput', PAGE $  {------------------------------------------------------------}  {                                                            }  {                        ReadInput                           }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE ReadInput  
   (VAR input_string: String;     VAR result:       Int16);  {    Get a line of input from the input device/file.      {}  { Description: Read a line from file "input." Check for "/A"  #{    ("/a, ab, Ab, aB, AB") & set result = IABORT if any was entered.  # {   {    If null input was read set input_string to "/D".   {   
{ Input parameters:  none  
 
{ Output parameters: 
 {       input_string - 80 char string which contains the  {           line that was read.   "{           If result <> GOOD, input_string will be null, except if  " {              result = IABORT, when string will be 'AB'.   {   "{       result - return parameter.  0 if no problems, IABORT if "/A" " {           was entered, <0 if other problems.  {   {   {  Global variables used but not changed:   	{     From FileMan 	 {        inputf      TEXT file to read from   {   {  Global variables changed:  
{     From Init_Dec  
 {        hiterror-   used to handle pascal reading errors   {        reading -   used to handle pascal reading errors   	{     From FileMan 	 %{        first_read - used to handle EOLN problem on first read from input % {        read_string- where input read is placed  {  Side Effects:  pascal error catcher may be envoked.  {  Routines called:  TestInputRead.   {   {}      VAR       &   internal_result: Int16;           { internal value for result parameter } &        BEGIN   { ReadInput }         SetStrlen( input_string, 0 );         IF NOT initglobals.IG_filemaninit THEN         BEGIN    { files not init: error }        { internal variables not initialized: error. }        internal_result := FILESNOTINIT;        END      { files not init: error }       ELSE         BEGIN    { do print }         { start out without any errors }        internal_result := GOOD;            IF first_read THEN           BEGIN    { clear first read from input flag }           { this flag is used to circumvent a PASCAL I/O   
         "feature".  
              If the EOLN function is executed on an interactive            terminal before a read has been done on the terminal,           PASCAL will hang a read on the terminal.  This            is not desired, so skip the first_read flag is set up           to avoid the EOLN test on the first read from the            input device.                                        }                 first_read := FALSE;            END      { clear first read from input flag }          ELSE           BEGIN    { delete "EOLN" from input buffer }       
         READLN( inputf ); 
          END;     { delete "EOLN" from input buffer }             reading := TRUE;        READ( inputf, read_string );        reading := FALSE;             { check input read for pascal read errors, 'ab', etc }  !      TestInputRead( read_string, input_string, internal_result ); !           END;     { do print }          result := internal_result;          END;    { ReadInput }      $ SUBTITLE 'TestInputRead', PAGE $  {------------------------------------------------------------}  {                                                            }  {                 TestInputRead                              }  {                                                            }  {------------------------------------------------------------}      PROCEDURE TestInputRead     (    read_string:     PCharType;     VAR input_string:    String;      VAR result:          Int16 );  $   { test input read from a device for pascal errors & abort sequence }  $ {   {  Description: To check the input read from the input device   "{  for general validity.  Also convert the input a from packed array " {  of char to a pascal string.  {   {     Tests performed:  !{        If pascal error catcher hig (hiterror) then check for EOF ! {          and return an error to caller.   #{        Test for all combinations of 'ab' in read_string. If have an  # ${          IABORT sequence, set result=IABORT, and input_string to 'AB'. $ {   {  Input:   "{     read_string:      Packed Array of Char containing input read.  " {  Output:  {     input_string:     String of input read.   {     result:           <> 0 IF error, 0 Otherwise.   {   {  Global Variables Accessed:   {     pascal error catcher variables from Init_Dec:   {        pascal_error record.   {}      CONST      ABORT_LENGTH = 2;               { length of abort string }   !   EOFMSG = '** (9008) NS: End of file encountered. Aborting. **'; !     VAR      abort_string:  TwoCharType;         BEGIN    { TestInputRead }   	   result := GOOD; 	         IF (( hiterror ) AND ( pascal_error.ernumber <> NONE )) THEN          BEGIN    { error }        hiterror := FALSE;        IF pascal_error.ernumber = EOFERROR THEN           BEGIN    { Eof on input }               { tell caller about the problem. }            result := EOFONREAD;            END      { Eof on input }          ELSE           BEGIN    { hit error catcher for something else }           result := ERRPASCAL_ERRC;           END;     { hit error catcher for something else }            END      { error }        { do paranoid checks here to make sure that only one        of the above conditions NEVER happens.              }        ELSE         BEGIN    { no error on read }       
      input_string := '';  
 
      abort_string := '';  
           { get a two character string to check for abort }             { this move works for 1 char input because           read_string is a packed array of char. }         Strmove( TWOCHAR, read_string, 1, abort_string, 1 );            { upshift the abort string }        StrUpshift( abort_string );       
      { Check for abort }  
        IF ( abort_string = '/A' ) OR ( abort_string = 'AB' ) THEN            BEGIN          { abort }   
         result := IABORT; 
          input_string := 'AB';           END            { abort }          ELSE            BEGIN    { continue checking input }       &         { convert packed array of char that was read in to pascal string }  &           Strmove( STRINGSIZE, read_string, 1, input_string, 1 );                { strip off leading and trailing blanks }           input_string := Strrtrim( input_string );           input_string := Strltrim( input_string );               IF Strlen( input_string ) = 0 THEN               BEGIN       { null input }              input_string := '/D';               END;        { null input }               END;     { continue checking input }         END;     { no error on read }          END;     { TestInputRead }       $ SUBTITLE 'SayOutputNeedsEdit', PAGE $   {------------------------------------------------------------}  {                                                            }  {               SayOutputNeedsEdit                           }  {                                                            }  {------------------------------------------------------------}  PROCEDURE SayOutputNeedsEdit;       {}  {  Purpose: To print the message ' output file needs editing'   {  in the output device if save_in_out is true and the output   {  device is open.  In addition, print this message on the  {  input and log devices if necessary.  {   {  Input:   none  {  Output:  none  {   {  Global Variables Accessed:   {     From Init_Dec: save_in_out is checked.   {     From Fileman:  output_open is checked, errormsg is used to   {        store the message to be printed.   
{  Routines Called:  
 	{     PrintError.  	 {   {}      VAR      internal_result:  Int16;          BEGIN    { SayOutputNeedsEdit }         errormsg :=  &'** (9009) NS ERROR: Edit OUTPUT file before using it to initialize NS. **'; &        IF initglobals.IG_save_in_out AND output_open THEN         BEGIN    { have output file; print message }            PrintError( errormsg, internal_result );       { for now ignore errors }            END;     { have output file; print message }      "   { If there is no output file don't bother to print the message. } "        END;     { SayOutputNeedsEdit }      $ SUBTITLE 'SayUsingInputAgain', PAGE $   (*  {------------------------------------------------------------}  {                                                            }  {               SayUsingInputAgain                           }  {                                                            }  {------------------------------------------------------------}  PROCEDURE SayUsingInputAgain;       {}  !{  Purpose: To print the message ' Using input file xxx for input' !  {  on the log device.  This routine will be called by the input    {  routines to inform the user that the use of the log device   {  to read input is no longer necessary.  {   {  Input:   none  {  Output:  none  {   {  Global Variables Accessed:   {     From Init_Dec: inputfile - the name of the input file is  {       blank trimmed, and used to construct the message.   
{  Routines Called:  
 	{     WriteOnLog.  	 {   {}      VAR      internal_result:  Int16;          BEGIN    { SayUsingInputAgain }      "   initglobals.IG_inputfile := Strltrim( initglobals.IG_inputfile ); " "   initglobals.IG_inputfile := Strrtrim( initglobals.IG_inputfile ); "        errormsg := 'Using input file ';      Strappend( errormsg, initglobals.IG_inputfile );      Strappend( errormsg, ' for input again.' );         WriteOnLog( errormsg, internal_result );      { ignore error returns }          END;     { SayUsingInputAgain }      *)  $ SUBTITLE 'WriteOnInput' , PAGE $  {------------------------------------------------------------}  {                                                            }  {                  WriteOnInput                              }  {                                                            }  {------------------------------------------------------------}  PROCEDURE WriteOnInput    (    write_string: PromptType;     VAR result:       Int16 );      { write string on input device }   {   {  Description:   Write the string passed on the input device   {     if the input device is interactive.   {   {  Input:   {     write_string:     String to be written.   {   {  Output:  {     result:           <> 0 if error, 0 Otherwise.   {   {  Global variables accessed:   
{     From FileMan:  
 "{        filemaninit (tested to see if initialization has been done) " {        input_print:   TEXT file where string is printed   {     From  Init_Dec:   
{        interactive flag  
 {   {  Side Effects:  {     pascal error catcher may be envoked on errors.  {}         BEGIN    { WriteOnInput }  	   result := GOOD; 	        IF NOT initglobals.IG_filemaninit THEN         BEGIN    { files not init: error }        result := FILESNOTINIT;         END      { files not init: error }       ELSE         IF initglobals.IG_interactive THEN           BEGIN    { print on input device }            WRITELN( input_print, write_string );           END;     { print on input device }          END;     { WriteOnInput }      $ SUBTITLE 'WriteOnLog', PAGE $   {------------------------------------------------------------}  {                                                            }  {                    WriteOnLog                              }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE WriteOnLog 
   (    write_string: PromptType;     VAR result:       Int16 );      { write string on log device }   {   {  Description:   This routine writes the string passed on the  {     log device if it is open.   {   {  Input:   {     write_string:     String to be printed  {  Output:  {     result:           <>0 If error, 0 otherwise   {   {  Global Variables Accessed:   
{     from FileMan:  
  {        filemaninit:   flag to indicate variables initialized.    {        log:  TEXT file where string is printed.   {        log_open:   TRUE if log file is open.  {   {   {  Side Effects:  none  {}      
   BEGIN    { WriteOnLog } 
 	   result := GOOD; 	        IF NOT initglobals.IG_filemaninit THEN         BEGIN    { files not init: error }        result := FILESNOTINIT;         END      { files not init: error }       ELSE         IF log_open THEN           BEGIN    { write on log }               WRITELN( log, write_string );               END;     { write on log }      
   END;     { WriteOnLog } 
     $ SUBTITLE 'WriteOnOutput', PAGE $  {------------------------------------------------------------}  {                                                            }  {                  WriteOnOutput                             }  {                                                            }  {------------------------------------------------------------}  PROCEDURE WriteOnOutput     (    write_string: PromptType;     VAR result:       Int16 );      { write string on output device }  {   {  Description:   Write the passed string on the output device  {     if it is open and the save_in_out flag is true.   {   #{     Note that the string will be truncated if it is > 79 Characters. # {   {  Input:   {     write_string:     String to be printed  {   {  Output:  {     result:           <> 0 if error, 0 Otherwise  {   {  Global Variables Accessed:   
{     From Fileman:  
  {        filemaninit to determine if variables were initialized    {        output_open:   TRUE if OpenOutput was successful   {        outputf:    TEXT file where string is printed.   {   
{     From Init_Dec: 
 
{        save_in_out flag  
 {   {  Side Effects:  none  {   {}         BEGIN    { WriteOnOutput }   	   result := GOOD; 	        IF NOT initglobals.IG_filemaninit THEN         BEGIN    { files not init: error }        result := FILESNOTINIT;         END      { files not init: error }       ELSE         IF output_open AND initglobals.IG_save_in_out THEN           BEGIN    { write on output }                WRITELN( outputf, write_string );           END;     { write on output }          END;     { WriteOnOutput }       END         { Module FileMan }  .  