 $PASCAL '91790-1X205 REV.4010 <860109.1715>'  $TITLE 'Socket Registry Library'$   $debug$   $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF$ 
 $HEAP 0   	$HEAP_DISPOSE OFF  	 $STANDARD_LEVEL 'HP1000'  $PRIVATE_TYPES$       {}  {------------------------------------------------------   {   
{     NAME : SREGLIB 
 {   SOURCE : 91790-18205  	{    RELOC : NONE  	 {     PGMR : CWW  {    OWNER : CLC  {   {------------------------------------------------------   {}          MODULE SREGLIB;       {------------------------------------------------------------    (C) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date   PCO  Prgmr Description  {  850621 ---- cww   Made SregIBProbeReply() into a separate  {                    protocol handler.  {}              IMPORT     $SEARCH 'phtm/BODEC.REL'$        bodec,     $SEARCH 'phtm/SODEC.REL'$        sodec,     $SEARCH 'phtm/MMDEC.REL'$        mmdec,     $SEARCH 'phtm/MMEXT.REL'$        ds_mm,     $SEARCH 'phtm/TRCMOD.REL'$       trcmod,      $SEARCH 'phtm/SIGMOD.REL'$       sigmod,      $SEARCH 'phtm/LKLB.REL'$         lk,      $SEARCH 'phtm/TMRDEC.REL'$       tmrdec,      $SEARCH 'phtm/TCPGB.REL'$        tg,      $SEARCH 'phtm/TUSER.REL'$        tuser,     $SEARCH 'phtm/IPDEC.REL,phtm/IPLIB.REL,phtm/IPDB.REL'$                                  iplib,      $SEARCH 'phtm/IPPATH.REL,phtm/IPPCTL.REL,phtm/IPACTP.REL'$                                  ippath,    $SEARCH 'phtm/TCPLB.REL'$         tl,     $SEARCH 'phtm/PXPLB.REL'$         px,     $SEARCH 'phtm/LAN8.REL'$          lan8;       $PAGE   !{----------------------------------------------------------------} ! !{                                                                } ! !{   EXPORT DECLARATIONS                                          } ! !{                                                                } ! !{----------------------------------------------------------------} !     EXPORT      
   PROCEDURE EnvNameCheck  
       ( VAR namestr   : EnvironStringType;          VAR namelen   : Int16;          VAR ierr      : Int16 );      
   PROCEDURE NRegAdd 
       ( VAR ndrec   : NDRecord;               options : MMFlagsType;          VAR ierr    : Int16 );         PROCEDURE NRegFind         ( VAR regname   : EnvironStringType;              namelen   : Int16;          VAR mbufid    : Int16;          VAR pathoffset: Int16;          VAR pathlen   : Int16;          VAR ierr      : Int16 );         PROCEDURE NRegPurge        ( VAR rname  : EnvironStringType;               nlen   : Int16;           VAR ierr   : Int16  );      
   PROCEDURE ScanAndShift  
       ( VAR namestring  : EnvironStringType;              namelen     : Int16;          VAR curptr      : Int16;          VAR namepartlen : Int16;          VAR ierr        : Int16 );      
   PROCEDURE SRegIb  
       ( VAR emsg : EventMsgType;          VAR ierr : Int16        );      
   PROCEDURE SRegIbOutPro  
       ( VAR emsg : EventMsgType;          VAR ierr : Int16        );         PROCEDURE SRegIbProbeReply         ( VAR emsg  : EventMsgType;           VAR ierr  : Int16 );      
   PROCEDURE SregOb  
       ( VAR emsg  : EventMsgType;           VAR ierr  : Int16         );         PROCEDURE SregPokeProbe;          PROCEDURE SregIpcTemplates         ( VAR ierr : Int16 );          PROCEDURE SregSocketToPath         ( VAR socket  : SocketRecord;           VAR preport : PathReportRecord;           VAR ierr    : Int16  );           $PAGE   !{----------------------------------------------------------------} ! !{                                                                } ! !{   IMPLEMENT DECLARATIONS                                       } ! !{                                                                } ! !{----------------------------------------------------------------} !     IMPLEMENT       !{---------------------------------------------------------------}  ! !{   TYPE DECLARATIONS                                           }  ! !{---------------------------------------------------------------}  !     CONST   !   SREG_VERSION_ERR        = 1;  {defined error for SReg headers}  ! !   SREG_UNKNOWN_NAME_ERR   = 2;  {defined error for SReg headers}  !        { Define constants used as opcodes to ConvertReport().      {}      CR_CSREP_TO_DPATH    = 1;     CR_NODREP_TO_DPATH   = 2;     CR_NODREP_TO_CSREP   = 3;      !   {-------------------------------------------------------------} ! !   {   LOCATION CONSTANTS                                        } ! !   {-------------------------------------------------------------} !     CONST      LOC_900_PURGING              =  900;      LOC_901_STORING_NPR          =  901;      LOC_1000_READING_NDREC       = 1000;      LOC_1001_READING_PTR         = 1001;      LOC_1100_READING_NDREC       = 1100;      LOC_1101_READING_NXTPTR      = 1101;      LOC_1103_OVERWRITING         = 1103;      LOC_1800_MREAD               = 1800;      LOC_1801_MREAD2              = 1801;      LOC_1802_DISP_OVERW          = 1802;      LOC_1400_READING_HEADER      = 1400;      LOC_1401_APPENDING_PREAMBLE  = 1401;      LOC_1408_NO_PATH_MEMORY      = 1408;      LOC_1402_TRANSFER_PROBLEM    = 1402;      LOC_1403_READ_ERRMSG         = 1403;      LOC_1404_DISPOSING           = 1404;      LOC_1405_ODD_MSG             = 1405;      LOC_1406_SREGIB              = 1406;      LOC_1407_BAD_EMSG            = 1407;      LOC_1500_SREGIB_OUTPRO       = 1500;      LOC_1501_EVENT_TYPE          = 1501;      LOC_1502_MYSTERY             = 1502;      LOC_1600_PROBE_REPLY         = 1600;      LOC_1601_READING_LUREC       = 1601;      LOC_1602_DISPOSING           = 1602;      LOC_1603_READING_NPR         = 1603;      LOC_1604_READING_AGAIN       = 1604;      LOC_1900_CONFIGURATION       = 1900;      LOC_1901_PUTTING_TEMPLATE    = 1901;      LOC_2000_SREGOB              = 2000;      LOC_2001_BAD_EMSG            = 2001;      LOC_2100_READING_NPR         = 2100;      LOC_2101_READING_ENVNAME     = 2101;      LOC_2102_FIXING_ENVNAME      = 2102;      LOC_2103_OVERWRITE_LUREC     = 2103;      LOC_2104_S_TO_P              = 2104;      LOC_2105_PREP_QUERY          = 2105;      LOC_2300_NOT_IP              = 2300;      LOC_2301_TCP_ADD             = 2301;      LOC_2302_IP_ADD              = 2302;      LOC_2303_LAN_ADD             = 2303;      LOC_2304_X25_ADD             = 2304;      LOC_2305_OTHERWISE           = 2305;       TYPE     Int3216Type = RECORD         CASE INTEGER OF         1: (int0 : Int16;             int  : Int16);        2: (longint : INTEGER);   
      END; { Int3216Type } 
         VAR      context           : ContextWords;     logerr            : Int16;      preport           : PathReportRecord;     protorec          : ProtocolRecord;     scratchlumsg      : IpcLookUpReqMsg;      templookuprec     : LookUpRecord;     tempndrec         : NDRecord;     tempsocket        : SocketRecord;     vectdbuf          : VectoredDataType;      $PAGE   !{---------------------------------------------------------------}  ! !{   FORWARD AND EXTERNAL DECLARATIONS                           }  ! !{---------------------------------------------------------------}  !     PROCEDURE AdrOf   
   (     object   : Int16; 
 
         offset   : Int16; 
      VAR byteaddr : Int16 ); EXTERNAL;      PROCEDURE ChargeNAttachReport      (     urecid      : Int16;        VAR pathreport  : PathReportRecord;       VAR lsd         : Int16;        VAR sokind      : Int16;        VAR ierr        : Int16 ); FORWARD;      PROCEDURE DS_StoreUrec     ( VAR urecid      : Int16;        VAR urec        : Int16 ); EXTERNAL;       PROCEDURE ExaminePath      (     opcode      : Int16;        VAR ibyte       : Int16;        VAR score       : Int16;        VAR stack       : PathStackType;        VAR sp          : Int16;            nets_match  : BOOLEAN;        VAR eopath      : Int16;        VAR pathrep     : PathReportRecord;       VAR ierr        : Int16 ); FORWARD;      
PROCEDURE FinishName 
    ( VAR namestr    : EnvironStringType;           hierarchy  : Int16;       VAR curptr     : Int16 ); FORWARD;       FUNCTION $DIRECT$ Ior   
   ( VAR i : Int16;  
      VAR j : Int16 ): Int16; EXTERNAL;      
PROCEDURE MakeCSiteReport  
    ( VAR protoelement      : SocketNameType;       VAR elementlen        : Int16;        VAR preport           : PathReportRecord;       VAR preportlen        : Int16;        VAR wkmp              : Int16;        VAR ierr              : Int16 ); FORWARD;      
PROCEDURE PrepSRNameQuery  
    ( VAR soname      : SocketNameType;           sonamelen   : Int16;        VAR sregmsg     : IpcLookUpReqMsg;            rootgsd     : Int16;        VAR msgmbufid   : Int16;        VAR ierr        : Int16 ); FORWARD;      PROCEDURE ProSw      ( VAR emsg : EventMsgType;        VAR ierr : Int16         ); EXTERNAL;      
PROCEDURE SRegIbUpConfirm  
    (     lsd        : Int16;           sokind     : Int16;           result     : Int16;           upref      : Int16;           seqnum     : Int16;       VAR replyemsg  : EventMsgType;        VAR wkmp       : Int16); FORWARD;      PROCEDURE SRegLogError     ( location  : Int16;        error     : Int16 ); FORWARD;      
PROCEDURE SregQueryRequest 
    ( VAR emsg  : EventMsgType;       VAR wkmp  : Int16;        VAR ierr  : Int16        ); FORWARD;       PROCEDURE SregTemplateBuild      (     userpid    : Int16;           toppid     : Int16;           sp         : Int16;       VAR stack      : TemplateControlStack;        VAR report     : PathReportRecord;        VAR dynamicptr : Int16;       VAR ierr       : Int16  );FORWARD;       $PAGE   !{---------------------------------------------------------------}  ! !{   BUILD PATH                                            (100) }  ! !{---------------------------------------------------------------}  !     PROCEDURE BuildPath ( VAR pathreport  : PathReportRecord;                             vnaptr      : Int16;                        VAR stack       : PathStackType;                            sp          : Int16;                        VAR down_ref    : Int16;                        VAR down_pid    : Int16;                        VAR wkmp        : Int16;                        VAR ierr        : Int16 );      {}  { Abstract:    {  Converts a path described by a path report into a determinate    {  path structure that can be used by a node's protocol handlers   {  to send messages to a target connect-site.   {   
{ Input parameters:  
 {    {  pathreport: The path report containing the path description.    {   {  vnaptr: Index into the path report. The virtual network  {     address to be used when building the d-path begins at   
{     pathreport[vnaptr].  
 {   {  stack: A stack of protocol identifiers (pids) and indices  {     into the path report. The top entry on the stack will be  {     a pid, the next lowest an index to the pids path element  {     entry in the path report. Pids and path report indices   {     are arranged in this alternating fashion down through the    {     stack. The last stack entry, stack[0], contains the pid    {     of the protocol (or service) that will be the user of this   {     path: this entry will probably always refer to IPC.   {   {  sp: Current top of stack.  {   
{ Output parameters: 
 {   !{  down_ref: Down path reference to determinate record topmost in  ! {     the path.   {    {  down_pid: Protocol identifier of the topmost protocol in the    {     path. Note that this value doesn't refer to the path's  {     user, but rather to the protocol that the user will be  
{     running atop.  
 {}      LABEL 99;       VAR      current_pid : Int16;      elementptr  : Int16;      options     : PathOptionsRecord;      up_pid      : Int16;       BEGIN   down_pid := MEANINGLESS;  down_ref := MEANINGLESS;  
ierr := SUCCESSFUL;  
     { Each protocol that may be referenced by a path report's path  { will have a routine which can interpret its corresponding   { part(s) of the path report and construct a determinate path   { record from it. The loop below merely invokes each of these   { routines for each pid and path-report-index pair.   {}  WHILE ((sp <> 0) AND (ierr = SUCCESSFUL)) DO     BEGIN     { Pop pid off the stack, then pop path report index off.      {}      current_pid := stack[sp];     sp := sp - 1;     elementptr := stack[sp];      sp := sp - 1;         { Fetch the pid of the protocol that will run on top of the     { current protocol but don't pop it off the stack.      {}      up_pid := stack[sp];          { Now invoke the routine appropriate for building the next      { part of the path. Note that these routines return new     { down_pid and down_ref values. These new values will be      { appropriate down values when we invoke the next     { highest level protocol to build its part of the path.     {}      CASE current_pid OF      !      TCP: TcpBuildPath ( pathreport, vnaptr, elementptr, up_pid,  ! "                          down_pid, down_ref, options, wkmp, ierr ); "     "      HP_PXP: PxpBuildPath ( pathreport, vnaptr, elementptr, up_pid, " "                          down_pid, down_ref, options, wkmp, ierr);  "     !      IP:  IpBuildPath  ( pathreport, vnaptr, elementptr, up_pid,  ! "                          down_pid, down_ref, options, wkmp, ierr);  "     !      IEEE_802: IEEE802BuildPath (pathreport, vnaptr, elementptr,  ! #                                 up_pid, down_pid, down_ref, options,  #                                  wkmp, ierr);             OTHERWISE            ierr := U_INTERNALERR;         END; {CASE current_pid}       	   END; {WHILE sp} 	     99:;  END; {BuildPath}      $PAGE   !{---------------------------------------------------------------}  ! !{   BUILD C SITE REPORT                                   (200) }  ! !{---------------------------------------------------------------}  !     
PROCEDURE BuildCSiteReport 
    ( VAR pathreport     : PathReportRecord;            vnaptr         : Int16;       VAR stack          : PathStackType;           sp             : Int16;       VAR ierr           : Int16 );      {}  { Abstract;   {  Constructs a connect-site path report from a conglomeration  {  of information contained in an extended nodal path report.   {  A stack containing pointers into the path report references  {  important protocol elements. The protocol elements are the   {  ones to be used to construct a new path in the connect-site  {  report.  {   
{ Input parameters:  
 {   "{  pathreport: An ordinary nodal path report with a single protocol  " {     element appended to it.   {    {  vnaptr: A byte index pointer into the nodal path report that    {     references a Virtual Network Address (VNA) component.   {     This VNA component should be used as the basis for the  {     for the VNA to be included in the connect-site report.  {   {  stack: A stack of Protocol ID (PID) and byte index pointer   {     pairs. The pointers reference those protocol elements in  {     nodal path report that should be used when constructing   {     the new connect-site path report.   {   
{ Output parameters: 
 {   "{  pathreport: The newly constructed connect-site path report. This  " {     report will overlay the nodal report that was passed in.  {    {  ierr: Returns SUCCESSFUL (=0) if the call was successful and    {     U_INTERNALERR (=111) if not.  {}      CONST   
   VNA_OFFSET        = 2;  
 
   PATHLEN_OFFSET    = 5;  
 
   PREPORTLEN_OFFSET = 0;  
 
   DOMAINLEN_OFFSET  = 1;  
     VAR   
   elementlen     : Int16; 
 
   i              : Int16; 
 
   iword          : Int16; 
 
   newelementlen  : Int16; 
 
   temp           : Int16; 
 
   tempsp         : Int16; 
     BEGIN   { We're going to be building the new connect-site path report   { in the same buffer that now contains our nodal path report.   { While building we don't want to lose -- by overlaying -- any   { of the nodal path report information that we need. Therefore,    { we shift the entire nodal path report and accompanying  { free-floating protocol element further down into the buffer.  { The number of words we shift by is set by the length of the   "{ free-floating element. We then build the connect-site path report  " "{ from the top of the buffer. If we had more time we could probably  " { figure out a much more efficient way to do this.  {    { First we compute the word length of the free-floating element,   { then we shift everything down.  {}   temp := stack[1] + 1;  {byte index to protocol element's length}   newelementlen := (pathreport.bytes[temp] + 3) DIV 2;      "{ Figure out the word length of path report + protocol element. Then " { shift everything down.  {}  &temp := pathreport.ints[PREPORTLEN_OFFSET] DIV 2 + 1; {path report word len} &  FOR iword := (temp + newelementlen) DOWNTO PREPORTLEN_OFFSET DO    "   pathreport.ints[iword + newelementlen] := pathreport.ints[iword]; "     !{ Next we copy the to-be-included VNA from its (shifted) position  ! !{ into the position it will occupy in the new connect-site report. ! {}  temp := vnaptr DIV 2 + newelementlen; {convert to word index}   	FOR i := 0 TO 2 DO 	    BEGIN     pathreport.ints[VNA_OFFSET+i] := pathreport.ints[temp+i];     END; {FOR}       !pathreport.ints[PATHLEN_OFFSET] := 0; {zero out the path's length} !     { Now we copy the protocol elements that our stack references.  { So that we don't inadvertently overlay any information that   { we'll need later, we copy topmost path elements first    { even though the stack is oriented from bottom-most to topmost.   {}  iword := PATHLEN_OFFSET + 1;  tempsp := 1;  WHILE (tempsp <= sp) DO      BEGIN     { We observe here that stack[tempsp] holds the byte index     { of the protocol element that we want to copy next.      {}      temp := stack[tempsp] + 2 * newelementlen;          { Determine the length of the protocol element in bytes      { and then increment the length of our connect-site report's       { path by this amount. We watch out for elements that have      { pad bytes.      {}      elementlen := pathreport.bytes[temp + 1] + 2;     IF Odd(elementlen) THEN elementlen := elementlen + 1;  #   pathreport.ints[PATHLEN_OFFSET] := pathreport.ints[PATHLEN_OFFSET]  #                                         + elementlen;       "   { Now we're ready to copy the protocol element. For efficiency we "    { want to do this word-by-word not byte-by-byte.      {}      temp := temp DIV 2; {convert to word index}     elementlen := elementlen DIV 2;     FOR i := 1 TO elementlen DO        BEGIN         pathreport.ints[iword] := pathreport.ints[temp];  
      iword := iword + 1;  
       temp := temp + 1;         END; {FOR}      #   tempsp := tempsp + 2; {bump stack index to reference next protocol  #                           element index}     END; {WHILE}        { Lastly, we compute our connect-site report's domain length and   !{ report length. We put these values into the appropriate fields.  ! {}  %pathreport.ints[DOMAINLEN_OFFSET] := pathreport.ints[PATHLEN_OFFSET] + 8;  % &pathreport.ints[PREPORTLEN_OFFSET] := pathreport.ints[DOMAINLEN_OFFSET] + 2; & END; {BuildCSiteReport}       $PAGE   !{---------------------------------------------------------------}  ! !{   CHARGE N ATTACH REPORT                                (300) }  ! !{---------------------------------------------------------------}  !     PROCEDURE ChargeNAttachReport      {     urecid      : Int16;        VAR pathreport  : PathReportRecord;       VAR lsd         : Int16;        VAR sokind      : Int16;        VAR ierr        : Int16 };       {}  { Abstract:    {  This routine may be used to store a path report into DSAM. It   !{  does this by charging the space taken up by the report against  !  {  the special path memory socket. Once it has been placed into     {  mbufs a descriptor for the report is created and linkded into   {  the UserRecord of the user that wanted the report.   {}      LABEL 99;       VAR   
   gsd      : Int16; 
 
   urec     : UserRecord;  
     BEGIN   { Try to put the path report into DSAM. Attempt to charge the   { memory required against the special path memory socket.   { If the memory can't be obtained then that fact will be  { logged by SoChargePath().   {}  SoChargePath (urecid, pathreport.int, gsd, ierr);   IF (ierr <> SUCCESSFUL) THEN GOTO 99;        { Now try to insert the gsd for the stored path report into the    { user's descriptor map.  {}  DS_URFetchElement (urecid, urec.int);   AttachSoToUser (urec, gsd, lsd);  DS_URStoreElement (urecid, urec.int);   sokind := VC; {must change when other socket kinds suported}      99:;  
END; {ChargeNAttachReport} 
     $PAGE   !{---------------------------------------------------------------}  ! !{   CONVERT REPORT                                        (400) }  ! !{---------------------------------------------------------------}  !     PROCEDURE ConvertReport (     opcode     : Int16;                                 userpid    : Int16;                             VAR pathrep    : PathReportRecord;                            VAR downpath   : Int16;                             VAR downpid    : Int16;                             VAR wkmp       : Int16;                             VAR ierr       : Int16 );       {}  { Abstract:   !{  This routine can be used to perform a variety of "conversions"  ! {  on path reports. The type of conversion to be performed  {  depends upon which opcode is passed.   {   {  opcode: Passed by the caller to indicate which type of   {     conversion operation should be performed:   {   {     CR_CSREP_TO_DPATH (=1): Convert the information in a  {        connect-site path report into a d-path that can be   {        used by system protocols to access the object  {        that the connect-site report references.   !{        If the passed connect-site report contains multiple paths !  {        then ConvertReport() employs some special heuristics to   "{        discover the optimum path and then uses the information in  " {        that path to build the d-path. A special routine,  !{        ExaminePath(), is used to produce a "goodness" score for  ! !{        each path. Once the most viable path (i.e., the one with  ! {        the highest goodness score) has been    {        chosen, the routine BuildPath() is invoked to actually    {        control the d-path construction.   {   {     CR_NODREP_TO_DPATH (=2): Convert nodal path report  {        information into a d-path that can be used to access   {        a "well-known" NS service (e.g., Socket Registry).   "{        To build such a path some knowledge of well-known addresses " {        is required.   {   {     CR_NODREP_TO_CSREP (=3): Convert a combination of nodal   {        path report and "isolated" address information   {        into a connect-site path report. The isolated address  {        would typically be a TCP port number, and   {        the nodal path report would reference some remote node.   {        The returned connect-site report would contain a path  {        describing how to establish communication with the   {        isolated address on the remote node. The isolated   {        address is passed inside an "isolated protocol element"   {        and that protocol element is appended to the passed  {        nodal path report.   {   "{  userpid: The Protocol ID (PID) of the protocol that will use the  " "{     path. At first release the only supported user protocols will  " {     be IPC, SREG, and RAW.  {    {  pathrep: The connect-site or nodal path report that is to be    {     converted.  {   "{  downpath: If opcode=3 then downpath is a pointer to the isolated  " !{     protocol element that should be merged with the nodal report ! {     information to form a connect-site path report.   {    {  downpid: If opcode=3 then downpid is the PID of the protocol     {     that should lie at the top of the path in the connect-site   {     report that we're to generate.  {   
{ Output Parameters: 
 {   !{  downpath: A reference to the protocol record that the d-path's  ! {     topmost protocol has linked into the d-path. This is the  {     down path reference that the path's user should refer to  {     on subsequent manipulations of the path. This value is  {     meaningless if ierr does not return SUCCESSFUL.   {    {  downpid: The Protocol ID (PID) of the topmost protocol linked   {     into the d-path.  {    {  ierr: Returns either SUCCESSFUL or the resultant error code.    {}      LABEL 99;       CONST      { As we examine each of the alternative paths in a path     { report we generate a "goodness" score.      { A score of SUFFICIENT means that a reasonable d-path can      { be constructed from the path, whereas a score higher      { than sufficient implies that the path has some property     { which makes it more attractive than one which is merely     { SUFFICIENT.     {}   
   SUFFICIENT        = 1;  
        { These constants are used for comparisons with the fields      { and/or values in the path report.     {}       MIN_PATHREP_LEN      = 8; {min acceptable path report length}   !   MIN_DOMAINREP_LEN    = 2; {min acceptable domain report length} !    CURRENT_VERSION      = 0;     MIN_PATH_LEN         = 0; {min acceptable path length}       VAR      bestscore   : Int16;      bestsp      : Int16;      bestvnaptr  : Int16;      eopathrep   : Int16;      eodomainrep : Int16;      eopath      : Int16;      hopcnt      : Int16;      i           : Int16;      ibyte       : Int16;   
   nets_match  : BOOLEAN;  
    stack       : PathStackType;      tempscore   : Int16;      tempsp      : Int16;      tempstack   : PathStackType;      vnaptr      : Int16;      vnarec      : VnaRecord;          PROCEDURE Escape ( error : Int16 );        BEGIN   
      ierr := error; 
       GOTO 99;  
      END; {Escape}  
     BEGIN {ConvertReport}   eopathrep := pathrep.ints[0]; {get the length}   IF (eopathrep < MIN_PATHREP_LEN) THEN Escape ( U_BAD_PATH_LEN );   eopathrep := eopathrep + 2; {first byte beyond the end}       bestscore := 0;   bestsp := 0;      ibyte := 2;   WHILE (ibyte < eopathrep) DO     BEGIN     eodomainrep := pathrep.ints[ibyte DIV 2]; {get length}   #   IF (eodomainrep < MIN_DOMAINREP_LEN) THEN Escape (U_BAD_PATH_LEN);  #    ibyte := ibyte + 2; {index virtual network address}     eodomainrep := eodomainrep + ibyte;     IF (eodomainrep > eopathrep) THEN Escape ( U_BAD_PATH_LEN);      
   vnaptr := ibyte;  
     !   { Examine the version of this domain report. If we don't speak  !    { it then we must skip to the next domain report.     {}      IF (pathrep.bytes[ibyte] <> CURRENT_VERSION) THEN        BEGIN         ibyte := eodomainrep;         END      ELSE IF (pathrep.bytes[ibyte + 1] <> HPDSN_DOMAIN) THEN        BEGIN         ibyte := eodomainrep; {unknown domain}        END      ELSE         BEGIN          { Look at the virtual network address and try to determine   !      { the number of network hops to the target node. We can use  ! !      { this hop count later as part of our path's goodness score  !       { determination. Also, if the hop count is zero then we         { set nets_match to TRUE.         {}        FOR i := 0 TO 2 DO           BEGIN           vnarec.ints[i] := pathrep.ints[ibyte DIV 2 + i];            END; {FOR i};        IpVnaCompare ( vnarec, hopcnt, ierr);         IF (ierr = SUCCESSFUL) THEN            BEGIN           nets_match := (hopcnt = 0);  "         ibyte := ibyte + 6; {skip over VNA to start of first path}  "          END        ELSE           BEGIN            { We know nothing at all about the referenced network,             { therefore we must reject this domain report.            {}            ibyte := eodomainrep;           END; {IF ierr}         END; {IF pathrep}       "   { Examine each path within the domain report. If we discover one  " !   { that appears to be better than the one we previously accepted !    { then we replace the old with the new.     {}      WHILE (ibyte < eodomainrep) DO         BEGIN         eopath := pathrep.ints[ibyte DIV 2];        IF (eopath < MIN_PATH_LEN) THEN Escape (U_BAD_PATH_LEN);  
      ibyte := ibyte + 2;  
       eopath := eopath + ibyte;          IF (eopath > eodomainrep) THEN Escape ( U_BAD_PATH_LEN );              { Examine the path elements comprising the path. If the         { path is viable then the goodness score returned by        { ExaminePath() may be used to decide whether the path        { just examined is better than the ones we looked at        { before.         {}        tempstack[0] := userpid;        tempsp := 0; {init top of stack pointer}        IF (opcode = CR_NODREP_TO_CSREP) THEN            BEGIN  "         { We're trying to build a connect-site report by combining  " "         { information from a nodal report with an isolated protocol "          { element. We handle this case specially by partially  #         { initializing the protocol element stack that ExaminePath()  # !         { will manipulate. We provide ExaminePath() with a "hint  ! "         { to get started" by pushing the isolated protocol element  " 
         { onto the stack. 
          {}   #         tempstack[1] := downpath; {ptr to isolated protocol element}  #          tempstack[2] := downpid;   !         tempsp := 2; {tell ExaminePath() that stack isn't empty}  !          END; {IF opcode=CR_NODREP_TO_CSREP}             ExaminePath (opcode, ibyte, tempscore, tempstack, tempsp,                       nets_match, eopath, pathrep, ierr);            IF (ierr <> SUCCESSFUL) THEN Escape (ierr);             IF (tempscore > bestscore) THEN            BEGIN           { We replace the old path.            {}            bestscore := tempscore;           bestvnaptr := vnaptr;           FOR i := 0 TO tempsp DO stack[i] := tempstack[i];  
         bestsp := tempsp; 
          END; {IF tempscore}        END; {WHILE ibyte < eodomainrep}     END; {WHILE ibyte < eopathrep}       "{ If an acceptable path was discovered then, depending on the opcode " !{ specified, we'll try to build either a d-path or a connect-site  ! { path report.  {}  IF (bestscore < SUFFICIENT) THEN     BEGIN     ierr := U_NO_USEABLE_PATHS;     END  ELSE IF (opcode = CR_NODREP_TO_CSREP) THEN     BEGIN  #   { We need to use the information referenced by our protocol element #    { stack to build a connect-site path report.      {}       BuildCSiteReport (pathrep, bestvnaptr, stack, bestsp, ierr);       END  ELSE     BEGIN  #   BuildPath ( pathrep, bestvnaptr, stack, bestsp, downpath, downpid,  #                wkmp, ierr);      END; {IF bestscore}      99:;  
END; {ConvertReport} 
     $PAGE   !{---------------------------------------------------------------}  ! !{   ENV NAME CHECK                                        (500) }  ! !{---------------------------------------------------------------}  !     PROCEDURE EnvNameCheck { VAR namestr   : EnvironStringType;                            VAR namelen   : Int16;                            VAR ierr      : Int16 };       {}  { Abstract:    {  Accepts what presumably is a legal, hierarchical, environment   {  name and checks to see if it is correct and complete. An   {  incomplete name is one which doesn't have all of the parts   {  necessary to make the name "fully qualified." A fully  {  qualified name has three parts and takes the form  {  <object_part>.<domain_part>.<organization_part>.    {  Users may default any or all of the parts. EnvNameCheck will    {  fill in any of the parts that have been defaulted. It will   {  also shift any lower case characters to upper case.  {   
{ Input parameters:  
 {   {  namestr: The array of characters containing the name.  {   {  namelen: The length of the name in the namestr parameter.  {   
{ Output parameters: 
 {    {  namelen: The new name length, i.e., a longer one in case the    {     passed in name wasn't fully qualified.  {   {  ierr: Returns either SUCCESSFUL or else an error code.   {}      LABEL 99;       VAR       hierarchy      : Int16; {records which part of the name we're                               currently looking at}   
   namepartlen    : Int16; 
    scanptr        : Int16; {index into the name string}          PROCEDURE Escape ( error : Int16 );        BEGIN   
      ierr := error; 
       GOTO 99;  
      END; {Escape}  
     BEGIN   hierarchy := 1; {look at the object_part of the name first}   scanptr := 0;       REPEAT  !   { Try to find out how long the next unexamined part of the name ! !   { is. Also check for illegal characters, and upshift lower case !    { characters.     {}       ScanAndShift (namestr, namelen, scanptr, namepartlen, ierr);       IF (ierr <> SUCCESSFUL) THEN Escape (ierr);         IF (namepartlen = 0) THEN        BEGIN         { We need to add default values for one or more of the        { name parts in order to produce a fully qualified name.  !      { Before doing this, though, we make one last syntax check,  !        { i.e., to make sure the user didn't try to end the passed         { name with a period.         {}  %      IF (namestr.chars[scanptr] = '.') THEN Escape(U_ILLEGAL_NODE_NAME);  %           FinishName (namestr, hierarchy, scanptr);   
      namelen := scanptr;  
       hierarchy := 4; {indicates that we're finished}         END      ELSE         BEGIN         { We have a name for which  0 < namelen <= 16.        {}        hierarchy := hierarchy + 1;         END; {IF namepartlen}   
   UNTIL (hierarchy = 4);  
      IF ((scanptr <> namelen) OR (namestr.chars[scanptr] = '.')) THEN      BEGIN     { The name contains too many levels of hierarchy or else it     { ends with a dot.      {}      Escape (U_ILLEGAL_NODE_NAME);  
   END; {IF scanptr} 
     99:;  
END; {EnvNameCheck}  
     $PAGE    {-------------------------------------------------------------}     {   EXAMINE PATH                                        (600) }     {-------------------------------------------------------------}        PROCEDURE ExaminePath {     opcode      : Int16;                          VAR ibyte       : Int16;                          VAR score       : Int16;                          VAR stack       : PathStackType;                          VAR sp          : Int16;                              nets_match  : BOOLEAN;                          VAR eopath      : Int16;                          VAR pathrep     : PathReportRecord;                           VAR ierr        : Int16 };      {}  { Abstract:   {  Examines a single path in the path report passed to  {  ConvertReport(). If the path has something wrong with it   {  then an error will be returned. If not a "goodness" score  !{  will be computed for the path, and a stack will be initialized. ! {  Path record indices and pids (in that order) will be pushed  {  onto the stack for each valid path element examined.   {  A stack constructed in this way can subsequently be used to  {  build protocol paths from bottom to top.   {   
{ Input parameters:  
 {   {  opcode: Qualifies the kind of path being examined:   {   ${     CR_CSREP_TO_DPATH (=1): The path report is a connect-site report.  $ {   {     CR_NODREP_TO_DPATH (=2):  !{        The path report is a nodal report. We should examine the  ! {        path to see if we can somehow come up with a viable   {        way to use the protocols referenced within it to access   {        the well-known NS service whose PID was passed in  	{        stack[0]. 	 {   {     CR_NODREP_TO_CSITE (=3):  {        Arguement "pathrep" contains a nodal path report. The  {        stack already has pushed upon it a reference to an   {        individual (as opposed to a group) protocol element.    {        This protocol element holds a reference to a particular   {        protocol address (e.g., TCP port 255).   {        We want to examine the path to see if we can combine    {        its information with the individual protocol element's    {        information to create a description of a viable path   {        to the particular address.   {   {  ibyte: Path record index. On input this value should index   {     the first byte of the first path element of the path.   {     Note that on input ibyte does NOT index the first byte  {     of the path's length field.   {   {  stack[0]: The pid of the protocol that will run on top of  {     the path report we're to examine. At first release this   {     pid will probably always be IPC.  {   {  stack[1]: If opcode=3 then a pointer to the location within  {     the passed nodal path report that contains the special  {     individual protocol element.  {   ${  stack[2]: If opcode=3 then stack[2] contains the PID of the protocol  $ !{     that we want to see at the top of the path that we're trying ! 	{     to evaluate. 	 {   #{  sp: Pointer to top of stack. Will usually be set to zero on input,  # "{     unless the request is a CR_NODREP_TO_CSITE in which case there " #{     will already be several entries on the stack as described above. # {   
{ Output parameters: 
 {   {  ibyte: Indexes the first byte beyond the end of the path.  {   {  score: Goodness score assigned to the path. This score   {     offers a relative measure of the path's acceptability.  {     Higher scores reflect better paths.   {   {  stack[1..sp]: Alternating PIDs and path report indices.  {     The PIDs reference only individual protocols and not  {     protocol groups. If positive, the path report indices   {     are byte offsets to protocol elements in the path   {     report. If negative, the path report indices are  {     negatives of PIDs.  {   {  sp: Pointer to the top of the stack.   {}      LABEL 99;       CONST      { These constants are used to generate "goodness" scores      { for each of the paths in the path report being evaluated.     { A score of SUFFICIENT means that a reasonable d-path can      { be constructed from the report, whereas a score higher      { than sufficient implies that the path has some property     { which makes it more attractive than one which is merely     { SUFFICIENT.     {}   
   SUFFICIENT        = 1;  
    LOCAL_NO_SUBIP    = 300;      LOCAL_AND_SUBIP   = 301;      MAX_HOPS          = 299;       VAR   
   elementlen     : Int16; 
 
   hopcnt         : Int16; 
 
   pid            : Int16; 
    protorec       : ProtocolRecord;      servicemap     : ProtocolMapType;  
   upuser         : Int16; 
        PROCEDURE RejectPath;        BEGIN         ibyte := eopath;  	      score := 0;  	       GOTO 99;        END; {RejectPath}           
BEGIN {ExaminePath}  
 ierr := SUCCESSFUL; {assume to start}   score := 0;   
IF (opcode = 3) THEN 
    BEGIN      { The stack has already been partially initialized. Position       { stack[1] contains a pointer to a protocol element, and      { position stack[2] contains the PID of the protocol that     { that element is associated with.      {}      upuser := stack[2];     sp := 2;      END  ELSE     BEGIN     upuser := stack[0];     score := 0;     END; {IF opcode = 3}       
WHILE (ibyte < eopath) DO  
    BEGIN     { Get the next pid. Then push the current values of ibyte     { and pid onto the stack.     {}      pid := pathrep.bytes[ibyte];      sp := sp + 1;     stack[sp] := ibyte;     sp := sp + 1;  
   stack[sp] := pid; 
        { Dig out the path element's length.      {}      ibyte := ibyte + 1;     elementlen := pathrep.bytes[ibyte];     ibyte := ibyte + 1;          { We process individual path elements differently than group       { path elements. We let the appropriate protocols evaluate      { the individual elements after we've extracted the best      { path and built a stack. Group elements, however, are      { evaluated earlier so that we can determine if they      { offer the services/protocols we'll need to set up a     { determinate path to the appropriate remote connect-site.      {}      IF ((pid >= FIRST_INDIVIDUAL_PID) AND  #                                    (pid <= LAST_INDIVIDUAL_PID)) THEN #       BEGIN         { Set index to reference the next path element.         {}        ibyte := ibyte + elementlen;        IF Odd(elementlen) THEN ibyte := ibyte + 1;             { See if in our node the referenced lower level protocol        { supports the referenced upper level protocol. If it         { doesn't then we must reject the path. Note that if our         { node doesn't support the lower level protocol then we'll         { discover that fact here.        {}        DS_FetchElement (DS_ProtosTD, upuser, protorec.int);        IF (NOT protorec.pr_supportingpids.bits[pid]) THEN           BEGIN           RejectPath; {We don't support the adjacency.}           END; {IF NOT protorec}              { We keep going, we'll now start treating the lower level          { protocol as somebody else's upper level protocol.         {}  
      upuser := pid; 
       END   #   ELSE IF ((pid >= FIRST_GROUP_PID) AND (pid <= LAST_GROUP_PID))THEN  #       BEGIN   "      { Now we're dealing with group path elements. In this section  "       { we'll sometimes do a little fancy footwork in order to  "      { construct a "connect-site stack" out of a nodal path report. "       {}        IF (pid = ADS_SERVICES) THEN           BEGIN           { We first check that the length of this element is  
         { correct.  
          {}            IF (elementlen <> 2) THEN RejectPath; {bad syntax}                IF (upuser = SREG) THEN  	            BEGIN  	 !            { We check to see if the SREG service is supported by  !             { the node. If not then we must reject the path.  !            { Note that there is some controversy about how other  !             { systems will deal with the bit maps in the group               { element path entries. For now we're assuming that    !            { the bits are important and that we won't attempt to  ! !            { connect to a remote service unless the bits tell us  !             { its a reasonable thing to do.               {}              servicemap.bytes[1] := pathrep.bytes[ibyte];  #            IF (NOT servicemap.bits[2]) THEN RejectPath; {no support}  #             END            ELSE IF (upuser <> TCP) THEN   	            BEGIN  	              { We don't know of any other up user besides TCP and                { SREG for which we're able to use nodal path report   
            { information. 
             {}              RejectPath;               END; {IF upuser}      !         { Increment our index so it references the next protocol  ! !         { element. Also pop the services group reference off the  !           { stack -- we won't need it to build either a d-path or            { a connect-site path report.           {}            ibyte := ibyte + elementlen;            sp := sp - 2;           END        ELSE IF (pid = ADS_TRANSPORTS) THEN            BEGIN           { First we check that the element length is correct &           { if not we reject the path.            {}            IF (elementlen <> 2) THEN RejectPath; {bad syntax}                IF (upuser = SREG) THEN  	            BEGIN  	             { We need to verify that the remote node supports               { PXP since it is the only               { way that our socket registry software knows how to               { consult remote socket registries.               {}              servicemap.bytes[1] := pathrep.bytes[ibyte];  #            IF (NOT servicemap.bits[2]) THEN RejectPath; {no support}  #                  { Now we play with the stack a bit. We make the top                 { entry refer to HP_PXP but make the top path report               { pointer the negative of the SREG pid. The HP_PXP  "            { path building routine should understand that negative  "              { path pointers are requests for well-known address                { bindings.               {}              stack[sp-1] := -SREG;               stack[sp] := HP_PXP;              upuser := HP_PXP;               END            ELSE IF (upuser = TCP) THEN  	            BEGIN  	 #            { First we need to make sure that the remote node supports # !            { TCP over the path we're currently examining -- if it !             { doesn't then we must reject the path.               {}              servicemap.bytes[1] := pathrep.bytes[ibyte];  #            IF (NOT servicemap.bits[1]) THEN RejectPath; {no support}  #     "            { Here we can pop the references to the transport group  "             { protocol element from our stack.              {}  
            sp := sp - 2;  
             END            ELSE   	            BEGIN  	              { We don't know how to build a path from a transport                { group element that the referenced user could use.                {}              RejectPath;               END; {IF upuser}               ibyte := ibyte + elementlen;            END; {IF upuser = SREG}        END      ELSE         BEGIN         { We don't know anything about the protocol that the        { report references and therefore must reject the path.         {}  	      RejectPath;  	       END; {IF pid >= FIRST_INDIVIDUAL_PID}               { Make sure that the length of the element we just processed       { wasn't incorrect.     {}      IF (ibyte > eopath) THEN         BEGIN         ierr := U_BAD_PATH_LEN;         GOTO 99;        END; {IF ibyte}           { If the pid = IP then we're guaranteed to have a sufficient        { path. In addition, we try to decide if the path is a local       { path and one which should be favored over others.     {}      IF (pid = IP) THEN         BEGIN   
      score := SUFFICIENT; 
       IF (NOT nets_match) THEN           BEGIN  !         { The target machine is not on a network to which we are  !           { directly connected. Therefore we can afford to ignore            { the remainder of the path.            {}   
         ibyte := eopath;  
          END        ELSE IF (ibyte = eopath) THEN            BEGIN            { The target machine is on a directly connected network            { but we weren't provided with any sub-IP addressing            { information. Deriving the sub-IP addresses we need            { might require some additional effort.           {}            score := score + LOCAL_NO_SUBIP;            END        ELSE           BEGIN           { The path is sufficient. The target node is directly           { connected. And also, sub-IP addressing information            { was provided.           {}            score := score + LOCAL_AND_SUBIP;           END; {IF NOT}            { One last note with respect to IP. If the IP path        { building routine sees an entry with dispatch address        { equal to zero is should assume that the entry was         { part of a nodal path report and that any provided         { dispatch address would have been ambiguous. IP should         { figure out which well-known dispatch address to use.        {}        END; {IF pid = IP}     END; {WHILE ibyte}   99:;  	END; {ExaminePath} 	     $PAGE   !{----------------------------------------------------------------} ! !{   FINISH NAME                                            (700) } ! !{----------------------------------------------------------------} !     PROCEDURE FinishName { VAR namestr    : EnvironStringType;                             hierarchy  : Int16;                         VAR curptr     : Int16 };      {}  { Abstract:   !{  This routine should be called to fill in the defaulted parts of ! !{  an environment name. The defaulted parts are copied out of the  ! {  local node's NodeRecord where they must have been placed as  {  part of the initialization process.  {   
{ Input parameters:  
 {   {  namestr: The name string as it exists so far.  {   "{  hierarchy: The lowest level part of the name that must be filled  " {     in: 1=object_part, 2=domain_part, 3=org_part.   {   !{  curptr: Index to the last character already in the name string. !  {     This value may be zero if the entire name were defaulted.    {   
{ Output parameter:  
 {   {  curptr: Indexes the last character added to the name.  {}      VAR   "   defaultstart   : Int16; {position in the NodeRecord's namestring  " !                            from which the defaulted parts of the  !                             name should be copied}     i           : Int16;      noderec     : NodeRecord;      BEGIN   DS_FetchElement (DS_NodesTD, 1, noderec.int);   WITH noderec DO      BEGIN  
   CASE hierarchy OF 
       1: defaultstart := 1;         2: defaultstart := nr_domainstart;        3: defaultstart := nr_orgstart;   	      END; {CASE}  	        FOR i := defaultstart TO nr_nodenamelen DO         BEGIN         curptr := curptr + 1;         namestr.chars[curptr] := nr_nodename.chars[i];  	      END; {FOR i} 	    END; {WITH}  	END; {FinishName}  	     $PAGE   !{---------------------------------------------------------------}  ! !{   MAKE C SITE REPORT                                    (800) }  ! !{---------------------------------------------------------------}  !     
PROCEDURE MakeCSiteReport  
    { VAR protoelement      : SocketNameType;       VAR elementlen        : Int16;        VAR preport           : PathReportRecord;       VAR preportlen        : Int16;        VAR wkmp              : Int16;        VAR ierr              : Int16 };       {}  { Abstract:    {  This routine tries to build a connect-site path report from a   {  nodal path report and a protocol element. Such an operation  #{  is useful when servicing IpcDest() requests. Once the connect-site  # {  path report has been constructed it is placed into the   {  NodalRegistry's database.  {}      VAR   
   dnpath   : Int16; 
 
   dnpid    : Int16; 
 
   i        : Int16; 
     BEGIN   !{ First we append the protocol elemtn to the tail end of the nodal ! { path report.  {}  FOR i := 1 TO elementlen DO      preport.bytes[preportlen + i -1] := protoelement.bytes[i];       dnpath := preportlen; {pointer to appended protocol element}  "dnpid := protoelement.bytes[1]; {draw PID from the protocol element} "      ConvertReport (CR_NODREP_TO_CSREP, IPC, preport, dnpath, dnpid,                   wkmp, ierr);       END; {MakeCSiteReport}      $PAGE   !{---------------------------------------------------------------}  ! !{   N Reg Add                                             (900) }  ! !{---------------------------------------------------------------}  !     PROCEDURE NRegAdd { VAR ndrec  : NDRecord;                          options: MMFlagsType;                       VAR ierr   : Int16      };      {}  { Abstract:   #{  This routine should be called to add entries to the NReg database.  # {  Added entries are stored in mbufs. When such an entry   {  describes the local node then its mbufid is entered into the    {  local node's NodeRecord and a check is made to see if  !{  Probe's unsolicited reply timer should be set. The caller must  ! {  be critical.   {   
{ Input parameters:  
 {   "{  ndrec: A nodal descriptor record containing, among other things,  "  {     the name and path report of the node whose entry is being    {     added.  {    {  options.bits[-1]: If set then the passed entry should be used   "{     to overwrite any entry already in the table that is associated " 
{     with the same name.  
 {}      LABEL 99;       VAR   
   i        : Int16; 
    match    : BOOLEAN;  
   mbufid   : Int16; 
 
   mmflags  : MMFlagsType; 
 
   namelen  : Int16; 
 
   noderec  : NodeRecord;  
 
   pathgsd  : Int16; 
 
   temp     : Int16; 
        PROCEDURE Escape ( error : Int16 );        BEGIN   
      ierr := error; 
       GOTO 99;  
      END; {Escape}  
     BEGIN   { Fetch the name out of the NDRecord. Then see if the name has  { already been entered into the NReg database. If it has then   { we might want to try to overwrite the current entry.  {}  WITH ndrec DO      BEGIN     namelen := nd_nameinfo.nlen;      NRegFind (nd_name, namelen, mbufid, temp, temp, ierr);      IF (ierr <> SUCCESSFUL) THEN Escape (ierr);         IF (mbufid <> NULL) THEN         BEGIN   !      { An entry with a matching name is already entered into the  !        { nodal database. We should either purge the entry or else         { report an error to the caller.        {}         IF (NOT options.bits[-1]) THEN Escape (U_DUPLICATE_NAME);              NRegPurge (nd_name, namelen, ierr);         IF (ierr <> SUCCESSFUL) THEN           BEGIN           SRegLogError (LOC_900_PURGING, ierr);           Escape (U_INTERNALERR);           END; {IF ierr}         END; {IF mbufid}         { TESTBED: We don't have a true hash table yet. For now we   !   {  merely add NDRecords to a linked list that closely resembles !    {  what an equivlence class would look like.      {}      DS_FetchElement (DS_TrackTD, TL_NODE_LIST, i);   "   Adrof(i, 0, vectdbuf[1]); {using 'i' as internalndrec.in_nxtptr}  " 
   vectdbuf[2] := 2; 
    Adrof(ndrec.int, 0, vectdbuf[3]);     vectdbuf[4] := ndrec.nd_length;         { Now we attempt to store our nodal path report into DSAM.      { We charge the required DSAM space against the special     { Probe socket. We don't borrow from the general pool if      { the space we need isn't available.      {}      DS_FetchElement (DS_TrackTD, TL_PROBE_SOCKET, pathgsd);     { mmflags.int := 0;     { mmflags.bits[-1] := TRUE;     { mmflags.bits[-2] := TRUE;     {}   
   mmflags.int := 6; 
 #   temp := ndrec.nd_length + 2; {ndrec plus internal ndrec's nxt ptr}  # $   DS_SBPut (vectdbuf, 8, pathgsd * 2 -1, mmflags, mbufid, temp, ierr);  $    IF (ierr <> SUCCESSFUL) THEN         BEGIN         { Probe's special path memory socket didn't have         { enough space to accomodate the nodal path report that we   "      { want to store. Since the amount of memory allocated to this  "       { socket is configurable we want to log the problem.        {}        context.longint := 0;   "      Log_Event (EL_RESOURCELIM, SREG, LOC_901_STORING_NPR, context, "                  2, ierr, logerr);  
      Escape(U_NO_MEMORY); 
 
      END; {IF ierr} 
            DS_StoreElement (DS_TrackTD, TL_NODE_LIST, mbufid);  
   END; {WITH ndrec} 
     { Now we check the passed name to see if it matches our local   { node's name. If it does then we want to initialize some of  { the fields in out node's node record.   {}  DS_FetchElement (DS_NodesTD, 1, noderec.int);   WITH noderec DO      BEGIN     IF (namelen = nr_nodenamelen) THEN         BEGIN   
      match := TRUE; 
       FOR i := 1 TO namelen DO           BEGIN  !         IF (ndrec.nd_name.chars[i] <> nr_nodename.chars[i]) THEN  !             match := FALSE;            END; {FOR i}   
      IF match THEN  
          BEGIN           nr_path_mbufid := mbufid;  $         nr_pathlen := ndrec.nd_length + 2;  {total of entry + next ptr} $          DS_StoreElement (DS_NodesTD, 1, noderec.int);      !         { Check here to see if we should set Probe's Unsolicited  !          { Reply timer.            {}            SregPokeProbe;            END; {IF match}        END; {IF namelen}      END; {WITH noderec}      99:;  END; {NRegAdd}      $PAGE   !{---------------------------------------------------------------}  ! !{   N Reg Find                                           (1000) }  ! !{---------------------------------------------------------------}  !     PROCEDURE NRegFind  { VAR regname   : EnvironStringType;                            namelen   : Int16;                        VAR mbufid    : Int16;                        VAR pathoffset: Int16;                        VAR pathlen   : Int16;                        VAR ierr      : Int16 };      {}  { Abstract:   {  The NReg database contains entries which bind environment  {  (or alternatively SReg) names to nodal path reports.   {  These database entries are keyed by environment names.   {  NRegFind(), when passed a presumed environment name,   {  attempts to locate the entry keyed under that name.  !{  The caller must be critical. NRegFind() never leaves critical.  ! {   
{ Input parameters:  
 {   {  regname: The environment name, fully qualified and with  {     all characters shifted to upper case.   {    {  namelen: The length, in characters, of the environment name.    {   
{ Output parameters: 
 {   {  mbufid: Returns a value of NULL if the no entry was found,   {     otherwise returns the mbufid of the mbuf containing the   {     NDRecord for the named node.  {   {  pathoffset: The offset, in bytes, from the beginning of the  !{     mbuf containing the NDRecord, at which the nodal path report ! {     for the named node begins.  {    {  pathlen: The length of path report contained in the NDRecord.   {   "{  ierr: Returns either a value of SUCCESSFUL or else an indication  " {     that an internal system error occurred.   {}      LABEL 99;       VAR   
   found       : BOOLEAN;  
    i           : Int16;      mmflags     : MMFlagsType;      nxtmbufid   : Int16;       
   PROCEDURE Escape; 
       BEGIN         mbufid := NULL;         ierr := U_INTERNALERR;        GOTO 99;  
      END; {Escape}  
     BEGIN   mbufid := NULL;        { Compute a hash value for the string & retrieve the pointer to    { the head of the equivalence class where we're likely to find  
{ the entry we seek. 
 {   { TESTBED: We don't have a true hash table yet.   {}  DS_FetchElement (DS_TrackTD, TL_NODE_LIST, mbufid);   found := FALSE;   WHILE ((mbufid <> NULL) AND (NOT found)) DO      BEGIN      { Fetch the tempNDRecord stored in the referenced mbuf. Don't      { bother fetching the associated path report.     {}          { mmflags.int := 0;     { mmflags.bits[0] := TRUE;  {preview read}      {}   
   mmflags.int := 1; 
    DS_MRead (tempndrec.int, INTERNAL_NDREC_BSIZE, mbufid, 2,               mmflags, ierr);      IF (NOT ((ierr = SUCCESSFUL) OR (ierr = MMTOOFEWBYTES))) THEN         BEGIN         SRegLogError (LOC_1000_READING_NDREC, ierr);        Escape;   
      END; {IF NOT}  
        IF (namelen = tempndrec.nd_nameinfo.nlen) THEN         BEGIN          { There's a possibility that the names will match because          { they're equal length. We could optimize the comparison        { algorithm below but for now it's adequate.        {}        i := 0;   
      found := TRUE; 
       REPEAT  
         i := i + 1; 
 !         IF (tempndrec.nd_name.chars[i] <> regname.chars[i]) THEN  !             found := FALSE;         UNTIL (i = namelen) OR (NOT found);         END; {IF namelen}          IF (NOT found) THEN        BEGIN         DS_MRead (nxtmbufid, 2, mbufid, 0, mmflags, ierr);        IF (ierr <> SUCCESSFUL) THEN           BEGIN           SRegLogError (LOC_1001_READING_PTR, ierr);            Escape;           END; {IF ierr}   
      mbufid := nxtmbufid; 
       END      ELSE         BEGIN   #      pathoffset := tempndrec.nd_path_offset + INTERNAL_NDREC_BSIZE -  #                          NDREC_BSIZE;   "      pathlen := tempndrec.nd_end_offset - tempndrec.nd_path_offset; " 
      END; {IF NOT}  
        END; {WHILE}   
ierr := SUCCESSFUL;  
     99:;  END; {NRegFind}       $PAGE   !{---------------------------------------------------------------}  ! !{   N Reg Purge                                          (1100) }  ! !{---------------------------------------------------------------}  !     PROCEDURE NRegPurge { VAR rname  : EnvironStringType;                             nlen   : Int16;                         VAR ierr   : Int16  };      {}  { Abstract:   !{  May be called to remove entries from the NReg database. Caller  ! {  must be critical. NRegPurge() never leaves critical.   {   
{ Input parameters:  
 {    {  rname: The name to be used as a key when finding the entry to   {     purge.  {   {  nlen: The length of the passed name.   {}      LABEL 99;       VAR      found          : BOOLEAN;  
   i              : Int16; 
    oldmbufid      : Int16;    {previous entry}     mbufid         : Int16;    {current entry}      mmflags        : MMFlagsType;  !   nxtmbufid      : Int16;    {entry pointed to by current entry}  !        PROCEDURE Escape ( error : Int16 );        BEGIN   
      ierr := error; 
       GOTO 99;  
      END; {Escape}  
         BEGIN   { Find the hash bucket in which the entry will be found if it   
{ exists in the data base. 
 {   { TESTBED: We don't have a full-blown hash table yet.   {}  DS_FetchElement (DS_TrackTD, TL_NODE_LIST, mbufid);   found := FALSE;   
oldmbufid := MEANINGLESS;  
 WHILE ((mbufid <> NULL) AND (NOT found)) DO      BEGIN  "   { Preview read the next internal ndrec. Then check to see if its  "    { name matches the passed name. If it does then we want to      { purge the mbuf containing the ndrec.      {     { mmflags.int := 0;     { mmflags.bits[0] := TRUE;      {}      mmflags.int := 1; {preview read}   #   DS_MRead (tempndrec.int, INTERNAL_NDREC_BSIZE, mbufid, 2, mmflags,  # 
             ierr);  
     IF (NOT ((ierr = SUCCESSFUL) OR (ierr = MMTOOFEWBYTES))) THEN         BEGIN         SRegLogError (LOC_1100_READING_NDREC, ierr);        Escape (U_INTERNALERR);   
      END; {IF NOT}  
     !   { Also preview read the next pointer for the entry we're going  ! "   { to examine. We'll need this pointer regardless of whatever else "    { happens.      {}      mmflags.int := 1; {preview read}      DS_MRead (nxtmbufid, 2, mbufid, 0, mmflags, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN         SRegLogError (LOC_1101_READING_NXTPTR, ierr);         Escape (U_INTERNALERR);   
      END; {IF ierr} 
     	   found := TRUE;  	    FOR i := 1 TO nlen DO        BEGIN         IF (rname.chars[i] <> tempndrec.nd_name.chars[i]) THEN           found := FALSE;  	      END; {FOR i} 	        IF (NOT found) THEN        BEGIN         oldmbufid := mbufid;  {current becomes previous}        mbufid := nxtmbufid;  {next becomes current}  
      END; {IF NOT found}  
    END; {WHILE}       IF found THEN      BEGIN     IF (oldmbufid = MEANINGLESS) THEN        BEGIN          { The entry was at the head of the list. All we need do is         { modify the list head pointer.         {}        DS_StoreElement (DS_TrackTD, TL_NODE_LIST, nxtmbufid);        END      ELSE         BEGIN   "      { We must overlay the "next pointer" of the entry that points  "       { to the one we are about to delete.        {}        DS_MBOverWrite (nxtmbufid, 2, oldmbufid, 0, ierr);        IF (ierr <> SUCCESSFUL) THEN           BEGIN           SRegLogError (LOC_1103_OVERWRITING, ierr);            Escape (U_INTERNALERR);           END; {IF ierr}   
      END; {IF oldmbufid}  
    DS_MDispose (mbufid, ierr);  	   END; {IF found} 	     
ierr := SUCCESSFUL;  
 99:;  END; {NRegPurge}      $PAGE   !{---------------------------------------------------------------}  ! !{   PREP S R NAME QUERY                                  (1200) }  ! !{---------------------------------------------------------------}  !     
PROCEDURE PrepSRNameQuery  
    { VAR soname      : SocketNameType;           sonamelen   : Int16;        VAR sregmsg     : IpcLookUpReqMsg;            rootgsd     : Int16;        VAR msgmbufid   : Int16;        VAR ierr        : Int16 };       {}  { Abstract:    {  This routine can be called to build SocketRegistry name query   {  messages and to put them into mbufs. The mbufs used will be  {  charged against the socket whose gsd was passed down.  {}      VAR   
   i        : Int16; 
 
   mmflags  : MMFlagsType; 
     BEGIN   { Prepare the header for the query that we'll send to our   { peer SReg. The format for this header is standardized across  { HP and is documented the the HP/DSN IPC specification.  {}  WITH sregmsg DO      BEGIN     lureq_msglen := IPCLOOKUPREQ_SIZE + sonamelen;      lureq_pid := 10; {magic number from IPC HP/DSN spec. Has no  "                     relation to PID values. See B.Lynn for details} "    lureq_seqnum := 1;      lureq_msgtype := 1;     lureq_capmask := 0;     lureq_unused1 := 0;     lureq_version := 0;     lureq_unused2 := 0;     lureq_nameptr := IPCLOOKUPREQ_SIZE;     lureq_endptr := lureq_msglen;     END; {WITH lureqmsg}       { Now put the SReg query header along with its associated   { socket name into DSAM. Charge the message against the   { root socket of the requestor.   {}  AdrOf (sregmsg.int, 0, vectdbuf[1]);  vectdbuf[2] := IPCLOOKUPREQ_SIZE;   AdrOf (soname.int, 0, vectdbuf[3] );  
vectdbuf[4] := sonamelen;  
     
{ mmflags.int := 0;  
 
{ mmflags.bits[0] := TRUE; 
 { mmflags.bits[-2] := TRUE;   {}  	mmflags.int := 5;  	 i := 32767;   !DS_SBPut (vectdbuf, 8, rootgsd * 2, mmflags, msgmbufid, i, ierr);  ! END; {PrepSRNameQuery}      $PAGE   !{---------------------------------------------------------------}  ! !{   SCAN AND SHIFT                                       (1300) }  ! !{---------------------------------------------------------------}  !     PROCEDURE ScanAndShift { VAR namestring  : EnvironStringType;                                namelen     : Int16;                            VAR curptr      : Int16;                            VAR namepartlen : Int16;                            VAR ierr        : Int16 };       {}  { Abstract:    {  This procedure performs several operations on the namestring     {  passed to it: it upshifts alphabetic characters from upper to   !{  lower case; it returns an error if non-alpha-numeric characters !  {  other than periods are encountered; and, it scans the string    #{  starting from a passed "current positon" until it either encounters # "{  a period or the end of the string. The scanning part is intended  "  {  to pick out parts of hierarchical names that are delimited by   {  periods.   {   
{ Input parameters:  
 {   {  namestring: The name string array.   {   {  namelen: The number of characters making up the name in the  {     namestring parameter.   {    {  curptr: Index into the name string to the last character that   {     has been examined. ScanAndShift() should only look at   {     characters starting at position curptr+1 and beyond.  {   
{ Output parameters: 
 {   "{  curptr: Index into the namestring of the last character examined. " {   "{  namepartlen: The length of the name part that was scanned, could  " {     be zero.  {    {  ierr: Returns either SUCCESSFUL or the resultant error code.    {}      VAR      done     : BOOLEAN;     firstchar: BOOLEAN;      BEGIN   done := FALSE;  	namepartlen := 0;  	 
ierr := SUCCESSFUL;  
 	firstchar := TRUE; 	     REPEAT     IF (curptr = namelen) THEN         BEGIN         { We've reached the end of the string.        {}  
      done := TRUE;  
       END      ELSE         BEGIN   $      { There are characters in the string that we haven't yet scanned.  $       {}        curptr := curptr + 1;             CASE namestring.chars[curptr] OF      	         'a'..'z': 	 	            BEGIN  	             namestring.chars[curptr] :=   #                              CHR(ORD(namestring.chars[curptr]) - 32); #             namepartlen := namepartlen + 1;               END; {a..z case}      	         'A'..'Z': 	 	            BEGIN  	             namepartlen := namepartlen + 1;               END; {A..Z case}      
         '-','_','0'..'9': 
 	            BEGIN  	 "            { We accept underscores, hyphens, and numeric characters "             { in all positions except the first.              {}              IF firstchar THEN   
               BEGIN 
                ierr := U_ILLEGAL_NODE_NAME;                  done := TRUE;                 END; {IF firstchar}              END;               '.':   	            BEGIN  	 
            done := TRUE;  
 
            END; {. case}  
     	         OTHERWISE 	 	            BEGIN  	 "            { We've encountered an illegal character, i.e., one that "             { shouldn't be present in a name string.              {}              ierr := U_ILLEGAL_NODE_NAME;  
            done := TRUE;  
             END; {OTHERWISE}      
         END; {CASE} 
      END; {IF curptr}        firstchar := FALSE;     UNTIL done;      
END; {ScanAndShift}  
     $PAGE   !{----------------------------------------------------------------} ! !{   SREG CONNECT REQUEST                                  (1800) } ! !{----------------------------------------------------------------} !     PROCEDURE SregConnectRequest ( VAR emsg    : EventMsgType;                                 VAR wkmp    : Int16;                                  VAR ierr    : Int16         );       {}  { Abstract:   {  This routine is called as a kind of "detour" from IPC to   "{  TCP. The emsg received will be a CONNECT_REQUEST that references  " !{  an mbuf containing a connect-site path report. An attempt will  !  {  be made to convert the path report into a d-path. If this can    {  be done successfully then the top of the path will be linked    #{  into the VC socket that the emsg references and the CONNECT_REQUEST # {  emsg will be redirected down to TCP.   {}      LABEL 99;       VAR      dnpid     : Int16;      dnpath    : Int16;      gsd       : Int16;      mbufid    : Int16;      mmflags   : MMFlagsType;      pathid    : Int16;      preamble  : PathPreambleRecord;     socket    : SocketRecord;             PROCEDURE Escape (error: Int16 );        BEGIN   
      ierr := error; 
       GOTO 99;  
      END; {Escape}  
     BEGIN   gsd := emsg.emcr_up_ref;  mbufid := emsg.emcr_dst_ref;  
{ mmflags.int := 0;  
 
{ mmflags.bits[0] := TRUE; 
 {}  	mmflags.int := 1;  	 DS_MRead ( preamble.int, PATH_PREAMBLE_SIZE+2, mbufid, 0,              mmflags, ierr );   IF (ierr <> SUCCESSFUL) THEN     BEGIN     SRegLogError (LOC_1800_MREAD, ierr);   
   Escape (U_INTERNALERR); 
 	   END; {IF ierr}  	     { Now that we have the preamble we can read out the rest of   { the path report. Note that we're using the same flags as for  { the previous call. The length that we're using for the path   { report read is actually drawn from the path report itself &   { therefore to fetch the entire path report we need to add two  { bytes.  {}  DS_MRead ( preport.int, preamble.pa_length+2, mbufid,              PATH_PREAMBLE_SIZE, mmflags, ierr );   IF (ierr <> SUCCESSFUL) THEN     BEGIN     SRegLogError (LOC_1801_MREAD2, ierr);     Escape ( U_INTERNALERR);   	   END; {IF ierr}  	     { We've extracted the path report and have it in our local   { buffer. At this point it is appropriate to decrement the path    { report's reference count and possibly destroy the DSAM copy.  { This is true because the CONNECT_REQUEST emsg that brought  { us the reference to the report might be the last object in  { the system that references the path.  {}  preamble.pa_ref_cnt := preamble.pa_ref_cnt - 1;   IF (preamble.pa_ref_cnt = 0) THEN      BEGIN     DS_MDispose(mbufid, ierr);      END  ELSE     BEGIN  #   DS_MBOverWrite(preamble.int, PATH_PREAMBLE_SIZE, mbufid, 0, ierr);  #    END; {IF preamble}   IF (ierr <> SUCCESSFUL) THEN     BEGIN     SRegLogError (LOC_1802_DISP_OVERW, ierr);  
   Escape (U_INTERNALERR); 
 	   END; {IF ierr}  	     { Retrieve the VC socket referenced in the request and check  { its state. If the user has already died or has already  { aborted the socket then we deallocate the socket and return   { its resources.  {}  DS_SoFetchElement ( gsd, socket.int );      IF (socket.so_b.state = VC_BUD_NIPPED) THEN      BEGIN     { We assume the socket has already been unlinked from its  
   { owner's user record.  
    {}      MakeSocketFree (gsd, socket);     DS_LeaveCritical (wkmp);   
   Escape ( SUCCESSFUL );  
    END; {IF socket.so_b.state}      !{ Now we can try to build a determinate path from the path report. ! {}  &ConvertReport (CR_CSREP_TO_DPATH, IPC, preport, dnpath, dnpid, wkmp, ierr ); &     "{ We've attempted to construct our d-path. While doing this we might " !{ have left the safety of our critical region. As a result our IPC !  { user could have aborted or somehow modified the fields of our    !{ socket. To be safe we need to read in the socket again and check ! { its state.  {}  DS_SoFetchElement (gsd, socket.int);      WITH socket DO     BEGIN     IF (ierr <> SUCCESSFUL) THEN         BEGIN   !      { We couldn't build the path. We'll have to inform our user  !       { unless he/she has already aborted the socket.         {}        IF (so_b.state = VC_BUD_NIPPED) THEN           BEGIN  $         { Looks like the user has aborted or shutdown the socket before $ #         { its time. If we've built a path then we'll have to kill it. #          {}            MakeSocketFree (gsd, socket);           END        ELSE           BEGIN  "         { The socket is still active but we simply couldn't build a "          { path for it.            {}            so_b.state := VC_SERVER_ABORTED;            so_down_pathref := ierr;            so_UserSig.er_flags[EXCEPTIONAL] := TRUE;           DS_Signal (gsd, INBOUND_SIG, socket);           END; {IF so_b.state}             DS_LeaveCritical ( wkmp );        Escape ( SUCCESSFUL );        END; {IF ierr <> SUCCESSFUL}      "   { The path was built successfully but the socket might have been  " #   { aborted. We now check this. If the socket was aborted then we'll  #    { kill the path that just been created for it.      {}      IF (so_b.state = VC_BUD_NIPPED) THEN         BEGIN         MakeSocketFree (gsd, socket);   	      WITH emsg DO 	          BEGIN           em_event := KILL_REQUEST;           ehport := dnpid * EHS_PER + EHOB_OFFSET;            emkr_down_ref := dnpath;            emkr_msg_snd_cnt := 1;            emkr_msg_rcv_cnt := 1;   
         END; {WITH emsg}  
       DS_LeaveCritical (wkmp);  
      ProSw (emsg, ierr);  
 
      Escape (SUCCESSFUL); 
 
      END; {IF so_b.state} 
        { The lower part of the path has been built successfully      { and the socket hasn't been aborted. We link the path      { to the socket and we change the socket's state to     { reveal that we've processed the connect request.      { Note with respect to reference counting that here      { we are counting the original CONNECT_REQUEST that was sent       { as one message sent along this path. In addition we are      { treating path building as if it had occurred as a result of       { an inbound message, therefore we pretend that we've so far       { received one inbound message along our path.      {}      so_down_pathref := dnpath;      so_down_pid := dnpid;     so_b.state := VC_ESTAB_CONFIRM_PENDING;     { We increment the down count to count the CONNECT_REQUEST      { that we're going to be sending down.      {}      so_down_cnt := so_down_cnt + 1;     { We increment the up count inorder to make the path appear      { as if it were constructed as a result of an inbound message   
   { entering the system.  
    {}      so_up_cnt := so_up_cnt + 1;     DS_SoStoreElement ( gsd, socket.int );      END; {WITH socket}       { Prepare a CONNECT_REQUEST emsg and send it down to the  { protocol that will serve the socket.  {}  WITH emsg DO     BEGIN  
   emcr_dst_ref := dnpath; 
    ehport := dnpid * EHS_PER + EHOB_OFFSET;   #   emcr_max_window := socket.so_k.max_rcvcc * socket.so_k.max_burstin; #    emcr_max_snds := socket.so_k.max_burstout;   
   END; {WITH emsg}  
     
ierr := SUCCESSFUL;  
 
DS_LeaveCritical ( wkmp ); 
 ProSw ( emsg, ierr );       99:;  
END; {SregConnectRequest}  
     $PAGE   !{----------------------------------------------------------------} ! !{   SREG IB                                               (1400) } ! !{----------------------------------------------------------------} !     PROCEDURE SRegIb { VAR emsg    : EventMsgType;                     VAR ierr    : Int16   };       {}  { Abstract:   !{  This is the Socket Registry's inbound protocol handler routine. ! {  Its two primary functions are to field SReg query and SReg   {  query-confirm messages sent to it from remote nodes.    {  This protocol handler does not handle the QUERY_CONFIRM event   {  messages sent up by Probe. Instead, another SocketRegistry   {  handler, SRegIbProbeReply(), handles Probe confirmations.  {}      LABEL 99;       VAR      dropmbufid        : Int16;      mbufid            : Int16;      mc                : Int16;      mmflags           : MMFlagsType;      msglen            : Int16;      namerecid         : Int16;      namerec           : NameRecord;     preamble          : PathPreambleRecord;     replyemsg         : EventMsgType;     sb                : Int16;      socket            : SocketRecord;     soname            : SocketNameType;     sonamelen         : Int16;      sregmsg           : RECORD                             CASE INTEGER OF                             1: ( int        : Int16);                             2: ( request    : IpcLookUpReqMsg );                            3: ( reply      : IpcLookUpRepMsg );                            END; {Sregmsg}     urecid            : Int16;      urec              : UserRecord;     wkmp              : Int16;       !   {-------------------------------------------------------------} ! !   {   SREG IB RESPONSE / SREG IB                                } ! !   {-------------------------------------------------------------} !        PROCEDURE SRegIbResponse;         {}      { Abstract:      {  Used like a MACRO to send QUERY_RESPONSE down to the LLP.       {}      BEGIN     DS_MDispose (dropmbufid, ierr);  
   WITH replyemsg DO 
       BEGIN         ehport := emsg.emqi_down_pid * EHS_PER + EHOB_OFFSET;         em_event := QUERY_RESPONSE;         emqrs_down_ref := emsg.emqi_down_ref;         emqrs_seq_num := emsg.emqi_seq_num;         emqrs_mbufid := mbufid;         emqrs_dlen := msglen;         { emqrs_options.int := 0;         { emqrs_options.bits[-1] := TRUE;         {}        emqrs_options.int := 2;         END; {WITH replyemsg}      DS_LeaveCritical (wkmp );     ProSw (replyemsg, ierr);      GOTO 99;      END; {SRegIbResponse}      !   {-------------------------------------------------------------} ! !   {   SREG IB KILL PATH / SREG IB                               } ! !   {-------------------------------------------------------------} !        PROCEDURE SRegIbKillPath;         {}      { Abstract:  !   {  Should be used like a MACRO to send KILL_REQUEST emsgs down  !    {  to the LLP that delivered up a QUERY_INDICATION.     {}      BEGIN     DS_MDispose (dropmbufid, ierr);  
   WITH replyemsg DO 
       BEGIN         ehport := emsg.emqi_down_pid * EHS_PER + EHOB_OFFSET;         em_event := KILL_REQUEST;         emkr_down_ref := emsg.emqi_down_ref;        emkr_msg_snd_cnt := 1;        emkr_msg_rcv_cnt := 1;        END; {WITH replyemsg}      DS_LeaveCritical (wkmp);      ProSw (replyemsg, ierr);      GOTO 99;      END; {SRegIbKillPath}      !   {-------------------------------------------------------------} ! !   {   SREG IB ERR CONFIRM / SREG IB                             } ! !   {-------------------------------------------------------------} !        PROCEDURE SRegIbErrConfirm ( error : Int16 );         {}      { Abstract:      {  Used like a MACRO to generate and send SReg query response       {  messages to the peer SReg protocol handler that previously      {  sent us      {  only be used when sending responses with errors.     {}      BEGIN     DS_MDispose (dropmbufid, ierr);     WITH sregmsg.reply DO        BEGIN   "      { Prepare the SReg message header taking full advantage of the " !      { overlap of some of the request and response header fields. !       {}         msglen := IPCLOOKUPERR_SIZE;     {length of fixed header}          lurep_msglen := msglen;   
      lurep_msgtype := 2;  
       lurep_errorcode := error;   
      END; {WITH sregmsg}  
    DS_FetchElement ( DS_TrackTD, TL_PATH_SOCKET, sb );     sb := sb + sb; {outbound path memory socket's sbuf}     AdrOf (sregmsg.int, 0, vectdbuf[1] );  
   vectdbuf[2] := msglen;  
    { mmflags.int := 0;     { mmflags.bits[-2] := TRUE;     {}   
   mmflags.int := 4; 
    mc := 32767;      DS_SBPut (vectdbuf, 4, sb, mmflags, mbufid, mc, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN   #      { We can't get enough memory to send back our reply. All we can  # $      { really do is kill the down path and return. We rely on our peer  $       { either to reissue its request or to time out.         {}        SRegIbKillPath;         END      ELSE         BEGIN         SRegIbResponse;   
      END; {IF ierr} 
 
   END; {SRegIbErrConfirm} 
     !   {-------------------------------------------------------------} ! !   {   SREG IB Q CONF / SREG IB                                  } ! !   {-------------------------------------------------------------} !     
   PROCEDURE SRegIBQConf;  
        {}      { Abstract:      {  This procedure handles all QUERY_CONFIRM emsgs sent up to        {  the SocketRegistry from PXP. Such an emsg should reference      {  an mbuf containing a response to a query previously sent     {  to a peer.     {}          BEGIN     mbufid := emsg.emqc_mbufid;     dropmbufid := mbufid;     { Check to see if the lower layer timed out.      {}      IF (emsg.emqc_result = U_RETRY_COUNT_EXHAUSTED) THEN         BEGIN         { We don't have to worry about dropping the inbound         { message because there wasn't one.         {}        SregIbUpConfirm(MEANINGLESS, 0, U_NO_REGISTRY_RESPONSE,   &                      emsg.emqc_up_ref, emsg.emqc_seq_num, replyemsg, wkmp); &       GOTO 99;        END      ELSE IF (emsg.emqc_dlen >= IPCLOOKUPREP_SIZE) THEN         BEGIN   !      { The data length specified in the QUERY_CONFIRM emsg allows !        { us to determine whether our query was successful and has         { resulted in the return of a path report.        {}        { Apparently we've recieved a path report.        {}        mmflags.int := 0; {non-preview read of header}  "      DS_MRead (sregmsg.int, IPCLOOKUPREP_SIZE, mbufid, 0, mmflags,  "                 ierr );         IF ((ierr <> SUCCESSFUL)             OR (sregmsg.reply.lurep_errorcode <> SUCCESSFUL)) THEN            BEGIN            { This is very odd, we've actied upon information given            { to us by the LLP and have run into problems.            {}            SRegLogError (LOC_1400_READING_HEADER, ierr);           DS_MDispose (dropmbufid, ierr);  %         SRegIbUpConfirm (MEANINGLESS, 0, U_INTERNALERR, emsg.emqc_up_ref, %                           emsg.emqc_seq_num, replyemsg, wkmp);  	         GOTO 99;  	          END; {IF ierr}             { Grab the requesting user's transaction root socket and        { verify that the user hasn't aborted yet. If the user        { has aborted then we need to be careful about cleaning         { up -- for example, we don't want to try to add a new        { descriptor to the user's UserRecord.        {}        DS_SoFetchElement (emsg.emqc_up_ref, socket.int);         IF (socket.so_b.state <> ROOT_TRANSACTING) THEN            BEGIN  "         { The user has already aborted. We must purge our received  " !         { path report and complete the transaction on the user's  !          { root socket so that it can be cleaned up.           {}            DS_MDispose (mbufid, ierr);  $         SRegIbUpConfirm (MEANINGLESS, 0, SUCCESSFUL, emsg.emqc_up_ref,  $                           emsg.emqc_seq_num, replyemsg, wkmp);  	         GOTO 99;  	 
         END; {IF socket}  
     !      { In preparation for permanently saving the path report that !        { we've received, we append a path report preamble to it.          {}        WITH preamble DO           BEGIN           pa_urecid := socket.so_urecid;            pa_namesptr := NULL;            pa_giveptr := NULL;  
         pa_ref_cnt := 1;  
          END; {WITH preamble}       #      DS_MAppendHead (preamble.int, PATH_PREAMBLE_SIZE, mbufid, ierr); #       IF (ierr <> SUCCESSFUL) THEN           BEGIN  !         { There shouldn't have been any problem doing the append  ! !         { because we already stripped the message header off the  !          { message and it was longer than the preamble.            {}            SRegLogError (LOC_1401_APPENDING_PREAMBLE, ierr);           DS_MDispose (mbufid, ierr);  %         SRegIbUpConfirm(MEANINGLESS, 0, U_INTERNALERR, emsg.emqc_up_ref,  %                          emsg.emqc_seq_num, replyemsg, wkmp);   	         GOTO 99;  	          END; {IF ierr}              { Now try to charge the memory taken up by the path report         { to the system's path memory socket and/or the general         { pool.         {}        DS_FetchElement (DS_TrackTD, TL_PATH_SOCKET, sb);         sb := sb + sb -1; {path memory socket's inbound sbuf}   
      { mmflags.int := 0;  
       { mmflags.bits[0] := FALSE;         {}        mmflags.int := 2;         DS_MBTransfer (mbufid, sb, mmflags, ierr);        IF (ierr = SUCCESSFUL) THEN            BEGIN  !         { We've managed to accomodate the path report within our  !          { memory accounting system. Now all we have to do is   !         { bind the report's mbuf into the user's descriptor space ! "         { and return a response to the user. Our response includes  " "         { the kind of socket that the path report references, this  " !         { is necessary so that we can return this information to  !          { the caller.           {}   #         mbufid := mbufid + DST_BOUNDARY; {shift into dest gsd space}  #          DS_UrFetchElement (socket.so_urecid, urec.int);           AttachSoToUser (urec, mbufid, sb);            DS_StoreUrec (socket.so_urecid, urec.int);   #         SRegIbUpConfirm (sb, sregmsg.reply.lurep_sokind, SUCCESSFUL,  # %                          emsg.emqc_up_ref, emsg.emqc_seq_num, replyemsg,  %                           wkmp);  	         GOTO 99;  	          END        ELSE IF (ierr = MMINSUFFICMEM) THEN            BEGIN  !         { SocketRegistry's path memory socket didn't have enough  !          { memory to accomodate the new path report and so we            { won't be able to satisfy our user's need for a path  !         { report. Before exiting this routine we log the resource !           { problem so that the system manager will know that it    	         { exists. 	          {}            context.longint := 0;  !         Log_Event (EL_RESOURCELIM, SREG, LOC_1408_NO_PATH_MEMORY, !                     context, 2, ierr, logerr);           DS_MDispose (mbufid, ierr);  $         SRegIbUpConfirm (MEANINGLESS, 0, U_NO_MEMORY, emsg.emqc_up_ref, $                           emsg.emqc_seq_num, replyemsg, wkmp);  	         GOTO 99;  	          END        ELSE           BEGIN  #         { Our attempt to charge the space for our path report failed  #          { for some completely unexpected reason.            {}            SRegLogError (LOC_1402_TRANSFER_PROBLEM, ierr);           DS_MDispose (mbufid, ierr);  %         SRegIbUpConfirm (MEANINGLESS, 0, U_INTERNALERR, emsg.emqc_up_ref, %                           emsg.emqc_seq_num, replyemsg, wkmp);  	         GOTO 99;  	          END; {IF ierr = SUCCESSFUL}        END      ELSE IF (emsg.emqc_dlen = IPCLOOKUPERR_SIZE) THEN        BEGIN          { We got an error message from our peer. The message will           { tell us what went wrong and this information we'll pass          { along to our user. After pulling the error information  #      { out of the message we'll drop the mbuf that held the message.  #       {}        mmflags.int := 0;   %      DS_MRead (sregmsg.int, IPCLOOKUPERR_SIZE, mbufid, 0, mmflags, ierr); %       IF (ierr <> SUCCESSFUL) THEN           BEGIN  "         { We couldn't read the message that PXP told us was there.  "          {}            SRegLogError (LOC_1403_READ_ERRMSG, ierr);            ierr := U_INTERNALERR;            END        ELSE           BEGIN            { Here we try to dispose of the mbuf that contained our            { socket registry reply header.           {}            DS_MDispose (dropmbufid, ierr);           IF (ierr <> SUCCESSFUL) THEN   	            BEGIN  	              { We shouldn't have had any trouble disposing of the   "            { mbuf that contained our socket registry reply header.  "             {}              SRegLogError (LOC_1404_DISPOSING, ierr);              ierr := U_INTERNALERR;              END   %         ELSE IF ((sregmsg.reply.lurep_errorcode = SREG_UNKNOWN_NAME_ERR)  % $            OR (sregmsg.reply.lurep_errorcode = SREG_VERSION_ERR)) THEN  $ 	            BEGIN  	 #            { Our remote socket registry peer has informed us that the #             { name mentioned in our query couldn't be found.              {}              ierr := U_NAME_NOT_FOUND              END            ELSE   	            BEGIN  	 #            { We have no idea what our remote peer was trying to tell  # 	            { us.  	             {}  &            SRegLogError (LOC_1405_ODD_MSG, sregmsg.reply.lurep_errorcode);  &             ierr := U_INTERNALERR;              END; {IF sregmsg}            END; {IF ierr}         SRegIbUpConfirm (MEANINGLESS, 0, ierr, emsg.emqc_up_ref,                          emsg.emqc_seq_num, replyemsg, wkmp);        GOTO 99;        END      ELSE IF (emsg.emqc_result <> SUCCESSFUL) THEN        BEGIN   #      { we got an error message without a LookUp record from PXP. Pass #         this error message up to the user }         DS_MDispose (dropmbufid, ierr);   %      SRegIbUpConfirm (MEANINGLESS, 0, emsg.emqc_result, emsg.emqc_up_ref, %         emsg.emqc_seq_num, replyemsg, wkmp);        GOTO 99;        END      ELSE         BEGIN   "      { We got a message with a peculiar length. We don't know what  " "      { it might be so we drop it and tell our user that the remote  "       { SocketRegistry has sent us something unexpected.        {}        DS_MDispose (dropmbufid, ierr);   %      SRegIbUpConfirm (MEANINGLESS, 0, U_BAD_SREG_REPLY, emsg.emqc_up_ref, %                        emsg.emqc_seq_num, replyemsg, wkmp);         GOTO 99;        END; {IF emsg.emqc_result}     END; {SRegIBQConf}       !   {-------------------------------------------------------------} ! !   {   SREG IB Q IND / SREG IB                                   } ! !   {-------------------------------------------------------------} !        PROCEDURE SregIBQInd;         {}      { Abstract:  "   {  This procedure handles the processing of all QUERY_INDICATION  "    {  emsgs passed up to us by PXP. Normally such an emsg will  !   {  reference an mbuf containing a query from one of our peers.  !    {  We try to examine this message to verify that it is       {  formatted according to the conventions that we understand.      {  When this routine terminates it transfers control to the     {  end of SRegIB() and we'll no longer be critical.     {}          BEGIN     WITH emsg, sregmsg DO        BEGIN   !      { First we read in the header of what is presumably a valid  ! !      { SReg query message. We evaluate the header to make sure we !       { understand it. We also save the mbufid of the inbound   "      { message so we ask memory manager to drop the message later.  "       {}        dropmbufid := emqi_mbufid;        mmflags.int := 0; {no previewing}          DS_MRead ( sregmsg.int, IPCLOOKUPREQ_SIZE, emqi_mbufid, 0,                    mmflags, ierr);        IF (ierr <> SUCCESSFUL) THEN           BEGIN  "         { There wasn't as much message as we thought. It's possible "           { that we somehow lost part of it -- but not likely. We   "         { assume that the remote node made the mistake. To recover  " !         { we ignore the message but destroy the path that it came ! 	         { in on.  	          {}            SRegIbKillPath;           END; {IF ierr}              { Check to make sure that our peer-SReg handler thinks it          { was sending us a request messsage.        {}        IF (request.lureq_msgtype <> 1) THEN           SRegIbErrConfirm( SREG_VERSION_ERR );            { Retreive the name length and make sure its reasonable.        {}         sonamelen := request.lureq_endptr - request.lureq_nameptr;   "      IF ((sonamelen < 1) OR (sonamelen > MAX_SOCKET_NAMELEN)) THEN  "          SRegIbErrConfirm ( SREG_UNKNOWN_NAME_ERR );            { Try reading in the name string from the message. If we        { run into a problem reading the name we assume it means  !      { that the name length specified was longer than the actual  !       { name string sent in the message.        {}  $      DS_MRead ( soname.int, sonamelen, emqi_mbufid, 0, mmflags, ierr);  $       IF (ierr <> SUCCESSFUL) THEN           SRegIbErrConfirm ( SREG_UNKNOWN_NAME_ERR );      !      { Try to find an entry in the SReg database that matches the !       { passed socket name.         {}        HashFind (FALSE, soname, sonamelen, namerecid, ierr);         IF (ierr <> SUCCESSFUL) THEN           SRegIbErrConfirm (SREG_UNKNOWN_NAME_ERR);            { The name was found. We retrieve the name record and          { from it determine which socket to generate a path report         { from.         {}        DS_FetchElement (DS_NamesTD, namerecid, namerec.int);         DS_SoFetchElement (namerec.nr_socketd, socket.int);         SregSocketToPath (socket, preport, ierr);         IF (ierr <> SUCCESSFUL) THEN           BEGIN           SregIbKillPath;           END; {IF ierr}       "      { Prepare the SReg reply header. Here we take advantage of the " #      { overlap between some the the request and reply header fields.  #       {}  "      reply.lurep_msglen := IPCLOOKUPREP_SIZE + preport.ints[0] + 2; "       reply.lurep_msgtype := 2;         reply.lurep_errorcode := SUCCESSFUL;        reply.lurep_numpathreps := 1;         reply.lurep_sokind := socket.so_b.kind;         END; {WITH emsg, sregmsg}       !   { Now we try to put the reply header along with its associated  !    { path report into DSAM.      {}      AdrOf (sregmsg.int, 0, vectdbuf[1] );     vectdbuf[2] := IPCLOOKUPREP_SIZE;     AdrOf ( preport.int, 0, vectdbuf[3] );      vectdbuf[4] := preport.ints[0] + 2;     DS_FetchElement (DS_TrackTD, TL_PATH_SOCKET, sb);     sb := sb + sb; {outbound path memory socket's sbuf}     { mmflags.int := 0;     { mmflags.bits[-2] := TRUE;     {}   
   mmflags.int := 4; 
    mc := 32767;      DS_SBPut (vectdbuf, 8, sb, mmflags, mbufid, mc, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN         { There wasn't enough memory in the account of the path         { memory socket's outbound sbuf nor in the general pool          { to accomodate the reply. All we can do is kill the down          { path.         {}        SRegLogError (LOC_1408_NO_PATH_MEMORY, ierr);         SRegIbKillPath;         END      ELSE         BEGIN   "      { We've successfully placed our SReg reply message into DSAM.  " !      { Now we prepare a QUERY_RESPONSE emsg and submit it to our  ! 
      { serving protocol.  
       {}        msglen := vectdbuf[2] + vectdbuf[4];        SRegIbResponse;   
      END; {IF ierr} 
 
   END; {SRegIBQInd} 
      {--------------------------------------------------------------}    {   BEGIN / SREG IB                                            }    {--------------------------------------------------------------}       BEGIN {SRegIb}  DS_EnterCritical (wkmp, ierr);      {First we log the event message we've just received.  {}  context.longint := 0;   Log_Event (EL_EVENT, SREG, LOC_1406_SREGIB, context,             EMSG_BYTE_LEN, emsg.int, logerr);      IF (emsg.em_event = QUERY_INDICATION) THEN     BEGIN  !   { Looks like we've received a SocketRegistry query from one of  !    { our remote peers.     {}      SRegIBQInd;     END  ELSE IF ((emsg.em_event = QUERY_CONFIRM)           AND (emsg.emqc_down_pid = HP_PXP)) THEN     BEGIN     { Looks like we've received a response to a previously sent     { SocketRegistry query message. The QUERY_CONFIRM emsg sent  !   { up to us from PXP should reference an mbuf with the response  ! 
   { message in it.  
    {}      SRegIBQConf;      END  ELSE     BEGIN     { We've received some kind of event message that we weren't     { expecting ever to receive here. This is a serious problem      { and all we can do is panic. When we've integrated with the    !   { event logger we'll want to log the reason for our discomfort. !    {}      SRegLogError (LOC_1407_BAD_EMSG, emsg.em_event);      DS_LeaveCritical (wkmp);      END; {emsg.em_event}   99:;  END; {SRegIB}       $PAGE    {-------------------------------------------------------------}     {   SREG IB OUT PRO                                    (1500) }     {-------------------------------------------------------------}        PROCEDURE SregIbOutPro { VAR emsg   : EventMsgType;                            VAR ierr   : Int16 };      {}  { Abstract:   "{  This routine is the entry point for the inbound protocol handler  " !{  that the SocketRegistry will support in OUTPRO. This handler is ! "{  small and needn't support all the functions that SocketRegistry's " {  protocol handler in INPRO does. The routine must be able to  !{  handle error-reporting QUERY_CONFIRMs from both PXP and PROBE.  ! {}      LABEL 99;       VAR      replyemsg      : EventMsgType;   
   wkmp           : Int16; 
    temp           : Int3216Type;         PROCEDURE GetNervous;        BEGIN         { Some thing unexpected has happened. Our most rational         { response is to panic.         {}        ierr := U_INTERNALERR;        DS_LeaveCritical (wkmp);        GOTO 99;        END; {GetNervous}       BEGIN   DS_EnterCritical (wkmp, ierr);      { First we log the event message just received.   {}  context.longint := 0;   Log_Event (EL_EVENT, SREG, LOC_1500_SREGIB_OUTPRO, context,              EMSG_BYTE_LEN, emsg.em_event, logerr);       WITH emsg DO     BEGIN     IF (em_event <> QUERY_CONFIRM) THEN        BEGIN   #      { We've received a kind of event message that we didn't expect.  # !      { All we can do is log the problem and return to our caller. !       {}        SRegLogError (LOC_1501_EVENT_TYPE, em_event);   	      GetNervous;  	       END; {IF em_event}         { We now know we've gotten a QUERY_CONFIRM emsg. To respond     { appropriately we'll need to know whether it came from  	   { PXP or PROBE. 	    {}      IF (emqc_down_pid = PROBE) THEN        BEGIN   "      { The response we've received is from Probe. Context for Probe " "      { transactions is saved in a LookUpRecord in an mbuf. We want  "        { to release this mbuf and then report up to the user why    "      { the transaction failed. We first assign the sequence number  " %      { which is 32 bits long into a temporary variable before disposing.  %       { Note the mbufid only takes up the first 16 bits.        {}        temp.longint := emqc_seq_num;         DS_MDispose (temp.int, ierr);          SRegIbUpConfirm (MEANINGLESS, 0, emqc_result, emqc_up_ref,                          MEANINGLESS, emsg, wkmp);        GOTO 99;        END      ELSE IF (emqc_result = U_RETRY_COUNT_EXHAUSTED) THEN         BEGIN   !      { The response is from PXP and its not too surprising -- the !       { remote socket registry couldn't be reached. This is a         { circumstance that should occur from time to time.         {}        SRegIbUpConfirm (MEANINGLESS, 0, U_NO_REGISTRY_RESPONSE,  %                    emsg.emqc_up_ref, emsg.emqc_seq_num, replyemsg, wkmp); %       GOTO 99;        END      ELSE         BEGIN   "      { TESTBED: We've been given something unexpected. A better way "       { to panic is needed here.        {}        SRegLogError (LOC_1502_MYSTERY, emqc_result);   	      GetNervous;  	 
      END; {IF emsg} 
 
   END; {WITH emsg}  
     99:;  
END; {SRegIbOutPro}  
     $PAGE    {-------------------------------------------------------------}     {   SREG IB PROBE REPLY                                (1600) }     {-------------------------------------------------------------}        
PROCEDURE SRegIbProbeReply 
    { VAR emsg     : EventMsgType;        VAR ierr     : Int16 };      {}  { Abstract:   {  This routine serves as the SocketRegistry's second inbound   !{  protocol handler. Its job is to handle all QUERY_CONFIRM emsgs  !  {  sent up to the SocketRegistry from Probe. The QUERY_CONFIRMs    {  will contain result codes revealing whether Probe was able   !{  to obtain the nodal path report for the requested node or not.  !  {  If it was then the QUERY_CONFIRM will contain a reference to    "{  the mbuf containing the path report. SocketRegistry will read in  " !{  the path report and then try to use it to complete a previously ! {  initiated IpcLookUp() or IpcDest() transaction.  {   
{ Input parameters:  
 {       !{  emsg: The QUERY_CONFIRM emsg sent up to the SocketRegistry from ! {     Probe.  {}      LABEL 99;       VAR   
   dnpath         : Int16; 
 
   dnpid          : Int16; 
    scratchndrec   : NDRecord;   
   lookupmbufid   : Int16; 
 
   lsd            : Int16; 
    mmflags        : MMFlagsType;     socketname     : SocketNameType;   
   temp           : Int16; 
    tempvar        : Int3216Type;  
   wkmp           : Int16; 
     BEGIN   DS_EnterCritical (wkmp, ierr);      { Log the event message just received.  {}  context.longint := 0;   Log_Event (EL_EVENT, SREG, LOC_1600_PROBE_REPLY, context,              EMSG_BYTE_LEN, emsg.int, logerr);      
WITH emsg, scratchndrec DO 
    BEGIN  "   { The emqc_seqnum field of the QUERY_CONFIRM emsg that we've just " !   { received should contain the mbufid of the mbuf that holds the ! !   { transaction's look-up record. Regardless of whether Probe was ! "   { able to produce the information requested of it, we'll want to  " "   { pull in some of the look-up record so we can complete or abort  "    { the transaction.      {}      tempvar.longint := emqc_seq_num;      lookupmbufid := tempvar.int;      { mmflags.int := 0;     { mmflags.bits[0] := TRUE; {preview read}     {}   
   mmflags.int := 1; 
     DS_MRead (templookuprec.int, LOOKUPREC_SIZE, lookupmbufid, 0,                mmflags, ierr);     IF (ierr <> SUCCESSFUL) THEN         BEGIN   #      { This is a problem. We shouldn't ever have any trouble reading  #       { in the LookUpRecord. All we can do is panic.        {}        SRegLogError (LOC_1601_READING_LUREC, ierr);        ierr := U_INTERNALERR;        DS_LeaveCritical (wkmp);        GOTO 99;  
      END; {IF ierr} 
     #   { Check the result code in the QUERY_CONFIRM emsg sent up to us by  # "   { Probe. If the result was not SUCCESSFUL then we need to send an " "   { emsg up to the application that initiated the original look-up  " 	   { transaction.  	    {}      IF (emqc_result <> SUCCESSFUL) THEN        BEGIN          { The result was not successful so we first dispose of our   !      { LookUpRecord's mbuf since we won't be needing it anymore.  !       { Then we send up a negative QUERY_CONFIRM.         {}        DS_MDispose (lookupmbufid, ierr);         IF (ierr <> SUCCESSFUL) THEN           SRegLogError (LOC_1602_DISPOSING, ierr);          SRegIbUpConfirm (MEANINGLESS, 0, emqc_result, emqc_up_ref,                          MEANINGLESS, emsg, wkmp);  
      ierr := SUCCESSFUL;  
       GOTO 99;        END; {IF emqc_result}       #   { Probe has (presumably) provided us with the NodalPathReport that  # "   { we needed. Later we'll want to use this path report to complete " #   { the IpcLookUp() or IpcDest() transaction that we were working on. # "   { First, however, we'll try to store the NPR in our NodalRegistry "    { database as a kind of caching measure.      {  !   { Previously we read in the preamble part of the LookUpRecord.  !     { Now, using the length information from the preamble we want       { to read in the socket and node names that are stored in the      { preamble. We'll read the node name into the new NDRecord   
   { that we're preparing. 
    {}          { mmflags.int := 0;     { mmflags.bits[0] := TRUE; {preview read}     {}   
   mmflags.int := 1; 
 $   DS_MRead (socketname.int, templookuprec.lu_socket_nlen, lookupmbufid, $              LOOKUPREC_SIZE, mmflags, temp);      
   nd_nameinfo.ntype := 1; 
    nd_nameinfo.nlen := templookuprec.lu_env_nlen;   !   DS_MRead (nd_name.int, templookuprec.lu_env_nlen, lookupmbufid, ! &             LOOKUPREC_SIZE + templookuprec.lu_socket_nlen, mmflags, ierr);  &    temp := temp + ierr;          { We no longer need the mbuf containing the lookup record.      {}      DS_MDispose (lookupmbufid, ierr);     temp := temp + ierr;      IF (temp <> SUCCESSFUL) THEN         BEGIN         SRegLogError (LOC_1602_DISPOSING, ierr);  !      SRegIbUpConfirm (MEANINGLESS, 0, U_INTERNALERR, emqc_up_ref, !                        MEANINGLESS, emsg, wkmp);        GOTO 99;  
      END; {IF temp} 
     !   { Now we want to read the NPR returned to us by Probe into our  !     { ndrec structure. We'll completely initialize this structure      { and then try adding it to our NodalRegistry database.     {}      nd_name_offset := 8;   "   nd_path_offset := nd_name_offset + templookuprec.lu_env_nlen + 2; "    IF Odd(nd_path_offset) THEN        BEGIN         { We must add a pad byte to the name field.         {}        scratchndrec.bytes[nd_path_offset] := NULL;         nd_path_offset := nd_path_offset + 1;   
      END; {IF Odd}  
        nd_length := nd_path_offset + emqc_dlen;      nd_end_offset := nd_length;         { mmflags.int := 0;     { mmflags.bits[0] := TRUE;      {}   
   mmflags.int := 1; 
     DS_MRead (scratchndrec.ints[nd_path_offset DIV 2], emqc_dlen,                emqc_mbufid, 0, mmflags, ierr);         IF (ierr <> SUCCESSFUL) THEN         BEGIN         SRegLogError (LOC_1603_READING_NPR, ierr);        DS_MDispose (emqc_mbufid, temp);  !      SRegIbUpConfirm (MEANINGLESS, 0, U_INTERNALERR, emqc_up_ref, !                        MEANINGLESS, emsg, wkmp);        GOTO 99;  
      END; {IF ierr} 
     !   { Next we try to add the NDRecord we've just constructed to our !     { NodalRegistry's database. We should only fail at this stage      { if there isn't enough free memory to store the report.      {}      mmflags.int := 0;  {don't overwrite an existing entry}      NRegAdd (scratchndrec, mmflags, ierr);          IF (ierr = U_INTERNALERR) THEN         BEGIN         DS_MDispose (emqc_mbufid, temp);  !      SRegIbUpConfirm (MEANINGLESS, 0, U_INTERNALERR, emqc_up_ref, !                        MEANINGLESS, emsg, wkmp);        GOTO 99;  
      END; {IF ierr} 
     "   { Here we try to read the NPR passed to us by Probe into a local  " "   { path report buffer. Having done this we won't have any further  " "   { need for the mbuf that Probe used for temporary storage of the  "    { NPR.      {}      { mmflags.int := 0;     { mmflags.bits[0] := TRUE; {preview set}      {}   
   mmflags.int := 1; 
 "   DS_MRead (preport.int, emqc_dlen, emqc_mbufid, 0, mmflags, ierr); "    DS_MDispose (emqc_mbufid, temp);      ierr := ierr + temp;      IF (ierr <> SUCCESSFUL) THEN         BEGIn         SRegLogError (LOC_1604_READING_AGAIN, ierr);  !      SRegIbUpConfirm (MEANINGLESS, 0, U_INTERNALERR, emqc_up_ref, !                         MEANINGLESS, emsg, wkmp);         GOTO 99;  
      END; {IF ierr} 
     "   { We now have the NPR for the remote node that is the subject of  " !   { our IpcDest() or IpcLookUp() transaction. If we're working on !     { an IpcDest() transaction then we now want to use the NPR to   !   { construct a connect-site path report. If we're working on an  !     { IpcLookUp() transaction then we need to send a socket name    !   { to the SocketRegistry server on the remote node. This server  ! !   { should reply with a connect-site report for the named socket. !     { By convention we keep a negative urecid in our LookUpRecord      { if we're handling an IpcDest() transaction and a positive     { urecid for an IpcLookUp() transaction.      {}      IF (templookuprec.lu_urecid < 0) THEN        BEGIN   !      { We're trying to complete an IpcDest() transaction. Here we !        { try to generate a connect-site path report from the NPR          { and protocol element we're holding.         {}        templookuprec.lu_urecid := -templookuprec.lu_urecid;         MakeCSiteReport (socketname, templookuprec.lu_socket_nlen,                          preport, emqc_dlen, wkmp, ierr);         IF (ierr <> SUCCESSFUL) THEN           BEGIN  %         SRegIbUpConfirm (MEANINGLESS, 0, ierr, emqc_up_ref, MEANINGLESS,  %                           emsg, wkmp);  	         GOTO 99;  	          END; {IF ierr}       !      { Now that we've constructed our connect-site path report we !        { must try to store it in DSAM and insert its gsd into the         { user's descriptor map.        {}        ChargeNAttachReport (templookuprec.lu_urecid, preport,                             lsd, temp, ierr);  !      SRegIbUpConfirm (lsd, temp, ierr, emqc_up_ref, MEANINGLESS,  !                        emsg, wkmp);         GOTO 99;        END      ELSE         BEGIN   !      { We want to complete an IpcLookUp() transaction. To do this ! !      { we have to build an outbound path down which we can send a !       { name query message to our remote SocketRegistry peer.   !      { The path will be built based upon information provided to  !       { us in the NPR just obtained from Probe.         {}         ConvertReport (CR_NODREP_TO_DPATH, SREG, preport, dnpath,                         dnpid, wkmp, ierr);        IF (ierr <> SUCCESSFUL) THEN           BEGIN           { For some reason we can't build an outbound path.            {}            SRegIbUpConfirm (MEANINGLESS, 0, ierr, emqc_up_ref,                            MEANINGLESS, emsg, wkmp);   	         GOTO 99;  	          END; {IF ierr}       "      { Next try to prepare the message that we'll send to our peer. "       { We need to put this message into an mbuf.         {}         PrepSRNameQuery (socketname, templookuprec.lu_socket_nlen,   #                       scratchlumsg, emqc_up_ref, lookupmbufid, ierr); #       IF (ierr <> SUCCESSFUL) THEN           BEGIN           SRegIbUpConfirm (MEANINGLESS, 0, ierr, emqc_up_ref,                            MEANINGLESS, emsg, wkmp);   	         GOTO 99;  	          END; {IF ierr}              { The message is now ready and residing in an mbuf. Now we   !      { prepare a QUERY_REQUEST emsg and pass it down to PXP along ! #      { the d-path that we constructed earlier from the NPR delivered  #        { by Probe. Note here that we're using the emsg frame that         { Probe's QUERY_CONFIRM arrived in.         {}        em_event := QUERY_REQUEST;        ehport := dnpid * EHS_PER + EHOB_OFFSET;        emqrq_up_ref := emqc_up_ref;        emqrq_up_pid := SREG;         emqrq_down_ref := dnpath; {from ConvertReport()}        emqrq_mbufid := lookupmbufid; {message is in here}  !      emqrq_dlen := scratchlumsg.lureq_msglen; {length of message} !       emqrq_seq_num := MEANINGLESS; {not used at this level}        { emqrq_options.int := 0;   #      { emqrq_options.bits[-1] := TRUE; {LLP should destroy down path  # $      {                                 after delivering QUERY_CONFIRM}  $       {}        emqrq_options.int := 2;             { Our emsg for PXP is prepared and ready to be sent. PXP        { will want to use the transaction's root socket for  !      { receiving timer signals on. Here we set the root socket's  ! "      { down pid field to HP_PXP so timer signals will be delivered  " !      { to PXP and not to Probe (Probe used the root socket last). ! #      { Now all that's left is to send off the query and wait for the  #       { reply.        {}        DS_SoFetchElement (emqrq_up_ref, tempsocket.int);         tempsocket.so_down_pid := HP_PXP;         DS_SoStoreElement (emqrq_up_ref, tempsocket.int);             DS_LeaveCritical (wkmp);  
      ProSw (emsg, ierr);  
       END; {IF templookuprec}       
   END;  {WITH emsg} 
 99:;  END; {SRegIBProbeReply}       $PAGE    {-------------------------------------------------------------}     {   SREG IB UP CONFIRM                                 (1700) }     {-------------------------------------------------------------}        
PROCEDURE SRegIbUpConfirm  
    {     lsd        : Int16;           sokind     : Int16;           result     : Int16;           upref      : Int16;           seqnum     : INTEGER;       VAR replyemsg  : EventMsgType;        VAR wkmp       : Int16 };      {}  { Abstract:   {  Should be used to send QUERY_CONFIRM emsgs up to the    {  root socket of the user that issued the original IpcLookUp()    {  request. Caller should be critical. This routine leaves  {  critical.  {   
{ Input parameters:  
 {   !{  lsd: The local descriptor for the path report that was obtained ! !{     for the initiator of transaction. Initiators will either be  ! {     IpcDest() or IpcLookUp() callers.   {   {  sokind: The kind of socket that the path report describes.   {   !{  upref: The path record that the QUERY_CONFIRM should reference. ! {     For now this up reference will always reference the root  {     socket of the IpcDest() or IpcLookUp() caller.  {    {  seqnum: The reply sequence number that should be inserted in    {     the QUERY_CONFIRM's emqc_seqnum field.  {   !{  replyemsg: The event message buffer that should be initialized  ! {     to form the QUERY_CONFIRM.  {   {  wkmp: The current critical region identifier.  {}      BEGIN   	WITH replyemsg DO  	    BEGIN     em_event := QUERY_CONFIRM;      ehport := IPC * EHS_PER + EHIB_OFFSET;      emqc_up_ref := upref;  
   emqc_seq_num := seqnum; 
    emqc_mbufid := lsd; {return descriptor not mbuf}      emqc_dlen := sokind; {return socket kind not dlen}   
   emqc_result := result;  
    END; {WITH replyemsg}  SoResponse (replyemsg.emqc_up_ref, replyemsg, result);  DS_LeaveCritical (wkmp);  END; {SRegIbUpConfirm}      $PAGE   !{---------------------------------------------------------------}  ! !{   SREG IPC TEMPLATES                                   (1900) }  ! !{---------------------------------------------------------------}  !     PROCEDURE SregIPCTemplates { VAR ierr : Int16 };      {}  { Abstract:    {  This procedure should be called at initialization time after     {  all of the protocol and domain records have been initialized.   {  The routine is responsible for constructing path report   {  templates for all protocols that support IPC directly. Every    {  template that gets constructed also gets queued onto its   {  corresponding protocol's protocol record.  {}      LABEL 99;       VAR      ctrlstk        : TemplateControlStack;   
   ctrlsp         : Int16; 
 
   domainind      : Int16; 
    domainrec      : DomainRecord;   
   dynamicptr     : Int16; 
 
   i              : Int16; 
 
   mbufid         : Int16; 
    mmflags        : MMFlagsType;     noderec        : NodeRecord;   
   pathsb         : Int16; 
 
   protoind       : Int16; 
    protorec       : ProtocolRecord;      targetpids     : ProtocolMapType;  
   temp           : Int16; 
 
   wkmp           : Int16; 
        PROCEDURE Escape ( error : Int16 );        BEGIN   
      ierr := error; 
       GOTO 99;  
      END; {Escape}  
     BEGIN   
ierr := SUCCESSFUL;  
 DS_InitEnterCritical (wkmp, ierr);      { Scan all the domain records in the system to discover which   { protocols support IPC directly. These protocols represent a    { target set -- we want to construct a path report template for    
{ each one of them.  
 {}  targetpids.longint := 0;  DS_FetchElement (DS_NodesTD, 1, noderec.int);   i := noderec.nr_domains;  	WHILE (i <> 0) DO  	    BEGIN     DS_FetchElement (DS_DomainsTD, i, domainrec.int);     targetpids.ints[1] := Ior( targetpids.ints[1],                                 domainrec.dr_ipcpids.ints[1] );      targetpids.ints[2] := Ior( targetpids.ints[2],                                 domainrec.dr_ipcpids.ints[2] );      i := i - 1;  	   END; {WHILE i}  	     IF (targetpids.longint = 0) THEN  !   { We've got some kind of configuration problem. Either we don't !    { have any domains configured or else we don't have any     { IPC-supporting protocols configured.      {     { Escape ( U_CONFIGURATION_ERROR )      {}      BEGIN     logerr := 0;      SRegLogError (LOC_1900_CONFIGURATION, logerr);      Escape ( U_INTERNALERR );     END; {IF targetpids}       "{ Now we want to generate a path report template for each of our IPC "  { supporting protocols. To do this we must push onto the control   { stack one template control record for each VNA that will be   !{ included in the template. Our system's domain records will tell  ! !{ us how many VNA's are included in each domain that our protocol  ! 	{ supports IPC in. 	 {}  ctrlsp := 0;  FOR protoind := 1 TO LAST_INDIVIDUAL_PID DO      BEGIN     IF targetpids.bits[protoind] THEN        BEGIN   !      { Variable protoind gives us the PID of one protocol that is !        { a direct supporter of IPC. Now we'll look at each of the   !      { domains to see which ones have protocol protoind servicing !       { as a direct IPC supporter.        {}        FOR domainind := 1 TO noderec.nr_domains DO            BEGIN  !         DS_FetchElement (DS_DomainsTD, domainind, domainrec.int); !          IF domainrec.dr_ipcpids.bits[protoind] THEN  	            BEGIN  	             i := domainrec.dr_vnas;               WHILE (i <> 0) DO   
               BEGIN 
 !               { Push control record for SReg onto the stack. This !                 { control record will later act as a stimulus for   !               { SReg software to add a new VNA to the path report !                { that's being built.  	               {}  	                ctrlsp := ctrlsp + 1;                 WITH ctrlstk[ctrlsp] DO                    BEGIN                     tc_activepid := SREG;                     tc_pathoffset := i; {VNA index}                     tc_uppid := IP;                     END; {WITH ctrlstk}   
               i := i - 1; 
                END; {WHILE i}               END; {IF domainrec}            END; {FOR domainind}       "      { If we've pushed some control records onto our stack by this  "        { point then we're ready to use the stack to build a path          { report template.        {}        IF (ctrlsp <> 0) THEN            BEGIN  "         SregTemplateBuild (IPC, protoind, ctrlsp, ctrlstk, preport, "                             dynamicptr, ierr);           IF (ierr <> SUCCESSFUL) THEN Escape ( ierr );      "         { Put the path report template into DSAM. Charge the space  " #         { it occupies against the special system path memory socket.  # !         { Plug the resulting mbufid into the protocol record for  !          { the protocol that's the subject of the template.            {}            DS_FetchElement (DS_TrackTD, TL_PATH_SOCKET, pathsb);           pathsb := pathsb + pathsb - 1;            AdrOf (preport.int, 0, vectdbuf[1]);            vectdbuf[2] := preport.ints[0] + 2;               { mmflags.int := 0;           { mmflags.bits[0] := TRUE;            { mmflags.bits[-1] := TRUE;           { mmflags.bits[-2] := TRUE;           {}   
         mmflags.int := 7; 
          temp := MAX_PATHREP_BYTES;   #         DS_SBPut (vectdbuf, 4, pathsb, mmflags, mbufid, temp, ierr);  #          IF (ierr <> SUCCESSFUL) THEN   	            BEGIN  	             context.longint := 0;   $            Log_Event (EL_RESOURCELIM, SREG, LOC_1901_PUTTING_TEMPLATE,  $                        context, 2, ierr, logerr);               Escape ( U_NO_MEMORY);  
            END; {IF ierr} 
               DS_FetchElement (DS_ProtosTD, protoind, protorec.int);    
         WITH protorec DO  
 	            BEGIN  	             pr_path_mbufid := mbufid;               pr_pathlen := preport.ints[0] + 2;              pr_dynamicptr := dynamicptr;              END; {WITH protorec}            DS_StoreElement (DS_ProtosTD, protoind, protorec.int);    
         END; {IF ctrlsp}  
     
      END; {IF targetpids} 
    END; {FOR protoind}      99: DS_InitLeaveCritical (wkmp);  END; {SregIPCTemplates}       $PAGE   !{---------------------------------------------------------------}  ! !{   SREG LOG ERROR                                              }  ! !{---------------------------------------------------------------}  !     PROCEDURE SRegLogError  
   { location     : Int16; 
      error        : Int16 };      {}  { Abstract:    {  This routine may be used to log simple errors (EL_ERROR type)   
{  to the log file.  
 {}  BEGIN   context.longint := 0;    Log_Event (EL_ERROR, SREG, location, context, 2, error, logerr);   
END; {SRegLogError}  
     $PAGE   !{---------------------------------------------------------------}  ! !{   SREG OB                                              (2000) }  ! !{---------------------------------------------------------------}  !     PROCEDURE SregOB { VAR emsg  : EventMsgType;                     VAR ierr  : Int16          };      VAR   	   wkmp  : Int16;  	     BEGIN  {SregOb}   DS_EnterCritical (wkmp, ierr);      context.longint := 0;   Log_Event (EL_EVENT, SREG, LOC_2000_SREGOB, context,             EMSG_BYTE_LEN, emsg.int, logerr);      CASE emsg.em_event OF          CONNECT_REQUEST: SregConnectRequest (emsg, wkmp, ierr );          QUERY_REQUEST: SregQueryRequest ( emsg, wkmp, ierr );         OTHERWISE        BEGIN         SRegLogError (LOC_2001_BAD_EMSG, emsg.em_event);        DS_LeaveCritical (wkmp);        END; {OTHERWISE}  
   END; {CASE emsg } 
     END; {SregOB}   $PAGE   !{----------------------------------------------------------------} ! !{   SREG POKE PROBE                                       (2100) } ! !{----------------------------------------------------------------} !     PROCEDURE SregPokeProbe;      {}  { Abstract:   {  This routine may be called to set Probe's Unsolicited Timer  {  the first time. SregPokeProbe first tests to see if the  {  timer has ever been set before. If it has then Probe will   {  assume all further responsibility for resetting it. If we do    {  set the timer then eventually a TIMERABLE_3 signal will be   {  sent down through Probe's special socket. When the Probe   {  outbound protocol handler receives this signal it will   {  send out an Unsolicited Probe reply message.   {}      VAR   
   gsd      : Int16; 
 
   ierr     : Int16; 
    rqsttime : INTEGER;  
   timerid  : TimerIDType; 
    timermsg : TimerMsgType;       BEGIN   { First we check to see if our node is LAN-based. If it is  { then we'll want to make sure Probe's special socket is  { properly set up to deliver timer signals.   {}  DS_FetchElement (DS_ProtosTD, SREG, protorec.int);  IF (protorec.pr_supportingpids.bits[PROBE]) THEN     BEGIN     { Yes our node is LAN-based. Here we want to make sure that     { we've initialized the Probe socket so that Unsolicited      { Probe timeout signals may be sent down on it.     {}      DS_FetchElement (DS_TrackTD, TL_PROBE_SOCKET, gsd);     DS_SoFetchElement (gsd, tempsocket.int);      IF (tempsocket.so_timeout <> MEANINGLESS) THEN         BEGIN         tempsocket.so_timeout := MEANINGLESS;         timermsg.socket := gsd;         timermsg.direction := OUTBOUND_SIG;         timermsg.signal := TIMERABLE_3;         DS_SoStoreElement (gsd, tempsocket.int);  !      rqsttime := 3; {short -- there's no sense in waiting around} !       ActivateTimer (rqsttime, timermsg, timerid, ierr);      %      { As an enhancement we could log any error that we encountered here. % $      { No real harm will be done if we don't send out Unsolicited Probe $ 	      { messages.  	       {}  
      END; {IF tempsocket} 
    END; {IF protorec}   
END; {SregPokeProbe} 
     $PAGE   !{----------------------------------------------------------------} ! !{   SREG QUERY REQUEST                                           } ! !{----------------------------------------------------------------} !     PROCEDURE SregQueryRequest { VAR emsg  : EventMsgType;                               VAR wkmp  : Int16;                                VAR ierr  : Int16        };      {}  { Abstract:   {  This routine handles all the QUERY_REQUEST event messages  {  sent to Probe from the SocketRegistry. Each of these emsgs   {  carries a reference to an mbuf containing a LookUpRecord.  {  These records contain a user record descriptor, a socket   {  name, and a (possibly invalid or unqualified) node name.   {  SregQueryRequest() attempts to use the passed information  {  to locate a connect-site path report for the named socket.   {}      LABEL 99;       VAR   
   destreq     : BOOLEAN;  
    dnpath      : Int16;      dnpid       : Int16;      envname     : EnvironStringType;      envnamelen  : Int16;      gsd         : Int16;      i           : Int16;   "   localndmbufid  : Int16;  {the id of the mbuf containing the local "                              node's NDRecord}      lookuprec   : LookUpRecord;     lureqmsg    : IpcLookUpReqMsg;      lookupmbufid      : Int16;      mmflags     : MMFlagsType;      namerecid   : Int16;      namerec     : NameRecord;  $   ndmbufid    : Int16;      {the id of the mbuf containing the NDRecord $                               of the node named in the query}   #   prepoffset  : Int16;      {offset into the NDRecord where the path  #                               report begins}     preplen     : Int16;      socket      : SocketRecord;     socketname  : SocketNameType;     temp        : Int16;      urecid      : Int16;       !   {-------------------------------------------------------------} ! !   {   Escape Confirm / Sreg Query Request                       } ! !   {-------------------------------------------------------------} !        PROCEDURE EscapeConfirm ( lsd     : Int16;                                sokind  : Int16;                                result  : Int16 );          VAR        confemsg    : EventMsgType;          BEGIN     { Before leaving SRegQuery() we must dispose the mbuf that      { contained the query's LookUpRecord.     {}      DS_MDispose (lookupmbufid, ierr);      
   WITH confemsg DO  
       BEGIN         em_event := QUERY_CONFIRM;        ehport := emsg.emqrq_up_pid * EHS_PER + EHOB_OFFSET;        emqc_up_ref := emsg.emqrq_up_ref;         emqc_seq_num := emsg.emqrq_seq_num;         emqc_mbufid := lsd;  {return descriptor not mbufid}   
      emqc_dlen := sokind; 
       emqc_result := result;  
      END; {WITH confemsg} 
    SoResponse ( confemsg.emqc_up_ref, confemsg, ierr);     DS_LeaveCritical ( wkmp );          GOTO 99;      END; {EscapeConfirm}       $   {------------------------------------------------------------------}  $ $   {   Dig Out Nodal Report / Sreg Query Request                      }  $ $   {------------------------------------------------------------------}  $        PROCEDURE DigOutNodalReport;         {}  	      { Abstract:  	 !      {  Used like a MACRO. Attempts to preview-read a nodal path  ! !      {  report out of the mbuf in which it is supposedly stored.  !       {}        BEGIN   
      { mmflags.int := 0;  
       { mmflags.bits[0] := TRUE;  {preview}         {}        mmflags.int := 1;   &      DS_MRead (preport.int, preplen, ndmbufid, prepoffset, mmflags, ierr);  &       IF (ierr <> SUCCESSFUL) THEN           BEGIN           SRegLogError (LOC_2100_READING_NPR, ierr);            EscapeConfirm (MEANINGLESS, 0, U_INTERNALERR);            END; {IF ierr}         END; {DigOutNodalReport}      #{--------------------------------------------------------------------} # #{   BEGIN / Sreg Query Request                                       } # #{--------------------------------------------------------------------} #     BEGIN       !{ First thing we do is grab a reference to the mbuf that contains  ! { the query's LookUpRecord. Before exiting, and unless we have   { to keep it for context, we must be sure to dispose this mbuf.    {}  lookupmbufid := emsg.emqrq_mbufid;      { Grab the transaction root socket and verify that the user   { hasn't aborted yet.   {}  DS_SoFetchElement (emsg.emqrq_up_ref, socket.int);  IF (socket.so_b.state <> ROOT_TRANSACTING) THEN      BEGIN     { The user has already aborted and so there is no sense in      { continuing on trying to resolve the socket name. We     { must however do something to complete the transaction     { initiated on the user's root socket or else it will     { never be released back to the free socket pool.     { In addition, if the query was successful and we were      { able to create a new destination descriptor we wouldn't     { want to link that descriptor into a user record that      { had already been subjected to abort processing.     { The EscapeConfirm() routine calls SoResponse() and      { SoResponse() handles the proper closing of the user's  	   { root socket.  	    {}      EscapeConfirm (MEANINGLESS, 0, SUCCESSFUL);     END  ELSE     BEGIN      { The root socket is intact and it is safe for us to continue      { processing the query. If our query must be resolved by a       { remote SocketRegistry then we must use PXP to send a query       { to that registry. If used, PXP will want to issue a timer      { request against our root socket; when/if the timeout signal      { arrives then DispatchRoot() will want to prepare a       { TIMER_RESPONSE emsg and send it down to PXP. To accomodate       { this eventuality we must put HP_PXP's protocol id in the       { root socket. Given that we've dirtied the socket we choose    !   { to write it out to DSAM immediately -- this is very important ! !   { because subsequent memory manager requests will likely modify ! $   { the root socket's signal records and we don't want to inadvertantly $    { overlay any such changes.     {}      socket.so_down_pid := HP_PXP;     urecid := socket.so_urecid; {useful later}      DS_SoStoreElement (emsg.emqrq_up_ref, socket.int);      END; {IF socket.so_b.state}      WITH emsg DO     BEGIN  #   { The QUERY_REQUEST emsg has a reference to an mbuf which contains  #    { a LookUpRecord and character strings with the socket and   "   { socket registry names in them. Here we read in the LookUpRecord " !   { and use its information to correctly read in the two strings. !    {}      { mmflags.int := 0;     { mmflags.bits[0] := TRUE; {preview read}     {}   
   mmflags.int := 1; 
 &   DS_MRead (lookuprec.int, LOOKUPREC_SIZE, lookupmbufid, 0, mmflags, ierr); &    temp := ierr;  "   DS_MRead (socketname.int, lookuprec.lu_socket_nlen, lookupmbufid, "              LOOKUPREC_SIZE, mmflags, ierr);     temp := temp + ierr;      envnamelen := lookuprec.lu_env_nlen;      DS_MRead (envname.int, envnamelen, lookupmbufid,   $             LOOKUPREC_SIZE + lookuprec.lu_socket_nlen, mmflags, ierr);  $    temp := temp + ierr;      IF (temp <> SUCCESSFUL) THEN         BEGIN         SRegLogError (LOC_2101_READING_ENVNAME, ierr);        EscapeConfirm (MEANINGLESS, 0, U_INTERNALERR);  
      END; {IF temp} 
        { Next we handle the parsing of the socket registry name by     {     {  upshifting all lower case chars;     {  checking for out-of-range chars;     {  determining if the number of hierarchies is correct;     {  completing the name if any parts are defaulted.      {}      EnvNameCheck (envname, envnamelen, ierr);  "   IF (ierr <> SUCCESSFUL) THEN EscapeConfirm(MEANINGLESS, 0, ierr); "            { See of our NReg knows about the named SReg.     {}   $   NRegFind (envname, envnamelen, ndmbufid, prepoffset, preplen, ierr);  $ "   IF (ierr <> SUCCESSFUL) THEN EscapeConfirm(MEANINGLESS, 0, ierr); "    IF (ndmbufid = NULL) THEN        BEGIN   !      { Our local NReg doesn't know anything about the referenced  !        { SReg. Before giving up, we check to see if we're running         { Probe. If we are, then we can ask it for assistance.        {}        DS_FetchElement (DS_ProtosTD, SREG, protorec.int);        IF (NOT protorec.pr_supportingpids.bits[PROBE]) THEN           BEGIN            { Probe isn't available on this node. We must give up.             {}            EscapeConfirm (MEANINGLESS, 0, U_UNKNOWN_REGISTRY);           END        ELSE           BEGIN            { We don't have to give up hope yet, we can try Probing            { for the nodal path report we need. We'll want to            { prepare a QUERY_REQUEST emsg to send down to Probe.           {{ This emsg will reference the mbuf containing the             { LookUpRecord for this transaction. Here we make sure             { that the node name contained in the lookuprecord is           { fully-qualified.            {}            IF (envnamelen > lookuprec.lu_socket_nlen) THEN  	            BEGIN  	 #            { We've had to fill in some of the defaulted parts of the  # !            { name. Because we always want to pass fully-qualified ! $            { names down to Probe, we now must update our LookUpRecord.  $             { First thing we do is cut out the old name.              {}  "            DS_MAdj (lookupmbufid, (-lookuprec.lu_env_nlen), ierr);  " 
            temp := ierr;  
                  { Next we update the node-name-length field and then               { finally write out the name itself.              {}              lookuprec.lu_env_nlen := envnamelen;  $            DS_MBOverWrite (lookuprec.int, LOOKUPREC_SIZE, lookupmbufid, $                             0, ierr);               temp := temp + ierr;      %            DS_MAppendTail (envname.int, envnamelen, lookupmbufid, ierr);  %             temp := temp + ierr;                  IF (temp <> SUCCESSFUL) THEN  
               BEGIN 
                SRegLogError (LOC_2102_FIXING_ENVNAME, temp);                 EscapeConfirm (MEANINGLESS, 0, U_INTERNALERR);                  END; {IF temp}               END; {IF envnamelen}               { We'll salvage what   !         { we can from the QUERY_REQUEST emsg just received. Note  ! !         { that we initialize the up_pid field not to the Socket-  !          { Registry's normal PID but to a special PID used to            { identify the protocol handler that SocketRegistry           { provides for the handling of Probe replies. This            { special protocol handler was added because the SR's           { inbound protocol handler became too big and had to            { be split across segments.           {}            ehport := PROBE * EHS_PER + EHOB_OFFSET;            emqrq_up_pid := SREGPROBE_PID;            emqrq_down_ref := MEANINGLESS;            emqrq_seq_num := emqrq_mbufid;   !         { Remember whether this is an IpcDest() or an IpcLookUp() ! 
         { request.  
          {}            destreq := emqrq_options.bits[0];               { emqrq_options.int := 0;  !         { emqrq_options.bits[-1] := TRUE; {don't return down ref} !           { emqrq_options.bits[-2] := TRUE; {don't destroy mbuf}             {}            emqrq_options.int := 6;               END; {IF NOT protorec}       !      { We might be handling an IpcDest() request. If so then our  ! !      { LookUpRecord contains some addressing information instead  ! !      { of a socket name. When our reply arrives from Probe we'll  ! !      { want to complete our transaction processing and we'll need !       { some way to remember whether we were processing an        { IpcLookUp() query or an IpcDest() query.        {}        IF destreq THEN            BEGIN           { To record that we're handling an IpcDest() request            { we make our LookUpRecord's urecid negative.           {}            lookuprec.lu_urecid := - lookuprec.lu_urecid;  %         DS_MBOverWrite ( lookuprec.lu_urecid, 2, lookupmbufid, 0, ierr);  %          IF (ierr <> SUCCESSFUL) THEN   	            BEGIN  	             SRegLogError (LOC_2103_OVERWRITE_LUREC, ierr);              EscapeConfirm (MEANINGLESS, 0, U_INTERNALERR);  
            END; {IF ierr} 
 
         END; {IF destreq} 
           DS_LeaveCritical (wkmp);  
      ProSw (emsg, ierr);  
       GOTO 99;        END; {IF ndmbufid = NULL}       !   { If we've received a QUERY_REQUEST generated by IpcDest() then !    { we have all the information we need to satisfy it.       { We must take the nodal path report whose mbufid we've just       { uncovered and combine its information with the addressing     { information provided by the IpcDest() caller to form a      { connect-site path report.     {}      IF emqrq_options.bits[0] THEN        BEGIN   &      DS_MDispose (lookupmbufid, ierr); {We don't need the qualifying mbuf}  &       DigOutNodalReport;      "      { Try to construct a connect-site path report by combining the " !      { information in our nodal path report and protocol element. !       {}        MakeCSiteReport (socketname, lookuprec.lu_socket_nlen,                         preport, preplen, wkmp, ierr);         IF (ierr <> SUCCESSFUL) THEN              EscapeConfirm (MEANINGLESS, 0, ierr);       !      { Now that we've constructed our connect-site path report we !        { must try to store it in DSAM and insert its gsd into the         { user's descriptor map.        {}        ChargeNAttachReport (urecid, preport, i, temp, ierr);         EscapeConfirm (i, temp, ierr);        END; {IF emqrq_options}           { Determine whether the passed name corresponds to the local        { node or to some remote node. If the correspondence is local      { then we must try to resolve the passed socket name within     { the context of our local SReg.      {}      DS_FetchFields (DS_NodesTD, 1, localndmbufid, 28, 1);     IF (localndmbufid = ndmbufid) THEN         BEGIN   $      { The socket name, if it can be resolved, can be resolved locally. $       {}  '      HashFind (FALSE, socketname, lookuprec.lu_socket_nlen, namerecid, ierr); '        IF (ierr <> SUCCESSFUL) THEN EscapeConfirm ( MEANINGLESS,                                                       0,   #                                                   U_NAME_NOT_FOUND);  #           DS_FetchElement (DS_NamesTD, namerecid, namerec.int);              { Fetch the socket referenced by the name record. Generate         { a path report to describe how to access the socket.         {}        DS_SoFetchElement (namerec.nr_socketd, socket.int);         SregSocketToPath (socket, preport, ierr);         IF (ierr <> SUCCESSFUL) THEN           BEGIN           SRegLogError (LOC_2104_S_TO_P, ierr);           EscapeConfirm(MEANINGLESS, 0, U_INTERNALERR);           END; {IF ierr}              { Try to put the path report into DSAM. Attempt to charge    "      { the memory required against the special path memory socket.  "       {}        ChargeNAttachReport (urecid, preport, i, temp, ierr);         EscapeConfirm (i, temp, ierr);        END   {IF localndmbufid}     ELSE IF (ndmbufid = NULL) THEN         BEGIN          { The referenced SReg is remote and we don't have an NReg          { entry that describes how to access it. When ADS/1000  "      { supports the PROBE protocol then we might be able to locate  "        { the NReg via PROBE. When using PROBE we'll save context           { information in the mbuf used to pass down the socket and   
      { SReg names.  
       {}        EscapeConfirm (MEANINGLESS, 0, U_UNKNOWN_REGISTRY);         END      ELSE         BEGIN   $      { The referenced SReg is remote but we've got a nodal path report  $ "      { that describes how to access it. First we dig the nodal path " "      { report that references it. From this path report we're able  " #      { to construct an outbound path that we can use to send a query  #       { to the remote node.         {}        DigOutNodalReport;            ConvertReport (CR_NODREP_TO_DPATH,                        SREG, preport, dnpath, dnpid, wkmp, ierr);          IF (ierr <> SUCCESSFUL) THEN           EscapeConfirm (MEANINGLESS, 0, ierr);      "      { Prepare the SocketRegistry socket-name query message. Put it "        { into an mbuf and charge the mbuf against the application          { user's root socket. The mbufid of the message should be          { returned through variable temp below.         {}        PrepSRNameQuery (socketname, lookuprec.lu_socket_nlen,                         lureqmsg, emqrq_up_ref, temp, ierr);         IF (ierr <> SUCCESSFUL) THEN           BEGIN           SRegLogError (LOc_2105_PREP_QUERY, ierr);           EscapeConfirm (MEANINGLESS, 0, U_INTERNALERR);            END; {IF ierr}       !      { Modify the QUERY_REQUEST emsg slightly so that we can use  !       { it to forward our query on down to PXP.         {}        ehport := dnpid * EHS_PER + EHOB_OFFSET;        emqrq_up_pid := SREG;         {emqrq_up_ref := <same as was passed from ULP requestor}        emqrq_down_ref := dnpath; {from ConvertReport()}        emqrq_mbufid := temp;         emqrq_dlen := lureqmsg.lureq_msglen;  "      {emqrq_seq_num := <same as was passed down from ULP requestor} "       { emqrq_options.int := 0;   #      { emqrq_options.bits[-1] := TRUE; {LLP should destroy down path  # '      {                                 after delivering up the QUERY_CONFIRM} '       {}        emqrq_options.int := 2;             DS_MDispose (lookupmbufid, ierr);         DS_LeaveCritical (wkmp);  
      ProSw (emsg, ierr);  
       END; {IF localndmbufid}       
   END; {WITH emsg}  
     99:;  END; {SregQueryRequest}       $PAGE   !{----------------------------------------------------------------} ! !{   SREG SOCKET TO PATH                                   (2300) } ! !{----------------------------------------------------------------} !     PROCEDURE SregSocketToPath { VAR socket  : SocketRecord;                               VAR preport : PathReportRecord;                               VAR ierr    : Int16 };       LABEL 99;       VAR      bound       : Int16;      dptr        : Int16;      dynaddr     : AddressType;      dynaddrlen  : Int16;      i           : Int16;      mmflags     : MMFlagsType;      pid         : Int16;      protorec    : ProtocolRecord;         PROCEDURE Escape ( error : Int16 );        BEGIN   
      ierr := error; 
       GOTO 99;  
      END; {Escape}  
     BEGIN   
pid := socket.so_down_pid; 
 DS_FetchElement ( DS_ProtosTD, pid, protorec.int);  
{ mmflags.int := 0;  
 { mmflags.bits[0] := TRUE; {set preview bit on}   {}  	mmflags.int := 1;  	     "DS_MRead (preport.int, protorec.pr_pathlen, protorec.pr_path_mbufid, "           0, mmflags, ierr);  IF (ierr <> SUCCESSFUL) THEN Escape(ierr);      dptr := protorec.pr_dynamicptr;   IF (dptr <> NULL) THEN     BEGIN  "   { We need to get the dynamic address needed to transform our path "    { template into a full-fledged path report.     {}      IF (pid = TCP) THEN        BEGIN   "      TcpDynamicAddr (socket.so_down_pathref, dynaddr, dynaddrlen);  "       END      ELSE         BEGIN         Escape (U_INTERNALERR);   
      END; {IF pid}  
     !   { Having gotten the needed dynamic address we can now insert it !    { into all of our template's dynamic address slots.     {}   
   WHILE (dptr <> NULL) DO 
       BEGIN   
      bound := dptr; 
       dptr := preport.ints[dptr DIV 2];  {get next dptr}        FOR i := 0 TO (dynaddrlen - 1) DO            BEGIN           preport.bytes[bound + i] := dynaddr.bytes[i];           END; {FOR i}         END; {WHILE dptr}   	   END; {IF dptr}  	 
ierr := SUCCESSFUL;  
 99:;  END; {SregSocketToPath}       $PAGE   !{----------------------------------------------------------------} ! !{   SREG TEMPLATE BUILD                                   (2400) } ! !{----------------------------------------------------------------} !     PROCEDURE SregTemplateBuild {     userpid    : Int16;                                     toppid     : Int16;                                     sp         : Int16;   "                              VAR stack      : TemplateControlStack; "                                VAR report     : PathReportRecord;                                 VAR dynamicptr : Int16;                                 VAR ierr       : Int16 };       {}  { Abstract:   "{  This routine may be called to complete the construction of either " {  a nodal- or a connect-site- path report after the template   #{  control stack to be used in the operation has been pre-initialized. # {   
{ Input parameters:  
 {   "{  sp: Pointer to the topmost template control record on the stack.  " {    {  stack: Pre-initialized template control stack containing one    {     or more template control records.   {   
{ Output parameters: 
 {   {  report: Fully constructed path report template.  {   "{  dynamicptr: Relative offset from the beginning of the path report " {     to the first of possibly several dynamically-determined    {     address fields within the path report. All such fields are   {     to be linked together to facilitate adding the dynamic  {     information later.  {   {  ierr: The resultant error code, else SUCCESSFUL.   {}      LABEL 99;       VAR      crec        : TemplateControlRecord;      domainstart : Int16;      i           : Int16;      oldrptr     : Int16;      pathstart   : Int16;      reportstart : Int16;      rptr        : Int16;   
   starting    : BOOLEAN;  
    temp        : Int16;      vnarec      : VnaRecord;      vnareclen   : Int16;              PROCEDURE Escape ( error : Int16 );        BEGIN   
      ierr := error; 
       GOTO 99;  
      END; {Escape}  
     BEGIN   #rptr := 2;  {skip path report length, reference domain report length}  # 	starting := TRUE;  	 dynamicptr := NULL; {terminator for end of linked list}       { Process and use the template control stack to build the path  	{ report template. 	 {}  	WHILE (sp <> 0) DO 	    BEGIN  !   { Pop the topmost control record. Most of these control records ! "   { will effectively request the addition of new protocol elements, "    { but some will request the addition of new VNAs.     {}      crec := stack[sp];      sp := sp - 1;      "   { Check to see if we've completed the previous path and now need  " "   { to begin a new variation of it. If we have then we must set the " "   { length of the last path, then copy part of it, and then resume  "    { building.     {}      WITH crec DO         BEGIN         IF ((rptr > oldrptr) AND            ((tc_activepid <> SREG) AND (tc_pathoffset <> 0))) THEN            BEGIN            { The control record just popped reveals that one path    #         { has just been completed and now we're to begin constructing # "         { a variation on that path. To do this we make a copy of as "          { much of the current path as we can use.           {}            report.ints[pathstart DIV 2] := rptr - pathstart - 2;           FOR i := 0 TO (tc_pathoffset - 1) DO   	            BEGIN  	 !            report.bytes[rptr + i] := report.bytes[pathstart + i]; !             END; {FOR i}                { The path portion just copied might include a dynamic             { dispatch address part. If it does then we need to  !         { link the dynamic part of our new path into our dynamic  ! 
         { address chain.  
          {}            IF (dynamicptr > pathstart) THEN   	            BEGIN  	             temp := rptr + dynamicptr - pathstart;              report.ints[temp DIV 2] := dynamicptr;              dynamicptr := temp;               END; {IF dynamicptr}      "         { Now we set "pathstart" so it references the beginning of  " !         { our new path, and we set "rptr" to index the first byte !          { beyond what we just copied.           {}            pathstart := rptr; {see new path start}           rptr := pathstart + tc_pathoffset;            END; {IF tc_activepid}             oldrptr := rptr;  
      CASE tc_activepid OF 
              SREG:  	            BEGIN  	 !            { The stack entry is associated with a VNA. The first  ! !            { VNA in a path report is handled slightly differently !              { than the others because it won't have any paths or   !            { domain reports preceding it that need finishing off. !             {}              IF starting THEN  
               BEGIN 
                 { The control record is associated with the first                  { VNA in the path report.  	               {}  	                starting := FALSE;   	               END 	             ELSE  
               BEGIN 
 "               { The control record is associated with a VNA that is " !               { coming along after the first. Before adding a new ! #               { VNA entry and beginning construction of a new domain  # #               { report we must finish off the old domain report that  # #               { we had been working on. To do this we need to fill in # "               { the old domain report's length now that it's known. " !               { We also need to finish off the old path's length. ! 	               {}  	 $               report.ints[domainstart DIV 2] := rptr - domainstart - 2; $ "               report.ints[pathstart DIV 2] := rptr - pathstart - 2; "                END; {IF starting}                   { We want to remember where the new domain report                { begins, i.e., we want to remember where the domain                { report's length field is so that we can fill it in               { later after we've determined the domain report's              { length.               {}              domainstart := rptr;              rptr := rptr + 2; { index first byte of VNA area}       "            { We need to initialize the domain report's VNA portion. " !            { The information to be filled into this area must be  ! !            { provided by the protocol that supports VNA's within  ! 
            { the domain.  
             {}              IF (tc_uppid = IP) THEN   
               BEGIN 
                 IpVnaSupplier (tc_pathoffset, vnarec, vnareclen);                  FOR i := 0 TO (vnareclen - 1) DO                     report.bytes[rptr + i] := vnarec.bytes[i];                 rptr := rptr + vnareclen;  	               END 	             ELSE  
               BEGIN 
                { Internal error.  	               {}  	                SRegLogError (LOC_2300_NOT_IP, tc_uppid);                 Escape ( U_INTERNALERR );                 END; {IF tc_uppid}                   pathstart := rptr;              rptr := rptr + 2;       "            { Push control record for topmost protocol in the paths  " !            { that will be generated under this domain. For now we ! !            { assume there will only be one such topmost protocol. !              { In the future, we might get fancy and permit, say,   !            { IPC call sockets to be bound to multiple protocols.  !              { When that day comes our algorithm will have to be                { modified slightly.              {}  
            sp := sp + 1;  
             WITH stack[sp] DO   
               BEGIN 
                tc_activepid := toppid;                 tc_pathoffset := 0;                 tc_uppid := userpid;                  END; {WITH stack}              END; {SREG case}               TCP:   	            BEGIN  	             { We must invoke TCP's template building routine.               {}              TcpAddElement (sp, stack, crec, vnarec,   #                           pathstart, rptr, report, dynamicptr, ierr); #             IF (ierr <> SUCCESSFUL) THEN  
               BEGIN 
                SRegLogError (LOC_2301_TCP_ADD, ierr);                  Escape (U_INTERNALERR);                 END; {IF ierr}               END; {TCP case}                IP:  	            BEGIN  	             IPAddElement (sp, stack, crec, vnarec,  #                          pathstart, rptr, report, dynamicptr, ierr);  #             IF (ierr <> SUCCESSFUL) THEN  
               BEGIN 
                SRegLogError (LOC_2302_IP_ADD, ierr);                 Escape ( U_INTERNALERR);                  END; {IF ierr}   
            END; {IP case} 
     	         IEEE_802: 	 	            BEGIN  	             IEEE802AddElement ( sp, stack, crec, vnarec,  &                                pathstart, rptr, report, dynamicptr, ierr);  &             IF (ierr <> SUCCESSFUL) THEN  
               BEGIN 
                SRegLogError (LOC_2303_LAN_ADD, ierr);                  Escape (U_INTERNALERR);                 END; {IF ierr}               END;               X25:   	            BEGIN  	             X25AddElement ( sp, stack, crec, vnarec,                              pathstart, rptr, report,                              dynamicptr, ierr);              IF (ierr <> SUCCESSFUL) THEN  
               BEGIN 
                SRegLogError (LOC_2304_X25_ADD, ierr);                  Escape(U_INTERNALERR);                  END; {IF ierr}               END; {X25 case}       	         OTHERWISE 	 	            BEGIN  	             SRegLogError (LOC_2305_OTHERWISE, tc_activepid);              Escape (U_INTERNALERR);               END; {OTHERWISE}  
         END; {CASE} 
       END; {WITH crec}  	   END; {WHILE sp} 	     { The control stack is now empty. Before we can consider our  { path report generation task complete we must initialize   { the last path's length, the last domain report's length,  { and the entire path report's length.  {}  	rptr := rptr - 2;  	 report.ints[0] := rptr;       {path report length}  report.ints[domainstart DIV 2] := rptr - domainstart;   report.ints[pathstart DIV 2] := rptr - pathstart;       99:;  END; {SregTemplateBuild}      END. {OF SREGLIB IMPLEMENT}  