 $PASCAL '91790-1X200 REV.4010 <860226.1540> '   $ TITLE 'DS 1K-3K INITIALIZATION' $   $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 2 $  
$ HEAP_DISPOSE OFF $ 
 $ DEBUG $   MODULE S3Kinit;   	$ALIAS 'N$S3Kinit' 	     {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  {     NAME:   S3KINIT   
{     SOURCE: 91790-18200  
 	{     RELOC:  NONE 	 {     PGMR:   EW  {}      {}  {   "{  This module contains the DS/1000-IV 1000-3000 links and Services  " {  routines for NSINIT.   {   {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   %{ 850506  EW    Moved LU type Check from LU init. to table building time.  % { 860225  lms   Moved error strings to NSINIT.MSG (n356).   {   {------------------------------------------------------------   {}      {}  { MODULE DESCRIPTION:   {   #{     ThreeKInit contains six exported subroutines for initialization  # {     and shutdown of DS/1000-IV services/links to DS/3000. In  ${     addition, several subroutines used within the module are included  $ {     here. The six exported subroutines are:   {   #{     SYN3K1 : Determines whether the user wants DS/1000-IV to DS/3000 # #{     services. If they do, a global flag is set to indicate this and  # ${     the size of the Transaction Status Table (TST) is determined from  $ "{     user input. The size of the TST is kept in a variable local to " 	{     this module. 	 {   #{     SYN3K2 : Gathers, from user input, link related information. The # ${     number of X.25 POOL LUs to allow for, the LU numbers of any Bisync $ !{     LUs, and Bisync ID sequences (if applicable) are determined. ! ${     All data gathered is kept either in variables local to this module $ {     or in EMA (Bisync LU numbers).  {   !{     INIT3K1 : Schedules the programs required for DS/1000-IV to  ! ${     DS/3000 communication (QUEX, QUEZ, RQCNV, RPCNV), builds the 3000  $ #{     LU table in System Memory Block (SMB), and stores the Bisync ID  # %{     sequences in labeled common ("RES"). The following entry points are  % {     altered in labeled common ("RES");  {          #3KLU    -  number of entries in the 3000 LU table   "{          #D$XS5   -  Bisync/HSI indicator (always = 2 for Bisync)  " "{          #LU3K    -  address of first entry in 3000 LU table (SMB) " {          #LU3K+1  -  local Bisync ID sequence   {          #LU3K+11 -  remote Bisync ID sequence  {          #QZCL    -  QUEZ class number  {          #QXCL    -  QUEX class number  {          #RQCL    -  RQCNV class number   {          #RPCL    -  RPCNV class number    {          #TST     -  Pointer to Transaction Status Table (SMB)   {          #TST+1   -  number of TST entries  {   #{     INIT3K2 : Enables all Bisync LUs in the 3000 LU table by calling # {     the MACRO routine D$RLU.  {   ${     SHUT3K1 : Stops all programs scheduled by INIT3K1 and deallocates  $ #{     their class numbers. In addition, the labeled common entry point # ${     #LU3K is set to zero. Entry points #QZCL, #QXCL, #RPCL, and #RQCL  $ "{     are set to zero when the class numbers are deallocated. Entry  " ${     points #3KLU, #TST, and #TST+1 are set to zero by the DSINIT main  $ {     program (subroutine DeallocateSMP).   {   "{     SHUT3K2 : Sends a disconnect control request to all Bisync LUs " {     in the 3000 LU table.   {   {   {}  IMPORT         { memory manager declarations }  $ SEARCH 'phtm/bodec.rel'  $     Bodec,      { intitialization declarations }   $ SEARCH 'phtm/init_dec.rel' $     Init_Dec,  $ SEARCH 'phtm/initmulti.xpt'$     initmulti,      { File I/O routines }  $ SEARCH 'phtm/filemad.xpt'$     FileMan,   
   { Parsing subroutines } 
 $ SEARCH 'phtm/parsdd.xpt'$      Parser,     { Dummy RES }  
$ SEARCH 'phtm/dres.xpt'$  
    DRes,      
   { RTE routines }  
 $ SEARCH 'phtm/init_rte_if.xpt'$     Init_RTE_IF,       
   { SMB routines }  
 
$ SEARCH 'phtm/alloc.xpt'$ 
    alloc;           EXPORT         PROCEDURE Syn3k1(VAR memory_block:     Int16;                      VAR dsamsize:    Int16;                       VAR socketcnt:   Int16;                       VAR classcnt:    Int16;                       VAR resourcecnt: Int16;                       VAR result:     Int16);          PROCEDURE Syn3k2(VAR memory_block:     Int16;                      VAR dsamsize:    Int16;                       VAR socketcnt:   Int16;                       VAR classcnt:    Int16;                       VAR resourcecnt: Int16;                       VAR result:     Int16);          PROCEDURE Init3k1(VAR result:     Int16);         PROCEDURE Init3k2(VAR result:     Int16);         PROCEDURE Shut3k1(VAR trustvar:   TrustType;                        VAR result:     Int16);         PROCEDURE Shut3k2(VAR trustvar:   TrustType;                        VAR result:     Int16);          $ SUBTITLE 'Implement', PAGE $  IMPLEMENT       ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${              GLOBAL CONSTANTS, TYPES AND VARIABLES                  }  $ ${                                                                     }  $ ${  The variables declared in this section are those variables which   }  $ ${  must be shared between procedures and/or functions within this     }  $ ${  module.                                                            }  $ ${  As a general rule any variable declared as global to this module   }  $ ${  is only referenced by one or more of the exported subroutines. If  }  $ ${  a lower level routine must access a global variable it is passed   }  $ ${  as a parameter to the subroutine.                                  }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ CONST   %   BAD3K_LU_ERROR = -99;          { !!!! this goes into lissa's code !!! } % $   DEFAULT_USERS = 4;           { default number of concurrent users  }  $ $   DEFAULT_X25_LUS = 0;         { default number of X.25 POOL LUs     }  $ $   ID_ENTRIES = 2;              { number of id sequences stored in RES}  $ $   ID_SIZE = 16;                { byte length of an ID sequence       }  $ $   LID_OFFSET = 1;              { word offset from #LU3K to local ID  }  $ $   LOCAL = 1;                   { index into ID table of local ID seq.}  $ $   LU_ENTRY_SIZE = 2;           { word length of a 3K LU table entry  }  $ $   MAX_BISYNC_LU = 255;         { highest bisync LU number allowed    }  $ $   MIN_BISYNC_LU = 1;           { lowest bisync LU number allowed     }  $ $   MAX_USERS = 10;              { maximum concurrent 3k users allowed }  $ $   MIN_USERS = 0;               { minimum concurrent 3k users allowed }  $ $   MAX_X25_LUS = 255;           { max number of X.25 POOL LUs allowed }  $ $   MIN_X25_LUS = 0;             { min number of X.25 POOL LUs allowed }  $ $   NO_OFFSET = 0;               { for storring into RES with no offset}  $ $   NUMBER_OF_CLASSES = 4;       { number of class numbers for 3k comm.}  $ 	   QUEX = 'QUEX '; 	 	   QUEZ = 'QUEZ '; 	 $   RID_OFFSET = 11;             { word offset from #LU3K to remote ID }  $ 
   RQCNV = 'RQCNV '; 
 
   RPCNV = 'RPCNV '; 
 $   REMOTE = 2;                  { index into ID table, remote ID seq. }  $ $   START_BUFFER_SIZE = -1;      { used in 3K LU table for 'not init.' }  $ $   STATUS = 13 + NOABORTBIT;    { request code for device status      }  $ $   TST_ENTRY_SIZE = 15;         { word size of a Trans. Status Entry  }  $ $   TYPE66 = 54;                 { type 66 (octal) device              }  $     ${**********************************************************************} $ ${*          All messages unique to this module live here.             *} $ ${**********************************************************************} $     	   BISYNC_LU_MSG = 	       '* Enter a PSI-Bisync LU. Type /E to end:_';  !   CHG_ID_MSG = '* Do you want to modify these values [Y/(N)] ?_'; ! 	   CHG_LOCAL_MSG = 	 !      '* Enter a local ID sequence [/D = none, Type /E to end] :'; ! 
   CHG_REMOTE_MSG =  
 #         '* Enter a remote ID sequence [/D = none, Type /E to end] :'; #    ID_HEADER_MSG = '*++    BISYNC ID SEQUENCES    ++*';      SHOW_LOCAL_MSG =  '*    Local ID sequence  : none ';      SHOW_REMOTE_MSG = '*    Remote ID sequence : none ';   %   SERVICES_MSG ='* Do you want DS/1000-IV 1000-3000 services [Y/(N)]?_';  %    USERS_MSG1 =   %      '* Enter the maximum number of concurrent DS/3000 users to access';  %    USERS_MSG2 =         ' this node [0..(4)..10]:_';     X25_LU_MSG1 =  #      '* Enter the maximum number of concurrent X.25 pool LUs used ';  #    X25_LU_MSG2 =        'for DS/1000-IV to DS/3000 communication [(0)..255]:_';       TYPE     CntWdType = PACKED RECORD        Fill1 : Posint8;        LU    : Posint8;  
      Fill2 : Int16; 
       END;         DvrStatType  = PACKED RECORD         availability : Posint2;         device_type  : Posint6;         fill         : Posint6;         soft_error   : BOOLEAN;         hard_error   : BOOLEAN;         END;         Id_Char_Type = PACKED ARRAY [1..ID_SIZE] OF CHAR;     Id_Int_Type  = PACKED ARRAY [1..ID_SIZE DIV 2] OF Int16;      Id_Type = RECORD CASE BOOLEAN OF                   TRUE : (int : Id_Int_Type);                   FALSE: (char: Id_Char_Type);  	             END;  	        Id_Rec_Type = RECORD                       Length : Int16;                       ID     : Id_Type;                    END;          Id_Table_Type = PACKED ARRAY[LOCAL..REMOTE] OF Id_Rec_Type;         LuTablePtr = ^Lu3k_Entry;         Lu3k_Entry = Record           Link:     LuTablePtr;  
         Lu:       Int16;  
          END;       VAR       $   end_lutable         : LuTablePtr;    { end of 3k LU list           }  $ $   head_lutable        : LuTablePtr;    { start of 3k LU list         }  $ $   id_table            : Id_Table_Type; { local ID storage            }  $ $   lu_table_size       : Int16;         { words in 3k LU table        }  $ $   tst_entries         : Int16;         { number of TST entries       }  $ $   tst_size            : Int16;         { size of TST in words        }  $     "FUNCTION Reset_Lu(lu_number : Int16;               $ ALIAS 'D$RLU' $ "                   reason    : Int16) : Int16;                     EXTERNAL;       	$ HEAPPARMS OFF $  	 &PROCEDURE Get_lu_stats (    rcode     : Int16;     $ ALIAS 'XLUEX', NOABORT$ &                         VAR cntwd     : CntWdType;                          VAR stats     : DvrStatType);                           EXTERNAL;   $ HEAPPARMS ON $      #PROCEDURE Get_A_3000_Lu(index     : Int16;          $ ALIAS 'D$3IN' $  #                         lu_num    : Int16;                          bufsize   : Int16;                          cont_flag : Int16;                          X25_flag : Int16);                    EXTERNAL;       "PROCEDURE Get_Registers(a_register : Int16;        $ ALIAS 'ABREG' $ "                         b_register : Int16);                    EXTERNAL;        PROCEDURE MoveIntoRes                          $ ALIAS 'D$MIR' $   	$ HEAPPARMS OFF $  	           ( ResAccess: Int16;              resoffset : Int16;              data      : Int16;              datalen   : Int16);  	$ HEAPPARMS ON  $  	 EXTERNAL;       $ SUBTITLE 'Add_LU', PAGE $   ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                             Add_LU                                  }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ PROCEDURE Add_LU(VAR lu_number : Int16;                    VAR duplicate : BOOLEAN;                    VAR head_ptr  : LuTablePtr;                   VAR tail_ptr  : LuTablePtr);   ${---------------------------------------------------------------------}  $ ${ PURPOSE: Links a Bisync LU number into a global list in EMA. LU     }  $ ${   numbers are not duplicated in the list.                           }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   lu_number     INPUT    number of the LU to be added.              }  $ ${   duplicate     OUTPUT   TRUE if the LU is already in the list.     }  $ ${   head_ptr      INPUT    Pointer to first LU in linked LU list.     }  $ ${   tail_ptr      INPUT    Pointer to last LU in linked LU list.      }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${   The global pointers "head_lutable" and "end_lutable" may be       }  $ ${   modified by this procedure. These pointers MUST be initialized    }  $ ${   prior to calling this procedure.                                  }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   None accessed directly.                                           }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   If an LU number is passed in which is found to be in the linked   }  $ ${   list, the parameter "duplicate" will be set to TRUE to warn the   }  $ ${   caller. In the case of a duplicate LU no change is made in the    }  $ ${   list. No errors are returned, if an error is encountered in a call}  $ ${   to new, the error catcher should abort the user.                  }  $ ${                                                                     }  $ ${ ALGORITHM:                                                          }  $ ${                                                                     }  $ ${   If no LUs in list then                                            }  $ ${     Add this LU as the first                                        }  $ ${   else                                                              }  $ ${     Make sure this one isn't already in the list                    }  $ ${     and if it isn't then add it to the end.                         }  $ ${     If the LU is already in the list tell the caller.               }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ VAR      current : LuTablePtr;         BEGIN   { Procedure Add_Lu }         IF head_Ptr = NIL THEN           BEGIN { adding the first entry to the list }   
            NEW(head_ptr); 
             tail_ptr := head_ptr;               head_Ptr^.link := NIL;              head_Ptr^.lu := lu_number;              duplicate := FALSE;            END { adding the first entry }         ELSE           BEGIN { adding entry "n" }   !            duplicate := FALSE; { assume this is not a duplicate } !             current := head_ptr;              WHILE (current <> NIL) AND (NOT duplicate) DO                   BEGIN { shoot the list looking for a duplicate }                      IF current^.lu = lu_number THEN                        BEGIN   { handling duplicate LU }                          duplicate := TRUE                        END     { handling duplicate LU }                    ELSE                       BEGIN   { moving to next entry }                           Current := Current^.link;                        END;    { moving to next entry }                  END; { shooting the list }               IF (NOT duplicate) THEN   !               BEGIN { add the new entry to the end of the list }  !                   NEW(current);                     current^.link := NIL;                     current^.lu := lu_number;                     tail_ptr^.link := current;                    tail_ptr := current;                 END; { adding the new entry }           END;  { adding entry "n" }      END;    { Procedure Add_Lu }       $ SUBTITLE 'Build_3k_Lu_table', PAGE $  ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                        Build_3K_Lu_Table                            }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ PROCEDURE Build_3K_Lu_Table(VAR head_ptr : LuTablePtr;                              VAR end_ptr  : LuTablePtr;                              VAR lu_table_size : int16;                              VAR result       : Int16);  ${---------------------------------------------------------------------}  $ ${ PURPOSE: Builds the 3000 LU table in System Memory Block.           }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${    head_ptr      INPUT pointer to head of LU list or NIL if empty   }  $ ${    tail_ptr      INPUT pointer to tail of LU list or NIL if empty   }  $ ${    lu_table_size INPUT number of words in the 3000 LU table         }  $ ${    result        OUTPUT error indicator (0 = no error)              }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${   The labeled common ("RES") entry points #3KLU and #LU3K are set   }  $ ${   to the number of entries in the 3000 LU table and the address     }  $ ${   in SMB of the first word of the table. These entry points are     }  $ ${   not set untill the table is built to prevent erroneous access     }  $ ${   to the table while it is being built.                             }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   None accessed.                                                    }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${    An error will be returned to the caller under two conditions.    }  $ ${    If an error is returned by the call to GetSmbaddress it will     }  $ ${    be rippled back up to the caller. If an LU in the list is        }  $ ${    not type 66, or the dynamic ststue call fails an error           }  $ ${    message will be printed and an error code rippled back to        }  $ ${    the caller.                                                      }  $ ${                                                                     }  $ ${ ALGORITHM:                                                          }  $ ${                                                                     }  $ ${   Allocate system memory Block.                                     }  $ ${   For every LU in the linked list;                                  }  $ ${     Check for a type 66 LU.                                         }  $ ${     Put the LU number in SMB followed by a -1                       }  $ ${                                                                     }  $ ${ NOTE:                                                               }  $ ${   There are, currently, no checks in this routine to ensure the     }  $ ${   integrity of the linked list containing the LU numbers. If the    }  $ ${   value determined for the size of the 3000 LU table is not large   }  $ ${   enough to contain all of the LUs, SMB not allocated to the        }  $ ${   table will be overwritten. It is assumed that the list and the    }  $ ${   size of the table are both correct.                               }  $ ${---------------------------------------------------------------------}  $     VAR   %   cntwd           : CntWdType;   { XLUEX control word type             }  % %   current_address : Int16;       { address in SMB being initialized    }  % %   current_entry   : LuTablePtr;  { pointer to LU number in EMA         }  % %   dummy           : Int16;       { for string write                    }  % %   error_string    : IStringType; { error message goes here             }  % %   head_of_table   : Int16;       { SMB address of first LU table entry }  %    local_error     : Int16;   %   rcode           : Int16;       { xluex request code                  }  % %   stat1           : DvrStattype; { DVT word 6 returned from exec 13    }  %        BEGIN { Build_3K_Lu_Table }        result := GOOD;         DS_GetSMBAddr(lu_table_size, head_of_table, result);        IF result = GOOD THEN            BEGIN   { building table }               current_address := head_of_table;               Current_Entry := Head_Ptr;               WHILE (current_entry <> NIL) AND (result = GOOD) DO                   BEGIN   { WHILE loop }                     Cntwd.fill1 := 0;                     Cntwd.fill2 := 0;                     Cntwd.lu := current_entry^.lu;                    rcode := -32755;                    Get_lu_stats (rcode, cntwd, stat1);                        BEGIN { error on XLUEX }                        { set device type to 0 for error }                        stat1.device_type := 0;                       END;  { error on XLUEX }                     IF stat1.device_type <> TYPE66 THEN                        result := BAD3K_LU_ERROR;                    IF result = GOOD THEN                        BEGIN { putting LU in table }  $                     DS_MoveIntoSMB(current_entry^.lu, current_address); $                      current_address := current_address + 1;  $                     DS_MoveIntoSMB(start_buffer_size, current_address); $                      current_address := current_address + 1;                       current_entry := current_entry^.link;                       END;   { putting LU in table }                  END;    { WHILE loop }               IF result = GOOD THEN                  BEGIN { setting up RES entry points }  '               DS_StoreResElement(NSINIT_AdrOf( Lb_LU3K ), 0, head_of_table);  '                DS_StoreResElement(NSINIT_AdrOf( Lb_3KLU ), 0,   "                                  lu_table_size DIV LU_ENTRY_SIZE);  "                    END   { setting up RES entry points }              ELSE                 BEGIN { bad LU type found }                 SetStrLen (error_string, 0);   $               StrWrite (error_string, 1, dummy,'** (353) NS: Error: ',  $                 'Wrong type or can''t read device type for LU: ',                  current_entry^.lu:1, '.**' );                 PrintError (error_string, local_error);                 END;  { bad LU type found }           END;    { building table }      END; { Build_3K_Lu_Table }   $ SUBTITLE 'Schedule_Program', PAGE $   ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                         Schedule_Program                            }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ PROCEDURE Schedule_Program (    Name       : PNameType;                                   Res_Access : Int16;                                   required   : BOOLEAN;                               VAR error      : Int16);  ${---------------------------------------------------------------------}  $ ${ PURPOSE: This procedure allocates a class number, and schedules a   }  $ ${   DS program. The class number is placed in the indicated position  }  $ ${   in Labeled common.                                                }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   Name        INPUT    name of program to schedule                  }  $ ${   Res_Access  INPUT    address for class number storage             }  $ ${   required    INPUT    is this a required monitor                   }  $ ${   error       OUTPUT   error indicator                              }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${   When the class number is allocated it is stored in labeled common }  $ ${   by the allocation subroutine.                                     }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   None accessed.                                                    }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   If an error is returned from class the class allocation           }  $ ${   routine it is returned to the caller and no attempt is made       }  $ ${   to schedule the specified program. If the schedule attempt        }  $ ${   fails, the action is determined by the "required" parameter.      }  $ ${   If this parameter is set to TRUE (the program is required)        }  $ ${   a message is printed reporting the error an the error is          }  $ ${   returned to the caller. If the "required" parameter is set        }  $ ${   to false, an warning is printed but no error is returned to       }  $ ${   the caller.                                                       }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     CONST     CLASSBITS = 8192;   { OCT 20000 = BIT 13 = rethread bit }       VAR      Class_Number : Int16;     error1       : Int16;       { local error return }   
   Error_Flag   : BOOLEAN; 
        BEGIN { Schedule_Program }         Error_Flag := TRUE;  { do print an error on schedule }  !      DS_GetClass(Res_Access, 0, CLASSBITS, Class_Number, Error);  !       IF (error = GOOD) THEN           BEGIN    { scheduling }  !         DS_StartMonitor( Name, Class_Number, Error_Flag, Error);  !           IF (( error <> GOOD ) AND ( error <> NOTDORMANT )) THEN               BEGIN    { error handling }                  IF required THEN   "                  { Print error and return error to caller.       }  " "                  { Any error returned by the print error routine }  " "                  { is ignored.                                   }  "                   BEGIN { non-abortable error }                     PrintError( NO_REQ_MON_ABORTMSG, error1 );                    error := ERR_ALREADY_PRINTED;                     END   { non-abortable error }   
               ELSE  
                   BEGIN { abortable error }   #                  { Set error to GOOD (no error) and print an       }  # #                  { warning. Any error from the warning gets passed }  # #                  { back to the caller.                             }  #                   error := GOOD;                    PrintError( NO_REQ_MONMSG, error);                    END;  { abortable error }   $               { any error from the print will be passed back to caller} $             END;     { error handling }            END;     { scheduling }     END;  { Schedule_Program }       $ SUBTITLE 'ThreeksInSystem', PAGE $  ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                         ThreeKsInSystem                             }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ FUNCTION ThreeKsInSystem (VAR error : Int16) : BOOLEAN;   ${---------------------------------------------------------------------}  $ ${ PURPOSE: This function determines from user input whether or not    }  $ ${   the user will have DS/1000-IV 1000-3000 services in the system.   }  $ ${   If the user wishes these services, a TRUE is returned, else a     }  $ ${   FALSE.                                                            }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   error     OUTPUT     returns any error encountered during input/  }  $ ${                        output to the caller.                        }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${   Calls DSINIT I/O routines.                                        }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   None accessed.                                                    }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   If an error is returned from the I/O routines, it is passed back  }  $ ${   to the caller and the BOOLEAN function returns FALSE.             }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     VAR      default : BOOLEAN;      input_char : OneCharType;         BEGIN        default := TRUE;        YesNoInput(SERVICES_MSG, default, input_char, error);         IF error <> GOOD THEN            BEGIN   { set function to FALSE on error }              ThreeKsInSystem := FALSE;           END     { set function to FALSE on error }         ELSE           BEGIN   { returning users choice }               IF ((input_char = 'N') OR (default)) THEN                  ThreeKsInSystem := FALSE               ELSE                 ThreeKsInSystem := TRUE;            END;    { returning users choice }      END;       
$ SUBTITLE 'DoTST', PAGE $ 
 ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                             DoTST                                   }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ PROCEDURE DoTST (VAR number_of_words   : Int16;                    VAR number_of_entries : Int16;                    VAR error : Int16);  ${---------------------------------------------------------------------}  $ ${ PURPOSE: Determines, from user input, the size of the Transaction   }  $ ${   Status Table to allow when initializing DS/1000-IV 1000-3000      }  $ ${   services.                                                         }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   number_of_words       OUTPUT     number of words to allow         }  $ ${   error                 OUTPUT     error indicator                  }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${   Calls DSINIT I/O routines.                                        }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   None accessed.                                                    }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   If an error is encountered during I/O, the error is returned to   }  $ ${   the caller and the number of entries is left unaltered.           }  $ ${                                                                     }  $ ${ NOTES:                                                              }  $ ${   The size of the TST may be set to zero but, if it is, any master  }  $ ${   requests from the 3000 will be rejected by RQCNV.                 }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     VAR      default           : BOOLEAN;      terminator        : BOOLEAN;      local_error       : Int16;          BEGIN   { procedure DoTST }        default := TRUE;  
      terminator := FALSE; 
           IntInput(USERS_MSG1 + USERS_MSG2, default, terminator,            max_users, min_users, number_of_entries, local_error);              error := local_error;       
      IF error = GOOD THEN 
          BEGIN   { processing user input }              IF default THEN                  BEGIN   { setting defaults }                     number_of_entries := DEFAULT_USERS;                  END;    { setting defaults }   !            number_of_words := number_of_entries * TST_ENTRY_SIZE; !           END;   { processing user input }         END;    { Procedure DoTST }      
$ SUBTITLE 'DoX25', PAGE $ 
 ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                         PROCEDURE DoX25                             }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ PROCEDURE DoX25 (VAR number_of_lus : Int16;                    VAR error : Int16);  ${---------------------------------------------------------------------}  $ ${ PURPOSE: Determines from user input the number of X.25 POOL LUs     }  $ ${   which may be expected in the system.  This, in turn, will         }  $ ${   determine the number of entries to allow in the 3000 LU table.    }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   number_of_lus     OUTPUT     number of lu specified by the user.  }  $ ${   error             OUTPUT     error indicator                      }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${   Calls DSINIT I/O routines.                                        }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   None accessed.                                                    }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   If an error is returned from a subroutine call, it is returned to }  $ ${   the caller and the number_of_lus parameter is left unaltered.     }  $ ${   No internal errors are generated.                                 }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     VAR      default    : BOOLEAN;     terminator : BOOLEAN;     local_error : INT16;          BEGIN   { procedure DoX25 }        default := TRUE;  
      terminator := FALSE; 
           IntInput(X25_LU_MSG1 + X25_LU_MSG2, default, terminator,            MAX_X25_LUS, MIN_X25_LUS, number_of_lus, local_error);              error := local_error;       
      IF error = GOOD THEN 
          BEGIN   { processing user input }              IF default THEN                  number_of_lus := DEFAULT_X25_LUS;           END;    { processing user input }         END;    { Procedure DoX25 }      $ SUBTITLE 'DoBisyncLUs', PAGE $  ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                            DoBisyncLUs                              }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ PROCEDURE DoBisyncLUs (VAR number_of_lus : Int16;                          VAR error : Int16);  ${---------------------------------------------------------------------}  $ ${ PURPOSE: Builds a linked list of Bisync LU numbers in EMA, based    }  $ ${   upon LU numbers specified by the user.                            }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   number_of_lus     OUTPUT     number of unique LUs specified       }  $ ${   error             OUTPUT     error indicator                      }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${   Calls DSINIT I/O routines.                                        }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   head_lu_table and end_lu_table are modified in building the       }  $ ${   linked list of Bisync LUs.                                        }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   Errors returned by I/O subroutines are passed back to the user.   }  $ ${   Upon this type of an error exit the value of the first parameter  }  $ ${   will reflect the number of LUs input by the user before the error.}  $ ${   If the user enters a duplicate LU number an error message is      }  $ ${   output and the user re-propted if possible. If the input is not   }  $ ${   interactive, no recovery is possible and an error is returned to  }  $ ${   the caller.                                                       }  $ ${                                                                     }  $ ${ ALGORITHM:                                                          }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     VAR      default    : BOOLEAN;     duplicate  : BOOLEAN;     terminator : BOOLEAN;     local_error : INT16;      lu_number : INT16;          BEGIN   { procedure DoBisyncLus }      
      number_of_LUs := 0;  
 
      end_LuTable := NIL;  
 
      head_LuTable := NIL; 
       default := FALSE;             REPEAT   { until user is done or we have an error }                terminator := TRUE;  #         IntInput( BISYNC_LU_MSG, default, terminator, MAX_BISYNC_LU,  #                   MIN_BISYNC_LU, lu_number, local_error);       $         error := local_error; { this to get around PASCAL HEAP limits } $              IF (local_error = GOOD) AND (NOT terminator) THEN              BEGIN   { processing user input }   $               Add_LU(lu_number, duplicate, head_lutable, end_lutable);  $                IF duplicate THEN                    BEGIN   { handling duplicate LU }                        { Inform the user of their error and   }                        { if input is not interactive flag it  }                        { as an error.                         }       $                     MsgFilePrint( DUP_3KLU, PMT_ERROR, 0, local_error); $                      error := local_error;                       SayOutputNeedsEdit;                       IF NOT Initglobals.IG_Interactive THEN                           BEGIN   { handling abort situation }                             error := DUP_LU_ERROR;                           END;    { handling abort situation }                        END     { handling duplicate LU }                  ELSE  { not a duplicate }                    BEGIN   { handling new LU }                        number_of_LUs := number_of_LUs + 1;                    END;    { handling new LU }               END;    { processing user input }             UNTIL ((terminator) OR (ERROR <> GOOD))      END; { Procedure DoBisyncLUs }       $ SUBTITLE 'DoIDSequences', PAGE $  ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                        DoIdSequences                                }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ PROCEDURE DoIdSequences (VAR id_table : Id_Table_Type;                           VAR error : Int16);  ${---------------------------------------------------------------------}  $ ${ PURPOSE: This procedure builds the Bisync id sequences to be used   }  $ %{   for DS/1000-IV 1000-3000 communication.                              } % ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   id_table     OUTPUT     a two element array used to store the ids }  $ ${   error        OUTPUT     error indicator (0 = no error)            }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${   Calls DSINIT I/O routines.                                        }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   None accessed.                                                    }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   If an error is encountered during I/O, the error code is returned }  $ ${   to the caller and the id_table is left in an undetermined state.  }  $ ${                                                                     }  $ ${ ALGORITHM:                                                          }  $ ${                                                                     }  $ ${   Set ID lengths to zero.                                           }  $ ${   Display default ID sequences.                                     }  $ ${   If user wishes to change them, then for local and remote          }  $ ${     get new ID sequence as a string                                 }  $ ${     make sure its less not too long and move it into the ID table.  }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ LABEL      999;       VAR   
   casefold     : BOOLEAN; 
 
   default      : BOOLEAN; 
    input_char   : OneChartype;     input_string : IStringType;     length       : INT16;     local_result : INT16;  
   repeating    : BOOLEAN; 
 
   terminator   : BOOLEAN; 
        BEGIN   { Procedure DoIdSequences }            id_table[LOCAL].length := 0;        id_table[REMOTE].length := 0;             local_result := GOOD;         default := TRUE;  
      repeating := FALSE;  
           PrintPrompt(repeating, ID_HEADER_MSG, local_result);        IF local_result <> GOOD THEN GOTO 999;            PrintPrompt(repeating, SHOW_LOCAL_MSG, local_result);         IF local_result <> GOOD THEN GOTO 999;            PrintPrompt(repeating, SHOW_REMOTE_MSG, local_result);        IF local_result <> GOOD THEN GOTO 999;             YesNoInput(CHG_ID_MSG, default, input_char, local_result);         IF local_result <> GOOD THEN GOTO 999;            IF NOT ((input_char = 'N') OR (default)) THEN            BEGIN   { Changing ID Sequences }              casefold := FALSE;              default := TRUE;              terminator := FALSE;  "            CharInput(CHG_LOCAL_MSG, casefold, default, terminator,  "                       input_string, local_result);              IF local_result <> GOOD THEN GOTO 999;                  IF Strlen( input_string) > ID_SIZE THEN                  SetStrlen( input_string, ID_SIZE );                   IF NOT (default OR (Strlen(input_string) = 0)) THEN    
               BEGIN 
 "                  id_table[LOCAL].length := Strlen( input_string );  " !                  StrMove(Strlen( input_string ), input_string, 1, !                                 id_table[LOCAL].id.char, 1 );   
               END;  
                 casefold := FALSE;              default := TRUE;              terminator := FALSE;  "            CharInput(CHG_REMOTE_MSG, casefold, default, terminator, "                       input_string, local_result);              IF local_result <> GOOD THEN GOTO 999;                  IF Strlen(input_string ) > ID_SIZE THEN                  SetStrlen( input_string, ID_SIZE );                   IF NOT (default OR (Strlen(input_string) = 0)) THEN                   BEGIN   { storing ID sequence }  "                  id_table[REMOTE].length := Strlen( input_string ); "                    StrMove(Strlen(input_string), input_string, 1,                                id_table[REMOTE].id.char, 1 );                  END;    { storing ID sequence }           END;    { Changing ID Sequences }      999:  error := local_result;     END; { Procedure DoIdSequences }       $ SUBTITLE 'Syn3k1', PAGE $   ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                             SYN3K1                                  }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ 	PROCEDURE Syn3K1;  	     ${---------------------------------------------------------------------}  $ %{ PURPOSE: determines whether there will be DS/1000-IV to DS/3000        } % ${   links in this system, and if so, the required size of the         }  $ ${   Transaction Status Table. This routine returns the amount of      }  $ ${   System Memory Block required for the TST as well as the number    }  $ %{   of class numbers and resource numbers required for DS/1000-IV        } % ${   DS/3000 connections.                                              }  $ ${                                                                     }  $ ${                           !!! NOTE !!!                              }  $ ${      All parameters are assumed to be set to zero upon entry.       }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   memory_block   OUTPUT   words of SMB required for TST             }  $ ${   dsamsize       OUTPUT   words of DSAM required (0)                }  $ ${   socketcnt      OUTPUT   number of IPC sockets required (0)        }  $ ${   classcnt       OUTPUT   number of RTE class numbers required (2)  }  $ ${   resourcecnt    OUTPUT   number of RTE resource numbers required(0)}  $ ${   result         OUTPUT   error indicator (0 = no error)            }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   'initglobals.ig_hp3000_enable' is set to TRUE if the user         }  $ ${   requests DS/1000 1000-3000 links/services. If not the variable    }  $ ${   is set to false. The variable 'TST_size, which is global to this  }  $ ${   module is set to the number of words required for the Transaction }  $ ${   Status Table. Also set the global "Initglobals.Ig_need_queue"     }  $ ${   to TRUE if user wants 3000 services.                              }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   Any errors returned by called subroutines are passed back to the  }  $ ${   caller unaltered. There are no internal errors generated. If      }  $ ${   an error exit is taken all other parameters remain unaltered.     }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $        BEGIN { procedure syn3k1 }             InitGlobals.IG_HP3000_Enable := FALSE;            IF ThreeKsInSystem(result) THEN                BEGIN              InitGlobals.IG_HP3000_Enable := TRUE;                   { tell main queue needs to be scheduled }               initglobals.IG_need_queue := TRUE;                  DoTST(TST_Size, TST_Entries, result);                   IF result = GOOD THEN                  BEGIN   { returning requirements }                     memory_block := TST_Size;                     classcnt := NUMBER_OF_CLASSES;                 END;    { returning requirements }            END;          END; { procedure Syn3K1 }      $ SUBTITLE 'PrintBanner', PAGE $  PROCEDURE PrintBanner   
( VAR result:     Int16 ); 
     LABEL      99;      CONST   
   NUMBBANNERS = 3;  
     TYPE     BannerType = Array[1..NUMBBANNERS] OF IStringType;       CONST      LINKBANNERS = BannerType[  
   IStringType['*'], 
    IStringType['*++   DS/1000-IV 1000-3000 Links   ++*'],      IStringType['*']];       VAR      index:      Int16;          BEGIN { PrintBanner }     FOR index := 1 TO NUMBBANNERS DO         BEGIN    { print one line }             PrintPrompt( FALSE, LINKBANNERS[index], result );         IF result <> GOOD THEN GOTO 99;         END;     { print one line }   99:      { hand any error back to the caller }         END;  { PrintBanner }          $ SUBTITLE 'Syn3k2', PAGE $   ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                              SYN3K2                                 }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ 	PROCEDURE Syn3K2;  	     ${---------------------------------------------------------------------}  $ %{ PURPOSE: Obtains and stores link related information for DS/1000-IV    } % ${   1000-3000 links.  This routine returns resource requirements to   }  $ ${   the caller.                                                       }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   memory_block   OUTPUT   words of SMB required (for 3K LU table)   }  $ ${   dsamsize       OUTPUT   words of DSAM required (0)                }  $ ${   socketcnt      OUTPUT   number of IPC sockets required (0)        }  $ ${   classcnt       OUTPUT   number of RTE class numbers required (0)  }  $ ${   resourcecnt    OUTPUT   number of RTE resource numbers required(0)}  $ ${   result         OUTPUT   error indicator (0 = no error)            }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   'Initglobals.IG_HP3000_Enable' is checked to determine if there   }  $ ${    are to be 3000 links in the system, it is not altered.           }  $ ${    Data strutures global to this module which are altered are:      }  $ ${      id_table            - set to Bisync Id sequences               }  $ ${      lu_table_size       - set to number of words for 3K LU table   }  $ ${      Linked LU list is created for Bisync LU numbers.               }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   If any called subroutine returns an error, it is returned to      }  $ ${   the caller.                                                       }  $ ${                                                                     }  $ ${ ALGORITHM:                                                          }  $ ${                                                                     }  $ ${   If the user wants connections to DS/3000 then                     }  $ ${     BEGIN                                                           }  $ ${                                                                     }  $ ${     find out how many X.25 POOL LUs they want                       }  $ ${                                                                     }  $ ${     get the LU numbers for all the Bisync LUs                       }  $ ${                                                                     }  $ ${     If they have some Bisync LUs then get the ID sequences          }  $ ${                                                                     }  $ ${     If they didn't want any Bisync or X.25 LUs warn them            }  $ ${     END                                                             }  $ ${                                                                     }  $ ${ NOTES:                                                              }  $ ${   All parameters are assumed to be set to zero upon entry.          }  $ ${                                                                     }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ LABEL      999;       VAR   
   number_3k_lus : Int16;  
    number_bisync_lus   : Int16;      number_x25_lus      : Int16;          BEGIN { procedure syn3k2 }             IF InitGlobals.IG_HP3000_Enable THEN           BEGIN   { gathering more 3k information }                  PrintBanner( result );              IF result <> GOOD THEN GOTO 999;                  DoX25(number_X25_lus,result);               IF result <> GOOD THEN GOTO 999;                  DoBisyncLUs(number_bisync_lus,result);              IF result <> GOOD THEN GOTO 999;      !            number_3k_lus := (number_X25_lus + number_bisync_lus); !                 lu_table_size := (number_3k_lus * LU_ENTRY_SIZE);                   IF  number_3k_lus > 0 THEN                 BEGIN   { checking for bisync ID sequences }                     IF number_bisync_lus > 0 THEN                     BEGIN { handling ID sequences }                        DoIdSequences(id_table,result);                       IF result = GOOD THEN                          BEGIN   { returning requirements }                             memory_block := lu_table_size;                           END;    { returning requirements }                    END;  { handling ID sequences }                  END     { checking for Bisync ID sequences }               ELSE { warn user that no LUs were specified }                  BEGIN   { warning user }   "                  MsgFilePrint( NO_3KLUSWARN, PMT_ERROR, 0, result); "                   { result is returned to user }                 END;    { warning user }                END;    { gathering more 3k information }  999:  	   END; { Syn3K2 } 	     $ SUBTITLE 'Init3k1', PAGE $  ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                             Init3K1                                 }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $    PROCEDURE Init3k1(VAR result:     Int16);      ${---------------------------------------------------------------------}  $ ${ PURPOSE: Allocates class numbers, starts programs, and sets up      }  $ %{   tables required for DS/1000-IV 1000-3000 links/services.             } % ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   result     OUTPUT     returns error indicator                     }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   The following variables, global to this module are accessed;      }  $ ${     head_lutable                                                    }  $ ${     end_lutable                                                     }  $ ${     lu_table_size                                                   }  $ ${     id_table                                                        }  $ ${   The global variable initglobals.ig_hp3000_enable is accessed.     }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   If an error is returned from any subroutine call, the error       }  $ ${   is returned to the caller and no further initialization is        }  $ ${   performed.                                                        }  $ ${                                                                     }  $ ${ NOTES:                                                              }  $ ${   The labeled common entry point D$EQT is used by DS/1000           }  $ ${   programs to determine if the system has HSI or PSI links to       }  $ ${   DS/3000.  OCT 3 for PSI is always stored in this location         }  $ ${   since there are no HSI links to an A-Series. At a later time      }  $ ${   this entry point may be converted to a single word, containing    }  $ ${   OCT 3 which is appended to programs loaded on an A-Series.        }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ LABEL      999;   VAR   
   Address : Int16;  
     
   BEGIN { Init3K1 } 
       Result := GOOD;  { assume the best for now }            IF initglobals.ig_hp3000_enable THEN           BEGIN { initialization }       "            DS_StoreResElement( NSINIT_AdrOf( D_Dollar_XS5 ), 0, 3); "     %            Schedule_Program(QUEX, NSINIT_AdrOf( Lb_QXCL ), TRUE, result); %             IF (result <> GOOD) THEN GOTO 999;      %            Schedule_Program(QUEZ, NSINIT_AdrOf( Lb_QZCL ), TRUE, result); %             IF (result <> GOOD) THEN GOTO 999;                  Schedule_Program(RQCNV, NSINIT_AdrOf( Lb_RQCV ),                                           FALSE, result);              IF (result <> GOOD) THEN GOTO 999;                  Schedule_Program(RPCNV, NSINIT_AdrOf( Lb_RPCV ),                                            FALSE, result);               IF (result <> GOOD) THEN GOTO 999;                  DS_getSMBAddr(TST_Size, Address, result);               IF (result <> GOOD) THEN GOTO 999;      "            DS_StoreResElement( NSINIT_AdrOf( Lb_TST ), 0, Address); "     $            DS_StoreResElement( NSINIT_AdrOf( Lb_TST ), 1, TST_Entries); $     #            { Move Bisync ID sequences into labeled common after the } # #            { 3000 LU table. There are no directly addressable       } # #            { entry points for the ID sequences so their location    } # #            { relative to the pointer to the 3000 LU table is used   } # #            { instead. This relative position MUST NOT be changed in } # #            { "RES" without altering the offsets used here !!!       } #                 MoveIntoRes(NSINIT_AdrOf( Lb_LU3K ), LID_OFFSET,                                id_table[LOCAL].length,                       ((id_table[LOCAL].length + 1) DIV 2) + 1);                  MoveIntoRes(NSINIT_AdrOf( Lb_LU3K ), RID_OFFSET,                                id_table[REMOTE].length,                       ((id_table[REMOTE].length + 1) DIV 2) + 1);        $            Build_3K_Lu_Table(Head_LuTable, End_LuTable, lu_table_size,  $                               result);               END; { initialization }  999:  
   END; { Init3K1 }  
     $ SUBTITLE 'Init3k2', PAGE $  ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                              Init3K2                                }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $    PROCEDURE Init3k2(VAR result:     Int16);      ${---------------------------------------------------------------------}  $ %{ PURPOSE: Initializes Bisync LUs for DS/1000-IV 1000-3000               } % ${   communication.                                                    }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   result     OUTPUT     returns error indicator                     }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${   See NOTES.                                                        }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   This routine access the linked list of Bisync LUs kept in EMA.    }  $ ${   Initglobals.ig_hp3000_enable is also accessed.                    }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   If an attempt to initialize an LU fails, the error is reported    }  $ ${   to the user but no error is returned to the caller.               }  $ ${                                                                     }  $ ${ NOTES:                                                              }  $ ${   This subroutine utilizes the DS/1000                              }  $ ${   PASCAL routine D$RLU which in turn calls the MACRO routine        }  $ ${   D$DN!. D$DN! will send any error messages to QCLM, which should   }  $ ${   be running before calling this subroutine or no errors will be    }  $ ${   reported.                                                         }  $ ${---------------------------------------------------------------------}  $         VAR      cntwd        : CntWdType;     error_string : IStringType;     local_error  : Int16;     dummy        : INT16;     stat1        : DvrStatType;     temptr       : LutablePtr;       
   BEGIN { Init3K2 } 
       Result := GOOD; { assume no error will occur }        IF initglobals.ig_hp3000_enable THEN           BEGIN { initialization }               temptr := head_lutable;                   WHILE (temptr <> NIL) AND (result = GOOD) DO                 BEGIN { While loop }                  Local_Error := Reset_Lu(Temptr^.Lu, GOOD);                  IF Local_Error <> GOOD THEN                    BEGIN   { handling card reset error }                     SetStrLen(Error_String, 0);   %                  StrWrite(Error_String, 1, dummy,'** (355) NS: Error: ',  %                        Local_Error:3,' initializing Bisync LU ',                          Temptr^.Lu, '.**');                     PrintError(Error_String, local_error);                    result := local_error;                    END;    { handling card reset error }                  temptr := temptr^.link;                 END;  { While loop }            END;  { initialization }   
   END; { Init3K2 }  
     $ SUBTITLE 'Shut3k1', PAGE $  ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                             SHUT3K1                                 }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $    PROCEDURE Shut3k1(VAR trustvar:   TrustType;                        VAR result:     Int16);          ${---------------------------------------------------------------------}  $ ${ PURPOSE:  Aborts programs and returns class numbers used for        }  $ ${   DS/1000 1000-3000 initialization.  The pointer to the 3000        }  $ ${   LU table is also set to zero. Other labeled common entry points   }  $ ${   are zeroed out by the DSINIT main (#3KLU, #TST, and #TST+1).      }  $ ${   Bisync ID sequence lengths are set to zero.                       }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   result     OUTPUT     error return (always 0)                     }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${   The following programs will be aborted if they are running:       }  $ ${     QUEX                                                            }  $ ${     QUEZ                                                            }  $ ${     RQCNV                                                           }  $ ${     RPCNV                                                           }  $ ${   If class numbers have been allocated for these programs they      }  $ ${   are deallocated and their storage locations in labeled common     }  $ ${   ("RES") are set to zero.                                          }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${   None accessed.                                                    }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${   No errors are ever returned by this subroutine.                   }  $ ${                                                                     }  $ ${ ALGORITHM:                                                          }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     VAR      Local_Error : INT16;       
   BEGIN { Shut3K1 } 
       result := GOOD;             DS_StopMonitor(QUEX, Local_Error);  "      DS_RetClass(NSINIT_AdrOf( Lb_QXCL ), NO_OFFSET, Local_Error);  "           DS_StopMonitor(QUEZ, Local_Error);  "      DS_RetClass(NSINIT_AdrOf( Lb_QZCL ), NO_OFFSET, Local_Error);  "           DS_StopMonitor(RPCNV, Local_Error);   "      DS_RetClass(NSINIT_AdrOf( Lb_RPCV ), NO_OFFSET, Local_Error);  "           DS_StopMonitor(RQCNV, Local_Error);   "      DS_RetClass(NSINIT_AdrOf( Lb_RQCV ), NO_OFFSET, Local_Error);  "           { zero out pointer to the 3000 LU table, #LU3K }        DS_StoreResElement(NSINIT_AdrOf( Lb_Lu3k ), 0, 0);            { zero out local ID length }  !      DS_StoreResElement(NSINIT_AdrOf( Lb_Lu3k ), LID_OFFSET, 0);  !           { zero out remote ID length }   !      DS_StoreResElement(NSINIT_AdrOf( Lb_Lu3k ), RID_OFFSET, 0);  !     
   END;  { Shut3k1 } 
     $ SUBTITLE 'Shut3k2', PAGE $  ${---------------------------------------------------------------------}  $ ${                                                                     }  $ ${                             SHUT3K2                                 }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $ 	PROCEDURE Shut3K2; 	     ${---------------------------------------------------------------------}  $ ${ PURPOSE:  Sends a disconnect control request to all Bisync LUs in   }  $ ${   the 3000 LU table.                                                }  $ ${                                                                     }  $ ${ PARAMETERS:                                                         }  $ ${   result     OUTPUT     error return (always zero for now)          }  $ ${                                                                     }  $ ${ SIDE EFFECTS:                                                       }  $ ${                                                                     }  $ ${ GLOBAL DATA STRUCTURES:                                             }  $ ${                                                                     }  $ ${ ERROR HANDLING:                                                     }  $ ${                                                                     }  $ ${ ALGORITHM:                                                          }  $ ${                                                                     }  $ ${---------------------------------------------------------------------}  $     VAR      a_register        : Int16;      b_register        : Int16;      buffer_size       : Int16;      continuation_flag : Int16;      done              : Boolean;      lu_counter        : Int16;      lu_number         : Int16;      X25_flag          : Int16;       
   BEGIN { Shut3K2 } 
 
      result     := GOOD;  
       lu_counter := 1;  
      done := FALSE; 
       WHILE NOT done DO            BEGIN   { WHILE loop }               Get_A_3000_Lu(lu_counter, lu_number, buffer_size,                             continuation_flag, X25_flag);               Get_Registers(a_register, b_register);              IF a_register <> 0 THEN                  BEGIN  { processing non-zero error return }                    done := TRUE;                  END    { processing non-zero error return }              ELSE                 BEGIN  { sending disconnect to the LU }                   Disconnect_Lu(lu_number, result);                   { ignore any errors }                   lu_counter := lu_counter + 1;                 END;   { sending disconnect to the LU }           END;   { WHILE loop }  
   END;  { Shut3k2 } 
     
END. { module ThreeKInit } 
