 $PASCAL ',7 91790-1X194 REV.4010 <860403.1759>'$  
$STANDARD_LEVEL 'HP1000'$  
 $debug$   $HEAPPARMS OFF$   $RECURSIVE OFF$   $RANGE OFF$   $HEAP 0$  	$HEAP_DISPOSE OFF$ 	     MODULE rrob;  $ALIAS 'N$RROB'       $TITLE 'MODULE Description',PAGE$   {}  {------------------------------------------------------------    (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   ------------------------------------------------------------}  {}  
{      NAME:   RROB  
 
{      SOURCE: 91790-18194 
 
{      RELOC : NONE  
 	{      PGMR  : DGA 	 {}  ${----------------------------------------------------------------------- $ { MODIFICATIONS   {   {    date  Prgmr  Description   {   #{  12/20/83  dga   changed to heap 0; improved error logger messages;  # !{                  fix: rrob now tests for routing links properly  ! {   {  07/18/85  RM    Added triggers.  {   {  08/30/85  RM    Used negative char len when logging ascii  "{  09/03/85  RM    log mbuf pointer as contextword where applicable  " {  09/26/85  RM    Call LogEvent first thing  {  12/16/85  RM    Modified context word in log_event calls   &{  01/03/86  RM    log an error in outstub only if it is not a kill request  & "{  03/03/86  RM    Send a kill indication if the lu in the NRV is 0. " {                  (N385 REV.2626)  ${----------------------------------------------------------------------- $ {}  
{ MODULE DESCRIPTION 
 {   {    This module contains the Rerouter outbound routines.   {   {}  $TITLE 'IMPORT Section',PAGE$       IMPORT         $SEARCH 'phtm/BODEC.REL'$     bodec,      $SEARCH 'phtm/SODEC.REL'$     sodec,      $SEARCH 'phtm/MMDEC.REL'$     mmdec,      $SEARCH 'phtm/MMEXT.REL'$     ds_mm,      $SEARCH 'phtm/TRCMOD.REL'$      trcmod,     $SEARCH 'phtm/LKLB.REL'$      lk,     $SEARCH 'phtm/RRDEC.REL'$     rrdec;       $TITLE 'Export Section',PAGE$       %{------------------------------------------------------------------------} % %{             Export Section                                             } % %{------------------------------------------------------------------------} %     EXPORT      PROCEDURE RROB     (    e_msg      : EventMsgType;      VAR rtnerr     : Int16        );      	PROCEDURE OUTSTUB  	    (    e_msg      : EventMsgType;      VAR rtnerr     : Int16        );          $TITLE 'Global Variables',PAGE$       &{--------------------------------------------------------------------------} & &{             Global Variables/Constants                                   } & &{--------------------------------------------------------------------------} &     IMPLEMENT       CONST   '   BAD_LINK_TYPE    = 1;             { Path error code                      }  ' '   BAD_PATH_REF     = 2;             { Path error code                      }  ' '   NO_ROUTES        = 3;             { Path error code                      }  ' '   ROUTER_TYPE_LINK = 0;             { Link type returned by Fetch_nrv      }  '     '   RROB_DUMPBUFFER  = 1;             { Location code for Log_Event          }  ' '   RROB_LINKDATAXMIT= 2;             { Location code for Log_Event          }  ' '   RROB_OUTSTUB     = 3;             { Location code for Log_Event          }  ' '   RROB_RROB        = 4;             { Location code for Log_Event          }  ' '   RROB_SENDKILLIND = 5;             { Location code for Log_Event          }  ' '   RROB_ENTRY       = 6;             { Location code for Log_Event          }  '         '                                     { testing                              }  ' VAR   '   data_len      : Int16;            { Input data length passed by ulp      }  ' '   dst_node_no   : Int16;            { Destination node no.                 }  ' '   err           : Int16;            { General error parameter.             }  ' '   log_pac       : AscType;          { String holder for event logger       }  ' '   mbuf_ptr      : Int16;            { Input ptr to message in DSAM from ulp}  ' '   nrv_index     : Int16;            { Index to entry( path ref ) in nrv.   }  ' '   nrv_link_lu   : Int16;            { Lu returned by nrv.                  }  ' '   path_err      : Int16;            { Error var for NRV related errors.    }  ' '   pathref       : contextwords;     { For event logging                    }  ' '   ps_err        : Int16;            { Error returned to ProSw.             }  ' '   router_header : RouterHeaderType; { Buffer that holds the router hdr.    }  ' '   rr_msg        : AscType;          { Event message to be sent to ulp.     }  ' '   rr_wkmap      : Int16;            { Working map for memory mgr calls     }  ' '   send_err      : Int16;            { LISend error return.                 }  ' '   temp3         : Temp3Type;        { A general var used to convert types  }  '             $TITLE 'Forward Declarations',PAGE$       '{---------------------------------------------------------------------------}  ' '{             Forward Declarations                                          }  ' '{---------------------------------------------------------------------------}  '     PROCEDURE BuildRouterHeader;       FORWARD;       PROCEDURE DumpBuffer;        FORWARD;       PROCEDURE LinkDataXmit     (      in_err : Int16 );        FORWARD;       PROCEDURE NRVFindPathOB   
   ( VAR  err  : Int16 );  
      FORWARD;       PROCEDURE FetchNRVIndex            $ALIAS 'Fetch_NRV_Index'$     (      nrv_index    : Int16;        VAR  nrv_entry    : NrvEntryType );       EXTERNAL;      PROCEDURE ProSw      ( VAR  e_msg     : EventMsgType;        VAR  error     : Int16 );       EXTERNAL;          PROCEDURE SendKillIndOB      (     kill_refr   : Int16;            kill_err    : Int16 );        FORWARD;           
$TITLE 'Procedures',PAGE$  
     &{--------------------------------------------------------------------------} & &{             Procedures                                                   } & &{--------------------------------------------------------------------------} &         $TITLE 'BuildRouterHeader',PAGE$      &{--------------------------------------------------------------------------} & &{             BuildRouterHeader                                           }  & &{--------------------------------------------------------------------------} &     PROCEDURE BuildRouterHeader;      {}  { Description   !{    This routine initializes a DS/1000 IV router header and local ! !{    appendage. This header is later passed to LISend which passes ! "{    it to the driver along with the dsam message in sam. It should  "  {    be noted that the local appendage is included in the header   {    and is initialized here.   {   { Globals   "{    DSAM globals accessed:  DS_Local_node, DS_Msg_Level, DS_Max_Hop " {    RROB globals         :  router_header  {                            rr_wkmap   {                            dst_node_no  {                            nrv_link_lu  {}  CONST      { This constant is used to set the "not from driver bit" }      { of the local appendage so that if outpro sends messages }     { to inpro via GRPM, GRPM will treat the message as if it }     { were a read completion and pass it to inpro properly}     APNDGE_WORD2_INIT = hex ('0100');         APNDGE_BUF_INIT   = ApndgeBufType        [  so_id         :  0,           seq           :  0,           ni_type       :  ROUTER_LINE,           link_lu       :  APNDGE_WORD2_INIT ];         QUAL_WORD_INIT    = QualWordType         [  int           :  0 ];         REP_NODE_NO_INIT  = RepNodeNoType        [  rn_sign_bit   :  0,           rn_node_no    :  0 ];         STREAM_WORD_INIT  = StreamWordType         [  sw_3000_mast  :  0,           sw_rply_flag  :  0,           sw_rb         :  0,           sw_fl         :  1,           sw_rmbs_cnt   :  0,           sw_lrtry_cnt  :  0,           sw_stream_no  :  13 ];          ROUTER_HEADER_INIT = RouterHeaderType        [  rh_stream_wd      :  STREAM_WORD_INIT,            rh_trans_seq_no   :  0,           rh_src_node_no    :  0,           rh_dst_node_no    :  0,           rh_ecode1         :  0,           rh_ecode2         :  0,           rh_rep_node_no    :  REP_NODE_NO_INIT,            rh_qual_wd        :  QUAL_WORD_INIT,            rh_ma_send_seq_no : -3,           rh_ma_recv_seq_no :  0,           rh_ma_cancel_flgs :  0,           rh_loop_cnt       :  0,           rh_session_id     :  0,           rh_local_ap       :  APNDGE_BUF_INIT];       VAR      temp_var : Int16;  { temporary variable }      BEGIN  { BuildRouterHeader }      { Initialize the router header }  router_header := ROUTER_HEADER_INIT;      { Fill in node specific info }  WITH  router_header  DO          BEGIN  { hdr init }     { Get the local node number          }      DS_FetchGlobal(DS_Local_node,1,rh_src_node_no);         { Get the message level word         }      DS_FetchGlobal(DS_Msg_Level,1,temp_var);      rh_qual_wd.int := temp_var;         { Get the maximum hop count          }      DS_FetchGlobal(DS_Max_Hop,1,rh_loop_cnt);         { Initialize the destination node number }      rh_dst_node_no := dst_node_no;          { Initialize the local appendage lu. Note that the LU is }      { added so as not to overwrite the "not from driver bit" }      rh_local_ap.link_lu := rh_local_ap.link_lu + nrv_link_lu;             END;   { hdr init }      END;  { BuildRouterHeader }           
$TITLE 'DumpBuffer',PAGE$  
     %{-----------------------------------------------------------------------}  % %{             DumpBuffer                                                }  % %{-----------------------------------------------------------------------}  %     PROCEDURE DumpBuffer;       {}  { Description   {    This routine disposes of dsam message buffers.   {   { Globals accessed  :   rr_wkmap  {                       mbuf_ptr  {                       log_pac   {}  VAR      ds_err   : Int16;   { holder for dsam error }      BEGIN  { DumpBuffer }   DS_MDispose(mbuf_ptr,ds_err);   
IF  ds_err <> NO_ERR  THEN 
    BEGIN     temp3.chars    := 'RROB : DS_MDispose error ';      log_pac.emsg   := temp3.emsg;     pathref.longint := ds_err ;  $   Log_Event(EL_ERROR,RR_PID,RROB_DUMPBUFFER,pathref,-MAX_LOG_LEN_BYTES, $             log_pac.bufr,err);     END;   
END;  { DumpBuffer } 
         $TITLE 'LinkDataXmit',PAGE$       %{------------------------------------------------------------------------} % %{             LinkDataXmit                                               } % %{------------------------------------------------------------------------} %     PROCEDURE  LinkDataXmit      {     in_err  : Int16; };      {}  { Description   {   This routine builds the router header and sends the data  {   on the link. If any error conditions occur that involve   {   involve paths (ie nrv errors ), a kill_indication is sent   {   to the ulp and the message is tossed.   {   { Parameters  ${   in_err  <input>  This  is the error code returned from NRVFindPathOB $ {   { Global variables  :   nrv_index   {                       mbuf_ptr  {                       data_len  {                       router_header   {                       send_err  {                       log_pac   {   {}  TYPE     TempBufType = RECORD   
      CASE Int16 OF  
          1 :  ( ap_buf  : AppendageBuffer );           2 :  ( rh_buf  : RouterHeaderType);        END;      VAR   #   err       :  Int16;        { general error parm.                  } # #   dummy     :  Int16;        { used in triggers                     } # #   temp_buf  :  TempBufType;  { temporary buffer for type conversion } #     BEGIN  { LinkDataXmit }       CASE  in_err  OF      	   BAD_LINK_TYPE:  	       BEGIN  { wrong type }         SendKIllIndOB(nrv_index,RR_LINK_TYPE_INVALID);        END;   { wrong type }          NO_ROUTES:         BEGIN  { lu is 0    }         SendKIllIndOB(nrv_index,RR_ALL_ROUTES_DOWN);        END;   { lu is 0    }          NO_ERR:        BEGIN  { no err }         { Initialize the router header                 }        BuildRouterHeader;        { Send the data on the link.  LISend requeues    }        { the data to the lu specified in the appendage  }        { and uses GRPM's class no. for write comletions }        temp_buf.rh_buf.wd_array := router_header.wd_array;   "      LISend(mbuf_ptr,data_len,temp_buf.ap_buf,RH_LEN_WDS,send_err); "               { If send is not successful, send a kill }        { to the ulp.                            }        IF  send_err = NO_ERR  THEN            BEGIN  { send ok }   
         DumpBuffer; 
          DS_LeaveCritical(rr_wkmap);           END    { send ok }         ELSE           BEGIN  { bad send }           { Note: SendKillIndOB also dumps the buffer }           SendKillIndOB(nrv_index,send_err);            END;   { bad send }        END;  { no err }         OTHERWISE        BEGIN   { otherwise }         { unknown error was passed in from NRVFindPathOB }        temp3.chars  := 'RROB : NRV error ';        log_pac.emsg := temp3.emsg;         pathref.longint := NRV_index ;  '      Log_Event(EL_ERROR,RR_PID,RROB_LINKDATAXMIT,pathref,-MAX_LOG_LEN_BYTES,  '                log_pac.bufr,err);         DS_LeaveCritical(rr_wkmap);   
      END;   { otherwise } 
     END;  { path_err case }       END;  { LinkDataXmit }          $TITLE 'NRVFindPathOB',PAGE$      &{-------------------------------------------------------------------------}  & &{             NRVFindPathOB                                               }  & &{-------------------------------------------------------------------------}  &     PROCEDURE NRVFindPathOB      { VAR  err : Int16};       {}  { Description   "{    This routine gets the NRV table entry that contains the link lu " !{    on which to send the message. It encapsulates the NRV access  ! !{    routine as well. Furthermore, the errors returned are mapped  ! "{    into path related error conditions that are passed to the ulp.  " {   { Parameters  {    err  <output>  Returns  NO_ERR         no error  %{                            BAD_LINK_TYPE  link was not a rerouting link  % {   { Global variables   :  rr_wkmap  {                       nrv_index   {                       dst_node_no   {                       nrv_link_lu   {}  LABEL      99;      VAR   %   nrv_entry  :  NRVEntryType;  { buffer used to receive nrv table entry } %    local_node :  Int16 ;        { local router address }      BEGIN  { NRVFindPathOB }      { Must be critical for this call }  FetchNRVIndex(nrv_index,nrv_entry);   dst_node_no := nrv_entry.nv_node_number;  nrv_link_lu := nrv_entry.nv_link_lu;      { get local router address }  DS_FetchGlobal(DS_LOCAL_NODE,1,local_node);       "{ if it is not destined for local node then do some more checking }  " IF local_node <> dst_node_no THEN         BEGIN { more checking }         { See if the link is a rerouting link }         IF  nrv_entry.nv_router  THEN            BEGIN  { bad type }           err := BAD_LINK_TYPE;           END    { bad type }        ELSE IF nrv_link_lu = 0 THEN           BEGIN  { no route }  
         err := NO_ROUTES; 
          END;   { no route }        END;  { more checking }       99:   END;  { NRVFindPathOB }           $TITLE 'OutStub',PAGE$      '{---------------------------------------------------------------------------}  ' '{             OutStub                                                       }  ' '{---------------------------------------------------------------------------}  '     	PROCEDURE OutStub  	    {     e_msg    : EventMsgType;            rtnerr   : Int16          };       {}  { Description   !{    This procedure should never be called. It is simply an entry  ! {    point in INPROSW that might accidentally be entered.   {}  VAR   	   err   : Int16;  	     	BEGIN  { OutStub } 	     IF e_msg.em_event <> KILL_REQUEST THEN        BEGIN { invalid message }         DS_EnterCritical(rr_wkmap,err);         temp3.chars  := 'RROB : OutStub detected bad emsg';         log_pac.emsg := temp3.emsg;         pathref.longint := 0;   $      Log_Event(EL_ERROR,RR_PID,RROB_OUTSTUB,pathref,-MAX_LOG_LEN_BYTES, $               log_pac.bufr,err);        DS_LeaveCritical(rr_wkmap);         END; {invalid message }       	END;   { OutStub } 	             
$TITLE 'RROB', PAGE$ 
     '{---------------------------------------------------------------------------}  ' '{             RROB                                                          }  ' '{---------------------------------------------------------------------------}  '     PROCEDURE RROB     {    e_msg      : EventMsgType;      VAR rrob_err   : Int16};          {}  { Description   #{    This procedure is the outbound link interface for Router (DS/1000 # !{    routing ) links. The following event messages are supported:  ! {    {    input  SEND_REQUEST                 output  KILL_INDICATION   {           KILL_REQUEST   <ignored>  {   #{    Basically, for send requests, messages from the ulp are appended  # %{    with the old DS/1000 style header and sent out the link lu specified  % &{    in the NRV routing table. The old DS/1000 software is responsible for:  & {        1   updating the NRV routing table   (GRPM)  {        2   sending routing updates          (#SEND)   {        3   handling class completions       (GRPM)  {   { Parameters  {    e_msg    <input>      event message type sent by ProSw   {   {    rrob_err <output>     error code returned to ProSw   {   { Global variables   :  mbuf_ptr  {                       data_len  {                       nrv_index   {                       path_err  {                       log_pac   {   {}  LABEL      99;      VAR   &   err        : Int16;             { general error parameter              }  &     BEGIN  { RROB }   DS_EnterCritical(rr_wkmap,err);   IF err <> NO_ERR  THEN     BEGIN     GOTO 99;      END;       pathref.longint := 0 ;  Log_Event(EL_EVENT,RR_PID,RROB_ENTRY,pathref,                  EMSG_WORD_LEN,e_msg.int,err);          WITH e_msg DO      BEGIN { with e_msg }           
   CASE em_event OF  
     
      SEND_REQUEST:  
          BEGIN  { send request }           { Initialize global variables                  }            mbuf_ptr        := emsr_mbufid;           data_len        := emsr_dlen;           nrv_index       := emsr_down_ref;           pathref.longint := nrv_index ;     { for Log_Event  }                   { Look up the path info in the NRV using the    }           { down_ref as an index.                         }           NRVFindPathOB(path_err);                { Send the data with the header.        }           LinkDataXmit(path_err);           END;  { send request }       
      KILL_REQUEST:  
          BEGIN { kill }   
         { Ignore }  
          DS_LeaveCritical(rr_wkmap);           END;  { kill }             OTHERWISE   
         BEGIN { unknown } 
          temp3.chars  := 'RROB : invalid emsg   ';           log_pac.emsg := temp3.emsg;           pathref.longint := em_event ;  $         Log_Event(EL_ERROR,RR_PID,RROB_RROB,pathref,-MAX_LOG_LEN_BYTES, $                   log_pac.bufr,err);           DS_LeaveCritical(rr_wkmap);  
         END;  { unknown } 
       END;  { end evnt_msg case }      END;  { with e_msg }       99: ;   END;  { RROB }          $TITLE 'SendKillIndOB',PAGE$      &{--------------------------------------------------------------------------} & &{             SendKillIndOB                                                } & &{--------------------------------------------------------------------------} &     PROCEDURE SendKillIndOB      {    kill_refr:       Int16;           kill_err :       Int16};  {}  { Description   {    This routine does the following :  {   {        - formats and sends a kill_indication to the ulp   {        - logs the kill_indication   {        - discards the dsam buffer   {   { Global variables   :  rr_msg  {                       ps_err  {}      BEGIN { SendKillIndOB }   rr_msg.emsg.em_event      := KILL_INDICATION;   rr_msg.emsg.ehport        := IPIB_INDEX;  rr_msg.emsg.emki_down_ref := kill_refr;   rr_msg.emsg.emki_down_pid := RR_PID;  rr_msg.emsg.emki_reason   := kill_err;      { Invoke the error logger }   pathref.longint := kill_refr ;  !Log_Event(EL_WARNING,RR_PID,RROB_SENDKILLIND,pathref,KILL_IND_LEN, ! 
         rr_msg.bufr,err); 
     { Discard the DSAM buffer }   DumpBuffer;       DS_LeaveCritical(rr_wkmap);   ProSw (rr_msg.emsg,ps_err);   END;  { SendKillIndOB }       END.  { RROB Module }      