 !{----------------------------------------------------------------} ! !{   PRBLB.PAS                                                    } ! !{                                                                } ! !{   Programmer: CWW                             <860325.1444>    } ! !{----------------------------------------------------------------} !     $PASCAL ',20 91790-1X177 REV.4010 <850308.1111>'$   $TITLE 'Probe Library'$   $DEBUG  $WIDTH 90   $HEAPPARMS OFF  
$RECURSIVE OFF, RANGE OFF  
 $HEAP 0   	$HEAP_DISPOSE OFF  	 $STANDARD_LEVEL 'HP1000'      MODULE PRBLB;       !{----------------------------------------------------------------  ! (C) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.   !----------------------------------------------------------------}  !     {}  !{----------------------------------------------------------------} ! {   	{    NAME : PRBLB  	 {  SOURCE : 91790-18177   {   RELOC : NONE  {    PGMR : CWW   {   OWNER : CLC   !{                                                                } ! !{----------------------------------------------------------------} ! {  Modification History (since Release I):  {  03/19/86  clc  Send proxy request on multicast address   {                 SR# 034827, N379   {  03/25/86  clc  Ignore Kill_Indication emsgs on ProbeInbound,    !{                 instead of reporting a bad emsg SR# 035360, N389 ! {}          !{----------------------------------------------------------------} ! !{                                                                } ! !{   IMPORT LIST                                                  } ! !{                                                                } ! !{----------------------------------------------------------------} !     IMPORT     $SEARCH 'phtm/BODEC.REL'$         bodec,      $SEARCH 'phtm/SODEC.REL'$         sodec,      $SEARCH 'phtm/MMDEC.REL'$         mmdec,      $SEARCH 'phtm/MMEXT.REL'$         ds_mm,      $SEARCH 'phtm/TRCMOD.REL'$        trcmod,     $SEARCH 'phtm/SIGMOD.REL'$        sigmod,     $SEARCH 'phtm/LKLB.REL'$          lk,     $SEARCH 'phtm/TMRDEC.REL'$        tmrdec,     $SEARCH 'phtm/TCPGB.REL'$         tg,     $SEARCH 'phtm/TUSER.REL'$         tuser,      $SEARCH 'phtm/IPDEC.REL,phtm/IPLIB.REL,phtm/IPDB.REL'$                                   iplib,     $SEARCH 'phtm/IPPATH.REL,phtm/IPPCTL.REL,phtm/IPACTP.REL'$                                   ippath,      $SEARCH 'phtm/TCPLB.REL'$         tl,     $SEARCH 'phtm/PXPLB.REL'$         px,     $SEARCH 'phtm/LAN8.REL'$          lan8,     $SEARCH 'phtm/SREGLIB.REL'$       sreglib,      $SEARCH 'phtm/PRBDEC.REL'$        prbdec,     $SEARCH 'phtm/RRDEC.REL'$         rrdec,      $SEARCH 'phtm/SROUTER.REL'$       srouter;       !{----------------------------------------------------------------} ! !{                                                                } ! !{   EXPORT DECLARATIONS                                          } ! !{                                                                } ! !{----------------------------------------------------------------} !     EXPORT      
   PROCEDURE ProbeInbound  
       ( VAR emsg     : EventMsgType;          VAR ierr     : Int16 );       
   PROCEDURE ProbeOutbound 
       ( VAR emsg     : EventMsgType;          VAR ierr     : Int16 );       $PAGE   !{----------------------------------------------------------------} ! !{                                                                } ! !{   IMPLEMENT DECLARATIONS                                       } ! !{                                                                } ! !{----------------------------------------------------------------} !     IMPLEMENT       !{----------------------------------------------------------------} ! !{   TYPE DECLARATIONS                                            } ! !{----------------------------------------------------------------} !     CONST   "   MAX_VA_ATTEMPTS         =  3;  {Maximum number of Virtual Address "                                    Request retries}   "   MAX_NAME_ATTEMPTS       =  6;  {Maximum number of Name/Proxy-Name "                                    Request retries}      PROBE_FIRST_SEND        = 255; {special value}       !   {-------------------------------------------------------------} ! !   {   LOCATION CONSTANTS FOR EVENT LOGGING                      } ! !   {-------------------------------------------------------------} !        { The following are location codes that should be passed to     { the Log_Event routine when logging Probe events.      {}      LOC_100_CANT_SBPUT                   =  100;      LOC_200_NO_PATHRECS                  =  200;      LOC_300_READING_NAME                 =  300;      LOC_301_LAN_MAPPING                  =  301;      LOC_302_CHARGING_GW_REPLY            =  302;      LOC_400_READING_NAME                 =  400;      LOC_401_BAD_NLEN                     =  401;      LOC_402_BAD_NAME                     =  402;      LOC_403_READING_NODALREPORT          =  403;      LOC_404_PREPARING_NAME_REPLY         =  404;      LOC_600_READING_UNSOLICITED          =  600;      LOC_601_BAD_NLEN                     =  601;      LOC_602_ADJUSTING_NRENTRY            =  602;      LOC_603_ADDING_REPORT                =  603;      LOC_604_OVERWRITING                  =  604;      LOC_800_BAD_VAREQ_LEN                =  800;      LOC_801_READING_VAREQ                =  801;      LOC_802_PUTTING_VAREPLY              =  802;      LOC_901_CANT_SET_UP_NAMEREC          =  901;      LOC_902_NAME_TIMER_START             =  902;      LOC_1000_RETRYING_NAMEREQ            = 1000;      LOC_1001_RESETTING_NAME_TIMER        = 1001;      LOC_1100_CANT_FIND_ME                = 1002;      LOC_1101_CANT_READ_OWN_REPORT        = 1101;      LOC_1102_CHARGING_UNSOLICITED        = 1102;      LOC_1103_SETTING_UNSOL_TIMER         = 1103;      LOC_1200_CHARGING_VA_REQ             = 1200;      LOC_1201_SETTING_FIRST_VA_TIMER      = 1201;      LOC_1202_VAREQ_BAD_PID               = 1202;      LOC_1300_CHARGING_VA_RETRY           = 1300;      LOC_1301_RESET_VA_TIMER              = 1301;      LOC_2500_BAD_INBOUND_EMSG            = 2500;      LOC_2501_BAD_MSG_LEN                 = 2501;      LOC_2502_MBUF_TOO_LEAN               = 2502;      LOC_2503_BAD_IBMSG                   = 2503;      LOC_2504_INBOUND                     = 2504;      LOC_2600_OUTBOUND                    = 2600;      LOC_2601_BAD_TIMER_SIGNAL            = 2601;      LOC_2602_UNKNOWN_EVENT               = 2602;              {---------------------------------------------------------}     {   PROBE MSG RECORD                                      }     {---------------------------------------------------------}      CONST       PROBE_PREAMBLE_LEN      = 6; {byte length of Probe message's                                      preamble part}      PROBE_VAREQ_LEN         =16; {VA request message byte length}           TYPE  
   ProbeMsgRecord = RECORD 
       CASE INTEGER OF         1: ( int       : Int16 );         2: ( ints      : PathWordArray  );        3: ( bytes     : PathByteArray  );            4: (  pmr_b       : PACKED RECORD                              version : Byte;                             msgtype : Byte;                             END; {pmr_b}               pmr_msglen  : Int16;              pmr_seqnum  : Int16;                  { Here we declare the variant parts of the header.              {}              CASE INTEGER OF       	               0:  	                   ( pmr_varpart    : Int16 );                      PB_VNA_REQUEST,                 PB_GATEWAY_REQUEST:                    ( pmr_reportlen     : Int16;                      pmr_domainlen     : Int16;                      pmr_vna           : VNARecord;                      pmr_src_reportlen : Int16;                      pmr_src_domainlen : Int16;                      pmr_src_vna       : VNARecord );                     PB_NAME_REQUEST,                  PB_PROXY_NAME_REQUEST:                     ( pmr_nameb      : PACKED RECORD                                         ntype : Byte;                                         len   : Byte;                                         END; {pmr_nameb}                       pmr_name       : EnvironStringType );                          PB_GATEWAY_REPLY:                    ( pmr_gwrep_rlen    : Int16;                      pmr_gwrep_dlen    : INt16;                      pmr_gwrep_vna     : VNARecord;                      pmr_gwrep_pathlen : Int16;                      pmr_gwrep_lanelem : LANProtoElementRecord;                      pmr_gwrep_hopcnt  : Int16 );                     PB_NAME_REPLY,                  PB_PROXY_NAME_REPLY:                     ( pmr_pathreport     : PathReportRecord )                  )  {Case ... 2:}            END; {ProbeMsgRecord}      !   {-------------------------------------------------------------} ! !   {   GLOBAL SCRATCH VARIABLES                                  } ! !   {-------------------------------------------------------------} !     VAR       context           : ContextWords;   {type exported by trcmod}      logerr            : Int16;      noderec           : NodeRecord;     pcbrec            : PCBRecord;      probegrec         : ProbeGRecord;     rqsttime          : INTEGER;      scratchemsg       : EventMsgType;     scratchemsg2      : EventMsgType;     scratchmsg        : ProbeMsgRecord;     scratchvect       : VectoredDataType;     socket            : SocketRecord;     timerid           : TimerIdType;      timermsg          : TimerMsgType;      !{----------------------------------------------------------------} ! !{   FORWARD AND EXTERNAL DECLARATIONS                            } ! !{----------------------------------------------------------------} !     PROCEDURE AdrOf   
   ( VAR object   : Int16; 
 
         offset   : Int16; 
      VAR byteaddr : Int16 ); EXTERNAL;      PROCEDURE PrbChargeMsg     (     acctgsd     : Int16;        VAR msg         : ProbeMsgRecord;       VAR mbufid      : Int16;        VAR ierr        : Int16 ); FORWARD;      PROCEDURE PrbIbGatewayRequest      ( VAR emsg        : EventMsgType;       VAR reqmsg      : ProbeMsgRecord;       VAR wkmp        : Int16;        VAR ierr        : Int16 ); FORWARD;      PROCEDURE PrbIbNmReply     (     seqnum      : Int16;        VAR emsg        : EventMsgType;       VAR wkmp        : Int16 ); FORWARD;      PROCEDURE PrbIbNmRequest     ( VAR emsg        : EventMsgType;       VAR reqmsg      : ProbeMsgRecord;       VAR wkmp        : Int16;        VAR ierr        : Int16 ); FORWARD;      
PROCEDURE PrbIbUnsolicited 
    ( VAR emsg        : EventMsgType;       VAR scratchmsg  : ProbeMsgRecord;       VAR wkmp        : Int16;        VAR ierr        : Int16 ); FORWARD;      PROCEDURE PrbIbVARequest     ( VAR reqemsg  : EventMsgType;        VAR reqmsg   : ProbeMsgRecord;   
     VAR wkmp     : Int16; 
      VAR ierr     : Int16 ); FORWARD;       
PROCEDURE PrbObNameRequest 
    ( VAR emsg     : EventMsgType;   
     VAR wkmp     : Int16; 
      VAR ierr     : Int16  ); FORWARD;      
PROCEDURE PrbObNameTimeOut 
 
   (     seqnum   : Int16; 
 
     VAR wkmp     : Int16; 
      VAR ierr     : Int16 ); FORWARD;       
PROCEDURE PrbObUnsolicited 
 
   ( VAR wkmp     : Int16; 
      VAR ierr     : Int16 ); FORWARD;       PROCEDURE PrbObVATimeOut     ( VAR wkmp        : Int16;        VAR ierr        : Int16 ); FORWARD;      PROCEDURE PrbPrepAbortDPath      ( VAR pcb      : PCBRecord;       VAR emsg     : EventMsgType;            error    : Int16 ); FORWARD;       PROCEDURE PrbPrepConfirmDpath      ( VAR pcbrec      : PCBRecord;        VAR cdpathemsg  : EventMsgType ); FORWARD;       PROCEDURE PrbPrepKillRequest  
   (     dnpid    : Int16; 
 
         dnref    : Int16; 
 
         dncnt    : Int16; 
 
         upcnt    : Int16; 
      VAR emsg     : EventMsgType ); FORWARD;      PROCEDURE PrbPrepQueryConfirm      ( VAR namepcb        : PCBRecord;           pathrepmbufid  : Int16;           pathreplen     : Int16;           errorcode      : Int16;       VAR eventmsg       : EventMsgType ); FORWARD;      PROCEDURE PrbPrepSendRequest  
   (     acctgsd  : Int16; 
 
         dnpid    : Int16; 
 
         dnref    : Int16; 
      VAR msg      : ProbeMsgRecord;        VAR sendemsg : EventMsgType;        VAR ierr     : Int16 ); FORWARD;       PROCEDURE PrbReleasePCB   
   ( VAR pcbrecid : Int16; 
      VAR pcb      : PCBRecord;       VAR grec     : ProbeGRecord ); FORWARD;      
PROCEDURE PrbSearchPCBList 
 
   (     hdptr    : Int16; 
 
         key      : Int16; 
 
         offset   : Int16; 
 
     VAR pcbrecid : Int16; 
      VAR pcbrec   : PCBRecord;       VAR ierr     : Int16 ); FORWARD;       
PROCEDURE PrbSetUpNameMsg  
    ( VAR reqpcb   : PCBRecord;       VAR sendemsg : EventMsgType;        VAR ierr     : Int16 ); FORWARD;       PROCEDURE PrbSetUpVAMsg   
   (     acctgsd  : Int16; 
      VAR pcbrec   : PCBRecord;       VAR emsg     : EventMsgType;        VAR ierr     : Int16 ); FORWARD;       
PROCEDURE PrbStartVATimer  
    ( VAR globalrec   : ProbeGRecord;       VAR ierr        : Int16 ); FORWARD;      PROCEDURE PrbObVARequest     ( VAR emsg     : EventMsgType;   
     VAR wkmp     : Int16; 
      VAR ierr     : Int16 ); FORWARD;       PROCEDURE PrbUnlinkPCB     ( VAR headptr     : Int16;            pcbrecid    : Int16;        VAR pcbrec      : PCBRecord ); FORWARD;      PROCEDURE ProSw      ( VAR emsg     : EventMsgType;        VAR ierr     : Int16 ); EXTERNAL;          $PAGE   !{----------------------------------------------------------------} ! !{   PRB CHARGE MSG                                         (100) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbChargeMsg     {     acctgsd     : Int16;        VAR msg         : ProbeMsgRecord;       VAR mbufid      : Int16;        VAR ierr        : Int16 };       {}  { Abstract:   {  After a Probe message has been prepared for transmission   {  this routine may be used to put the message into DSAM.   {   
{ Input parameters:  
 {    {  acctgsd: The global socket descriptor for the socket against    {     whose outbound sbuf the buffer space for the message  {     should be charged.  {    {  msg: The message itself. Note that the length of the message    {     is determined from its pmr_msglen field.  {   
{ Output parameters: 
 {   !{  mbufid: The identifier of the mbuf that the message was placed  ! {     into (valid only if ierr returns SUCCESSFUL).   {   {  ierr: The return value from the DS_SBPut() call used to put  {     the message into the mbuf.  {}      VAR      mc        : Int16;      mmflags   : MMFlagsType;       BEGIN   { First we prepare a data vector that describes the message.  {}  AdrOf (msg.int, 0, scratchvect[1]);   scratchvect[2] := msg.pmr_msglen;   mc := scratchvect[2];        { The options we set when putting the message into DSAM specify    !{ that we want to allocate an macct, that we don't want to tap the !  { general pool, and that we don't want to preserve any reserved    { mbufs.  {}  	mmflags.int := 0;  	 
mmflags.bits[-2] := TRUE;  
 #DS_SBPut (scratchvect, 4, acctgsd+acctgsd, mmflags, mbufid, mc, ierr); # IF (ierr <> SUCCESSFUL) THEN     BEGIN     context.longint := 0;  '   Log_Event (EL_ERROR, PROBE, LOC_100_CANT_SBPUT, context, 2, ierr, logerr);  ' 	   END; {IF ierr}  	 
END; {PrbChargeMsg}  
     $PAGE   !{----------------------------------------------------------------} ! !{   PRB GET PCB                                            (200) } ! !{----------------------------------------------------------------} !     
PROCEDURE PrbGetPCB  
    ( VAR probegrec   : ProbeGRecord;       VAR pcbrecid    : Int16;        VAR pcbrec      : PCBRecord;        VAR ierr        : Int16 );       {}  { Abstract:    {  PrbGetPCB attempts to allocate a Probe Control Block record.     {  Free records are linked onto the pg_freeq of Probe's globals    {  record. If a new record is allocated then it is assigned a   {  new, unique sequence number -- this number is placed in the  {  record's pcb_seqnum field.   {   
{ Input Parameters:  
 {   {  probegrec: The Probe globals record.   {   
{ Output Parameters: 
 {   {  pcbrecid: If ierr returns SUCCESSFUL then pcbrecid contains  {     a descriptor for a newly allocated PCBRecord.   {   {  pcbrec: If ierr returns SUCCESSFUL, then pcbrec contains a   {     newly allocated PCBRecord.  {   !{  ierr: Returns SUCCESSFUL if a new PCBRecord was initialized and ! {     an error value otherwise.   {}      BEGIN   
WITH probegrec, pcbrec DO  
    BEGIN     IF (pg_freeq <> NULL) THEN         BEGIN         { We have a free PCBRecord available. We unlink it from         { the globals record's free queue and assign it a unique        { sequence number.        {}        pcbrecid := pg_freeq;         DS_FetchElement (DS_ProbePCBTD, pcbrecid, pcbrec.int);        pg_freeq := pcb_nxtptr;         pcb_seqnum := pg_nxtseq;        pg_nxtseq := pg_nxtseq + 1;   
      ierr := SUCCESSFUL;  
       END      ELSE         BEGIN         { Note: We might want to return a more definitive error         { than the one below. We might want to return an error        { indicating that there were no PROBE path records.         {}        ierr := U_NO_PATH_RECORDS;        context.longint := 0;         Log_Event (EL_RESOURCELIM, PROBE, LOC_200_NO_PATHRECS,                   context, 2, ierr, logerr);         END; {IF pg_freeq}     END; {WITH}  END; {PrbGetPcb}      $PAGE   !{----------------------------------------------------------------} ! !{   PRB IB GATEWAY REQUEST                                 (300) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbIbGatewayRequest      { VAR emsg        : EventMsgType;       VAR reqmsg      : ProbeMsgRecord;       VAR wkmp        : Int16;        VAR ierr        : Int16 };       {}  { Abstract:   {  This routine handles all arriving Gateway Request messages.  {}      LABEL 99;       VAR   
   hopcnt         : Int16; 
    mmflags        : MMFlagsType;  
   temp           : Int16; 
     !   {-------------------------------------------------------------} ! !   {   KILL AND ESCAPE / PRB IB GATEWAY REQUEST                  } ! !   {-------------------------------------------------------------} !        PROCEDURE KillAndEscape;      {}   #   { Abstract: Should be used like a macro to generate a KILL_REQUEST  #     {  that can be used to kill the path that the Gateway request   	   {  came in on.  	    {}      BEGIN     DS_LeaveCritical (wkmp);   "   PrbPrepKillRequest (emsg.emdi_down_pid, emsg.emdi_down_ref, 1, 1, "                     scratchemsg);      GOTO 99;      END; {KillAndEscape}       !   {-------------------------------------------------------------} ! !   {   KILL PANIC AND ESCAPE / PRB IB GATEWAY REQUEST            } ! !   {-------------------------------------------------------------} !        PROCEDURE KillPanicAndEscape         ( location     : Int16;           error        : Int16 );          BEGIN     context.longint := 0;  #   Log_Event (EL_ERROR, PROBE, location, context, 2, context.ints[1],  # !                                                          logerr); !    DS_LeaveCritical (wkmp);   "   PrbPrepKillRequest (emsg.emdi_down_pid, emsg.emdi_down_ref, 1, 1, "                     scratchemsg);      GOTO 99;      END; {KillPanicAndEscape}      !{----------------------------------------------------------------} ! !{   BEGIN / PRB IB GATWAY REQUEST                                } ! !{----------------------------------------------------------------} !     BEGIN    { Before doing too much work we make sure we're really a Gateway   { server.   {}  DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);  IF (NOT probegrec.pg_qbits.bits[-1]) THEN      BEGIN     { We're not a gateway server.     {}   	   KillAndEscape;  	    END; {IF NOT}       { Try to read in the request message's VNAs. If we can't read in   { as much data as the SEND_REQUEST emsg promised us then we've  { got serious internal problems. After attempting our read we    { dispose of the mbuf that contained the request since we won't    
{ be needing it any more.  
 {}  WITH emsg, reqmsg, probegrec DO      BEGIN     mmflags.int := 0; {destructive read}   "   DS_MRead (pmr_varpart, emdi_dlen, emdi_mbufid, 0, mmflags, ierr); "    IF (ierr <> SUCCESSFUL) THEN         BEGIN         KillPanicAndEscape (LOC_300_READING_NAME, ierr);  
      END; {IF ierr} 
        DS_MDispose (emdi_mbufid, temp);           { Now that we've read the message in we can make some simple       { checks to make sure that it looks alright.      {}      IF (    (pmr_reportlen <> 8)  OR (pmr_src_reportlen <> 8)  !        OR (pmr_domainlen <> 6)  OR (pmr_src_domainlen <> 8)) THEN !       BEGIN   !      { There's some problem with the length values in the request !       { message.        {         { ENHANCEMENT: Log this problem with low severity.        {}  
      KillAndEscape; 
       END; {IF pmr_reportlen}          { Now try asking IP if it knows how to reach the node whose      { VNA is contained in the request. Note that if the following      { call is successful then part of our request message will      { have been converted into part of our reply message.     {}      IPCanWeGetThere (pmr_src_vna, pmr_vna, hopcnt, ierr);     IF (ierr <> SUCCESSFUL) THEN         BEGIN   
      KillAndEscape; 
 
      END; {IF ierr} 
     $   { IP thinks we'd make a good gateway. We therefore proceed in trying  $ !   { to construct a complete Gateway Reply message. The LAN has to !     { tell us what our IEEE-802.3 address is on the LAN that our       { request came in on.     {}      LANMapVNA (pmr_gwrep_vna, pmr_gwrep_lanelem, ierr);     IF (ierr <> SUCCESSFUL) THEN         BEGIN   !      { Arriving here is odd. IP thought we'd make a good gateway  ! "      { but LAN just had trouble telling us what our station address "       { is on the requestor's (and presumably our own) LAN.         {}        KillPanicAndEscape (LOC_301_LAN_MAPPING, ierr);   
      END; {IF ierr} 
     !   { Now we can try to prepare the rest of our reply. Here we can  ! !   { use all magic numbers because we don't ever expect to change. !    {}      pmr_b.version := 1;     pmr_b.msgtype := PB_GATEWAY_REPLY;   
   pmr_msglen := 28; 
    { pmr_seqnum := <same as request's>;      {}      pmr_gwrep_rlen := 20;     pmr_gwrep_dlen := 18;     pmr_gwrep_pathlen := 10;      pmr_gwrep_hopcnt := hopcnt;      "   { Our message has been completely initialized. Now we try to put  "    { in into an mbuf and also prepare a SEND_REQUEST emsg to     { pass back down to the LAN.      {}   !   PrbPrepSendRequest (pg_probegsd, emdi_down_pid, emdi_down_ref,  !                        reqmsg, scratchemsg, ierr);     IF (ierr <> SUCCESSFUL) THEN         BEGIN          { Looks like and internal error. We shouldn't have had any         { trouble charging our message against Probe's special        { socket.         {}        KillPanicAndEscape (LOC_302_CHARGING_GW_REPLY, ierr);   
      END; {IF ierr} 
        END; {WITH}  DS_LeaveCritical (wkmp);      99:      BEGIN     ProSw (scratchemsg, ierr);      END; {99}  
END; {PrbIbGatewayRequest} 
     $PAGE   !{----------------------------------------------------------------} ! !{   PRB IB NM REPLY                                        (400) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbIbNmReply     {     seqnum      : Int16;        VAR emsg        : EventMsgType;       VAR wkmp        : Int16 };       {}  { Abstract:    {  This routine should be called to handle all DATA_INDICATIONs    {  for Name and Proxy-Name Reply messages. If the received  {  reply is one that a requestor is waiting for then a   {  QUERY_CONFIRM will be sent up to that requestor. In all cases    {  the path that the reply traced up to Probe will be destroyed.   {   
{ Input parameters:  
 {    {  seqnum: The sequence number that ProbeInbound() found in the    {     Probe header of the reply message.  {   {  emsg: The DATA_INDICATION emsg that conveyed the mbufid  {     of the reply message up to Probe.   {   {  wkmp: The current critical region identifier.  {}      LABEL 99;       VAR   
   ierr           : Int16; 
 
   pcbrecid       : Int16; 
     BEGIN    { No matter what, we're going to want to kill the path that the    !{ reply came in on. Therefore, we prepare a KILL_REQUEST emsg that ! { we'll use later regardless of what else happens.  {}  WITH emsg, probegrec, pcbrec DO      BEGIN  $   PrbPrepKillRequest (emdi_down_pid, emdi_down_ref, 1, 1, scratchemsg); $        { Search the list of pending Name Requests hoping to find a      { PCBRecord whose sequence number matches the sequence number      { for the reply message.      {}      DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);   "   PrbSearchPCBList (pg_nameq, seqnum, PCB_SEQNUM_OFFSET, pcbrecid,  "                      pcbrec, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN   !      { Our search failed, therefore we won't be needing the path  !       { report we've just received.         {}        DS_MDispose (emdi_mbufid, ierr);        DS_LeaveCritical (wkmp);        GOTO 99;  
      END; {IF ierr} 
        PrbUnlinkPCB (pg_nameq, pcbrecid, pcbrec);       !   { We've unlinked our entry from the pending request queue. Next ! !   { we try to cancel the timer that was set for the transaction.  ! "   { The timer might have expired already -- if it has then there's  " !   { nothing we can do but expect PrbObNameTimeOut() to handle the !    { situation when the TIMER_NOTIFICATION emsg arrives.     {}      CancelTimer (pcb_timerid, ierr);          PrbPrepQueryConfirm (pcbrec, emdi_mbufid, emdi_dlen,                           SUCCESSFUL, scratchemsg2);     PrbReleasePCB (pcbrecid, pcbrec, probegrec);      DS_StoreElement (DS_ProbeGTD, 1, probegrec.int);      DS_LeaveCritical (wkmp);      ProSw (scratchemsg2, ierr);  
   END; {WITH emsg}  
     99:      BEGIN      { Last thing we must do is send our KILL_REQUEST to the lower      { level protocol telling it to destroy the path the the     { reply came in on.     {}      ProSw (scratchemsg, ierr);      END; {99}  
END; {PrbIbNmReply}  
     $PAGE   !{----------------------------------------------------------------} ! !{   PRB IB NM REQUEST                                      (500) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbIbNmRequest     { VAR emsg        : EventMsgType;       VAR reqmsg      : ProbeMsgRecord;       VAR wkmp        : Int16;        VAR ierr        : Int16 };       {}  { Abstract:    {  This routine handles all arriving Name and Proxy-Name request   {  messages.  {}      LABEL 99;           VAR   
   i              : Int16; 
    mmflags        : MMFlagsType;  
   nlen           : Int16; 
 
   pathlen        : Int16; 
 
   pathmbufid     : Int16; 
 
   pathoffset     : Int16; 
 
   temp           : Int16; 
     !   {-------------------------------------------------------------} ! !   {   KILL AND ESCAPE / PRB IB NAME REQUEST                     } ! !   {-------------------------------------------------------------} !        PROCEDURE KillAndEscape;      {}   #   { Abstract: Should be used like a macro to generate a KILL_REQUEST  # "   {  that can be used to kill the path that the Name or Proxy-Name  " 
   {  request came in on.  
    {}      BEGIN     DS_LeaveCritical (wkmp);   "   PrbPrepKillRequest (emsg.emdi_down_pid, emsg.emdi_down_ref, 1, 1, "                     scratchemsg);      GOTO 99;      END; {KillAndEscape}       !   {-------------------------------------------------------------} ! !   {   KILL PANIC AND ESCAPE / PRB IB NAME REQUEST               } ! !   {-------------------------------------------------------------} !        PROCEDURE KillPanicAndEscape         ( location     : Int16;           error        : Int16 );          BEGIN     context.longint := 0;  "   Log_Event (EL_ERROR, PROBE, location, context, 2, error, logerr); "    DS_LeaveCritical (wkmp);   "   PrbPrepKillRequest (emsg.emdi_down_pid, emsg.emdi_down_ref, 1, 1, "                     scratchemsg);      GOTO 99;      END; {KillPanicAndEscape}      !{----------------------------------------------------------------} ! !{   BEGIN / PRB IB NAME REQUEST                                  } ! !{----------------------------------------------------------------} !     BEGIN   !{ Try to read in the name part of the request message. If we can't !  { read in as much data as our message's header promised us then    { we've got problems somewhere. After attempting our read we   { dispose of the mbuf that contained the request since we won't    
{ be needing it any more.  
 {}  
WITH emsg, reqmsg DO 
    BEGIN     mmflags.int := 0; {destructive read}   "   DS_MRead (pmr_varpart, emdi_dlen, emdi_mbufid, 0, mmflags, ierr); "    IF (ierr <> SUCCESSFUL) THEN         BEGIN         KillPanicAndEscape (LOC_400_READING_NAME, ierr);  
      END; {IF ierr} 
        DS_MDispose (emdi_mbufid, temp);       #   { The name has been read in successfully. Now verify that the name  # 
   { length is reasonable. 
    {}   
   nlen := pmr_nameb.len;  
    IF ((nlen = 0) OR (nlen > MAX_ENVIRON_NAMELEN)) THEN         BEGIN         { The name length specified in the message was outside        { the legal range. We log our observation here and        { forget about trying to satisfy the request.         {}        context.longint := 0;         Log_Event (EL_WARNING, PROBE, LOC_401_BAD_NLEN, context,                   2, nlen, logerr);  
      KillAndEscape; 
 
      END; {IF nlen} 
        { The name is reasonable length. Before querying our nodal      { registry we make sure all characters are in upper case.     {}      EnvNameCheck (pmr_name, nlen, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN         context.longint := 0;         Log_Event (EL_WARNING, PROBE, LOC_402_BAD_NAME,                    context, 0, nlen, logerr);   
      KillAndEscape; 
 
      END; {IF ierr} 
        { Now we check to see what kind of request we've received.      { We won't try to answer a simple name probe unless we're     { the node named in the request.      {}      IF (pmr_b.msgtype = PB_NAME_REQUEST) THEN        BEGIN         pmr_b.msgtype := PB_NAME_REPLY;         DS_FetchElement (DS_NodesTD, 1, noderec.int);         WITH noderec DO            BEGIN           IF (nlen <> nr_nodenamelen) THEN   	            BEGIN  	 !            { The name lengths don't match, therefore we shouldn't !             { try to answer this requestor's name probe.              {}  
            KillAndEscape; 
 
            END; {IF nlen} 
              FOR i := 1 TO nlen DO  	            BEGIN  	 $            IF (noderec.nr_nodename.chars[i] <> pmr_name.chars[i]) THEN  $ 
               BEGIN 
                 { The names have mis-matched character and so we                   { can't be the node named by this name probe.  	               {}  	                KillAndEscape;                  END; {IF ndrec}              END; {FOR i}           END; {WITH noderec}        END      ELSE         BEGIN         pmr_b.msgtype := PB_PROXY_NAME_REPLY;         END; {IF pmr_b}          { Now we try to find the nodal path report in our Nodal      { Registry database. NRegFind panics on its own if there are    	   { any problems. 	    {}   "   NRegFind (pmr_name, nlen, pathmbufid, pathoffset, pathlen, ierr); "    IF ((pathmbufid = NULL) OR (ierr <> SUCCESSFUL)) THEN        BEGIN          { Our nodal registry doesn't have the path report that the   !      { requestor wants. Therefore, we kil the down path and quit. !       {}  
      KillAndEscape; 
 
      END; {IF pathmbufid} 
     #   { The path report we want is in the mbuf identified by pathmbufid.  #    { To prepare our reply message we try to read in this path      { report.     {}   
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE; {set preview bit}   !   DS_MRead (pmr_pathreport.int, pathlen, pathmbufid, pathoffset,  !              mmflags, ierr);     IF (ierr <> SUCCESSFUL) THEN         BEGIN   "      { PANIC. There shouldn't have been any problem reading in our  " 
      { path report. 
       {}        KillPanicAndEscape (LOC_403_READING_NODALREPORT, ierr);   
      END; {IF ierr} 
        { Before sending our message we must initialize its length.     {}      pmr_msglen := PROBE_PREAMBLE_LEN + pathlen;          { We're almost home. If we can get our message into DSAM and       { prepare a SEND_REQUEST emsg we'll be finished.      {}       DS_FetchFields (DS_ProbeGTD, 1, temp, PG_PROBEGSD_OFFSET, 1);   !   PrbPrepSendRequest (temp, emdi_down_pid, emdi_down_ref, reqmsg, !                        scratchemsg, ierr);     IF (ierr <> SUCCESSFUL) THEN         BEGIN         KillPanicAndEscape (LOC_404_PREPARING_NAME_REPLY, ierr);  
      END; {IF ierr} 
     
   END; {WITH emsg}  
     scratchemsg.emsr_killsnd_cnt := 1;  scratchemsg.emsr_killrcv_cnt := 1;      DS_LeaveCritical (wkmp);      99: ProSw (scratchemsg, ierr);  END; {PrbIbNmRequest}       $PAGE   !{----------------------------------------------------------------} ! !{   PRB IB UNSOLICTED                                      (600) } ! !{----------------------------------------------------------------} !     
PROCEDURE PrbIbUnsolicited 
    { VAR emsg        : EventMsgType;       VAR scratchmsg  : ProbeMsgRecord;       VAR wkmp        : Int16;        VAR ierr        : Int16 };       {}  { Abstract:   {  This routine processes Unsolicited Replies. It reads in the  {  entire reply message and then checks to see if the node  {  name contained in the message matches the names of any of  {  the entries in the NodalRegistry database. If a matching   {  entry is found then its information is replaced with the   {  information from the message. Regardless of whether a match  {  is found a KILL_REQUEST emsg is prepared and sent down to  {  the lower level protocol to destroy the path that the  
{  reply came in on. 
 {}      LABEL 99;       VAR      i           : Int16;      mmflags     : MMFlagsType;      newlen      : Int16;      nlen        : Int16;      nprlen      : Int16;      nproffset   : Int16;      pathlen     : Int16;      pathmbufid  : Int16;      pathoffset  : Int16;  {relative to internalndrec beginning}     temp        : Int16;       !   {-------------------------------------------------------------} ! !   {   PANIC BAIL OUT / PRB IB UNSOLICITED                       } ! !   {-------------------------------------------------------------} !     
   PROCEDURE PanicBailOut  
 
      ( location  : Int16; 
         error     : Int16 );         BEGIN     context.longint := 0;  "   Log_Event (EL_ERROR, PROBE, location, context, 2, error, logerr); "    DS_LeaveCritical (wkmp);      GOTO 99;      END; {PanicBailOut}      !{---------------------------------------------------------------}  ! !{   BEGIN / PRB IB UNSOLICITED                                  }  ! !{---------------------------------------------------------------}  !     BEGIN   !{ Knowing that we'll be wanting to kill the down path before we're !  { through regardless of what happens, we prepare a KILL_REQUEST    { emsg as our first act.  {}  !PrbPrepKillRequest (emsg.emdi_down_pid, emsg.emdi_down_ref, 1, 1,  ! #                                                        scratchemsg);  #     !{ Next we try to read in the remainder of the reply message. If we ! { can't read in as much data as our message's header promised   { us then we've got problems somewhere. After attempting our  { read we dispose of the mbuf that contained the request since  { we won't be needing it any more.  {}  WITH emsg, scratchmsg DO     BEGIN     mmflags.int := 0;  {destructive read}  "   DS_MRead (pmr_varpart, emdi_dlen, emdi_mbufid, 0, mmflags, ierr); "    IF (ierr <> SUCCESSFUL) THEN         BEGIN          { PANIC: We've got problems conveying data lengths and/or          { mbufids.        {}        PanicBailOut (LOC_600_READING_UNSOLICITED, ierr);   
      END; {IF ierr} 
        DS_MDispose (emdi_mbufid, temp);          { Check that the length of the received name is reasonable.     { If it isn't then we can quit right now. If it is then we      { want to upshift all lower case characters before querying     { our NodalRegistry database.     {}   
   nlen := pmr_nameb.len;  
    IF ((nlen = 0) OR (nlen > MAX_ENVIRON_NAMELEN)) THEN         BEGIN          { ENHANCEMENT: Might want to log error with low severity.          {}  
      ierr := SUCCESSFUL;  
       context.longint := 0;         Log_Event (EL_WARNING, PROBE, LOC_601_BAD_NLEN,                    context, 2, nlen, logerr);         DS_LeaveCritical (wkmp);        GOTO 99;  
      END; {IF nlen} 
        { Now upshift all the lower case characters to upper case.      {}      FOR i := 1 TO nlen DO        BEGIN         IF ((pmr_name.chars[i] >= 'a') AND            (pmr_name.chars[i] <= 'z')) THEN           BEGIN  !         pmr_name.chars[i] := Chr( Ord( pmr_name.chars[i]) - 32);  !          END; {IF pmr_name}   	      END; {FOR i} 	        { Now use NRegFind() to see if we have an entry in our   !   { NodalRegistry database that matches the node specified in our !    { message.      {}   "   NRegFind (pmr_name, nlen, pathmbufid, pathoffset, pathlen, ierr); "    IF ((pathmbufid = NULL) OR (ierr <> SUCCESSFUL)) THEN        BEGIN   !      { Our NodalRegistry's database doesn't have a matching entry !        { that we can overlay. Therefore, all that's left to do is         { to kill our down path.        {}        DS_LeaveCritical (wkmp);        GOTO 99;  
      END; {IF pathmbufid} 
     !   { Here we check to see if the report we've just received is for !     { our local node. If it is then we'll simply ignore it since       { there is little point in replacing one entry with itself.     {}      DS_FetchElement (DS_NodesTD, 1, noderec.int);     IF (noderec.nr_path_mbufid = pathmbufid) THEN        BEGIN          { We've received the same entry that we've just sent out.          {}        DS_LeaveCritical (wkmp);        GOTO 99;        END; {IF noderec}       !   { Now we want to replace the path report in the NodalRegistry's !    { entry with a new entry.     {}      DS_MAdj (pathmbufid, (-pathlen), ierr);     IF (ierr <> SUCCESSFUL) THEN         BEGIN         PanicBailOut (LOC_602_ADJUSTING_NRENTRY, ierr);   
      END; {IF ierr} 
         { Compute the word offset to the beginning of the Unsolicited      { Reply message's nodal path report.      {}       nproffset := (pmr_nameb.len + PROBE_PREAMBLE_LEN + 3) DIV 2;       nprlen := scratchmsg.ints[nproffset] + 2;  %   DS_MAppendTail (scratchmsg.ints[nproffset], nprlen, pathmbufid, ierr);  %    IF (ierr <> SUCCESSFUL) THEN         BEGIN   !      { We've had some trouble appending our new path report. This !       { is very surprising.         {}        PanicBailOut (LOC_603_ADDING_REPORT, ierr);   
      END; {IF ierr} 
         { Next we try to update the database entry's total-length and      { end-offset fields. This is necessary if the length of our     { new path report differs from the length of the old.     {}      newlen := pathoffset + nprlen - 2;   #   DS_MBOverWrite (newlen, 2, pathmbufid, INDR_LENGTH_BOFFSET, temp);  # !   DS_MBOverWrite (newlen, 2, pathmbufid, INDR_END_BOFFSET, ierr); !    ierr := ierr + temp;      IF (ierr <> SUCCESSFUL) THEN         BEGIN         PanicBailOut (LOC_604_OVERWRITING, ierr);   
      END; {IF ierr} 
        END; {WITH}  DS_LeaveCritical (wkmp);      99:      BEGIN     ProSw (scratchemsg, ierr);      END; {99}      END; {PrbIbUnsolicited}       $PAGE   !{----------------------------------------------------------------} ! !{   PRB IB VA REPLY                                        (700) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbIbVAReply  
   (     dnpid    : Int16; 
 
         dnref    : Int16; 
 
         seqnum   : Int16; 
      VAR wkmp     : Int16 );      {}  { Abstract:   {  In this routine we field an incoming Virtual Address reply.  !{  How we handle the reply depends upon whether we still consider  !  {  its corresponding request to be active (i.e., whether we have   {  a PCB whose sequence number matches the reply).  {   {  If we can find a PCB to match the reply then we'll ask LAN    {  to use information from the reply's path to construct a path    "{  that would satisfy our client -- if LAN is able to construct the  " !{  path then we'll prepare a CONFIRM_DPATH for our client, and if  !  {  not, we'll prepare an ABORT_DPATH. We'll also need to prepare   {  a KILL_REQUEST to kill the multicast path over which the   {  Virtual Address requests were sent.  {    {  After we've prepared all necessary event messages we'll send    {  them and return to our caller.   {   
{ Input parameters:  
 {   {  dnpid: The protocol that delivered the reply.  {   {  dnref: The down reference to the path the reply came in on.  {     This path is bound to the target node but to Probe's  {     dispatch address  The path very close to the one the  {     user wants  -- the user wants a path  !{     bound to the target node and to the user's dispatch address. ! {   !{  seqnum: The sequence number carried in the header of the reply. ! {    {  wkmp: The working map value for the currently active critical   {     region.   {}      LABEL 99;       VAR      ierr                       : Int16;     pcbrecid                   : Int16;      BEGIN    { First we try to locate an active PCB that matches our sequence   { number. We might have to search through both the global   { record's pg_vnaq and pg_tempvnaq queues. Recall that both   { queues are used when we process Virtual Address timeouts.   {}  DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);   PrbSearchPCBList (probegrec.pg_vnaq, seqnum, PCB_SEQNUM_OFFSET,                      pcbrecid, pcbrec, ierr);  IF (ierr = SUCCESSFUL) THEN      BEGIN      { We found a pending entry that matches our sequence number.       { We unlink this entry now so that we can release the PCB  
   { a little later. 
    {}      PrbUnlinkPCB (probegrec.pg_vnaq, pcbrecid, pcbrec);     END  ELSE     BEGIN     { Our seach of pg_vnaq failed so we try pg_tempvnaq.      {}   #   PrbSearchPCBList (probegrec.pg_tempvnaq, seqnum, PCB_SEQNUM_OFFSET, #                      pcbrecid, pcbrec, ierr);      IF (ierr = SUCCESSFUL) THEN        BEGIN         PrbUnlinkPCB (probegrec.pg_tempvnaq, pcbrecid, pcbrec);         END      ELSE         BEGIN         { We couldn't find a PCB to match our sequence number on        { either of the vna queues. All we can do now is destroy        { the down path that the reply came in on. After sending        { our KILL_REQUEST we simply terminate.         {}        DS_LeaveCritical (wkmp);        PrbPrepKillRequest (dnpid, dnref, 1, 1, scratchemsg);         ProSw (scratchemsg, ierr);        GOTO 99;        END; {IF ierr = SUCCESSFUL}   	   END; {IF ierr}  	      { Having found a matching PCB we now want to ask LAN to provide    { us with a new path, one bound to the target node's station  { address and target protocol's dispatch address.   {}  WITH pcbrec DO     BEGIN     { First thing we do is prepare a KILL_REQUEST emsg that we      { can use to kill the multicast path over which we'd been     { sending our Virtual Address Requests. Our KILL_REQUEST's      { send count will count the KILL_REQUEST itself.      {}   $   PrbPrepKillRequest (pcb_down_pid, pcb_down_ref, (pcb_b.downcnt + 1),  $                        1, scratchemsg2);         { Next we ask LAN for our new path. If successful     { the following call will put the new path reference into     { our PCB record's pcb_down_ref field. Before calling      { LanGivePath() we replace the multicast down path registered      { in our PCBRecord with the uni-cast path that our reply      { came in on. This allows us to use some of Probe's canned      { routines.     {  #   { We're being careful here about reference counting. LanGivePath()  # !   { does not increment the reference count of the LAN path record ! !   { it manipulates. That path record's up count should be set to  !    { one.      {}   
   pcb_down_ref := dnref;  
    LanGivePath (pcb_f.vna, pcb_up_pid, pcb_down_ref, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN         { The LAN is probably out of path records. We can't          { satisfy our requestor so we prepare an ABORT_DPATH that          { we can send up.         {}        PrbPrepAbortDPath (pcbrec, scratchemsg, ierr);        END      ELSE         BEGIN   "      { The LAN has come through for us. We prepare a CONFIRM_DPATH  " 
      { for our requestor. 
       {}        PrbPrepConfirmDPath (pcbrec, scratchemsg);        END; {IF ierr <> SUCCESSFUL}         PrbReleasePCB (pcbrecid, pcbrec, probegrec);      DS_StoreElement (DS_ProbeGTD, 1, probegrec.int);          DS_LeaveCritical (wkmp);      ProSw (scratchemsg, ierr); {Either CONFIRM- or ABORT-DPATH}      ProSw (scratchemsg2, ierr);{KILL_REQUEST for multicast path}       END; {WITH pcbrec}       99:;  
END; {PrbIbVAReply}  
     $PAGE   !{----------------------------------------------------------------} ! !{   PRB IB VA REQUEST                                      (800) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbIbVARequest     { VAR reqemsg  : EventMsgType;        VAR reqmsg   : ProbeMsgRecord;   
     VAR wkmp     : Int16; 
      VAR ierr     : Int16 };      {}  { Abstract:    {  This routine should be called to handle all incoming Virtual     {  address requests. The request's virtual address part is still    {  the mbuf that the DATA_INDICATION emsg (reqemsg) references.    {  We must be careful to dispose of this mbuf regardless of   
{  whatever else happens.  
 {   
{ Input parameters:  
 {   !{  reqemsg: The DATA_INDICATION emsg that the lower level protocol !  {     used to deliver the Virtual Address Request message to us.    {     We need the information in this emsg so we can reply on or   
{     kill the down path.  
 {   {  reqmsg: The preamble part of the request message. We'll use  {     this part as a kind of template for our reply should we   {     actually find it necessary to reply.  {}      LABEL 99;       VAR      acctgsd     : Int16;      mmflags     : MMFlagsType;       !   {-------------------------------------------------------------} ! !   {   DO PANIC ESCAPE / PRB IB VA REQUEST                       } ! !   {-------------------------------------------------------------} !     
   PROCEDURE DoPanicEscape 
 
      ( location  : Int16; 
         error     : Int16 );         BEGIN     context.longint := 0;  "   Log_Event (EL_ERROR, PROBE, location, context, 2, error, logerr); "    GOTO 99;      END; {DoPanicEscape}       BEGIN   WITH reqemsg, reqmsg DO      BEGIN      IF (emdi_dlen <> (PROBE_VAREQ_LEN - PROBE_PREAMBLE_LEN)) THEN         BEGIN   #      { The length of the request message wasn't what we thought it'd  # #      { be. We therefore prepare a KILL_REQUEST emsg and take a panic  #       { escape.         {}  &      PrbPrepKillRequest (emdi_down_pid, emdi_down_ref, 1, 1, scratchemsg);  &       DoPanicEscape (LOC_800_BAD_VAREQ_LEN, emdi_dlen);   
      END; {IF emdi_dlen}  
     "   { We've verified that the message is the right length. Now we'll  "    { read in that message and try to process it.     {}      mmflags.int := 0;  {destructive read}  #   DS_MRead (pmr_reportlen, emdi_dlen, emdi_mbufid, 0, mmflags, ierr); #    IF (ierr <> SUCCESSFUL) THEN         BEGIN          { We've got serious problems. We can't read a message that         { LAN told us was in DSAM.        {}  &      PrbPrepKillRequest (emdi_down_pid, emdi_down_ref, 1, 1, scratchemsg);  &       DoPanicEscape (LOC_801_READING_VAREQ, ierr);  
      END; {IF ierr} 
        { Now we ask IP if our node belongs to the virtual network       { address in the request. If it does then we will try to send   !   { out a virtual address reply message, otherwise we will merely !    { kill the path that the request came in on.      {}      IPIsThisMe (pmr_vna, ierr);     IF (ierr = SUCCESSFUL) THEN        BEGIN   !      { We're the node being probed for. Therefore we want to try  !       { sending back a reply. The space taken up by our reply          { message will be charged against Probe's special socket.          {}        pmr_b.msgtype := PB_VNA_REPLY;        pmr_msglen := PROBE_PREAMBLE_LEN;   #      DS_FetchFields (DS_ProbeGTD, 1, acctgsd, PG_PROBEGSD_OFFSET, 1); # $      PrbPrepSendRequest (acctgsd, emdi_down_pid, emdi_down_ref, reqmsg, $                           scratchemsg, ierr);         IF (ierr <> SUCCESSFUL) THEN           BEGIN            PrbPrepKillRequest (emdi_down_pid, emdi_down_ref, 1, 1,                                scratchemsg );            DoPanicEscape (LOC_802_PUTTING_VAREPLY, ierr);            END; {IF ierr}       !      { We set up our SEND_REQUEST emsg to tell the LAN to destroy !        { the down path after our Probe message has been sent out.         {}        scratchemsg.emsr_killsnd_cnt := 1;        scratchemsg.emsr_killrcv_cnt := 1;        END      ELSE         BEGIN          { None of our VNA's matches the one in the request. All we         { have to do is kill the down path.         {}  &      PrbPrepKillRequest (emdi_down_pid, emdi_down_ref, 1, 1, scratchemsg);  & 
      END; {IF ierr} 
    END; {WITH}      99:;  DS_MDispose (reqemsg.emdi_mbufid, ierr);  DS_LeaveCritical (wkmp);  
ProSw (scratchemsg, ierr); 
 END; {PrbIbVARequest}           $PAGE   !{----------------------------------------------------------------} ! !{   PRB OB NAME REQUEST                                    (900) } ! !{----------------------------------------------------------------} !     
PROCEDURE PrbObNameRequest 
    { VAR emsg     : EventMsgType;   
     VAR wkmp     : Int16; 
      VAR ierr     : Int16 };      {}  { Abstract:    {  This routine handles name requests. It should be called with    !{  a QUERY_REQUEST emsg that was sent down by the SocketRegistry.  ! {  The routine attempts to allocate a PCB for tracking the   {  transaction. It initializes that PCB, prepares a Name Request   {  message, and attempts to multicast that message across all   {  LANs that the local node is attached to.   {}      LABEL 99;       VAR      pcbrecid    : Int16;      temp        : Int16;           !   {-------------------------------------------------------------} ! !   {   DO REFUSE QUERY / PRB OB NAME REQUEST                     } ! !   {-------------------------------------------------------------} !     
   PROCEDURE DoRefuseQuery 
 
      ( error  : Int16 );  
        {}      { Abstract:     {  May be used to prepare an error-reporting QUERY_CONFIRM      {  emsg. Most of the information needed to generate this      {  emsg is drawn from the QUERY_REQUEST emsg that was sent      {  down from SocketRegistry.      {}      BEGIN     WITH scratchemsg DO        BEGIN         em_event := QUERY_CONFIRM;        ehport := emsg.emqrq_up_pid * EHS_PER + EHIB_OFFSET;        emqc_up_ref := emsg.emqrq_up_ref;         emqc_down_pid := PROBE;         emqc_seq_num := emsg.emqrq_seq_num;   
      emqc_mbufid := NULL; 
       emqc_dlen := 0;         emqc_result := error;   	      END; {WITH}  	    DS_LeaveCritical (wkmp);      ProSw (scratchemsg, ierr);      END; {DoRefuseQuery}       !{----------------------------------------------------------------} ! !{   BEGIN / PRB OB NAME REQUEST                                  } ! !{----------------------------------------------------------------} !     BEGIN   DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);  PrbGetPCB (probegrec, pcbrecid, pcbrec, ierr);  IF (ierr <> SUCCESSFUL) THEN     BEGIN      { We weren't able to get a PCBRecord, apparently every one in       { the system is currently in use. This fact should have been       { logged by the PrbGetPCB() routine.      {}   
   DoRefuseQuery ( ierr ); 
    GOTO 99;   	   END; {IF ierr}  	      { So far we've allocated a PCB record for tracking our progress.   { We've also "dirtied" Probe's globals record. If everything  !{ goes well we'll want to write these two records out to DSAM, but ! { if we run into some problems we don't need to write anything  { out (the DSAM copies will appear as if nothing happened).   {}  WITH pcbrec, emsg, probegrec DO      BEGIN      { Now we initialize our PCB record. From here on most of our    !   { transaction processing will center on this record. Our first  !    { action is to link the PCB record onto the global record's     { name queue. This is our way of registering that the PCB     { record is being used to track a name query.     {}   
   pcb_nxtptr := pg_nameq; 
    pg_nameq := pcbrecid;     pcb_b.reqtype := PB_NAME_REQUEST;     pcb_b.downcnt := 1;     pcb_up_pid := emqrq_up_pid;     pcb_up_ref := emqrq_up_ref;     pcb_down_pid := IEEE_802;     pcb_down_ref := LAN_PROBE_TARGET;     pcb_f.mbufid := emqrq_mbufid;     pcb_f.up_options := emqrq_options;      pcb_f.up_seqnum := emqrq_seq_num;     END; {WITH pcbrec}       { Now we're ready to generate a new Name Request message and  { corresponding SEND_REQUEST emsg. Note that we're careful to   { preserve the emsg that conveyed the QUERY_REQUEST -- we may   !{ need it to generate a QUERY_CONFIRM in case anything goes wrong. ! {}  PrbSetUpNameMsg (pcbrec, scratchemsg, ierr);  IF (ierr <> SUCCESSFUL) THEN     BEGIN     context.longint := 0;     Log_Event (EL_ERROR, PROBE, LOC_901_CANT_SET_UP_NAMEREC,                 context, 2, ierr, logerr);     DoRefuseQuery (ierr);     GOTO 99;   	   END; {IF ierr}  	      { Our message is prepared and waiting in an mbuf. Before sending    { it we must do the following: modify the root socket referenced   !{ by the request so we can send timer signals on it, set a timer,  ! { save our PCB and globals records. Note that we set the  #{ socket's down pathref field equal to the value of the transaction's  # { sequence number. We do this so that the timer will send this  { number to us as part of any timeout notification emsgs.   {}  WITH pcbrec DO     BEGIN     DS_SoFetchElement (pcb_up_ref, socket.int);     socket.so_down_pathref := pcb_seqnum;     socket.so_down_pid := PROBE;      DS_SoStoreElement (pcb_up_ref, socket.int);         timermsg.socket := pcb_up_ref;      timermsg.direction := OUTBOUND_SIG;     timermsg.signal := TIMERABLE_1;     rqsttime := probegrec.pg_retryinterval;     ActivateTimer (rqsttime, timermsg, pcb_timerid, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN         DS_MDispose (scratchemsg.emsr_mbufid, temp);        context.longint := 0;         Log_Event (EL_ERROR, PROBE, LOC_902_NAME_TIMER_START,                    context, 2, ierr, logerr);         DoRefuseQuery ( ierr );         GOTO 99;  
      END; {IF ierr} 
    END; {WITH pcbrec}       DS_StoreElement (DS_ProbeGTD, 1, probegrec.int);  DS_StoreElement (DS_ProbePCBTD, pcbrecid, pcbrec.int);  DS_LeaveCritical (wkmp);  
ProSw (scratchemsg, ierr); 
     99:;  END; {PrbObNameRequest}       $PAGE   !{----------------------------------------------------------------} ! !{   PRB OB NAME TIME OUT                                  (1000) } ! !{----------------------------------------------------------------} !     
PROCEDURE PrbObNameTimeOut 
 
   {     seqnum   : Int16; 
 
     VAR wkmp     : Int16; 
      VAR ierr     : Int16 };      {}  { Abstract:   {  This routine handles timer notifications for pending Name  {  Request transactions. It first tries to find the PCB   {  for the transaction. If none is found then the timer   {  notification is ignored. If an active PCB is found then  {  a check is made to see if a retry should be attempted  {  or if the maximum number of attempts has already been  {  made.  {   	{ Input parameter: 	 {   {  seqnum: The sequence number for the transaction. This value  {     should have been delivered to ProbeOutbound() via a   {     TIMER_NOTIFICATION emsg (it would have been found in  {     the emsg's down path reference field).  {}      LABEL 99;       VAR      pcbrecid    : Int16;      temp        : Int16;       !   {-------------------------------------------------------------} ! !   {   DO CLOSE TRANSACTION                                      } ! !   {-------------------------------------------------------------} !        PROCEDURE DoCloseTransaction         ( pathrepmbufid   : Int16;          pathreplen      : Int16;          reason          : Int16 );         {}      { Abstract:  !   {  This routine may be called to release the PCBRecord that was ! "   {  being used to track the transaction. The routine also prepares "     {  a QUERY_CONFIRM emsg and sends it up to the protocol that    !   {  originally initiated the transaction. If the transaction was !     {  successful then an mbufid and length for the obtained path   !   {  report will be sent in the QUERY_CONFIRM. The 'reason' input ! $   {  parameter should indicate whether the transaction was successful.  $    {}          BEGIN     PrbUnlinkPCB (probegrec.pg_nameq, pcbrecid, pcbrec);      PrbPrepQueryConfirm (pcbrec, pathrepmbufid, pathreplen,                  reason, scratchemsg);      PrbReleasePCB (pcbrecid, pcbrec, probegrec);      DS_StoreElement (DS_ProbeGTD, 1, probegrec.int);      DS_LeaveCritical (wkmp);      ProSw (scratchemsg, ierr);      END; {DoCloseTransaction}      !{----------------------------------------------------------------} ! !{   BEGIN / PRB OB NAME TIME OUT                                 } ! !{----------------------------------------------------------------} !     BEGIN   DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);  
WITH pcbrec, probegrec DO  
    BEGIN     PrbSearchPCBList (pg_nameq, seqnum, PCB_SEQNUM_OFFSET,                        pcbrecid, pcbrec, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN   !      { We must have completed the transaction already. Therefore, !       { we don't have to do anything.         {}        DS_LeaveCritical (wkmp);  
      ierr := SUCCESSFUL;  
       GOTO 99;  
      END; {IF ierr} 
     "   { Now we check to see if we've exhausted all our retry attempts.  "    {}      IF (pcb_b.downcnt > MAX_NAME_ATTEMPTS) THEN        BEGIN   "      { We've retried our request the maximum number of times. What  " "      { we need to do now is back out of our transaction. We assume  "        { we were trying to locate a SocketRegistry and return an          { error indicating this. It might be better to return an  #      { error more specific to Probe, e.g., Probe-couldn't-find-node.  #       {}        DoCloseTransaction (NULL, 0, U_UNKNOWN_REGISTRY);         END      ELSE         BEGIN          { We haven't exhausted our retries and so must generate a          { new Name or Proxy-Name Request message and send it.         {}        PrbSetUpNameMsg (pcbrec, scratchemsg, ierr);        IF (ierr <> SUCCESSFUL) THEN           BEGIN           { PANIC. There shouldn't have been any problems given           { that we've gotten this far. To recover we try to            { release the PCB record and abort the transaction.           {}            temp := ierr;           context.longint := 0;            Log_Event (EL_ERROR, PROBE, LOC_1000_RETRYING_NAMEREQ,                        context, 2, ierr, logerr);           DoCloseTransaction (NULL, 0, U_INTERNALERR);   	         GOTO 99;  	          END; {IF ierr}       #      { Our send request has been prepared for retransmission. Before  # !      { sending it we must set a timer and save our PCBRecord and  !       { ProbeGRecord.         {}        timermsg.socket := pcb_up_ref;        timermsg.direction := OUTBOUND_SIG;         timermsg.signal := TIMERABLE_1;         rqsttime := pg_retryinterval;         ActivateTimer (rqsttime, timermsg, pcb_timerid, ierr);        IF (ierr <> SUCCESSFUL) THEN           BEGIN            { PANIC. We don't normally expect our timer requests to   $         { fail. We must release the mbuf containing our retransmission  $           { message and then try to back out of this transaction.            {}            temp := ierr;           DS_MDispose (scratchemsg.emsr_mbufid, ierr);            context.longint := 0;  "         Log_Event (EL_ERROR, PROBE, LOC_1001_RESETTING_NAME_TIMER,  "                     context, 2, temp, logerr);           DoCloseTransaction (NULL, 0, U_INTERNALERR);   	         GOTO 99;  	          END; {IF ierr}       "      { Our timer is set. Our message is ready. After saving context "       { we can issue our retry.         {}        DS_StoreElement (DS_ProbeGTD, 1, probegrec.int);        DS_StoreElement (DS_ProbePCBTD, pcbrecid, pcbrec.int);        DS_LeaveCritical (wkmp);        ProSw (scratchemsg, ierr);        END; {IF pcb_b.downcnt}      END; {WITH pcbrec}       99:;  END; {PrbObNameTimeOut}       $PAGE   !{----------------------------------------------------------------} ! !{   PRB OB UNSOLICITED                                    (1100) } ! !{----------------------------------------------------------------} !     
PROCEDURE PrbObUnsolicited 
 
   { VAR wkmp     : Int16; 
      VAR ierr     : Int16 };      {}  { Abstract:   !{  This routine should be called to generate and send Unsolicited  ! {  Reply messages. ProbeOutbound() will normally call   #{  PrbObUnsolicited() whenever it receives a TIMERABLE_3 notification  # "{  via Probe's special socket. The caller should already be critical " {  when calling. Upon return we'll no longer be critical.   {}      LABEL 99;       VAR   
   gsd            : Int16; 
 
   mlen           : Int16; 
    mmflags        : MMFlagsType;  
   pathlen        : Int16; 
 
   pathmbufid     : Int16; 
 
   pathoffset     : Int16; 
     !   {-------------------------------------------------------------} ! !   {   BAIL OUT / PRB OB UNSOLICITED                             } ! !   {-------------------------------------------------------------} !     
   PROCEDURE BailOut 
 
      ( location : Int16;  
         error    : Int16 );          BEGIN     context.longint := 0;  "   Log_Event (EL_ERROR, PROBE, location, context, 2, error, logerr); "    DS_LeaveCritical ( wkmp );      GOTO 99;   	   END; {BailOut}  	     BEGIN   !{ First we get the name of our local node from the NodeRecord. We  !  { assume the NodeRecord has already been completely initialized.   {}  DS_FetchElement (DS_NodesTD, 1, noderec.int);       WITH noderec, scratchmsg, probegrec DO     BEGIN     pmr_b.version := 0;     pmr_b.msgtype := PB_UNSOLICITED_REPLY;      pmr_seqnum := 0; {don't care}     pmr_nameb.ntype := 1; {node name type}      pmr_nameb.len := nr_nodenamelen;      pmr_name := nr_nodename;      IF Odd (nr_nodenamelen) THEN         BEGIN         { Must add NULL pad byte to odd length names.         {}        pmr_name.bytes[nr_nodenamelen + 1] := 0;        mlen := 1;        END      ELSE         BEGIN         mlen := 0;  
      END; {IF Odd}  
     !   { Now we try to find the nodal path report in our NodalRegistry !    { NRegFind() panics on its won if there are any problems.     {}   !   NRegFind (nr_nodename, nr_nodenamelen, pathmbufid, pathoffset,  !              pathlen, ierr);     IF ((pathmbufid = NULL) OR (ierr <> SUCCESSFUL)) THEN        BEGIN         { Our NodalRegistry is really fouled up. It can't locate        { our local node's path report.         {}        BailOut (LOC_1100_CANT_FIND_ME, ierr);        END; {IF}          { Here we calculate the byte length of our message so far.      { We save this length and we also use it to calculate the     { word offset into our message where we should place our   	   { path report.  	    {}      mlen := mlen + nr_nodenamelen + PROBE_PREAMBLE_LEN + 2;     pmr_msglen := mlen;     mlen := mlen DIV 2; {word offset to path report position}         { The path report we want is in the mbuf identified by      { pathmbufid. To prepare our reply message we must read in   	   { this report.  	    {}   
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE; {set preview bit}      DS_MRead (scratchmsg.ints[mlen], pathlen, pathmbufid,               pathoffset, mmflags, ierr);     IF (ierr <> SUCCESSFUL) THEN         BEGIN          { PANIC: We shouldn't have had any trouble reading in our          { own nodal path report.        {}        BailOut (LOC_1101_CANT_READ_OWN_REPORT, ierr);  
      END; {IF ierr} 
     %   pmr_msglen := pmr_msglen + pathlen; {include path length in msg length} %        { Now that we've completely prepared our Unsolicited Reply       { message, we can try putting in into DSAM. At the same time       { we want to prepare a SEND_REQUEST emsg. Note that our  "   { send request will be a special group or multicast send request. "    {}      DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);      timermsg.socket := pg_probegsd;  "   PrbPrepSendRequest (timermsg.socket, IEEE_802, LAN_PROBE_TARGET,  "                        scratchmsg, scratchemsg, ierr);     scratchemsg.emsr_flags.bits[0] := TRUE; {group path bit}      IF (ierr <> SUCCESSFUL) THEN         BEGIN         BailOut (LOC_1102_CHARGING_UNSOLICITED, ierr);  
      END; {IF ierr} 
        { Lastly, we must try to reset our unsolicited timer.     {}      timermsg.direction := OUTBOUND_SIG;     timermsg.signal := TIMERABLE_3;     rqsttime := pg_unsol_interval;      ActivateTimer (rqsttime, timermsg, timerid, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN         DS_MDispose (scratchemsg.emdi_mbufid, mlen);        BailOut (LOC_1103_SETTING_UNSOL_TIMER, ierr);   
      END; {IF ierr} 
        END; {WITH}  DS_LeaveCritical (wkmp);  
ProSw (scratchemsg, ierr); 
     99:;  END; {PrbObUnsolicited}       $PAGE   !{----------------------------------------------------------------} ! !{   PRB OB VA REQUEST                                     (1200) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbObVARequest     { VAR emsg     : EventMsgType;   
     VAR wkmp     : Int16; 
      VAR ierr     : Int16  };       {}  { Abstract:    {  This routine handles virtual address requests. Such requests    {  are delivered to Probe via REQUEST_DPATH emsgs. These kinds  {  of emsgs contain the virtual network address of the node   {  that the requestor wishes to have a d-path for.  {}      VAR   
   dnpathref      : Int16; 
 
   pcbrecid       : Int16; 
 
   temp           : Int16; 
     !   {------------------------------------------------------------}  ! !   {   DO CONFIRM DPATH / PRB OB VA REQUEST                     }  ! !   {------------------------------------------------------------}  !        PROCEDURE DoConfirmDPath;         {}      { Abstract:     {  This procedure is used like a MACRO to prepare and send       {  (i.e, ProSw) CONFIRM_DPATH event messages to the requestor      {  that sent Probe a REQUEST_DPATH event message.     {}          BEGIN     WITH scratchemsg DO        BEGIN         em_event := CONFIRM_DPATH;        ehport := emsg.emrd_root_pid * EHS_PER + EHIB_OFFSET;         emcd_root_ref := emsg.emrd_root_ref;        emcd_vna := emsg.emrd_vna;        emcd_down_pid := emsg.emrd_down_pid;        emcd_down_ref := dnpathref;         END; {WITH scratchemsg}      DS_LeaveCritical (wkmp);      ProSw (scratchemsg, ierr);      END; {DoConfirmDpath}      !   {------------------------------------------------------------}  ! !   {   DO ABORT DPATH / PRB OB VA REQUEST                       }  ! !   {------------------------------------------------------------}  !        PROCEDURE DoAbortDPath ( reason  : Int16 );         {}      { Abstract:  !   {  Used to prepare and send ABORT_DPATH emsgs when Probe can't  !    {  for any reason produce the d-path requested in a  
   {  REQUEST_DPATH emsg.  
    {}      BEGIN     WITH scratchemsg DO        BEGIN         em_event := ABORT_DPATH;        ehport := emsg.emrd_root_pid * EHS_PER + EHIB_OFFSET;         emed_root_ref := emsg.emrd_root_ref;        emed_reason := reason;        emed_vna := emsg.emrd_vna;        END; {WITH scratchemsg}      DS_LeaveCritical (wkmp);      ProSw (scratchemsg, ierr);      END; {DoAbortDPath}      !   {-------------------------------------------------------------} ! !   {   DO LOG ERROR / PRB OB VA REQUEST                          } ! !   {-------------------------------------------------------------} !        PROCEDURE DoLogError   
      ( location  : Int16; 
         error     : Int16 );         BEGIN     context.longint := 0;  "   Log_Event (EL_ERROR, PROBE, location, context, 2, error, logerr); " 
   END; {DoLogError} 
     !   {-------------------------------------------------------------} ! !   {   DO SEND VA PROBE / PRB OB VA REQUEST                      } ! !   {-------------------------------------------------------------} !     
   PROCEDURE DoSendVAProbe 
 
      ( dnpid     : Int16; 
         dnpath    : Int16 );         {}      { Abstract:     {  This routine may be used to send Virtual Address Probe's     {  out over IEEE-802 (or which ever lower level protocol      {  we've determined will support our multicasts). We try      {  to allocate a Probe Control Block (PCB) record to keep     {  track of our progress. If we can't get a PCB record then     {  we'll have to discontinue our request processing.      {     { Input Parameters:     {  !   {  dnpid: The PID of the lower level protocol that the message  !    {     should be sent to.      {  !   {  dnpath: Reference to the path over which the message should  ! 	   {     be sent.  	    {}          LABEL 99;         BEGIN     DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);      PrbGetPCB (probegrec, pcbrecid, pcbrec, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN          { We don't have any free PCBRecords right now. PrbGetPCB()          { should have logged this fact. In this case we just give          { up.         {}        DoAbortDPath ( ierr );        GOTO 99;        END;         { We've managed to allocate a PCB record for tracking our     { progress and can proceed to toward our goal of sending      { a Virtual Address request.      {}      WITH pcbrec, emsg, probegrec DO        BEGIN   !      { Next we initialize the PCB record that we're going to use  !        { to keep track of our transaction. Note carefully that we   !      { do a little fancy footwork here with the PCB's down count. !        { We assign it a special value so that we don't retransmit         { our request too soon. PrbObVATimeOut() will modify         { the down count to a more normal value upon encountering          { this special value (see Probe D.O. for details).        {}        pcb_b.reqtype := PB_VNA_REQUEST;        pcb_b.downcnt := PROBE_FIRST_SEND;        pcb_up_pid := emrd_root_pid;        pcb_up_ref := emrd_root_ref;        pcb_down_pid := dnpid;        pcb_down_ref := dnpath;         pcb_f.vna := emrd_vna;             { Now we can use our PCB to generate a new Virtual Address         { request message and associated SEND_REQUEST emsg. Note        { that we're careful to preserve the emsg that conveyed         { the REQUEST_DPATH -- we may need it to generate an        { ABORT_DPATH in case any thing goes wrong.         {}        PrbSetUpVAMsg (pg_probegsd, pcbrec, scratchemsg, ierr);         IF (ierr <> SUCCESSFUL) THEN           BEGIN           { PANIC. We shouldn't have had any problem charging a           { message against Probe's special socket. To recover            { we'll send up an ABORT_DPATH emsg. We don't worry           { about posting the ProbeGRecord or the PCB we were           { using since we only had a local copy.           {}             temp := ierr; {so its not overwritten before we panic}             DoLogError (LOC_1200_CHARGING_VA_REQ, temp);            DoAbortDPath (U_INTERNALERR);  	         GOTO 99;  	          END; {IF ierr}              { Now we want to consider setting a timer. If our pg_vnaq    !      { isn't empty then there's no need to set a new timer since  ! !      { our algorithm allows all pending Virtual Address requests  !       { to share the same timer.        {}        IF (pg_vnaq = NULL) THEN           BEGIN           { We must start a timer. We'll want it to send down a           { TIMERABLE_2 signal through Probe's special socket.            {}            PrbStartVATimer (probegrec, ierr);            IF (ierr <> SUCCESSFUL) THEN   	            BEGIN  	 !            { We failed to set the timer. This is a real surprise. !             { To recover we must dispose the mbuf holding our   !            { Virtual Address request and send an ABORT_DPATH emsg ! "            { up to the requestor. We don't have to worry about the  " "            { ProbeGRecord or PCB since we've only been playing with "             { local copies.               {}              temp := ierr; {so we don't lose it}               DS_MDispose ( scratchemsg.emsr_mbufid, ierr);                DoLogError (LOC_1201_SETTING_FIRST_VA_TIMER, temp);                DoAbortDpath (U_INTERNALERR);   
            GOTO 99; 
 
            END; {IF ierr} 
     #         { Because this PCB will be the only one on the retransmission # #         { queue we won't have to process it specially when a timeout  # 
         { arrives.  
          {}            pcb_b.downcnt := 1;  
         END; {IF pg_vnaq} 
     #      { We're finished dealing with timer initialization. Now we must  #        { link our PCB onto the VNA queue and save off the globals         { record and the PCB.         {}        pcb_nxtptr := pg_vnaq;  
      pg_vnaq := pcbrecid; 
           DS_StoreElement (DS_ProbeGTD, 1, probegrec.int);        DS_StoreElement (DS_ProbePCBTD, pcbrecid, pcbrec.int);            END; {WITH pcbrec}         DS_LeaveCritical ( wkmp );      ProSw (scratchemsg, ierr);       99:;  
END; {DoSendVAProbe} 
     !{----------------------------------------------------------------} ! !{   BEGIN / PRB OB VA REQUEST                                    } ! !{----------------------------------------------------------------} !     BEGIN   WITH emsg DO     BEGIN  !   { Determin which lower level protocol the requestor thinks can  !    { build us a path to the target node.     {}      CASE emrd_down_pid OF            IEEE_802:            BEGIN           LanSearch (emrd_vna, emrd_root_pid, dnpathref, ierr);           IF (ierr = SUCCESSFUL) THEN  	            BEGIN  	             DoConfirmDPath;               END            ELSE IF (ierr = LI_NOTFOUND) THEN  	            BEGIN  	             { IEEE_802 has told us that it doesn't know how to              { give us the down path we need right now but that              { we may try multicasting a Virtual Address Probe               { over the path provided.               {}              DoSendVAProbe (emrd_down_pid, dnpathref);               END            ELSE   	            BEGIN  	 !            { There is no hope. IEEE_802 can't give us the path we ! !            { desire. Nor can it give us a multicast path. We must !             { give up.              {}              DoAbortDPath ( ierr );  
            END; {IF ierr} 
          END; {IEEE_802 case}                 ROUTER:            BEGIN  "         { The algorithm used for Router is very similar to the one  "          { used for LAN. The only difference is that we can't            { multicast Virtual Address Probes onto Router nets.            {}   !         RouterSearch ( emrd_vna, emrd_root_pid, dnpathref, ierr); !          IF (ierr = SUCCESSFUL) THEN  	            BEGIN  	             DoConfirmDPath;               END            ELSE   	            BEGIN  	             { We must give up. Router can't help us.              {}              DoAbortDPath ( ierr );  
            END; {IF ierr} 
          END; {ROUTER case}             GG_PID:            BEGIN  #         { The algorithm used for gateway lines is similar to the one  #          { used for Router. We can't of course multicast           { Virtual Address Probes onto Router nets.            {}   "         GatewaySearch ( emrd_vna, emrd_root_pid, dnpathref, ierr);  "          IF (ierr = SUCCESSFUL) THEN  	            BEGIN  	             DoConfirmDPath;               END            ELSE   	            BEGIN  	             { We must give up. Gateway lines can't help us.               {}              DoAbortDPath ( ierr );  
            END; {IF ierr} 
          END; {GG_PID case}             OTHERWISE            BEGIN  !         { The lower level protocol passed to us by the requestor  !          { doesn't mean anything to us.            {}            DoLogError (LOC_1202_VAREQ_BAD_PID, emrd_down_pid);           DoAbortDPath ( U_INTERNALERR );  
         END; {OTHERWISE}  
 	      END; {CASE}  	    END; {WITH}  END; {PrbObVARequest}       $PAGE   !{----------------------------------------------------------------} ! !{   PRB OB VA TIME OUT                                    (1300) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbObVATimeOut  
   { VAR wkmp     : Int16; 
      VAR ierr     : Int16 };  {}  { Abstract:    {  This routine's responsibility is to process timeouts related    {  to pending Virtual Address requests. Each Virtual Address  {  timeout causes Probe to process the entire queue of pending  !{  requests. For those requests that have been retried the maximum ! {  permissible number of times, ABORT_DPATH emsgs are sent up    {  and KILL_REQUEST emsgs are sent down. All other requests are    {  retried.   {}      VAR      pcbrecid    : Int16;      temp        : Int16;       !   {-------------------------------------------------------------} ! !   {   DO ABORT TRANSACTION / PRB OB VA TIME OUT                 } ! !   {-------------------------------------------------------------} !        PROCEDURE DoAbortTransaction         ( ierr      : Int16 );         {}      { Abstract:     {  This routine may be called to abort Virtual Address       {  transactions. It will be called in case a request has been      {  retried too many times or if an internal software error      {  is encountered while attempting a retry. The routine     {  prepares and sends an ABORT_DPATH up to the client. It     {  also returns the PCB used to track the transaction to      {  the free pool. And finally it sends a KILL_REQUEST down      {  to the LAN so that the multicast path over which the  "   {  Virtual Address Request messages were sent will be destroyed.  "    {}          BEGIN  	   WITH pcbrec DO  	       BEGIN         PrbPrepKillRequest (pcb_down_pid,                             pcb_down_ref,   #                          pcb_b.downcnt + 1, {count KILL_REQUEST too}  #                           1,                            scratchemsg2);  	      END; {WITH}  	    PrbPrepAbortDPath (pcbrec, scratchemsg, ierr);      PrbReleasePCB (pcbrecid, pcbrec, probegrec);      DS_StoreElement (DS_ProbeGTD, 1, probegrec.int);      DS_LeaveCritical (wkmp);      ProSw (scratchemsg, ierr);      ProSw (scratchemsg2, ierr);     END; {DoAbortTransaction}      "   {--------------------------------------------------------------}  " "   {   DO LOG ERROR / PRB OB VA TIME OUT                          }  " "   {--------------------------------------------------------------}  "        PROCEDURE DoLogError         ( location     : Int16;           error        : Int16 );          BEGIN     context.longint := 0;  "   Log_Event (EL_ERROR, PROBE, location, context, 2, error, logerr); " 
   END; {DoLogError} 
     "{-----------------------------------------------------------------}  " "{   BEGIN / PRB OB VA TIME OUT                                    }  " "{-----------------------------------------------------------------}  "     BEGIN   DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);  
WITH probegrec, pcbrec DO  
    BEGIN     { Process all entries in the pg_vnaq.     {}      WHILE (pg_vnaq <> NULL) DO         BEGIN         { Unlink the first/next PCB record from the pg_vnaq.        {}  
      pcbrecid := pg_vnaq; 
       DS_FetchElement (DS_ProbePCBTD, pcbrecid, pcbrec.int);        pg_vnaq := pcb_nxtptr;            { If the request has just been transmitted for the first        { time then we won't retransmit it now. Instead we'll         { just change its down count to show that its been        { handled once and then place it on the pg_tempvnaq.        {}        IF (pcb_b.downcnt = PROBE_FIRST_SEND) THEN           BEGIN           pcb_b.downcnt := 1; {true and "normal" value}           pcb_nxtptr := pg_tempvnaq;            pg_tempvnaq := pcbrecid;             DS_StoreElement (DS_ProbePCBTD, pcbrecid, pcbrec.int);             END        ELSE IF (pcb_b.downcnt < MAX_VA_ATTEMPTS) THEN           BEGIN  "         { We haven't exhausted all retry attempts for this request. "           { Therefore, we'll try to prepare a new Virtual Address            { request message and put it into a DSAM buffer.   !         { If we can't get the buffer space we need then something !          { must be seriously wrong.            {}             PrbSetUpVAMsg (pg_probegsd, pcbrec, scratchemsg, ierr);            IF (ierr <> SUCCESSFUL) THEN   	            BEGIN  	              { PANIC: We shouldn't have had any trouble charging                { the space for our retry message against Probe's               { special socket.               {}  
            temp := ierr;  
             DoLogError (LOC_1300_CHARGING_VA_RETRY, temp);              DoAbortTransaction (U_INTERNALERR);               END            ELSE {ierr = SUCCESSFUL}   	            BEGIN  	 !            pcb_b.downcnt := pcb_b.downcnt + 1; {for SEND_REQUEST} !             pcb_nxtptr := pg_tempvnaq;              pg_tempvnaq := pcbrecid;              DS_StoreElement (DS_ProbeGTD, 1, probegrec.int);  !            DS_StoreElement (DS_ProbePCBTD, pcbrecid, pcbrec.int); !             DS_LeaveCritical (wkmp);                  ProSw (scratchemsg, ierr);                  END; {IF ierr <> SUCCESSFUL}           END        ELSE {we've exhausted all our retries}           BEGIN           DoAbortTransaction (U_RETRY_COUNT_EXHAUSTED);           END; {IF pcb_b.downcnt}            DS_EnterCritical ( wkmp, ierr);         DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);  	      END; {WHILE} 	        { Now that we've gone through the entire queue of pending     { Virtual Address requests we need to decide whether it's     { appropriate to reset our Virtual Address timer.     {}      IF (pg_tempvnaq <> NULL) THEN        BEGIN   !      { We've still got some requests pending and so we must reset ! 	      { our timer. 	       {}        pg_vnaq := pg_tempvnaq;   
      pg_tempvnaq := NULL; 
       PrbStartVATimer (probegrec, ierr);        IF (ierr <> SUCCESSFUL) THEN           BEGIN           { PANIC: We shouldn't have had any problem resetting            { our retransmission timer. To recover we will            { abort all the pending VA transactions. This will            { be a little tricky because there may be several of            { them.           {}            DS_StoreElement (DS_ProbeGTD, 1, probegrec.int);            DoLogError (LOC_1301_RESET_VA_TIMER, ierr);           DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);                WHILE (pg_vnaq <> NULL) DO   	            BEGIN  	             pcbrecid := pg_vnaq;  !            DS_FetchElement (DS_ProbePCBTD, pcbrecid, pcbrec.int); !             pg_vnaq := pcbrec.pcb_nxtptr;               DoAbortTransaction (U_INTERNALERR);               DS_EnterCritical (wkmp, ierr);              DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);              END; {WHILE}           END        ELSE           BEGIN           DS_StoreElement (DS_ProbeGTD, 1, probegrec.int);            END; {IF ierr}         END; {IF pg_tempvnaq}          DS_LeaveCritical (wkmp);      END; {WITH}  END; {PrbObVATimeOut}       $PAGE   !{----------------------------------------------------------------} ! !{   PRB PREP ABORT DPATH                                  (1400) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbPrepAbortDPath      { VAR pcb      : PCBRecord;       VAR emsg     : EventMsgType;            error    : Int16 };      {}  { Abstract:    {  This routine prepares an ABORT_DPATH emsg from a passed error   !{  code and PCB record. It does not send the emsg through ProSw()  ! {  nor does it enter or leave critical.   {}  BEGIN   	WITH emsg, pcb DO  	    BEGIN     em_event := ABORT_DPATH;      ehport := pcb_up_pid * EHS_PER + EHIB_OFFSET;     emed_root_ref := pcb_up_ref;      emed_reason := error;  
   emed_vna := pcb_f.vna;  
 
   END; {WITH emsg}  
 END; {PrbPrepAbortDPath}      $PAGE   !{----------------------------------------------------------------} ! !{   PRB PREP CONFIRM DPATH                                (1500) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbPrepConfirmDpath      { VAR pcbrec     : PCBRecord;       VAR cdpathemsg : EventMsgType };       BEGIN   
WITH pcbrec, cdpathemsg DO 
    BEGIN     ehport := pcb_up_pid * EHS_PER + EHIB_OFFSET;     em_event := CONFIRM_DPATH;      emcd_root_ref := pcb_up_ref;   
   emcd_vna := pcb_f.vna;  
    emcd_down_pid := pcb_down_pid;      emcd_down_ref := pcb_down_ref;      END; {WITH pcbrec}   
END; {PrbPrepConfirmDpath} 
     $PAGE   !{----------------------------------------------------------------} ! !{   PRB PREP KILL REQUEST                                 (1600) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbPrepKillRequest  
   {     dnpid    : Int16; 
 
         dnref    : Int16; 
 
         dncnt    : Int16; 
 
         upcnt    : Int16; 
      VAR emsg     : EventMsgType };       {}  { Abstract:   !{  This routine prepares a KILL_REQUEST emsg from the information  ! {  passed. It does not send the emsg nor does it enter or   	{  leave critical. 	 {}      BEGIN   WITH emsg DO     BEGIN     em_event := KILL_REQUEST;     ehport := dnpid * EHS_PER + EHOB_OFFSET;   
   emkr_down_ref := dnref; 
    emkr_msg_snd_cnt := dncnt;      emkr_msg_rcv_cnt := upcnt;      END; {WITH}  
END; {PrbPrepKillRequest}  
 $PAGE   !{----------------------------------------------------------------} ! !{   PRB PREP QUERY CONFIRM                                (1700) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbPrepQueryConfirm      { VAR namepcb        : PCBRecord;           pathrepmbufid  : Int16;           pathreplen     : Int16;           errorcode      : Int16;       VAR eventmsg       : EventMsgType };       {}  { Abstract:   {  This routine may be called to prepare QUERY_CONFIRM emsgs  {  suitable for closing out Name Request transactions. Once   {  prepared the QUERY_CONFIRM is NOT sent, only returned to   {  the caller.  {   
{ Input parameters:  
 {   !{  namepcb: The PCBRecord that was used to track the Name Request  ! 	{     transaction. 	 {}      BEGIN   
WITH eventmsg, namepcb DO  
    BEGIN     em_event := QUERY_CONFIRM;      ehport := pcb_up_pid * EHS_PER + EHIB_OFFSET;     emqc_up_ref := pcb_up_ref;   
   emqc_down_pid := PROBE; 
    emqc_seq_num := pcb_f.mbufid; {mbufid of LookUpRecord}      emqc_mbufid := pathrepmbufid;     emqc_dlen := pathreplen;      emqc_result := errorcode;     END; {WITH eventmsg}   
END; {PrbPrepQueryConfirm} 
     $PAGE   !{----------------------------------------------------------------} ! !{   PRB PREP SEND REQUEST                                 (1800) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbPrepSendRequest  
   {     acctgsd  : Int16; 
 
         dnpid    : Int16; 
 
         dnref    : Int16; 
      VAR msg      : ProbeMsgRecord;        VAR sendemsg : EventMsgType;        VAR ierr     : Int16 };      BEGIN   WITH msg, sendemsg DO      BEGIN     PrbChargeMsg (acctgsd, msg, emsr_mbufid, ierr);     IF (ierr = SUCCESSFUL) THEN        BEGIN         em_event := SEND_REQUEST;         ehport := dnpid * EHS_PER + EHOB_OFFSET;        emsr_down_ref := dnref;         emsr_dlen := pmr_msglen;  
      emsr_flags.int := 0; 
       emsr_opt_mbufid := 0;         emsr_killsnd_cnt := 0;  
      END; {IF ierr} 
 	   END; {WITH msg} 	 
END; {PrbPrepSendRequest}  
     $PAGE   !{----------------------------------------------------------------} ! !{   PRB RELEASE PCB                                              } ! !{----------------------------------------------------------------} !     PROCEDURE PrbReleasePCB      {    pcbrecid     : Int16;       VAR pcb          : PCBRecord;       VAR grec         : ProbeGRecord };      {}  { Abstract:   {  This routine links PCB record onto Probe's free queue. The    {  header for this queue in maintained in Probe's ProbeGRecord.     {  PrbReleasePCB() writes the PCB record out to DSAM but doesn't   {  write out the globals record even though it modifies it.   {}      BEGIN   	WITH pcb, grec DO  	    BEGIN  
   pcb_nxtptr := pg_freeq; 
    pg_freeq := pcbrecid;     DS_StoreElement ( DS_ProbePCBTD, pcbrecid, pcb.int);      END; {WITH}  	END; {PrbRelease}  	     $PAGE   !{----------------------------------------------------------------} ! !{   PRB SEARCH PCB LIST                                          } ! !{----------------------------------------------------------------} !     
PROCEDURE PrbSearchPCBList 
 
   {     hdptr    : Int16; 
          key      : Int166;  
         offset   : Int16; 
 
     VAR pcbrecid : Int16; 
      VAR pcbrec   : PCBRecord;       VAR ierr     : Int16 };      {}  { Abstract:   {  This routine may be used to search a singly linked list of   {  PCB records for a record that contains a 16-bit key value  {  at the offset (0-based) specified. This routine does NOT   {  unlink the PCBRecord from the list (if it is found).   {   
{ Input Parameters:  
 {    {  hdptr: A pointer to the first PCB in the list to be searched.   {   {  key: The key value that must be matched in the record.   {   {  offset: The word offset into the record where the key value  {     will be found if its present.   {   
{ Output Parameters: 
 {   {  pcbrecid: If found, the descriptor for the matching PCB.   {   {  pcbrec: The found PCB record.  {   #{  ierr: Returns SUCCESSFUL if the PCB was found and MEANINGLESS (=-1) # {     if not.   {}      BEGIN   
ierr := MEANINGLESS; 
 IF (hdptr <> NULL) THEN      BEGIN     DS_FetchElement (DS_ProbePCBTD, hdptr, pcbrec.int);     IF (pcbrec.ints[offset] = key) THEN        BEGIN         { The first record in the list held the key value.        {}        pcbrecid := hdptr;  
      ierr := SUCCESSFUL;  
       END      ELSE         BEGIN         pcbrecid := pcbrec.pcb_nxtptr;        WHILE ((ierr <> SUCCESSFUL) AND (pcbrecid <> NULL)) DO           BEGIN            DS_FetchElement (DS_ProbePCBTD, pcbrecid, pcbrec.int);             IF (pcbrec.ints[offset] = key) THEN  	            BEGIN  	             ierr := SUCCESSFUL;               END            ELSE   	            BEGIN  	             pcbrecid := pcbrec.pcb_nxtptr;              END; {IF pcbrec}           END; {WHILE}         END; {IF pcbrec}  	   END; {IF hdptr} 	 END; {PrbSearchPCBList}       $PAGE   !{----------------------------------------------------------------} ! !{   PRB SET UP NAME MSG                                   (2100) } ! !{----------------------------------------------------------------} !     
PROCEDURE PrbSetUpNameMsg  
    { VAR reqpcb   : PCBRecord;       VAR sendemsg : EventMsgType;        VAR ierr     : Int16 };      {}  { Abstract:   !{  This routine may be used to prepare Name Request and Proxy-Name !  {  Request messages. It attempts to put them into DSAM, charging   #{  them against Probe's special socket. After the message is put into  # {  DSAM, a SEND_REQUEST emsg is prepared that can be used to  !{  send the Probe request message out of the machine. This routine ! {  does not panic if any problems are encountered.  {   
{ Input parameters:  
 {   !{  reqpcb: The PCBRecord for the transaction that we're attempting ! {     to retry.   {   
{ Output parameters: 
 {   !{  reqpcb.pcb_b.downcnt: If the call is successful then this field !  {     is incremented by one to count the SEND_REQUEST generated.   {     Note, however, that this count is really valid until the  {     emsg is actually sent.  {   {  ierr: If any problems were encountered interacting with the   {     memory manager then the MMGR error will be returned here.     {     The caller should treat any such errors as internal errors   {     as far as Probe is concerned.   {}      LABEL 99;       VAR      lookuprec      : LookUpRecord;      mmflags        : MMFlagsType;  
   probegsd       : Int16; 
     BEGIN   WITH reqpcb, sendemsg, lookuprec, scratchmsg DO      BEGIN     { First we read in the preamble part of the LookUpRecord.     { This will enable us to figure out the length of the node      { name we'll be Probing for and where it is in the request      { mbuf.     {}   
   mmflags.int := 0; 
    mmflags.bits[0] := TRUE; {preview read}  &   DS_MRead (lookuprec.int, LOOKUPREC_SIZE, pcb_f.mbufid, 0, mmflags, ierr); &    IF (ierr <> SUCCESSFUL) THEN GOTO 99;         DS_MRead (pmr_name.int, lu_env_nlen, pcb_f.mbufid,                LOOKUPREC_SIZE + lu_socket_nlen, mmflags, ierr);      IF (ierr <> SUCCESSFUL) THEN GOTO 99;         { We've got the node name so now we fill in the rest of the     { request message.      {}      pmr_b.version := 0;     IF Odd (pcb_b.downcnt) THEN        pmr_b.msgtype := PB_NAME_REQUEST     ELSE         pmr_b.msgtype := PB_PROXY_NAME_REQUEST;      pmr_msglen := PROBE_PREAMBLE_LEN + 2 + lu_env_nlen;     pmr_seqnum := pcb_seqnum;     pmr_nameb.ntype := 1;     pmr_nameb.len := lu_env_nlen;     IF Odd(lu_env_nlen) THEN         BEGIN   !      { We have to add the special null pad byte to the end of the ! !      { name. Also we need to increment the message's length field !       { so we don't forget to transmit the pad byte.        {}        pmr_name.bytes[lu_env_nlen + 1] := 0; {pad byte}        pmr_msglen := pmr_msglen + 1;   
      END; {IF Odd}  
         { Our message  is now prpared and we're ready to try putting    !   { it into DSAM. There should never be any problems doing this.  !     { We charge the space for the message against Probe's special   !   { socket. We pull the gsd for this socket from Probe's global's !    { record.     {}   "   DS_FetchFields (DS_ProbeGTD, 1, probegsd, PG_PROBEGSD_OFFSET, 1); " "   PrbChargeMsg (probegsd, scratchmsg, sendemsg.emsr_mbufid, ierr);  "    IF (ierr <> SUCCESSFUL) THEN GOTO 99;      #   { Our message is in DSAM. All we need to do now is finish preparing # 
   { a SEND_REQUEST emsg.  
    {}      em_event := SEND_REQUEST;     ehport := pcb_down_pid * EHS_PER + EHOB_OFFSET;      #   { tell LAN to send it down to either the target (primary) multicast # #     address, or the proxy (secondary) multicast address, depending on #      whether it is a target or proxy request }     IF Odd (pcb_b.downcnt) THEN        pcb_down_ref := LAN_PROBE_TARGET     ELSE         pcb_down_ref := LAN_PROBE_PROXY;     emsr_down_ref := pcb_down_ref;          emsr_dlen := pmr_msglen;      emsr_flags.int := 0;      emsr_flags.bits[0] := TRUE; {group ref}  
   emsr_killsnd_cnt := 0;  
 
   emsr_killrcv_cnt := 0;  
    pcb_b.downcnt := pcb_b.downcnt + 1;     END; {WITH}      
ierr := SUCCESSFUL;  
 99:;  END; {PrbSetUpNameMsg}      $PAGE   !{----------------------------------------------------------------} ! !{   PRB SET UP VA MSG                                     (2200) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbSetUpVAMsg   
   {     acctgsd  : Int16; 
      VAR pcbrec   : PCBRecord;       VAR emsg     : EventMsgType;        VAR ierr     : Int16 };      {}  { Abstract:   !{  This routine uses the information in a PCB record to construct  ! {  a Probe header for a Virtual Address request message. After  {  construction the header is put into DSAM. A SEND_REQUEST    {  event message is then prepared. The event message can be used   {  if Probe later decides to transmit the request.  {   
{ Input Parameters:  
 {   {  acctgsd: The descriptor for the socket whose outbound sbuf   {     the Probe message should be charged against.  {    {  pcbrec: The initialized Probe Control Block that will be used   {     to track the Virtual Address transaction. This record   {     contains the information needed to generate the message.  {   
{ Output Parameters: 
 {   !{  emsg: A SEND_REQUEST emsg that may be passed to ProSw() should  ! {     Probe decide to try sending the Virtual Address request.  "{     This emsg is only valid if ierr returns a value of SUCCESSFUL. " {   "{  ierr: The error return code. Callers may assume the call resulted " {     in a "panic" if a result of SUCCESSFUL is not returned.   {}      LABEL 99;       VAR   
   probegsd : Int16; 
     BEGIN   WITH pcbrec, emsg, scratchmsg DO     BEGIN     { First we initialize the message that we'd like to send.     {}      pmr_b.version := 0;     pmr_b.msgtype := PB_VNA_REQUEST;      pmr_msglen := PROBE_VAREQ_LEN;      pmr_seqnum := pcb_seqnum; {allocated by PrbGetPCB}      pmr_reportlen := 8;     pmr_domainlen := 6;     pmr_vna := pcb_f.vna;          { Next we try to put the message into DSAM. We always expect       { this attempt to succeed. If it doesn't then we panic.     {}   "   DS_FetchFields (DS_ProbeGTD, 1, probegsd, PG_PROBEGSD_OFFSET, 1); "    PrbChargeMsg (acctgsd, scratchmsg, emsr_mbufid, ierr);      IF (ierr <> SUCCESSFUL) THEN         BEGIN   "      { We were unable to put our message into DSAM. PrbChargeMsg()  "       { should have called PrbPanic().        {}        GOTO 99;  
      END; {IF ierr} 
         { Now we prepare our SEND_REQUEST esmg. Its emsr_mbufid field      { has already been initialized by the PrbChargeMsg() call     { above.      {}      em_event := SEND_REQUEST;     ehport := pcb_down_pid * EHS_PER + EHOB_OFFSET;     emsr_down_ref := pcb_down_ref;      emsr_dlen := pmr_msglen;      emsr_flags.int := 0;      emsr_opt_mbufid := 0;  
   emsr_killsnd_cnt := 0;  
 
   END; {WITH pcbrec ... } 
     99:;  
END; {PrbSetUpVAMsg} 
     $PAGE   !{----------------------------------------------------------------} ! !{   PRB START VA TIMER                                    (2300) } ! !{----------------------------------------------------------------} !     
PROCEDURE PrbStartVATimer  
    { VAR globalrec   : ProbeGRecord;       VAR ierr        : Int16 };       {}  { Abstract:   {  This routine may be called to start the timer for pending  {  virtual address requests. If/when this timer expires it  {  will result in a TIMERABLE_2 timer notification emsg being   {  sent down through Probe's special socket.  {   
{ Input parameters:  
 {   {  globalrec: This should be a copy of the current ProbeGRec.   {     It should have been fetched prior to the call.  {   
{ Output parameters: 
 {   {  globalrec.pg_vnatimerid: If the call is successful then  {     this field is modified in the Probe globals record.   {     Callers should store the ProbeGRecord back out to   {     DSAM before leaving critical.   {   {  ierr: Returns the error from the ActivateTimer() call. This  {     error will NOT be an IPC error. This call does not panic  {     if a timer wasn't set.  {}      BEGIN   	WITH globalrec DO  	    BEGIN     timermsg.socket := pg_probegsd;     timermsg.direction := OUTBOUND_SIG;     timermsg.signal := TIMERABLE_2;  "   rqsttime := pg_retryinterval * 2; {usually about 2 seconds worth} "    ActivateTimer (rqsttime, timermsg, pg_vnatimerid, ierr);      END; {WITH globlrec}   END; {PrbStartVATimer}      !{----------------------------------------------------------------} ! !{   PRB UNLINK PCB                                        (2400) } ! !{----------------------------------------------------------------} !     PROCEDURE PrbUnlinkPCB     { VAR headptr     : Int16;            pcbrecid    : Int16;        VAR pcbrec      : PCBRecord };       {}  { Abstract:   {  This routine may be used to unlink a PCB record from a list  {  of such records. The record to be unlinked must be know to   	{  be in the list. 	 {   
{ Input parameters:  
 {   {  headptr: A pointer to the first element in the linked list.  {   "{  pcbrecid: The identifier for the PCBRecord that should be removed " {     from the linked list.   {   {  pcbrec: The PCBRecord to be removed.   {   
{ Output parameters: 
 {   #{  headptr: This value may be changed if the PCBRecord being unlinked  # #{     was the first record in the list. Often the list's head pointer  # #{     will be a field in the ProbeGRecord and so the caller should be  # #{     careful to store the ProbeGRecord back to DSAM if PrbUnlinkPCB() # {     is called.  {}      VAR      nextptr     : Int16;      temppcbid   : Int16;       BEGIN   IF (headptr = pcbrecid) THEN     BEGIN     headptr := pcbrec.pcb_nxtptr;     END  ELSE     BEGIN     temppcbid := NULL;      nextptr := headptr;     WHILE (nextptr <> pcbrecid) DO         BEGIN         temppcbid := nextptr;         DS_FetchFields (DS_ProbePCBTD, temppcbid, nextptr,                         PCB_NXTPTR_OFFSET, 1);   
      END; {WHILE nextptr} 
     DS_StoreFields (DS_ProbePCBTD, temppcbid, pcbrec.pcb_nxtptr,                        PCB_NXTPTR_OFFSET, 1);  
   END; {IF headptr} 
 
END; {PrbUnlinkPCB}  
 $PAGE   !{----------------------------------------------------------------} ! !{   PROBE INBOUND                                         (2500) } ! !{----------------------------------------------------------------} !     PROCEDURE ProbeInbound     { VAR emsg     : EventMsgType;        VAR ierr     : Int16 };      {}  { Abstract:   {  This routine is Probe's inbound protocol handler. It is the  {  first Probe routine to see emsgs addressed to Probe. The    {  routine does some initial screening of event messages to make   {  sure Probe is equipped to handle them. Then, if the emsg   {  is a DATA_INDICATION, ProbeInbound() reads in the preamble   {  of the accompanying Probe message. Depending on the type   {  of message received an appropriate routine will be invoked   {  to handle it.  {}      LABEL 99;       VAR   
   mmflags  : MMFlagsType; 
 
   wkmp     : Int16; 
     !   {-------------------------------------------------------------} ! !   {   DO KILL PATH / PROBE INBOUND                              } ! !   {-------------------------------------------------------------} !        PROCEDURE DoKillPath;         {}      { Abstract:     {  Used like a macro to kill the path traced by an inbound      {  DATA_INDICATION.     {}      BEGIN     DS_LeaveCritical (wkmp);      WITH scratchemsg DO        BEGIN         em_event := KILL_REQUEST;         ehport := emsg.emdi_down_pid * EHS_PER + EHOB_OFFSET;         emkr_down_ref := emsg.emdi_down_ref;        emkr_msg_snd_cnt := 1;        emkr_msg_rcv_cnt := 1;  	      END; {WITH}  	    ProSw (scratchemsg, ierr);   
   END; {DoKillPath} 
     !   {------------------------------------------------------------}  ! !   {   DO LOG ERROR / PROBE INBOUND                             }  ! !   {------------------------------------------------------------}  !        PROCEDURE DoLogError   
      ( location  : Int16; 
         error     : Int16 );         BEGIN     context.longint := 0;  "   Log_Event (EL_ERROR, PROBE, location, context, 2, error, logerr); " 
   END; {DoLogError} 
     !{---------------------------------------------------------------}  ! !{   BEGIN / PROBE INBOUND                                       }  ! !{---------------------------------------------------------------}  !     BEGIN   DS_EnterCritical ( wkmp, ierr);   context.longint := 0;   Log_Event (EL_EVENT, PROBE, LOC_2504_INBOUND, context,              EMSG_BYTE_LEN, emsg.int, logerr);       WITH emsg DO     BEGIN     { First we make sure we've received a DATA_INDICATION.   "   { ProbeInbound() doesn't know how to deal with any other kind of  "    { emsg (KILL_INDICATIONs are ignored).      {}      IF (em_event = KILL_INDICATION) THEN         BEGIN         DS_LeaveCritical (wkmp);        GOTO 99;        END      ELSE IF (em_event <> DATA_INDICATION) THEN         BEGIN         DoLogError (LOC_2500_BAD_INBOUND_EMSG, em_event);         DS_LeaveCritical (wkmp);        GOTO 99;        END; {IF em_event}      "   { Prepare to read in the preamble of the Probe message referenced "    { by the DATA_INDICATION.     {}      IF (emdi_dlen < PROBE_PREAMBLE_LEN) THEN         BEGIN         DS_MDispose ( emdi_mbufid, ierr);         DoLogError (LOC_2501_BAD_MSG_LEN, emdi_dlen);   	      DoKillPath;  	       GOTO 99;  
      END; {IF emdi_dlen}  
        mmflags.int := 0; {no previewing}      DS_MRead (scratchmsg.int, PROBE_PREAMBLE_LEN, emdi_mbufid, 0,                mmflags, ierr);     IF (ierr <> SUCCESSFUL) THEN         BEGIN         DS_MDispose (emdi_mbufid, ierr);        DoLogError (LOC_2502_MBUF_TOO_LEAN, ierr);  	      DoKillPath;  	 
      ierr := SUCCESSFUL;  
       GOTO 99;  
      END; {IF ierr} 
     !   { We adjust the length recorded in our DATA_INDICATION emsg to  !    { reflect that we've just done a destructive read.      {}      emdi_dlen := emdi_dlen - PROBE_PREAMBLE_LEN;   
   END; {WITH emsg}  
     WITH scratchmsg, emsg DO     BEGIN     IF (pmr_b.version <> 0) THEN         BEGIN   "      { We can't handle the version of Probe message just received.  " "      { To recover we dispose the mbuf that brought the request and  "       { we kill the path that the message traced up to Probe.         {}        DS_MDispose (emdi_mbufid, ierr);  	      DoKillPath;  	 
      ierr := SUCCESSFUL;  
       GOTO 99;        END; {IF pmb_b.version}          CASE pmr_b.msgtype OF            PB_VNA_REQUEST:            BEGIN           { We call the routine that handles Virtual Address            { requests. We expect this routine to dispose of            { the mbuf containing the request message.            {}            PrbIbVARequest (emsg, scratchmsg, wkmp, ierr);            END; {PB_VA_REQUEST}       
      PB_NAME_REPLY, 
 
      PB_PROXY_NAME_REPLY: 
          BEGIN           PrbIbNmReply (pmr_seqnum, emsg, wkmp);            END; {PB_NAME_REPLY case}      
      PB_VNA_REPLY:  
          BEGIN           { We have a Virtual Address Reply message. We don't           { need the mbuf that brought it this far.           {}            DS_MDispose (emdi_mbufid, ierr);   $         PrbIbVAReply (emdi_down_pid, emdi_down_ref, pmr_seqnum, wkmp);  $          END; {PB_VNA_REPLY}            PB_NAME_REQUEST:           BEGIN           PrbIbNmRequest (emsg, scratchmsg, wkmp, ierr);            END; {PB_NAME_REQUEST}       #{ *******************************************************************  # "  The gateway server code is unsupported and will thus be commented  "   out for first release   #  *******************************************************************  #     
      PB_GATEWAY_REQUEST:  
          BEGIN           PrbIbGatewayRequest (emsg, scratchmsg, wkmp, ierr);           END; ************ }  {PrbIbGatewayRequest case}      ${ ******************************************************************* }  $           PB_UNSOLICITED_REPLY:            BEGIN           PrbIbUnsolicited (emsg, scratchmsg, wkmp, ierr);            END; {PB_UNSOLICITED_REPLY}            PB_PROXY_NAME_REQUEST:           BEGIN           { Before handling this one we must make sure we're             { a Proxy-Name server. If not we'll want to dispose the   !         { mbuf that the request arrived in and also kill the down !          { path.           {}            DS_FetchElement (DS_ProbeGTD, 1, probegrec.int);            IF probegrec.pg_qbits.bits[0] THEN   	            BEGIN  	             { We're a Proxy-Name server all right.              {}              PrbIbNmRequest (emsg, scratchmsg, wkmp, ierr);              END            ELSE   	            BEGIN  	             { We can't help this requestor.               {}              DS_MDispose (emdi_mbufid, ierr);              DoKillPath;               ierr := SUCCESSFUL;               END;           END; {PB_PROXY_NAME_REQUEST case}            OTHERWISE            BEGIN           DS_MDispose (emdi_mbufid, ierr);            DoLogError (LOC_2503_BAD_IBMSG, pmr_b.msgtype);  
         DoKillPath; 
          ierr := SUCCESSFUL;  
         END; {OTHERWISE}  
           END; {CASE pmr_b.msgtype}          END; {WITH}  99:;  
END; {ProbeInbound}  
     $PAGE   !{----------------------------------------------------------------} ! !{   PROBE OUTBOUND                                        (2600) } ! !{----------------------------------------------------------------} !     PROCEDURE ProbeOutbound      { VAR emsg  : EventMsgType;  
     VAR ierr  : Int16  }; 
     {}  { Abstract:    {  This routine represents one of the two main protocol handler    !{  entry points for Probe. All outbound emsgs sent to Probe should !  {  be sent to ProbeOutbound(). This routine should be registered   {  in ProSw()'s switch table.   {}      VAR   	   wkmp  : Int16;  	     !   {-------------------------------------------------------------} ! !   {   DO LOG ERROR / PROBE OUTBOUND                             } ! !   {-------------------------------------------------------------} !        PROCEDURE DoLogError         ( location     : Int16;           error        : Int16 );          BEGIN     context.longint := 0;  "   Log_Event (EL_ERROR, PROBE, location, context, 2, error, logerr); " 
   END; {DoLogError} 
     BEGIN   DS_EnterCritical ( wkmp, ierr);   context.longint := 0;   Log_Event (EL_EVENT, PROBE, LOC_2600_OUTBOUND, context,               EMSG_BYTE_LEN, emsg.int, logerr);       WITH emsg DO     BEGIN     CASE emsg.em_event OF      
      REQUEST_DPATH: 
          BEGIN           PrbObVARequest ( emsg, wkmp, ierr);           END; {REQUEST_DPATH case}            TIMER_RESPONSE:            BEGIN           IF (emtr_data[0] = TIMERABLE_1) THEN   	            BEGIN  	              { We've received a time out notification for one of                 { our name-request transactions. The sequence number                { for this transaction should have been saved in the                { down path reference field of the root socket that                { the notification was delivered down through.              {}              PrbObNameTimeOut (emtr_down_ref, wkmp, ierr);               END            ELSE IF (emtr_data[0] = TIMERABLE_2) THEN  	            BEGIN  	             PrbObVATimeOut (wkmp, ierr);              END            ELSE IF (emtr_data[0] = TIMERABLE_3) THEN  	            BEGIN  	 "            { For now the only TIMERABLE_3 notifications that we'll  " !            { receive will be to stimulate us to send unsolicited  !             { replies.              {}              PrbObUnsolicited(wkmp, ierr);               END            ELSE   	            BEGIN  	 !            DoLogError (LOC_2601_BAD_TIMER_SIGNAL, emtr_data[0]);  !             DS_LeaveCritical (wkmp);              END; {IF emtr_data[0]}           END; {TIMER_RESPONSE case}       
      QUERY_REQUEST: 
          BEGIN           PrbObNameRequest ( emsg, wkmp, ierr );            END; {QUERY_REQUEST case}            OTHERWISE            BEGIN           DoLogError (LOC_2602_UNKNOWN_EVENT, emsg.em_event );            DS_LeaveCritical (wkmp);   
         END; {OTHERWISE}  
     	      END; {CASE}  	 
   END; {WITH emsg}  
 
END; {ProbeOutbound} 
     
END. {OF PRBLB IMPLEMENT}  
