 $PASCAL '91790-1X117 REV.4010 <860131.1225>'  
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG$   $HEAP 0$  $RANGE OFF$   $RECURSIVE OFF$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $TITLE 'Module Description', PAGE$      MODULE mminf;       {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  	{      NAME: mminf 	 {    SOURCE: 91790-18117  	{     RELOC: NONE  	 {      PGMR: jar  {}      {}  { PROGRAM DESCRIPTION:  {   {  Formats information about the memory manager   {}  IMPORT                       $SEARCH 'phtm/BODEC.REL'       bodec,   {  General-purpose declarations                    }                        $SEARCH 'phtm/MMDEC.REL'       mmdec,   {  Memory-Manager declarations                     }                        $SEARCH 'phtm/MMEXT.REL'       ds_mm,   {  The Memory Manager                              }                        $SEARCH 'phtm/INFLB.REL'       inflb;   {  Info Utility Library                            }       EXPORT          FUNCTION MMinf     (VAR info : InfoRecordType)     : Int16;       $SUBTITLE 'Implementation', PAGE  IMPLEMENT       VAR   '   {  These variables are placed here to make them syntactically            }  ' &   {  "own".  In segmented programs (including CDS), mminf.1 must be       } & '   {  memory resident.  For CDS programs, this means either that AL segments}  ' '   {  must be memory-resident, or that you ensure that the segment that     }  ' '   {  contains mminf.1 is.  For SEGLD programs, mminf.1 must reside in      }  ' '   {  the main.                                                             }  '     
   ms    :  MemStatusType; 
 
   bs    :  BufStatusType; 
     CONST      LF_JUST = -1;      { left justify }     SR_JUST = 0;       { single word integer, right justify }     DR_JUST = 1;       { double word integer, right justify }      FUNCTION MAX  $ALIAS 'MAX0'      (  a, b  :  Int16 )     :  Int16;     EXTERNAL;      $SUBTITLE 'BufMgrInfo', PAGE     FUNCTION BufMgrInfo        (        valid    :  BOOLEAN;                  reset    :  BOOLEAN;            VAR   next     :  Int16;            VAR   line     :  Charray78 )        :  Int16;              VAR        next_pos :  Int16;        error :  Int16;          BEGIN {  BufrMgrInfo    }         CASE next OF             0: {  Initial request   }             BEGIN {  Get the data, return first line              }            DS_BufMgrInfo ( valid, reset, bs, error );                IF ( error = MMDSAMCORRUPT ) THEN              BEGIN {  Report that }              line  := 'DSAM Corrupt!';               next := 0;              END   {  Report that }           ELSE IF ( error <> 0 ) THEN              BEGIN {  Report unknown error }               line  := 'Unknown Buffer Allocation error:  .';               InsrtDec (line, error, 31, next_pos, LF_JUST);              next := 0;  
            PrInfo (line); 
             END   {  Report unknown error }            ELSE               BEGIN {  AOK - print first line: }              IF ( valid ) THEN                   BEGIN {  we forced validation of the stats      }   !               line  := 'Validated Buffer Allocation Statistics:'; !                 END   {  we forced validation of the stats      }               ELSE                  BEGIN {  we didn't                              }                   line  := 'Current Buffer Allocation Statistics:';                   END;  {  we didn't                              }               next := 1;              END   {  AOK - print first line }                 END;  {  Get the data, return first line              }             1:           BEGIN  
         next := next + 1; 
          END;             2:           BEGIN  {   DSAM Allocation:  }            line := 'DSAM Allocation:';  
         next := next + 1; 
          END;             3:           BEGIN  {   #                           In DSAM           In Tables            With # }            line := '                           In DSAM';           temp_buf := '           In Tables';           InsrtChr (line, temp_buf, 20, 35, next_pos );           temp_buf := '            With';           InsrtChr (line, temp_buf, 16, next_pos, next_pos );  
         next := next + 1; 
          END;             4:           BEGIN  {   '                           (Total)          And Globals          Parity Errors ' }            line := '                           (Total)';           temp_buf := '          And Globals';            InsrtChr (line, temp_buf, 21, 35, next_pos );           temp_buf := '       Parity Errors';           InsrtChr (line, temp_buf, 20, next_pos, next_pos );  
         next := next + 1; 
          END;             5:           BEGIN  {   'Bytes:                  ____299606           _____46070             _________0 ' }   
         line := 'Bytes:'; 
          InsrtDec (line, bs.dsamtotal, 24, next_pos, DR_JUST);            InsrtDec (line, bs.statictotal, 45, next_pos, DR_JUST);             InsrtDec (line, bs.paritytotal, 65, next_pos, DR_JUST);   
         next := next + 1; 
          END;             6:           BEGIN  
         next := next + 1; 
          END;             7:           BEGIN  {   	Buffer Allocation: 	 }            line := 'Buffer Allocation:';  
         next := next + 1; 
          END;             8:           BEGIN  
         next := next + 1; 
          END;             9:           BEGIN           temp_buf := 'None';           InsrtChr(line, temp_buf, 4, 72, next_pos );  
         next := next + 1; 
          END;             10:            BEGIN  {   &         Defined    Useable    Free     Requests        Scans     Available  & }            line := '         Defined';           temp_buf := 'Useable';            InsrtChr (line, temp_buf, 7, 21, next_pos);           temp_buf := 'Free';           InsrtChr (line, temp_buf, 4, 32, next_pos);           temp_buf := 'Requests';           InsrtChr (line, temp_buf, 8, 41, next_pos);           temp_buf := 'Scans';            InsrtChr (line, temp_buf, 5, 57, next_pos);           temp_buf := 'Available';            InsrtChr (line, temp_buf, 9, 67, next_pos);  
         next := next + 1; 
          END;             11:            BEGIN  {   &Mbufs      _1504      _1504   _1497   _________9   _________0    _________0  & }   
         line := 'Mbufs';  
          InsrtDec (line, bs.maxmbid,   11, next_pos, SR_JUST);           InsrtDec (line, bs.mbtotal,   22, next_pos, SR_JUST);           InsrtDec (line, bs.mbfree,    30, next_pos, SR_JUST);           InsrtDec (line, bs.mbrqsts,   38, next_pos, DR_JUST);           InsrtDec (line, bs.mbscans,   51, next_pos, DR_JUST);           InsrtDec (line, bs.mbunavail, 65, next_pos, DR_JUST);  
         next := next + 1; 
          END;             12:            BEGIN  {   'Clusters   __188      __188   __187    _________0    _________0     _________0 ' }            line := 'Clusters';           InsrtDec (line, bs.maxclid,   11, next_pos, SR_JUST);           InsrtDec (line, bs.cltotal,   22, next_pos, SR_JUST);           InsrtDec (line, bs.clfree,    30, next_pos, SR_JUST);           InsrtDec (line, bs.clrqsts,   38, next_pos, DR_JUST);           InsrtDec (line, bs.clscans,   51, next_pos, DR_JUST);           InsrtDec (line, bs.clunavail, 65, next_pos, DR_JUST);  
         next := next + 1; 
          END;             13:            BEGIN  
         next := next + 1; 
          END;             14:            BEGIN  {                       ____0 invalid release requests.   }             InsrtDec (line, bs.invalrqsts, 16, next_pos, SR_JUST);              temp_buf := ' invalid Mbuf/Cluster release requests.';             InsrtChr (line, temp_buf, 39, next_pos, next_pos);   
         IF ( reset ) THEN 
 	            BEGIN  	             next := next + 1;               END            ELSE   	            BEGIN  	             next := next + 3;               END;           END;             15:            BEGIN  
         next := next + 1; 
          END;             16:            BEGIN  
         IF ( reset ) THEN 
 	            BEGIN  	             line := '(Statistics have been reset.)';              END;  
         next := next + 1; 
          END;             OTHERWISE            next := 0;    { line = ' ' }         END;  {  Case  }         BufMgrInfo  := next;          END;  {  BufrMgrInfo    }          $SUBTITLE 'MemMgrInfo', PAGE         FUNCTION MemMgrInfo        (        valid    :  BOOLEAN;                  reset    :  BOOLEAN;            VAR   next     :  Int16;            VAR   line     :  Charray78 )        :  Int16;          VAR        error  :  Int16;  
      next_pos  :  Int16;  
        BEGIN {  MemMgrInfo    }      CASE next OF             0: {  Initial request   }             BEGIN {  Get the data, return first line              }            DS_MemMgrInfo ( valid, reset, ms, error );                IF ( error = MMDSAMCORRUPT ) THEN              BEGIN {  Report that }              line  := 'DSAM Corrupt!';               next := 0;              END   {  Report that }           ELSE IF ( error <> 0 ) THEN              BEGIN {  Report unknown error }               line  := 'Unknown Buffer Accounting error:  .';               InsrtDec (line, error, 31, next_pos, LF_JUST);              next := 0;              END   {  Report unknown error }            ELSE               BEGIN {  AOK - print first line: }              IF ( valid ) THEN                   BEGIN {  we forced validation of the stats      }   !               line  := 'Validated Buffer Accounting Statistics:'; !                 END   {  we forced validation of the stats      }               ELSE                  BEGIN {  we didn't                              }                   line  := 'Current Buffer Accounting Statistics:';                   END;  {  we didn't                              }               next := 1;              END   {  AOK - print first line }                 END;  {  Get the data, return first line              }             1:           BEGIN  
         next := next + 1; 
          END;             2:           BEGIN  {   &                               Mbufs reserved     Mbufs free   Mbufs in use  & }   !         line := '                               Mbufs reserved';  !          temp_buf := 'Mbufs free';           InsrtChr (line, temp_buf, 10, 51, next_pos);            temp_buf := 'Mbufs in use';           InsrtChr (line, temp_buf, 12, 64, next_pos);   
         next := next + 1; 
          END;             3:           BEGIN  {   &General Pool                             1504            671            833  & }            line := 'General Pool';           InsrtDec (line, ms.mingenl, 40, next_pos, SR_JUST);           InsrtDec (line, ms.freegenl, 55, next_pos, SR_JUST);             InsrtDec (line, ms.actualgenl, 70, next_pos, SR_JUST);    
         next := next + 1; 
          END;             4:           BEGIN  {   &Connectionless pool                        10              0            803  & }            line := 'Connectionless pool';             InsrtDec (line, ms.minconnless, 40, next_pos, SR_JUST);   !         InsrtDec (line, ms.freeconnless, 55, next_pos, SR_JUST);  ! "         InsrtDec (line, ms.actualconnless, 70, next_pos, SR_JUST);  " 
         next := next + 1; 
          END;             5:           BEGIN  {   &Connection pool                            15             15              0  & }            line := 'Connection pool';            InsrtDec (line, ms.minconn, 40, next_pos, SR_JUST);           InsrtDec (line, ms.freeconn, 55, next_pos, SR_JUST);             InsrtDec (line, ms.actualconn, 70, next_pos, SR_JUST);    
         next := next + 1; 
          END;             6:           BEGIN  
         next := next + 1; 
          END;             7:           BEGIN  {   &General Inbound                           249            249              0  & }            line := 'General Inbound';            InsrtDec (line, ms.mingenlin, 40, next_pos, SR_JUST);            InsrtDec (line, ms.freegenlin, 55, next_pos, SR_JUST);    !         InsrtDec (line, ms.actualgenlin, 70, next_pos, SR_JUST);  ! 
         next := next + 1; 
          END;             8:           BEGIN  
         next := next + 1; 
          END;             9:           BEGIN  {   &Store and Forward                           5              5              0  & }            line := 'Store and Forward';            InsrtDec (line, ms.minsandf, 40, next_pos, SR_JUST);            InsrtDec (line, ms.freesandf, 55, next_pos, SR_JUST);            InsrtDec (line, ms.actualsandf, 70, next_pos, SR_JUST);   
         next := next + 1; 
          END;             10:            BEGIN  {   &Connection Inbound                          0              0              0  & }            line := 'Connection Inbound';           InsrtDec (line, ms.minconnin, 40, next_pos, SR_JUST);            InsrtDec (line, ms.freeconnin, 55, next_pos, SR_JUST);    !         InsrtDec (line, ms.actualconnin, 70, next_pos, SR_JUST);  ! 
         next := next + 1; 
          END;             11:            BEGIN  {   &Connectionless Inbound                    244            244              0  & }            line := 'Connectionless Inbound';  !         InsrtDec (line, ms.minconnlessin, 40, next_pos, SR_JUST); ! "         InsrtDec (line, ms.freeconnlessin, 55, next_pos, SR_JUST);  " #         InsrtDec (line, ms.actualconnlessin, 70, next_pos, SR_JUST);  # 
         next := next + 1; 
          END;             12:            BEGIN  
         next := next + 1; 
          END;             13:            BEGIN  {   &                                                     Requests       Callers  & }            line :=  ''                                                     Requests       Callers'; ' 
         next := next + 1; 
          END;             14:            BEGIN  {   &         Defined    Useable    Free     Requests       Denied        Waited  & }            line :=  ''         Defined    Useable    Free     Requests       Denied        Waited'; ' 
         next := next + 1; 
          END;             15:            BEGIN  {   &Maccts     __501      __501   __501        ____3        ____0         ____0  & }   
         line := 'Maccts'; 
           InsrtDec (line, ms.maxmaid,    11, next_pos, SR_JUST);              InsrtDec (line, ms.matotal,    22, next_pos, SR_JUST);              InsrtDec (line, ms.mafree,     30, next_pos, SR_JUST);              InsrtDec (line, ms.marqsts,    38, next_pos, DR_JUST);              InsrtDec (line, ms.maunavail,  51, next_pos, DR_JUST);              InsrtDec (line, ms.mwaitrqsts, 65, next_pos, DR_JUST);    
         next := next + 1; 
          END;             16:            BEGIN  
         next := next + 1; 
          END;             17:            BEGIN  !         InsrtDec (line, ms.mainvalrqsts, 16, next_pos, SR_JUST);  !          temp_buf := ' invalid Macct release requests.';           InsrtChr (line, temp_buf, 32, next_pos, next_pos );  
         IF ( reset ) THEN 
 	            BEGIN  	             next := next + 1;               END            ELSE   	            BEGIN  	             next := next + 3;               END;           END;             18:            BEGIN  
         next := next + 1; 
          END;             19:            BEGIN  
         IF ( reset ) THEN 
 	            BEGIN  	             line := '(Statistics have been reset.)';              END;  
         next := next + 1; 
          END;             OTHERWISE            BEGIN {  End of listing }           next := 0;          { line = ' ' }            END;  {  End of listing }            END;  {  Case  }         MemMgrInfo  := next;      END;  {  MemMgrInfo    }       $SUBTITLE 'MemErrorInfo', PAGE         FUNCTION MemErrorInfo        (        valid    :  BOOLEAN;                  reset    :  BOOLEAN;            VAR   next     :  Int16;            VAR   line     :  Charray78 )        :  Int16;          VAR        error  :  Int16;  
      next_pos  :  Int16;  
        BEGIN {  MemErrorInfo    }      CASE next OF             0: {  Initial request   }             BEGIN {  Get the data, return first line              }            DS_MemMgrInfo ( valid, reset, ms, error );                IF ( error = MMDSAMCORRUPT ) THEN              BEGIN {  Report that }              line  := 'DSAM Corrupt!';               next := 0;              END   {  Report that }           ELSE IF ( error <> 0 ) THEN              BEGIN {  Report unknown error }               line  := 'Unknown Buffer Accounting error:  .';               InsrtDec (line, error, 31, next_pos, LF_JUST);              next := 0;              END   {  Report unknown error }            ELSE               BEGIN {  AOK - print first line: }              IF ( valid ) THEN                   BEGIN {  we forced validation of the stats      }   $               line  := 'Validated Buffer Accounting Error Statistics:'; $                 END   {  we forced validation of the stats      }               ELSE                  BEGIN {  we didn't                              }   #               line  := 'Current Buffer Accounting Error Statistics:'; #                 END;  {  we didn't                              }               next := 1;              END   {  AOK - print first line }                 END;  {  Get the data, return first line              }             1:           BEGIN  
         next := next + 1; 
          END;             2:           BEGIN  
         next := next + 1; 
          END;             3:           BEGIN  {   &     _____0 Mbufs available for borrowing _____0 Mbufs ever available (min)  & }            InsrtDec (line, MAX(0,(ms.freegenl-MMACKTHRESH)),              6, next_pos, SR_JUST);           temp_buf := ' Mbufs available for borrowing';           InsrtChr (line, temp_buf, 30, next_pos, next_pos);            InsrtDec (line, MAX(0,(ms.mingenlpool-MMACKTHRESH)),               44, next_pos, SR_JUST);            temp_buf := ' Mbufs ever available (min)';            InsrtChr (line, temp_buf, 27, next_pos, next_pos);   
         next := next + 1; 
          END;             4:           BEGIN  {   %     _____0 Mbufs currently borrowed      _____0 Mbufs ever borrowed (max) % }            line := ' ';   !         InsrtDec (line, ms.mbchargedgenl, 6, next_pos, SR_JUST);  !          temp_buf := ' Mbufs currently borrowed';            InsrtChr (line, temp_buf, 25, next_pos, next_pos);             InsrtDec (line, ms.maxmbonloan, 44, next_pos, SR_JUST);            temp_buf := ' Mbufs ever borrowed (max)';           InsrtChr (line, temp_buf, 26, next_pos, next_pos);   
         next := next + 1; 
       END;         5:         BEGIN         next := next + 1;         END;         6:         BEGIN   {   #__________0 Outbound borrows needed  ________0 Outbound borrows failed # }         InsrtDec (line, ms.mainsuffic, 1, next_pos, DR_JUST);         temp_buf := ' Outbound borrows needed';         InsrtChr (line, temp_buf, 27, next_pos, next_pos);        InsrtDec (line, ms.maoutofmem, 39, next_pos, DR_JUST);        temp_buf := ' Outbound borrows failed';         InsrtChr (line, temp_buf, 24, next_pos, next_pos);        next := next + 1;         END;         7:         BEGIN   {   $__________0 Inbound borrows           __________0 Inbound borrows failed $ }         InsrtDec (line, ms.ibinsuffic, 1, next_pos, DR_JUST);         temp_buf := ' Inbound borrows needed';        InsrtChr (line, temp_buf, 26, next_pos, next_pos);        InsrtDec (line, ms.iboutofmem, 39, next_pos, DR_JUST);        temp_buf := ' Inbound borrows failed';        InsrtChr (line, temp_buf, 23, next_pos, next_pos);        next := next + 1;         END;         8:         BEGIN         next := next + 1;         END;         9:         BEGIN   {   !__________0 Free-space recoveries     __________0 Mbufs recovered  ! }         InsrtDec (line, ms.freespacerec, 1, next_pos, DR_JUST);         temp_buf := ' Free-space recoveries';         InsrtChr (line, temp_buf, 22, next_pos, next_pos);        InsrtDec (line, ms.mbufsrecov, 39, next_pos, DR_JUST);        temp_buf := ' Mbufs recovered';         InsrtChr (line, temp_buf, 16, next_pos, next_pos);        IF ( reset ) THEN            BEGIN  
         next := next + 1; 
          END        ELSE           BEGIN  
         next := next + 3; 
          END;         END;         10:        BEGIN         next := next + 1;         END;         11:        BEGIN         IF ( reset ) THEN            BEGIN           line := '(Statistics have been reset.)';            END;         next := next + 1;         END;         OTHERWISE        BEGIN {  End of listing }         next := 0;          { line = ' ' }        END;  {  End of listing }             END;  {  Case  }      
   MemErrorInfo  := next;  
    END;  {  MemErrorInfo    }       $SUBTITLE 'MMInf', PAGE   	   FUNCTION MMinf  	       ( VAR info : InfoRecordType)        : Int16;      	BEGIN {  MMinf   } 	     WITH info DO     BEGIN         CASE inputs [menu_level] OF            0: {  Want buf mgr info }   !         MMinf := bufmgrinfo ( FALSE, FALSE, next_line, buffer );  !           1: {  Want buf mgr info }             MMinf := bufmgrinfo ( FALSE, TRUE, next_line, buffer );             2: {  Want buf mgr info }             MMinf := bufmgrinfo ( TRUE, FALSE, next_line, buffer );             3: {  Want buf mgr info }             MMinf := bufmgrinfo ( TRUE, TRUE, next_line, buffer );              4: {  Want mem mgr info }   "         MMinf   := memmgrinfo ( FALSE, FALSE, next_line, buffer );  "           5: {  Want mem mgr info }   !         MMinf   := memmgrinfo ( FALSE, TRUE, next_line, buffer ); !           6: {  Want mem mgr info }   !         MMinf   := memmgrinfo ( TRUE, FALSE, next_line, buffer ); !           7: {  Want mem mgr info }   !         MMinf   := memmgrinfo ( TRUE, TRUE, next_line, buffer );  !           8: {  Want mem mgr error info }   #         MMinf   := memerrorinfo ( FALSE, FALSE, next_line, buffer );  #           9: {  Want mem mgr error info }   "         MMinf   := memerrorinfo ( FALSE, TRUE, next_line, buffer ); "          10: {  Want mem mgr error info }   "         MMinf   := memerrorinfo ( TRUE, FALSE, next_line, buffer ); "          11: {  Want mem mgr error info }   "         MMinf   := memerrorinfo ( TRUE, TRUE, next_line, buffer );  "           OTHERWISE            {  Want something I don't know! }  
         next_line   := 0; 
 
         MMinf       := 0; 
       END;  {  case  }      	   END;  { with }  	     	END;  {  MMinf   } 	         END   {  IMPLEMENT of MMINF  }  .  