 $PASCAL '91790-1X104 REV.4010 <860404.2209>'  $ TITLE 'IP Path Control Routines' $  $HEAP 0 $   $HEAPPARMS OFF$   $RECURSIVE OFF$   
$STANDARD_LEVEL 'HP1000'$  
 $DEBUG$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $RANGE OFF$       MODULE ippctl;  	$ALIAS 'N$IPPCTL'  	     {}  {-------------------------------------------------------------  {   { (C) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT PACKARD COMPANY.   {   {-------------------------------------------------------------  {}      {}  
{      NAME: IPPCTL  
 {    SOURCE: 91790-18104  	{     RELOC: NONE  	 {      PGMR: CWJ  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   &{  2/13/85     cwj   Correct Segment size calculation for Status Indication  & {  2/14/85     cwj   Change import searches to @.rels   !{  5/2/85      cwj   Change for alteration of reassembly algorithm ! {  5/16/85     cwj   Add SEND_ULP_SRCQUNCH state processing   {  5/21/85     cwj   Add SendUlpSrcQuench routine code  %{                    ( Depends: TCP must handle this STATUS_INDICATION  )  % %{                    ( Depends: WHEN SODEC adds SI_SRC_QUENCH remove it )  % %{                    (          from this module.                       )  % {  5/22/85     cwj   Add ICMP send calls  !{  6/4/85      cwj   Change REQUEST DPATH handling so that sending ! ${                    may happen with an offered, but not confirmed route $ !{  7/1/85      cwj   Change GetAnhRec to set the net segment size  ! {  7/30/85     cwj   Bug Fix: KillPath not fetching ANH record  {  7/31/85     cwj   Change calling sequence of GetAnhRec   {  8/2/85      cwj   Convert to LogEvent  {                    IMPORT @.xpt   {                    RANGE checking off   {                    Enter/Leave Critical error handling   {  8/14/85     cwj   Process Offered Route changes for DCN nodes   {  8/20/85     cwj   Add Prosw error return logging   {  8/26/85     cwj   Initialize error variables   !{  8/28/85     cwj   ANH unlinking not done correctly in KillPath  !  {  8/29/85     cwj   ClearOutQue now also clears SEND_DATA state   {                    Move KillPath processing to IPACTP   {                    Move ClearReassQue to IPACTP   {                    Move ClearOutQue to IPACTP   {                    change cst_KILL_PATH to ast_KILL_PATH  ${                    SendKillUp will always clear the SEND_KILL_UP state $ '{                    SendFragStatus will always clear the SEND_FRAG_STATUS st. ' {  8/30/85     cwj   Move ClearFragments to IPACTP  {                    Added UpdatedPr in several cases   {  ----- posted -----   {  9/11/85     cwj   Don't count Kill Indications   {                    Move KillEmsg from IPIB  {                    Cleanup Offered route emsg counting  {                    Move KillOldRoute in from IPLIB  {                    Misc emsg count cleanup  {  9/12/85     cwj   Export KillOldRoute  {                    Remove DS_IncWd  {                    Remove DS_DecWd  {  ----- N145 Submittal -----    {  9/19/85     cwj   Convert to CCP - DEBUG remove trigger code    {  ----- N152 Submittal -----   {  9/30/85     cwj   KillEmsg parameter unused bug  {  ----- N171 Submittal -----   {  11/5/85     cwj   Add Part Number  {  11/6/85     cwj   Add Module Alias   {  11/18/85    cwj   CCP out TRGLB references   {  ----- N209 Submittal -----   "{  11/21/85    cwj   Clear Outbound Msg Queue when Sending Kills up. " ${  11/22/85    cwj   RequestDpath while ProcessOffer only if NOT pending $ {  ----- N220 Submittal -----   {  12/2/85     cwj   Changed Emsg Counts from Int16 to Int32  {                    Remove a redundant constant  {  ----- N214 Submittal -----   !{  1/9/85      cwj   IP Should not Request Dpath of Probe in INPRO ! {  ----- N286 Submittal -----   {  1/11/86     cwj   Path Maintainance bugs fixed   {  1/14/86     cwj   Move LLP emsg counts to ANH record   {  1/16/86     cwj   Export SegSize Check   {  ----- N302 Submittal -----   {  ----- N334 Submittal -----   {  01/30/86    jar   REV.2608   {  ----- N352 Submittal -----    {  3/13/86     cwj   Checking membership on DCN, use DcnAddress.   {                       SR# 034223  &{                    If ANH address is unknown, don't attempt to verify the  & {                       Offered Route.  {  ----- N372 Submittal -----   ${  3/25/86     cwj   Validate ANH record prior to processing the offered $ {                    route.   {                    SR# 35808  {  ----- Nxxx Submittal -----   {}  {  End of Modifications   {------------------------------------------------------------   {}      {}  { MODULE DESCRIPTION:   {   #{  This module contains the path control maintainance routines for IP. # {   {}  $TITLE 'IMPORT Section',PAGE$       IMPORT                  $SEARCH 'phtm/bodec.xpt'$      bodec,               $SEARCH 'phtm/sodec.xpt'$      sodec,               $SEARCH 'phtm/mmdec.xpt'     mmdec,               $SEARCH 'phtm/mmext.xpt'$      ds_mm,               $SEARCH 'phtm/trcmod.xpt'$     trcmod,              $SEARCH 'phtm/sigmod.xpt'$     sigmod,              $SEARCH 'phtm/tmrdec.xpt'$     tmrdec,              $SEARCH 'phtm/tuser.xpt'$      tuser,               $SEARCH 'phtm/ipdec.xpt'$      ipdec,               $SEARCH 'phtm/ipdb.xpt'$     ipdb,              $SEARCH 'phtm/iplib.xpt'$      iplib;       $TITLE 'EXPORT Section',PAGE$   {------------------------------------------------------------}  {              Export Section                                }  {------------------------------------------------------------}  EXPORT      PROCEDURE IpPathControl;      	PROCEDURE KillEmsg 	            (    pid  : Int16;                   path : Int16);      PROCEDURE SegSizeCheck;       IMPLEMENT       $TITLE 'Forward Declarations',PAGE$   {------------------------------------------------------------}  {              Forward Declarations                          }  {------------------------------------------------------------}      FUNCTION  FirstAhState            $ALIAS 'DS_FirstElement'$              (    states  : AhStateSetType ) : AhAllStatesType;               EXTERNAL;       FUNCTION  FirstPrState            $ALIAS 'DS_FirstElement' $             (    states  : PrStateSetType ) : PrAllStatesType;               EXTERNAL;       PROCEDURE KillOfferedRoute;   
            FORWARD; 
     PROCEDURE ProcessOfferedRoute;  
            FORWARD; 
     PROCEDURE ProSw              (VAR emsg : EventMsgType;              VAR ierr : Int16);              EXTERNAL;       
PROCEDURE SendFragStatus;  
 
            FORWARD; 
     PROCEDURE SendKillUp;   
            FORWARD; 
     
PROCEDURE SendUlpSrcQnch;  
 
            FORWARD; 
     
$TITLE 'Procedures',PAGE$  
 {------------------------------------------------------------}  {              Procedures                                    }  {------------------------------------------------------------}      $TITLE 'IpPathControl',PAGE$  {------------------------------------------------------------}  {              IpPathControl                                 }  {------------------------------------------------------------}      PROCEDURE IpPathControl;      {}  {  Description  {     This routine will handle the processing of the various  {     control states a path record may have set.  {   {     It will process one state each time it is entered.  {     It will process the first state that is set (going   {     from the lowest numbered to the highest numbered states).    {}  {  Parameters   {     None  {}  
{  Global Variables  
 {     gv_ip_globals  IN/OUT   {        This record will be set up prior to entry into this  {        routine. It contains the head of the Control Queue   {        that this routine uses to determine which path   {        record to process.   {   {     gv_path_rec       OUT   {        This routine will fetch the appropriate path record  {        and will then process the control states in this   {        record.  {}  {  Algorithm  {     Process 1 state at a time so that Active Path processing  {     can go on as well.  {}     CONST  "      SUBR = SubrIPPATHCNTL;   { Subroutine ID number for logging }  "          BADSTATE = 2;  { error log qualifier }          VAR  
      error      : Int16;  
 #      first_elem : Int16;         { Int16 with the bit corresponding } # #                                  { to the element of the set to be  } # #                                  { processed.                       } #     
   BEGIN { IpPathControl } 
    WITH gv_ip_globals, gv_path_rec DO         BEGIN { WITH Global Variables }             FetchPathRec (ipg_pr_cntl_que, error);            {}        { Process the states set In order of priority   #      {     which is determined by the order of the bits in the state  # 	      {     word.  	       {}        IF error <> ips_GOOD_RETURN THEN               BEGIN { IF Error on fetch of Path }           { Remove the path from the processing lists    }            { (but first ensure there are no bogus states) }            { (and ensure that the globals get cleaned up) }   
         pr_states := [];  
          pr_active_link := END_OF_LIST;   
         UpdatedPr;  
 
         StatesLink; 
 !         IpErrorLog (EL_ERROR, error, pr_pathref, SUBR+PATHFAIL);  !          END   { IF Error on fetch of Path }            ELSE IF pr_states = [] THEN                BEGIN { IF No states are set }   
         StatesLink; 
          END   { IF No states are set }              ELSE                BEGIN { ELSE Some state is set }                CASE FirstPrState (pr_states) OF                   cst_HAVE_IN_ROUTE:  
               BEGIN 
                ProcessOfferedRoute;   
               END;  
                 cst_SEND_KILL_UP:   
               BEGIN 
 
               SendKillUp; 
 
               END;  
                 cst_SEND_FRAG_STATUS:   
               BEGIN 
                SendFragStatus;  
               END;  
                 cst_SEND_ULP_SRCQNCH:   
               BEGIN 
                SendUlpSrcQnch;  
               END;  
                 OTHERWISE   
               BEGIN 
                { A Control State is NOT set }                  IF (pr_states * ACTIVE_STATES) <> [] THEN                    BEGIN { IF have active state }                    StatesLink;                     END   { IF have active state }  
                ELSE 
                   BEGIN { ELSE unknown state }  !                  { Log this condition, erase the offensive state  ! 
                  {} 
 #                  IpErrorLog (EL_ERROR, 0, pr_pathref, SUBR+BADSTATE); # #                  pr_states := pr_states - [FirstPrState (pr_states)]; #                   UpdatedPr;                    END;  { ELSE unknown state }  
               END;  
                 END;  { CASE first_elem }                END;  { ELSE Some State is set }         END;  { WITH Global Variables }   
   END;  { IpPathControl } 
     $TITLE 'KillEmsg',PAGE$   {------------------------------------------------------------}  {              KillEmsg                                      }  {------------------------------------------------------------}      	PROCEDURE KillEmsg 	            (    pid  : Int16;                   path : Int16);      {}  { Description   {     This routine will generate a KILL_REQUEST with a message  {     count of 1 to the LLP described by PID on the path  
{     referenced by path.  
 {}  { Parameters  %{     pid   IN    The PID of the LLP destined to receive this KILL_REQUEST % {     path  IN    The path ref to be KILLed.  {}  { Side Effects  {     Context is lost and restored as a result of this call.  {}  { Global Data Structures  #{     gv_send_emsg   OUT   Storage for the event message to be sent to # {                          the LLP.   {     gv_wkmap    IN/OUT  {}  	{  Error Handling  	 {     none  {}  {  Algorithm  "{     An event message is built with a message count of 1 using the  "  {     passed in parameters and is then sent to the LLP described   {     in the pid parameter.   {}     CONST  "      SUBR = SubrKILLEMSG;     { Subroutine ID number for logging }  "        VAR  
      error : Int16; 
        BEGIN { KillEmsg }      WITH gv_send_emsg DO         BEGIN { WITH Global Variables }         {}        { Build the event message         {}        em_event := KILL_REQUEST;         ehport := BuildPort (pid, EHOB_OFFSET);         emkr_down_ref    := path;         emkr_msg_snd_cnt := 1;   { Count this message as well }   !      emkr_msg_rcv_cnt := 1;   { Count the message just received } !           {}        { Save the state,         { Send the event message,         { and set the variables to ensure context is fetched        {}        SaveState;        IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);            ProSw (gv_send_emsg, error);  	      ContextLost; 	       DS_EnterCritical (gv_wkmap, gv_gocrit_error);         { Post the Prosw error return if any, before proceeding         { Then save the EnterCritical error         {}  %      IF error <> 0 THEN IpErrorLog (EL_ERROR, error, 0, SUBR+PROSWFAIL);  %       error := gv_gocrit_error;             IF error <> ips_GOOD_RETURN THEN           BEGIN           { Enter Critical Error checking }           IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);            END;       
      FetchGlobals;  
           END;  { WITH Global Variables }      END;  { KillEmsg }       $TITLE 'KillOfferedRoute',PAGE$   {------------------------------------------------------------}  {              KillOfferedRoute                              }  {------------------------------------------------------------}      PROCEDURE KillOfferedRoute;       {}  {  Description  {     KillOfferedRoute will take the Offered route from the   {     given path record, and will generate a KILL_REQUEST   {     to the LLP with an event message count of 1.  {}  {  Parameters   {     None  {}  
{  Global Variables  
 {     gv_ip_globals  IN/OUT    The IP Globals block   #{     gv_path_rec    IN/OUT    The current path record being acted on  # ${     gv_send_emsg      OUT    Storage for the event message being built $ {     gv_wkmap       IN/OUT   {}      CONST       SUBR = SubrKILLOFFER;    { Subroutine ID number for logging }       VAR   	   error : Int16;  	 	   dnpid : Int16;  	 	   dnpath : Int16; 	     
BEGIN { KillOfferedRoute } 
 WITH gv_ip_globals, gv_path_rec, gv_send_emsg DO     BEGIN { WITH Global Variables }     { Record the offer and clear it from the path record.     { and relink the path onto the proper processing queue      {}   
   dnpid  := pr_in_dnpid;  
 
   dnpath := pr_in_dnpath; 
 
   pr_in_dnpid  := NO_PID; 
    pr_in_dnpath := NO_PATH;      pr_states := pr_states - [cst_HAVE_IN_ROUTE];     UpdatedPr;      StatesLink;         { Kill the emsg that brought the offer      { and the bearer of the Kill      {}      KillEmsg (dnpid, dnpath);         END;  { WITH Global Variables }  
END;  { KillOfferedRoute } 
     $TITLE 'ProcessOfferedRoute',PAGE$  {------------------------------------------------------------}  {              ProcessOfferedRoute                           }  {------------------------------------------------------------}  PROCEDURE ProcessOfferedRoute;      {}  { Description   {     This routine will take the offered route contained in   {     path record (pr_in_dnpid, pr_in_dnpath) and do the  {     necessary processing:   {   #{        IF IP has no routing information for the destination network  # {           in the NGT then   {   ${           a new ANH record is fetched to store the offered information $ {           for this one path.  {   
{        Otherwise,  
 {   {           an ANH record is found or built for the ANH given   {           by FetchNgt.  {   {        IF no route has been set into the ANH record    {           for this path, then IP will save this offered route    {           in the ANH record for this path.  {           If the offer is from a node on the DCN, then this   {           offer is accurate, and ah_anh = pr_remote.  ${           If the offer is from a remote network (ah_anh <> pr_remote)  $  {           then the dnpid/dnpath offered may or may not be the    {           ones for the ah_anh gateway node.   #{           An attempt will be made to verify that this offered route  # {           is a route to the gateway of IP's choice.   {           The routine then exits.   {   {     OR (the ANH record has a route, and)  {        IF the route in the ANH record matches the offer,  {           then the offered route is accepted (i.e. the  {           emsg counts are incremented in the path and the   {           offer is cleared from the path rec fields.  {           The routine then exits.   {   {     OR (the ANH record has a route, and   )   {        (the offer does not match the route)   #{        IF the ANH record is waiting for the reply to a REQUEST_DPATH # !{           or if the gateway being used on this route is unknown, ! {           then the offered route is killed.   {           The routine then exits.   {   {     OR (the ANH record has a route, and   {        (the offer does not match the route, and   ${        (the record is not waiting for a reply to a REQUEST_DPATH, and  $ {        (the gateway being used is known, and  
{        otherwise,  
 {           The offered route is killed.  {           The routine then exits.   {}  { Parameters  {     None  {}  	{ Global Variables 	 "{     gv_path_rec    IN/OUT    The path with the offered route to be " {                              processed.   "{     gv_anh_rec        OUT    The ANH record which will be used to  " #{                              hold the down route which results from  # {                              this processing.   %{     gv_ngt_rec        OUT    The NGT record associated with the path rec % {                              being processed.   {}  { Algorithm   {}     LABEL        99;      { Exit Label }          CONST  "      SUBR = SubrPROCOFFER;    { Subroutine ID number for logging }  "          GETANHFAIL     =  1;            FETCHANHFAIL   =  2;            SWITCHANH      =  3;          VAR        error   : Int16;        anhnode : Int32;        dnpid   : Int16;        segsize : Int16;        olddnpid  : Int16;        olddnpath : Int16;  
      llpupemscnt : Int32; 
 
      llpdnemscnt : Int32; 
        PROCEDURE AcceptOfferedRoute;        FORWARD;      	   PROCEDURE Exit; 	       FORWARD;      $page$  	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
        PROCEDURE AcceptOfferedRoute;        BEGIN { AcceptOfferedRoute }        WITH gv_path_rec, gv_anh_rec DO            BEGIN { WITH Global Variables }           {}            { Record the offer, and count it.           { Clear the offer from the path           {}            ah_dnpid  := pr_in_dnpid;           ah_dnpath := pr_in_dnpath;            SegSizeCheck;           ah_up_emscnt := ah_up_emscnt + 1;           pr_in_dnpid  := NO_PID;           pr_in_dnpath := NO_PATH;            pr_states := pr_states - [cst_HAVE_IN_ROUTE];  
         StatesLink; 
 
         UpdatedPr;  
 
         UpdatedAnh; 
          END;  { WITH Global Variables }        END;  { AcceptOfferedRoute }      BEGIN { ProcessOfferedRoute }   WITH gv_path_rec, gv_anh_rec, gv_ngt_rec DO          BEGIN { WITH Global Variables }      { Fetch the NGT information to use in validating or building    
   { the ANH record. 
    {}      IF pr_ngt_idx = NO_NGT THEN        BEGIN { IF dest net is unknown to IP }        anhnode := NO_ANH_NODE;         dnpid   := 0;          { No LLP PID this network }        segsize := 0;          { No segmentation this net }         END   { IF dest net is unknown to IP }          ELSE            BEGIN { ELSE dest net is known to IP }        { Fetch the NGT information and determine the         { Appropriate Next Hop (ANH) to be taken        {}        FetchNgtRec (pr_ngt_idx, pr_remote);  
      anhnode := ngt_anh;  
       dnpid   := ngt_dnpid;         segsize := ngt_segsize;         END;  { ELSE dest net is known to IP }         {}      { Is there already a route associated with this path?     {}      IF pr_anh_idx = NO_ROUTE THEN        BEGIN { IF no ANH record currently }        {  Get the ANH record appropriate to this situation         {}        GetAnhRec (anhnode, dnpid, segsize, error);         IF error <> ips_GOOD_RETURN THEN           BEGIN { IF couldn't get an ANH record }           { This is never supposed to happen.           {}   #         IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+GETANHFAIL); # 
         KillOfferedRoute; 
          Exit;           END;  { IF couldn't get an ANH record }      	      LkPathToAnh; 	       END   { IF no ANH record currently }          ELSE        BEGIN { ELSE have an ANH record already }         FetchAnhRec (pr_anh_idx, error);        IF error <> ips_GOOD_RETURN THEN           BEGIN { IF couldn't get an ANH record }           { This is never supposed to happen.           {}   $         IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+FETCHANHFAIL); $ 
         KillOfferedRoute; 
          Exit;           END;  { IF couldn't get an ANH record }            END;  { ELSE have an ANH record already }          { Have an ANH record now      {}          IF anhnode <> 0 THEN         BEGIN { IF destination network is Known to NGT }        IF anhnode <> ah_anh THEN            BEGIN { IF NGT's ANH is different than the ANH's }   $         { This ANH record is no longer valid for the given path record  $          {}            pr_states := pr_states + [ast_BUILD_ROUTE];  
         UpdatedPr;  
 
         StatesLink; 
 
         KillOfferedRoute; 
          Exit;           END;  { IF NGT's ANH is different than the ANH's }         END   { IF destination network is Known to NGT }          ELSE            BEGIN { ELSE destination network is UNknown to NGT }        IF (ah_dnpid  <> pr_in_dnpid ) OR            (ah_dnpath <> pr_in_dnpath) THEN            BEGIN { IF Offered Route <> Current Route }           IF (ah_pr_link = pr_pathref) AND               (pr_anh_link = END_OF_LIST) THEN  "            BEGIN { IF this is the only path using this ANH record } "              { Save the old route information to Kill it properly               {}              olddnpid := ah_dnpid;               olddnpath := ah_dnpath;               llpupemscnt := ah_up_emscnt;              llpdnemscnt := ah_dn_emscnt;              ah_up_emscnt := 0;              ah_dn_emscnt := 0;      $            { Clear out the necessary fields to show the destination is  $ #            { unknown to IP, and so the gateway is only inferred from  #             { the inbound message.              {}              ah_anh := 0;              ah_segsize := 0;              ah_netpid  := 0;              ah_netsegsize := 0;       !            { Accept the offered route, and check the segment size !             {}              AcceptOfferedRoute;                   { Kill the old route, and get out.              {}  #            KillRoute (olddnpid, olddnpath, llpupemscnt, llpdnemscnt); # 	            Exit;  	 "            END   { IF this is the only path using this ANH record } "               ELSE      #            BEGIN { ELSE there are other paths using this ANH record } #             { Remove this path from the ANH record's queue.               {}              UnLkPathfromANH;              { Build a new ANH record              { (suitable for an unknown destination network)               { and save the offered route there.               {}              GetAnhRec (0, 0, 0, error);               IF error <> ips_GOOD_RETURN THEN                 BEGIN { IF couldn't get an ANH record }  &               IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+SWITCHANH);  &                KillOfferedRoute;  
               Exit; 
                END;  { IF couldn't get an ANH record }                  LkPathToAnh;              AcceptOfferedRoute;   	            Exit;  	 #            END;  { ELSE there are other paths using this ANH record } #              END;  { IF Offered Route <> Current Route }        END;  { ELSE destination network is UNknown to NGT }         IF (ah_dnpid = pr_in_dnpid) AND        (ah_dnpath = pr_in_dnpath) THEN         BEGIN { IF offer matches current route }  
      AcceptOfferedRoute;  
       Exit;         END;  { IF offer matches current route }         IF (ah_dnpid  = NO_PID ) OR        (ah_dnpath = NO_PATH) THEN        BEGIN { IF no recorded route }  
      AcceptOfferedRoute;  
     #      { and attempt to verify the offer if the IP addresses disagree.  #       {  (only if the gateway IP Address is known)        {}        IF (ah_anh <> pr_remote) AND           (ah_anh <> NO_ANH_NODE) AND           NOT (ahst_ROUTE_PENDING IN ah_states) THEN            BEGIN { IF ANH's disagree }           pr_states := pr_states + [ast_BUILD_ROUTE];  
         UpdatedPr;  
 
         StatesLink; 
          END;  { IF ANH's disagree }            Exit;         END;  { IF no recorded route }         IF (ahst_ROUTE_PENDING IN ah_states) THEN        BEGIN { IF ANH is awaiting a CONFIRM_DPATH }        { In this case, we already have a route and         { are already verifying it. We are not to have multiple         { REQUEST_DPATHs outstanding.         {}        KillOfferedRoute;         Exit;   #      END;  { IF ANH is awaiting a CONFIRM_DPATH or unknown gateway }  #        IF (ah_anh = NO_ANH_NODE           ) THEN        BEGIN { IF gateway is unknown }   #      { In this case, there is no gateway to verify the route against. #       { NOTE:   !      { In the future we may want to accept the offer in this case ! !      { as being a more recent indication of the state of the net. !       {}        KillOfferedRoute;         Exit;         END;  { IF gateway is unknown }          { If none of the above conditions hold,     { then the offer doesn't match the current route.     {}      IF DcnAddress (pr_remote) THEN         BEGIN { IF route to node on DCN }          { Log an error to indicate that somehow our Down PID/Path           { info has changed. (It is supposed to be a fixed mapping    !      { for the life of the path. f(IP Address) = (dnpid, dnpath)  !       {}         IpErrorLog (EL_WARNING, ips_DCNPATHSW, pr_pathref, SUBR);              { Save the old route and the emsg counts        { clear the emsg counts from the anh        {}        olddnpid := ah_dnpid;         olddnpath := ah_dnpath;         llpupemscnt := ah_up_emscnt;        llpdnemscnt := ah_dn_emscnt;        ah_up_emscnt := 0;        ah_dn_emscnt := 0;            { Accept the offer, and check the segment size        {}  
      AcceptOfferedRoute;  
           { Now get rid of the old route.         {}         KillRoute (olddnpid, olddnpath, llpupemscnt, llpdnemscnt);       #      { All context is lost but the Global block and the path record.  #       {}        Exit;         END   { IF route to node on DCN }          ELSE             BEGIN { ELSE route to remote network }        KillOfferedRoute;         END;  { ELSE route to remote network }         END;  { WITH Global Variables }      
99:   { Exit Point } 
 END;  { ProcessOfferedRoute }       $TITLE 'SendFragStatus',PAGE$   {------------------------------------------------------------}  {              SendFragStatus                                }  {------------------------------------------------------------}      
PROCEDURE SendFragStatus;  
     {}  {  Description  !{     This routine is called to generate a status indication event ! #{     message for the ULP to inform it about the maximum fragmentation # {     size currently allowed on this path.  {   {     NOTE that this advisory emsg is not counted.  {}  {  Parameters   {     none  {}  
{  Global Data Structures  
 {     gv_ip_globals  IN/OUT   {     gv_send_emsg      OUT   {     gv_path_rec    IN/OUT   {     gv_anh_rec        OUT   {     gv_wkmap       IN/OUT   {}     LABEL        99;      { Exit Label }          CONST  "      SUBR = SubrSENDFRAGST;   { Subroutine ID number for logging }  "     "      MIN_IP_HDLEN = 20;       { Byte length of minimum IP header }  "        VAR  
      error       : Int16; 
 
      segmentsize : Int16; 
           PROCEDURE Exit;            BEGIN { Exit }   	         GOTO 99;  	          END;  { Exit }          BEGIN { SendFragStatus }       WITH gv_ip_globals, gv_send_emsg, gv_path_rec, gv_anh_rec DO          BEGIN { WITH Global Variables }         { Always clear the SEND_FRAG_STATUS state         {}        pr_states := pr_states - [cst_SEND_FRAG_STATUS];        UpdatedPr;            { IF no ULP to report to, exit. (e.g. S&F paths)        {}        IF (pr_uppid = NO_PID) THEN Exit;             {}        { Have ULP to report to         {}        { Fetch the necessary state         {}        FetchAnhRec (pr_anh_idx, error);        IF error <> ips_GOOD_RETURN THEN           BEGIN { IF Error on Anh record fetch }            { This is an internal error that should not arise }  
         { Log the error,  
          { Remove the frag status state   #         { Set the build route state to correct the bad ANH reference  #          {}   "         IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+ANHFAIL);  "          pr_anh_idx := NO_INDEX;           pr_states := pr_states + [ast_BUILD_ROUTE];  
         UpdatedPr;  
 
         StatesLink; 
          Exit;           END;  { IF Error on Anh record fetch }             {}        { Have the ANH record         {}  !      { Determine the appropriate segment size to pass to the ULP. ! #      { This is the # bytes of user data, assuming standard IP header. #       {         { IF the segment size goes below 0, 0 will be returned.         {}        segmentsize := ah_segsize - MIN_IP_HDLEN;             IF segmentsize < 0 THEN segmentsize := 0;             { Build the event message         {}        em_event := STATUS_INDICATION;        ehport   := BuildPort (pr_uppid, EHIB_OFFSET);            emsi_dn_ref  := pr_pathref;         emsi_segsize := segmentsize;      
      { Save all the state 
       { and send the message        {}        SaveState;            IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);        ProSw (gv_send_emsg, error);  	      ContextLost; 	       DS_EnterCritical (gv_wkmap, gv_gocrit_error);         { Post the Prosw error return if any, before proceeding         { Then save the EnterCritical error         {}  %      IF error <> 0 THEN IpErrorLog (EL_ERROR, error, 0, SUBR+PROSWFAIL);  %       error := gv_gocrit_error;             IF error <> ips_GOOD_RETURN THEN           BEGIN { IF Error going critical }           IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);            Exit;           END;  { IF Error going critical }      
      FetchGlobals;  
           END;  { WITH Global Variables }          99:   { Exit Point }      END;  { SendFragStatus }       
$TITLE 'SendKillUp',PAGE$  
 {------------------------------------------------------------}  {              SendKillUp                                    }  {------------------------------------------------------------}  PROCEDURE SendKillUp;       {}  {  Description  {     This routine will send a Kill Indication to the ULP    {     for the path record contained in the global path variable.   {   {     NOTE, IP will log the KILL_INDICATION if the error code   {     to be put into it is within IP's range. IP takes this   {     to mean, that the KILL_INDICATION was generated by IP.  {     If the KI is generated by another layer, some non-IP  {     error code will be passed along as the reason.  {    {     Also, KILL_INDICATIONs are not counted in the emsg counts,   {     because they are advisory messages.   {}  {  Parameters   {     None  {}  
{  Global Variables  
 {     gv_path_rec    IN/OUT   This is the path record that the   {                             KILL_INDICATION is to be sent with   {                             reference to.   {     gv_send_emsg      OUT   {     gv_wkmap       IN/OUT   {}  {  Algorithm  {}  LABEL   
   99;      { Exit Point } 
     CONST       SUBR = SubrSENDKILLUP;   { Subroutine ID number for logging }       VAR   	   error  : Int16; 	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     
BEGIN { SendKillUp } 
 WITH gv_path_rec, gv_send_emsg DO      BEGIN { WITH Global Variables }     { Always clear the SEND_KILL_UP state     {}      pr_states := pr_states - [cst_SEND_KILL_UP];      UpdatedPr;          { Clean any messages waiting to be sent off of this path.      {  (the path is not currently sendable, so return the memory       {   for these messages.)      {}      ClearOutQue;          IF pr_proto.byte = NO_PROTO THEN         BEGIN { IF store and forward path }         pr_states := pr_states + [ast_KILL_PATH];         UpdatedPr;  	      StatesLink;  	       Exit;         END;  { IF store and forward path }          { Build KILL_INDICATION Message     {}      em_event := KILL_INDICATION;      ehport   := BuildPort (pr_uppid, EHIB_OFFSET);      emki_down_pid := IP;      emki_down_ref := pr_pathref;      emki_reason   := pr_ki_reason;          { Log this event message IF IP generated the KI     { (if there is an IP error for a reason, assume IP   	   {  started it). 	    {}      IF (                pr_ki_reason > ips_IP) AND         (ips_IP + 1000 > pr_ki_reason         )    THEN         BEGIN { IF KI started by IP }         IpKillLog (gv_send_emsg, SUBR);         END;  { IF KI started by IP }          { Clean up the path record      {}      pr_ki_reason                   := ips_GOOD_RETURN;      UpdatedPr;          { Send the event message      {}          SaveState;      IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);      ProSw (gv_send_emsg, error);      ContextLost;      DS_EnterCritical (gv_wkmap, gv_gocrit_error);     { Post the Prosw error return if any, before proceeding     { Then save the EnterCritical error     {}   #   IF error <> 0 THEN IpErrorLog (EL_ERROR, error, 0, SUBR+PROSWFAIL); #    error := gv_gocrit_error;         IF error <> ips_GOOD_RETURN THEN         BEGIN { IF critical call failed }         IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);        END;  { IF critical call failed }          FetchGlobals;         END;  { WITH Global Variables }      
99:   { Exit Point } 
 
END;  { SendKillUp } 
     $TITLE 'SendUlpSrcQnch',PAGE$   {------------------------------------------------------------}  {           SendUlpSrcQnch                                   }  {------------------------------------------------------------}      
PROCEDURE SendUlpSrcQnch;  
     {}  { Description    {     This routine will generate a Status indication for the ULP    {     indicated by gv_path_rec, indicating that a SOURCE QUENCH    {     ICMP message was received.  {   {     NOTE that this advisory emsg is not counted.  {}  { Parameters  {     none  {}  { Global Data Structures   {     gv_path_rec    IN/OUT   The path record to use as context.   {     gv_send_emsg      OUT   {     gv_wkmap       IN/OUT   {}  { Error Handling  {}  { Algorithm   {   {}  LABEL      99;   { Exit point }       CONST      SUBR = SubrSendUlpSrcQnch;      SI_SRC_QUENCH = 1;      { Temp until SODEC changes }       VAR   
   error    : Int16; 
     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { SendUlpSrcQnch }  WITH gv_path_rec, gv_send_emsg DO      BEGIN { WITH global variables }     { Clear the state from the path     {}      pr_states := pr_states - [cst_SEND_ULP_SRCQNCH];      StatesLink;         { Is there an ULP listening (i.e. not Store and Forward)      {}      IF pr_uppid = NO_PID THEN Exit;         { Build the event message for the ULP     {}      em_event       := STATUS_INDICATION;      ehport         := BuildPort (pr_uppid, EHIB_OFFSET);      emsi_dn_ref    := pr_pathref;     emsi_segsize   := 0;      emsi_status[1] := SI_SRC_QUENCH;          { Save the state, and send the message      {}      SaveState;      IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);      ProSw (gv_send_emsg, error);      ContextLost;      DS_EnterCritical (gv_wkmap, gv_gocrit_error);     { Post the Prosw error return if any, before proceeding     { Then save the EnterCritical error     {}   #   IF error <> 0 THEN IpErrorLog (EL_ERROR, error, 0, SUBR+PROSWFAIL); #    error := gv_gocrit_error;         IF error <> 0 THEN         BEGIN { IF Error on Enter Critical }        IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);        Exit;         END;  { IF Error on Enter Critical }         FetchGlobals;         END;  { WITH global variables }      
99:   { Exit Point } 
 END;  { SendUlpSrcQnch }      $TITLE 'SegSizeCheck',PAGE$   {------------------------------------------------------------}  {           SegSizeCheck                                     }  {------------------------------------------------------------}      PROCEDURE SegSizeCheck;       {}  { Description   {     This routine will set the segmentation size based on the  #{     DnPid. If the expected DnPid is used, then the segmentation size # !{     will be set to the value determined at initialization time.  ! !{     If an unexpected PID is found, then a default (max) segment  ! {     size for that DnPid will be used.   {   {     This routine should be called each time ah_dnpid is set.  {}  { Parameters  {     none  {}  { Global Data Structures  {     gv_anh_rec  IN/OUT      The current ANH record  {}  	{  Error Handling  	  {     If an error is encountered, then the smallest segment size   {     of any LLP known to IP is used.   {}      BEGIN { SegSizeCheck }  	WITH gv_anh_rec DO 	    BEGIN { WITH global ANH record }      IF ah_dnpid = ah_netpid THEN         BEGIN { IF using the LLP IP expects }         ah_segsize := ah_netsegsize;        END   { IF using the LLP IP expects }       ELSE        BEGIN { ELSE using an unexpected LLP }        CASE ah_dnpid OF           IEEE_802:      ah_segsize := MAX802PKT;           ROUTER:        ah_segsize := MAXRTRPKT;           GG_PID:        ah_segsize := MAXGWYPKT;           OTHERWISE      ah_segsize := MAXSMLPKT            END;  { CASE ah_dnpid }        END;  { ELSE using an unexpected LLP }     END;  { WITH global ANH record }   UpdatedAnh;   END;  { SegSizeCheck }      $PAGE$ (* title   $TITLE 'template',PAGE$   {------------------------------------------------------------}  {           template                                         }  {------------------------------------------------------------}      	PROCEDURE Template 	            (VAR error      : Int16);      {}  { Description   {}  { Parameters  {   {   {   {   {   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}      	BEGIN { Template } 	 	END;  { Template } 	     *)      	$TITLE 'The End'$  	 
END   { IMPLEMENT }  
 .     { End of File }  