 $PASCAL '91790-1X102 REV.4010 <860402.1328>'  $ TITLE 'IP Outbound Routines' $  $HEAP 0 $   $HEAPPARMS OFF$   $RECURSIVE OFF$   
$STANDARD_LEVEL 'HP1000'$  
 $DEBUG$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $RANGE OFF$       MODULE ipob;  $ALIAS 'N$IPOB'       {}  {-------------------------------------------------------------  {   { (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS  { RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   { REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT  { THE PRIOR WRITTEN CONSENT OF THE HEWLETT PACKARD COMPANY.   {   {-------------------------------------------------------------  {}      {}  	{      NAME: IPOB  	 {    SOURCE: 91790-18102  	{     RELOC: NONE  	 {      PGMR: CWJ  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   {  2/14/85     cwj   Change import searches to @.rels   {  2/18/85     cwj   Add RCB logging for Reassembly Time Outs   {  2/21/85     cwj   Revise Msg Duplication Trigger processing  {                    during SAT_BEAM processing in case of  {                    an extra SAT_BEAM  {  3/ 5/85     cwj   Revised Trigger handling at SAT BEAM call  #{  3/18/85     cwj   Fixed bug in ReassTimeOut. RCB was never removed  # {                    from GLOBAL block on timeout.  !{                    And added StartSFTimer Call to OutIpSfTimer.  ! "{  3/26/85     cwj   Fixed Reass Timeout processing in ReassTimeOut  " {  4/12/85     cwj   Remove the PopWindow concept    {  5/2/85      cwj   Change references to Hole desc to Frag desc   {  5/22/85     cwj   Add ICMP send calls  {  7/3/85      cwj   for cww: Changes for PROBE SREGLIB   {  6/28/85     cwj   Correct processing of S&F timer  {                    Move OutIpSfTimer to IpActp   {  7/1/85      cwj   Process KILL_REQUEST with CleanupPath state   {  7/9/85      cwj   Correct Emsg counting  {                    Merge in N050 emsg format changes  {  7/29/85     cwj   Correct statistics keeping   {  8/2/85      cwj   LogEvent Conversion  {  8/3/85      cwj   IMPORT @.xpt   {                    Range checking off   {                    Enter/Leave critical error handling  {  8/16/85     cwj   Change comments re: global variables   {  8/29/85     cwj   Change ast_CLEANUP_PATH to ast_KILL_PATH   {  8/30/85     cwj   Added UpdatedPr in several cases   {  ----- posted -----   {  9/3/85      cwj   Changes for Connectionless path handling   {  9/10/85     cwj   Handle Out Kill Request for path types   !{  9/11/85     cwj   One Shot Send's killing re Connectless paths  ! {                    Remove gv_out_emscnt   {  9/12/85     cwj   Remove DS_IncWd  {                    Remove DS_DecWd  {  9/13/85     cwj   StartClTimer when appropriate  {  9/14/85     cwj   One Shot Send kill count processing  {                    Clear age when connectionless path used  {  9/16/85     cwj   Handle Kill_Requests correctly   {  ----- N145 Submittal -----   {  9/19/85     cwj   Moved DisposeRcbsQue to IPACTP   {                    Changed to CCP - remove TRIGGER Points   {  9/26/85     cwj   Initialize error parameters  {  ----- N152 Submittal -----   {  9/30/85     cwj   Move trcmod IMPORT before sigmod IMPORT  {  ----- N172 Submittal -----   {  10/31/85    cwj   RCB list maintainance fixes  {  ----- N185 Submittal -----   !{  10/9/85     cwj   Let KillPath do cleanup checking when a path  ! {                       is no longer referenced   {  ----- N176 Submittal -----   {  11/5/85     cwj   Add Part Number  {  11/6/85     cwj   Add Module Alias   {  11/18/85    cwj   CCP out TRGLB references   {  ----- N209 Submittal -----   ${  1/16/86     cwj   Change Reassembly Time out to a Warning (not Error) $ {  ----- N302 Submittal -----   {  ----- N395 Submittal -----   !{  4/2/86      cwj   Change QueueMsgOnSendQue calling sequence for ! "{                       Outbound Msg Queue LIFO to FIFO conversion.  " {                       SR# 035451  {  ----- Nxxx Submittal -----   {}  {  End of Modifications   {------------------------------------------------------------   {}      {}  { MODULE DESCRIPTION:   {   !{  This module contains the IP Outbound procedures and functions.  ! {   {  This module contains the following things:   {   
{     IMPORT Section 
 {        BODEC imported for the general global declarations   #{        SODEC imported for the socket and event message declarations  # {   
{     EXPORT Section 
 %{        This contains the declarations for the IP Outbound routines that  % {        will be called by the ProSw routine.   {   {     FORWARD Procedure Decls   !{        The remainder of the Outbound routines are declared here. ! {   {     Procedure Declarations  {        The IP Outbound routines are implemented.  {   {}      $TITLE 'IMPORT Section',PAGE$       IMPORT                  $SEARCH 'phtm/bodec.xpt'$      bodec,               $SEARCH 'phtm/sodec.xpt'$      sodec,               $SEARCH 'phtm/mmdec.xpt'     mmdec,               $SEARCH 'phtm/mmext.xpt'$      ds_mm,               $SEARCH 'phtm/trcmod.xpt'$     trcmod,              $SEARCH 'phtm/sigmod.xpt'$     sigmod,              $SEARCH 'phtm/tmrdec.xpt'$     tmrdec,              $SEARCH 'phtm/tuser.xpt'$      tuser,               $SEARCH 'phtm/ipdec.xpt'$      ipdec,               $SEARCH 'phtm/ipdb.xpt'$     ipdb,              $SEARCH 'phtm/iplib.xpt'$      iplib,               $SEARCH 'phtm/ippctl.xpt'$     ippctl,              $SEARCH 'phtm/ipactp.xpt'$     ipactp;      $TITLE 'EXPORT Section',PAGE$   EXPORT      	PROCEDURE Outbound 	            (VAR emsg_recvd : EventMsgType;              VAR result     : Int16);      PROCEDURE OutKillRequest             (VAR emsg_recvd : EventMsgType);       
PROCEDURE OutSatBeam 
            (VAR emsg_recvd : EventMsgType);       PROCEDURE OutSendRequest             (VAR emsg_recvd : EventMsgType);       	PROCEDURE OutStubb 	            (VAR emsg_recvd : EventMsgType;              VAR result     : Int16);      
PROCEDURE OutTimerExpires  
            (VAR emsg_recvd : EventMsgType);       IMPLEMENT       $TITLE 'Forward/External Decl',PAGE$  {------------------------------------------------------------}  {              Forward/External Declarations                 }  {------------------------------------------------------------}      PROCEDURE ReassTimeOut;   
            FORWARD; 
     
$TITLE 'Procedures',PAGE$  
 {------------------------------------------------------------}  {              Procedures                                    }  {------------------------------------------------------------}          $TITLE 'Outbound',PAGE$   {------------------------------------------------------------}  {              Outbound                                      }  {------------------------------------------------------------}  	PROCEDURE Outbound 	            (VAR emsg_recvd : EventMsgType;              VAR result     : Int16);      {}  { Description   #{     This is the primary IP Outbound Event handler. It is the routine # "{     that will be called by ProSw in the Outbound protocol process  " {     to handle an IP outbound event.   {}  { Parameters   {     emsg_recvd   in         The event message to be processed.   "{     result                  The result of the ProSw call. Ignored  " {                             by this routine.  {}  { Side Effects  {   {}  { Global Data Structures  {     gv_ip_globals        OUT  {     gv_path_rec          OUT  {     gv_wkmap          IN/OUT  {}  { Error Handling  {   {}  { Algorithm   {     The processing of an event message has several parts:   {   {        1) Building Context  ${              The event message is parsed to determine what needs to be $ &{              done and then the appropriate IP data structures are fetched  & 
{              from DSAM.  
 ${              These structures are then set into the appropriate states $ {              depending on the processing to be done.  {   {        2) Processing IP's processing queues   {              Path Control Queue   {              Active Path Queue  {   {        3) Saving State  {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrOUTBOUND;     { Subroutine ID number for logging }       VAR   	   error : Int16;  	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     	BEGIN { Outbound } 	 WITH gv_ip_globals, gv_path_rec, emsg_recvd DO         BEGIN { WITH GLOBAL VARIABLES }     result := 0;          { Ensure that present context is invalid      { Go critical to ensure exclusive access to DSAM tables     { Fetch the IP Global variables from DSAM     { Set the event to be processed from the event message      {}      gv_gocrit_error := 0;     ContextLost;      DS_EnterCritical (gv_wkmap, gv_gocrit_error);     error := gv_gocrit_error;         IF error <> ips_GOOD_RETURN THEN         BEGIN { IF go critical failed }         IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);        Exit;         END;  { ELSE Go Critical Call Failed }         IpEmsgLog (emsg_recvd, SUBR);         FetchGlobals;     {}       { This section handles the initial processing of events that       { arrive from outside this IP protocol module.      {      { The events are Parsed and the appropriate context is set up       { The IP Internal Event is set, and control is passed to the       {     appropriate IP routine to handle the event.     {     { This Processing sets up IP's tables and states for the      { rest of the work to be done below.      {}       
   CASE em_event OF  
     
      SEND_REQUEST:  
          OutSendRequest (emsg_recvd);       
      KILL_REQUEST:  
          OutKillRequest (emsg_recvd);             TIMER_RESPONSE:            OutTimerExpires (emsg_recvd);            SAT_BEAM:            OutSatBeam (emsg_recvd);             OTHERWISE   "         IpErrorLog (EL_ERROR, ips_UNKNOWN_EMSG, pr_pathref, SUBR);  " $         IpBufrLog  (ipl_EMSGLOG, SUBR, emsg_recvd.int, EMSG_BYTE_LEN);  $           END;  { CASE em_event }          FetchGlobals;         WHILE (ipg_pr_cntl_que     <> END_OF_LIST) OR           (ipg_act_out_pr_que  <> END_OF_LIST) DO            BEGIN { WHILE }         {}        { Processing Queue Processing   #      {     Process paths on these queues until the queues are empty.  # "      {     The Path Control States in a path record have priority.  " #      {     Note, the Inbound process only processes the path control  # $      {     states. The reasons behind this are discussed in the IP/1000 $       {     Design Outline.         {}            IF ipg_pr_cntl_que <> END_OF_LIST THEN           BEGIN { IF }            IpPathControl;            END   { IF }          ELSE            BEGIN { ELSE }            IpActOutPath;           END;  { ELSE }       
      FetchGlobals;  
           END;  { WHILE }          { Start the Connectionless path rec timer if necessary      {}      StartClTimer;         SaveState;      IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);      ContextLost;          END;  { WITH GLOBAL VARIABLES }      
99:   { Exit Point } 
 	END;  { Outbound } 	     $TITLE 'OutKillRequest',PAGE$   {------------------------------------------------------------}  {              OutKillRequest                                }  {------------------------------------------------------------}      PROCEDURE OutKillRequest             (VAR emsg_recvd : EventMsgType);   {}  { Description   !{     On receipt of a KILL_REQUEST event, this routine will handle ! !{     all the initial processing, fetching the appropriate context ! {     and setting it into the proper state.   {     If the emsg count goes to 0, IP's path will be KILLed.  !{     (The actual cleanup will be done after all other processing  ! {      is completed with respect to this path).   !{     Otherwise, the processing is finished and IP will return to  ! {       ProSw.  {}  { Parameters  '{     emsg_recvd  IN       The event message to be processed by this routine.  ' {   {     event          OUT   The event to be processed next.  {}  { Side Effects  {   {}  { Global Data Structures  %{     gv_path_rec    OUT   This is the context for all further processing. % ${                          The emsg counts are decremented and the path  $ %{                          may be set into the pr_KILL_PATH state if these % {                          fields go to 0.  {}  { Error Handling  {     none  {}  { Algorithm   {     The path record will be fetched    {        its message counts will be decremented and if they both   !{        go to 0, the path will be set to the KILL_PATH state and  ! {        linked onto the Path Control Queue.  {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrOUTKILLREQ;   { Subroutine ID number for logging }       VAR   	   error : Int16;  	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { OutKillRequest }  WITH gv_path_rec, emsg_recvd DO      BEGIN { WITH Global Variables }     { Fetch the appropriate context     {}      FetchPathRec (emkr_down_ref, error);      IF error <> ips_GOOD_RETURN THEN         BEGIN { IF DON'T have Path record }         { Log the error and then ignore this event }  "      IpErrorLog (EL_DISASTER, error, emkr_down_ref, SUBR+PATHFAIL); "       Exit;         END;  { IF DON'T have Path record }          {  Count this event message     {}      pr_ulp_dn_emscnt := pr_ulp_dn_emscnt + 1;          {  Kill the event messages that have gone before on this path      {  Process the event message counts     {}      pr_ulp_up_emscnt := pr_ulp_up_emscnt - emkr_msg_rcv_cnt;      pr_ulp_dn_emscnt := pr_ulp_dn_emscnt - emkr_msg_snd_cnt;          IF (pr_ulp_up_emscnt = 0) AND        (pr_ulp_dn_emscnt = 0) THEN       	      BEGIN { IF } 	       {}         { Both counts are 0, all messages have been accounted for    !      { and there are no longer any ULP's path records refering to ! 
      { this path record.  
       {   %      { The path must be KILLed, (which includes cleanup and deallocation) %       { Set its state and link it as necessary.         {}        pr_states := pr_states + [ast_KILL_PATH];   	      StatesLink;  	 	      END;  { IF } 	        UpdatedPr;          END;  { WITH Global Variables }      
99:   { Exit Point } 
 END;  { OutKillRequest }      
$TITLE 'OutSatBeam',PAGE$  
 {------------------------------------------------------------}  {              OutSatBeam                                    }  {------------------------------------------------------------}      
PROCEDURE OutSatBeam 
            (VAR emsg_recvd : EventMsgType);       {}  { Description   %{     This procedure does the preprocessing on the SAT_BEAM event message. %  {     There is no processing to be done, so the routine returns.   {}  { Parameters  {     emsg_recvd              Ignored.  {}  { Side Effects  {   {}  { Global Data Structures  
{     gv_ip_globals     IN 
 {     gv_path_rec          OUT  {}  { Error Handling  {   {}  { Algorithm    {     Control is returned to the Outbound routine to allow it to    {     fall through into the Processing Queue processing section.   {}  CONST   
   SUBR = SubrOUTSATBEAM;  
     VAR   	   error : Int16;  	     
BEGIN { OutSatBeam } 
 {}  { Return so as to get into the processing queue section.  {   { This message is not associated with a particular path,  { so it needs no reference counting.  {}      { Duplicate messages Trigger point  {}  WITH gv_ip_globals, gv_path_rec DO  
   BEGIN { WITH globals }  
 {}   {  NOTE that extra SAT_BEAMs are possible since INPRO is running   "{       'faster' than OUTPRO, so if one arrives and there is nothing " {        to be done, be tolerant, and ignore it.  {}     IF ipg_act_out_pr_que <> END_OF_LIST THEN        BEGIN { IF there is something to be done }            FetchPathRec (ipg_act_out_pr_que, error);         IF error = ips_GOOD_RETURN THEN            BEGIN { IF have path record }           END;  { IF have path record }            END;  { IF there is something to be done }  
   END;  { WITH globals }  
 
END;  { OutSatBeam } 
     $TITLE 'OutSendRequest',PAGE$   {------------------------------------------------------------}  {              OutSendRequest                                }  {------------------------------------------------------------}      PROCEDURE OutSendRequest             (VAR emsg_recvd : EventMsgType);       {}  { Description   {   {     This is the Primary Outbound SendRequest Processor.   {}  {   {  Parameters   
{     emsg_recvd  IN 
 {        On Input the event message has the following fields:   {   &{           emsr_down_ref     The IP Path Record to use in sending the msg.  & ${           emsr_mbufid       The mbuf chain with the data for IP's msg. $ ${           emsr_dlen         The Length of the data in the mbuf chain.  $ ${           emsr_flags        This parameter ignored for first release.  $ ${           emsr_opt_mbufid   This parameter ignored for first release.  $ ${           emsr_killsnd_cnt  The msg count to kill after this request.  $ ${           emsr_killrcv_cnt  The msg count to kill after this request.  $ {}  { Side Effects  {   {}  { Global Data Structures  {   '{     gv_ip_globals  IN     The context required before entering this routine. ' {   !{     gv_path_rec       OUT The context generated by this routine. ! {   {     gv_ip_head        OUT Storage for ip_header   !{                           iphd_ihl = 0 => Header not initialized ! {}  { Error Handling  {   {}  { Algorithm   {   {     It will 1) parse the event message   {             2) set up the appropriate context for the message     {             3) pass control to the off to the sending routine     {             4) If the killsnd or killrcv counts are set, then     {                this path is to be killed following this send.    {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrOUTSENDREQ;   { Subroutine ID number for logging }       VAR   	   error : Int16;  	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     BEGIN { OutSendRequest }  WITH gv_ip_globals, gv_path_rec, emsg_recvd, gv_ip_head DO     BEGIN { WITH Global Variables }     {}   	   { Fetch Context 	    {}      FetchPathRec (emsr_down_ref, error);      IF error <> ips_GOOD_RETURN THEN         BEGIN { IF DON'T have Path record }         { Log the error and ignore this event }   !      IpErrorLog (EL_DISASTER, error, pr_pathref, SUBR+PATHFAIL);  !       Exit;         END;  { IF DON'T have Path record }          { Have Path record      {}   
   { Count this emsg 
    { and increment the statistics.     {}      pr_ulp_dn_emscnt := pr_ulp_dn_emscnt + 1;      #   { If this path is a connectionless path, indicate that it has been  # 	   { recently used 	    {}      IF (pr_path_type = pr_REFED_CONNECTLESS)   OR        (pr_path_type = pr_UNREFED_CONNECTLESS) THEN        BEGIN { IF connectionless path }        pr_cl_idletime := cl_PATH_NOT_IDLE;         END;  { IF connectionless path }         WITH pr_statistics DO        st_sendrq_up := st_sendrq_up + 1;          UpdatedPr;          BuildIPHeader (emsr_flags.int,                     emsr_mbufid,                    emsr_dlen,                    emsr_opt_mbufid );         { Queue the local copy of the header on the send queue }      { of the path in gv_path_rec }      {}      QueueMsgonSendQue (iphd_mbufid);          {}      { Process the killsnd and killrcv counts      {}      IF (emsr_killsnd_cnt <> 0) OR        (emsr_killrcv_cnt <> 0) THEN        BEGIN { IF doing send & kill }  #      { Sender wants this path killed following the completion of this #       { send request.         { Set the path state,         { Decrement the message counts        {}        pr_ulp_dn_emscnt := pr_ulp_dn_emscnt - emsr_killsnd_cnt;        pr_ulp_up_emscnt := pr_ulp_up_emscnt - emsr_killrcv_cnt;        IF (pr_ulp_dn_emscnt = 0) AND            (pr_ulp_up_emscnt = 0) THEN               BEGIN { IF path is unreferenced }           pr_states := pr_states + [ast_KILL_PATH];           END;  { IF path is unreferenced }            END;  { IF doing send & kill }         UpdatedPr;      StatesLink;         SaveState;          END;  { WITH Global Variables }      
99:   { Exit Point } 
 END;  { OutSendRequest }      $TITLE 'OutStubb',PAGE$   {------------------------------------------------------------}  {              OutStubb                                      }  {------------------------------------------------------------}  	PROCEDURE OutStubb 	            (VAR emsg_recvd : EventMsgType;              VAR result     : Int16);      {}  { Description   "{     This is the IP Outbound Stubb Event handler. It is the routine " !{     that will be called by ProSw in the Inbound protocol process ! {     to handle an IP outbound event.   {   #{     The main difference between this routine and IP.OUTBOUND is that # "{     this routine will do the initial event message processing but  " #{     with then generate a SatBeam Signal to let the outbound process  # {     handle the processing queues.   {}  { Parameters   {     emsg_recvd   in         The event message to be processed.   "{     result                  The result of the ProSw call. Ignored  " {                             by this routine.  {}  { Side Effects  {   {}  { Global Data Structures  {     gv_ip_globals        OUT  {     gv_path_rec          OUT  {     gv_wkmap             OUT  {}  { Error Handling  {   {}  { Algorithm   {     The processing of an event message has several parts:   {   {        1) Building Context  ${              The event message is parsed to determine what needs to be $ &{              done and then the appropriate IP data structures are fetched  & 
{              from DSAM.  
 ${              These structures are then set into the appropriate states $ {              depending on the processing to be done.  {   {        2) Processing IP's processing queues   !{              This will be done in the Outbound protocol process. ! !{              This routine will generate a SatBeam signal to the  ! {              outbound process which will do this processing.  {}  LABEL   
   99;      { Exit Label } 
     CONST       SUBR = SubrOUTSTUBB;     { Subroutine ID number for logging }      TMRRSPNS = 1;            { Error Logging Qualifiers }     SATBEAM  = 2;            {           "              }     OTHERWSE = 3;            {           "              }         OB_SIGNAL = 0; { Send SatBeam to Outbound process }      VAR   	   error  : Int16; 	 	   ip_gsd : Int16; 	     	   PROCEDURE Exit; 	 
      BEGIN { Exit } 
       GOTO 99;  
      END;  { Exit } 
     	BEGIN { OutStubb } 	 WITH gv_ip_globals, gv_path_rec, emsg_recvd DO         BEGIN { WITH GLOBAL VARIABLES }     result := 0;          { Ensure that present context is invalid      { Go critical to ensure exclusive access to DSAM tables     { Fetch the IP Global variables from DSAM     { Set the event to be processed from the event message      {}      gv_gocrit_error := 0;     ContextLost;      DS_EnterCritical (gv_wkmap, gv_gocrit_error);     error := gv_gocrit_error;         IF error <> ips_GOOD_RETURN THEN         BEGIN { IF go critical failed }         IpErrorLog (EL_DISASTER, error, 0, SUBR+GOCRITFAIL);        Exit;         END;  { ELSE Go Critical Call Failed }         IpEmsgLog (emsg_recvd, SUBR);         FetchGlobals;         {}       { This section handles the initial processing of events that       { arrive from outside this IP protocol module.      {      { The events are Parsed and the appropriate context is set up       { The IP Internal Event is set, and control is passed to the       {     appropriate IP routine to handle the event.     {     { This Processing sets up IP's tables and states for the      { rest of the work to be done below.      {}       
   CASE em_event OF  
     
      SEND_REQUEST:  
          OutSendRequest (emsg_recvd);       
      KILL_REQUEST:  
          OutKillRequest (emsg_recvd);             TIMER_RESPONSE:   '         IpErrorLog (EL_ERROR, ips_OUTEMSG_RECVD, pr_pathref, SUBR+TMRRSPNS);  '           SAT_BEAM:   &         IpErrorLog (EL_ERROR, ips_OUTEMSG_RECVD, pr_pathref, SUBR+SATBEAM); &           OTHERWISE   "         IpErrorLog (EL_ERROR, ips_UNKNOWN_EMSG, 0, SUBR+OTHERWSE);  "              END;  { CASE em_event }         FetchGlobals;         WHILE  (ipg_pr_cntl_que <> END_OF_LIST) DO             BEGIN { WHILE }         {}        { Processing Queue Processing   !      {     Process paths on the Control Queue until it is empty.  !       {}  
      IpPathControl; 
       FetchGlobals;     { For next pass and for below }         END;  { WHILE }          IF ipg_act_out_pr_que <> END_OF_LIST THEN        BEGIN { IF have active queue processing to do }             { Notify the Outbound process of work to be done }        SaveState;        DS_FetchElement (DS_TrackTD, TL_IP_SOCKET, ip_gsd);         DS_SatBeamSignal (ip_gsd, OB_SIGNAL);         END;  { IF have active queue processing to do }          { Start the Connectionless path rec timer if necessary      {}      StartClTimer;         SaveState;      IF gv_gocrit_error = 0 THEN DS_LeaveCritical (gv_wkmap);      ContextLost;          END;  { WITH GLOBAL VARIABLES }      
99:   { Exit Point } 
 	END;  { OutStubb } 	     $TITLE 'OutTimerExpires',PAGE$  {------------------------------------------------------------}  {              OutTimerExpires                               }  {------------------------------------------------------------}  
PROCEDURE OutTimerExpires  
            (VAR emsg_recvd : EventMsgType);       {}  { Description    {     This routine will call the appropriate routine to process    {     the various types of IP timer events that might occur.  {}  { Parameters  
{     emsg_recvd  IN 
 {}     CONST        SUBR = subrOUTTIMEREXPR;         BEGIN { OutTimerExpires }     CASE emsg_recvd.emtr_data [0] OF       	      IP_CL_TIMER: 	 
            OutIpClTimer;  
           IP_REASS_TIMER:   
            ReassTimeOut;  
           OTHERWISE               IpErrorLog (EL_ERROR, ips_BAD_TMREXPIRE, 0, SUBR);  %            IpBufrLog  (ipl_EMSGLOG, SUBR, emsg_recvd.int, EMSG_BYTE_LEN); %     
      END;  { CASE } 
    END;  { OutTimerExpires }      $TITLE 'ReassTimeOut',PAGE$   {------------------------------------------------------------}  {           ReassTimeOut                                     }  {------------------------------------------------------------}      PROCEDURE ReassTimeOut;       {}  { Description   "{     This routine will do the timeout processing for the reassembly " {     queue.  {   !{     When ICMP processing is done, it will also generate an ICMP  ! {     message indicating that the reassembly failed.  {   "{     NOTE that the RcbUnLink routine will see to it that the timer  " {          is set correctly after it is called.   {}  { Parameters  {     none  {}  { Global Data Structures  #{     gv_ip_globals  IN/OUT   This global block contains the list head # {                             for the reassembly queue.   {     gv_ip_head     IN/OUT   {     gv_path_rec       OUT   {     gv_icmp_msg       OUT   {}  { Error Handling  "{     If the is an error while trying to dispose of the message, the " {     error will be logged, and processing will continue.   {}  CONST      SUBR = subrREASSTIMEOUT;         GETRCBFAIL = 1;       TYPE     ContextType = RECORD CASE Int16 OF         0: (longint : Int32);         1: (int     : Int16);         2: (mbufid  : MbufIdType);        END;  { ContextType }       VAR      rcb       : RcbType;      error     : Int16;      numfrags  : Int16;   
   link      : MbufIdType; 
    context   : ContextType;       BEGIN { ReassTimeOut }  WITH gv_ip_globals, gv_ip_head DO      BEGIN { WITH global variables }     { Set the Timer off flag      {}      ipg_reass_tmrid.index := ip_TIMER_OFF;      UpdatedIpg;         { Set up the fields of the RCB for use as the list head     {}      rcb.rcb_link := ipg_reass_que;      rcb.rcb_time := 0;          WHILE (rcb.rcb_link <> END_OF_LIST) AND           (rcb.rcb_time = 0)             DO            BEGIN { WHILE more RCBs to time out }         link := rcb.rcb_link;         GetRcb (link, rcb, error);        IF error <> 0 THEN               BEGIN { IF error on RCB fetch }           context.mbufid := link;  $         IpErrorLog (EL_DISASTER, error, context.int, SUBR+GETRCBFAIL);  $          RcbUnLink (rcb, GLOBAL_BLK_RCB);            END   { IF error on RCB fetch }             ELSE                BEGIN { ELSE successful RCB fetch }           IpErrorLog (EL_WARNING, 0, rcb.rcb_pathref, SUBR);            IpBufrLog (IPL_RCBTO, SUBR, rcb.rcb_bufr, RCB_BLEN);       $         { Remove the RCB from the list and reset the TIMER if necessary $          {}            RcbUnLink (rcb, GLOBAL_BLK_RCB);            DisposeRcbsQue (rcb, gv_ip_head, numfrags);  $         { NOTE: The IP header is not currently saved during reassembly. $ %         {       When it is, DisposeRcbsQue will return it locally before  %          {       disposing of it.   #         {       The Fragment Offset is the key word here, IF it is 0, # $         {       then that means that the first fragment header arrived, $          {       otherwise, it didn't arrive.            {}            IF iphd.fragwd.iphd_off = 0 THEN               BEGIN { IF have IP header }   $            { Send a Reassembly Time Out ICMP message to the Source node $             {}              GetPathRec (iphd.src, NO_LOCAL, NO_PROTO, error);               IF error = ips_GOOD_RETURN THEN                  BEGIN { IF have proper path }                 WITH gv_icmp_msg DO                    BEGIN { WITH }                    icmp_tc.msgtype := TIME_EXCEEDED;                     icmp_tc.msgcode := REASS_EXPIRED;                     icmp_cksum      := 0;                     timeexceed      := 0; { unused field }                    END;  { WITH }                 RtnIcmpMsg (gv_icmp_msg, error);                  IF error <> ips_GOOD_RETURN THEN                     BEGIN { IF error }  #                  IpErrorLog (EL_ERROR, error, 0, SUBR+ICMPSENDFAIL);  #                   END;  { IF error }                 END   { IF have proper path }              ELSE                 BEGIN { ELSE could'nt get path }   "               IpErrorLog (EL_RESOURCELIM, error, 0, SUBR+PATHFAIL); "                END;  { ELSE could'nt get path }               END;  { IF have IP header }                WITH ipg_statistics DO   (            ipgs_ttl_exp_packloss := DS_IncBt (ipgs_ttl_exp_packloss, numfrags); (          END;  { ELSE successful RCB fetch }        END;  { WHILE more RCBs to time out }          END;  { WITH global variables }  END;  { ReassTimeOut }      $TITLE ' ',PAGE$  (*  $TITLE 'template',PAGE$   {------------------------------------------------------------}  {           template                                         }  {------------------------------------------------------------}      	PROCEDURE Template 	            (VAR error      : Int16);      {}  { Description   {}  { Parameters  {   {   {   {   {   {}  { Side Effects  {}  { Global Data Structures  {   {}  { Error Handling  {}  { Algorithm   {   {}      	BEGIN { Template } 	 	END;  { Template } 	     *)      	$TITLE 'The End'$  	 
END   { IMPLEMENT }  
 .     { End of File }  