 $PASCAL '91790-1X082 REV.4010 <860310.1338> '       $ TITLE 'initstateRoutines'$  $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 0  $   $ DEBUG $   $ CODE_INFO on      	MODULE initstate;  	 
$ALIAS 'N$initstate' 
     {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  {      NAME: initstate  {    SOURCE: 91790-18082  	{     RELOC: NONE  	 {      PGMR: EMS  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date     Prgmr  Description  {  850528   ems    Bug fix: hand mminit sbnum not socket count  {  860228   ems    initialize var in accessinitrn (n356).   {  860310   ems    Add MMNOCRITRN, MMBADCRITRN errors (n368).   {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {  This module handles the access to DSAM and SMB for NSINIT.   {  It is called only by NSINIT and its main modules.  {   {}          IMPORT         { basic memory manager declarations }  
$SEARCH 'phtm/bodec.rel' $ 
    bodec,       
$SEARCH 'phtm/mmdec.rel' $ 
    mmdec,   
$SEARCH 'phtm/mmext.rel' $ 
    ds_mm,          { basic initialization declarations. }   $SEARCH 'phtm/init_dec.rel'$     init_dec,  $SEARCH 'phtm/initmulti.xpt'$      initmulti,       $SEARCH 'phtm/filemad.xpt'$      fileman,       $SEARCH 'phtm/parsdd.xpt' $      parser,      
$SEARCH 'phtm/dres.xpt' $  
    dres,      
$SEARCH 'phtm/alloc.xpt' $ 
    alloc,       $SEARCH 'phtm/init_rte_if.xpt' $     init_rte_if,       $SEARCH 'phtm/initerrck.xpt' $     initerrck;       $ SUBTITLE 'Exported Routines ', PAGE $       EXPORT      TYPE     RNAccessType = ( GETRN, LOCKRN, RTNRN, UNLOCKRN );       PROCEDURE AccessInitRN  (     whichaccess:   RnAccessType;    VAR accessresult:    Int16 );       PROCEDURE AllocateResources     (VAR ds:             DsStateType;          tot_smbsize:    Int16;          tot_dsamsize:   Int32 );      { Allocate resources required by protocols }       
PROCEDURE ChangeStateWords 
    (     whichdsword:   DSWordType;            exitonerror:    Boolean;            newvalue:      Int16;       VAR ierr:          Int16 );  !   { change the value of DS_InitProtoSeg or DS_StateOfDS in DSAM } !     PROCEDURE CheckErrorno    (     errorno:        Int16;          errorvalue:     Int16 );      PROCEDURE CheckShutConditions     (VAR ds:           DsStateType;      VAR ds_stateword: Int16;      VAR goodresponse: Boolean;      VAR passedresult: Int16 );      { Check Shut down environment }      PROCEDURE CheckStartConditions    (VAR ds:           DsStateType;      VAR goodresponse: Boolean;      VAR passedresult: Int16 );      { Check Start up environment }       PROCEDURE DeAllocateDSAM     (     halt_value:    Int16 );     { DeAllocate DSAM.  Print any errors, and Exit NSINIT }      FUNCTION  EnvironmentOk:  Boolean;     { Check run conditions }       
PROCEDURE FetchStateWords  
    (     whichdsword:   DSWordType;            exitonerror:   Boolean;       VAR value:         Int16;       VAR ierr:          Int16 );  !   { Fetch the value of DS_InitProtoSeg or DS_StateOfDS in DSAM }  !     PROCEDURE GetDSCondition  ( VAR dscondition:   DsStateType;     VAR dserrorno:     Int16;     VAR errorvalue:    Int16;     VAR ds_stateword:  Int16 );      { Get the state of DS by checking DS state words in DSAM }       
PROCEDURE GetDSAMCondition 
 ( VAR dsamcondition:   DsStateType;     VAR dsamerrorno:     Int16;     VAR errorvalue:      Int16;     VAR dsam_stateword:  Int16 );      { Get the state of DSAM by calling DS_StateOfDSAM }      PROCEDURE GetStateOfDS    (VAR ds:              DsStateType;     VAR dsamerrorno:     Int16;     VAR dserrorno:       Int16;     VAR errorvalue:      Int16;     VAR ds_stateword:    Int16 );     { Return the state of DS: INIT, UNINIT, or SICK }      
PROCEDURE MarkDSAMUp 
 ( VAR markresult:    Int16 );       { Change the state of dsam to ADSINIT, unlock the init. rn }        IMPLEMENT   { Module initstate }      CONST      EXEC12 = 12+BIT15;      FMPFILEEXISTSERR = -239;      ONESEC = -1;      ONCE   = 0;     SECS   = 2;     QUEUE_W_WAIT = 23;          RNLOCKEDLOCALLY = 2;   
   RTESCHEDERROR = -32768; 
 
   MMINITECATCHR = -32767; 
        { number of socket buffers per socket is 2. }  	   SBPERSOCK = 2;  	     TYPE     NameType = Packed Array[1..6] OF Char;      RAType = Array[1..5] OF Int16;       VAR      a_reg:        TwoPCharType;     b_reg:        TwoPCharType;     message:       PromptType;      progrun:       IStringType;     errorvalue: Int16;      wkmap:         Int16;          PROCEDURE ABReg      ( VAR a_reg:   TwoPCharType;        VAR b_reg:   TwoPCharType );      EXTERNAL;      $PROCEDURE FindMyProgName                         $ ALIAS 'IdAddToName' $ $  (       idaddress:     Int16;     VAR   namearray:     PNameType;     VAR   lu:            Int16 );     EXTERNAL;     { Have RTE find NSINIT's program name }      FUNCTION FmpRpProgram   $ FIXED_STRING ON, HEAPPARMS OFF $   (     filedes:      IStringType;      VAR namerpd:      String;         options:      IStringType;      VAR error:        Int16 ):  Int16;      EXTERNAL;  $ HEAPPARMS ON, FIXED_STRING OFF $      $FUNCTION MyIDSegAddr: Int16;                     $ ALIAS 'MyIdAdd'     $ $    EXTERNAL;     { Have RTE return the caller's ID segment address }      "FUNCTION PascalStringData                $ ALIAS 'Pas.StringData1' $ "    ( VAR s:          String ):  PCharTypePtr;      EXTERNAL;     { return a packed array of char pointer to a string }      PROCEDURE Rmpar      (VAR returnarray: RAType );     EXTERNAL;      PROCEDURE RteRNAccess                      $ ALIAS 'RNRQ' $   $ NOABORT $   
  (    fncode:      Int16; 
 
   VAR rn:          Int16; 
    VAR statretn:    Int16 );     EXTERNAL;      PROCEDURE Schedule                       $ ALIAS 'EXEC' $   $ NOABORT $      (  schedtype:     Int16;         name:          NameType;        parm1:         Int16;         parm2:         Int16;         parm3:         Int16;         parm4:         Int16;         parm5:         Int16;         pcharschstring:PCharType;         stringlen:     Int16 );      EXTERNAL;      FUNCTION SystemProcess    (VAR   idsegaddr:   Int16 ): Int16;      EXTERNAL;     { Find out if the program is running as a system utility }       PROCEDURE WaitASec                        $ ALIAS 'EXEC' $  $ NOABORT $      (     ecode:      Int16;            name:       Int16;            units:      Int16;            often:      Int16;            delay:      Int16 );      EXTERNAL;     { Wait one second }      $ SUBTITLE 'AccessInitRN', PAGE $   {------------------------------------------------------------}  {                                                            }  {                 AccessInitRN                               }  {                                                            }  {------------------------------------------------------------}  {   { Purpose: to AccessInitRN.   {}  PROCEDURE AccessInitRN  (     whichaccess:   RnAccessType;    VAR accessresult:    Int16 );       VAR      ierr:       Int16;      rn:         Int16;      statreturn: Int16;      wkmap:      Int16;              BEGIN    { AccessInitRN }     accessresult := GOOD;         CASE whichaccess OF        GETRN:           BEGIN    { buy rn }               { get an rn, save it in res }  !         DS_GetRN( NSINIT_AdrOf( Lb_QRN ), 0, rn, accessresult );  !          IF accessresult = GOOD THEN              BEGIN    { save rn in dsam }              DS_InitEnterCritical( wkmap, accessresult );              IF accessresult = GOOD THEN                  BEGIN    { are critical }                     DS_StoreGlobal( DS_Init_rn, 1, rn );                  DS_InitLeaveCritical( wkmap );                  END;     { are critical }              END;     { save rn in dsam }           END;      { buy rn }             LOCKRN:            BEGIN    { lock rn }                DS_GetResElement( NSINIT_AdrOf( Lb_QRN ), 0, rn );                { If the rn is 0 assume we never got it, and don't            try to lock it.                                    }                IF rn <> 0 THEN              BEGIN    { lock the rn }              { lock the rn so everyone knows we're going down }  !            RteRNAccess( LOCLOCK + RN_NO_ABORT, rn, statreturn );  !                BEGIN    { rnrq error }                 accessresult := INITRN_ERROR;                 END;     { rnrq error }                  IF (( statreturn <> RNLOCKEDLOCALLY ) AND                                      ( accessresult = GOOD )) THEN                   BEGIN    { have error }                     accessresult := INITRN_ERROR;                 END;     { have error }              END      { lock the rn }             ELSE               BEGIN    { don't have an rn }   "            { For some reason there is no rn. Don't try to lock it,  " "            but don't stop the lock attempt.  We are trying to clean " #            up anyway.  Just return to caller.                      }  #             END;     { don't have an rn }            END;     { lock rn }             RTNRN:           BEGIN    { return rn }                DS_InitEnterCritical( wkmap, ierr );            IF ierr = GOOD THEN              BEGIN    { clear value in dsam }                  { make the value in dsam invalid }              rn := 255;              DS_StoreGlobal( DS_Init_Rn, 1, rn );              DS_InitLeaveCritical( wkmap );              END;     { clear value in dsam }               { if enter critical errors still want to return rn }            DS_RetRN( NSINIT_AdrOf( Lb_QRN ), 0, accessresult );                END;     { return rn }         UNLOCKRN:            BEGIN    { unlock rn }                DS_GetResElement( NSINIT_AdrOf( Lb_QRN ), 0, rn );                IF rn <> 0 THEN              BEGIN    { lock the rn }  $            { unlock the rn so all monitors will go to "normal state" }  $              RteRNAccess( UNLOCK + RN_NO_ABORT, rn, statreturn );                  BEGIN    { rnrq error }                 accessresult := INITRN_ERROR;                 END;     { rnrq error }                  IF (( statreturn <> SUCCESSRNUNLOCK ) AND                                      ( accessresult = GOOD )) THEN                   BEGIN    { have error }                     accessresult := INITRN_ERROR;                 END;     { have error }              END      { lock the rn }             ELSE               BEGIN    { don't have an rn }   "            { This is an internal error condition.  NSINIT allocated " &              the rn at startup.  If we don't have it now we should abort. } &             accessresult := INITRN_ERROR;               END;     { don't have an rn }                    END;     { unlock rn }             END;     { CASE }      END;     { AccessInitRN }      $ SUBTITLE 'AllocateResources', PAGE $  {------------------------------------------------------------}  {                                                            }  {              AllocateResources                             }  {                                                            }  {------------------------------------------------------------}  {}  PROCEDURE AllocateResources     (VAR ds:           DsStateType;          tot_smbsize:  Int16;          tot_dsamsize: Int32 );       {}  {  Purpose: To allocate system resources required by NS.  {   !{  Description:  The routine allocates DSAM by scheduling MMInit.  ! {  It passes MMInit values for the NS tablesize.  MMInit   {  returns an error parameter indicating if DSAM was successully   {  initialized.   {   !{  If no error is returned, the routine verifies that the state of ! {  DSAM is INIT, and that the state of DS is UNINIT.  {   {  Once DSAM is initialized, NSINIT reserves as much space in   {  labelled common as is necessary for the old services.   {  NSINIT also allocates class numbers and resource numbers for    
{  the old services. 
 {   !{  Issue: Does NSINIT need to allocate class numbers and resource  ! {  numbers for the NS services and transports, or should this   {  be left up to each protocol?   {   {  Input:   none  {  Output:  none  {  Global Variables Accessed:   {     ds:   the condition of ds   %{     the tot_resource record is used to get the amount of each resource.  % {   {  Side Effects:  {     the routine will call Cleanup if an error is discovered   {     during allocation.  {}      VAR      deallocateflag:      Boolean;     internallocresult:   Int16;     nextpos:             Int16;     returnarray:  RAType;      $ SUBTITLE 'VerifyStates (AllocateResources)', PAGE $   %{------------------------------------------------------------------------} % %{  (LOCAL)          VerifyStates              (LOCAL)                    } % %{------------------------------------------------------------------------} % 
   PROCEDURE VerifyStates  
    ( VAR msgoffset:     Int16;       VAR ierr      :     Int16 );   {}  { This procedure checks the state of DS and DSAM immediately  {  after calling MMInit.  {   {}         VAR        dscondition:      DsStateType;        dsamcondition:    DsStateType;        dsamerrorno:      Int16;        dserrorno:        Int16;        ds_stateword:     Int16;        dsam_stateword:   Int16;            BEGIN    { VerifyStates }         errorvalue := 0;            { check that dsam is initialized }         GetDSAMCondition( dsamcondition, dsamerrorno, errorvalue,    #                                                    dsam_stateword );  #       IF dsam_stateword <> ADSINITIALIZING THEN            BEGIN    { invalid DSAM state }               IF dsamcondition = DS_UNINIT THEN              BEGIN    { dsam not alloc }                   msgoffset := CBADSTATEUNINIT;               ierr := CBADSTATEUNINIT;              END      { dsam not alloc }              ELSE               BEGIN    { need to dealloc dsam }                   deallocateflag := TRUE;               msgoffset := CBADDSAMSTATE;               ierr := CBADDSAMSTATE;              END;     { need to dealloc dsam }            END      { invalid DSAM state }          ELSE           BEGIN    { check DS State }               { check that DS is not initialized }            GetDSCondition( dscondition, dserrorno, errorvalue,  "                                                    ds_stateword );  "          IF dscondition <> DS_UNINIT THEN               BEGIN    { invalid DS state }                   CheckErrorno( dserrorno, errorvalue );              msgoffset := CBADSTATE;               deallocateflag := TRUE;               END;     { invalid DS state }            END;     { check DS State }        END;     { VerifyStates }       $ SUBTITLE 'ScheduleMMInit (AllocateResources)', PAGE $   %{------------------------------------------------------------------------} % %{  (LOCAL)        ScheduleMMInit              (LOCAL)                    } % %{------------------------------------------------------------------------} %    PROCEDURE ScheduleMMInit      ( VAR ierr:    Int16;       VAR schedresult:  Int16 );          VAR        error:         Int16;         schedstring:   IStringType;         temp:          Int16;         name:         NameType;         term:          Boolean;         def:           Boolean;             BEGIN    { ScheduleMMinit }   
      progrun := 'MMINIT'; 
       name := 'MMINIT';             schedstring := 'MMINIT';  !      error := FmpRpProgram( progrun, schedstring, '   ', error ); !        IF (( error <> 0 ) AND ( error <> FMPFILEEXISTSERR )) THEN            BEGIN    { rp error }      #         MsgFilePrint( CMMINITRPERR, PMT_ERROR, error, schedresult );  # 	         BailOut;  	          END;     { rp error }            schedstring := '';  	      error := 0;  	     "      { Prepare MMinit's runstring.  MMInit expects the socket count " !        to be the socket buffer count, so multiply the socketcount ! "        by the number of sbufs/socket.  Also add the number of user  " "        record buckets to the program count to make sure we have the " #        number of user records available that he/she requested.     }  #           Strwrite( schedstring, 1, temp, 'RU,MMINIT,',               initglobals.IG_tot_nodal_sockets * SBPERSOCK, ',',              MMINITGENLINUSECL, ',', tot_dsamsize, ',',              initglobals.IG_tot_nodal_progs + NUM_UR_BUCKETS,              ',', MMSECURITY, '  ' );            { note blank pad on strwrite for pas.stringdata }             Schedule( QUEUE_W_WAIT + NOABORTBIT, name,  "               0,0,0,26182,0, ( PascalStringData( schedstring )^ ),  "                (- Strlen( schedstring ) ) );           BEGIN    { error on exec }            abreg( a_reg, b_reg );            error := -99;               END;     { error on exec }             Rmpar( returnarray );       
      message := ''; 
           IF error <> 0 THEN           BEGIN    { Sched Error }                { tell user what a & b are after bad sched call }           Strwrite( message, 1, temp, INITMSG[CMMSCHEDERR],                                 a_reg, b_reg, '.***' );           PrintError( message, schedresult );  	         BailOut;  	              END      { Sched Error }           ELSE           BEGIN    { MMInit sched ok }                ierr := returnarray[1];           schedresult := GOOD;                IF ierr = RTESCHEDERROR THEN               BEGIN    { sched problem }      $            MsgFilePrint( CMMSCHEDPROB, PMT_ERROR, ierr, schedresult );  $ 
            BailOut; 
             END;     { sched problem }               END;     { MMInit sched ok }             END;     { ScheduleMMInit }       $ SUBTITLE 'CheckIerr (AllocateResources)', PAGE $  %{------------------------------------------------------------------------} % %{  (LOCAL)          CheckIerr                 (LOCAL)                    } % %{------------------------------------------------------------------------} %    PROCEDURE CheckIerr     (     ierr:     Int16 );       {}  {  This routine checks the error return from MMInit.  "{  If MMInit returns no error, the states of DSAM and DS are tested. " {   {}     VAR        msgoffset:     Int16;             BEGIN       { CheckIerr }             msgoffset := 0;         deallocateflag := FALSE;      	      CASE ierr OF 	          GOOD:              BEGIN    { GOOD }                    { MMInit says dsam initialized, check the states of    !              DS and DSAM to be sure.                           }  !                 VerifyStates( msgoffset, ierr );                  { routine will set msgoffset to error message, and                 deallocate flag if appropriate.  If no error, both   !              should stay as before.                            }  !                 END;     { GOOD }                MMOUTOFMEMORY:               BEGIN    { MMOUTOFMEMORY }              { Too much DSAM requested, but under normal                 circumstances the request could be granted. }                   msgoffset := CMMBADSHEMASZ;               END;     { MMOUTOFMEMORY }               MMDSAMALLOC:               BEGIN    { MMDSAMALLOC }              { Error setting up DSAM.  Probably SHEMA error }                  msgoffset := CMMPALCERR;               { DSAM was allocated, but is bad. Need to cleanup }                deallocateflag := TRUE;                   END;     { MMDSAMALLOC }               MMBADSECURITY:               BEGIN    { MMBADSECURITY }              { DSAM allocation routine received invalid                security code from MMInit, which probably                 means NSINIT sent a bad SC.  Coding Error }                   msgoffset := CMMSECERR;               END;     { MMBADSECURITY }      
         MMDSAMINIT: 
             BEGIN    { MMDSAMINIT }               { DSAM already initialized.  This is a problem.               NSINIT checked the state of DS immediately prior              to the allocation call.  DS in wierd state. }                   msgoffset := CDSAMUPERR;              deallocateflag := TRUE;               END;     { MMDSAMINIT }       
         MMDSAMCORRUPTPE:  
             BEGIN    { MMDSAMCORRUPT }  !            { DSAM allocated, but it is corrupt. Internal Error. } !                 msgoffset := CDSAMPE;               deallocateflag := TRUE;                   END;     { MMDSAMCORRUPT }               MMBADMINCLNUM:               BEGIN    { MMBADMINCLNUM }              { currently minclnum is defaulted, so this is                  an internal error.  If minclnum is ever passed to                  MMIinit, the meaning of this error will change.  }                    msgoffset := CMMBADCL;                  END;     { MMBADMINCLNUM }               MMBADTABLESIZE:              BEGIN    { MMBADTABLESIZE }               { The tablesize passed to MMInit is <0.                 This is a coding error.               }                   msgoffset := CMMBADTB;              END;     { MMBADTABLESIZE }                    MMSTATICTOOBIG:              BEGIN    { MMSTATICTOOBIG }   !            { The size of the static tables is too big. Currently  !               there are limits on everything that can encroach                on the static stuff.  This makes this error a                  coding bug.  If we ever change the way this works    "              this error should change too.                       }  "                 msgoffset := CMMBADGL;                  END;     { MMSTATICTOOBIG }       
         MMIMPOSSIBLERQST: 
             BEGIN    { MMIMPOSSSIBLERQST }  !            { The total amount of DSAM requested is > 2 megabytes. ! "              The user must lessen the total memory requirements.  } "                 msgoffset := CMMTOOMUCH;                  END;     { MMIMPOSSSIBLERQST }               MMPALCERROR:               BEGIN    { MMPALCERROR }  !            { DS_SetUpDSAM found an error with the SHEMA- the size ! "              is less than the size requested.  PALC did not return  " #              an error, but still have troubles.  Coding Error.     }  #                 msgoffset := CMMSHEMAERR;               deallocateflag := TRUE;                   END;     { MMPALCERROR }               MMINITECATCHR:               BEGIN    { Hit MMInit's error catcher }               msgoffset := CMMERRCATCH;               END;     { Hit MMInit's error catcher }       
         MMNOCRITRN: 
             BEGIN    { No Criticality RN }              msgoffset := CMMNORN;               END;     { No Criticality RN }      	         OTHERWISE 	             BEGIN    { Otherwise }              { Invalid return from MMInit. Internal Error. }                   msgoffset := CMMINTPARMERR;                   END;     { Otherwise }                END;     { CASE }             IF msgoffset <> 0 THEN           BEGIN             { encountered error }      "         MsgFilePrint( msgoffset, PMT_ERROR, 0, internallocresult ); "          IF internallocresult <> GOOD THEN BailOut;            END;              { encountered error }            IF returnarray[2] <> 0 THEN            BEGIN    { tell user shema size }               MsgFilePrint( CSHEMANEED, PMT_ERROR,  returnarray[2],  #                                                  internallocresult ); #          IF internallocresult <> GOOD THEN BailOut;                END;     { tell user shema size }            IF deallocateflag THEN           BEGIN    { deallocate DSAM & term. }       %         MsgFilePrint( CATTEMPTDEALLOC, PMT_ERROR, 0, internallocresult ); %          { ignore print errors }               { Try to deallocate DSAM and terminate }            DeAllocateDSAM( -3);                END      { deallocate DSAM & term. }           ELSE IF ierr <> 0 THEN           BEGIN    { error, need to quit }       	         BailOut;  	          END;     { error, need to quit }             IF returnarray[3] <> 17491 {DS} THEN           BEGIN    { wrong MMInit }                { improper security code; wrong MMInit was scheduled }    "         MsgFilePrint( CMMSECERR, PMT_ERROR, 0, internallocresult ); "     	         BailOut;  	          END;     { wrong MMInit }        END;        { CheckIerr }       $ SUBTITLE 'AllocDSAM (AllocateResources)', PAGE $  %{------------------------------------------------------------------------} % %{  (LOCAL)        AllocDSAM                   (LOCAL)                    } % %{------------------------------------------------------------------------} %    PROCEDURE AllocDSAM;       {}   {  This routine calls ScheduleMMInit to allocate DSAM.  It then    {  calls CheckIerr if no errors occurred during the schedule.   {   {}     VAR        ierr:                Int16;             BEGIN    { AllocDSAM }            { This routine schedules MMInit with proper parms. }        ScheduleMMInit( ierr, internallocresult );            IF internallocresult = GOOD THEN           BEGIN    { check MMInit error return }                { This routine will handle all error conditions.              Control will be returned if no error was found. }           CheckIerr( ierr );                END;     { check MMInit error return }         END;     { AllocDSAM }      $ SUBTITLE 'AllocateResources', PAGE $     BEGIN    { AllocateResources }          internallocresult := GOOD;       
   IF ds = DS_UNINIT THEN  
       BEGIN    { allocate dsam/resources }            AllocDSAM;        { Subroutine will exit if an error occurs. }            { allocate resources for old services if neccesary }        IF tot_smbsize <> 0 THEN           BEGIN    { allocate smb }               AllocateSMB( tot_smbsize, internallocresult );            CheckResult( internallocresult );           IF internallocresult <> GOOD THEN              BEGIN    { deallocate dsam }                  DeallocateDSAM(-4);               { subroutine will exit }              END;     { deallocate dsam }           END;     { allocate smb }        END      { allocate dsam/resources }       ELSE         BEGIN    { internal state error }             internallocresult := GOOD;  #      MsgFilePrint( CINVSTATESTART, PMT_ERROR, 0, internallocresult ); #       CheckResult( internallocresult );             { always bail out here }        BailOut;            END;     { internal state error }          { This procedure will have to allocate DSAM, allocate sam        and allocate the class numbers, resource numbers, etc         for the old services.          It will call cleanup if an error occurs.  It is responsible      for keeping track of what resources it has allocated so they        can be cleaned up on error conditions.                      }          END;     { AllocateResources }       $ SUBTITLE 'ChangeStateWords', PAGE $   %{------------------------------------------------------------------------} % %{                                                                        } % %{                     ChangeStateWords                                   } % %{                                                                        } % %{------------------------------------------------------------------------} %     
PROCEDURE ChangeStateWords 
    (     whichdsword:   DSWordType;            exitonerror:   Boolean;           newvalue:      Int16;       VAR ierr:          Int16 );  !   { change the value of DS_InitProtoSeg or DS_StateOfDS in DSAM } ! {}   {  Change the NS state words in dsam to the passed values.  Also   {  change the state word of NS in the OS if necessary.  {   {}  VAR      tempvar:    Int16;          BEGIN    { ChangeStateWords }         DS_InitEnterCritical( wkmap, ierr );       
   IF ierr = 0 THEN  
       BEGIN    { are critical }         IF whichdsword = PROTOSEGWORD THEN           BEGIN    { change proto seg }               DS_StoreGlobal( DS_InitProtoSeg, 1, newvalue );               END      { change proto seg }          ELSE           BEGIN    { change state word }   
         CASE newvalue OF  
 
            DSINIT_START:  
                BEGIN    { start }                  END;     { start }                   DSINIT_INIT:                 BEGIN    { init }                     tempvar := 0;                 DS_StoreGlobal( DS_InitProtoSeg, 1, tempvar );                      END;     { init }                  DSINIT_SHUT:                 BEGIN    { shut }      !               { For shutdown only change the DSINIT state words.  !                   The state of DSAM will be changed after we shut   !                 down the INPRO and OUTPRO.                      } !                    END;     { shut }      
            DSINIT_UNINIT: 
                BEGIN    { uninit }                     tempvar := 0;                 DS_StoreGlobal( DS_InitProtoSeg, 1, tempvar );                  END;     { uninit }                  OTHERWISE                  BEGIN    { undefined state }                  BailOut;                  END;     { undefined state }       
            END;  { CASE } 
              DS_StoreGlobal( DS_StateOfDS, 1, newvalue );                END;     { change state word }             DS_InitLeaveCritical( wkmap );            END      { are critical }        ELSE         BEGIN    { have a problem }             MsgFilePrint( CBADCRIT, PMT_ERROR, ierr, tempvar );         { ignore errors on print, bailing out anyway. }             ierr := ERR_ALREADY_PRINTED;      
      IF exitonerror THEN  
          BEGIN    { tell user giving up }                MsgFilePrint( CCRITABORT, PMT_ERROR, 0, tempvar );   	         BailOut;  	          END;     { tell user giving up }         END;     { have a problem }          END;     { ChangeStateWords }      $ SUBTITLE 'CheckErrorno', PAGE $   {------------------------------------------------------------}  {                                                            }  {                    CheckErrorno                            }  {                                                            }  {------------------------------------------------------------}  {}  PROCEDURE CheckErrorno    (     errorno:        Int16;          errorvalue:  Int16 );   {}  !{  Purpose: To print an error found while checking the state words ! 	{  of DS and DSAM. 	 {   {   #{  The errorvalue variable holds the numeric value for the state word  # {  that caused the error condition.   {   #{  Input:   errorno     Index into the array of state error constants  # !{               errorno  =0 then there is no error to be printed.  ! &{                        >0 the StateErrorCONST[errorno] should be printed.  & "{                        <0 then stringfornumb should be appended to " #{                             StateErrorCONST[ -errorno] and printed.  # {   "{           errorvalue  value of the integer that caused the error.  " {   {  Output:  none  {   {  Global Variables accessed:  StateErrorCONST.   {   {  Routines called:  PrintError, CheckResult.   {   {}      VAR      dummy:            Int16;      internal_result:  Int16;          BEGIN    { CheckErrorno }         internal_result := GOOD;       
   IF errorno <> NONE THEN 
       IF errorno <> ERR_ALREADY_PRINTED THEN           BEGIN    { have error }  %         { print the error, appending the numeric value when appropriate } %     %         MsgFilePrint( errorno, PMT_ERROR, errorvalue, internal_result );  %          IF internal_result <> GOOD THEN BailOut;            END;     { have error }         END;     { CheckErrorno }      $ SUBTITLE 'CheckShutConditions', PAGE $  {------------------------------------------------------------}  {                                                            }  {              CheckShutConditions                           }  {                                                            }  {------------------------------------------------------------}  PROCEDURE CheckShutConditions     (VAR ds:           DsStateType;      VAR ds_stateword: Int16;      VAR goodresponse: Boolean;      VAR passedresult:       Int16 );       {}  {  Purpose: To check the operating conditions for a Shut down.  {   	{  Input:    none  	 {    {  Output:  ds-           The state of DS (INIT,UNINIT,or SICK)    {           ds_stateword- The value of StateOfDS in DSAM.   {           goodresponse- TRUE if ds is INIT, FALSE otherwise   {           passedresult:       <>0 If error, 0 otherwise   {   {  Global Variables Accessed: message   {  Routines Called: EnvironmentOk, GetStateOfDS, CheckErrorno,  {     PrintError, CheckResult.  {   {  Description: The routine checks the operating environment.   #{  If the environment is ok, the routine finds out if DS is in a state # #{  that allows it to be shut down.  DSAM must be INIT or LAME, DS must # %{  be INIT.  If these conditions are met the routine returns goodresponse  % {  TRUE.  If not, it returns FALSE.   {   {}          VAR      dserrorno:           Int16;     dsamerrorno:         Int16;     internal_result:     Int16;     errorvalue:       Int16;          BEGIN    { CheckShutConditions }          internal_result := GOOD;          { check that operating environment is ok }      IF EnvironmentOk THEN        BEGIN    { ok }         { Operating conditions ok, check DS conditions }            GetStateOfDS( ds, dsamerrorno, dserrorno, errorvalue,                     ds_stateword );         CheckErrorno( dsamerrorno, errorvalue );        CheckErrorno( dserrorno, errorvalue );            CASE ds OF  	         DS_INIT:  	             BEGIN    { init }               goodresponse := TRUE;               END;     { init }       	         DS_SICK:  	             BEGIN    { sick }                PrintError( INITMSG[CADVISESHUT], internal_result );               CheckResult( internal_result );               IF internal_result <> GOOD THEN BailOut;                  goodresponse := TRUE;               END;     { sick }       
         DS_UNINIT:  
             BEGIN    { uninit }   $            MsgFilePrint( CNOTINITSHUT, PMT_ERROR, 0, internal_result ); $             CheckResult( internal_result );               IF internal_result <> GOOD THEN BailOut;                  IF NOT initglobals.IG_interactive THEN                 BEGIN       { non-interactive }                 internal_result := ERRUSERINPUT;                  END;        { non-interactive }                  { If interactive user will enter new action }               END;     { uninit }   	         OTHERWISE 	             BEGIN    { state error }              internal_result := GOOD;  $            MsgFilePrint( CDSSTATEERR, PMT_ERROR, 0, internal_result );  $             CheckResult( internal_result );               IF internal_result <> GOOD THEN BailOut;                  internal_result := ERR_ALREADY_PRINTED;                   END;     { state error }      
         END;     { CASE } 
       END      { ok }        ELSE   
      BEGIN    { NOT ok }  
           { operating conditions not ok.  Terminate. }        internal_result := ERR_ALREADY_PRINTED;   
      END;     { NOT ok }  
        passedresult := internal_result;          END;     { CheckShutConditions }       $ SUBTITLE 'CheckStartConditions', PAGE $   {------------------------------------------------------------}  {                                                            }  {             CheckStartConditions                           }  {                                                            }  {------------------------------------------------------------}  PROCEDURE CheckStartConditions    (VAR ds:           DsStateType;      VAR goodresponse: Boolean;      VAR passedresult:       Int16 );   {}  { Purpose: To check the start up environment.   {   {  Input:   none  {  Output:     ds-          The state of DS (INIT,UNINIT,SICK)  {              goodresponse-TRUE if the environment is ok and   {                           DS is UNINIT.   {              result-      <>0 If error, 0 Otherwise   {   {  Global Variables Accessed: message   {  Routines Called: EnvironmentOk, GetStateOfDS, CheckErrorno,  {     PrintError, CheckResult.  {   %{  Description: Check the operating environment by calling EnvironmentOk.  % "{  If the environment is ok, verify that the state of DS is UNINIT.  " #{  If it is is then return goodresponse TRUE.  Otherwise return FALSE. # {   {}      VAR      dsamerrorno:         Int16;     dserrorno:           Int16;     ds_stateword:        Int16;     internal_result:     Int16;     errorvalue:       Int16;          BEGIN    { CheckStartConditions }         internal_result := GOOD;          { check that operating environment is ok }      IF EnvironmentOk THEN        BEGIN    { ok }             { Operating conditions ok.  Check DS condition }        GetStateOfDS( ds, dsamerrorno, dserrorno, errorvalue,                      ds_stateword );        CheckErrorno( dsamerrorno, errorvalue );        CheckErrorno( dserrorno, errorvalue );            CASE ds OF  
         DS_UNINIT:  
             BEGIN    { uninit }               goodresponse := TRUE;               END;     { uninit }       	         DS_SICK,  	 	         DS_INIT:  	             BEGIN    { Sick/Init }                  IF ds = DS_SICK THEN                 BEGIN    { ds partially up }                  errorvalue := CPARTUPSTART;                 END      { ds partially up }   	              ELSE 	                BEGIN    { ds up }                  errorvalue := CUPSTART;                 END;     { ds up }       #            MsgFilePrint( errorvalue, PMT_ERROR, 0, internal_result ); #             IF internal_result <> GOOD THEN BailOut;                  IF NOT initglobals.IG_interactive THEN                 BEGIN    { not-interactive }                  internal_result := ERRUSERINPUT;                  END;     { not-interactive }                   { If interactive, user will be reprompted. }              END;     { Sick/Init }      	         OTHERWISE 	             BEGIN    { state error }              internal_result := GOOD;      $            MsgFilePrint( CDSSTATEERR, PMT_ERROR, 0, internal_result );  $             CheckResult( internal_result );               IF internal_result <> GOOD THEN BailOut;                  internal_result := ERR_ALREADY_PRINTED;               END;     { state error }      
         END;     { CASE } 
       END      { ok }        ELSE   
      BEGIN    { NOT ok }  
           internal_result := ERR_ALREADY_PRINTED;   
      END;     { NOT ok }  
         passedresult := internal_result;         END;     { CheckStartConditions }      $ SUBTITLE 'DeAllocateDSAM', PAGE $   %{------------------------------------------------------------------------} % %{                                                                        } % %{                      DeAllocateDSAM                                    } % %{                                                                        } % %{------------------------------------------------------------------------} %     PROCEDURE DeAllocateDSAM     (     halt_value:    Int16 );      VAR      ierr:             Int16;      internal_result:  Int16;      msgoffset:        Int16;      param:            Int32;          BEGIN    { DeAllocateDSAM }     { This routine is responsible for de-allocating DSAM.  It      should print a "good deallocation " message when it is done.        It should then terminate the program.                       }       	   msgoffset := 0; 	        DS_DeallocDSAM( MMSECURITY, param, ierr );          CASE ierr OF         GOOD,         MMDSAMCORRUPTPE,  	      MMBADCRITRN: 	          BEGIN    { dsam deallocated }               IF ierr <> GOOD THEN               BEGIN    { parity error }               IF ierr = MMBADCRITRN THEN msgoffset := CMMBADRN             ELSE msgoffset := CPARITYWARN;       #            MsgFilePrint( msgoffset, PMT_ERROR, 0, internal_result );  #             msgoffset := 0;               IF internal_result <> GOOD THEN BailOut;                  END;     { parity error }                IF halt_value = 0 THEN               BEGIN    { tell user we're done }       !            PrintError( INITMSG[CDSAMDEALLOK], internal_result );  !             { ignore errors, we are done anyway }               END;     { tell user we're done }                END;     { dsam deallocated }      
      MMDSAMDEALLOC: 
          BEGIN    { problem deallocating }           msgoffset := CDSAMDEALLERR;           END;     { problem deallocating }      
      MMDSAMUNINIT:  
          BEGIN    { dsam uninit }            msgoffset := CDSAMNODEALLNOTALL;            END;     { dsam uninit }       
      MMBADSECURITY: 
          BEGIN    { bad sec code }           msgoffset := CINVSECCODE;           END;     { bad sec code }            OTHERWISE            BEGIN    { invalid return }           msgoffset := CMMINTPARMERR;           END;     { invalid return }            END;     { CASE }       
   IF msgoffset <> 0 THEN  
       BEGIN    { build error message }             MsgFilePrint( msgoffset, PMT_ERROR, 0, internal_result );          IF internal_result <> GOOD THEN BailOut;      !      { Change the halt value to report that NSINIT had a problem  !          cleaning up.  Don't change the value if we were already    "        reporting an error from a level below.                    }  "       IF halt_value = 0 THEN halt_value := 2;         END;     { print error }         KillChildren;     Halt( halt_value );         END;     { DeAllocateDSAM }      $ SUBTITLE 'EnvironmentOk', PAGE $  {------------------------------------------------------------}  {                                                            }  {                   EnvironmentOk                            }  {                                                            }  {------------------------------------------------------------}  {}  FUNCTION EnvironmentOk:  Boolean;       {}  {  This routine checks the operating environment for NSINIT.  {  It checks that the user running the program is a SuperUser,  {  that the program name is DSINI, and that the program was   {  loaded as a SystemUtility.   {   %{  The routine is called by CheckStartConditions and CheckShutConditions.  % !{  Note that the operating environment is NOT checked if the user  ! {  only wishes to build an output file.   {   {  Input:   none  !{  Output:  Boolean Functional Return: TRUE if environment is OK,  ! {           FALSE otherwise.  {   {  Global Variables Accessed: message    {  Routines Called: RTE routines: MyIdAddr (Alias MyIDSegAddr),    {     IdAdToName (Alias FindMyProgName), SystemProcess.   {   {                  NS routines: PrintError, CheckResult.  {}      VAR      dummylu:             Int16;     errnumber:           Int16;     idsegaddr:           Int16;     internal_result:     Int16;     progname:            PNameType;     systemutility:       Int16;         BEGIN    { EnvironmentOk }       
   EnvironmentOk := TRUE;  
 	   errnumber := 0; 	        { Get the program's ID segment Address }      idsegaddr := MyIDSegAddr;         { Check the program name is 'NSINI' }     FindMyProgName( idsegaddr, progname, dummylu );     IF progname <> 'NSINI' THEN        BEGIN       { NOT dsini }         errnumber := CNOCLONE;        EnvironmentOk := FALSE;         END         { NOT dsini }        ELSE         BEGIN          { Check SU }             { Find out if prog is a System Utility }        systemutility := SystemProcess( idsegaddr );        IF systemutility >0 THEN           BEGIN             { NOT su }            errnumber := CNOTSU;            EnvironmentOk := FALSE;           END;              { NOT su }             END;           { Check SU }       
   IF errnumber <> 0 THEN  
       BEGIN    { print error }             MsgFilePrint( errnumber, PMT_ERROR, 0, internal_result );          IF internal_result <> GOOD THEN BailOut;            END;     { print error }     END;     { EnvironmentOk }       $ SUBTITLE 'FetchStateWords', PAGE $  %{------------------------------------------------------------------------} % %{                                                                        } % %{                      FetchStateWords                                   } % %{                                                                        } % %{------------------------------------------------------------------------} %     
PROCEDURE FetchStateWords  
    (     whichdsword:   DSWordType;            exitonerror:   Boolean;       VAR value:         Int16;       VAR ierr:          Int16 );  !   { change the value of DS_InitProtoSeg or DS_StateOfDS in DSAM } !     VAR      internal_result:     Int16;         BEGIN    { FetchStateWords }          DS_InitEnterCritical( wkmap, ierr );       
   IF ierr = 0 THEN  
       BEGIN    { are critical }         IF whichdsword = PROTOSEGWORD THEN           BEGIN    { fetch proto word }           DS_FetchGlobal( DS_InitProtoSeg, 1, value );            END      { fetch proto word }          ELSE           BEGIN    { fetch init state word }            DS_FetchGlobal( DS_StateOfDS, 1, value );           END;     { fetch init state word }             DS_InitLeaveCritical( wkmap );            END      { are critical }        ELSE         BEGIN    { have problem }   !      MsgFilePrint( CBADCRIT, PMT_ERROR, ierr, internal_result );  !       { Ignore errors on print, leaving anyway }            ierr := ERR_ALREADY_PRINTED;      
      IF exitonerror THEN  
          BEGIN    { tell user giving up }   "         MsgFilePrint( CCRITABORT, PMT_ERROR, 0, internal_result );  " 	         BailOut;  	          END;     { tell user giving up }         END;     { have problem }       !   { If get an error on enter critical call, return it to caller } !        END;     { FetchStateWords }       $ SUBTITLE 'GetDSCondition', PAGE $   %{------------------------------------------------------------------------} % %{                                                                        } % %{                      GetDSCondition                                    } % %{                                                                        } % %{------------------------------------------------------------------------} %     PROCEDURE GetDSCondition  ( VAR dscondition:   DsStateType;     VAR dserrorno:     Int16;     VAR errorvalue:    Int16;     VAR ds_stateword:  Int16 );       {}  "{ Purpose: To translate the two ds state words into dscondition with " {  an error qualifier.  {   {  Input:   none  {  Output:  dscondition- INIT,UNINIT or SICK   {           dserrorno-   contains the index into StateErrorCONST   "{           ds_stateword-contains the actual value in DS_StateOfDS.  " {   {  Global Variables Accessed: DSAM state words for NSINIT.  {  routines called: FetchStateWords   {   {  Description: This routine gets the value in DS_StateOfDS.  #{  The actual value is returned to the caller in ds_stateword, but it  # {  is also interpreted for the caller.  {   "{  If the value is INIT or UNINIT, the routine returns those values  " {  to the caller as dscondition.  {   "{  If the value is STARTING or SHUTTING, the routine assumes NSINIT  " #{  was previously aborted, and returns SICK, with an index pointing to # {  the proper error message in StateErrorCONST.   {   #{  If the value is not defined, the routine returns an index pointing  #  {  to this error message in StateErrorCONST. The actual value in   "{  ds_stateword, which the caller can use to construct a meaningful  " 	{  error message.  	 {   {}  LABEL      99;      VAR      current_seg:      Int16;      ierr:             Int16;          BEGIN    { GetDSCondition }     ierr := 0;              { get state of DS from global table in DSAM }      FetchStatewords( INITSTATEWORD, FALSE, ds_stateword, ierr );        { FALSE indicates not to exit on error accessing stateword. }   
   IF ierr <> 0 THEN 
       BEGIN    { error accessing state word }             dserrorno := ierr;        dscondition := DS_SICK;         GOTO 99;        END;     { error accessing state word }              dserrorno := NONE;      errorvalue := NONE;         CASE ds_stateword OF       	      DSINIT_INIT: 	 
         BEGIN    { init } 
     "         FetchStatewords( PROTOSEGWORD, FALSE, current_seg, ierr );  " #         { FALSE indicates not to exit if error getting state word. }  # 
         IF ierr = 0 THEN  
             BEGIN    { have state word }              IF current_seg = 0 THEN                  BEGIN    { ds up }                      dscondition := DS_INIT;                 END      { ds up }   	              ELSE 	                BEGIN    { seg wrong }                      dscondition := DS_SICK;                     { make errorno indicate to use errorvalue }                 dserrorno := SECI_DSPSEG;                 errorvalue := current_seg;                  END;     { seg wrong }               END      { have state word }            ELSE              BEGIN    { error getting state word }                   dserrorno := ierr;              dscondition := DS_SICK;               END;     { error getting state word }   
         END;     { init } 
     
      DSINIT_UNINIT: 
          BEGIN    { uninit }               dscondition := DS_UNINIT;               END;     { uninit }      
      DSINIT_START:  
          BEGIN    { starting }           { NSINIT must have been aborted while starting up.              Do shutdown.  Tell user what's going on.         }                dscondition := DS_SICK;           dserrorno := SECI_DSSTART;                END;     { starting }      	      DSINIT_SHUT: 	          BEGIN    { any shut }               dscondition := DS_SICK;           dserrorno := SECI_DSSHUT;               END;     { any shut }            OTHERWISE            BEGIN    { otherwise }            { invalid state for DS. }               dscondition := DS_SICK;           { use negative to indicate to use errorvalue }            dserrorno := SECI_DSSTATE;            errorvalue := ds_stateword;               END;     { otherwise }         END;     { case }   99:          END;     { GetDSCondition }      $ SUBTITLE 'GetDSAMCondition', PAGE $   %{------------------------------------------------------------------------} % %{                                                                        } % %{                     GetDSAMCondition                                   } % %{                                                                        } % %{------------------------------------------------------------------------} %     
PROCEDURE GetDSAMCondition 
 ( VAR dsamcondition:    DsStateType;    VAR dsamerrorno:      Int16;    VAR errorvalue:       Int16;    VAR dsam_stateword:   Int16 );          {}  !{ Purpose: To translate the value returned by DS_StateOfDSAM into  ! {  dsamcondition with an error qualifier.   {   {  Input:   none  {  Output:  dsamcondition- INIT,UNINIT, SICK, or LAME   !{           dsamerrorno-   contains the index into StateErrorCONST ! ${           dsam_stateword-contains the actual value in DS_StateOfDSAM.  $ {   {  Global Variables Accessed: none  {  Routines Called: DS_StateOfDSAM.   {   {  Description: This routine gets the value in DS_StateOfDSAM.  ${  The actual value is returned to the caller in dsam_stateword, but it  $ {  is also interpreted for the caller.  {   "{  If the value is INIT or UNINIT, the routine returns those values  " {  to the caller as dsamcondition.  {   {  If the value is MBUF_PARITY, the routine assumes   &{  dsam has some error, but can still function.  For this reason it returns  & "{  LAME, with an index in dsamerrorno to the proper error message in " 
{  StateErrorCONST.  
 {   %{  If the value indicates any other condition or one which is not defined, % !{  the routine returns an index pointing to the appropriate error  ! !{  message in StateErrorCONST. The actual value in dsam_stateword, ! "{  which the caller can use to construct a meaningful error message. " {   {}     BEGIN    { GetDSAMCondition }         dsamerrorno := NONE;      errorvalue := NONE;         { Assume dsam is initialized.  CASE will clear flag for        EnterCritical calls if dsam is not initialized.      }         { call MM routine for state of DSAM in vector }     dsam_stateword := DS_StateOfDSAM;          
   CASE dsam_stateword OF  
           ADSUNINIT:           BEGIN    { uninit }           { DSAM uninitialized; return ds not up }                dsamcondition := DS_UNINIT;               END;     { uninit }            ADSINIT:  
         BEGIN    { init } 
          { DSAM initialized, check if DS is up }               dsamcondition := DS_INIT;      
         END;     { init } 
           ADSINITIALIZING:           BEGIN    { partial_init }           { DS is partially init.  This means DSAM init, but DS              is not fully up.                                    }                dsamcondition := DS_SICK;           dsamerrorno := SECI_PARTIN;               END;     { partial_init }      
      DSAMPECLMBUFS: 
          BEGIN    { mbuf_parity }            { set up message to tell user parity error in mbufs }               dsamcondition := DS_LAME;           dsamerrorno := SECI_MBPAR;                END;     { mbuf_parity }       
      DSAMPEGLOBALS: 
          BEGIN   { global_parity }            { set up message to tell user parity error in globals }                dsamcondition := DS_SICK;           dsamerrorno := SECI_GLBPAR;               END;    { global_parity }      
      DSAMPETABLES:  
          BEGIN   { table_parity }   "         { set up message to tell user parity error in the tables }  "              dsamcondition := DS_SICK;           dsamerrorno := SECI_TBLPAR;               END;    { table_parity }             OTHERWISE            BEGIN    { otherwise }   
         { invalid state } 
              dsamcondition := DS_SICK;           { indicate to print current value of state of dsam }            dsamerrorno := SECI_DSAMSTATE;            errorvalue := dsam_stateword;               END;     { otherwise }       
      END;  { CASE } 
    END;     { GetDSAMCondition }      $ SUBTITLE 'GetStateOfDS', PAGE $   %{------------------------------------------------------------------------} % %{                                                                        } % %{                    GetStateOfDS                                        } % %{                                                                        } % %{------------------------------------------------------------------------} % PROCEDURE GetStateOfDS    (VAR ds:              DsStateType;     VAR dsamerrorno:     Int16;     VAR dserrorno:       Int16;     VAR errorvalue:   Int16;      VAR ds_stateword:    Int16 );      {}  "{  Purpose: the routine is responsible for checking the DS and DSAM  " "{  state words.  It then returns ds; the state of ds in the system.  "  {  The routine is meant to be general purpose to be used by any    {  routine wanting to know the state of ds.   {   {  Input:   none  !{  Output:  ds-            The state of ds (INIT,UNINIT, or SICK ) ! {   #{           dsamerrorno-   An index into StateErrorCONST for any dsam  # {                              state word errors  {   "{           dserrorno-     An index into StateErrorCONST for any ds  " {                              state word errors  {   "{           errorvalue-    Used to store the value of the state word " {                              that was found to be in error.   {   #{           ds_stateword:  The integer representation of DS_StateOfDS. # {    {  Global Variables Accessed: the current segment word in DSAM.    {  Routines Called: GetDSCondition, GetDSAMCondition.   {   {  This routine translates the results from GetDSCondition and  !{  GetDSAM condition into one state word and two error qualifiers. ! %{  GetDSCondition is only called if GetDSAMCondition returns INIT or LAME. % {   {}      VAR      dsamcondition:    DsStateType;      dscondition:      DsStateType;      dsam_stateword:   Int16;      ierr:             Int16;      nxtpos:           Int16;          BEGIN    { GetStateOfDS }         dsamerrorno := NONE;      dserrorno := NONE;   
   errorvalue := 0;  
         { dsamcondition will be either: init,uninit, sick, or lame. }      GetDSAMCondition( dsamcondition, dsamerrorno, errorvalue,  #                                                     dsam_stateword ); #     "   { assume ds is in same condition as dsam, we will check this with " #      GetDSCondition call and correct ds variable if necessary.     }  #    ds := dsamcondition;      IF (( ds = DS_INIT ) OR ( ds = DS_LAME ) OR                ( dsam_stateword = ADSINITIALIZING )) THEN        BEGIN    { need to check ds state word }            GetDSCondition( dscondition, dserrorno, errorvalue,   #                                                      ds_stateword );  #           IF dsam_stateword <> ADSINITIALIZING THEN            BEGIN    { make internal state match ds state word }       "         { Assume ds is in same state as ds state word indicates. }  "          ds := dscondition;            END;     { make internal state match ds state word }             IF ds = DS_UNINIT THEN           BEGIN    { ds in invalid state }                ds := DS_SICK;            dserrorno := SECI_INDISCR;                END;     { ds in invalid state }         END;     { need to check ds state word }         END;     { GetStateOfDS }      $ SUBTITLE 'MarkDsamUp', PAGE $   
PROCEDURE MarkDsamUp 
 ( VAR markresult:      Int16 );       VAR      temp:       Int16;          BEGIN { MarkDsamUp }          markresult := GOOD;      { Change the state of DSAM to init so INPRO will be ready to    !     receive link up messages from the link initializations.     } ! 
   temp := ADSINIT;  
    DS_SetDSAMState( temp );          { Unlock the initialization rn so all the monitors        will wake up and get going. }     AccessInitRN( UNLOCKRN, markresult );     CheckResult( markresult );      IF markresult = GOOD THEN        BEGIN    { wait for monitors to wake }            WaitASec( EXEC12, 0, SECS, ONCE, ONESEC );           BEGIN    { exec error }  
         { ignore errors } 
          END;     { exec error }        END;     { wait for monitors to wake }     END;  { MarkDsamUp }       END        { module initstate }   .  