 $PASCAL '91790-1X085 REV.4010 <860317.0943> '       $ TITLE 'initmulti Routines'$   $ STANDARD_LEVEL'HP1000', RECURSIVE OFF, RANGE OFF, HEAP 0  $   $ DEBUG $   $ CODE_INFO on      	MODULE initmulti;  	 
$ALIAS 'N$initmulti' 
     {------------------------------------------------------------        (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986. ALL RIGHTS    RESERVED. NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,   REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT    THE PRIOR WRITTEN CONSENT OF THE HEWLETT-PACKARD COMPANY.       ------------------------------------------------------------}      {}  {      NAME: init_mmult   {    SOURCE: 91790-18085  	{     RELOC: NONE  	 {      PGMR: EMS  {}      {}  {------------------------------------------------------------   { MODIFICATIONS:  {   {  Date  Prgmr  Description   !{  850610   lms  have each protocol program sit on its own class.  ! {  860110   lms  NSINIT coalescence (N345).   {  860317   lms  Delete TEXT var (N370).  {------------------------------------------------------------   {}      {}  { PROGRAM DESCRIPTION:  {   {}          IMPORT         { basic memory manager declarations }  $ SEARCH 'phtm/bodec.rel' $      bodec,          { basic initialization declarations. }   $ SEARCH 'phtm/init_dec.rel' $     init_dec;      $ SUBTITLE 'Exported Constants ', PAGE $  EXPORT      CONST       "   { offsets into the multiprogramming arrays: for program names and " !     and class numbers. The names are for protos and parser.  The  ! "     classes are for protos, parser, and nsinit.                   } " 	   PROTO1PROG = 1; 	 	   PROTO2PROG = 2; 	 	   PARSERPROG = 3; 	 	   MP_NSINIT = 4;  	     "   { Set up constants for the multiprogramming program name array }  "    FIRSTMP_PROG = PROTO1PROG;      LASTMP_PROG = MP_NSINIT;          { Class numbers are necessary for all protocol programs,        the parser, and NSINIT.  Set up constants for the       multiprogramming class number array                     }     FIRSTMP_CLASS = FIRSTMP_PROG;     LASTMP_CLASS = MP_NSINIT;         { length of multiprocessing error buffer:       2 words for A&B Regs, 1 for offset into error buffer. }  
   MultiErrorTypeLen = 3;  
         TYPE     { used to handle multi-process errors }  
   MultiErrorType = RECORD 
       ES_regs:    TwoIorCType;        ES_number:  Int16;        END;      
   { Program name array }  
 !   PNameArrType = Array [FIRSTMP_PROG..LASTMP_PROG] OF PNameSType; !         { used by subordinate programs to indicate which error type }      ShootType = PACKED ARRAY[1..2] OF Char;      CONST       !   { Array of multiprogramming program names; Used to start up the !       subordinate programs in SetUpChildren and CheckChild.  Also   "     used for error reporting.                                    }  "    PROGNAMEARRAY = PNameArrType[        PNameSType[ 'NSPR1' ],        PNameSType[ 'NSPR2' ],        PNameSType[ 'NSPARS' ],         PNameSType[ 'NSINIT' ] ];          { This constant is used to convert numbers to ascii for  #     MultiError.  A given number + 48 decimal = the ascii equivilent } # 
   INT_TO_CHAROFFSET = 48; 
 VAR          { This array will contain the class numbers for all the  "     processes.  NSINIT allocates the classes, and hands the numbers " #     to the subordinate programs in the runstring.                   } #     multip_classes:  Array[FIRSTMP_CLASS..LASTMP_CLASS] OF Int16;           #   { In addition to the array of class numbers, each process keeps its # #     own class in a separate variable to simplify subroutine calls to  # $     other programs.                                                   } $    myclass:          Int16;           CONST      { This constant is largest variant of BSTType.        To calculate its value:            For each subroutine call declared in the variant record   
         do the following: 
 #      Add up the lengths of all the parameters in the variant record.  # !      This is the length of all the parameters in the subroutine,  ! "         (don't forget to add in initglobals to the subroutines that " 
          need it.)  
      After you have done this for every variant, you take the   $     largest and make BIGSTRINGSIZE = that value.                      } $     !   { Currently the subroutine with the largest parameter length is ! "     WordInput.  It has 163 words of parameters + MAX_IG/2(236/2) =  " $     281 words or 562 bytes.                                           } $    BIGSTRSIZE = 562; { Max. length for class buffers  }       TYPE         BPCharType =  PACKED ARRAY[1..BIGSTRSIZE] OF CHAR;      BPCharTypePtr = ^BPCharType;               "{ These constants are used to index into the variant record which is " #  used to pass parameter lists between the processes of NSINIT.  There # "  is one constant for each subroutine in the parser and the protocol "   processes.      $  The protocol segment routines have a two character prefix to indicate  $ $  which type of routine they are.  Each constant is preceeded by a C to  $ $  indicate it is a constant.  In addition, The semantic checker routines $ "  have S as a prefix, the initialization routines have an I, and the " %  cleanup/shutdown routines have C.                                     }  %     CONST   
   CCLASSBUFFER = 0; 
     	   CCHARINPUT = 1; 	    CCOUNTERRORMSGS = 78;  
   CERRORMSGSTODSAM = 79;  
 
   CFILEEXISTS = 2;  
 
   CFILEINTRAC = 3;  
    { 4 }     { 5 }  
   CHANDLEDEFF = 6;  
 	   CINTINPUT = 7;  	    CMSGFILEPRINT = 77;  	   COPENINPUT = 8; 	    COPENLOG = 9;  
   COPENOUTPUT = 10; 
 
   CPRINTERROR = 11; 
    CPRINTPROMPT = 12;      CREADFROMLOG = 13;   
   CREADINPUT = 14;  
 
   CSAYOUTEDIT = 15; 
    CSAYUSEINPUT = 16;   
   CWORDINPUT = 17;  
 
   CWRITEINPUT = 18; 
 	   CWRITELOG = 19; 	    CWRITEOUTPUT = 20;   
   CYESNOINPUT = 21; 
        CSPXP  = 23;      CIPXP  = 24;      CCPXP  = 25;          CSTCP  = 26;      CITCP  = 27;      CCTCP  = 28;          CSNM  =  29;      CINM  =  30;      CCNM  =  31;          CSNOD =  32;      CINOD =  33;      CCNOD =  34;          CSIPC = 35;     CIIPC = 36;     CCIPC = 37;         CSIP = 38;      CIIP = 39;      CCIP = 40;          CSIFP = 41;     CIIFP = 42;     CCIFP = 43;         CS1KS = 44;     CI1KS = 45;     CC1KS = 46;         CS3KS = 47;     CI3KS = 48;     CC3KS = 49;         CS3KL = 50;     CI3KL = 51;     CC3KL = 52;         CSRTR = 53;     CIRTR = 54;     CCRTR = 55;         CSNRV = 56;     CINRV = 57;     CCNRV = 58;         CSMON = 59;     CIMON = 60;     CCMON = 61;         CSNSL = 62;     CINSL = 63;     CCNSL = 64;         CSNFT = 65;     CINFT = 66;     CCNFT = 67;         CSMU  = 68;     CIMU  = 69;     CCMU  = 70;         CSTMR = 71;     CITMR = 72;     CCTMR = 73;         CSNRG = 74;     CINRG = 75;     CCNRG = 76;         CSPROB = 80;      CIPROB = 81;      CCPROB = 82;          CSNSLNK = 86;     CINSLNK = 87;     CCNSLNK = 88;         CIPADR = 83;      CIPROU = 84;          REMA   = 85;          CLANFL  = 89;     CLANSMA = 90;         CG90ST = 91;   	   CIPLIPADE = 92; 	    { Next avail number is 93 }         SONDONE   = -1;   { tell process it can terminate }     SERR      = -2;   { tell caller son has problem }      TYPE  #   { This is the variant record to store the parameter lists which are # !     passed between the processes in NSINIT.  There is one variant ! $     for each subroutine that can be called.  Additionally, the SONDONE  $ !     variant tells the subordinate process it can terminate.  The  ! !     CCLASSBUFFER is the variant used to start up each subordinate ! %     process.                                                            } %        BSTType = RECORD CASE Int16 OF         SERR:            (  SERR_errorstring:  MultiErrorType );            SONDONE:            ( GlobIGs:          InitGlobalType );       
      CCLASSBUFFER:  
           ( CCBChars:         BPChartype);      	      CCHARINPUT:  	           ( CIglobIGs:        InitGlobalType;               CIpromptstring:   PromptType;               CIcasefold:       Boolean;              CIdefault:        Boolean;              CIterminator:     Boolean;              CIinput_string:   IStringType;              CIresult:         Int16 );      
   CCOUNTERRORMSGS:  
          ( CEGlobIGs:         InitGlobalType;              CEtotalerrorcount: Int16 );      
   CERRORMSGSTODSAM: 
          ( EMGlobIGs:         InitGlobalType;              EMresult:          Int16 );         CFILEEXISTS:             ( FEGlobIGs:        InitGlobalType;               FEname1:          IStringType;              FEresult:         Int16;              FEfnreturn:       Boolean );         CFILEINTRAC:             ( FIGlobIGs:        InitGlobalType;               FIwhichfile:      InputOrLogType;               FIfnreturn:       Boolean );         CHANDLEDEFF:             ( HDGlobIGs:        InitGlobalType;               HDfilename:       FileNType;              HDname_base:      IStringType;              HDresult:         Int16 );         CINTINPUT:             ( IIGlobIGs:        InitGlobalType;               IIpromptstring:   PromptType;               IIdefault:        Boolean;              IIterminator:     Boolean;              IIhi_value:       Int16;              IIlo_value:       Int16;              IIint16_value:    Int16;              IIpassed_result:  Int16 );          	   CMSGFILEPRINT:  	           ( MFGlobIGs:        InitGlobalType;               MFmsgnumber:      Int16;              MFwhichroutine:   PrintMsgType;               MFprintinfo:      Int16;              MFresult:         Int16 );         COPENINPUT:            ( OIGlobIGs:        InitGlobalType;               OIresult:         Int16 );     COPENLOG:            ( OLGlobIGs:        InitGlobalType;               OLresult:         Int16 );         COPENOUTPUT:             ( OOGlobIGs:        InitGlobalType;               OOresult:         Int16 );         CPRINTERROR:             ( PEGlobIGs:        InitGlobalType;               PEerror_msg:      PromptType;               PEresult:         Int16 );         CPRINTPROMPT:            ( PPGlobIGs:        InitGlobalType;               PPsaveprompt:     Boolean;              PPpromptstring:   PromptType;               PPpassed_result:  Int16 );         CREADFROMLOG:            ( RLGlobIGs:        InitGlobalType;               RLinput_string:   IStringType;              RLresult:         Int16 );         CREADINPUT:            ( RIGlobIGs:        InitGlobalType;               RIinput_string:   IStringType;              RIresult:         Int16 );         CSAYOUTEDIT:             ( SEGlobIGs:        InitGlobalType );          CSAYUSEINPUT:            ( SIGlobIGs:        InitGlobalType );          CWORDINPUT:            ( WRGlobIGs:        InitGlobalType;               WRpromptstring:   PromptType;               WRdefault:        Boolean;              WRstring_of_tokens: IStringType;              WRtoken_from_user:  IStringType;              WRpassed_result:  Int16 );         CWRITEINPUT:             ( WIGlobIGs:        InitGlobalType;               WIwrite_string:   PromptType;               WIresult:         Int16 );         CWRITELOG:             ( WLGlobIGs:        InitGlobalType;               WLwrite_string:   PromptType;               WLresult:         Int16 );         CWRITEOUTPUT:            ( WOGlobIGs:        InitGlobalType;               WOwrite_string:   PromptType;               WOresult:         Int16 );         CYESNOINPUT:             ( YIGlobIGs:        InitGlobalType;               YIpromptstring:   PromptType;               YIdefault:        Boolean;              YIyesnovalue:     OneCharType;              YIpassed_result:  Int16 );         CSPXP:             ( SPXPglobIGs:      InitGlobalType;               SPXPsmbsize:      Int16;              SPXPdsamtbsize:     Int16;              SPXPsocketcnt:    Int16;              SPXPclasscnt:     Int16;              SPXPresourcecnt:  Int16;              SPXPresult:       Int16 );         CIPXP:             ( IPXPglobIGs:      InitGlobalType;               IPXPresult:       Int16 );         CCPXP:             ( CPXPGlobIGs:      InitGlobalType;               CPXPtrustvar:     TrustType;              CPXPresult:       Int16 );         CSTCP:             ( STCPglobIGs:      InitGlobalType;               STCPsmbsize:      Int16;              STCPdsamtbsize:     Int16;              STCPsocketcnt:    Int16;              STCPclasscnt:     Int16;              STCPresourcecnt:  Int16;              STCPresult:       Int16 );         CITCP:             ( ITCPIglobIGs:     InitGlobalType;               ITCPresult:       Int16 );     CCTCP:             ( CTCPGlobIGs:     InitGlobalType;              CTCPtrustvar:    TrustType;               CTCPresult:      Int16 );          CSNOD:             ( SNODglobIGs:      InitGlobalType;               SNODsmbsize:      Int16;              SNODdsamtbsize:     Int16;              SNODsocketcnt:    Int16;              SNODclasscnt:     Int16;              SNODresourcecnt:  Int16;              SNODresult:       Int16 );         CINOD:             ( INODIglobIGs:     InitGlobalType;               INODresult:       Int16 );     CCNOD:             ( CNODGlobIGs:     InitGlobalType;              CNODtrustvar:    TrustType;               CNODresult:      Int16 );          CS1KS:             ( S1KSglobIGs:      InitGlobalType;               S1KSsmbsize:      Int16;              S1KSdsamtbsize:     Int16;              S1KSsocketcnt:    Int16;              S1KSclasscnt:     Int16;              S1KSresourcecnt:  Int16;              S1KSresult:       Int16 );         CI1KS:             ( I1KSglobIGs:     InitGlobalType;              I1KSresult:       Int16 );     CC1KS:             ( C1KSGlobIGs:     InitGlobalType;              C1KStrustvar:    TrustType;               C1KSresult:      Int16 );          CS3KL:             ( S3KLglobIGs:      InitGlobalType;               S3KLsmbsize:      Int16;              S3KLdsamtbsize:     Int16;              S3KLsocketcnt:    Int16;              S3KLclasscnt:     Int16;              S3KLresourcecnt:  Int16;              S3KLresult:       Int16 );         CI3KL:             ( I3KLglobIGs:     InitGlobalType;              I3KLresult:       Int16 );     CC3KL:             ( C3KLGlobIGs:     InitGlobalType;              C3KLtrustvar:    TrustType;               C3KLresult:      Int16 );          CS3KS:             ( S3KSglobIGs:      InitGlobalType;               S3KSsmbsize:      Int16;              S3KSdsamtbsize:     Int16;              S3KSsocketcnt:    Int16;              S3KSclasscnt:     Int16;              S3KSresourcecnt:  Int16;              S3KSresult:       Int16 );         CI3KS:             ( I3KSglobIGs:     InitGlobalType;              I3KSresult:       Int16 );     CC3KS:             ( C3KSGlobIGs:     InitGlobalType;              C3KStrustvar:    TrustType;               C3KSresult:      Int16 );              CSNM:            ( SNMglobIGs:      InitGlobalType;              SNMsmbsize:      Int16;               SNMdsamtbsize:     Int16;               SNMsocketcnt:    Int16;               SNMclasscnt:     Int16;               SNMresourcecnt:  Int16;               SNMresult:       Int16 );          CINM:            ( INMglobIGs:     InitGlobalType;               INMresult:       Int16 );      CCNM:            ( CNMGlobIGs:     InitGlobalType;               CNMtrustvar:    TrustType;              CNMresult:      Int16 );             CSIPC:             ( SIPCglobIGs:     InitGlobalType;              SIPCsmbsize:     Int16;               SIPCdsamtbsize:    Int16;               SIPCsocketcnt:   Int16;               SIPCclasscnt:    Int16;               SIPCresourcecnt: Int16;               SIPCresult:      Int16 );          CIIPC:             ( IIPCIglobIGs:    InitGlobalType;              IIPCresult:      Int16 );      CCIPC:             ( CIPCGlobIGs:    InitGlobalType;               CIPCtrustvar:   TrustType;              CIPCresult:     Int16 );             CSIP:            ( SIPglobIGs:     InitGlobalType;               SIPsmbsize:     Int16;              SIPdsamtbsize:    Int16;              SIPsocketcnt:   Int16;              SIPclasscnt:    Int16;              SIPresourcecnt: Int16;              SIPresult:      Int16 );         CIIP:            ( IIPGlobIGs:    InitGlobalType;              IIPresult:      Int16 );     CCIP:            ( CIPGlobIGs:    InitGlobalType;              CIPtrustvar:   TrustType;               CIPresult:     Int16 );          CSIFP:             ( SIFPglobIGs:     InitGlobalType;              SIFPsmbsize:     Int16;               SIFPdsamtbsize:    Int16;               SIFPsocketcnt:   Int16;               SIFPclasscnt:    Int16;               SIFPresourcecnt: Int16;               SIFPresult:      Int16 );          CIIFP:             ( IIFPGlobIGs:    InitGlobalType;               IIFPresult:      Int16 );      CCIFP:             ( CIFPGlobIGs:    InitGlobalType;               CIFPtrustvar:   TrustType;              CIFPresult:     Int16 );             CSRTR:             ( SRTRglobIGs:     InitGlobalType;              SRTRsmbsize:     Int16;               SRTRdsamtbsize:    Int16;               SRTRsocketcnt:   Int16;               SRTRclasscnt:    Int16;               SRTRresourcecnt: Int16;               SRTRresult:      Int16 );          CIRTR:             ( IRTRGlobIGs:    InitGlobalType;               IRTRresult:      Int16 );          CCRTR:             ( CRTRGlobIGs:    InitGlobalType;               CRTRtrustvar:   TrustType;              CRTRresult:     Int16 );         CSNRV:             ( SNRVglobIGs:     InitGlobalType;              SNRVsmbsize:     Int16;               SNRVdsamtbsize:    Int16;               SNRVsocketcnt:   Int16;               SNRVclasscnt:    Int16;               SNRVresourcecnt: Int16;               SNRVresult:      Int16 );          CINRV:             ( INRVGlobIGs:    InitGlobalType;               INRVresult:      Int16 );          CCNRV:             ( CNRVGlobIGs:    InitGlobalType;               CNRVtrustvar:   TrustType;              CNRVresult:     Int16 );         CSMON:             ( SMONglobIGs:     InitGlobalType;              SMONsmbsize:     Int16;               SMONdsamtbsize:    Int16;               SMONsocketcnt:   Int16;               SMONclasscnt:    Int16;               SMONresourcecnt: Int16;               SMONresult:      Int16 );          CIMON:             ( IMONGlobIGs:    InitGlobalType;               IMONresult:      Int16 );          CCMON:             ( CMONGlobIGs:    InitGlobalType;               CMONtrustvar:   TrustType;              CMONresult:     Int16 );             CSNSL:             ( SNSLglobIGs:     InitGlobalType;              SNSLsmbsize:     Int16;               SNSLdsamtbsize:    Int16;               SNSLsocketcnt:   Int16;               SNSLclasscnt:    Int16;               SNSLresourcecnt: Int16;               SNSLresult:      Int16 );          CINSL:             ( INSLGlobIGs:    InitGlobalType;               INSLresult:      Int16 );          CCNSL:             ( CNSLGlobIGs:    InitGlobalType;               CNSLtrustvar:   TrustType;              CNSLresult:     Int16 );             CSNFT:             ( SNFTglobIGs:     InitGlobalType;              SNFTsmbsize:     Int16;               SNFTdsamtbsize:    Int16;               SNFTsocketcnt:   Int16;               SNFTclasscnt:    Int16;               SNFTresourcecnt: Int16;               SNFTresult:      Int16 );          CINFT:             ( INFTGlobIGs:    InitGlobalType;               INFTresult:      Int16 );          CCNFT:             ( CNFTGlobIGs:    InitGlobalType;               CNFTtrustvar:   TrustType;              CNFTresult:     Int16 );             CSMU:            ( SMUglobIGs:     InitGlobalType;               SMUsmbsize:     Int16;              SMUdsamtbsize:    Int16;              SMUsocketcnt:   Int16;              SMUclasscnt:    Int16;              SMUresourcecnt: Int16;              SMUresult:      Int16 );         CIMU:            ( IMUGlobIGs:    InitGlobalType;              IMUresult:      Int16 );         CCMU:            ( CMUGlobIGs:    InitGlobalType;              CMUtrustvar:   TrustType;               CMUresult:     Int16 );              CSTMR:             ( STMRglobIGs:     InitGlobalType;              STMRsmbsize:     Int16;               STMRdsamtbsize:    Int16;               STMRsocketcnt:   Int16;               STMRclasscnt:    Int16;               STMRresourcecnt: Int16;               STMRresult:      Int16 );          CITMR:             ( ITMRGlobIGs:    InitGlobalType;               ITMRresult:      Int16 );          CCTMR:             ( CTMRGlobIGs:    InitGlobalType;               CTMRtrustvar:   TrustType;              CTMRresult:     Int16 );             CSNRG:             ( SNRGglobIGs:     InitGlobalType;              SNRGsmbsize:     Int16;               SNRGdsamtbsize:    Int16;               SNRGsocketcnt:   Int16;               SNRGclasscnt:    Int16;               SNRGresourcecnt: Int16;               SNRGresult:      Int16 );          CINRG:             ( INRGGlobIGs:    InitGlobalType;               INRGresult:      Int16 );          CCNRG:             ( CNRGGlobIGs:    InitGlobalType;               CNRGtrustvar:   TrustType;              CNRGresult:     Int16 );         CSPROB:            ( SPROBglobIGs:     InitGlobalType;               SPROBsmbsize:     Int16;              SPROBdsamtbsize:    Int16;              SPROBsocketcnt:   Int16;              SPROBclasscnt:    Int16;              SPROBresourcecnt: Int16;              SPROBresult:      Int16 );         CIPROB:            ( IPROBGlobIGs:    InitGlobalType;              IPROBresult:      Int16 );         CCPROB:            ( CPROBGlobIGs:    InitGlobalType;              CPROBtrustvar:   TrustType;               CPROBresult:     Int16 );          CSNSLNK:             ( SNSLNKglobIGs:     InitGlobalType;              SNSLNKsmbsize:     Int16;               SNSLNKdsamtbsize:    Int16;               SNSLNKsocketcnt:   Int16;               SNSLNKclasscnt:    Int16;               SNSLNKresourcecnt: Int16;               SNSLNKresult:      Int16 );          CINSLNK:             ( INSLNKGlobIGs:    InitGlobalType;               INSLNKresult:      Int16 );          CCNSLNK:             ( CNSLNKGlobIGs:    InitGlobalType;               CNSLNKtrustvar:   TrustType;              CNSLNKresult:     Int16 );         CIPADR:            ( CIPADRGlobIGs:    InitGlobalType;               CIPADRfnretrn:    Int32 );         CIPROU:            ( CIPROUGlobIGs:    InitGlobalType;               CIPROUipadr:      Int32;              CIPROUanhpid:     Int16;              CIPROUdcnadr:     Boolean;              CIPROUresult:     Int16 );         REMA:           ( REMAGlobIGs:       InitGlobalType;              REMAema_avail:     Int16;             REMAema_used:      Int16;             REMAierr:          Int16 );         CLANFL:           ( CLANFLGlobIGs:     InitGlobalType;              CLANFLindex:       Int16;             CLANFLlu:          Int16;             CLANFLierr:        Int16 );         CLANSMA:            ( CLANSMAGlobIGs:         InitGlobalType;             CLANSMAsuppliedaddrs:   MCastInfo;              CLANSMAierr:            Int16 );          CG90ST:           ( CG90STGlobIGs:         InitGlobalType;              CG90STactivecallsock:  Int16;             CG90STactivevcsock:    Int16;             CG90STierr:            Int16 );         CIPLIPADE:            ( CIPLIPADEglobIGs:      InitGlobalType;              CIPLIPADEipadr:        Int32;             CIPLIPADEfnretrn:      Boolean );         END;       VAR   %   { This buffer is the class I/O buffer used to handle multiprocessing. } %    globalstring:    BSTType;      CONST       
   ECLASSALLOC  = 1; 
 
   ECLWRITE     = 2; 
 
   ECLGETLENGTH = 3; 
 
   EEXECWAIT    = 4; 
 
   ECHILDSCHED  = 5; 
 
   EBADCHILD    = 6; 
 
   ECLGET       = 7; 
 
   EOTHERWISE   = 8; 
 
   EBADRUNSTRING= 9; 
    EERRORCATCHER= 10;      EERRORCATCH2 = 11;      ECHILDNOTDORM= 12;   
   LAST_ECONST = 12; 
     TYPE     EMCharType = String[71];      EMsgArray = Array[1..LAST_ECONST] OF EMCharType;       CONST      NSINITE = EMsgArray[       	      EMCharType[  	 	{ 1- ECLASSALLOC } 	   '** (801) NSINIT: CLRQ error. A and B registers are:'],       	      EMCharType[  	 { 2- ECLWRITE }      '** (802) NSINIT: Class Write Error. Error is: '],       	      EMCharType[  	 
{ 3- ECLGETLENGTH }  
 #   '** (803) NSINIT: Length Error on Class Get. NSINIT Program is: '], #     	      EMCharType[  	 { 4- EEXECWAIT }     '** (804) NSINIT: Exec Wait error: '],       	      EMCharType[  	 	{ 5- ECHILDSCHED } 	 $   '** (805) NSINIT: Error starting up subordinate program. Error is:'], $     	      EMCharType[  	 { 6- EBADCHILD }  $   '** (806) NSINIT: Invalid subordinate security code.  Program is: '], $     	      EMCharTYpe[  	 { 7- ECLGET }       '** (807) NS: Error on Class Get.  A and B registers are:'] ,       	      EMCharTYpe[  	 	{ 8- EOTHERWISE }  	 %   '** (808) NSINIT: Subordinate- invalid routine index. Program is: ' ],  %     	      EMCharTYpe[  	 { 9 - EBADRUNSTRING }     '** (809) NSINIT: Invalid subordinate runstring. Program is'] ,       	      EMCharTYpe[  	 { 10- EERRORCATCHER }      '** (810) NSINIT: Encountered Pascal Error in: '] ,      	      EMCharTYpe[  	 
{ 11- EERRORCATCH2 } 
  '** (811) NSINIT: Internal Pascal Errors in: '],       	      EMCharTYpe[  	 { 12- ECHILDNOTDORM }   % '** (812) NSINIT Error: Subordinate not dormant (EXEC). Program is: '] ]; %     $ SUBTITLE 'Exported Procedures', PAGE $  	PROCEDURE BailOut; 	 	   { Exit NSINIT } 	     
PROCEDURE ChildWake  
    (     whichchild:    Int16 );     { Read Run String parameters from the caller (NSINIT) }      
PROCEDURE DoSubCall  
    (     progtosched:   Int16 );     { Schedule another process to do this subroutine call }      PROCEDURE KillChildren;       { Terminate the other processes that make up the NSINIT set }       
PROCEDURE MultiError 
    (     errorstring:   MultiErrorType );   #   { Print error message and attempt to clean up NSINIT's processes }  #     PROCEDURE SetUpChildren;     { Get class numbers and start up the NSINIT program set }      
PROCEDURE ShootSelf  
    (     errorstring:   MultiErrorType );   "   { Send an error to the caller; Terminate a subordinate program }  "     IMPLEMENT   { Module initmulti }      CONST   
   DEALLOCATE = 2 + BIT14; 
    EXEC10 = 10 + NOABORTBIT;     EXEC12 = 12 + NOABORTBIT;     GETCLASS = 1 + BIT15 + BIT14;     {Used to convert a number to an ascii character. }      SECS = 2;     ONCE  = 0;      ONESEC = -1;      FMPFILEEXISTSERR = -239;       VAR      dummy:         Int16;     typeofsched:   Int16;     result:        Int16;     a_reg:         Int16OrCharType;     b_reg:         Int16OrCharType;     endofstring:   IStringType;     errorstring:   MultiErrorType;      message:       IStringType;     classtouse:    Int16;      PROCEDURE ABReg      ( VAR a_reg:   Int16;  
     VAR b_reg:   Int16 ); 
    EXTERNAL;     { get the A and B registers for errors on RTE calls }      PROCEDURE ClassGet                $ ALIAS 'EXEC' $  $ NOABORT $      (    code:        Int16;           classnum:    Int16;       VAR buffer:      BPCharType;          buflen:      Int16;           p1:          Int16;           p2:          Int16 );      EXTERNAL;  %   { Class get to transfer globals and parameter list between processes }  %     PROCEDURE ClassWrite           $ ALIAS 'EXEC' $   $ NOABORT $    (       code:       Int16;            cnwrd:      Int16;      VAR   buffer:     BPCharType;           buflen:     Int16;            p1:         Int16;            p2:         Int16;            classnum:   Int16 );      EXTERNAL;  !   { Used to pass globals and parameter lists between processes }  !     FUNCTION FmpRpProgram   $ FIXED_STRING ON, HEAPPARMS OFF $   (     filedes:      PNameSType;     VAR namerpd:      String;         options:      IStringType;      VAR error:        Int16 ):  Int16;      EXTERNAL;  $ HEAPPARMS ON, FIXED_STRING OFF $      PROCEDURE GetClassNumber       $ ALIAS 'CLRQ' $   $ NOABORT $    (       fncode:     Int16;      VAR   classnumber:Int16 );      EXTERNAL;  '   { NSINIT buys class numbers for itself, parser, & one for each proto segs } '     "FUNCTION PascalStringData                $ ALIAS 'Pas.StringData1' $ "    ( VAR s:          String ):  PCharTypePtr;      EXTERNAL;     { return a packed array of char pointer to a string }      $FUNCTION PickUpStringParms     $ ALIAS 'PAS.SPARAMETERS',HEAPPARMS OFF$  $   (    pnum:      Int16;     VAR p:         String): Int16;      EXTERNAL;     { Pick up run-time parameters as a string }      $PROCEDURE RtePrint             $ ALIAS 'REIO', HEAPPARMS OFF, NOABORT $  $   ( writereq:     Int16;      conwd:        Int16;      msg:          PCharType;  
    msglen:       Int16 ); 
    EXTERNAL;     { Print a message on the scheduling terminal }       PROCEDURE SchedBailOut  (     progname:      PNameSType;        ierr:          Int16 );      FORWARD;      { Exit NSINIT on Schedule errors  }      PROCEDURE ScheduleChild                  $ ALIAS 'EXEC' $   $ NOABORT $      (  schedtype:     Int16;         name:          PCharType;         parm1:         Int16;         parm2:         Int16;         parm3:         Int16;         parm4:         Int16;         parm5:         Int16;         pcharschstring:PCharType;         stringlen:     Int16 );      EXTERNAL;     { schedule all the processes needed by NSINIT }      PROCEDURE WaitASec                        $ ALIAS 'EXEC' $  $ NOABORT $      (     ecode:      Int16;            name:       Int16;            units:      Int16;            often:      Int16;            delay:      Int16 );      EXTERNAL;     { Wait one second before shooting the other processes }      $ SUBTITLE 'BailOut', PAGE $  {------------------------------------------------------------}  {                                                            }  {                        BailOut                             }  {                                                            }  {------------------------------------------------------------}  {}  	PROCEDURE BailOut; 	 {}  {  Purpose: To exit NSINIT if result an error was encountered.  {   {  Input:   none  {  Output:  none  {   {  Global variables accessed: initglobals.IG_callerclass  {   {  Routines called: KillChildren, ShootSelf.  {   {  Side Effects:  TERMINATES THE PROGRAM.   {   #{  Description:   This routine determines if it is part of NSINIT, or  # "{     is part of a subordinate program.  If it is part of NSINIT, it " #{     terminates all the subordinate processes and terminates itself.  # {   #{  If it is part of a subordinate process it passes the error back to  # {  its caller by calling ShootSelf which sends a buffer back  {  to the caller.  The program then terminates.   {}         BEGIN    { BailOut }          KillChildren;     Halt( 1 );          END;     { BailOut }       $SUBTITLE 'DoSubCall', PAGE $   {------------------------------------------------------------}  {                                                            }  {                    DoSubCall                               }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE DoSubCall  
    (     progtosched:   Int16 );      {}  {  Purpose:   !{     To schedule the program which contains the actual subroutine ! {     not the dummy subroutine which calls DoSubCall.   {   {  input:   #{      progtosched- the constant that tells this routine which program # {        to schedule to do the actual subroutine call.  {   {  output:  none  {   
{  Global Variables used:  
 
{     from init_dec: 
  {        globalstring used for class I/O calls.  It contains the   ${           global variables and the parameter list for the subroutine.  $ ${        initglobals is copied into globalstring and passed to the other $ {           process.  It contains the global variables.   {     from init_gend:   {        a_reg, b_reg are used to save local storage.   {   
{  Routines Called:  
 {     ClassWrite, ClassGet, ABReg, MultiError.  {   {  Description:   !{     This routine determines which class number should be used to ! #{     write the globals to based on which program is to be scheduled.  # {   ${     The routine writes globalstring onto the appropriate class number. $ !{     This buffer has already been set up to contain the parameter ! ${     list needed by the subroutine that is to be executed in the other  $ ${     process.  The dummy version of the subroutine already stored these $ ${     variables.  DoSubCall copies the global variables into the buffer  $ {     before writing it to the class number.  {   "{     The routine then waits on its class number for the reply from  " !{     the other process.  If the length of the buffer is less than ! "{     the length of the global variables (initglobals), the routine  "  {     knows the other process had a problem, and wants to abort.   !{     This routine calls MultiError, which handles the situation.  ! {   %{     DoSubCall saves a local copy of one of the globals- IG_callerclass.  % &{     This is because it needs to tell the other process what THIS program's & "{     class number is.  However, when the other process has done the " %{     subroutine call, DoSubCall needs to restore the class number of the  % {     program that called THIS one.   {   {}      VAR      tempclass:     Int16;     dummy:         Int16;     mlen:          Int16;      $ PAGE $  
   BEGIN    { DoSubCall }  
         { tell program that was scheduled where to write the reply }       WITH initglobals DO        BEGIN    { save my caller's class }         tempclass := IG_callerclass;        IG_callerclass := myclass;        END;      $   { copy the globals into the class I/O buffer for the other process }  $    globalstring.GlobIGs := initglobals;          { get the proper multiprogramming class number }      classtouse := multip_classes[progtosched];       "   { write the globals and the parameter list to the other process } "    ClassWrite( NAEXEC20, 0, globalstring.CCBChars,        -BIGSTRSIZE, 0, 0, classtouse );        BEGIN    { Write Error }  
      WITH errorstring DO  
 
         BEGIN    { WITH } 
          ABReg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );            ES_number := ECLWRITE;   
         END;     { WITH } 
           MultiError( errorstring );        END;     { Write Error }      %   { Wait on my own class number for the response from the other process } %    dummy := -BIGSTRSIZE;     ClassGet( NAEXEC21, myclass + SAVECLASSBIT,              globalstring.CCBChars, dummy, 0, 0 );         BEGIN    { Get Error }  
      WITH errorstring DO  
 
         BEGIN    { WITH } 
          ABReg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );            ES_number := ECLGET;   
         END;     { WITH } 
           MultiError( errorstring );        END;     { Get Error }         { check the length from the class get }     ABReg( a_reg.IIorCType, dummy );      IF dummy <= 0 THEN         BEGIN    { length error }   
      WITH errorstring DO  
 
         BEGIN    { WITH } 
 &         ES_regs[1].CIorCType[1] := CHR( progtosched + INT_TO_CHAROFFSET );  &          ES_number := ECLGETLENGTH;   
         END;     { WITH } 
           MultiError( errorstring );        END;     { length error }       $   { copy the globals from the class I/O buffer back to local storage }  $    initglobals := globalstring.globIGs;          { restore my caller's class number }      initglobals.IG_callerclass := tempclass;       
   IF dummy < MAX_IG THEN  
       BEGIN    { child in trouble }         { child will send a one word buffer if it had trouble.  !        Get the error number and a and b registers if appropriate. ! "        Print an error and clean up.                               } "           errorstring := globalstring.SERR_errorstring;         MultiError( errorstring );        END;     { child in trouble }       
   END;     { DoSubCall }  
     $ SUBTITLE 'KillChildren', PAGE $   {------------------------------------------------------------}  {                                                            }  {                    KillChildren                            }  {                                                            }  {------------------------------------------------------------}  PROCEDURE KillChildren;       {}   {  Purpose: used by NSINIT to clean up all subordinate programs.   {   {  Input:   none  {   {  Output:  none  {   {  Side Effects:  none  {   {  Global Variables Accessed:   {     globalstring is used as a class buffer.   {     initglobals is used for the class numbers.  %{     the program name array is used to wake up the subordinate processes  % {   
{  Routines called:  
 {     ClassWrite,  EXEC 12 (to wait),   {     ABreg, CLRQ (to return class numbers).  {   {  Description:   ${     This routine tells all subordinate programs that they are finished $ #{     by setting the global IG_whichguy to SONDONE.  The routine then  # &{     returns the class numbers to the system that SetUpChildren allocated.  & {}      VAR   
   classtouse:Int16; 
 
   index :    Int16; 
 
   mlen:      Int16; 
 $ SUBTITLE 'ErrorOnKill', PAGE $      
   PROCEDURE ErrorOnKill;  
       BEGIN    { ErrorOnKill }  
      message := ''; 
     
      WITH errorstring DO  
 
         BEGIN    { WITH } 
          Strwrite( message, 1, mlen, NSINITE[ES_number],                 ES_regs[1].CIorCType, ES_Regs[2].CIorCType, );             RTEPrint( XWRITEREQ, LU1, PascalStringData( message )^,                                   -Strlen( message ) );               BEGIN    { Error }              { ignore errors }               END;     { Error }               Halt( ES_number );   
         END;     { WITH } 
       END;     { ErrorOnKill }         BEGIN    { KillChildren }      !   { tell the main program of the other processes it is finished } !    initglobals.IG_whichguy := SONDONE;         { clear out the class I/O buffer }      globalstring.CCBChars := '';          { copy the globals into the class I/O buffer }      globalstring.globIGs := initglobals;          { The for loop runs for all subordinate programs,       LASTMP_PROG includes NSINIT, so we want 1 less. }     FOR index := FIRSTMP_PROG TO LASTMP_PROG -1 DO         BEGIN    { FOR }            classtouse := multip_classes[index];            { write the class I/O buffer to the parser }        ClassWrite( NAEXEC20, 0, globalstring.CCBChars,               MAX_IG, 0, 0, classtouse );            BEGIN    { Write Error }            WITH errorstring DO              BEGIN    { WITH }                ABReg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );               ES_number := ECLWRITE;              END;     { WITH }                ErrorOnKill;            END;     { Write Error }             { wait for each to get its buffer }         WaitASec( EXEC12, 0, SECS, ONCE, ONESEC );           BEGIN    { Exec error }           WITH errorstring DO              BEGIN       { WITH }               ABReg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );               ES_number := EEXECWAIT;               END;        { WITH }               ErrorOnKill;            END;     { Exec Error }            END;     { FOR }  #   { RTE will de-allocate the class numbers when NSINIT terminates. }  #        END;     { KillChildren }      $ SUBTITLE 'MultiError', PAGE $   {------------------------------------------------------------}  {                                                            }  {                   MultiError                               }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE MultiError 
    (   errorstring:  MultiErrorType );  
   BEGIN    { MultiError } 
            { print a message telling the user about the problem. Then          try to clean up the multiprocessing.                     }          WITH errorstring DO        BEGIN    { WITH }       
      message := ''; 
       Strwrite( message, 1,dummy, NSINITE[ ES_number],          ES_Regs[1].CIorCType, ES_regs[2].CIorCType );         RTEPrint( XWRITEREQ, LU1, PascalStringData( message )^,                -Strlen( message ));            BEGIN    { print error }   
         { ignore errors } 
          END;     { print error }         END;     { WITH }          BailOut;       
   END;     { MultiError } 
     $ SUBTITLE 'SchedBailOut', PAGE $   {------------------------------------------------------------}  {                                                            }  {                 SchedBailout                               }  {                                                            }  {------------------------------------------------------------}      PROCEDURE SchedBailOut  (     progname:      PNameSType;        ierr:          Int16 );       VAR   	   dummy:   Int16; 	        BEGIN    { SchedBailOut }      	   message := '';  	     !   Strwrite( message, 1, dummy, '** (222) NSINIT: Error ', ierr:1, ! !      ' Rping ', progname, '.  Terminating. (FMPRPPROGRAM) **' );  !        RTEPrint( XWRITEREQ, LU1, PascalStringData( message )^,                                  -Strlen( message ) );         BEGIN    { Error }        { ignore errors }         END;     { Error }         KillChildren;     Halt( 1 );          END;     { SchedBailOut }          $ SUBTITLE 'SetUpChildren', PAGE $  {------------------------------------------------------------}  {                                                            }  {                 SetUpChildren                              }  {                                                            }  {------------------------------------------------------------}  PROCEDURE SetUpChildren;      {}  !{  Purpose: To allocate class numbers and establish communication  ! {  with the subordinate programs that are part of NSINIT.   {   {  input: none  {  output: none   {  Global Variables Accessed:   	{   from init_dec: 	 {     These are initialized:  {        multip_classes, myclass  {     These are used to save storage:   {        endofstring.   {   
{  Routines Called:  
 {     CheckChild, CLRQ (getclassnumber).  {   {  Description:   #{     Get 8 class numbers from the system, call CheckChild to start up # {     all subordinate programs.   {}      VAR      index:      Int16;       $ SUBTITLE 'CheckChild', PAGE $   {------------------------------------------------------------}  {  (LOCAL)              CheckChild              (LOCAL)      }  {------------------------------------------------------------}  
PROCEDURE CheckChild 
    (     progtosched:   Int16;           endofstring:   IStringType );      {}  {  Purpose:    {     To start up a subordinate program for NSINIT, and to check   {     that it returns 'DS' in a class buffer to NSINIT.   {   {  input:   #{     progtosched- index into PROGNAMEARRAY for program to be started  # %{     endofstring- end of the runstring which will be passed to the prog.  % {   {  output:  {     result- <>0 if error, 0 Otherwise   {   {  Global Variables Accessed:   !{     globalstring- to get the buffer from the subordinate program ! {     dummy ( to save storage )   {   
{  Routines Called:  
 {     FmpRpProgram, ScheduleChild (EXEC10), ClassGet  {     (EXEC21), ABReg, BailOut, MultiError.   {   {  Description:   ${     Schedule the program of the name in progtosched.  Hand the program $  {     the appropriate class numbers in its schedule string that    #{     SetUpChildren put in endofstring.  Wait on NSINIT's class number # !{     for the program to send a buffer back.  Make sure the buffer ! {     is 'DS'.  If it's not clean up and terminate.   {   {}  CONST      TESTLEN = 10;      VAR      len:              Int16;      nametouse:        IStringType;      runstring:        IStringType;      tempname:         PNameSType;      $ PAGE $  
   BEGIN    { CheckChild } 
     
   runstring := '';  
 
   nametouse := '';  
        tempname := PROGNAMEARRAY[progtosched];     dummy := FmpRpProgram( PROGNAMEARRAY[progtosched],                                        tempname, '  ', dummy );          { Note the FmpFileExists error is tolerated here to enable         debugging subordinate programs (see PDEBUG.)             }       IF (( dummy <> 0 ) AND ( dummy <> FMPFILEEXISTSERR )) THEN                     SchedBailOut( tempname, dummy );         { set up standard run string for the proper program }      "   Strwrite( runstring, 1, dummy, 'RU,', PROGNAMEARRAY[progtosched], " #                                                        endofstring ); #     Strwrite( nametouse, 1, dummy, PROGNAMEARRAY[progtosched] );           { schedule the son }   "   ScheduleChild( EXEC10, PascalStringData( nametouse )^, 0,0,0,0,0, "           PascalStringData( runstring )^, -Strlen( runstring ) );         BEGIN    { Sched Error }  
      WITH errorstring DO  
 
         BEGIN    { WITH } 
          ABReg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );            ES_number := ECHILDSCHED;  
         END;     { WITH } 
           MultiError( errorstring );        END;     { Sched Error }         { Verify the child was not already running }      WITH errorstring DO        BEGIN  { WITH }         ABReg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );        IF ES_regs[1].IIorCType <> 0 THEN            BEGIN    { Child already running }                ES_number := ECHILDNOTDORM;  &         ES_Regs[1].CIorCType[1] := CHR( progtosched + INT_TO_CHAROFFSET );  &              MultiError( errorstring );            END;     { Child already running }         END;     { WITH }       #   { Get a class buffer from the son.  Make sure the buffer is 'DS' }  #    globalstring.CCBChars := '';   	   len := TESTLEN; 	     #   ClassGet( NAEXEC21, myclass + SAVECLASSBIT, globalstring.CCBChars,  #                                  len, 0, 0 );         BEGIN    { Get Error }  
      WITH errorstring DO  
 
         BEGIN    { WITH } 
          ABreg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );            ES_number := ECLGET;   
         END;     { WITH } 
           MultiError( errorstring );        END;     { Get Error }         ABReg( a_reg.IIorCType, len );   
   IF len <= 0 THEN  
       BEGIN    { length error }   
      WITH errorstring DO  
 
         BEGIN    { WITH } 
 &         ES_regs[1].CIorCType[1] := CHR( progtosched + INT_TO_CHAROFFSET );  &          ES_number := ECLGETLENGTH;   
         END;     { WITH } 
           MultiError( errorstring );        END;     { length error }              IF ( globalstring.CCBChars[1] <> 'D' ) AND                       ( globalstring.CCBChars[2] <> 'S' ) THEN        BEGIN    { Bad child }  
      WITH errorstring DO  
 
         BEGIN    { WITH } 
 &         ES_regs[1].CIorCType[1] := CHR( progtosched + INT_TO_CHAROFFSET );  &          ES_number := EBADCHILD;  
         END;     { WITH } 
           MultiError( errorstring );        END;     { Bad child }      
   END;     { CheckChild } 
     $ SUBTITLE 'BuyClass', PAGE $   	PROCEDURE BuyClass 	 ( VAR  classnum:     Int16 );          BEGIN    { BuyClass }         { get a class number for myself }     GetClassNumber( GETCLASS, classnum );        BEGIN    { alloc error }  
      WITH errorstring DO  
 
         BEGIN    { WITH } 
          ABReg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );            ES_number := ECLASSALLOC;  
         END;     { WITH } 
           MultiError( errorstring );        END;     { alloc error }         END;     { BuyClass }      $ SUBTITLE 'SetUpChildren', PAGE $     BEGIN    { SetUpChildren }          FOR index := FIRSTMP_CLASS TO LASTMP_CLASS DO        BEGIN    { get class numbers for everyone }             BuyClass( multip_classes[index] );        END;     { get class numbers for everyone }       !   { save nsinitclass in myclass so dosubcall will work properly } !    myclass := multip_classes[MP_NSINIT];      	   message := '';  	        Strwrite( message, Strlen( message ) +1 , dummy,   %    ',', multip_classes[PROTO1PROG]:1, ',', multip_classes[PROTO2PROG]:1,  % $    ',', multip_classes[PARSERPROG]:1, ',', multip_classes[MP_NSINIT]:1, $     '   ');       !   { Start up each child, hand each the same run string.  Each one ! "     will figure out which class it should wait on.                } "        FOR index := FIRSTMP_PROG TO LASTMP_PROG -1 DO         BEGIN    { FOR }  	      dummy := 0;  	           CheckChild( index, message );   !      { routine will clean up and terminate if it has a problem }  !           END;     { FOR }     END;     { SetUpChildren }       $ SUBTITLE 'ShootSelf', PAGE $  {------------------------------------------------------------}  {                                                            }  {                  ShootSelf                                 }  {                                                            }  {------------------------------------------------------------}  
PROCEDURE ShootSelf  
    ( errorstring:  MultiErrorType );  {}  {  Purpose:   ${     To terminate a subordinate program in the NSINIT set of programs.  $ {   {  input:   "{     numstring: a number to be passed back to the caller indicating " {        what type of error occurred in this program.   {   {  output:  none  {   {  global variables accessed:   &{     initglobals- which contain the global variables  ( need caller class ) & ${     globalstring- buffer used to pass error number back to the caller. $ {   {  Side Effects:  none  {   {  Routines Called:  ClassWrite (EXEC21), Halt.   {   {  Description:   "{     This routine sends an error indication back to the caller, and " {     terminates this program.  {   {}          
   BEGIN    { ShootSelf }  
     	   message := '';  	        { clear the class buffer }      globalstring.CCBChars := '';          { tell the caller there is a problem. }     globalstring.SERR_errorstring := errorstring;         { write the buffer back to the caller }     Classwrite( NAEXEC20, 0, globalstring.CCBChars,            MULTIERRORTYPELEN, 0, 0, initglobals.IG_callerclass );          BEGIN    { exec error }             ABReg( a_reg.IIorCType, b_reg.IIorCType );        Strwrite( message, 1, dummy, NSINITE[ECLWRITE],                             a_reg.CIorCType, b_reg.CIorCType );         RTEPrint( XWRITEREQ, LU1, PascalStringData( message )^,               -Strlen( message ));           BEGIN    { print error }   
         { ignore errors } 
          END;     { print error }       "      { now print the error we were trying to send back to caller }  " 
      WITH errorstring DO  
 
         BEGIN    { WITH } 
          Strwrite( message, 1, dummy, NSINITE[ES_number],               ES_regs[1].CIorCType, ES_regs[2].CIorCType );   
         END;     { WTIH } 
           RTEPrint( XWRITEREQ, LU1, PascalStringData( message )^,               -Strlen( message ));           BEGIN    { print error }   
         { ignore errors } 
          END;     { print error }             HALT( errorstring.ES_number );        END;     { exec error }       "   { Terminate.  The caller will print a message about the error and " #      will make sure NSINIT terminates as well.                      } #    Halt(0);       
   END;     { ShootSelf }  
     $SUBTITLE 'ChildWake', PAGE $   
PROCEDURE ChildWake  
    (     whichchild:    Int16 );  {}  {  Purpose: To read the runstring from NSINIT, and to   {     send a buffer back to NSINIT's class.   {   {  Input: whichchild-    offset into multiprogramming arrays,   !{                        identifying which child is being awoken.  ! {  Output: none   {  Global Variables Accessed:   {     myclass, multip_classes are all initialized here.   {     globalstring is used to hand NSINIT the 'DS' buffer.  {   
{  Routines Called:  
 {     ChildWake, ClassWrite (EXEC21), ABReg.  {   {  Description:   
{     Read the runstring.  
 !{     Send NSINIT a buffer containing 'DS' so it knows I am awake. ! {   {}      VAR      count:      Int16;      dummy:      Int16;      len:        Int16;       
   BEGIN    { ChildWake }  
        FOR count := FIRSTMP_CLASS TO LASTMP_CLASS DO        BEGIN    { Get classes }        { Get class numbers from the runstring }            len := PickUpStringParms( count, message );         IF len <= 0 THEN           BEGIN    { bad runstring }            WITH errorstring DO              BEGIN    { WITH }               ES_number := EBADRUNSTRING;   '            ES_regs[1].CIorCType[1] := CHR( whichchild + INT_TO_CHAROFFSET );  '                 END;     { WITH }                MultiError( errorstring );            END;     { bad runstring }             StrRead( message, 1, len, dummy );        multip_classes[count] := dummy;             END;     { Get classes }         myclass := multip_classes[whichchild];           { Write 'DS' back to NSINIT's class to tell him I'm awake. }       globalstring.CCBChars := 'DS';          Classwrite( NAEXEC20, 0, globalstring.CCBChars, -2,            0,0, multip_classes[MP_NSINIT] );         BEGIN    { exec error }   
      WITH errorstring DO  
 
         BEGIN    { WITH } 
          ABReg( ES_regs[1].IIorCType, ES_regs[2].IIorCType );            ES_number := ECLWRITE;   
         END;     { WITH } 
           MultiError( errorstring );        END;     { exec error }   
   END;     { ChildWake }  
     END        { module initmulti }   .  