 $PASCAL '91790-1X076 REV.4010 <860403.0936>'  
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG $  $RANGE OFF$   $RECURSIVE OFF$   $CODE_INFO ON$  	$CODE_OFFSETS ON$  	 $TITLE 'Module Description', PAGE$          MODULE INFLB;   %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : INFLB   {      SOURCE : 91790-18076   
{       RELOC : NONE 
 
{        PGMR : JXL  
 {}  {   	{  MODIFICATIONS:  	 {   ${  4/3/86   ash   Modify InsrtOct to include a 'b'.  Output is sometimes $ 
{                 unclear. 
 {}  { MODULE DESCRIPTION:   {}  %{  This module supplies all the I/O intrinsics needed for the Information  % %{    Utility for Network Services/1000.  This module is imported in common % {    by the modules of NSInfo as well as by NSInfo itself.  	{    JXL 12-26-84  	 {   {}              IMPORT  
  $SEARCH 'phtm/BODEC.rel' 
   bodec;          $ TITLE 'Export Section', PAGE $  EXPORT  ${---------------------------------------------------------------------}  $ {   {                   GLOBAL TYPES  {   ${---------------------------------------------------------------------}  $     CONST   %   EXEC_READ = 1 + (-32768);      { Set NoAbort Bit in both Xluex ecodes } %    EXEC_WRITE = 2 + (-32768);   	   NOECHO_SET = 4; 	    LU_ONE = 1;     B_LEN = 78;     P_LEN = 42;  	   MAX_LEVEL = 3;  	     CONST      ERRN_ADSPECLMBUFS  =  1;      ERRN_ADSPEGLOBALS  =  2;      ERRN_ADSPETABLES   =  3;      ERRN_ADSUNINIT     =  4;      ERRN_DIST_INCONST  =  5;      ERRN_ENT_CRIT      =  6;      ERRN_INCONST       =  7;      ERRN_INFO_LIMIT    =  8;      ERRN_INIT_INCONST  =  9;      ERRN_INIT_SHUT     = 10;      ERRN_INIT_START    = 11;      ERRN_INIT_UNINIT   = 12;      ERRN_INTERNAL      = 13;      ERRN_PART_INIT     = 14;      ERRN_SYS_DIST      = 15;      ERRN_VALID_LU      = 16;                  INF_MSG_LABEL = '(NSINFERR   )';          INTERN_ERR =                'NSINF : Internal Error';         XLUEX_ERR =               'NSINF : Error writing to output LU : ';       	   VALID_LU_ERR =  	              'NSINF : Valid LU choices are 0 to 255.';      	   ENT_CRIT_ERR =  	              'NSINF : No access to DSAM permitted.';         DISAST_INCONSISTANT =               '** Disaster: State of DSAM is inconsistant. **';     WARN_INCONSISTANT =  '             '** Warning: Inconsistency detected.  Try running NSINF again.';  '    WARN_UNINIT =               '** Warning: NS is not initialized. **';   
   WARN_INFO_LIMIT = 
               'NSINF will be denied access to some information.';   
   WARN_PE_CLMBUFS = 
 &             '** Warning: Parity error detected in DSAM clusters/mbufs. **'; & 
   WARN_PE_GLOBALS = 
 #             '** Warning: Parity error detected in Globals Area. **';  # 
   WARN_PE_TABLES =  
 "             '** Warning: Parity error detected in Tables Area. **'; "    WARN_SYS_DISASTER =  $             '** Disaster: State of DSAM is undefined. **  Value is :';  $    WARN_PROTO =                'Protocol stateword is :';   
   WARN_PART_INIT =  
              '** Warning: NS is not fully initialized. **';   
   WARN_INIT_SHUT =  
              'NSINIT aborted during shutdown.';   
   WARN_INIT_START = 
              'NSINIT aborted during startup.';     WARN_INIT_INCONST =               'NSINIT stateword is invalid; stateword is :';       TYPE     Charray6 = PACKED ARRAY [1..6] OF CHAR;     Charray78 = PACKED ARRAY [1..B_LEN] OF CHAR;          InputArrayType = ARRAY [0..MAX_LEVEL] OF Int16;      
   InfoRecordType = RECORD 
                       menu_level : Int16;                         inputs     : InputArrayType;                        next_line  : Int16;                         length     : Int16;                         buffer     : Charray78;                       END;      $   XluexControl = PACKED RECORD           { The control words used in }  $ $                  ov          : Posint2;  {   XLUEX write calls       }  $                   fil1        : Posint6;                    lu          : Posint8;                    subfunction : Posint10;                     fil2        : Posint6;                    END;         FTimeType = ARRAY [1..15] OF Int16;      ${---------------------------------------------------------------------}  $ {   {                   GLOBAL VARIABLES  {   ${---------------------------------------------------------------------}  $     VAR   	   length : Int16; 	    six_chars : Charray6;     temp_buf : Charray78;     output_LU : Int16;      cntrl_read,     cntrl_write : XluexControl;     areg,     breg : Int16;          $ SUBTITLE 'Export Procedures', PAGE $  ${---------------------------------------------------------------------}  $ {   {                   EXPORT PROCEDURES   {   ${---------------------------------------------------------------------}  $         {   {  Pick up the A and B registers }  {}  PROCEDURE ABReg   $ALIAS 'ABREG'$   	   (VAR a : Int16; 	 
    VAR b : Int16);  
     {   {  CNumD takes an integer and returns a character string that    {    represents that decimal integer in ascii.  System routine.    {}  PROCEDURE CNumD    $ALIAS 'CNUMD'$  
   (    num : Int16; 
     VAR sixchars : Charray6);           {   {  CNumO takes an integer and returns a character string that    {    represents that decimal integer in ascii.  System routine.    {}  PROCEDURE CNumO      $ALIAS 'CNUMO'$  
   (    num : Int16; 
     VAR sixchars : Charray6);           {    {  IfBrk returns an integer value to indicate whether or not the   {    user has set the break flag.  System routine.  {}  FUNCTION IfBrk      $ALIAS 'IFBRK'$      : Int16;           {   "{  InitializeIO assigns the correct values to the controlword arrays " !{    used in doing Exec I/0 with XLUEX calls.  Called once at the  ! 
{    start of NSINF. 
 {}  PROCEDURE InitializeIO;           {   !{  InsrtChr inserts the 'chars' of length 'len' into the buffer at ! {    the array position 'pos', and then returns the buffer and  "{    the next character position following the characters inserted.  " {}  	PROCEDURE InsrtChr 	    (VAR buffer : Charray78;   
    VAR chars : Charray78; 
 
        len : Int16; 
 
        pos : Int16; 
 
    VAR next_pos : Int16); 
     {   !{  InsrtDec converts the 'decint' into characters using CNUMDInt,  ! {    inserts them into the buffer at the array position 'pos',  #{    and returns the buffer and the next character position following  # {    the characters inserted.  Negative integers are handled.   !{  If 'justify' is set to a negative value by the calling routine, !  {    then the characters are left justified eliminating leading    #{    blanks. Otherwise, an integer that exceeds the range of a single  # !{    word integer is handled as doubleword integer and occupies an ! ${    11-character field, and a singleword integer occupies a 6-character $ ${    field.  If the caller wants to force a double-word field 'justify'  $ #{    should be set greater than zero.  A zero value for 'justify' sets # "{    up a single-word field for numbers in the range of single-word  " {    integers.  {}  	PROCEDURE InsrtDec 	    (VAR buffer : Charray78;           decint : Int32;   
        pos : Int16; 
 
    VAR next_pos : Int16;  
 
        justify : Int16);  
     {   {  InsrtOct converts the 'octint' into characters using CNUMO,  !{    inserts them into the buffer at the array position 'pos', and ! !{    returns the buffer and the next character position following  ! {    the characters inserted.   {}  	PROCEDURE InsrtOct 	    (VAR buffer : Charray78;           octint : Int16;   
        pos : Int16; 
 
    VAR next_pos : Int16); 
     {   {  More issues a prompt string and a read to LU 1 to which the  {    user may respond with a <CR> for the next screen or any  {    other input to end the current output.   {}  FUNCTION More      : BOOLEAN;           {    {   NmChek determines whether a PAC has only numeric characters    {}  FUNCTION NmChek   
   (VAR numstr : Charray6; 
 
        len : Int16) 
    : BOOLEAN;           {   {  PrError prepends the NSINF error label and an error  "{    number supplied as a parameter to the procedure.  Error number  " "{    is assumed to be one or two digits.  Only 64 characters of the  " "{    original message will be printed with the error label.  Buffer  " {    is blank upon return from this procedure.  {}  	PROCEDURE PrError  	    (VAR buffer : Charray78;           errnum : Int16);          {   "{  PrInfo simply writes the buffer to the selected print output LU.  " {}  PROCEDURE PrInfo     (VAR buffer : Charray78);          {   {  PrMenu simply writes the buffer to the user's terminal LU.   {}  PROCEDURE PrMenu     (VAR buffer : Charray78);      {   {  PromptIO issues a write to the user's terminal LU and then   !{    posts a read to obtain the user's input.  The procedure sets  ! #{    a BOOLEAN, user_input, indicating whether (TRUE) the user entered # !{    a value which is returned in 'return', or simply typed a <CR> ! "{    (FALSE).  The buffer used to prompt the user is 32 characters.  " #{    Numeric is set to TRUE if the user input was digits and FALSE if  # {    the input was non-numeric.   {}  	PROCEDURE PromptIO 	    (VAR buffer : Charray78;       VAR return : Int16;   
    VAR numeric: BOOLEAN;  
     VAR user_input : BOOLEAN);      {   !{  PromptMenu calls PromptIO and checks the boolean that PromptIO  ! !{    returns.  If the user's input is numeric and not characters,  ! "{    PromptIO is called again to give the user another prompt string " {    and read another user input.   {}  
FUNCTION PromptMenu  
    (VAR buffer : Charray78;       VAR return : Int16)      : BOOLEAN;       {   !{  PromptUser calls PromptIO and checks the boolean that PromptIO  ! !{    returns.  If the user's input is characters and not numeric,  ! "{    PromptIO is called again to give the user another prompt string " {    and read another user input.   {}  
FUNCTION PromptUser  
    (VAR buffer : Charray78;       VAR return : Int16)      : BOOLEAN;       {   "{  PrInsrtDec converts the 'decint' into characters using CNUMD and  " !{    inserts them into the buffer at the array position 'pos'.  If ! !{    'justify' is set to a negative value by the calling routine,  !  {    then the characters are left justified eliminating leading     {    blanks.  The buffer is then written to the LU of the user's   {    terminal.  {}  
PROCEDURE PrInsrtDec 
    (VAR buffer : Charray78;           decint : Int32;   
        pos : Int16; 
 
        justify : Int16);  
     {   "{  PrInsrtOct converts the 'octint' into characters using CNUMO and  " !{    inserts them into the buffer at the array position 'pos'; the ! {    buffer is then written to the LU of the user's terminal.   {}  
PROCEDURE PrInsrtOct 
    (VAR buffer : Charray78;           octint : Int16;           pos : Int16);       {   !{  PrInsrtChr inserts the 'chars' of length 'len' into the buffer  !  {    at the array position 'pos'; the buffer is then written to    {    the LU of the user's terminal.   {}  
PROCEDURE PrInsrtChr 
    (VAR buffer : Charray78;   
    VAR chars : Charray78; 
 
        len : Int16; 
         pos : Int16);       {   !{  ReadBuf reads a PAC from the user's terminal with an exec call. ! {}  	PROCEDURE ReadBuf  	    (VAR buffer : Charray78);      {   !{  UpShift scans the buffer for alphabetic characters and upshifts ! {    any that it encounters.  {}  	PROCEDURE UpShift  	    (VAR buffer : Charray78);      {   !{ WriteBuf writes a PAC to the output_LU or LU1 with an exec call. ! {   The buffer sent must be appended with LF/CR here.   {}  	PROCEDURE WriteBuf 	    (VAR outline : Charray78;          index : Int16;          is_prompt : BOOLEAN;  
        write_LU : Int16); 
         IMPLEMENT       $ TITLE 'Implement Section', PAGE $   $ SUBTITLE 'External Procedures', PAGE $  ${---------------------------------------------------------------------}  $ {   {                   EXTERNAL PROCEDURES   {   ${---------------------------------------------------------------------}  $     {   {  Pick up the A and B registers }  {}  PROCEDURE ABReg   	   (VAR a : Int16; 	 
    VAR b : Int16);  
    EXTERNAL;      {   {  CNumD takes an integer and returns a character string that    {    represents that decimal integer in ascii.  System routine.    {}  PROCEDURE CNumD   
   (    num : Int16; 
     VAR sixchars : Charray6);      EXTERNAL;          {   {  CNumO takes an integer and returns a character string that    {    represents that decimal integer in ascii.  System routine.    {}  PROCEDURE CNumO   
   (    num : Int16; 
     VAR sixchars : Charray6);      EXTERNAL;      {   ${  Exec is an RTE I/O routine used here for terminal reads and writes to $ {    terminal or other log LU.  {}  PROCEDURE Xluex            $ ALIAS 'XLUEX', NOABORT $      (    rcode : Int16;          ctl : XluexControl;       VAR buf : Charray78;          length : Int16);     EXTERNAL;      {   &{ System routine to get the year, date, day of the week and time in ascii }  & {}  PROCEDURE FTime      (VAR ftime_buf : FTimeType);      EXTERNAL;          {    {  IfBrk returns an integer value to indicate whether or not the   {    user has set the break flag.  System routine.  {}  FUNCTION IfBrk     : Int16;      EXTERNAL;      {   "{  Kcvt returns two least significant ascii characters representing  "  {    the value of 'num'.  The ascii characters are stored in the   {    function return value.   {}  FUNCTION Kcvt      (num : Int16)     : Int16;      EXTERNAL;          $ SUBTITLE 'InitializeIO', PAGE $   ${---------------------------------------------------------------------}  $ {   {                  PROCEDURE InitializeIO   {   ${---------------------------------------------------------------------}  $ {   "{  InitializeIO assigns the correct values to the controlword arrays " !{    used in doing Exec I/0 with XLUEX calls.  Called once at the  ! 
{    start of NSINF. 
 {}  PROCEDURE InitializeIO;       BEGIN   { InitializeIO }      #   cntrl_read.ov := 0;                 { Set No Echo bit for exec   }  # #   cntrl_read.fil1 := 0;               {   reads (Xluex)            }  # #   cntrl_read.lu := LU_ONE;            { And initialize to LU 1     }  #    cntrl_read.fil2 := 0;     cntrl_read.subfunction := NOECHO_SET;      #   cntrl_write.ov := 0;                { Initialize to LU 1 for exec } # #   cntrl_write.fil1 := 0;              {   writes (Xluex)            } #    cntrl_write.lu := LU_ONE;  
   cntrl_write.fil2 := 0;  
    cntrl_write.subfunction := 0;      END;    { InitializeIO }          $ SUBTITLE 'InsrtChr', PAGE $   ${---------------------------------------------------------------------}  $ {   {                   PROCEDURE InsrtChr  {   ${---------------------------------------------------------------------}  $ {   !{  InsrtChr inserts the 'chars' of length 'len' into the buffer at ! {    the array position 'pos', and then returns the buffer and  "{    the next character position following the characters inserted.  " {}  	PROCEDURE InsrtChr 	    (VAR buffer : Charray78;   
    VAR chars : Charray78; 
 
        len : Int16; 
 
        pos : Int16; 
 
    VAR next_pos : Int16); 
     VAR      i : Int16;  { FOR loop control }       
BEGIN   { InsrtChr } 
     
   next_pos := pos + len;  
    IF next_pos <= (B_LEN + 1) THEN        BEGIN   
      FOR i := 1 TO len DO 
          BEGIN           buffer [pos + i - 1] := chars [i];            END;  { For }  	      END;  { If } 	     
END;    { InsrtChr } 
         $SUBTITLE 'InsrtDec', PAGE $  ${---------------------------------------------------------------------}  $ {   {                   PROCEDURE InsrtDec  {   ${---------------------------------------------------------------------}  $ {   !{  InsrtDec converts the 'decint' into characters using CNUMDInt,  ! {    inserts them into the buffer at the array position 'pos',  #{    and returns the buffer and the next character position following  # {    the characters inserted.  Negative integers are handled.   "{    If 'justify' is set to a negative value by the calling routine, "  {    then the characters are left justified eliminating leading    #{    blanks. Otherwise, an integer that exceeds the range of a single  # !{    word integer is handled as doubleword integer and occupies an ! ${    11-character field, and a singleword integer occupies a 6-character $ ${    field.  If the caller wants to force a double-word field 'justify'  $ #{    should be set greater than zero.  A zero value for 'justify' sets # "{    up a single-word field for numbers in the range of single-word  " {    integers.  {}  	PROCEDURE InsrtDec 	    (VAR buffer : Charray78;           decint : Int32;   
        pos : Int16; 
 
    VAR next_pos : Int16;  
 
        justify : Int16);  
     TYPE     Charray10 = PACKED ARRAY [1..10] OF CHAR;      VAR   
   double : BOOLEAN; 
    negative : BOOLEAN;     i : Int16;      x : Int16;      char_count : Int16;  
   ten_chars : Charray10;  
         $SUBTITLE 'CNumDInt', PAGE$   {---------------------------------------------------------}   {         Local Procedure CNumDInt  {---------------------------------------------------------}       	PROCEDURE CNumDInt 	    (    decint : Int32;       VAR ten_chars : Charray10);       TYPE     DigitArrayType = ARRAY [0..9] OF CHAR;       CONST   $   DIGIT_ARRAY = DigitArrayType ['0', '1', '2', '3', '4', '5', '6', '7', $                                  '8', '9'];   VAR   	   digit : Int16;  	 	   x     : Int16;  	         
BEGIN  { CNumDInt }  
     $   x := 10;   { index the character array with least significant digit } $        REPEAT   
   digit := decint MOD 10; 
    decint := decint DIV 10;       %   ten_chars [x] := DIGIT_ARRAY [digit];   { next most significant digit } %    x := x - 1;      &   UNTIL (decint = 0) OR (x < 1);    { index can never become less than 1 }  &     
END;   { CNumDInt }  
         $SUBTITLE 'InsrtDec', PAGE $  ${---------------------------------------------------------------------}  $ {   {                   PROCEDURE InsrtDec  {   ${---------------------------------------------------------------------}  $ 
BEGIN   { InsrtDec } 
     IF decint = MININT THEN      BEGIN     temp_buf := '-2147483648';      InsrtChr (buffer, temp_buf, 11, pos, next_pos);     END      ELSE BEGIN     IF decint < 0 THEN         BEGIN         decint := 0 - decint;         negative := TRUE;         END   
   ELSE negative := FALSE; 
         &   double := (decint > 65535)  { double indicates that a larger field will } & &             OR (justify > 0); {  be used to format this number, 11, not 6 } &     
   ten_chars := ' '; 
    CNUMDInt (decint, ten_chars);      '   x := 1;                      { find the size of the number in characters }  '    WHILE (ten_chars [x] = ' ') AND           ( x < 10) DO         BEGIN   	      x := x + 1;  	       END;         IF (justify < 0) THEN  %      BEGIN                 { x is position in ten_chars of first digit }  %       char_count := 10 - x + 1;         IF negative THEN           char_count := char_count + 1;        END      ELSE IF double THEN  '      char_count := 11      { standard field size for right-justified Int32 }  ' '   ELSE char_count := 6;    {     "      "     "   "       "          Int16 }  '        next_pos := pos + char_count;  #   IF next_pos <= (B_LEN + 1) THEN    { will all the characters fit? } #       BEGIN       '      IF justify >= 0 THEN       { find starting position of right-justified } ' '         BEGIN                   {   number in the receiving buffer          } '          pos := pos + x;               IF NOT double THEN   $            BEGIN                { account for large cnumdint buffer:  } $ $            pos := pos - 5 - 1;  {   min(x) = 6, max(x) = 10 for       } $ $            END                  {   single-word integers              } $ $         ELSE BEGIN              {                                     } $ $            pos := pos - 1;      { ...and for position of '-' in fixed } $ $            END;                 {   fields of 6 and 11 characters     } $              END;    { if right justify }             IF negative THEN           BEGIN           buffer [pos] := '-';            END;   { left justify and negative }             IF (negative) OR (justify >= 0) THEN pos := pos + 1;             FOR i := x TO 10 DO        { put in the digits of decint }            BEGIN           buffer [pos] :=  ten_chars [i];           pos := pos + 1;           END;  { for }            END;   { if next_pos }         END;   { if decint = minint }      
END;    { InsrtDec } 
         $ SUBTITLE 'InsrtOct', PAGE $   ${---------------------------------------------------------------------}  $ {   {                   PROCEDURE InsrtOct  {   ${---------------------------------------------------------------------}  $ {   {  InsrtOct converts the 'octint' into characters using CNUMO,  !{    inserts them into the buffer at the array position 'pos', and ! !{    returns the buffer and the next character position following  ! {    the characters inserted.   {}  	PROCEDURE InsrtOct 	    (VAR buffer : Charray78;           octint : Int16;   
        pos : Int16; 
 
    VAR next_pos : Int16); 
     VAR      i : Int16;  { FOR loop control }       
BEGIN   { InsrtOct } 
        next_pos := pos + 6;       $   { We need to make sure we have room for this and the 'b' at the end } $ 
   IF next_pos <= 78 THEN  
       BEGIN             CNumO (octint, six_chars);        FOR i := 1 TO 6 DO           BEGIN           buffer[pos + i - 1] := six_chars[i];            END;  { For }            buffer[next_pos] := 'b';        next_pos := next_pos + 1;         END;   { If next_pos }      
END;    { InsrtOct } 
         
$ SUBTITLE 'More', PAGE $  
 ${---------------------------------------------------------------------}  $ {   {                        FUNCTION More  {   ${---------------------------------------------------------------------}  $ {   {  More issues a prompt string and a read to LU 1 to which the  {    user may respond with a <CR> for the next screen or any  {    other input to end the current output.  If the output LU   {    is not LU 1, however, nothing is done.   {}  FUNCTION More      : BOOLEAN;       CONST      MORE_PROMPT = '              --- More ---';      VAR      response : BOOLEAN;  #   dummy1 : Int16;          { parameters used in prompts for actual }  # #   dummy2 : BOOLEAN;        {  user inputs of numbers and chars.    }  # BEGIN  { More }          IF output_LU = LU_ONE THEN         BEGIN             temp_buf := MORE_PROMPT;        PromptIO (temp_buf, dummy1, dummy2, response);        More := NOT response;         temp_buf := ' ';            END          ELSE More := TRUE;       END;   { More }           $ SUBTITLE 'NmChek', PAGE $   ${---------------------------------------------------------------------}  $ {   {                        FUNCTION NmChek  {   ${---------------------------------------------------------------------}  $ {    {  NmChek determines whether a PAC has only numeric characters,    {     including a minus sign.   {}  FUNCTION NmChek   
   (VAR numstr : Charray6; 
 
        len : Int16) 
       : BOOLEAN;      VAR      Numeric : Boolean;      Pos : Int16;      { Character position within parm }       	BEGIN  { NmChek }  	 
   numeric := TRUE;  
    pos := 1;         REPEAT         CASE (numstr[pos]) OF             '0'..'9',              '-': BEGIN                   pos := pos + 1   { move on to next one }  
                END  
       Otherwise BEGIN                   numeric := FALSE  
                END  
       END;     UNTIL (pos > len) OR (NOT numeric);         NmChek := numeric;     { Function returns boolean value }      END;  {NmChek }       $ SUBTITLE 'PrError', PAGE $  ${---------------------------------------------------------------------}  $ {   {                      PROCEDURE PrError  {   ${---------------------------------------------------------------------}  $ {   {  PrError prepends the NSINF error label and an error  "{    number supplied as a parameter to the procedure.  Error number  " "{    is assumed to be one or two digits.  Only 64 characters of the  " "{    original message will be printed with the error label.  Buffer  " {    is blank upon return from this procedure.  {}  	PROCEDURE PrError  	    (VAR buffer : Charray78;           errnum : Int16);  VAR   
   next_pos : Int16; 
     
BEGIN   { PrError }  
        temp_buf := INF_MSG_LABEL;          InsrtDec (temp_buf, errnum, 11, next_pos, -1);       $              { Only 64 characters of the original buffer will now fit } $    InsrtChr (temp_buf, buffer, 78 - 14, 15, next_pos);      #   buffer := temp_buf;   { PrMenu will return buffer with all blanks } # 
   PrMenu (buffer);  
         
END;    { PrError }  
         $ SUBTITLE 'PrInfo', PAGE $   ${---------------------------------------------------------------------}  $ {   {                   PROCEDURE PrInfo  {   ${---------------------------------------------------------------------}  $ {   "{  PrInfo simply writes the buffer to the selected print output LU.  " {   {}  PROCEDURE PrInfo     (VAR buffer : Charray78);      	BEGIN   { PrInfo } 	        WriteBuf (buffer, B_LEN, FALSE, output_LU);     buffer := '';           { Reinitialize buffer }      	END;    { PrInfo } 	             $ SUBTITLE 'PrMenu', PAGE $   ${---------------------------------------------------------------------}  $ {   {                   PROCEDURE PrMenu  {   ${---------------------------------------------------------------------}  $ {   {   {  PrMenu simply writes the buffer to the user's terminal LU.   {}  PROCEDURE PrMenu     (VAR buffer : Charray78);      	BEGIN   { PrMenu } 	        WriteBuf (buffer, B_LEN, FALSE, LU_ONE);      buffer := '';           { Reinitialize buffer }      	END;    { PrMenu } 	             $ SUBTITLE 'PromptIO', PAGE $   ${---------------------------------------------------------------------}  $ {   {                  PROCEDURE PromptIO   {   ${---------------------------------------------------------------------}  $ {   {  PromptIO issues a write to the user's terminal LU and then   !{    posts a read to obtain the user's input.  The procedure sets  ! #{    a BOOLEAN, user_input, indicating whether (TRUE) the user entered # !{    a value which is returned in 'return', or simply typed a <CR> ! "{    (FALSE).  The buffer used to prompt the user is 32 characters.  " #{    Numeric is set to TRUE if the user input was digits and FALSE if  # {    the input was non-numeric.   {}  	PROCEDURE PromptIO 	    (VAR buffer : Charray78;       VAR return : Int16;   
    VAR numeric: BOOLEAN;  
     VAR user_input : BOOLEAN);      CONST   
   ASCII_BASE = 48;  
    CR = 13;      NULL = 0;      TYPE     InputType = RECORD CASE Int16 OF                    1 : (int : Int16);                    2 : (chrs : PACKED ARRAY [1..2] OF CHAR);                   3 : (intchrs : Charray6);                   4 : (prompt_buffer : Charray78);   
               END;  
 VAR      input : InputType;      still_counting : BOOLEAN;     negative : BOOLEAN;     i : Int16;      x : Int16;           $SUBTITLE 'Process Input', PAGE$  ${---------------------------------------------------------------------}  $ {   {                   PROCEDURE ProcessInput  {   ${---------------------------------------------------------------------}  $     
   PROCEDURE ProcessInput; 
        BEGIN   { Process Input }         WITH input DO        BEGIN             numeric := TRUE;        still_counting := TRUE;   	      return := 0; 	           x := 6;         WHILE ((intchrs[x] = ' ') OR (Ord(intchrs[x]) = CR)             OR (Ord(intchrs[x]) = NULL))            AND (x > 1) DO  &         x := x - 1;                    { Actual non-blank character input } &           IF NmChek (intchrs, x) THEN            BEGIN                 { Input is integer value }            negative := FALSE;            i := 1;               WHILE still_counting AND (i <= x) DO   	            BEGIN  	                 IF intchrs[i] <> ' ' THEN   
               BEGIN 
                    IF intchrs[i] <> '-' THEN                    BEGIN   &                  return := (return * 10) + (Ord (intchrs[i]) - ASCII_BASE); &                   END       
               ELSE BEGIN  
                   IF NOT negative  THEN   
                     BEGIN 
                      negative := TRUE;                       END                    ELSE BEGIN                       still_counting := FALSE;   
                     END;  
                       END;  { If intchr is '-' }                     END;  { If intchrs is ' ' }                  i := i + 1;                   END;   { While still counting }       
         IF negative THEN  
 	            BEGIN  	             return := -return;              END;               END   { Input is integer value }             ELSE BEGIN        { Input is menu selection }                Upshift (prompt_buffer);            return := int;   
         numeric := FALSE; 
              END;  { Input is menu selection }      
      END;  { With } 
        END;    { Process Input }          $ SUBTITLE 'PromptIO', PAGE $   ${---------------------------------------------------------------------}  $ {   {                  PROCEDURE PromptIO   {   ${---------------------------------------------------------------------}  $ 
BEGIN   { PromptIO } 
     WITH input DO      BEGIN     prompt_buffer := '';          IF buffer <> '' THEN        BEGIN        x := P_LEN + 1;   $      REPEAT                      { Find the end of the prompt string }  $ 
         x := x - 1; 
       UNTIL (buffer[x] <> ' ') OR (x = 1);            i := 0;   #      WHILE (i <= (x - 1)) AND     { Right-justify the prompt string } # 
            (i <P_LEN) DO  
          BEGIN           prompt_buffer[(P_LEN - 1) - i] := buffer[x - i];   
         i := i + 1; 
          END;         END;         WriteBuf (prompt_buffer, P_LEN, TRUE, LU_ONE);      prompt_buffer := '';      ReadBuf (prompt_buffer);       &   user_input := (Ord(prompt_buffer[1]) <> CR); { False if null user input } &        ProcessInput;  	   END;  { With }  	     	END;  { PromptIO } 	     $ SUBTITLE 'PromptMenu', PAGE $   {   !{  PromptMenu calls PromptIO and checks the boolean that PromptIO  ! !{    returns.  If the user's input is numeric and not characters,  ! "{    PromptIO is called again to give the user another prompt string " {    and read another user input.   {}  
FUNCTION PromptMenu  
    (VAR buffer : Charray78;       VAR return : Int16)      : BOOLEAN;       VAR numeric : BOOLEAN;  
    user_input : BOOLEAN;  
     BEGIN  { PromptMenu }          PromptIO (buffer, return, numeric, user_input);      &   IF user_input THEN     { In case the user typed a number, prompt again. } & &      BEGIN               { Characters are expected for menu selection.    } &           WHILE user_input AND numeric DO            PromptIO (buffer, return, numeric, user_input);            END;         PromptMenu := user_input;     buffer := '';      END;   { PromptMenu }           $ SUBTITLE 'PromptUser', PAGE $   {   !{  PromptUser calls PromptIO and checks the boolean that PromptIO  ! !{    returns.  If the user's input is characters and not numeric,  ! "{    PromptIO is called again to give the user another prompt string " {    and read another user input.   {}  
FUNCTION PromptUser  
    (VAR buffer : Charray78;       VAR return : Int16)      : BOOLEAN;           VAR numeric : BOOLEAN;  
    user_input : BOOLEAN;  
     BEGIN  { PromptUser }          PromptIO (buffer, return, numeric, user_input);      &   IF user_input THEN     { In case the user typed letters, prompt again. }  & &      BEGIN               { Digits are expected for user selection.       }  &           WHILE user_input AND NOT numeric DO            PromptIO (buffer, return, numeric, user_input);            END;         PromptUser := user_input;     buffer := '';      END;   { PromptUser }       $ SUBTITLE 'PrInsrtDec', PAGE $   ${---------------------------------------------------------------------}  $ {   {                   PROCEDURE PrInsrtDec  {   ${---------------------------------------------------------------------}  $ {   "{  PrInsrtDec converts the 'decint' into characters using CNUMD and  " !{    inserts them into the buffer at the array position 'pos'.  If ! !{    'justify' is set to a negative value by the calling routine,  !  {    then the characters are left justified eliminating leading     {    blanks.  The buffer is then written to the LU of the user's   {    terminal.  {}  
PROCEDURE PrInsrtDec 
    (VAR buffer : Charray78;           decint : Int32;   
        pos : Int16; 
 
        justify : Int16);  
     VAR   	   dummy : Int16;  	     BEGIN   { PrInsrtDec }         InsrtDec (buffer, decint, pos, dummy, justify);  
   PrInfo (buffer);  
     END;    { PrInsrtDec }          $ SUBTITLE 'PrInsrtOct', PAGE $   ${---------------------------------------------------------------------}  $ {   {                   PROCEDURE PrInsrtOct  {   ${---------------------------------------------------------------------}  $ {   "{  PrInsrtOct converts the 'octint' into characters using CNUMO and  " !{    inserts them into the buffer at the array position 'pos'; the ! {    buffer is then written to the LU of the user's terminal.   {}  
PROCEDURE PrInsrtOct 
    (VAR buffer : Charray78;           octint : Int16;           pos : Int16);       VAR      next_pos : Int16;   { dummy parameter variable }       BEGIN   { PrInsrtOct }         InsrtOct (buffer, octint, pos, next_pos);  
   PrInfo (buffer);  
     END;     { PrInsrtOct }           $ SUBTITLE 'PrInsrtChr', PAGE $   ${---------------------------------------------------------------------}  $ {   {                   PROCEDURE PrInsrtChr  {   ${---------------------------------------------------------------------}  $ {   !{  PrInsrtChr inserts the 'chars' of length 'len' into the buffer  !  {    at the array position 'pos'; the buffer is then written to    {    the LU of the user's terminal.   {}  
PROCEDURE PrInsrtChr 
    (VAR buffer : Charray78;   
    VAR chars : Charray78; 
 
        len : Int16; 
         pos : Int16);       VAR      next_pos : Int16;   { dummy parameter variable }       BEGIN   { PrInsrtChr }         InsrtChr (buffer, chars, len, pos, next_pos);  
   PrInfo (buffer);  
     END;   { PrInsrtChr }           $ SUBTITLE 'ReadBuf', PAGE $  ${---------------------------------------------------------------------}  $ {   {                      PROCEDURE ReadBuf  {   ${---------------------------------------------------------------------}  $ {   !{  Readbuf reads a PAC from the user's terminal with an exec call. ! {}  	PROCEDURE ReadBuf  	     (VAR buffer : Charray78);       
BEGIN   { ReadBuf }  
        Xluex (EXEC_READ, cntrl_read, buffer, -P_LEN);             BEGIN   { Error handling from no abort call }         ABreg (areg,breg);          { Nothing to be done }        END;    { Error handling from no abort call }       
END;    { ReadBuf }  
     $ SUBTITLE 'UpShift', PAGE $  ${---------------------------------------------------------------------}  $ {   {                      PROCEDURE UpShift  {   ${---------------------------------------------------------------------}  $ {   !{ UpShift scans the buffer for alphabetic characters and upshifts  ! {   any that it encounters.   {}  	PROCEDURE Upshift  	    (VAR buffer : Charray78);      CONST   
   ASCII_CAPS = 32;  
     VAR      i : Int16;    { For loop control }       	BEGIN  { UpShift } 	 
   FOR i := 1 TO B_LEN DO  
 
      BEGIN { For }  
       IF (buffer [i] >= 'a') AND (buffer [i] <= 'z') THEN            BEGIN           buffer[i] := Chr (Ord (buffer[i]) - ASCII_CAPS);            END;   
      END;  { For }  
 	END;   { UpShift } 	         $ SUBTITLE 'WriteBuf', PAGE $   ${---------------------------------------------------------------------}  $ {   {                       PROCEDURE WriteBuf  {   ${---------------------------------------------------------------------}  $ {   !{ WriteBuf writes a PAC to the output_LU or LU1 with an exec call. !  {   The buffer sent must be appended with a symbol to the driver    {   not to issue a CR/LF in case this is the prompt message that   {   preceeds a Read from the terminal.  {}  	PROCEDURE WriteBuf 	    (VAR outline : Charray78;          index : Int16;          is_prompt : BOOLEAN;  
        write_LU : Int16); 
     TYPE     CnvrtRetrn = RECORD CASE Int16 OF                    1 : (chrs : PACKED ARRAY [1..4] OF CHAR);                     2 : (ints : ARRAY [1..2] OF Int16);                    END;       VAR      i : Int16;      return_code : CnvrtRetrn;     err_chrs : Charray78;     err_buf : Charray78;   
   next_pos : Int16; 
     
BEGIN  { WriteBuf }  
     "   IF IS_PROMPT THEN         { Special handling for prompt buffers } "       BEGIN         outline[index + 1] := ' ';        outline[index + 2] := '_';  
      index := index + 2;  
       END   %   ELSE BEGIN                { Eliminate ending blanks in other buffers }  % 	      i := index;  	       WHILE (outline [i] = ' ') AND (i > 1) DO           BEGIN  
         i := i - 1; 
          END;   	      index := i;  	       END;         cntrl_write.lu := write_LU;         Xluex (EXEC_WRITE, cntrl_write, outline, -index);            BEGIN   { Error handling from no abort call }       
      ABReg (areg, breg);  
       return_code.ints[1] := areg;        return_code.ints[2] := breg;        err_chrs := return_code.chrs;         err_buf := XLUEX_ERR;         InsrtChr (err_buf, err_chrs, 4, 38, next_pos);            cntrl_write.lu := LU_ONE;         Xluex (EXEC_WRITE, cntrl_write, err_buf, 25);            BEGIN     { Error handling from no abort call }           ABReg (areg, breg);           END;      { Error handling from no abort call }            END;    { Error handling from no abort call }       
END;   { WriteBuf }  
         END. 