 $PASCAL '   91790-16056 REV.4010 <860409.1541>'   $TITLE 'FMTRC Formatting routines'$   
$STANDARD_LEVEL 'HP1000' $ 
 $DEBUG $  $RECURSIVE OFF$   $ HEAP 2 $  
$ HEAP_DISPOSE OFF $ 
 $ SUBPROGRAM $  $ CDS ON $  $ RANGE OFF $           PROGRAM FMTER;      %{------------------------------------------------------------------------  %     "   (c) COPYRIGHT HEWLETT PACKARD COMPANY 1986.  ALL RIGHTS RESERVED. "    NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED, REPRODUCED, OR   "   TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT THE PRIOR WRITTEN  "    CONSENT OF THE HEWLETT-PACKARD COMPANY.      % ------------------------------------------------------------------------} %     {}  {        NAME : FMTER   {      SOURCE : 91790-18056   {       RELOC : 91790-16056   
{        PGMR : JXL  
 {}  { MODIFICATIONS:  #{  4/7/86   ash   SR#34728 Non stream 13 messages have only 2 words of # {                 local appendage. Routine: DumpMessage.  %{                 SR#35980 A destination node may be a -LU.  CNumD expects % {                 an unsigned integer.  Routine: InsertNumber   {                 SR#35972 Format the MA channel down message.  {                 Routine: FilterMessges  #{                 SR#34702 Add undecipherable message to the formatted # {                 file.  Routine: DumpError   {}  {  FMTER is a segment of the Trace Formatter FMTRC.   {}  "{  FMTRC reads unformatted messages out of a VMA file that has been  " !{  created by the AdvanceDS program NETRC.  FMTRC formats the raw  ! "{  trace messages  and analyzes the messages somewhat.  The user can " !{  specify options that limit the formatted output to a subset of  ! {  the messages contained in the raw trace file.  {   {}  !$INCLUDE 'src/FMTRC.PASI', SUBTITLE 'Imports and Globals'; PAGE $  !     {}  { Constants used throughout this segment.   {}      CONST          { This is the size of the fixed header area }  
   MIN_RTR_HEAD_LEN = 13;  
    { this is the smallest router header known to man }     MA_CHANNEL_DOWN_LEN = MIN_RTR_HEAD_LEN  + 1;           $SUBTITLE 'External Procedures', PAGE$  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   External Procedures                           }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " 	$ HEAPPARMS OFF $  	     '{ Converts a binary number to its ascii representation as a decimal integer }  ' PROCEDURE CNumD      (   num : Int16;     { Binary Number }   
    VAR chars : SixChar);  
    EXTERNAL;      &{ Converts a binary number to its ascii representation as an octal integer } & PROCEDURE CNumO      (   num : Int16;     { Binary Number }   
    VAR chars : SixChar);  
    EXTERNAL;      	FUNCTION FmpClose  	    (VAR dcb : DcbType;          error : Int16)     : Int16;      EXTERNAL;          FUNCTION FmpInteractive      (VAR dcb : DcbType)     : Int16;      EXTERNAL;          
$ FIXED_STRING ON $  
     FUNCTION FmpOpen     (VAR dcb : DcbType;      VAR error : Int16;          filedesc : String64;  
        options : Optype;  
         bufs : Int16)      : Int16;      EXTERNAL;      
$ FIXED_STRING OFF $ 
         	FUNCTION FmpWrite  	    (VAR dcb : DcbType;          error : Int16;          fmp_buffer : FmpBufferType;   
        maxlength : Int16) 
    : Int16;      EXTERNAL;          PROCEDURE FTime      (VAR time_array : FtimeType);     EXTERNAL;          $ HEAPPARMS ON $      PROCEDURE GetHeapStackInfo    $ ALIAS 'Pas.GetMemInfo2' $      (VAR heap_Info : Info_Rec);     EXTERNAL;      	$ HEAPPARMS OFF $  	         FUNCTION IAnd   	    (num1 : Int16; 	 	     num2 : Int16) 	    : Int16;      EXTERNAL;          FUNCTION IfBrk     : Int16;      EXTERNAL;          FUNCTION IfTTY     (lu : Int16)      : Int16;      EXTERNAL;          FUNCTION PasSParms    $ ALIAS 'Pas.SParameters' $      (    pos : Int16;    { Parameter number }      VAR parm : String)  !   : Int16;             { Length of the parameter in characters }  !    EXTERNAL;          
$ FIXED_STRING ON $  
     	PROCEDURE VmaOpen  	    (VAR error : Int16;          name : String64;          optn : optype);      External;      
$FIXED_STRING OFF $  
     $SUBTITLE 'FMTRC routines',PAGE$  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{              FMTRC Routines                                     }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " %$ HEAPPARMS ON $      { Heapparms option should be left on for the rest }  %         PROCEDURE AddErrorCode     (VAR msg_text   : String72;          error_code : Int16);        EXTERNAL;           PROCEDURE AddMsgHeader     (    msg_number : Int16;       VAR msg_buf    : String72;          exception  : BOOLEAN);        EXTERNAL;       PROCEDURE CheckFmpError   
   (error : Int16);  
       EXTERNAL;       PROCEDURE CheckFmpWriteError  
   (error : Int16);  
       EXTERNAL;       
FUNCTION ConvertTime 
    (integer_time : Int32) : CharTimeType;         FORWARD;      PROCEDURE CNumA      (    num : Int16;     { Binary Number }  
    VAR chars : SixChar);  
       FORWARD;      
PROCEDURE DumpBuffer 
    (VAR buffer : DBType;          buflen : Int16);     FORWARD;       
PROCEDURE DumpError  
    (VAR msg_buf   : String72;       VAR format_info  : FormatInfoType;      VAR msgline   : msgbuffer);      FORWARD;       	PROCEDURE DumpLine 	    (VAR  outline  : OutlineType);         FORWARD;      PROCEDURE DumpMessage      (VAR format_info : FormatInfoType;   
    VAR msg : MsgBuffer);  
       FORWARD;      PROCEDURE FilterMessages     (VAR options : OptionsType;      VAR VMA_info : VmaInfoType;       VAR SSNs : SSNsPtr);        FORWARD;      PROCEDURE FormatAscLine   
   (VAR  wordsfmt : Int16; 
 
         buflen   : Int16; 
     VAR  buffer   : DBType;       VAR  outline  : OutlineType);      FORWARD;       PROCEDURE FormatNumLine   
   (VAR  wordsfmt : Int16; 
 
         buflen   : Int16; 
     VAR  buffer   : DBType;       VAR  outline  : OutlineType);      FORWARD;       
PROCEDURE GetSocket  
    (sequence_no : Int16;      VAR SSNs : SSNsPtr;       VAR the_socket : Int16);        FORWARD;      PROCEDURE ProcessGateway     (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR SSNs : SSNsPtr);        FORWARD;      PROCEDURE ProcessLAN802      (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR SSNs : SSNsPtr);        FORWARD;      
PROCEDURE ProcessLU  
    (VAR msg       : MsgBuffer);         FORWARD;      
PROCEDURE ProcessNLM 
    (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR format_info : FormatInfoType;       VAR SSNs : SSNsPtr);        FORWARD;      
PROCEDURE ProcessSLM 
    (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR format_info : FormatInfoType);        FORWARD;      PROCEDURE ProcessRouter      (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR format_info : FormatInfoType);        FORWARD;      PROCEDURE UIWriteExcept      (VAR except_string : STRING);        EXTERNAL;           $ SUBTITLE 'ConvertTime', PAGE $  %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{                 ConvertTime                                           }  % %{                                                                       }  % %{-----------------------------------------------------------------------}  % 
FUNCTION ConvertTime 
 
   (integer_time : Int32)  
 	   : CharTimeType; 	 {   { This function takes a 2 word integer time value and converts  ${ it into a five word array value of hours(HH), minutes(MM), seconds(SS) $ { and centiseconds(LL) in the form <SP>HH:MM:SS:LL.   {}      CONST      TIMEPLATE = ' 00:00:00:00  ';      VAR   	   tempIT : Int32; 	    tempTA : ARRAY [1..4] OF Int16;     tempPrettyTA : CharTimeType;      dec_chars : SixChar;   
   x : Int16;   { Fudge }  
    i : Int16;   { FOR loop control }      
BEGIN {ConvertTime}  
 tempTA[4] := integer_time MOD 100;  tempIT := integer_time DIV 100;   tempTA[3] := tempIT MOD 60;   tempIT := tempIT DIV 60;  tempTA[2] := tempIT MOD 60;   tempTA[1] := tempIT DIV 60;       tempPrettyTA.chr := TIMEPLATE;  x := -1;     { initialize }   	FOR i := 1 TO 4 DO 	    BEGIN     x := x +2;                    { fudge for space or ':' }      CNumD (tempTA[i], dec_chars);  $   tempPrettyTA.chr[i + x]     := dec_chars[5]; { first of two digits }  $ $   tempPrettyTA.chr[i + x + 1] := dec_chars[6]; { second of two digits } $    END;       !FOR i := 2 TO 12 DO              { turn blank digits into zeros }  !    BEGIN     IF tempPrettyTA.chr[i] = ' ' THEN        BEGIN         tempPrettyTA.chr[i] := '0';         END;     END;       ConvertTime := tempPrettyTA;  
END;  {ConvertTime}  
         
$ SUBTITLE 'CNumA', PAGE $ 
 %{-----------------------------------------------------------------------}  % %{                                                                       }  % %{                 CNumA                                                 }  % %{                                                                       }  % %{-----------------------------------------------------------------------}  % PROCEDURE CNumA      (   num : Int16;     { Binary Number }   
    VAR chars : SixChar);  
 {   #{ This procedure translates an integer into characters that represent  # { the ascii values of the two bytes of the integer word.  {}      TYPE     BytesType = RECORD CASE BOOLEAN OF                   TRUE:  (int : Int16);                   FALSE: (byt : PACKED ARRAY [1..2] OF Byte);   	              END; 	 VAR   
   i, j, n : Int16;  
    chs : CC;     bytes : BytesType;       BEGIN { CNumA }       
   bytes.int := num; 
    chars := '      ';      n := 0;         FOR i := 1 TO 2 DO    { Which byte }       BEGIN           FOR j := 1 TO 2 DO       { Which character }         BEGIN         chars[j + n] := ch_table[bytes.byt[i]][j];          END;       n := n + 3;           END;      END;  { CNumA }           $ SUBTITLE 'DumpBuffer', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                    DumpBuffer                                   }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " 
PROCEDURE DumpBuffer 
    (VAR buffer : DBType;          buflen : Int16);      VAR   #   prev_wfmt   : Int16;    { used to retrain the previous word count } # 
   outline  : OutlineType; 
 &   wordsfmt : Int16; { Number of words in buffer which have been formatted } &     
BEGIN { dumpbuffer } 
 wordsfmt := 0;  
WHILE wordsfmt < buflen DO 
    BEGIN  
   prev_wfmt := wordsfmt;  
    outline.chr := ALL_BLANKS;      FormatNumLine (wordsfmt, buflen, buffer, outline);      DumpLine (outline);         FormatAscLine (prev_wfmt, buflen, buffer, outline);     DumpLine (outline);  	   END; { while }  	     
END;  { dumpbuffer } 
         $ SUBTITLE 'DumpError', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                    DumpError                                    }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " 
PROCEDURE DumpError  
    (VAR msg_buf   : String72;       VAR format_info  : FormatInfoType;      VAR msgline   : msgbuffer);       {}  { Discussion  {  Procedure to write an undecipherable message to the file.  #{  We will assume that the reason it is undecipherable came before the # "{  trace program.  That is, that all the special fields in msgbuffer " 
{  still make sense. 
 {   !{  The output consists of a timestamp, the message buffer and the  ! 
{  appendage buffer. 
 {}      VAR       cnvt_buffer : DBType;   { needed so we may have one routine }      i  : Int16;     outline  :  OutlineType;      timestr  :  Chartimetype;      
BEGIN { DumpError }  
     outline.chr := msg_buf;   
DumpLine (outline);  
     WITH msgline DO      BEGIN     { write out the time stamp }      timestr := ConvertTime (time);      outline.chr := '';      strwrite (outline.chr, 1, i, timestr.chr);      DumpLine (outline);         { add the message header }      outline.chr := MESS_DIV;   
   outline.chr[1] := '-';  
    i := strlen (outline.chr);   
   outline.chr[i] := '-';  
    DumpLine (outline);     DumpBuffer ( databuffer, datalen );         { Now the z buffer }      outline.chr := ZBUF_DIV;   
   outline.chr [1] := '-'; 
 
   outline.chr [i] := '-'; 
    DumpLine (outline);         FOR i := 1 TO zbufferlen DO        cnvt_buffer[i] := zbuffer[i];      DumpBuffer ( cnvt_buffer, zbufferlen );         outline.chr := ALL_BLANKS;      DumpLine (outline);     END;   
END;  { DumpError }  
     $ SUBTITLE 'DumpLine', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                    DumpLine                                     }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " 	PROCEDURE DumpLine 	    (VAR  outline  : OutlineType);       VAR   
   error    : Int16; 
 
   i        : Int16; 
 
   length   : Int16; 
     	BEGIN { dumpline } 	 length := strlen (outline.chr);   FOR i := (length + 1) TO FMP_LENGTH DO     outline.chr := outline.chr + ' ';  !length := FmpWrite (dcb, error, outline.view.as.int, FMP_LENGTH);  ! CheckFMPWriteError (error);   	END;  { dumpline } 	         $ SUBTITLE 'DumpMessage', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   DumpMessage                                   }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE DumpMessage      (VAR format_info : FormatInfoType;   
    VAR msg : MsgBuffer);  
 {}  { Discussion  {   Writes the heading information for each message, then   "{   initializes a two line template with border 'n's or border '*'s  "  {   and blanks.  Eight by eight, translate each word of the raw    !{   trace message into both octal characters and ascii characters  ! {   for a dump output.  {}  { Parameters  %{  format_info    INPUT    Gives level, direction, and protocol/service id % %{  msg            INPUT    The record containing timestamp, lengths, data, % {                              and z-buffer   {}  { Called by   {  ProcessSLM   	{  ProcessGateway  	 {  ProcessLAN802  {}  { Calls   {  CheckFmpError    FMTRC procedure   {  ConvertTime      FMTRC procedure   {  CNumD            RTE library routine   {  CNumO            RTE library routine   {  CNumA            FMTRC procedure   {  FmpWrite         RTE file system function  {  StrAppend        Pascal Standard string procedure  {  StrInsert        Pascal Standard string procedure  {  StrLen           Pascal Standard string function   {  StrWrite         Pascal Standard string procedure  {}  {   {              Algorithm/Pseudocode   {   #{ Case on index to issue the formatted heading lines for each message  # {    .Fill values in where they are appropriate   { Indent the line if message is outbound  
{ Write output line to fmp 
 
{ Set word counter to zero 
 ${ Call internal procedure to execute the following once for message and  $ 
{   once for the z_buffer  
 !{   .Case twice, once for octal and once for ascii representation  ! {      .While word counter < message/z_buffer length do   {         .Initialize the output line   {         .Set position to 1  	{         .Repeat  	 {            .Increment word counter  ${            .Translate message[word counter] into output line[position] $ {            .Increment position  !{          Until (position > 8) or (word counter = message length) ! {         .Indent the output line if message is outbound  {         .Write output line to file  	{       End while  	 { Write bottom border line, indented if necessary   	{ Write blank line 	 {}      $PAGE$      CONST      NINEBLANKS = '         ';     LANHPEXPSAP  = 252;     LANHDRLEN    = 17;      LANEXPHDRLEN = 24;      UP_BYTE = -256;       { Upper byte all ones for masking }          TYPE     CnvtBufType = RECORD CASE BOOLEAN OF                      TRUE : (data : DBType);                     FALSE: (zbuf : ZBType);                   END;      TwoBytesType = RECORD CASE Int16 OF                      1 : (int : Int16);                      2 : (bytes : PACKED RECORD                              one  : PosInt8;                               two  : PosInt8;                                    END);                     END;       VAR   
   outline : OutlineType;  
    index : Int16;    { CASE loop control }     i : Int16;        { FOR loop control }      j : Int16;      error  : Int16;   { for FMP write }     length : Int16;   { for FMP write }     time_buffer : CharTimeType;  
   word_cnt : Int16; 
 
   word_pos : Int16; 
    cnvt_buffer : CnvtBufType;          head_len  : Int16;      temp_buffer : DBType;     two_bytes  : TwoBytesType;           
PROCEDURE WriteOut;  
    FORWARD;           $ SUBTITLE 'CheckMsglost', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{      *LOCAL*        CheckMsglost           *LOCAL*              }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE CheckMsglost     (VAR msgline : MsgBuffer;      VAR format_info : FormatInfoType);      VAR      lost : Int16;  
   next_pos : Int16; 
     BEGIN       IF format_info.prev_msglost < msgline.msglost THEN     BEGIN     lost := msgline.msglost - format_info.prev_msglost;     format_info.prev_msglost := msgline.msglost;      END  ELSE IF msgline.msglost < format_info.prev_msglost THEN   "   BEGIN  { rollover is MaxInt16 to zero to one in two increments }  " "   lost := msgline.msglost + 1 + (32767 - format_info.prev_msglost); "    format_info.prev_msglost := msgline.msglost;      END  ELSE lost := 0;   IF lost > 0 THEN     BEGIN  
   CNumD (lost, six_str);  
    outline.chr := ALL_BLANKS;      StrWrite (outline.chr, 1, next_pos, six_str, D_COUNT);   !   length := FmpWrite (dcb,error,outline.view.as.int, FMP_LENGTH); !    CheckFmpWriteError (error);     outline.chr := ALL_BLANKS;   !   length := FmpWrite (dcb,error,outline.view.as.int, FMP_LENGTH); !    CheckFmpWriteError (error);     END;       END;  { CheckMsglost }          $ SUBTITLE 'InsertNumber', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{      *LOCAL*        InsertNumber           *LOCAL*              }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE InsertNumber     (num : Int16;      pos : Int16;      VAR outline : OutlineType);       VAR      i, j : Int16;      BEGIN       
CNumD (ABS(num), six_str); 
     IF num < 0 THEN      BEGIN { we need to insert a '-' }     i := 1;      $ PARTIAL_EVAL ON $  { to prevent subscript explosions }     WHILE (i<=6) AND (six_str[i] = ' ')  
      DO i := i + 1; 
     
   IF (i>6) OR (i=1) THEN  
        BEGIN { this is an internal error in RTE.  Do nothing?? }           END   { this is an internal error in RTE.  Do nothing?? }       ELSE         BEGIN { insert the '-' }  
      six_str[i-1] := '-'; 
       END;  { insert the '-' }     END;  { we need to insert a '-' }      j := 1;   	FOR i := 1 TO 6 DO 	    outline.view.as.chr [pos + i] := six_str[i];       END;  { InsertNumber }          $ SUBTITLE 'Realign', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{      *LOCAL*           Realign             *LOCAL*              }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     	PROCEDURE Realign  	    (    buf_ptr : Int16;      VAR len : Int16);       VAR      i, j : Int16;     temp_buf1 : TwoBytesType;     temp_buf2 : TwoBytesType;      BEGIN       WITH msg DO      BEGIN     j := 1;         FOR i := buf_ptr TO (len - 1) DO   &      BEGIN                               { Join into one word the second }  & &      temp_buf1.int := databuffer[i];     {  byte of the first word and   }  & &      temp_buf2.int := databuffer[i + 1]; {  the first byte of the second }  & &      temp_buf1.bytes.one := temp_buf1.bytes.two;  { word.                }  &       temp_buf1.bytes.two := temp_buf2.bytes.one;         databuffer[j] := temp_buf1.int;   	      j := j + 1;  	 
      END;  { for }  
     %   temp_buf1.int := databuffer[len];      { Pad the the last word with a } % %   temp_buf2.int := 0;                    {  zero in the second byte.    } %    temp_buf1.bytes.one := temp_buf1.bytes.two;     temp_buf1.bytes.two := temp_buf2.bytes.one;     databuffer[j] := temp_buf1.int;         len := j;      	   END;  { with }  	     	END;  { Realign }  	         $ SUBTITLE 'WriteOut', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{      *LOCAL*         Writeout              *LOCAL*              }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE WriteOut;  
     	BEGIN { WriteOut } 	        IF format_info.level = SCKET THEN        BEGIN         outline.chr[1] := '*';        outline.chr[70] := '*';         END      ELSE IF format_info.level = NON_RR THEN           BEGIN           outline.chr[1] := '+';            outline.chr[70] := '+';           END;          i := StrLen (outline.chr);   $   IF format_info.direction = OUTBD THEN    { initialize remainder of }  $ $      BEGIN                                 {   of 79 characters      }  $       StrInsert (NINEBLANKS, outline.chr, 1);         END      ELSE BEGIN         StrAppend (outline.chr, NINEBLANKS);        END;      !   length := FmpWrite (dcb,error,outline.view.as.int, FMP_LENGTH); !    CheckFmpWriteError (error);      	END;  { WriteOut } 	     $ SUBTITLE 'FormatDump', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{      *LOCAL*        FormatDump             *LOCAL*              }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE FormatDump 
 
   (buffer : DBType; 
 	    len : Int16);  	     VAR      prev_word_cnt  :  Int16;       
BEGIN { FormatDump } 
 
WITH format_info DO  
    BEGIN  	   word_cnt := 0;  	     
   WHILE word_cnt < len DO 
       BEGIN             outline.chr := SIDE_BORDER;         prev_word_cnt := word_cnt;            FormatNumLine (word_cnt, len, buffer, outline);         WriteOut;             { Now format the same line in ascii }         outline.chr := SIDE_BORDER;             FormatAscLine (prev_word_cnt, len, buffer, outline);        WriteOut;             END;  { While }       	   END;   { With } 	     END;   { FormatDump }       $ SUBTITLE 'DumpMessage', PAGE $      
BEGIN  {DumpMessage} 
     CheckMsglost (msg, format_info);      
WITH format_info DO  
        WITH msg DO     BEGIN     index := 1;         REPEAT      CASE index OF         1: outline.chr := FULL_BORDER [level];              2: BEGIN             outline.chr := PROGM_ID;      {Product ID template}             time_buffer := ConvertTime (msg.time);            FOR i := 1 TO 7 DO              { add time }                outline.view.as.int [3 + i] := time_buffer.int[i];    
          END;  { case 2 } 
            3: BEGIN             outline.chr := SIDE_BORDER;             StrWrite (outline.chr, 8, i, vma_info.node_name);   
          END;  { case 3 } 
            4: CASE level OF               SCKET:  outline.chr := SOC_LEV;   
            NON_RR,  
             NTWORK: outline.chr := NET_LEV;               Otherwise;            END;             5: BEGIN                CASE direction OF                 INBD:  BEGIN   $                      IF (protoid = RROUTER) OR (protoid = NON_RTR) THEN $                          outline.chr := REPLYn  
                      ELSE 
                          outline.chr := INBOUND;  
                      END; 
                OUTBD: BEGIN   $                      IF (protoid = RROUTER) OR (protoid = NON_RTR) THEN $                          outline.chr := REQUSTn   
                      ELSE 
                          outline.chr := OUTBOUN;  
                      END; 
                Otherwise outline.chr := SIDE_BORDER;               END;  {case direction}             END;             { Do request/reply here too }             6: BEGIN             CASE level OF   
            SCKET:  BEGIN  
 &                    outline.chr := LEN_SER;      { Get service/monitor id }  & &                    StrWrite (outline.chr, 63, i, SERVMON_CHARS[servmonid]); &                     END;  
            NON_RR,  
 
            NTWORK: BEGIN  
 $                    outline.chr := LEN_PRO;             { Get protocol } $ $                    StrWrite (outline.chr, 60, i, LINK_CHARS[protoid]);  $                     END;              Otherwise;  
            END;  { Case } 
                 InsertNumber (datalen, 23, outline);            END;             7: CASE level OF   
            SCKET:  BEGIN  
                     outline.chr := SSOCKET;                       InsertNumber (sock_no, 59, outline);                      END;  
            NON_RR,  
             NTWORK: CASE protoid OF                         GATEWAY,                        LAN802  : BEGIN                                   outline.chr := SEQ_SOC;   "                                InsertNumber (seq_no, 23, outline);  " &                                IF sock_no <> 0 THEN  { SSN was not found }  & $                                   InsertNumber (sock_no, 59, outline);  $                                 WriteOut;                                   outline.chr := NOD_NOD;   #                                StrWrite (outline.chr, 16, i, addr1);  # #                                StrWrite (outline.chr, 48, i, addr2);  #                                 END;                        RROUTER,                        NON_RTR : BEGIN   "                                         { Get service/monitor id }  "                                 outline.chr := SERV_ID;                                   StrWrite (outline.chr, 63, i,   "                                          SERVMON_CHARS[servmonid]); "                                 WriteOut;                                   outline.chr := SOU_DES;   #                                InsertNumber (sou_node, 23, outline);  # #                                InsertNumber (des_node, 59, outline);  #                                 END;                        Otherwise;                      END;              Otherwise;            END;  { Case }            Otherwise;  
      END;  { case index } 
        WriteOut;     index := index + 1;      
   UNTIL index > 7;  
     $PAGE$  %{  The formatted header is written, now dump the outermost protocol header % {    if this is a network or non-router level message.  {}     IF (level = NTWORK) OR (level = NON_RR) THEN   	   CASE protoid OF 	         LAN802 :        BEGIN         outline.chr := LHDR_DIV;        WriteOut;                                    { isolate the lan header }         two_bytes.int := databuffer[8];         IF two_bytes.bytes.one = LANHPEXPSAP THEN   %         BEGIN                           { is this an expansion header? }  %          head_len := LANEXPHDRLEN DIV 2;           FormatDump (databuffer, head_len);            END  %      ELSE BEGIN                         { odd number of bytes in header } %          head_len := (LANHDRLEN + 1) DIV 2;            FOR index := 1 TO head_len DO              temp_buffer[index] := databuffer[index];      &                     { mask off the lower byte of the last word with zero }  &          two_bytes.int := temp_buffer[head_len];           two_bytes.bytes.two := 0;           temp_buffer[head_len] := two_bytes.int;               FormatDump (temp_buffer, head_len);           END;       %            { move the remaining databuffer contents to the beginning of } % %            {   the databuffer --  byte by byte to realign word boundary;} % %            {   word by word if the next header is already word-aligned  } %       IF head_len =  (LANEXPHDRLEN DIV 2) THEN           BEGIN           j := 0;           FOR i := (head_len + 1) TO datalen DO  	            BEGIN  	             j := j + 1;               databuffer [j] := databuffer [i];   
            END;  { for }  
          datalen := j;           END   { if already word aligned }        ELSE           Realign (head_len, datalen);             END; { LAN802 }       $PAGE$      GATEWAY :         BEGIN         outline.chr := GHDR_DIV;        WriteOut;                                    { isolate the ip header }  '                    { IHL value (the second 4 bits of the IP header) is the }  ' '      two_bytes.int := databuffer[1];    { IP header length in 32-bit words }  '       head_len := (two_bytes.bytes.one MOD 16) * 2;         FormatDump (databuffer, head_len);      %            { move the remaining databuffer contents to the beginning of } % %            {   the databuffer for shipping to the formatdump routine    } %       j := 0;         FOR i := (head_len + 1) TO datalen DO            BEGIN  
         j := j + 1; 
          databuffer [j] := databuffer [i];           END;  { for }  
      datalen := j;  
           END; { GATEWAY }          RROUTER,      NON_RTR :         BEGIN         outline.chr := RHDR_DIV;        WriteOut;   #                       { isolate the router header from the z-buffer } #       cnvt_buffer.zbuf := zbuffer;        IF servmonid = 7 THEN            BEGIN { we have a stream 13 message }           head_len := zbufferlen - 4            END   { we have a stream 13 message }        ELSE IF (zbufferlen = MA_CHANNEL_DOWN_LEN) THEN   !         BEGIN { this is an internal message; no local appendage } !          head_len := zbufferlen;  !         END   { this is an internal message; no local appendage } !       ELSE           BEGIN { we have RTR over a RTR link }           head_len := zbufferlen - 2            END;  { we have RTR over a RTR link }            FormatDump (cnvt_buffer.data, head_len);      $            { move the remaining zbuffer contents to the beginning of }  $ $            {   the zbuffer for shipping to the formatdump routine    }  $       j := 0;         FOR i := (head_len + 1) TO zbufferlen DO           BEGIN  
         j := j + 1; 
          zbuffer [j] := zbuffer [i];           END;  { for }  %      zbufferlen := j;      { Now zbuffer holds only the control buffer }  %           END; { ROUTER }      Otherwise;       	   END;  { case }  	     $PAGE$  %                            { Dump the message (or rest of the message) }  %    IF datalen <> 0 THEN         BEGIN         outline.chr := MESS_DIV;        WriteOut;         FormatDump (databuffer, datalen);         END;      {  The message is written; now do the control buffer  {    (for lowlevel messages only).  {}     IF ((level = NTWORK) OR (level = NON_RR)) AND  !      ( zbufferlen > 0 ) THEN     { there is something else here } !       BEGIN  { if network level }         outline.chr := ZBUF_DIV;        Writeout;             cnvt_buffer.zbuf := zbuffer;        FormatDump (cnvt_buffer.data, zbufferlen);        END;   { if network level }          outline.chr := FULL_BORDER [level];     Writeout;         outline.chr := ALL_BLANKS;   !   length := FmpWrite (dcb,error,outline.view.as.int, FMP_LENGTH); !    CheckFmpWriteError (error);         END;   { WITH msg }      
END;   {DumpMessage} 
         $ SUBTITLE 'FilterMessages', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   FilterMessages                                }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE FilterMessages     (VAR options : OptionsType;      VAR VMA_info : VmaInfoType;       VAR SSNs : SSNsPtr);  {}  { Discussion  #{   The first level of filtering is performed here where each message  # "{   is checked against the time window Option.  If a message fits in " "{   that window, then check the Z-buffer length and call the correct " {   procedure to continue with the second level of filtering.   {}  { Parameters  "{   options       INPUT   The Option settings, including trace level " !{   VMA_info      INPUT   Pointers, counters, timevalues from the  ! {                           VMA file  {   SSNs          OUTPUT  Pointer to a linked list of SSNs  {}  { Called by   {  Main of FMTRC  {}  { Calls   {  IfBrk            RTE function  {  ProcessSLM       FMTRC procedure   {  ProcessNLM       FMTRC procedure   {  ProcessRouter    FMTRC procedure   {  Strread          Pascal Standard string procedure  {  UIWriteExcept    Fileio procedure  {}  $ PAGE $  {   {              Algorithm/Pseudocode   {   	{ With VMA info do 	 {   {Calculate the number of records written to VMA file}   "{   .Set the entry count to the lesser of the total possible entries " {     stored and the number of entries written  #{   .Issue a message that says that so-many messages were overwritten  # 
{   .With options do 
 {      .Loop on number of records written to VMA file   "{         .Get current record's timestamp, Z-buffer and msg lengths  " %{         .If timestamp is in the window then                   {filter 1} % {            .Case Z-buf-len of   {               .SSN : begin end  {already processed these}   %{               .SLM : if socket-level tracing call ProcessSLM  {filter 2} % %{               .NLM : if network-level tracing call ProcessNLM {    "   } % "{               .RTR : if network-level tracing and protocol option  " &{                      matches Router then call ProcessRouter  {filters 2,3} & {                Otherwise error  {             End case  	{          End if  	 #{         .Increment record pointer (and block pointer, if necessary)  # {       End loop  {    End with options   
{ End with VMA info  
 {}      CONST      SCK_LEN          = 1;     LINKUP_LEN       = 2;     NWK_LEN          = 4;      VAR      index : Int16;           { counter of records processed }     current_block : BlkPtr;  { block being accessed currently }     entry : Int16;           { position of record in block }       msgline : MsgBuffer;     { entire record, timestamp and all }       $ SUBTITLE 'FilterRouter', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{   *LOCAL*        FilterRouter                     *LOCAL*       }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " PROCEDURE FilterRouter     (VAR options   : OptionsType;  "    VAR msgline   : MsgBuffer;     { the line from the trace file }  "     VAR format_info  : FormatInfoType);   {}  { Discussion:   #{  The DS/1000 and DS/1000-IV cases are snakey enough to warrant being # #{  treated by themselves.  Furthermore, I'll bet this procedure grows  # #{  with time, as we discover yet another special case which should be  # {  formatted in a slightly different way.   {}      BEGIN { FilterRouter }  WITH options DO   	   BEGIN { with }  	    IF msgline.zbufferlen >= MA_CHANNEL_DOWN_LEN THEN        BEGIN { we have a router header }       !      { should we format this message or are we filtering it out } !       IF (trace_level [NTWORK]) AND   !         ((protocol[RROUTER]) OR (nodes.address_type = RTR)) THEN  !          BEGIN           ProcessRouter (options, msgline, format_info);            END; {if matches options}            END  {if Router header}      ELSE         BEGIN         msg_buf := MSGS [UNKNOWN_ZBUF_LENGTH];        UIWriteExcept (msg_buf);        DumpError (msg_buf, format_info, msgline);        END;  {unknown Z-buffer length}   	   END;  { with }  	 END;  { FilterRouter }          $ SUBTITLE 'WithinTimeWindow', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{   *LOCAL*        WithinTimeWindow                 *LOCAL*       }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
FUNCTION WithinTimeWindow  
 
   ( VAR msg_time : Int32) 
    : BOOLEAN;   {}  { Discussion  "{  Discover whether the time of this message is within the window of " "{  time set by the user's options.  This involves checking for times " "{  that bracket around midnight.  A user may set a time window that  "  {  starts before midnight and ends after midnight, and since the   !{  timestamp of each message is time only (no date), a start time  ! {  may be greater in cardinal value than a stop time.   {}  { Parameters  !{  msg_time    INPUT   A double-word integer that was set from the ! {                        system time, $TIME and $TIME + 1.  {}  { Called by   	{  FilterMessages  	 {}  { Calls   {  None   {}  {   {                Algorithm/Pseudocode   {   { Set function value to FALSE   { If start time is less than stop time  {   .If msg_time is between start time and stop time  {      .Set function value to TRUE  ${   .Else if msg_time is between zero and stop time or between max time  $ 
{     and start time 
 {      .Set function value to TRUE  {}  $PAGE$      
BEGIN  {WithinTimeWindow}  
     
WithinTimeWindow := FALSE; 
     WITH options DO      BEGIN         IF start_time < stop_time THEN         BEGIN       !      IF (msg_time >= start_time) AND (msg_time <= stop_time) THEN !          BEGIN           WithinTimeWindow := TRUE;           END;             END     {check times that fall within one day}     ELSE         BEGIN   {check times that span two days}             IF ((D_START_TIME < msg_time) AND (msg_time < stop_time))    "          OR ((start_time < msg_time) AND (msg_time < D_STOP_TIME))  " 
         THEN BEGIN  
          WithinTimeWindow := TRUE;           END;             END;    {check times that span two days}         END;   {With options}      
END;   {WithinTimeWindow}  
     $ SUBTITLE 'FilterMessages', PAGE $       BEGIN  {FilterMessages}   WITH VMA_info DO     BEGIN      
   entry := start_record;  
    current_block := head^.first_block;         WITH format_info DO        BEGIN         prev_msglost := current_block^.message[entry].msglost;        END;   { with }       	   WITH options DO 	 
      BEGIN    {filtering} 
 	      index := 1;  	           WHILE (NOT (IfBrk = -1)) AND (index <= record_count) DO            BEGIN               msgline := current_block^.message[entry];           IF WithinTimeWindow (msgline.time) THEN  	            BEGIN  	             CASE msgline.zbufferlen OF  "                      {Already processed Socket/sequence no. hints}  "                NO_ZBUF :  BEGIN                             END;                 SCK_LEN :  BEGIN                             IF (trace_level [SCKET]) THEN                                BEGIN  $                             ProcessSLM (options, msgline, format_info); $                              END; {if}                            END;  {case 1}                 LINKUP_LEN :                             BEGIN                             IF msgline.datalen = 0 THEN                                BEGIN { its a link up message }                               IF trace_level [NTWORK] THEN                                   ProcessLU (msgline);                               END   { its a link up message }                            ELSE                               BEGIN { unknown message }                               msg_buf := MSGS [UNKNOWN_MSG];                                UIWriteExcept (msg_buf);   $                             DumpError (msg_buf, format_info, msgline);  $                              END;  { unknown message }                            END;  { case 2 }                 NWK_LEN :  BEGIN                             IF (trace_level [NTWORK]) THEN                                BEGIN { are we formatting these? }                                 IF msgline.datalen = 0 THEN  #                                BEGIN { link up message for gateway }  #                                 ProcessLU (msgline);  #                                END   { link up message for gateway }  #                              ELSE                                   BEGIN   %                                ProcessNLM (options, msgline, format_info, %                                             SSNs);                                  END;                               END; { are we formatting these? }                            END;   {case 4}                  Otherwise  
                     BEGIN 
 !                     FilterRouter (options, msgline, format_info); !                      END;  {Otherwise}                 END;  {case}               END;  {if time window option}   %            IF entry = MSG_PER_BLOCK THEN     {move pointer to next block} % 
               BEGIN 
 
               entry := 1; 
                current_block := current_block^.next_block;  	               END 	             ELSE BEGIN                 entry := entry + 1;  
               END;  
          index := index + 1;           END;  { while not break and index <= records saved }         END;  { with options }      
   END;  { with VMA_info } 
     END;   {FilterMessages}           $ SUBTITLE 'FormatAscLine', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                     FormatAscLine                               }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " PROCEDURE FormatAscLine   
   (VAR  wordsfmt : Int16; 
 
         buflen   : Int16; 
     VAR  buffer   : DBType;       VAR  outline  : OutlineType);       VAR      i  : Int16;  
   word_pos : Int16; 
         BEGIN { FormatAscLine }       word_pos := 4;          { Last blank before the dump starts }       REPEAT                          { Counts message words processed }  
wordsfmt := wordsfmt + 1;  
 CNumA (buffer[wordsfmt], six_str);                               { Translate the integer to ascii octal }   	FOR i := 1 TO 6 DO 	    outline.view.as.chr[word_pos + i] := six_str[i];       
word_pos := word_pos + 8;  
     UNTIL (word_pos > 62) OR (wordsfmt = buflen);   END;  { FormatAscLine }       $ SUBTITLE 'FormatNumLine', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                     FormatNumLine                               }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " PROCEDURE FormatNumLine   
   (VAR  wordsfmt : Int16; 
 
         buflen   : Int16; 
     VAR  buffer   : DBType;       VAR  outline  : OutlineType);       VAR      i  : Int16;  
   word_pos : Int16; 
     BEGIN { FormatNumLine }   word_pos := 4;          { Last blank before the dump starts }       REPEAT                          { Counts message words processed }  
wordsfmt := wordsfmt + 1;  
 CNumO (buffer[wordsfmt], six_str);                               { Translate the integer to ascii octal }   	FOR i := 1 TO 6 DO 	          { Make sure six digits are printed }      IF six_str[i] = ' ' THEN         outline.view.as.chr[word_pos + i] := '0'     ELSE         outline.view.as.chr[word_pos + i] := six_str[i];      
word_pos := word_pos + 8;  
     UNTIL (word_pos > 62) OR (wordsfmt = buflen);   END;  { FormatNumLine }       $ SUBTITLE 'GetSocket', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                     GetSocket                                   }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE GetSocket  
    (sequence_no : Int16;      VAR SSNs : SSNsPtr;       VAR the_socket : Int16);      {}  { Discussion  !{   For this inbound Network level message, search the linked list !  {   of SSNs to find the Socket where the message was delivered.     {   If a matching sequence number is not found, the Socket will    	{   remain a zero. 	 {}  { Parameters  #{   sequence_no  INPUT   Sequence number found in Z-buffer of message  # {   SSNs         INPUT   List of Socket/sequence numbers  #{   the_socket   OUTPUT  Socket is found by matching sequence numbers  # "{                          in the SSN hints in a linked list created "  {                          from the SSN records in the raw trace   {}  { Called by   	{  ProcessGateway  	 {  ProcessLAN802  {}  { Calls   {  none   {}  {              Algorithm/Pseudocode   {   { Set the socket number to zero   !{ Use a pointer that indicates the element that was last accessed  ! "{   .If the sequence number is greater than the parameter value then " {      .Use the listhead pointer instead   { Search the linked list by comparing sequence numbers with the    
{   parameter value  
 { If sequence number is found then  {   .Get the socket number from that linked list element  {}      VAR      element : SSNsPtr;       	BEGIN  {GetSocket} 	     the_socket := 0;  
element := SSNs^.next_ssn; 
     IF element <> nil THEN     BEGIN     REPEAT             IF element^.seq_no = sequence_no THEN            BEGIN           the_socket := element^.socket;            END        ELSE BEGIN           element := element^.next_ssn;           END;          UNTIL (the_socket <> 0) OR (element = nil);         END;  { If element }       	END;   {GetSocket} 	             $ SUBTITLE 'ProcessGateway', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ProcessGateway                                }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE ProcessGateway     (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR SSNs : SSNsPtr);  {}  { Discussion  {   Obtain the source and destination numbers from the IP   !{   header.  If these match the Options then obtain the Socket and ! !{   Sequence number.  If the message is inbound search the Socket/ ! "{   Sequence number list for the Socket value and check for a match  " {   with the Options.  If this matches then do the formatting.  {}  { Parameters  {   options        INPUT   The Option settings  !{   msgline        INPUT   The record viewed as a record structure ! {   SSNs           INPUT   The Socket/sequence number list  {}  { Called by   {  ProcessNLM   {}  { Calls   {  DumpMessage         FMTRC procedure  {  GetSocket           FMTRC procedure  {  IpArpaStr           NS/1000 library function   {  SetStrLen           Pascal Standard String procedure   {  StrWrite            Pascal Standard String procedure   {}  {   {              Algorithm/Pseudocode   {   	{ With Options do  	 #{    Read Source/destination addresses                     {filter 4}  # #{    If message fits the selection options for source/destination then # 
{      .Read Socket  
 {      .If Socket zero then GetSocket   #{      .If Socket matches the Option then                  {filter 6}  # {         .Format the addresses for human readability   {         .Read Sequence no.  {         .DumpMessage  {       Endif   {    Endif  { End with  {}      TYPE     TwoWordsType = RECORD CASE Int16 OF                     1 : (double : Int32);                     2 : (twosingle : ARRAY[1..2] OF Int16);                    END;      VAR   
   arpa_str : ArpaStrType; 
    ip_source_addr : Int32;   { destination address }     ip_dest_addr   : Int32;   { source address      }     temp_addr : TwoWordsType;  
   match : BOOLEAN;  
 
   next_pos : Int16; 
     BEGIN  {ProcessGateway}       WITH msgline DO      BEGIN     temp_addr.twosingle[1] := databuffer[7];      temp_addr.twosingle[2] := databuffer[8];      ip_source_addr := temp_addr.double;     temp_addr.twosingle[1] := databuffer[9];      temp_addr.twosingle[2] := databuffer[10];     ip_dest_addr := temp_addr.double;      	   match := FALSE; 	    IF options.nodes.address_type = GWY THEN   '      BEGIN                               {  If we are filtering by Gateway }  ' '      WITH options.nodes.address DO       {  IP addresses, then check for a }  ' '         BEGIN                            {  match of nodespair addresses.  }  '              IF (ip_addr[1] = ip_source_addr) OR              (ip_addr[1] = ip_dest_addr) THEN              IF (options.nodes.wildcard)                 OR (ip_addr[2] = ip_source_addr)                OR (ip_addr[2] = ip_dest_addr) THEN   
              BEGIN  
               match := TRUE;  	              END; 	              END;  { with }         END   { if not GATEWAY }         ELSE match := TRUE;         IF match THEN        BEGIN             format_info.seq_no := zbuffer[2];       "      IF zbuffer[1] = 0 THEN    { Position for socket in outbound }  "          BEGIN  "         GetSocket (format_info.seq_no, SSNs, format_info.sock_no);  "          format_info.direction := INBD;            END        ELSE BEGIN           format_info.sock_no := zbuffer[1] DIV 2;            format_info.direction := OUTBD;           END;             IF (options.socket[1] = -1) OR           (format_info.sock_no = options.socket[1]) OR            (format_info.sock_no = options.socket[2]) OR            (format_info.sock_no = options.socket[3]) THEN            BEGIN  !                        { Put the IP addresses into user format }  !          arpa_str := IpArpaStr (ip_source_addr);           SetStrLen (format_info.addr1, 0);           StrWrite (format_info.addr1, 1, next_pos, arpa_str);            arpa_str := IpArpaStr (ip_dest_addr);           SetStrLen (format_info.addr2, 0);           StrWrite (format_info.addr2, 1, next_pos, arpa_str);                format_info.protoid := GATEWAY;           format_info.level := NTWORK;                DumpMessage (format_info, msgline);               END;  { if socket matches }            END;  { if match }      
   END;  { With msgline }  
     END;   {ProcessGateway}           $ SUBTITLE 'ProcessLAN802', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ProcessLAN802                                 }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE ProcessLAN802      (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR SSNs : SSNsPtr);  {}  { Discussion  {   Obtain the source and destination numbers from the LAN802   !{   header.  If these match the Options then obtain the Socket and ! !{   Sequence number.  If the message is inbound search the Socket/ ! "{   Sequence number list for the Socket value and check for a match  " {   with the Options.  If this matches then do the formatting.  {}  { Parameters  {   options        INPUT   The Option settings  !{   msgline        INPUT   The record viewed as a record structure ! {   SSNs           INPUT   The Socket/sequence number list  {}  { Called by   {  ProcessNLM   {}  { Calls   {  DumpMessage         FMTRC procedure  {  GetSocket           FMTRC procedure  {  InternalToUser      NS/1000 library procedure  {  SetStrLen           Pascal Standard String procedure   {  StrWrite            Pascal Standard String procedure   {}  {   {              Algorithm/Pseudocode   {   	{ With Options do  	 #{    Read Source/destination addresses                     {filter 4}  # #{    If message fits the selection options for source/destination then # 
{      .Read Socket  
 {      .If Socket zero then GetSocket   #{      .If Socket matches the Option then                  {filter 6}  # {         .Format the addresses   {         .Read Sequence no.  {         .DumpMessage  {       Endif   {    Endif  { End with  {}  VAR      station_address : UserFormat;     lan_header_dsta : StatAddr;   { destination address }     lan_header_ssta : StatAddr;   { source address      }  
   match : BOOLEAN;  
 
   next_pos : Int16; 
    i : Int16;       $SUBTITLE 'CompareAddrs'; PAGE$       FUNCTION CompareAddrs      (addr_one : StatAddr;      addr_two : StatAddr)     : BOOLEAN;       VAR      i : Int16;   
   match : BOOLEAN;  
     BEGIN  {CompareAddrs}          i := 1;  	   match := TRUE;  	     %   REPEAT      { Compare all three integer values of a LAN address array } %           IF addr_one[i] = addr_two[i]           THEN i := i + 1        ELSE  match := FALSE;          UNTIL (i > 3) OR (NOT match);      
   CompareAddrs := match;  
     END;   {CompareAddrs}       $ SUBTITLE 'ProcessLAN802', PAGE $      BEGIN  {ProcessLAN802}         FOR i := 1 TO STATADDRLEN DO         BEGIN         lan_header_dsta[i] := msgline.databuffer[i];        lan_header_ssta[i] := msgline.databuffer[i + 3];        END;      	   match := FALSE; 	    IF (options.nodes.address_type = LAN) THEN   &      BEGIN                               { If we are filtering by LAN802 }  & &      WITH options.nodes.address DO       {  addresses, then check for a  }  & &         BEGIN                            {  match of nodespair addresses.}  &              IF CompareAddrs (station_addr[1], lan_header_dsta) OR               CompareAddrs (station_addr[1], lan_header_ssta) THEN               IF (options.nodes.wildcard)                  OR CompareAddrs (station_addr[2], lan_header_dsta)   #              OR CompareAddrs (station_addr[2], lan_header_ssta) THEN  # 
              BEGIN  
               match := TRUE;  	              END; 	              END;  { with }         END   { if not LAN802 }          ELSE match := TRUE;         IF match THEN        BEGIN             format_info.seq_no := msgline.zbuffer[2];       &      IF msgline.zbuffer[1] = 0 THEN    { Position for socket in outbound }  &          BEGIN  "         GetSocket (format_info.seq_no, SSNs, format_info.sock_no);  "          format_info.direction := INBD;            END        ELSE BEGIN           format_info.sock_no := msgline.zbuffer[1] DIV 2;            format_info.direction := OUTBD;           END;             IF (options.socket[1] = -1) OR           (format_info.sock_no = options.socket[1]) OR            (format_info.sock_no = options.socket[2]) OR            (format_info.sock_no = options.socket[3]) THEN            BEGIN  !                        { Put the LAN addresses into user format } !          InternalToUser (lan_header_dsta, station_address);            SetStrLen (format_info.addr1, 0);  "         StrWrite (format_info.addr1, 1, next_pos, station_address); "          InternalToUser (lan_header_ssta, station_address);            SetStrLen (format_info.addr2, 0);  "         StrWrite (format_info.addr2, 1, next_pos, station_address); "              format_info.protoid := LAN802;            format_info.level := NTWORK;                DumpMessage (format_info, msgline);               END;  { if socket matches }            END;  { if match }      END;   {ProcessLAN802}          $ SUBTITLE 'ProcessLU', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                    ProcessLU                                    }  " "{                                                                 }  " "{-----------------------------------------------------------------}  " 
PROCEDURE ProcessLU  
    (VAR msg       : MsgBuffer);   {}  { Discussion:   {  We have a link up message from the HDLC driver in the file.  #{  It is a local appendage ( 2 or 4 words) with no corresponding data. # {  The last word contains the LU which has come up.  Simply   {  write a message to the output file that a link up message  {  arrived. Include the time stamp and the LU.  {}  VAR   	   i, j  : Int16;  	 
   maxlen   : Int16; 
 
   outline  : outlinetype; 
    timestr  : CharTimeType;   { holds the ascii time string }       
BEGIN { ProcessLU }  
 timestr := ConvertTime  (msg.time);   	outline.chr := ''; 	 
i := msg.zbufferlen; 
 'Strwrite (outline.chr, 1, j, timestr.chr, '  Link up message from driver.  ',  '                'LU ',msg.zbuffer[i]:1);       maxlen := strmax (outline.chr);   FOR i := j TO maxlen DO      outline.chr := outline.chr + ' '; { pad with spaces }      
DumpLine (outline);  
     
outline.chr := ALL_BLANKS; 
 
DumpLine (outline);  
 
END;  { ProcessLU }  
     $ SUBTITLE 'ProcessNLM', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ProcessNLM                                    }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE ProcessNLM 
    (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR format_info : FormatInfoType;       VAR SSNs : SSNsPtr);  {}  { Discussion   {   Compare the Protocol Id with the Options.  Move to the next    {   level of filtering if this message matches the Options.   {}  { Parameters  {   options        INPUT   The Option settings  "{   msgline        INPUT   The message viewed as a record structure  " {   SSNs           INPUT   The Socket/sequence number list  {}  { Called by   	{  FilterMessages  	 {}  { Calls   {  ProcessGateway      FMTRC procedure  {  ProcessLAN802       FMTRC procedure  {  UIWriteExcept       Fileio procedure   {}  {   {              Algorithm/Pseudocode   {   	{ With options do  	 {   .Read protocol id       {LI-type}   "{   .If message fits the protocol option then do         {filter 3}  " {      .Case protocol id of   {         .Gateway :  ProcessGateway  {         .LAN     :  ProcessLAN802   
{         .Otherwise error 
 {       End case  { End with  {}  $PAGE$      VAR   
   LI_type : Int16;  
     
BEGIN  {ProcessNLM}  
 WITH options DO   !   BEGIN          { LI-type is next to the last word of Z-buffer } ! 	   WITH msgline DO 	       BEGIN         LI_type := msgline.zbuffer[zbufferlen - 1];             CASE LI_type OF   	         2 : BEGIN 	              IF (protocol[GATEWAY]) OR                  (nodes.address_type = GWY) THEN                   BEGIN                   ProcessGateway (options, msgline, SSNs);  
                END; 
              END;  {case 2}   	         7 : BEGIN 	              IF (protocol[LAN802]) OR                   (nodes.address_type = LAN) THEN                   BEGIN                   ProcessLAN802 (options, msgline, SSNs);   
                END; 
              END;  {case 7}   	         Otherwise 	 	            BEGIN  	             msg_buf := MSGS [LI_TYPE_NOT_RECOGNISED];               UIWriteExcept (msg_buf);              DumpError (msg_buf, format_info, msgline);              END;           END;  {case}         END;  { with msgline }  
   END;   { with options } 
 
END;   {ProcessNLM}  
         $ SUBTITLE 'ProcessRouter', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ProcessRouter                                 }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     PROCEDURE ProcessRouter      (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR format_info : FormatInfoType);  {}  { Discussion   {   Read the 91790 header for source and destination.  Read the    ${   service/monitor id code.  Check these for a match with the Options.  $ {   Do the formatting if there is a match.  {}  { Parameters  {   options        INPUT      The Option settings   #{   msgline        INPUT      The message viewed as a record structure # %{   format_info INPUT/OUTPUT  Gives level, direction, protocol/service id  % {}  { Called by   	{  FormatMessages  	 {}  { Calls   {  AddErrorCode        FMTRC procedure  {  AddMsgHeader        FMTRC procedure  {  DumpMessage         FMTRC procedure  {  UIWriteExcept       Fileio procedure   {}  {   {              Algorithm/Pseudocode   {   	{ With options do  	 {   .Read source/destination numbers  {   .Read service/monitor id  !{   .If message matches selection options then do    {filters 4,5} ! 
{      .DumpMessage  
 {    Endif  { End with  {}      TYPE     StreamWordType = RECORD CASE Int16 OF                       1 : (int : Int16);                        2 : (bits : PACKED RECORD                                     m3000    : BOOLEAN;                                     rply_flg : BOOLEAN;                                     misc     : PosInt8;                                     stream_no : PosInt6;                                    END);  
                     END;  
    NonRouterType = RECORD CASE Int16 OF                        1 : (int : Int16);   !                     2 : (bit : PACKED ARRAY [1..16] OF BOOLEAN);  ! 
                     END;  
 VAR      stream_word : StreamWordType;     is_non_router : NonRouterType;   
   match : BOOLEAN;  
 	   index : Int16;  	         $ SUBTITLE 'GetServMonIndex', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{      *LOCAL*      GetServMonIndex          *LOCAL*              }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE GetServMonIndex  
    (VAR servmonid : Int16);       BEGIN   { GetServMonIndex }       
WITH format_info DO  
     
   CASE servmonid OF 
 &       0 : BEGIN    { Check the first word after the fixed header (0 - 12) } &            IF msgline.zbuffer[14] = 0 THEN                servmonid := 6   { ReRouting }             ELSE                 servmonid := 5;  { Message Accounting }              END;  { case 0 }          1 : servmonid := 8;  { Directory List/Cartridge List }          3 : servmonid := 9;  { Schedule with Wait }  !       4 : servmonid := 10; { Program to Program Communications }  !        5 : servmonid := 11; { Remote Exec Requests }         6 : servmonid := 12; { Remote File Access }         7 : servmonid := 13; { Operator Request }        12 : servmonid := 14; { TRFAS Messages }        13 : servmonid := 7;  { Inpro Messages }         Otherwise  
          BEGIN  { error } 
           AddMsgHeader (INTERNAL_ERROR, msg_buf, TRUE);             AddErrorCode (msg_buf, BAD_STREAM_NO);            UIWriteExcept (msg_buf);  !          servmonid := MAX_SERVMON + 1;  { Index to blank field }  ! 
          END;   { error } 
        END;  { case }       END;    { GetServMonIndex }       $ SUBTITLE 'ProcessRouter', PAGE $      BEGIN  {ProcessRouter}  WITH msgline DO      BEGIN      
WITH format_info DO  
    BEGIN  
   sou_node := zbuffer[3]; 
 
   des_node := zbuffer[4]; 
     	   match := FALSE; 	    IF options.nodes.address_type = RTR THEN   '      BEGIN                               {  If we are filtering by Router  }  ' '      WITH options.nodes.address DO       {  nodal addresses, the check for }  ' '         BEGIN                            {  match of nodespair addresses.  }  '              IF (node_number[1] = sou_node) OR              (node_number[1] = des_node) THEN              IF (options.nodes.wildcard)                 OR (node_number[2] = sou_node)                OR (node_number[2] = des_node) THEN   
              BEGIN  
               match := TRUE;  	              END; 	              END;  { with }         END   { if not ROUTER }          ELSE match := TRUE;         IF match THEN        BEGIN             match := FALSE;         stream_word.int := zbuffer[1];        servmonid := stream_word.bits.stream_no;  $                         { Map the stream_no to a FMTRC servmon index }  $       GetServMonIndex (servmonid);        IF options.serv_mon[SERVS] THEN            match := TRUE        ELSE FOR index := MA_S TO OR_S DO           IF (index = servmonid) AND             (options.serv_mon[index]) THEN   
           match := TRUE;  
     
      IF match THEN  
          BEGIN               IF stream_word.bits.rply_flg THEN              direction := RPLY            ELSE direction := RQST;               protoid := RROUTER;      { Initialize }  
         level := NTWORK;  
              IF (servmonid <> 7) AND              (zbufferlen > MA_CHANNEL_DOWN_LEN) THEN   #            BEGIN    { look at non-stream 13, or non-inpro, messages } # '            is_non_router.int := zbuffer [zbufferlen - 1];   { first word,  }  ' '            IF is_non_router.bit[1] THEN        { bit 15 of local appendage }  ' 
               BEGIN 
 '               protoid := NON_RTR;              { or 'control buffer'       }  '                level := NON_RR;   
               END;  
             END;               DumpMessage (format_info, msgline);               END;   { if stream number matches }      
      END;   { if match }  
        END;   { with format_info }      
   END;   { with msgline } 
     END;   {ProcessRouter}      $ SUBTITLE 'ProcessSLM', PAGE $   "{-----------------------------------------------------------------}  " "{                                                                 }  " "{                   ProcessSLM                                    }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE ProcessSLM 
    (VAR options : OptionsType;      VAR msgline : MsgBuffer;      VAR format_info : FormatInfoType);  {}  { Discussion  "{   Compare the Socket and the Service/Monitor Id with the Options.  " "{   Format a header and call DumpMessage if this message matches the " {   Options.  {}  { Parameters  {   options        INPUT   The Option settings  !{   msgline        INPUT   The record viewed as a record structure ! {}  { Called by   	{  FilterMessages  	 {}  { Calls   {  AddErrorCode        FMTRC procedure  {  AddMsgHeader        FMTRC procedure  {  DumpMessage         FMTRC procedure  {}  {   {              Algorithm/Pseudocode   {   	{ With options do  	 {   .Read Socket number   {   .Read Service/Monitor id number   
{   .Read direction  
 !{   .If message fits the selection options then do  {filters 5,6}  ! 
{      .DumpMessage  
 {    Endif  { End with  {}  VAR   
   choices : Int16;  
    socket_no : Int16;      servmon_no : RECORD                    CASE BOOLEAN OF                       TRUE : (word : Int16);                       FALSE: (byte : PACKED ARRAY [1..2] OF Int8);                     END;      $ SUBTITLE 'GetServMonIndex', PAGE $  "{-----------------------------------------------------------------}  " "{                                                                 }  " "{      *LOCAL*      GetServMonIndex          *LOCAL*              }  " "{                                                                 }  " "{-----------------------------------------------------------------}  "     
PROCEDURE GetServMonIndex  
    ( VAR servmonid : Int16);      {}  %{  The following routine does not have foolproof logic:  NS/1000 services  % "{    use the upper byte of the second word of a socket level message " %{    as a reference to the particular service whose message this is.  (The % #{    first word is the message length and the lower byte of the second # "{    word is the message type.)  To this extent the header format is " #{    consistent among the NS/1000 provided services.  However, a user  # %{    message has no conventional format and will likely not have a header. % "{  The formatter has no way of knowing conclusively whether the byte " ${    being viewed is actually part of an NS/1000 service header or not.  $ "{    Therefore, some messages may be mistakenly selected as NS/1000  " "{    service messages when filtering is done; and the labelling of a " !{    mistakenly selected message may be incorrect in the formatted ! #{    output.  Mention of this problem needs to be made in the manual,  # "{    but it is seen as a rather low probability, low nuisance factor " %{    problem.  This is particularly so because the 'sins' are not ones of  % {    omission.  {}      BEGIN   { GetServMonIndex }       
WITH format_info DO  
     
   CASE servmonid OF 
        1 : servmonid := 2;  { Network File Transfer }          2 : servmonid := 1;  { Virtual Terminal }         3 : servmonid := 4;  { Socket Registry }         12 : servmonid := 3;  { Remote Program Management }          Otherwise            BEGIN  { must be data byte of user's message }  !          servmonid := MAX_SERVMON + 1;  { Index to blank field }  !           END;         END;  { case }       END;    { GetServMonIndex }       $ SUBTITLE 'ProcessSLM', PAGE $       
BEGIN  {ProcessSLM}  
     WITH options DO      BEGIN      	   WITH msgline DO 	 &      BEGIN       { Z-buffer has only one word; Socket is all bits except }  & &                  {   the least significant, which indicates direction    }  &       socket_no := zbuffer[1] DIV 2;            IF socket[1] <> -1 THEN            BEGIN  { check this socket with the option choices }                choices := 1;           WHILE (choices <= MAX_CHOICES) AND                  (socket[choices] <> socket_no) DO  	            BEGIN  	             choices := choices + 1;               END;               END;   { check this socket with the option choices }              IF (socket[1] = -1) OR (socket[choices] = socket_no) THEN             BEGIN { check service/monitor id }   $                  { service/monitor number is found in the upper byte }  $ $                          {   of the second word of the message       }  $          servmon_no.word := databuffer[2];               WITH format_info DO  	            BEGIN  	             servmonid := servmon_no.byte[1];  $                         { Map the servmon_no to a FMTRC servmon index } $             GetServMonIndex (servmonid);                   IF (serv_mon [SERVS]) OR (serv_mon [servmonid]) THEN                  BEGIN   { formatting }                      sock_no := socket_no;                 protoid := 0;    { Not applicable }                 direction := zbuffer[1] MOD 2;                  level := SCKET;                 DumpMessage (format_info, msgline);                     END;   { formatting }                  END;   { with format_info }                END;  { check service/monitor id }       
      END;  {with msgline} 
        END;  {with options}       
END;   {ProcessSLM}  
                { FMTER }  .  