 $PASCAL ',7 92081-1X518 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM pointer_calculators;      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18518                                        *)  ! !(* RELOC:   92081-16518                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <850416.1429>  !(*                                                             *)  ! !(***************************************************************)  !     $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)        $ Include '[BMCCT'  $    (* Workhorse constants and types *)    $ Include '[XWRTF'  $    (* Run table reading routines. *)    $ List ON $       !(***************************************************************)  ! !(*                                                             *)  ! !(* The following routines are non-external pointer calculation *)  ! !(* modules which are used by DBMON in acquiring pointers to    *)  ! !(* such data structures as an item table, datset table,        *)  ! !(* free record table and dataset path table for a particular   *)  ! !(* root file.                                                  *)  ! !(*                                                             *)  ! !(***************************************************************)  !     !(***************************************************************)  ! !(*                                                             *)  ! !(* Function MAKE_RT_HEADER_PTR : Boolean;                      *)  ! !(*                                                             *)  ! !(*    Purpose: To construct a pointer to the run table header  *)  ! !(* for a given database.  This routine will automatically      *)  ! !(* perform a call to ROOT_READ and thereby guarantee that the  *)  ! !(* runtable is in memory for the duration of the intrinsic.    *)  ! !(* (DBBEG and DBEND may be exceptions to this rule).           *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    (in)     (1) The database number.                        *)  ! !(*    (out)    (2) EMA pointer to runtable header.             *)  ! !(*    (in/out) (3) Workhorse data.                             *)  ! !(*    (out)    (4) IMAGE error if an error occurs.             *)  ! !(*                                                             *)  ! !(* Possible errors are:                                        *)  ! !(*    Corrupt data structures or Disc Failure.                 *)  ! !(*                                                             *)  ! !(***************************************************************)  !     	$ Heapparms OFF $  	     FUNCTION make_rt_header_ptr   $ Alias 'DBW.RunTablePtr' $          (VAR Database_number : Short_int;          VAR rt_header_ptr   : Rootfile_header_ptr_type;           VAR workhorse_data  : Workhorse_info_type;          VAR error           : Short_int) : Boolean;       
LABEL 99; (* error exit *) 
     VAR      any_ptr : all_pointers_type;           BEGIN  (* make_rt_header_ptr *)           make_rt_header_ptr := true;    (* Assume error will occur *)        
   WITH workhorse_data DO  
    IF (opn_tbl_ptr^[database_number].start_run_tbl = nil) THEN        IF root_read (Database_number,                      workhorse_data,   
                    error) 
          THEN GOTO 99;         WITH workhorse_data.opn_tbl_ptr^[database_number] DO BEGIN         any_ptr.run_table_area :=  start_run_tbl;   !      any_ptr.value := any_ptr.value + offset_to_runtable_buffer + !                                        start_tbl_wrd;         rt_header_ptr := any_ptr.rootfile_header;         END; (* with *)          make_rt_header_ptr := false;   (* No error *)      99:  (* error exit *)       END; (* function make_rt_header_ptr *)  $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(* Function MAKE_MASTER_POINTERS : Boolean;                    *)  ! !(*                                                             *)  ! !(*    Purpose: Given a database and dataset number, to         *)  ! !(* calculate and return the pointers specific to a master      *)  ! !(* dataset; namely the entry in the dataset control block      *)  ! !(* table, a pointer to its information table, and a pointer    *)  ! !(* to its entry in the free record table.                      *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    (1) The database number.                                 *)  ! !(*    (2) The master dataset number.                           *)  ! !(*    (3) Pointer to master  control block entry.              *)  ! !(*    (4) Pointer to the master  path table.                   *)  ! !(*    (5) Pointer to the master information table.             *)  ! !(*    (6) Pointer to the free record table entry.              *)  ! !(*    (7) Workhorse information.                               *)  ! !(*    (8) IMAGE error if an error occurs.                      *)  ! !(*                                                             *)  ! !(* Function return:                                            *)  ! !(*    'false' if no error occurs.                              *)  ! !(*    'true' if an error does occur.                           *)  ! !(*                                                             *)  ! !(* Possible errors:                                            *)  ! !(*    Disc error.                                              *)  ! !(*    EMA mapping error.                                       *)  ! !(*                                                             *)  ! !(***************************************************************)  !     	$ Heapparms OFF $  	     FUNCTION make_master_pointers   $ Alias 'DBW.MasterPtrs' $     (VAR database_num : short_int;           dataset_num  : short_int;   !    VAR set_control_block_ptr : Global_dataset_ctl_table_ptr_type; !     VAR master_path_table_ptr : Global_md_path_table_ptr_type;      VAR master_info_ptr       : Global_md_info_ptr_type;      VAR master_free_rec_ptr   : Global_frt_entry_ptr_type;      VAR workhorse_data        : Workhorse_info_type;      VAR error                 : Short_int) : Boolean;       
LABEL 99; (* error exit *) 
     VAR      any_ptr1 : All_pointers_type;     any_ptr2 : All_pointers_type;      BEGIN (* make_master_pointers *)      
   WITH workhorse_data DO  
       IF ((valid_pointers) AND            (database_num = owning_db) AND            (dataset_num = owning_set))                THEN BEGIN  (* Use last accessed pointers *)               make_master_pointers  := false;               set_control_block_ptr := set_ctl_blk_ptr;               master_path_table_ptr := mpath_table_ptr;               master_info_ptr       := minfo_table_ptr;               master_free_rec_ptr   := free_rec_table_ptr;  
            GOTO 99; 
             END; (* then *)       "   make_master_pointers := true;   (* assume an error will occur. *) "            WITH workhorse_data DO BEGIN         valid_pointers := false;        owning_db      := database_num;         owning_set     := dataset_num;        END; (* with *)          IF make_rt_header_ptr (database_num,                             any_ptr1.rootfile_header,                             workhorse_data,                             error)           THEN GOTO 99;         any_ptr2.value := any_ptr1.value +                        any_ptr1.rootfile_header^.set_off +                       ((dataset_num - one) * bm_set_len);         (* Make pointer to dataset control block *)         set_control_block_ptr := any_ptr2.global_dataset_ctl_table;     workhorse_data.set_ctl_blk_ptr := set_control_block_ptr;           "   any_ptr2.value := any_ptr1.value+set_control_block_ptr^.info_off; "        (* Make pointer to master dataset path table *)         master_path_table_ptr := any_ptr2.global_md_path_table;     workhorse_data.mpath_table_ptr := master_path_table_ptr;   "   workhorse_data.dpath_table_ptr := any_ptr2.global_dd_path_table;  "        any_ptr2.value := any_ptr2.value +                        set_control_block_ptr^.gdt.set_paths;         (* Make pointer to master key info *)         master_info_ptr := any_ptr2.global_md_info;     workhorse_data.minfo_table_ptr := master_info_ptr;          any_ptr2.value := any_ptr1.value +                        any_ptr1.rootfile_header^.free_tbl_off +                        ((dataset_num - one) * bm_free_rec_len);           (* Make pointer to free record table entry for master set *)           master_free_rec_ptr := any_ptr2.global_frt_entry;     workhorse_data.free_rec_table_ptr := master_free_rec_ptr;         workhorse_data.valid_pointers := true;          make_master_pointers := false;   (* No error! *)       99:  (* error exit *)       END; (* make_master_pointers *)       $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(* Function MAKE_DETAIL_POINTERS : Boolean;                    *)  ! !(*                                                             *)  ! !(*    Purpose: Given a database and dataset number, to         *)  ! !(* calculate and return the pointers specific to a detail      *)  ! !(* dataset; namely the entry in the dataset control block      *)  ! !(* table, a pointer to its information table, and a pointer    *)  ! !(* to its entry in the free record table.                      *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    (1) The database number.                                 *)  ! !(*    (2) The dataset number. (detail only)                    *)  ! !(*    (3) Pointer to detail  control block entry.              *)  ! !(*    (4) Pointer to the detail  path table.                   *)  ! !(*    (5) Pointer to the free record table entry.              *)  ! !(*    (6) Workhorse information.                               *)  ! !(*    (7) IMAGE error if an error occurs.                      *)  ! !(*                                                             *)  ! !(* Function return:                                            *)  ! !(*    'false' if no error occurs.                              *)  ! !(*    'true' if an error does occur.                           *)  ! !(*                                                             *)  ! !(* Possible errors:                                            *)  ! !(*    Disc error.                                              *)  ! !(*    EMA mapping error.                                       *)  ! !(*                                                             *)  ! !(***************************************************************)  !     	$ Heapparms OFF $  	     FUNCTION make_detail_pointers   $ Alias 'DBW.DetailPtrs' $     (VAR database_num : short_int;           dataset_num  : short_int;   !    VAR set_control_block_ptr : Global_dataset_ctl_table_ptr_type; !     VAR detail_path_table_ptr : Global_dd_path_table_ptr_type;      VAR detail_free_rec_ptr   : Global_frt_entry_ptr_type;      VAR workhorse_data        : Workhorse_info_type;      VAR error                 : Short_int) : Boolean;       LABEL 99;       VAR      rtable_header_ptr : Rootfile_header_ptr_type;     any_ptr1 : All_pointers_type;     any_ptr2 : All_pointers_type;          BEGIN (* make_detail_pointers *)      
   WITH workhorse_data DO  
    IF (valid_pointers) AND (database_num = owning_db) AND         (dataset_num = owning_set)            THEN BEGIN (* Use last accessed pointers *)            set_control_block_ptr := set_ctl_blk_ptr;           detail_path_table_ptr := dpath_table_ptr;           detail_free_rec_ptr   := free_rec_table_ptr;            make_detail_pointers  := false;  	         GOTO 99;  	          END;       "   make_detail_pointers := true;   (* assume an error will occur. *) "        IF make_rt_header_ptr (database_num,                             rtable_header_ptr,                            workhorse_data,                             error)  
      THEN GOTO 99;  
        WITH workhorse_data DO BEGIN         valid_pointers := false;        owning_db      := database_num;         owning_set     := dataset_num;        END;         any_ptr1.rootfile_header := rtable_header_ptr;       !   any_ptr2.value := any_ptr1.value + rtable_header_ptr^.set_off + !                      ((dataset_num - one) * bm_set_len);         (* Make pointer to detail set control block *)          set_control_block_ptr := any_ptr2.global_dataset_ctl_table;     workhorse_data.set_ctl_blk_ptr := set_control_block_ptr;       "   any_ptr2.value := any_ptr1.value+set_control_block_ptr^.info_off; "        (* Make pointer to detail set path table *)         detail_path_table_ptr := any_ptr2.global_dd_path_table;     workhorse_data.dpath_table_ptr := detail_path_table_ptr;   "   workhorse_data.mpath_table_ptr := any_ptr2.global_md_path_table;  "        (**)      (* Make a pointer to the 'master info table' just in case     (* this is a master data set.     (**)          any_ptr2.value := any_ptr2.value +                        set_control_block_ptr^.gdt.set_paths;     workhorse_data.minfo_table_ptr := any_ptr2.global_md_info;       #   any_ptr2.value := any_ptr1.value + rtable_header_ptr^.free_tbl_off  #                       + ((dataset_num - one) * BM_free_rec_len);           (* Make pointer to detail set free record table entry *)          detail_free_rec_ptr := any_ptr2.global_frt_entry;     workhorse_data.free_rec_table_ptr := detail_free_rec_ptr;         workhorse_data.valid_pointers := true;          make_detail_pointers := false;   (* No error! *)       99:  (* error exit *)       END; (* make_detail_pointers *)   $ Page $   (**************************************************************)    (*                                                            *)    (* Function ITEM_POINTER : Boolean;                           *)    (*                                                            *)    (*    Purpose: To create a pointer to the item table entry    *)    (* for a specified data item in a database.                   *)    (*                                                            *)    (* Parameters:                                                *)    (*    (1) Database number.                                    *)    (*    (2) Item number.                                        *)    (*    (3) Item table entry pointer.                           *)    (*    (4) Workhorse information.                              *)    (*    (5) IMAGE error if an error occurs.                     *)    (*                                                            *)    (* Function result:                                           *)    (*    'False' if no error occurs.                             *)    (*    'True' if an error does occur.                          *)    (*                                                            *)    (* Possible errors:                                           *)    (*    Disc failure.                                           *)    (*    Mapping error.                                          *)    (*                                                            *)    (**************************************************************)       	$ Heapparms OFF $  	     FUNCTION item_pointer  $ Alias 'DBW.MakeItemPtr' $     (VAR database_num   : Short_int;           item_num       : Short_int;       VAR item_ptr       : Global_item_table_entry_ptr_type;      VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;      
LABEL 99; (* error exit *) 
     VAR      rtable_header_ptr :  Rootfile_header_ptr_type;      any_ptr : All_pointers_type;           BEGIN (* item_pointer *)         item_pointer := true;   (* Assume an error will occur. *)         IF make_rt_header_ptr (database_num,                             rtable_header_ptr,                            workhorse_data,                             error)  
      THEN GOTO 99;  
        Any_ptr.rootfile_header := rtable_header_ptr;          Any_ptr.value := any_ptr.value + rtable_header_ptr^.it_off +                        ((item_num - one) * bm_item_len);          (* Make item table entry pointer *)         item_ptr := any_ptr.global_item_table_entry;          item_pointer := false;   (* No error!! *)          99:  (* error exit *)       END; (* function item_pointer *)      .  