$PASCAL ',7 92081-1X520 REV.2440' $          (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18520                                        *)   (* RELOC:   92081-16520                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (* Date last modified: <840912.1412>  (*                                                             *)   (***************************************************************)      
$ Include '[LBOPT'  $ 
     PROGRAM system_independent_IO;      !(***************************************************************)  ! !(*                 INCLUDE FILE DEFINITIONS                    *)  ! !(***************************************************************)  !     $ List OFF, Include '[IMAGE' , List ON $    $ List OFF, Include '[BMCCT' , List ON $        $ Page $  (************************************************************)  (*                                                          *)  (* This file contains system-independent I/O routines for   *)  (* the database accessing routines (known lovingly as the   *)  (* 'database workhorses').  These routines work with        *)  (* buffers in EMA or local addressing space.                *)  (* NOTE!!! HEAP 2 must be on!!! HEAPPARMS are unpredictably *)  (* set by this routine.                                     *)  (*                                                          *)  (************************************************************)      (************************************************************)  (*                   EXTERNAL DEFINITIONS                   *)  (************************************************************)      $ List OFF, Include '[XERWD' , List ON $        $ Page $  (************************************************************)  (*                                                          *)  (* Function DO_DISC_TRANSFER : Boolean;                     *)  (*                                                          *)  (* Purpose:                                                 *)  (*    To read/write blocks of data between memory and a     *)  (*    disc medium.  This routine will work only with        *)  (*    type 1 file I/O.  (Type 1 files are made of 128 word  *)  (*    blocks which do not require an intermediate buffer    *)  (*    when being transferred betweeb disc and memory).      *)  (*    The buffer may reside in EMA.                         *)  (*                                                          *)  (* Parameters:                                              *)  (*    (in)     (1) read/write code (1 or 2).                *)  (*    (in/out) (2) File descriptor.                         *)  (*    (in)     (3) Block number in file of the start block. *)  (*    (in)     (4) Number of blocks to be transferred.      *)  (*    (in)     (5) Buffer to place/receive data (may be in  *)  (*                   EMA).                                  *)  (*    (in/out) (6) Database workhorse information.          *)  (*    (out)    (7) IMAGE error status.                      *)  (*                                                          *)  (* Possible error: Disc Failure.                            *)  (*                                                          *)  (* Function result:                                         *)  (*    'True' if an error occurs, 'false' otherwise.         *)  (*                                                          *)  (* IMPORTANT!!!!                                            *)  (*    ALL disc files begin at Block ONE!!!!!                *)  (*    The first block of a file is Always block one.        *)  (*    No exceptions.                                        *)  (*                                                          *)  (************************************************************)      	$ Heapparms OFF $  	     FUNCTION Do_disc_transfer   $ Alias 'DBW.BlockIO' $            (    rd_wt_ind      : short_int;   $ Heapparms ON $            VAR File_dcb       : dcb_header_type;   	$ Heapparms OFF $  	               Start_block    : long_int;                block_length   : short_int;   $ Heapparms ON $            VAR buffer_addr    : short_int;   	$ Heapparms OFF $  	           VAR workhorse_data : workhorse_info_type;             VAR error          : short_int  ) : Boolean;      CONST   
   read_code = one;  
 	   write_code= 2;  	        
BEGIN  (* function *) 
     WITH workhorse_data DO BEGIN         (* Perform the disc transfer to/from memory. *)        temp_file_descriptor.dcb.dcb_header := file_dcb;             do_disc_transfer := read_write_disc                             (rd_wt_ind,                               temp_file_descriptor,                              buffer_addr,                               block_length,                              start_block,                               error);        file_dcb := temp_file_descriptor.dcb.dcb_header;      END; (* with workhorse data *)     
END; (* do_disc_transfer *) 
 .  