$PASCAL ',7 92081-1X819 REV.5000' $ $ Title 'DBUTL: Define warning log' $  $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18819                                        *)   (* RELOC:   92081-16819                                        *)   (*                                                             *)   (* PGMR:        <EDB> <MRL>                                    *)   (*              <TH> for NLS                                   *)   (*                                                             *)   (* Date last modified: <870113.1612>  (*                                                             *)   (* Altered: July 1986 for new O/S numbers. <MRL>               *)   (*                                                             *)   (***************************************************************)       (**) %(*:nl:$ATB, mut_wl, %ut000, relocatable, 92081-16078 REV.2540 <870113.1612> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)     
PROGRAM Define_warning_log; 
    $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBUTL', List ON $ $ List OFF, Include '[UTNLS', List ON $  $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #      $ List OFF, Include '[XDMSG', List ON $  (* Message externals *)   !$ List OFF, Include '[XDSEM', List ON $  (* Resource# externals *) ! !$ List OFF, Include '[XDCIO', List ON $  (* DBCON I/O externals *) ! !$ List OFF, Include '[XDTDY', List ON $  (* Timestamp externals *) !    $ List OFF, Include '[XUU_M', List ON $ $ List OFF, Include '[XUU_3', List ON $ $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XUU_4', List ON $ $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XUSHF', List ON $ "$ List OFF, Include '[XDGIC', List ON $  (* $IMCR, $IMCL externals *) "     $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #
PROCEDURE MUT_WL; EXTERNAL; 
    (*** Get the operating system number ***)     FUNCTION operating_system  $ Alias 'IMG.OPSY' $     : os_kinds;     EXTERNAL;      $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_wl_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL WL   *) # #(*           command.  The WL command is change or display the      *) # #(*           file to which IMAGE errors are directed.               *) # #(*                                                                  *) # #(* PROGRAMMER : <EDB> <MRL>                                         *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      execute_wl_command                          *) # #(********************************************************************) #    PROCEDURE execute_wl_command $ALIAS 'DBUTL.WL.CMD'$    ( VAR parameter_buffer: parm_buffer );     CONST     do_not_extend_file = false;     VAR     wlf_change: boolean;            (* wlf change flag *)    return_status : Short_int;    reply_len : Short_int;     start :  short_int;      BEGIN (* execute_wl_command *)         (* check optional log file parameter *)     WITH parameter_buffer.parameter[2] DO       CASE typ OF               non: (* not supplied *)              wlf_change := false;              int, asc: (* integer or ascii parameter *)              BEGIN                  (* check parameter *)      &               file_dest_long_srce (temp_file.newfl, chars_in_new_file_name, &                                    ascii, chars_in_long_str,                                      str_assign, zero);                     IF create_file (temp_file, return_status)                    THEN nonfatal_error (return_status);                      (* Remove protections on non-device RTE-6 file *)                   (* because DBMON runs detached.                *)                     IF operating_system = RTE6                    THEN IF NOT is_device_file (temp_file)                        THEN IF remove_file_protections (temp_file,   "                                                      return_status) "                         THEN nonfatal_error (return_status);                    IF close_file (temp_file, return_status)                    THEN (* do nothing *);                     wlf_change := true;             END; (* asc CASE *)               END; (* CASE *)        (* check if log file change *)      IF wlf_change                   (* change warning log file *)        THEN WITH dbcon_table.dbcon_status_block DO BEGIN          IF read_dbcon_table (dbcon_file,                               dbc_status_blk,                                lock_dbcon_file,                                block,                                return_status)              THEN nonfatal_error (return_status);              wlf_name := temp_file.newfl;               IF write_dbcon_table (dbcon_file,                                 dbc_status_blk,                                unlock_dbcon_file,                                block,                                return_status)              THEN nonfatal_error (return_status);                   (* send a message telling DBMON of the change *)            IF (flag.dbmon_active)               THEN BEGIN                 (* build message and check on DBMON's status *)  !               IF build_dbmon_mesg_hdr ( to_bm_change_status_code, !                                          return_status) THEN  &                  (* we cannot send dbmon a message - dbmon is not around *) &                   return_status := zero       
               ELSE BEGIN  
 "                  request_msg.dbmon.change_status.changed_status :=  "                          warning_log_changed;                         IF xchg_dbmon_msg (                          request_msg.dbmon,                          to_bm_change_status_mesg_len,                         request_msg.user,                         reply_len,                          to_user_utl_stat_change_mesg_len,                         return_status) THEN                         nonfatal_error (return_status);                      END;  (* else *)                    END; (* then send DBMON a message *)              END; (* THEN with: change wlog. *)        (**)     (* read the latest copy of the database control file *)    (**)        WITH dbcon_table.dbcon_status_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)          THEN nonfatal_error (return_status);           (* display warning log file definition *)  (*    temp_str := 'Warning Log='; *)       (*:nl:#*1 1000 'Warning Log='; *) %      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str, len);' *) %        length := nlread (MUT_WL, 1000, nlerr, temp_str, len);             blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)            long_dest_file_srce (temp_str, chars_in_long_str,                             wlf_name, chars_in_new_file_name,                            str_append, zero);           IF write_long_str (log_file, temp_str, return_status)          THEN nonfatal_error (return_status);  	   END; (* with *) 	    END; (* execute_wl_command *)  .  