 $PASCAL ',7 92081-1X818 REV.2540' $   $ Title 'DBUTL: Command File Transfer' $  $ Heap 0 $  	$ Recursive OFF $  	 $ Range OFF $       $ Subprogram $      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18818                                        *)  ! !(* RELOC:   92081-16818                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <EDB> <MRL>                                    *)  ! !(*                                                             *)  ! (* Date last modified: <851107.0924>  !(*                                                             *)  ! !(***************************************************************)  !         PROGRAM command_file_transfer;      $ List OFF, Include '[IMAGE', List ON $   $ List OFF, Include '[DBUTL', List ON $   $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #      $ List OFF, Include '[XDMSG', List ON $  (* Message externals *)   !$ List OFF, Include '[XDSEM', List ON $  (* Resource# externals *) ! !$ List OFF, Include '[XDCIO', List ON $  (* DBCON I/O externals *) ! !$ List OFF, Include '[XDTDY', List ON $  (* Timestamp externals *) !     $ List OFF, Include '[XUU_M', List ON $   $ List OFF, Include '[XUU_3', List ON $   $ List OFF, Include '[XUU_4', List ON $   $ List OFF, Include '[XDFMP', List ON $   $ List OFF, Include '[XUSHF', List ON $       $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_tr_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL TR   *) # #(*           command.  The TR command is used to change the file    *) # #(*           from which commands are input.                         *) # #(*                                                                  *) # #(* PROGRAMMER : <EDB> <MRL>                                         *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      execute_tr_command                          *) # #(********************************************************************) #     PROCEDURE execute_tr_command   $ Alias 'DBUTL.TR.CMD' $      ( VAR parameter_buffer: parm_buffer );       CONST      do_not_extend_file = false;      VAR       tr_requested: boolean;          (* transfer requested flag *)      return_status : Short_int;           BEGIN (* execute_tr_command *)         (* check optional command file parameter *)     WITH parameter_buffer.parameter[2] DO  	      CASE typ OF  	              non: (* not supplied *)              tr_requested := false;               int, asc: BEGIN (* integer or ascii parameter *)               IF sec_input_file_name <> ' '                  THEN nonfatal_error (cannot_nest_cmd_file_err);                  (* now check if file exists *)              file_dest_long_srce                        (temp_file.newfl, chars_in_new_file_name,                        ascii, chars_in_long_str,                         str_assign, zero);                  IF open_existing_file (temp_file, return_status)                 THEN nonfatal_error (return_status);                   IF close_file (temp_file, return_status) THEN;                  tr_requested := true;               END; (* asc CASE *)                END; (* CASE *)         (* check if transfer requested *)     IF tr_requested THEN BEGIN                 (* if disc file, save pending line number for return *)            IF NOT is_interactive_file(input_file)               THEN IF get_pending_line (input_file.dcb,                                         pending_line,                                         return_status)                      THEN nonfatal_error (return_status);           in_TR_file := true;               (* set up new command file *)           sec_input_file_name := input_file.newfl;            input_file.newfl := temp_file.newfl;            open_command_file;   
      END (* THEN *) 
         ELSE BEGIN                   (* return from transfer file *)                 (* first check if not in command file *)            IF sec_input_file_name = ' '               THEN nonfatal_error (no_previous_cmd_file_err);                (* now set up new command file *)           input_file.newfl := sec_input_file_name;            sec_input_file_name := ' ';               (* open new command file and restore pending line *)            open_command_file;            IF NOT is_interactive_file(input_file)               THEN IF return_to_pending_line (input_file.dcb,                                               pending_line,                                               return_status)                      THEN fatal_error (return_status);            in_TR_file := false;             END; (* ELSE *)       END; (* execute_tr_command *)   .  