$PASCAL ',7 92081-1X817 REV.5000' $ $ Title 'DBUTL: Start up IMAGE' $  $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18817                                        *)   (* RELOC:   92081-16817                                        *)   (*                                                             *)   (* PGMR:        <EDB> <MRL>                                    *)   (*              <TH> for NLS                                   *)   (*                                                             *)   (* Date last modified: <870113.1612>  (*                                                             *)   (* Modified June 16, 1986:  Added a new undocumented feature   *)   (* for the SU command to schedule the PIGGY/SLURP tools.       *)   (* The command syntax is 'SU,PIGGY', which schedules PIGGY     *)   (* instead of DBMON.  PIGGY in turn schedules SLURP and DBMON  *)   (* with the appropriately massaged run strings. <MRL>          *)   (*                                                             *)   (***************************************************************)       (**) %(*:nl:$ATB, mut_su, %ut000, relocatable, 92081-16078 REV.2540 <870113.1612> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)     PROGRAM start_up_IMAGE;     $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBUTL', List ON $ $ List OFF, Include '[UTNLS', List ON $  $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #      $ List OFF, Include '[XDMSG', List ON $  (* Message externals *)   !$ List OFF, Include '[XDSEM', List ON $  (* Resource# externals *) ! !$ List OFF, Include '[XDCIO', List ON $  (* DBCON I/O externals *) ! !$ List OFF, Include '[XDTDY', List ON $  (* Timestamp externals *) !    $ List OFF, Include '[XUU_M', List ON $ $ List OFF, Include '[XUU_3', List ON $ $ List OFF, Include '[XUU_4', List ON $ $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XUSHF', List ON $ $ List OFF, Include '[XDCCP', List ON $ $ List OFF, Include '[XDSCD', List ON $  (* Schedule progs *) $ List OFF, Include '[XDIHK', List ON $  (* Suicide IMAGE. *) #$ List OFF, Include '[XDLDP', List ON $  (* Check if program dormant *) #     $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #PROCEDURE MUT_SU; EXTERNAL;                                          PROCEDURE kill_thyself  $ Alias 'EXEC' $    (exec_six_code : short_int);     EXTERNAL;      $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_su_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL SU   *) # #(*           command.  The SU command is used to start up the IMAGE *) # #(*           subsystem.                                             *) # #(*                                                                  *) # #(* PROGRAMMER : <EDB> <MRL>                                         *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      execute_su_command                          *) # #(********************************************************************) #     PROCEDURE execute_su_command  $ Alias 'DBUTL.SU.CMD'$     ( VAR parameter_buffer: parm_buffer );     LABEL 99;     	$ Include '[PROG' $ 	    CONST     schedule_without_wait = -32758;  (* 10 + bit15 *)     VAR    return_status : Short_int;    current_log_status : Logging_states;     "   dbmon_startup_message:          (* dbmon startup message buffer *) "      dbmon_startup_request_mesg; "   dbspl_startup_message:          (* dbspl startup message buffer *) "      dbspl_startup_request_mesg; "   DBCLN_startup_message:          (* DBCLN startup message buffer *) "      DBCLN_startup_request_mesg;      $   debug_dbmon, debug_dbspl, debug_DBCLN : Boolean; (* debug program? *) $       start_dbmon, start_dbspl, start_DBCLN : Boolean;                                     (* Really schedule program? *)       
   number_str : short_str; 
     memory_lock: Boolean;  (* Tell DBMON to memory-lock itself *)       &   start_piggy : boolean; (* Use the PIGGY/SLURP message recording tools? *) &     BEGIN (* execute_su_command *)        (**)     (* Assume all three programs will be activated.    (**)        start_dbmon := true;    start_dbspl := true;    start_DBCLN := true;    memory_lock := true;         debug_dbmon := false;     debug_dbspl := false;     debug_DBCLN := false;     start_piggy := false;        (* See if IMAGE is already up *)        WITH dbcon_table.dbcon_status_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)          THEN nonfatal_error (return_status);           (* check if IMAGE already active *)       IF flag.image_active THEN BEGIN  (*       temp_str := 'IMAGE already started'; *)           (*:nl:#*1 1000 'IMAGE already started' *)          (*:nl:$COPY '         length := nlread (&, #' *)          length := nlread (MUT_SU, 1000                                    , nlerr, temp_str, len);  "         blank_pad (temp_str, chars_in_long_str, length);  (* NLS *) "          IF write_long_str (log_file, temp_str, return_status)              THEN nonfatal_error (return_status);          GOTO 99;           END; (* THEN *)     
      END; (* with *) 
       (**)     (* Clear out the class communication lines.    (**)             WITH image_comm_buffer DO BEGIN  $      IF clear_comm_path (dbmon_comm_id, dbmon_comm_lock, return_status) $         THEN nonfatal_error (return_status);      $      IF clear_comm_path (dbspl_comm_id, dbspl_comm_lock, return_status) $         THEN nonfatal_error (return_status);      $      IF clear_comm_path (DBCLN_comm_id, DBCLN_comm_lock, return_status) $         THEN nonfatal_error (return_status);            IF clear_comm_path (spl_reply_comm_id, zero, return_status)           THEN nonfatal_error (return_status);           IF unlock_comm_lock_id (dblck_wait_lock, return_status)          THEN nonfatal_error (return_status);           IF unlock_comm_lock_id (dbcon_file_lock, return_status)          THEN nonfatal_error (return_status);           END; (* with comm buffer *)             WITH parameter_buffer.parameter[2] DO       CASE typ OF          non : ;   (* not required *)              int :  nonfatal_error (illegal_parm_type_err);               asc :  !            BEGIN (* See which programs are not to be scheduled *) !                   IF  ascii = 'XDBMON'                    THEN BEGIN                       start_dbmon := false;                      debug_dbmon := true; 
                  END 
                ELSE IF  ascii = 'XDBSPL'                    THEN BEGIN                       start_dbspl := false;                      debug_dbspl := true; 
                  END 
               ELSE IF ascii = 'XDBCLN'                    THEN BEGIN                       start_DBCLN := false;                      debug_DBCLN := true; 
                  END 
               ELSE IF ascii = 'NONE'                    THEN BEGIN                       start_dbmon := false;                       start_dbspl := false;                       start_DBCLN := false;                       debug_dbmon := false;                       debug_dbspl := false;                       debug_DBCLN := false; !                     END  (* deciding which programs to schedule *) !               ELSE IF ascii = 'UNLOCK'                   THEN memory_lock := false                ELSE IF ascii = 'PIGGY' THEN BEGIN                   start_dbmon := false;                    start_piggy := true;                   END; (* then piggy *)                 END; (* ascii case *)           END; (* case of parameter type *)            (**)    (* read the latest copy of the dbcon status block *)    (**)    WITH dbcon_table.dbcon_status_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)          THEN nonfatal_error (return_status);            current_log_status := logging_state;           IF (logging_state<>rb_rf) AND (logging_state<>rf_nospool)          THEN start_dbspl := false;      	   END; (* with *) 	           WITH dbcon_table.dbcon_bif_info_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_bif_info_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)          THEN nonfatal_error (return_status);           IF (bif_name = ' ')          THEN nonfatal_error (bif_not_defined_err);     
      END; (* with *) 
           WITH dbcon_table.dbcon_tlf_info_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_tlf_info_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)          THEN nonfatal_error (return_status);            IF current_log_status <> intr_only          THEN IF tlf_name = ' '              THEN nonfatal_error (tlf_not_defined_err);     
      END; (* with *) 
       WITH dbcon_table.dbcon_rfl_info_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_rfl_info_blk,                             do_not_lock_dbcon_file,                            block,                            return_status)          THEN nonfatal_error (return_status);      #      IF (current_log_status=rb_rf) OR (current_log_status=rf_nospool) #         THEN IF rfl_name = ' '              THEN nonfatal_error (rfl_not_defined_err);     
      END; (* with *) 
       (* Start up DBCLN *)     WITH DBCLN_startup_message DO BEGIN       DBCLN_comm_id := image_comm_buffer.DBCLN_comm_id;       reply_comm_id := dbutl_comm_id;        END;        IF start_DBCLN       THEN IF activate_DBCLN ('XQ,DBCLN.RUN',                               DBCLN_startup_message) THEN BEGIN          image_hari_kari;           nonfatal_error (DBCLN_not_ready_err);           END           ELSE (* do nothing *)           ELSE IF debug_DBCLN          THEN IF activate_DBCLN ('XQ,CI,DEBUG_DBCLN::IMAGE2',  !                                 DBCLN_startup_message) THEN BEGIN !         image_hari_kari;           nonfatal_error (DBCLN_not_ready_err);          END;         (* expect reply from DBCLN *)    IF start_DBCLN OR debug_DBCLN THEN 	   IF get_message ( 	                   dbutl_comm_id,                   zero,                   zero,  (* wait for message *)                    request_msg.user.from_comm_id,                    reply_msg_len,                   universal_mesg_hdr_len,                    return_status)        THEN nonfatal_error (return_status);            (* Start up DBSPL *)     WITH dbspl_startup_message DO BEGIN       dbspl_comm_id := image_comm_buffer.dbspl_comm_id;       reply_comm_id := dbutl_comm_id;        END;  (* with *)        IF start_dbspl       THEN IF activate_dbspl ('XQ,DBSPL.RUN',                               dbspl_startup_message) THEN BEGIN          image_hari_kari;           nonfatal_error (dbspl_not_ready_err);           END           ELSE (* do nothing *)           ELSE IF debug_dbspl          THEN IF activate_dbspl ('XQ,CI,DEBUG_DBSPL::IMAGE2',  !                                 dbspl_startup_message) THEN BEGIN !         image_hari_kari;           nonfatal_error (dbspl_not_ready_err);          END;        IF start_dbspl OR debug_dbspl THEN 	   IF get_message ( 	                   dbutl_comm_id,                   zero,                   zero,  (* wait for message *)                    request_msg.user.from_comm_id,                    reply_msg_len,                   universal_mesg_hdr_len,                    return_status)        THEN nonfatal_error (return_status);            (* Start up DBMON *)     WITH dbmon_startup_message DO BEGIN       dbmon_comm_id := image_comm_buffer.dbmon_comm_id;        memlock       := ord(memory_lock);       reply_comm_id := dbutl_comm_id; 
      END; (* with *) 
        IF start_dbmon THEN BEGIN        IF activate_dbmon ('XQ,DBMON.RUN',                           dbmon_startup_message) THEN BEGIN          image_hari_kari;           nonfatal_error (dbmon_not_ready_err);          END;       END (* then start dbmon normally *)        ELSE IF debug_dbmon THEN BEGIN       IF activate_dbmon ('XQ,CI,DEBUG_DBMON::IMAGE2',                           dbmon_startup_message) THEN BEGIN          image_hari_kari;           nonfatal_error (dbmon_not_ready_err);          END;        END (* then debug dbmon *)      $   ELSE IF start_piggy THEN BEGIN  (* start DBMON msg recording tools *) $       IF activate_dbmon ('XQ,/PROGRAMS/PIGGY.RUN',                           dbmon_startup_message) THEN BEGIN          image_hari_kari;           nonfatal_error (dbmon_not_ready_err);          END;       END; (* then start piggy *)         (* expect a reply from dbmon *)     IF start_dbmon OR debug_dbmon OR start_piggy THEN 	   IF get_message ( 	                   dbutl_comm_id,                   zero,                    zero,  (* wait for message code *)                    request_msg.user.from_comm_id,                    reply_msg_len,                   universal_mesg_hdr_len,                    return_status)        THEN nonfatal_error (dbmon_not_ready_err);            WITH dbcon_table.dbcon_status_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                            lock_dbcon_file,                            block,                            return_status)          THEN nonfatal_error (return_status);            WITH flag DO BEGIN           dbmon_active := true;          dbspl_active := start_dbspl;           DBCLN_active := true;           image_active := true;           END; (* with *)           IF write_dbcon_table (dbcon_file,                             dbc_status_blk,                              unlock_dbcon_file,                              block,                              return_status)          THEN nonfatal_error (return_status);            END; (* with dbcon status block *)      (* temp_str := 'IMAGE started'; *)     (*:nl:#*1 1001 'IMAGE started' *) "   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *) "   length := nlread (MUT_SU, 1001, nlerr, temp_str, len);         blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)     IF write_long_str (log_file, temp_str, return_status)        THEN nonfatal_error (return_status);         IF debug_DBCLN OR debug_dbmon OR debug_dbspl THEN BEGIN         (* ok - we don't want to say 'soft crash' when we can't *)          (* find the ID segment for the debugged program.  So... *)          (* let's just terminate DBUTL now.                      *)         temp_str := 'DBUTL aborting for you to debug';        IF write_long_str (log_file, temp_str, return_status) THEN;        kill_thyself (6);        END;      99:  (* to skip around startup processing *)     END; (* execute_su_command *)  .  