 $PASCAL ',7 92081-1X815 REV.2540' $   $ Title 'DBUTL: Shut down IMAGE' $  $ Heap 0 $  	$ Recursive OFF $  	 $ Range OFF $       $ Subprogram $      !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18815                                        *)  ! !(* RELOC:   92081-16815                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <EDB> <MRL>                                    *)  ! !(*              <TH> for NLS                                   *)  ! !(*                                                             *)  ! (* Date last modified: <860117.1034>  !(*                                                             *)  ! !(* Bug fix, January 1986:  DBSPL cannot afford to shut down    *)  ! !(* when waiting for a log volume.  Therefore a "can't shutdown"*)  ! !(* flag was added to the DBCON file.  <MRL>                    *)  ! !(*                                                             *)  ! !(***************************************************************)  !     (**)  &(*:nl:$ATB, mut_sd, %ut000, relocatable, 92081-16078 REV.2540 <860117.1034>  & (*:nl:$   
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      PROGRAM IMAGE_shut_down;      $ List OFF, Include '[IMAGE', List ON $   $ List OFF, Include '[DBUTL', List ON $   $ List OFF, Include '[UTNLS', List ON $   $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #      $ List OFF, Include '[XDMSG', List ON $  (* Message externals *)   !$ List OFF, Include '[XDSEM', List ON $  (* Resource# externals *) ! !$ List OFF, Include '[XDCIO', List ON $  (* DBCON I/O externals *) ! !$ List OFF, Include '[XDTDY', List ON $  (* Timestamp externals *) !     $ List OFF, Include '[XUU_M', List ON $   $ List OFF, Include '[XUU_3', List ON $   $ List OFF, Include '[XUU_4', List ON $   $ List OFF, Include '[XDFMP', List ON $   $ List OFF, Include '[XDSLP', List ON $       $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)      $(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *)  $  PROCEDURE MUT_SD; EXTERNAL;                                            $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_sd_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL SD   *) # #(*           command.  The SD command is shut down the IMAGE        *) # #(*           subsystem.                                             *) # #(*                                                                  *) # #(* PROGRAMMER : <EDB> <MRL>                                         *) # #(*                                                                  *) # #(********************************************************************) # $ Page $      #(********************************************************************) # #(*                 external routine definitions                     *) # #(********************************************************************) #     PROCEDURE execute_cl_command   $ Alias 'DBUTL.CL.CMD' $      (VAR parameter_buffer : parm_buffer);     EXTERNAL;  $ Page $  #(********************************************************************) # #(*                      execute_sd_command                          *) # #(********************************************************************) #     PROCEDURE execute_sd_command $ALIAS 'DBUTL.SD.CMD'$      ( VAR parameter_buffer: parm_buffer );       VAR      return_status : Short_int;           BEGIN (* execute_sd_command *)             (**)      (* Read the dbcon status block for current IMAGE status.      (**)          WITH dbcon_table.dbcon_status_block DO BEGIN             IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             do_not_lock_dbcon_file,                             block,                              return_status)            THEN nonfatal_error (return_status);                 (* check if IMAGE already shutdown *)         IF (NOT flag.image_active) THEN BEGIN       (*       temp_str := 'IMAGE is already shut down'; *)            (*:nl:#*1 1000 'IMAGE is already shut down' *)            (*:nl:$COPY '         length := nlread (&, #' *)            length := nlread (MUT_SD, 1000                                  , nlerr, temp_str, len);   "         blank_pad (temp_str, chars_in_long_str, length);  (* NLS *) "          IF write_long_str (log_file, temp_str, return_status)              THEN nonfatal_error (return_status);               END (* THEN *)       
         ELSE BEGIN  
                 (* Check if "can't shut down" flag is on *)               IF flag.cant_shut_down                 THEN nonfatal_error (rfl_full_warn_code);                  (**)              (* Perform cleanup before shutting down, in case              (* aborted programs look like they have resources.              (**)                  execute_cl_command (parameter_buffer);      (*          temp_str := 'Beginning IMAGE shutdown'; *)              (*:nl:#*1 1001 'Beginning IMAGE shutdown' *)               (*:nl:$COPY '            length := nlread (&, #' *)                length := nlread (MUT_SD, 1001                                       , nlerr, temp_str, len);   $            blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)  $             IF write_long_str (log_file, temp_str,                                 return_status)                  THEN nonfatal_error (return_status);                   IF read_dbcon_table (dbcon_file,                                   dbc_status_blk,                                   lock_dbcon_file,                                    block,                                    return_status)                  THEN nonfatal_error (return_status);                    system_access := disabled;                    IF write_dbcon_table (dbcon_file,                                     dbc_status_blk,                                     unlock_dbcon_file,                                      block,                                      return_status)                        THEN nonfatal_error (return_status);                     IF build_dbmon_mesg_hdr (to_bm_change_status_code,                                          return_status)                  THEN nonfatal_error (return_status);                   request_msg.dbmon.change_status.changed_status :=                      system_access_changed;                   IF xchg_dbmon_msg (request_msg.dbmon,                                  to_bm_change_status_mesg_len,                                   request_msg.user,                                   reply_msg_len,                                  to_bm_max_mesg_len,                                   return_status)                  THEN nonfatal_error (return_status);                    WITH request_msg.user DO                   IF request <> to_user_no_error_code                      THEN nonfatal_error (error.reply.status);       (*            temp_str := 'IMAGE system access disabled'; *)                (*:nl:#*1 1002 'IMAGE system access disabled' *)  "              (*:nl:$COPY '              length := nlread (&, #' *)  "               length := nlread (MUT_SD, 1002      !                                          , nlerr, temp_str, len); ! %              blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)  %                   IF write_long_str (log_file, temp_str,                                   return_status)                    THEN nonfatal_error (return_status);                          IF Build_dbmon_mesg_hdr (to_bm_change_status_code,                                          return_status)                    THEN nonfatal_error (return_status);                      request_msg.dbmon.change_status.changed_status :=                         shutdown_changed;                    IF xchg_dbmon_msg (request_msg.dbmon,                                    to_bm_change_status_mesg_len,                                   request_msg.user,                                   reply_msg_len,                                    to_bm_max_mesg_len,                                   return_status)                    THEN nonfatal_error (return_status);                     WITH request_msg.user DO                   IF request <> to_user_no_error_code                      THEN nonfatal_error (error.reply.status);       (*            temp_str := 'IMAGE is shut down'; *)                (*:nl:#*1 1003 'IMAGE is shut down' *)  "              (*:nl:$COPY '              length := nlread (&, #' *)  "               length := nlread (MUT_SD, 1003      !                                         , nlerr, temp_str, len);  ! %              blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)  %     "              IF write_long_str (log_file, temp_str, return_status)  "                  THEN nonfatal_error (return_status);                     END; (* else start shutdown *)            END; (* with dbcon status block *)      
END; (* procedure *) 
 .  