$PASCAL ',7 92081-1X798 REV.5000' $  $ Title 'DBUTL: Execute rollback recovery' $  $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18798                                        *)   (* RELOC:   92081-16798                                        *)   (*                                                             *)   (* PGMR:        <EDB> <MRL>                                    *)   (*                                                             *)   (* Date last modified: <870113.1611>  (*                                                             *)   (* Bug fix: June 25, 1986 <MRL>                                *)   (*    Do not give an error if recovery is not needed.          *)   (*    Issue a message saying 'no recovery needed', and allow   *)   (*    subsequent commands to be executed.                      *)   (*                                                             *)   (***************************************************************)       
PROGRAM rollback_recovery; 
    $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[DBUTL', List ON $ $ List OFF, Include '[UTNLS', List ON $      (**) %(*:nl:$ATB, mut_rb, %ut000, relocatable, 92081-16078 REV.4903 <870113.1611> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #      $ List OFF, Include '[XDMSG', List ON $  (* Message externals *)    $ List OFF, Include '[XUSHF', List ON $  (* Upshift externals *)   !$ List OFF, Include '[XDSEM', List ON $  (* Resource# externals *) ! !$ List OFF, Include '[XDCIO', List ON $  (* DBCON I/O externals *) ! !$ List OFF, Include '[XDTDY', List ON $  (* Timestamp externals *) !    $ List OFF, Include '[XUU_M', List ON $ $ List OFF, Include '[XUU_3', List ON $ $ List OFF, Include '[XUU_4', List ON $ $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XDNLS', List ON $     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #PROCEDURE MUT_RB; EXTERNAL;                                          $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_rb_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL RB   *) # #(*           command.  The RB command is perform a roll back        *) # #(*           recovery on a data base.                               *) # #(*                                                                  *) # #(* PROGRAMMER : <EDB> <MRL>                                         *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      execute_rb_command                          *) # #(********************************************************************) #    PROCEDURE execute_rb_command   $ Alias 'DBUTL.RB.CMD' $    ( VAR parameter_buffer: parm_buffer );      LABEL 99; (* to bypass recovery if not needed *)     CONST     dbrbr = prog_name               (* DBRBR standard name *)       [ 'DBRBR', chars_in_prog_name-5 OF ' ' ];     VAR  !   stats_requested: boolean;       (* statistics requested flag *) !    return_status  : Short_int;    dbcon_block    : dbcon_table_type;  	   msg : long_str; 	     BEGIN (* execute_rb_command *)        (* Check that a crash condition really exists *)    IF read_dbcon_block (dbcon_file,                         dbc_status_blk,                         do_not_lock_dbcon_file,                          dbcon_block,                          return_status)        THEN nonfatal_error (return_status);        WITH dbcon_block.dbcon_status_block DO    IF (NOT flag.crash_flag) OR (flag.image_active) THEN BEGIN %(*    msg := 'Soft crash recovery is not needed.  Ignoring RB command.'; *) %      (*:nl:#*1 1000 'IMAGE already started' *)        (*:nl:$COPY '         length := nlread (&, #' *)          length := nlread (MUT_RB, 1000                             , nlerr, msg, len);        blank_pad (msg, chars_in_long_str, length);  (* NLS *)        IF write_long_str (log_file, msg, return_status)          THEN nonfatal_error (return_status);        GOTO 99;        END;         (* execute DBRBR program, passing command line *)     execute_recovery_program (dbrbr, parameter_buffer);      99: (* skip over recovery if not needed *)     END; (* execute_rb_command *)  .  