 $PASCAL ',7 92081-1X793 REV.2540' $   $ Title 'DBUTL archive command' $   $ Heap 0 $  	$ Recursive OFF $  	     $ Subprogram $      PROGRAM archive_command;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(**                                                               * *) # #(** SOURCE:  92081-18793                                          * *) # #(** RELOC:   92081-16793                                          * *) # #(**                                                               * *) # #(** Altered: March 1984 for new file system.                      * *) # #(**          Dec. 1984 for NLS. <TH>                             * *)  # #(**                                                               * *) # #(* **************************************************************** *) #     (**)  &(*:nl:$ATB, mut_ar, %ut000, relocatable, 92081-16078 REV.2540 <851118.1432>  & (*:nl:$   
(*:nl:$COUNTER, 1, 1000, 1 
 (**)  $ List OFF, Include '[IMAGE', List ON $   $ List OFF, Include '[DBUTL', List ON $   $ List OFF, Include '[UTNLS', List ON $   $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) # $ List OFF $  
$ Include '[XUU_M' $ 
 
$ Include '[XUU_3' $ 
 
$ Include '[XDSMR' $ 
 
$ Include '[XUU_4' $ 
 
$ Include '[XDFMP' $ 
     
$ Include '[XDCIO' $ 
 
$ Include '[XDMSG' $ 
 
$ Include '[XUSHF' $ 
 
$ Include '[XDSEM' $ 
 
$ Include '[XDNLS' $ 
 $ List ON $   #(* Log_record_addr returns a pointer to a general log record from   *) # #(* a specified address.                                             *) #     FUNCTION log_record_addr $ Alias '.DRCT', Direct $     ( buffer: short_int): ptr_log_record_header_type;     EXTERNAL;          (*:nl:$COPY 'PROCEDURE &; EXTERNAL;' *)   PROCEDURE MUT_AR; EXTERNAL;           $ Page $      #(*******************************************************************)  # #(*                                                                 *)  # #(* ROUTINE : execute_ar_command                                    *)  # #(*                                                                 *)  # #(* PURPOSE : This routine performs the operations of the DBUTL AR  *)  # #(*           command.  The AR command is used to archive a disc    *)  # #(*           log file to magnetic tape.  Doing the reverse is      *)  # #(*           not allowed for: so once on tape, always on tape.     *)  # #(*                                                                 *)  # #(* PGMR:        <EDB> <MRL>                                        *)  # #(*                                                                 *)  # (* Date of last modification: <851118.1432>   #(*                                                                 *)  # #(*******************************************************************)  # $ Page $  #(*******************************************************************)  # #(*                      execute_ar_command                         *)  # #(*******************************************************************)  #     PROCEDURE execute_ar_command $ALIAS 'DBUTL.AR.CMD'$      ( VAR parameter_buffer: parm_buffer );       CONST      archive = prog_name       [ 'DBARC', chars_in_prog_name-5 OF ' ' ];      VAR      return_status :  short_int;     verify_specified :  boolean;      nls_temp_name1: new_file_name;      nls_temp_name2: new_file_name;       BEGIN (* execute_ar_command *)         (* PRE SCREEN PARAMETERS BEFORE PASSING TO DBARC *)         (* check required disc file parameter *)      WITH parameter_buffer.parameter[2] DO  	      CASE typ OF  	              non:  (* must be supplied *)                  nonfatal_error (missing_parameter_err);               int: (* integer parameter *)               nonfatal_error (not_disc_file_err);                asc: (* ascii parameter *)   	            BEGIN  	                file_dest_long_srce (temp_file.newfl,                                      chars_in_new_file_name,                                       ascii,                                      chars_in_long_str,                                      str_assign,                                       zero);              END; (* asc CASE *)                END; (* CASE *)         (* check required tape file parameter *)      WITH parameter_buffer.parameter[3] DO  	      CASE typ OF  	              non:  nonfatal_error (missing_parameter_err);               int: (* integer parameter *)   	            BEGIN  	                file_dest_long_srce (temp2_file.newfl,                                       chars_in_new_file_name,                                       ascii,                                      chars_in_long_str,                                      str_assign,                                       zero);                     IF open_file_for_write (temp2_file, error_code)                    THEN nonfatal_error (error_code);                      IF NOT is_tape_file (temp2_file)                     THEN nonfatal_error (not_tape_file_err);                     IF close_file (temp2_file, error_code) THEN;                   END; (* int CASE *)                asc: (* ascii parameter *)               nonfatal_error (not_tape_file_err);                END; (* CASE *)         (* check optional verify parameter *)     WITH parameter_buffer.parameter[4] DO      	      CASE typ OF  	              non:   verify_specified := false;               int:   nonfatal_error ( illegal_parm_type_err );                asc:   IF (ascii = 'VE') OR (ascii = 'V ')                      THEN verify_specified := true                     ELSE nonfatal_error (illegal_option_err);            END;  (* case *)              (***********************************************************)       (* send message to user telling him that archive has begun *)       (***********************************************************)   
   temp_str := ' ';  
    IF write_long_str (log_file, temp_str, error_code)         THEN nonfatal_error (error_code);   (*     temp_str := 'Archiving';          long_dest_file_srce (temp_str, chars_in_long_str,                           temp_file.newfl, chars_in_new_file_name,                           str_blankappend, zero);          append_blank_and_str (temp_str, 'to');          long_dest_file_srce (temp_str, chars_in_long_str,  !                        temp2_file.newfl, chars_in_new_file_name,  !                         str_blankappend, zero);   *)     (* The two temp file names are copied to avoid the null *)      (* byte that NLS places at the end of the file name.    *)      (* The null was being passed to DBARC and the FmpOpen   *)      (* call would fail with error -15, 'Illegal name'.      *)          nls_temp_name1 := temp_file.newfl;      nls_temp_name2 := temp2_file.newfl;         null_pad_fname (nls_temp_name1, chars_in_new_file_name);      null_pad_fname (nls_temp_name2, chars_in_new_file_name);          (*:nl:$  '!1 is the source file descripter.'      *)      (*:nl:$  '!2 is the destination file descripter.' *)      (*:nl:#*1 1000 'Archiving !1 to !2' *)   '   (*:nl:$COPY '   length := nlread_p2_fname (&, #, nlerr, temp_str, len,' *)  ' !   length := nlread_p2_fname (MUT_AR, 1000, nlerr, temp_str, len,  !                         nls_temp_name1, nls_temp_name2);     blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)     IF write_long_str (log_file, temp_str, error_code)         THEN nonfatal_error (error_code);              (* PREPARE RUN STRING FOR DBARC *)          temp_str := 'RU,';      append_str (temp_str, archive);     append_str (temp_str, ',');         (* pass DBUTL's log file to DBARC *)      long_dest_file_srce (temp_str, chars_in_long_str,                           log_file.newfl, chars_in_new_file_name,                            str_append, zero);         append_str (temp_str, ',');         long_dest_file_srce (temp_str, chars_in_long_str,                           temp_file.newfl, chars_in_new_file_name,                           str_append, zero);         append_str (temp_str, ',');         long_dest_file_srce (temp_str, chars_in_long_str,  !                        temp2_file.newfl, chars_in_new_file_name,  !                         str_append, zero);         IF verify_specified        THEN append_str ( temp_str, ',VE' );         (* close DBUTL's log file so DBARC can write to it *)     IF NOT is_interactive_file (log_file)        THEN IF close_file ( log_file, return_status ) THEN;         (* SCHEDULE DBARC *)      run_program ( archive, temp_str, temp_str, error_code );      IF error_code <> no_image_err        THEN nonfatal_error (error_code);          (* open up DBUTL's log file again *)      IF NOT is_interactive_file (log_file)        THEN IF open_file_for_append ( log_file,                                       return_status )             THEN fatal_error ( return_status );      
   temp_str := ' ';  
    IF write_long_str (log_file, temp_str, error_code)         THEN nonfatal_error (error_code);       END; (* execute_ar_command *)       
(* end of &UT_AR *)  
 .  