 $PASCAL ',7 92081-1X807 REV.2540' $   $ Title 'DBUTL Access change command' $   $ Heap 0 $  $ Recursive OFF, Range OFF $      $ Subprogram $      PROGRAM change_access_command;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* *                                                              * *) # #(* * SOURCE:  92081-18807                                         * *) # #(* *                                                              * *) # #(* **************************************************************** *) #     (**)  &(*:nl:$ATB, mut_ac, %ut000, relocatable, 92081-16078  REV.2540 <851118.1431> & (*:nl:$   (*:nl:$COUNTER, 1, 0, 1   
(*:nl:$COUNTER, 2, 1000, 1 
 (**)  $ List OFF, Include '[IMAGE', List ON $   $ List OFF, Include '[DBUTL', List ON $   $ List OFF, Include '[UTNLS', List ON $   $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) # $ List OFF $  
$ Include '[XUU_M' $ 
 
$ Include '[XUU_3' $ 
 
$ Include '[XDSMR' $ 
 
$ Include '[XUU_4' $ 
 
$ Include '[XDFMP' $ 
     
$ Include '[XDCIO' $ 
 
$ Include '[XDMSG' $ 
 
$ Include '[XUSHF' $ 
 
$ Include '[XDSEM' $ 
 
$ Include '[XDNLS' $ 
 $ List ON $       (*:nl:$COPY 'PROCEDURE &; EXTERNAL;' *)   PROCEDURE MUT_AC; EXTERNAL;           $ Page $      #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : execute_ac_command                                     *) # #(*                                                                  *) # #(* PURPOSE : This routine performs the operations of the DBUTL AC   *) # #(*           command.  The AC command is used to control the access *) # #(*           to data bases in the IMAGE subsystem.                  *) # #(*                                                                  *) # #(* PGMR:        <EDB> <MRL> <STC>                                   *) # #(*                                                                  *) # #(********************************************************************) # $ Page $  #(********************************************************************) # #(*                      execute_ac_command                          *) # #(********************************************************************) #     PROCEDURE execute_ac_command   $ Alias 'DBUTL.AC.CMD' $      ( VAR parameter_buffer: parm_buffer );       TYPE  "   db_access_names_type =          (* array of names for display *)  "       ARRAY[db_access_type] OF short_str;       (*  CONST          db_access_names = db_access_names_type         [ short_str [ 'DISABLED', chars_in_short_str-8 of ' ' ],           short_str [ 'READ-ONLY', chars_in_short_str-9 of ' ' ],            short_str [ chars_in_short_str of ' ' ],  "        short_str [ 'READ-WRITE', chars_in_short_str-10 of ' ' ] ];  "  *)      (**)   &   (*:nl:$     'The message length of No.0 to No.3 must be within 15 bytes'  &    (*:nl:$  
   (*:nl:#*1 0 'DISABLED'  
 
   (*:nl:#*1 1 'READ-ONLY' 
 	   (*:nl:#*1 2 ' ' 	    (*:nl:#*1 3 'READ-WRITE'      (**)       VAR      access_change: boolean;         (* access change flag *)      access_option: db_access_type;  (* access change option *)       "   system_access_flag: boolean;    (* system access request flag *)  " "   shutdown_flag :  boolean;       (* true if determined shutdown *) "    return_status : Short_int;      dummy_status  : Short_int;      reply_len : short_int;          (* message reply length *)   !   option_num  : short_int;        (* db_access_type number *nls*) ! !   access_str  : short_str;        (* db_access_type string *nls*) !     PROCEDURE handle_system_access;       BEGIN (* handle_system_access *)         IF access_change THEN        WITH dbcon_table.dbcon_status_block DO BEGIN           IF read_dbcon_table (              dbcon_file,               dbc_status_blk,               lock_dbcon_file,  	            block, 	             return_status) THEN            nonfatal_error (return_status);      '         shutdown_flag := NOT(flag.image_active);  (* from dbcon status blk *) '          (* check if system access change *)               system_access := access_option;           (* update dbcon with new system access *)           IF write_dbcon_table (dbcon_file,                                 dbc_status_blk,                                 unlock_dbcon_file,                                  block,                                  return_status)               THEN nonfatal_error (return_status);                    (* if shutdown, can change system access level, but *)              (* we can't inform the nonexistent DBMON about it.  *)                 IF NOT shutdown_flag THEN BEGIN  "            (*  Tell dbmon about the new access so dbmon          *) " "            (*  can get it from dbcon.  Also check on its status. *) "                 IF build_dbmon_mesg_hdr (to_bm_change_status_code,                                       return_status) THEN  %               (* we cannot send dbmon a message - dbmon is not around *)  %                return_status := zero              ELSE BEGIN                  request_msg.dbmon.change_status.changed_status :=                     system_access_changed;                 IF xchg_dbmon_msg (                     request_msg.dbmon,                      to_bm_change_status_mesg_len,                     request_msg.user,                     reply_len,                      to_user_utl_stat_change_mesg_len,                     return_status) THEN                     nonfatal_error ( return_status);                   END;  (* else *)      !            (* all is well - dbmon has been told and responded *)  !                END;  (*  IF NOT shutdown_flag  *)               END  (* with *)       !   ELSE         (* user just wants status displayed, so get it *)  !        WITH dbcon_table.dbcon_status_block DO BEGIN             IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                             do_not_lock_dbcon_file,                             block,                              return_status) THEN           nonfatal_error (return_status);        access_option := system_access;       
      END;  (* end with *) 
            (* display system access mode *)      (* temp_str := 'System Access Mode='; *nls*)      (*:nl:#*2 1000 'System Access Mode=' *)  #   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *)  #    length := nlread (MUT_AC, 1000, nlerr, temp_str, len);          blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)     option_num := ord (access_option);       (*:nl:$COPY '   length := nlread_s (&, option_num, nlerr,' *)      length := nlread_s (MUT_AC, option_num, nlerr,       #                                                  access_str, len_s);  # "   blank_pad_s (access_str, chars_in_short_str, length);  (* NLS *)  "     (* append_str (temp_str, db_access_names [access_option]); *)      append_str (temp_str, access_str);      IF write_long_str (log_file, temp_str, return_status)        THEN nonfatal_error (return_status);          END; (* handle_system_access *)   $ Page $      PROCEDURE handle_database_access;       CONST      all_false_alter_get_value =  alter_rootfile_types        [create_time : false,          backup_time : false,          volume_number : false,          first_trans : false,          volume_name : false,          log_set_name : false,  
       checksums : false,  
        db_modified : false,          part_unlogged : false,          logging_state :false,         accessibility : false ];           VAR   
   start_char : short_int; 
    rootfile_header : rootfile_header_type;      BEGIN (* handle_database_access *)         (* open rootfile *)      file_dest_long_srce (temp_file.newfl, chars_in_new_file_name,                           parameter_buffer.parameter[2].ascii,                          chars_in_long_str, str_assign, zero);          (* Get the complete root file name *)     build_root_name (temp_file.newfl);          (* check if database access change *)     IF access_change THEN BEGIN            (* build message header *)        IF build_dbmon_mesg_hdr ( to_bm_alter_rootfile_code,                                  return_status)  "         THEN BEGIN (* DBMON is not around: Modify root directly *)  "                 IF open_rootfile (temp_file, return_status)                  THEN nonfatal_error (return_status);                   IF read_rootfile_hdr (temp_file,                                    rootfile_header,                                    return_status)                 THEN nonfatal_error (return_status);                   rootfile_header.flags.access := access_option;                  IF write_rootfile_hdr (temp_file,                                      rootfile_header,                                      return_status)                  THEN nonfatal_error (return_status);                   IF close_file (temp_file, return_status) THEN;                  END  (* modifying rootfile directly *)                   ELSE BEGIN (* Send modification request to DBMON *)                  (* Add specific info pertaining to this request *)               (* Change string containing dbname to proper type *)                       WITH request_msg.dbmon.alter_rootfile DO BEGIN                 database := temp_file.newfl;                  to_alter := all_false_alter_get_value;                  to_alter.accessibility := true;                 db_access := access_option;  
               END;  
                (* send a message to dbmon *)             IF xchg_dbmon_msg (                request_msg.dbmon,                to_bm_alter_rootfile_mesg_len,                request_msg.user,                 reply_len,                to_user_utl_stat_change_mesg_len,                 return_status) THEN                 nonfatal_error (return_status);                (* Did DBMON encounter an error ? *)            WITH request_msg.user.utl_stat_change_mesg DO              IF reply.status <> zero THEN                 nonfatal_error (reply.status);                    END  (* ELSE tell DBMON to do the change *)            END (* then modify the database access *)          (* Else user wants current access displayed *)      (* Read it directly from the rootfile *)          ELSE BEGIN  (* see if DBMON is around: Handle both cases *)            IF build_dbmon_mesg_hdr (to_bm_get_rootfile_info_code,                                 return_status)             THEN BEGIN (* DBMON isn't around: read root directly *)                   IF open_rootfile (temp_file, return_status)                  THEN nonfatal_error (return_status);                   IF read_rootfile_hdr (temp_file,                                    rootfile_header,                                    return_status)                 THEN nonfatal_error (return_status);                   access_option := rootfile_header.flags.access;                  IF close_file (temp_file, return_status) THEN;                  END (* then read root directly *)           "         ELSE BEGIN (* DBMON is around: Ask it for current status *) "                 WITH request_msg.dbmon.get_rootfile_info DO BEGIN                  database := temp_file.newfl;                  to_get   := all_false_alter_get_value;                  to_get.accessibility := true;  
               END;  
                 IF xchg_dbmon_msg  (request_msg.dbmon,  !                                to_bm_get_rootfile_info_mesg_len,  !                                 request_msg.user,                                   reply_len,                                  to_user_utl_accst_mesg_len,                                   return_status)                 THEN nonfatal_error (return_status);                   WITH request_msg.user.utl_accst_mesg DO                  IF reply.status <> zero THEN                     nonfatal_error (reply.status);                  access_option :=                     request_msg.user.utl_accst_mesg.db_acc_status;                   END; (* else get current status from DBMON *)             END;  (* end else just display current access *)         (* display database access mode *)      (* temp_str := 'Database Access Mode='; *)      (*:nl:#*2 1001 'Database Access Mode=' *)  #   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *)  #    length := nlread (MUT_AC, 1001, nlerr, temp_str, len);          blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)     option_num := ord (access_option);       (*:nl:$COPY '   length := nlread_s (&, option_num, nlerr,' *)      length := nlread_s (MUT_AC, option_num, nlerr,                                              access_str, len_s);  "   blank_pad_s (access_str, chars_in_short_str, length);  (* NLS *)  "     (* append_str (temp_str, db_access_names [access_option]); *)      append_str (temp_str, access_str);      IF write_long_str (log_file, temp_str, return_status)        THEN nonfatal_error (return_status);      END; (* handle_database_access *)   $ Page $  BEGIN (* execute_ac_command *)         (* check required database parameter *)     WITH parameter_buffer.parameter [2] DO   	      CASE typ OF  	              (* cannot be not supplied *)            non:               nonfatal_error (missing_parameter_err);                int: (* integer parameter *)               nonfatal_error (illegal_file_name_err);                asc: (* ascii parameter *)   	            BEGIN  	                IF ascii = '* '                    THEN system_access_flag := true                     ELSE system_access_flag := false;                  END; (* asc CASE *)               END; (* CASE *)         (* check optional access parameter *)     WITH parameter_buffer.parameter [3] DO   	      CASE typ OF  	              non: (* not supplied *)              access_change := false;                int: (* integer parameter *)               nonfatal_error (illegal_parm_type_err);                asc: (* ascii parameter *)                BEGIN                  (* check for access option *)                  IF ascii = 'DI'                    THEN access_option := disabled                 ELSE IF ascii = 'RO'                     THEN access_option := read_only                  ELSE IF ascii = 'RW'                     THEN access_option := read_write                 ELSE nonfatal_error (illegal_option_err);                         access_change := true;                      END (* asc CASE *)                END; (* CASE *)             (* process either system access or database access *)     IF system_access_flag        THEN handle_system_access (* handle system access *)         ELSE handle_database_access; (* handle database access *)        END; (* execute_ac_command *)   .  