$PASCAL ',3,90 92081-16765 REV.5000'$      $ Heap 1 $ $ Recursive OFF $ $ Range OFF $  	$ Run_String 128 $ 	     PROGRAM data_base_store   $ Alias 'DBSTR' $;          (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18765                                        *)   (* RELOC:   92081-16765                                        *)   (*                                                             *)   (* PGMR:        <MRL>  <TH> for NLS                            *)   (*                                                             *)   (* Date last modified: <870414.1641>  (*                                                             *)   (***************************************************************)       (***************************************************************)   (*                                                             *)   (* Scheduling DBSTR:                                           *)   (*                                                             *)   (*    RU,DBSTR,prompt,list,storage,root,level,abort,verify     *)   (*                                                             *)   (* PROMPT must be interactive.                                 *)   (* LIST   is where DBULD output goes.                          *)   (* STORAGE is typically a tape, including Linus tapes.         *)   (* ROOT   is the database rootfile namr.                       *)   (* LEVEL  is the highest level word in the database.           *)   (* ABORT  is 'AB' or 'CO' to continue beyond one storage volume*)   (* VERIFY is 'VE' or 'NV' to verify/not verify.                *)   (*                                                             *)   (* Defaults:                                                   *)   (*    PROMPT  : the scheduling LU, typically LU 1.             *)   (*    LIST    : the scheduling LU.                             *)   (*    STORAGE : LU 8, typically a magtape.                     *)   (*    ROOT, LEVEL, ABORT and VERIFY are not defaultable and    *)   (*       are prompted for if omitted from the run string.      *)   (*                                                             *)   (* Overall program flow:                                       *)   (*                                                             *)   (*    1. Load segment DBST1.                                   *)   (*       A. Initialize DBSTR variables.                        *)   (*       B. Evaluate the run string parameters.                *)   (*       C. Open the root file and check for accessibility.    *)   (*       D. Determine the size needed for the storage.         *)   (*                                                             *)   (*    2. Load segment DBST2.                                   *)   (*       A. Dump the root file and data sets to the storage.   *)   (*       B. If the storage becomes full and no-abort was       *)   (*          specified, prompt for the next storage and         *)   (*          continue.                                          *)   (*                                                             *)   (*    3. Load segment DBST3.                                   *)   (*       A. If verify option was requested, do verification.   *)   (*       B. Close all files.                                   *)   (*       C. Terminate.                                         *)   (*                                                             *)   (***************************************************************)      LABEL 999, (* termination exit *)       91, 92;  (* NLS message test *)     $ List OFF, Include '[IMAGE', List ON $      $ List OFF, Include '[BACKUP_UTILS', List ON $     $ List OFF, Include '[STR_RST', List ON $     $ List OFF, Include '[DBSTR', List ON $      $ Page $ "(*******************************************************************) ""(*                    Main external definitions                    *) ""(*******************************************************************) "    $ List OFF, Include '[XBKP1', List ON $  $ List OFF, Include '[XDFMP', List ON $ (* Fmp routines *)     PROCEDURE load_segment  $ Alias 'Pas.SegmentLoad' $     (segment_name : prog_name);     EXTERNAL;     FUNCTION initialize_dbstr  $ Alias 'DBSTR.initialize' $    : Boolean;     EXTERNAL;      FUNCTION store_data  $ Alias 'DBSTR.StoreData' $    : boolean;     EXTERNAL;      FUNCTION verify_backup  $ Alias 'DBSTR.Verify' $    : boolean;     EXTERNAL;     PROCEDURE terminate_dbstr  $ Alias 'DBSTR.Terminate' $;     EXTERNAL;      PROCEDURE dbbuf; (* to insure that DBBUF goes in the main *)     EXTERNAL;     PROCEDURE make_pointer  $ Alias 'DBADR' $     (    to_point_to : short_int;     VAR set_ptr     : global_dataset_ctl_table_ptr_type);     EXTERNAL;  $ Page $ "(*******************************************************************) ""(*                     Pascal Error Catcher                        *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To catch pascal run-time errors and print out our own        *) ""(*    error message rather than a Pascal error message, to save    *) ""(*    space.                                                       *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE pascal_error_catcher  $ Alias 'Pas.ErrorCatcher' $;     BEGIN    report_error (catastrophic_utility_err);     GOTO 999;  END;  $ Page $ "(*******************************************************************) ""(*                     get_set_info_from_rootfile                  *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To create a pointer to the data set information given a      *) ""(*    particular data set number.                                  *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The data set number.                               *) ""(*    (out) (2) The pointer to the data set info.                  *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     !FUNCTION  get_set_info_from_rootfile  $ Alias 'DBSTR.GetSetInfo' $ !
   (    setnum : short_int; 
     VAR setptr : global_dataset_ctl_table_ptr_type) : boolean;      
LABEL 99; (* error exit *) 
    VAR 
   block  : long_int; 
    offset : short_int;     status : short_int;      BEGIN (* get_set_info_from_rootfile *)        (**)     (* It is assumed that the root file is open and the    (* header block already in memory.    (**)      $   get_set_info_from_rootfile := true;  (* assume an error will occur *) $       offset := root_header.set_off + ((setnum-one)*bm_set_len);         block  := (offset DIV words_in_disc_block) + one;     offset := offset MOD words_in_disc_block;         IF do_block_transfer (one, (* read *)                          root_file,                          block,                          2, (* block and block+1 *)                           root_buffer[one][zero],                          status) THEN BEGIN        report_error (status);        GOTO 99;        END;        make_pointer (root_buffer[one][offset], setptr);         get_set_info_from_rootfile := false; (* no error *)     
99:  (* error exit *) 
    END; (* get_set_info_from_rootfile *)  $ Page $ "(*******************************************************************) ""(*                    Main program of DBSTR                        *) ""(*******************************************************************) "     BEGIN (* main *)        dbbuf; (* Make sure DBBUF is in the main! *)     
   load_segment ('DBST1 '); 
       IF initialize_dbstr THEN GOTO 999;     
92:load_segment ('DBST2 '); 
       IF store_data THEN GOTO 999;     
91:load_segment ('DBST3 '); 
        IF verify_backup THEN GOTO 999;      999: (* termination label *)     
   load_segment ('DBST3 '); 
    	   terminate_dbstr; 	     END. (* end program DBSTR *) 