$PASCAL ',7,90 92081-1X053 REV.5000'$      $ Heap 0 $ $ Recursive OFF $ $ Range OFF $      $ Subprogram $         
PROGRAM dbstr_seg3_library; 
     (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18053                                        *)   (* RELOC:   92081-1X053                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (* Date last modified: <870414.1642>  (*                                                             *)   (***************************************************************)       (***************************************************************)   (*                                                             *)   (* This module contains functions and procedures used by DBSTR *)   (* in the segment DBST3, which verify the backup done by DBST2.*)   (*                                                             *)   (***************************************************************)   (**) %(*:nl:$ATB, mstor3, %st000, relocatable, 92081-16077 REV.2540 <870414.1642> %(*:nl:$  (*:nl:$LANGID, 0 (*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)  (**)  %(*:nl:$ '        SOURCE MESSAGE CATALOG                                  ' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '* (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984.  ALL RIGHTS      *' % %(*:nl:$ '* RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *' % %(*:nl:$ '* REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT *' % %(*:nl:$ '* THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        *' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '                                                                ' % %(*:nl:$ '                           SOURCE:   92081-18077                ' % %(*:nl:$ '         S. MESSAGE CATALOG NAME :   <ST000                     ' % %(*:nl:$ '                            RELOC:   92081-16077                ' % %(*:nl:$ '         B. MESSAGE CATALOG NAME :   %ST000                     ' % %(*:nl:$ '                            PGMR :   TH                         ' % %(*:nl:$ '         REV.2540 <870414.1642>                                 ' %(*:nl:$  (*:nl:$ '*NOTE*'  %(*:nl:$ 'All the messages in DBSTR must be within the number of chars_in ' % %(*:nl:$ 'long_str -1 (=127 bytes).                                       ' % (**)  $ Page $  (***************************************************************)   (*             Constants and types Declarations                *)   (***************************************************************)      $ List OFF, Include '[IMAGE', List ON $      $ List OFF, Include '[BACKUP_UTILS', List ON $     $ List OFF, Include '[STR_RST', List ON $     $ List OFF, Include '[DBSTR', List ON $          (***************************************************************)   (*                   External declarations                     *)   (***************************************************************)      $ List OFF, Include '[XSTOR', List ON $ $ List OFF, Include '[XBKP1', List ON $ $ List OFF, Include '[XTAPE', List ON $ $ List OFF, Include '[XDFMP', List ON $  $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #PROCEDURE MSTOR3; EXTERNAL;                                         FUNCTION fill_buffer  $ Alias 'FmpRead' $    (VAR dcb : dcb_type;      VAR err : short_int;     VAR buf : data_buffer_type;         max : short_int) : short_int;     EXTERNAL;      PROCEDURE set_position  $ Alias 'FmpSetPosition' $    (VAR dcb : dcb_type;      VAR err : short_int;         rec : long_int;          pos : long_int);     EXTERNAL;     FUNCTION compare_words  $ Alias 'DBCMW' $     (buffer1, buffer2 : data_buffer_type;      length_to_compare: short_int) : short_int;     EXTERNAL;     PROCEDURE param_return  $ Alias 'PRTN' $ (* system routine *)    (params : return_params_type);     EXTERNAL;     PROCEDURE io_control  $ Alias 'XLUEX' $     (control_request_code : short_int; (* constant 3 *)      function_and_tape    : xluex_control_word_type);     EXTERNAL;          $ Page $  (***************************************************************)   (*                         rewind_and_off_line                 *)   (***************************************************************)   (*                                                             *)   (* Purpose:                                                    *)   (*    Rewind the magtape storage and go off line.              *)   (*    Rewind the linus tape storage and unload.                *)   (*                                                             *)   (* Parameters: None, but globals are used.                     *)   (*                                                             *)   (***************************************************************)       PROCEDURE rewind_and_off_line $ Alias 'Bkp.RewindOffLine' $;     CONST    magtape_rewind_code = 320; (* 500 octal *)    linus_rewind_code = 192; (* 300 octal *)     VAR     xluex_parm : xluex_control_word_type;     BEGIN (* rewind_tape *)        xluex_parm.extended_lu := tape_file.tape_lu;            CASE tape_file.storage_kind OF       mag_tape  : BEGIN          xluex_parm.function_code := magtape_rewind_code;           io_control (3, xluex_parm);          END; (* case of magtape *)            linus_tape : BEGIN          xluex_parm.function_code := linus_rewind_code;           io_control (3, xluex_parm);          END;           OTHERWISE; (* do nothing *)     
      END; (* case *) 
     END; (* rewind_tape *)          $ Page $ "(*******************************************************************) ""(*                       set_backup_indicators                     *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To set the backup bits and timestamps in the root file       *) ""(*    after a backup operation has successfully completed.         *) ""(*                                                                 *) ""(* Parameters: None, but globals are used.                         *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION set_backup_indicators  $ Alias 'DBSTR.BackupInds' $    : boolean;     
LABEL 99;  (* error exit *) 
    VAR    status        : short_int;     BEGIN (* set_backup_indicators *)     !   set_backup_indicators := true;  (* assume an error will occur *) !        IF open_rootfile (root_file, status) THEN BEGIN        report_error (status);        GOTO 99;        END;     !   IF read_rootfile_hdr (root_file, root_header, status) THEN BEGIN !       report_error (status);        GOTO 99;        END;        WITH volume_header, root_header DO BEGIN       backup := tmstmp;       vol_num:= volume; 
      vol_xct:= xact; 
      vol_nam:= volnam;        logical_rlf_set_nam := setnam;           flags.mb := false; (* turn 'modified since backup' off *)        flags.mw := false; (* turn 'modified w/o rf logging' off *)  
      END; (* with *) 
     "   IF write_rootfile_hdr (root_file, root_header, status) THEN BEGIN "       report_error (status);        GOTO 99;        END;         IF close_file (root_file, status) THEN;        set_backup_indicators := false; (* no error *)     
99:  (* error exit *) 
     END; (* set_backup_indicators *)  $ Page $ "(*******************************************************************) ""(*                       verify_backup                             *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To verify the backup done by segment DBST2, to insure that   *) ""(*    the database was copied correctly to tape.                   *) ""(*                                                                 *) ""(* Parameters: None, but globals are used.                         *) ""(*                                                                 *) ""(* Function result is 'true' if an error occurs.                   *) ""(*                                                                 *) ""(*******************************************************************) "     FUNCTION verify_backup  $ Alias 'DBSTR.Verify' $    : boolean;      LABEL 77,88,99, (* error exit *)       8000,9000; (* NLS message test *) VAR  	   done : boolean; 	   error_message : short_str;     prompt_string : long_str;    files_to_verify : short_int;    i             : short_int;     numbufs, j    : long_int;        scratch_buffer : tape_buffer_type;        len, file_len : short_int;     status   : short_int;         length   : short_int;   (* NLreadRel actual read length *NLS*)      nlerr    : short_int;   (* NLreadRel error code  *NLS*)         next_file_found  : boolean;     file_header_read : boolean;         BEGIN (* verify_backup *)         verify_backup := true;  (* assume error will occur *)        IF NOT verify_option THEN BEGIN (* no verification wanted *)        IF close_tape_file_for_write THEN GOTO 99;        IF set_backup_indicators THEN GOTO 99;        verify_backup := false; (* no error *)        GOTO 99;        END;            (**)    (* 1) Read and verify the volume header.      (* 2) For each file header, open the file (type 1), then read      (*    each data block from the storage and compare it with the      (*    data from the database.    (**)        IF close_tape_file_for_write THEN GOTO 99;        IF volume_header.reel > one THEN BEGIN #(*    prompt_string := 'Please mount volume 1 for verification - _'; *) # "      (*:nl:#*1 1000 'Please mount volume 1 for verification - _' *) "      (*:nl:$COPY '8000: length := nlread (&, #' *)  8000: length := nlread (MSTOR3, 1000      "                         , nlerr, prompt_string, chars_in_long_str); " $      blank_pad (prompt_string, chars_in_long_str, length);    (* NLS *) $#      IF write_long_str (prompt_file, prompt_string, status) THEN BEGIN #9000:    report_error (status);          GOTO 99;          END;        IF check_ready THEN GOTO 99;        END;         volume_header.reel := zero; (* reset reel number *)        IF open_tape_file_for_read THEN GOTO 99;         "   files_to_verify := volume_header.sets + one; (* 1 for root file *) "        IF close_file (root_file, status) THEN GOTO 99;        done := false;    file_header_read := false;        FOR i := one TO files_to_verify DO BEGIN           IF NOT file_header_read          THEN IF read_file_header THEN GOTO 99;           WITH file_header DO BEGIN               set_dcb.newfl := set_id.setfil;      "         IF force_type_one_file_open (set_dcb, status) THEN GOTO 99; "              END; (* with *)               next_file_found := false;            WHILE NOT next_file_found DO BEGIN               IF read_data_buffer (len) THEN GOTO 99;               IF len = zero THEN GOTO 88; (* end of backup found *)               (* See if we just read a file header *) $         IF tape_buffer.data_header.ident = 'FILEHEAD2540    ' THEN BEGIN $             next_file_found := true;              file_header_read:= true;             file_header := tape_buffer.file_header;  
            GOTO 77; 
             END;               file_len := fill_buffer (set_dcb.dcb, status,                                   scratch_buffer.data_buffer,  #                                  tape_data_buffer_size*chars_in_word) #                         DIV chars_in_word;               IF compare_words (scratch_buffer.data_buffer,                            tape_buffer.data_buffer,                            file_len) <> zero THEN BEGIN             report_error (tape_verify_err);  
            GOTO 99; 
             END;      77:      (* when next file is found *)              END; (* while not next file found *)     88:   (* when end of backup is found *)           IF close_file (set_dcb, status) THEN GOTO 99;            END; (* for all files *)         IF close_tape_file_for_read THEN GOTO 99;        IF set_backup_indicators THEN GOTO 99;        rewind_and_off_line;        verify_backup := false; (* no error *)     
99:  (* error exit *) 
     END; (* verify_backup *)  $ Page $ "(*******************************************************************) ""(*                       terminate_dbstr                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To wrap up operations for DBSTR.                             *) ""(*                                                                 *) ""(* Parameters: None, but globals are used.                         *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE terminate_dbstr  $ Alias 'DBSTR.Terminate' $;     VAR    params : return_params_type;     i      : short_int;     
BEGIN (* terminate_dbstr *) 
       report_error (zero);         close_backup_files;        params[one] := last_error; 
   FOR i := 2 TO 5 DO 
       params[i] := zero;     !   param_return (params);  (* pass back some status to scheduler *) !     
END; (* terminate dbstr *) 
 .  