 $PASCAL ',7,90 92081-1X052 REV.2540'$       $ Heap 0 $  	$ Recursive OFF $  	 $ Range OFF $       $ Subprogram $      PROGRAM dbstr_seg2_library;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18052                                        *)  ! !(* RELOC:   92081-16052                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <851107.0922>  !(*                                                             *)  ! !(***************************************************************)  !     !(***************************************************************)  ! !(*                                                             *)  ! !(* This module contains functions and procedures used by DBSTR *)  ! !(* in the segment DBST2, which copy the database files to the  *)  ! !(* storage file/tape.                                          *)  ! !(*                                                             *)  ! !(***************************************************************)  ! $ Page $  !(***************************************************************)  ! !(*             Constants and types Declarations                *)  ! !(***************************************************************)  !     $ List OFF, Include '[IMAGE', List ON $       $ List OFF, Include '[BACKUP_UTILS', List ON $      $ List OFF, Include '[STR_RST', List ON $       $ List OFF, Include '[DBSTR', List ON $           !(***************************************************************)  ! !(*                   External declarations                     *)  ! !(***************************************************************)  !     $ List OFF, Include '[XSTOR', List ON $   $ List OFF, Include '[XBKP1', List ON $   $ List OFF, Include '[XDFMP', List ON $       FUNCTION fill_tape_buffer  $ Alias 'FmpRead' $     (VAR dcb : dcb_type;       VAR err : short_int;      VAR buf : data_buffer_type;           max : short_int) : short_int;      EXTERNAL;      PROCEDURE set_position  $ Alias 'FmpSetPosition' $     (VAR dcb : dcb_type;       VAR err : short_int;          rec : long_int;           pos : long_int);     EXTERNAL;      $ Page $  #(*******************************************************************)  # #(*                   Copy_file_to_storage                          *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To take an open file (either root or set) and copy it        *)  # #(*    to the storage file/tape.                                    *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in/out) (1) The file descriptor of the open file.           *)  # #(*                                                                 *)  # #(* Function result is 'true' if an error occurs.                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION copy_file_to_storage  $ Alias 'DBSTR.CopyToStor' $      (VAR file_dsc : file_descriptor) : boolean;      LABEL 99;  (* error exit *)       VAR      all_data_copied : boolean;      status, len     : short_int;           BEGIN (* copy_file_to_storage *)      !   copy_file_to_storage := true;  (* assume an error will occur *) !        all_data_copied := false;         (**)      (* Position the file at block 1.      (**)          set_position (file_dsc.dcb, status, one, -1);     IF status < zero THEN BEGIN        report_error (status);        GOTO 99;        END;         REPEAT (* until all data is copied *)            len := fill_tape_buffer (file_dsc.dcb, status,                                 tape_buffer.data_buffer,   "                               tape_data_buffer_size*chars_in_word); "           IF status = fmp_bof_eof_err THEN BEGIN           status := zero;           all_data_copied := true;            END        ELSE BEGIN           IF status < zero THEN BEGIN              report_error (status);  
            GOTO 99; 
             END;               len := len DIV chars_in_word;               IF write_data_buffer (len) THEN GOTO 99;                END; (* else *)            UNTIL all_data_copied;         copy_file_to_storage := false; (* no error *)      99:  (* error exit *)       END; (* copy_file_to_storage *)   $ Page $  #(*******************************************************************)  # #(*                      store_data                                 *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To copy the database files to the storage.  The files copied *)  # #(*    are the root file and data sets.                             *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    None.  Most data is in global variables.  See the include    *)  # #(*    files [Backup_Utils, [STR_RST and [DBSTR.                    *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE store_data   $ Alias 'DBSTR.StoreData' $;       
LABEL 99; (* error exit *) 
     VAR      set_ptr       : global_dataset_ctl_table_ptr_type;      loop, i       : short_int;      status        : short_int;           BEGIN (* store_data *)         (**)      (* Open the storage file/device.      (**)          IF open_tape_file_for_write THEN GOTO 99;         (**)      (* Set up the skeleton file_header variable.      (**)          WITH file_header DO BEGIN            ident := 'FILEHEAD2540';        (* setnam will be filled in later *)        filnum:= zero; (* incremented by write_tape_header *)   
      filler:= ' ';  
       (* entlen, filtyp and nument will be filled in later *)         END;         (**)      (* Write out the root file.     (**)          WITH file_header DO BEGIN        set_id.setfil := root_file.newfl;          nument := root_header.passw_block; (* number of blocks *)          entlen := words_in_disc_block;        END;         IF write_file_header THEN GOTO 99;          WITH tape_buffer.data_header DO BEGIN        ident := 'DATAHEAD2540    ';        set_id.setfil:= file_header.set_id.setfil;  
      filler:= ' ';  
       END;         IF copy_file_to_storage (root_file) THEN GOTO 99;             (**)      (* Now copy the data sets to tape.      (**)          FOR loop := one TO num_sets DO BEGIN             IF get_set_info_from_root (loop, set_ptr) THEN GOTO 99;             (**)  $      (* Fill in the specifics of the file header and write it to tape.  $       (**)            WITH file_header, set_ptr^ DO BEGIN            (* ident, filtyp, filled in earlier *)            set_id.setfil := set_name;            entlen := gdt.media_len + data_len;           nument := hash_val;           END; (* with *)            tape_buffer.data_header.set_id := file_header.set_id;             IF write_file_header THEN GOTO 99;            (**)        (* Open the data set and copy it to tape.         (**)            set_dcb.newfl := set_ptr^.set_name;             IF force_type_one_file_open (set_dcb, status) THEN BEGIN           report_error (status);   	         GOTO 99;  	          END;             IF copy_file_to_storage (set_dcb) THEN GOTO 99;             IF close_file (set_dcb, status) THEN;       
      END; (* for...if *)  
        (**)   "   (* To mark the end of the store, write out a zero-length record.  "    (**)          IF write_data_buffer (zero) THEN GOTO 99;             (**)      (* All data has been stored from the database:  Return.     (**)       99:  (* error exit *)       END; (* store_data *)   .  