 $PASCAL '92081-1X296 REV.2540' $  #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) # #(*                                                                  *) # #(* SOURCE:  92081-18296                                             *) # #(* RELOC:   92081-1X296                                             *) # #(*                                                                  *) # #(* PGMR: <EDB> <MRL>                                                *) # #(*                                                                  *) # (* Date of last modification: <851107.0915>   #(*                                                                  *) # #(********************************************************************) #     $ Heap 0 $  	$ Recursive OFF $  	 $ Subprogram  $   $ Range OFF $       
PROGRAM schedule_program;  
     #(********************************************************************) # #(*                                                                  *) # #(* This file contains several routines which perform operations on  *) # #(* strings of variable length, including upshifting lower case,     *) # #(* determining the length of significant characters in a string,    *) # #(* and a general purpose string handling routine for concatenating, *) # #(* truncating, and inserting strings.                               *) # #(*                                                                  *) # #(********************************************************************) #     #(********************************************************************) # #(*                      CONSTANTS and TYPES                         *) # #(********************************************************************) #     $ List OFF, Include '[IMAGE', List ON $       TYPE     rmpar_array_type = ARRAY [1..5] OF short_int;      $ List OFF, Include '[XDSMR', List ON $       FUNCTION make_runstr_hdr  $ Alias 'StrDsc' $  
   (runstring : long_str;  
     first, length : short_int) : f7x_str;      EXTERNAL;      FUNCTION make_prgrm_hdr  $ Alias 'StrDsc' $      (progname : long_str;      first, length : short_int) : f7x_str;      EXTERNAL;      FUNCTION fmp_run_program  $ Alias 'FmpRunProgram' $   
   (    runstr : f7x_str;  
     VAR rmpars : rmpar_array_type;      VAR prgnam : f7x_str) : short_int;     EXTERNAL;  $ Page $  #(*******************************************************************)  # #(*                     schedule_program                            *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To schedule a program and pass to it the RMPAR parameters.   *)  # #(*    The scheduling string can be anything, but must be           *)  # #(*    acceptable to FmpRunProgram.                                 *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) The scheduling string.                          *)  # #(*    (in/out) (2) RMPAR's passed to/received from program.        *)  # #(*                                                                 *)  # #(* Function result is 'true' if an error occurs, otherwise false.  *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION schedule_program  $ Alias 'Img.SchedProg' $     (    sched_string : long_str;      VAR rmpars       : rmpar_array_type) : Boolean;       VAR   
   num_string : short_str; 
 
   i          : short_int; 
    prgrm      : prog_name; (* name prog was scheduled as *)          run_hdr    : f7x_str;     prog_hdr   : f7x_str;  
   err        : short_int; 
     BEGIN (* schedule program *)         schedule_program := true;  (* Assume an error will occur *)         (* Set up string headers for FTN calls. *)   "   run_hdr := make_runstr_hdr (sched_string, 1, chars_in_long_str);  "    prog_hdr:= make_prgrm_hdr  (prgrm, 1, chars_in_prog_name);          (**)      (* We are passed a run string minus the parameters.     (* We will take each of the RMPAR parameters and append     (* their ascii equivalent to the run string.      (* FmpRunProgram passes them to the schedulee properly.     (**)          num_string := ' ';          FOR i := one TO 5 DO BEGIN         short_int_to_readable_short_str (rmpars[i], num_string);        append_str (sched_string, ',');         append_str (sched_string, num_string);      
      END; (* for *) 
            err := fmp_run_program (run_hdr, rmpars, prog_hdr);         IF (err = zero) THEN schedule_program := false;      END; (* schedule_program *)   .  