 $PASCAL ',3,90 92081-1X562 REV.5000' $ $Title 'DBRFR: Data Base Roll Forward Recovery Program' $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18562                                        *)   (* RELOC:   92081-16562                                        *)   (*                                                             *)   (* PGMR:        <STC> <TH>                                     *)   (*                                                             *)   (* Date last modified: <870415.1201>  (*                                                             *)   (***************************************************************)       $EMA '0,5' $ $Heap 2 $  $Recursive off $  $Range off $     PROGRAM DBRFR; (* Database roll forward recovery *)      (**)  %(*:nl:$ '        SOURCE MESSAGE CATALOG                                  ' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '* (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984.  ALL RIGHTS      *' % %(*:nl:$ '* RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *' % %(*:nl:$ '* REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT *' % %(*:nl:$ '* THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        *' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '                                                                ' % %(*:nl:$ '                           SOURCE:   92081-18075                ' % %(*:nl:$ '         S. MESSAGE CATALOG NAME :   <RF000                     ' % %(*:nl:$ '                            RELOC:   92081-16075                ' % %(*:nl:$ '         B. MESSAGE CATALOG NAME :   %RF000                     ' % %(*:nl:$ '                            PGMR :   TH                         ' % %(*:nl:$ '         REV.5000 <870415.1201>                                 ' %(*:nl:$  (*:nl:$ '*NOTE*'  %(*:nl:$ 'All the messages in DBRFR must be within the number of chars_in ' % %(*:nl:$ 'long_str -1 (=127 bytes).                                       ' % %(*:nl:$ 'There are some messages which are appended to another string.   ' % %(*:nl:$ 'In those case the messages in this source message cataloge      ' % %(*:nl:$ 'should be within 127 - string length.                           ' %(*:nl:$ (*:nl:$LANGID 0 (*:nl:$ (*:nl:$  (**)      (**) %(*:nl:$ATB, mfr_mn, %rf000, relocatable, 92081-16075 REV.5000 <870415.1201> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      LABEL 999,       9999,         10,11,12,13,14,15,16,17,18,19,20;  (* NLS message tests *)       (***************************************************************)   (* Constants and types                                         *)   (***************************************************************)               $ List OFF $ $ Include '[IMAGE' $    (* General IMAGE defn's.   *)       $ Include '[BMCCT' $   (* DBMON workhorse constants and types *)  $ Include '[DBRFR' $   (* DBRFR constants,types and vars *)  $ Include '[RFSG' $   (* Segment name defns *) $ List ON $     $ Include '[NLRFR' $   (* NLS constants and vars *)      $ page $  (**) (* External declaractions  (**)     PROCEDURE load_segment  $ Alias 'Pas.SegmentLoad' $     (segment_name : Prog_name);     EXTERNAL; $ Heapparms off $      PROCEDURE convert_shortint_to_ascii $ alias 'CITA' $ 
   (     value : short_int; 
    VAR  result_str : short_str);     EXTERNAL;     FUNCTION make_log_rec_word_ptr  $ alias 'EMA.ADDRTOPTR' $  $ heapparms on $     ( VAR  addr  : short_int;      VAR ptr    : ptr_log_record_header_type; $ Heapparms off $       VAR status : short_int) :    BOOLEAN;     EXTERNAL;      FUNCTION do_redo_block_transfer  $ alias 'Img.BlockIO' $      (    code             : short_int;       VAR file_description : file_descriptor;          block_num        : long_int;           num_blocks       : short_int;      VAR buffer           : redo_list_block_type;      VAR return_status    : short_int) : BOOLEAN;     EXTERNAL;      $ List OFF $      
$ Include '[XDFMP' $ 
 
$ Include '[XDCIO' $ 
$ Include '[XDSMR' $     (* string manipulation*) $ Include '[XWRTF' $     (* access root file *)  $ Include '[XUROC' $     (* re-open externals *)  $ Include '[XWPTS' $     (* make pointers *)  $ include '[XRFL1' $     (* externals to the RF library *) $ include '[XDNLS' $     (* externals to the NLS library *)     $ List ON $         (*:nl:$COPY 'PROCEDURE &; EXTERNAL;' *) PROCEDURE MFR_MN; EXTERNAL;         $ Heapparms OFF $     (* Initialize DBRFR variables and I/O. *)     PROCEDURE initialize;  $ Alias 'RFR.Initialize' $     EXTERNAL;      #PROCEDURE determine_recov_start_vol;  $ alias 'RFR.DetRecovStartVol' $ #    EXTERNAL;     $ Heapparms OFF $     (* Process the database list *)       PROCEDURE process_database_list;   $ Alias 'RFR.ProcessDBList' $      EXTERNAL;     $ Heapparms OFF $      (* Determine the start rfr volume *)      PROCEDURE determine_recov_set;     $ alias 'RFR.DetRecovSet' $     EXTERNAL;         $ Heapparms OFF $     (* If user is to enter volumes, process them *)      PROCEDURE process_volume_list;     $ alias 'RFR.ProcVolumeList' $      EXTERNAL;     $ Heapparms OFF $      PROCEDURE determine_redo_list;     $ alias 'RFR.DetRedoList' $     EXTERNAL;          FUNCTION redo_delete  $ alias 'RFR.RedoDelete' $    (VAR log_ptr : ptr_log_record_header_type;         abort_flag : boolean;    VAR workhorse : workhorse_info_type;     VAR return_status : short_int) : BOOLEAN;     EXTERNAL;         $ Heapparms OFF $         FUNCTION redo_update $ alias 'RFR.RedoUpdate' $    (VAR log_ptr : ptr_log_record_header_type;         abort_flag : boolean;         undo_update: boolean;     VAR workhorse_data : workhorse_info_type;     VAR return_status : short_int) : BOOLEAN;     EXTERNAL;         $ Heapparms OFF $         FUNCTION redo_put   $ alias 'RFR.RedoPut' $    (VAR log_ptr : ptr_log_record_header_type;         abort_flag : boolean;     VAR workhorse : workhorse_info_type;      VAR return_status : short_int) : BOOLEAN;     EXTERNAL;      	$ Heapparms OFF $  	         FUNCTION redo_close $ alias 'RFR.RedoClose' $      (VAR log_ptr : ptr_log_record_header_type;          abort_flag : boolean;    VAR workhorse : workhorse_info_type;     VAR return_status : short_int) : BOOLEAN;     EXTERNAL;         FUNCTION post_buffers $ alias 'RFR.PostBuffers' $    (VAR workhorse_data : workhorse_info_type;     VAR return_status : short_int) : BOOLEAN;     EXTERNAL;     PROCEDURE database_open  $ alias 'RFR.DatabaseOpen' $     ( VAR tbl_ix : short_int;  $ heapparms on $      VAR db_desc : new_file_name; $ heapparms off $       VAR return_status : short_int);     EXTERNAL;         $ Heapparms OFF $          FUNCTION log_record_display $ alias 'RFR.LogRecDisplay' $      (VAR log_rec_ptr : ptr_log_record_header_type;      VAR display_descriptor : file_descriptor;     VAR return_status : short_int) : boolean;     EXTERNAL;      PROCEDURE display_timestamps  $ alias 'RFR.DispTime' $ ;     EXTERNAL;         $ Heapparms OFF $          PROCEDURE get_volume $ alias 'RFR.GetVolume' $  
  (    vol_ix : short_int; 
       subvol_ix : short_int;     VAR history_entry : history_table_entry_type;     VAR cur_rfl_descriptor : file_descriptor;     VAR return_status : short_int);     EXTERNAL;     $ heapparms OFF $     PROCEDURE chunk_reader  $ alias 'RFR.ChunkReader' $     ( VAR return_status : short_int);     EXTERNAL;         $ Heapparms OFF $      PROCEDURE display_error $ alias 'RFR.DisplayError' $     ( VAR log_file1  : file_descriptor;       VAR log_file2  : file_descriptor;          error_code : short_int);     EXTERNAL;      $ Page $ "(*******************************************************************) ""(*                                                                 *) ""(* The following dummy procedures are to prevent DBRFR from being  *) ""(* loaded with the before-imaging subroutines (which take up a     *) ""(* large amount of memory).   Because DBRFR is itself, not         *) ""(* recoverable, there is no need for before-images.  (Just         *) ""(* start the roll-forward recovery process over again).            *) ""(*                                                                 *) ""(*******************************************************************) "        $ Heapparms OFF $      (**** Flush the Before-image file. ****)      FUNCTION  Flush_BI_buf  $ Alias 'DBW.FlushBib' $    (VAR workhorse_data : Workhorse_info_type;      VAR error          : short_int) : Boolean;     BEGIN flush_bi_buf := false; END;          (**** Prepare the next entry in the Before-image buffer. ****)      FUNCTION Get_next_BI_entry   $ Alias 'DBW.GetBibEntry' $    (VAR entry          : Short_int;     VAR workhorse_data : Workhorse_info_type;      VAR error          : Short_int) : Boolean;      BEGIN get_next_bi_entry := false; END;             !(**** Make before-images of datablocks referenced by REC_MAP. ****) !    FUNCTION Copy_rec_map_blocks   $ Alias 'DBW.CopyRecord' $    (VAR workhorse_data : Workhorse_info_type;      VAR error          : Short_int) : Boolean;      BEGIN copy_rec_map_blocks := false; END;          (* All parms on dummy routines are VAR'ed to save space *)     (**** Copy data into the before-image buffer. ****)      FUNCTION Copy_before_image  $ Alias 'DBW.MakeBImage' $              (VAR data_ptr    : Data_record_ptr_type;              VAR blocks      : Short_int;               VAR start_block : Long_int;               VAR type_of_file: image_file_types;  $ Heapparms ON $              VAR filename    : new_file_name; $ Heapparms OFF $              VAR workhorse   : Workhorse_info_type;               VAR error       : Short_int) : Boolean;      BEGIN copy_before_image := false; END;              !(**** See if the intrinsic can fit in the before-image file. ****) !     FUNCTION before_image_file_check  $ Alias 'DBW.CheckBifFull' $    (VAR intrinsic_code : Short_int;     VAR dataset_ptr    : Global_dataset_ctl_table_ptr_type;     VAR workhorse_data : Workhorse_info_type;      VAR error          : Short_int) : Boolean;      BEGIN before_image_file_check := false; END;              (**** Make a before-image copy of the Free Record Table. ****)      FUNCTION copy_free_record_table  $ Alias 'DBW.CopyFRecTbl' $    (VAR Dbase_num    : Short_int;     VAR workhorse    : Workhorse_info_type;      VAR error        : Short_int) : Boolean;     LABEL 99;     VAR     rtbl_header_ptr : Rootfile_header_ptr_type;     BEGIN  (* Copy_free_record_table *)      WITH workhorse_data DO BEGIN         Copy_free_record_table := true; (* Assume error will occur. *)          IF make_rt_header_ptr (dbase_num,                            rtbl_header_ptr,                           workhorse_data,                            error) 	      THEN GOTO 99; 	    $   rtbl_header_ptr^.flags.FT := true;      (* Flush FRT at checkpoint. *) $        copy_free_record_table := false;  (* No error! *)      END; (* with workhorse_data *)     
99:  (* Error exit *) 
    END; (* Copy_free_record_table *)              !(**** Place an 'end of intrinsic' mark in before-image file. ****) !     FUNCTION Mark_end_of_intrinsic  $ Alias 'DBW.MarkEOIntrin' $    (VAR workhorse_data : Workhorse_info_type;      VAR error          : Short_int) : Boolean;      BEGIN mark_end_of_intrinsic := false; END;      (**********************************************************)  (*     External definition of the DBRFR error printer.    *)  (**********************************************************)      PROCEDURE print_runtime_error   $ Alias 'RFR.ErrorPrinter' $             (VAR err_type : error_type;               VAR err_num  : Short_int;               VAR err_line : Short_int;               VAR err_file : err_file_name;              VAR err_flen : Short_int);     EXTERNAL;          PROCEDURE prtn    (prtn_array : rmpar_array_type);     EXTERNAL;          $ page $     PROCEDURE fatal_error        $ alias 'RFR.fatalerror' $     ( error : short_int);     VAR    return_status : short_int;     BEGIN         IF error <> zero THEN BEGIN           prtn_array[one] := error; (* return error to DBUTL *)            write_blank_line (          one, 
         input_descriptor); 
          load_segment (dbrfr_display_error_segment);        IF log_descriptor.newfl = ' ' THEN           display_error (             input_descriptor,             input_descriptor,  	            error) 	       ELSE           display_error ( 
            log_descriptor, 
            input_descriptor, 	            error); 	          (* close files *)       IF close_file (input_descriptor, return_status) THEN;        IF close_file (list_descriptor, return_status) THEN;       IF close_file (log_descriptor, return_status) THEN;       IF close_file (dbcon_descriptor, return_status) THEN;  "      IF close_file (redo_list_file_descriptor, return_status) THEN; "          (* purge the redo scratch file *)  "      IF purge_file (redo_list_file_descriptor, return_status) THEN; "           END;     
   prtn (prtn_array); 
       GOTO 9999;   (* terminate *)      END;  $ PAGE $  (**********************************************************)  (*                                                        *)  (* Purpose:                                               *)  (*    To capture PASCAL runtime errors and produce a      *)  (*    meaningful error for IMAGE users.  (Having the      *)  (*    standard PASCAL error message pop up on the         *)  (*    system console would not be informative or          *)  (*    helpful.                                            *)  (*                                                        *)  (* NOTE: The error catcher must be 'Pas.ErrorCatcher'.    *)  (*                                                        *)  (**********************************************************)      PROCEDURE catch_runtime_error   $ Alias 'Pas.ErrorCatcher' $              (VAR err_type : error_type;                VAR err_num  : Short_int;               VAR err_line : Short_int;               VAR err_file : err_file_name;               VAR err_flen : Short_int);       BEGIN  (* catch runtime error *)         load_segment (dbrfr_misc_segment );      #   print_runtime_error (err_type,err_num,err_line,err_file,err_flen);  #     
   fatal_error (err_num);  
     END; (* catch runtime error *)      $ page $     (*************************************************************) (*                                                           *) (* Procedure handle_redo_error                               *) (*                                                           *) (* This routine outputs an IMAGE error message to the list   *) (* and log.  It also print the log record which caused the   *) (* error (log only).  If the user has specified the option   *) (* 'AB', then we call fatal_error and terminate.  Otherwise  *) (* the user has specified the option 'CO', in which case     *) (* we return to the caller.                                  *) (*                                                           *) (* NOTE : This routine cannot be called from a segment       *) (*        since it does a segment load.                      *) (*                                                           *) (*************************************************************)      PROCEDURE handle_redo_error      $ alias 'RFR.RedoError' $ 
   ( VAR error : short_int; 
 $ heapparms on $      VAR log_rec_ptr : ptr_log_record_header_type); $ heapparms off $     LABEL        10,11;   (* NLS message tests *)     	$ include '[RFSG' $ 	        VAR    return_status : short_int;     BEGIN        (* print log record *) 
   write_blank_line ( 
       one,        log_descriptor);  (* temp_long_str := ' LOG RECORD FOR INTRINSIC WITH ERROR : '; *)     (*:nl:#*1 1000  ' LOG RECORD FOR INTRINSIC WITH ERROR : ' *)      
10:  (* NLS tests *) 
     %   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *) % !   length := nlread (MFR_MN, 1000, nlerr, temp_long_str, len);     !    blank_pad (temp_long_str, chars_in_long_str, length);     IF write_long_str ( 
      log_descriptor, 
 
      temp_long_str, 
 
      return_status) THEN; 
     
11:  (* NLS tests *) 
       load_segment (dbrfr_misc_segment);  
   IF log_record_display ( 
 	      log_rec_ptr, 	
      log_descriptor, 
 
      return_status) THEN; 
   write_blank_line ( 
       one,        log_descriptor);            IF abort_on_error THEN       fatal_error (error)         ELSE  BEGIN   (* continue but report error *)           load_segment (dbrfr_display_error_segment); 
      display_error ( 
          log_descriptor,  
         input_descriptor, 
          error);            END;  (* else *)      END;  $ page $  (**)  (* dummy routine to satisfy externals needed by routines (* shared between dbrfr and dbrbr although rfr won't ever  (* execute it.  (**)      FUNCTION check_point (     VAR workhorse_data : workhorse_info_type;    VAR status : short_int) : BOOLEAN;     BEGIN     check_point := false;  END;  $ page $   (**************************************************************)    (*                                                            *)    (* FUNCTION in_redo_list                                      *)    (*                                                            *)    (* Purpose : This function returns the value true if          *)    (* the transaction must be redone, false otherwise.  It       *)    (* determines this fact by looking in the redo_list (         *)    (* which determines if the transaction is a completed one)    *)    (* and looking in the start_table to see if the transaction   *)    (* is greater than the start transaction for the              *)    (* particular database.  The index into the start table is    *)    (* determined as follows :                                    *)    (*                                                            *)    (* (1) database list not provided by user -                   *)    (*     The index into the start table is the system           *)    (*     database number at the time the operation occurred.    *)    (*     We get this from the log record sysdb_num              *)    (*     (which is passed to us)  field which contains the      *)    (*     system database number.                                *)    (*                                                            *)    (* (2) database list provided by user -                       *)    (*     We must look through the open database table for a     *)    (*     name match in order to identify the database.          *)    (*     This is obviously slower than (1) but is necessary     *)    (*     because all we have is a database name.  Generally     *)    (*     we won't have a very long list to look through         *)    (*     because users won't be giving us many names.           *)    (*                                                            *)    (**************************************************************)      FUNCTION in_redo_list  $ alias 'RFR.InRedoList' $  $ heapparms on $    (VAR trans_num : long_int; $ heapparms off $     VAR db_name_id : new_file_name;    VAR sysdb_num  : short_int) : Boolean;     LABEL 99;     CONST    bits_in_redo_block = words_in_redo_block * bits_in_word;     VAR     desired_block : long_int;  
   desired_ix : short_int; 
	   diff : long_int; 		   found : boolean; 	    tbl_ix : short_int;    temp_filename : new_file_name;     BEGIN        IF NOT (db_list_provided) THEN       tbl_ix := sysdb_num    ELSE BEGIN            (* look through open database table *) 
      found := false; 
 
      tbl_ix := one; 
       WHILE (tbl_ix <= db_list_count) AND NOT (found) DO BEGIN &         temp_filename := workhorse_data.opn_tbl_ptr^[tbl_ix].root_file_name; &          IF db_name_id = temp_filename              THEN found := true             ELSE tbl_ix := succ (tbl_ix);          END;       IF NOT (found) THEN BEGIN          in_redo_list := false;          GOTO 99;          END;        END;  (* else *)        (* Is the transaction number greater than the start one *)    (* (the start one is the one at backup time *)  "   IF trans_num > start_vol_id_tbl[tbl_ix].xaction_number THEN BEGIN "           (* yes it is *)         (* Is this transaction in the redo list? *)             diff := trans_num - start_recov_xaction_num;        desired_block := diff DIV bits_in_redo_block + one;         desired_ix := diff MOD bits_in_redo_block + one;            IF desired_block <> cur_redo_block_num THEN BEGIN            IF do_redo_block_transfer (              read_code,              redo_list_file_descriptor,  
            desired_block, 
             one,  (* number of blocks *)              redo_list_block,             return_status) THEN              fatal_error (rfr_scratch_file_access_err);          cur_redo_block_num := desired_block;          END;            (* return function value from redo_list_block *)        IF (desired_ix < one) THEN          fatal_error (corrupt_rfl_err);        in_redo_list := redo_list_block[desired_ix];       END    ELSE        in_redo_list := false;     99:      END;  (* fctn *)  $ page $  !(****************************************************************) ! !(*                                                              *) ! !(* Procedure add_to_start_table                                 *) ! !(*                                                              *) ! !(* Purpose : This procedure adds an entry to the start_table    *) ! !(* which indicates which databases are to be recoverd and       *) ! !(* what transaction number and volume to begin for that         *) ! !(* database.  This procedure also checks that the set           *) ! !(* name stored in the root file matches that of the set         *) ! !(* we are recovering.                                           *) ! !(*                                                              *) ! !(* This assumes we are the given the file desc for the data     *) ! !(* base  ( assumed open already), the internal database number  *) ! !(* (which we store into the start table ) and the index into    *) ! !(* the start table for this database.                           *) ! !(*                                                              *) ! !(****************************************************************) !    PROCEDURE add_to_start_table    $ alias 'RFR.AddToStartTable' $  $ heapparms on $    ( VAR db_desc : new_file_name; $ heapparms off $       VAR db_num : short_int;      VAR tbl_ix : short_int);     LABEL     10,11;  (* NLS message tests *)     VAR     rt_header : rootfile_header_ptr_type;    database_name_str : short_str;         BEGIN         (* remember to update the 'db_list_count' variable *)    db_list_count := succ (db_list_count);         (* read the header *)    IF root_read (       db_num, 
      workhorse_data, 
      return_status) THEN        fatal_error (return_status);        (* create a pointer to it *)  
   IF make_rt_header_ptr ( 
      db_num,        rt_header,        workhorse_data,   
      return_status) THEN  
       fatal_error (return_status);         (* look at the rootfile hdr *)      IF (tbl_ix < one) OR (tbl_ix > max_IMAGE_db) THEN        fatal_error (corrupt_rfl_err);    WITH rt_header^, start_vol_id_tbl[tbl_ix] DO BEGIN            (**)       (* If the set name in the database does not match        (* the one we're recovering, ignore this db.        (* (blank set name is acceptable - this means that        (* the db was just created (DBDS).        (**)            IF (logical_rlf_set_nam <> recov_set_name) AND            (logical_rlf_set_nam <> '                ')  THEN BEGIN               (* database backed up under a different set *)              (* output message *) (*       temp_long_str :=               ' BACKUP TIMESTAMP REFLECTS A DIFFERENT SET :  '; *)           (*:nl:$ ' ' *) #         (*:nl:$ ' Max. 16 bytes string is appended to this message' *) #%         (*:nl:#*1 1001 ' BACKUP TIMESTAMP REFLECTS A DIFFERENT SET :  ' *) %     
10:  (* NLS tests *) 
     !         (*:nl:$COPY '         length := nlread (&, #, nlerr, ' *) !          length := nlread (MFR_MN, 1001, nlerr,                                               temp_long_str, len);           blank_pad (temp_long_str, chars_in_long_str, length);              positional_append_str ( temp_long_str,                                  logical_rlf_set_nam,                                   chars_in_short_str,                                   length);  (* char position *)           IF input_log_write_long_str (  
            temp_long_str, 
            return_status) THEN              fatal_error (return_status);      
11:  (* NLS tests *) 
               (* close the database *)  
          IF recls_unopn ( 
             db_desc, 
              workhorse_data,               return_status) THEN              fatal_error (return_status);          db_list_count := pred (db_list_count);               END 	         ELSE BEGIN 	             (**)             (* Save the internal database number, the start             (* volume, and xaction number for the db.              (**)              rf_db_num := db_num;              vol_number := vol_num;              xaction_number := vol_xct;              END;  (* else *)            END;  (* with *)      END;  (* proc *)  $ page $   (**************************************************************)    (*                                                            *)    (* Procedure perform_redo                                     *)    (*                                                            *)    (* Purpose : To perform redo's of all transactions in the     *)    (* redo_list whose log records appear on the current volume.  *)    (*                                                            *)    (*                                                            *)    (**************************************************************)       PROCEDURE perform_redo_operations;   $ alias 'RFR.PerfRedoOper' $      LABEL     10,11,12,13,14,15,16,99;  (* NLS message tests *)     VAR     vol_ix : short_int;    subvol_ix : short_int;  
   subvol_num : short_int; 
    num_subvolumes : short_int;     history_entry : history_table_entry_type;    return_status : short_int;    end_of_volume : boolean;  (* flag *)  
   end_of_chunk : boolean; 
    log_rec_ptr : ptr_log_record_header_type;     buf_word : short_int;  
   redone : boolean; 
    tbl_ix : short_int; 
   db_name : new_file_name; 
    first_time : boolean;         system_dbnum : short_int;      (**) (* uses globals  (*      cur_rfl_descriptor : file_descriptor  (**)         BEGIN        (**) 	   (* write message 	   (**)     first_time := true; 
   write_blank_line ( 
       2,        input_descriptor); (* temp_long_str := ' *** BEGINNING PASS TWO *** ' ; *)    (*:nl:#*1 1002 ' *** BEGINNING PASS TWO *** ' *)      
10:  (* NLS tests *) 
     %   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *) % !   length := nlread (MFR_MN, 1002, nlerr, temp_long_str, len);     !    blank_pad (temp_long_str, chars_in_long_str, length);     IF input_log_write_long_str (  
      temp_long_str, 
      return_status) THEN        fatal_error (return_status);      
11:  (* NLS tests *) 
       cur_chunk_seq_num := zero;        (**)    (* Loop to read roll forward log volumes  %   (*   start_recov_vol_ix is the start index into the dbcon history table %    (**)          FOR vol_ix := start_recov_vol_ix to  $                 (num_recov_volumes + start_recov_vol_ix - one) DO BEGIN $           (* read the history table entry for it from dbcon *)        IF volume_list_flag = cur_dbcon THEN  BEGIN            IF read_history_table_entry (              dbcon_descriptor,               do_not_lock_dbcon_file,   
            vol_ix,  
 
            history_entry, 
             return_status) THEN               fatal_error (return_status)            END  (* if *)            ELSE           IF read_history_table_entry (             old_dbcon_descriptor,             do_not_lock_dbcon_file, 	            vol_ix, 	 
            history_entry, 
            return_status) THEN              fatal_error (return_status);            IF history_entry.used_volume_flag = false THEN BEGIN               (* skip this volume since it is not being used *)           num_subvolumes := -1; (*       temp_long_str := $            ' HISTORY TABLE INDICATES VOLUME WAS NOT USED - VOLUME: '; *) $         (*:nl:$ ' ' *) #         (*:nl:$ ' Max. 16 bytes string is appended to this message' *) # #         (*:nl:#*1 1003 ' HISTORY TABLE INDICATES VOLUME WAS NOT &' *) #         (*:nl:#        'USED - VOLUME:  ' *)      
12:  (* NLS tests *) 
     !         (*:nl:$COPY '         length := nlread (&, #, nlerr, ' *) !          length := nlread (MFR_MN, 1003, nlerr,                                     temp_long_str, len);           blank_pad (temp_long_str, chars_in_long_str, length);          positional_append_str(  
            temp_long_str, 
            history_entry.logical_name,             chars_in_short_str,  
            length); 

         write_blank_line ( 
             one,              input_descriptor);           IF write_long_str (             input_descriptor,  
            temp_long_str, 
            return_status) THEN              fatal_error (return_status);      
13:  (* NLS tests *) 
              END        ELSE           num_subvolumes := history_entry.num_subvolumes;                FOR subvol_ix := zero to num_subvolumes DO BEGIN            subvol_num := subvol_ix;        load_segment (dbrfr_misc_segment);       get_volume (vol_ix,                   subvol_num,                    history_entry,                   cur_rfl_descriptor,  (* returned *)                   return_status);        (* if get_next_volume encounters error, it exits program *)             (**)  !      (* Now loop through this volume and determine if intrinsics  !       (* need to be redone, depending on 'REDO_LIST'.         (**)           end_of_volume := false;            (* read chunks until we hit the end of the volume *)           WHILE not (end_of_volume)  DO BEGIN           return_status := ignore_this_chunk;          load_segment (dbrfr_misc_segment);          WHILE (return_status = ignore_this_chunk) DO "            chunk_reader (return_status); (* in dbrfr_misc_segment *) "         IF return_status = rfl_parity_err THEN BEGIN              end_of_volume := true; #            num_subvolumes := zero;  (* exit from the subvolume loop *) ##                                     (* and volume loop              *) #!            num_recov_volumes := vol_ix - start_recov_vol_ix + one; ! (*          temp_long_str :=  %               ' *** WARNING! PARITY ERROR. RECOVERY TERMINATED. *** '; *) % %(*:nl:#*1 1004 ' *** WARNING~! PARITY ERROR. RECOVERY TERMINATED. *** ' *) %     
14:  (* NLS tests *) 
    #            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *) #             length := nlread (MFR_MN, 1004, nlerr,                                                   temp_long_str, len);               blank_pad (temp_long_str, chars_in_long_str, length);              IF input_log_write_long_str (                temp_long_str,                 return_status) THEN                fatal_error (return_status);             return_status := bof_eof_err;      
15:  (* NLS tests *) 
                 END;           (* signal that we are done with the volume *)           IF return_status = bof_eof_err THEN             end_of_volume := true 	         ELSE BEGIN 	                 (* ready for next chunk in current buffer *)              end_of_chunk := false;             buf_word := $               (cur_chunk_buf_blk_num - one) * words_in_disc_block + one; $                (* read log records until end of chunk *)             WHILE not (end_of_chunk) DO BEGIN                     IF make_log_rec_word_ptr (                    rfr_buf_ptr^.wds[buf_word],                    log_rec_ptr,                   return_status) THEN                    fatal_error (return_status);                    redone := false;                WITH log_rec_ptr^ DO BEGIN                  CASE rec_type OF                          (**)                      (*  NOTE - all references to sysdb_num  #                     (*  mean that it is a field within the log record #"                     (*  which contains the system database number at " #                     (*  the time the operation occurred.  This number #                      (*  now serves to index into the start table  #                     (*  as a means to identify an entry into the start #                      (*  table with a database, quickly.                      (**)                           dbdel_log_code:  
                     BEGIN 
                        (* determine if in redo list *)                          WITH delete DO BEGIN                            db_name := db_name_id;                            system_dbnum := sysdb_num;                            END;                          IF in_redo_list (delete.trans_num,                                          db_name, system_dbnum)                          THEN BEGIN                              load_segment (dbrfr_del_upd_segment);                             IF redo_delete (                                log_rec_ptr,                                NOT(abort_on_error),                               workhorse_data,                               return_status) THEN                               handle_redo_error (Return_status,                                                  log_rec_ptr)                            ELSE BEGIN                               redone := true;                                IF first_time THEN BEGIN                                   first_timestamp := timestamp;                                  first_time := false;                                  END;                                last_timestamp := timestamp;                                 END;   (* else no error redoing *)                              END;  (* if in redo list *)                          END;  (* dbdel case *)                              dbput_log_code : BEGIN                         WITH put DO BEGIN                            db_name := db_name_id;                            system_dbnum := sysdb_num;                            END;                             IF in_redo_list (put.trans_num,                                           db_name,system_dbnum)                          THEN BEGIN  #                           load_segment (dbrfr_put_opn_close_segment); #                           IF redo_put    (                                log_rec_ptr,                                NOT(abort_on_error),                               workhorse_data,                               return_status) THEN                               handle_redo_error (Return_status,                                                  log_rec_ptr)                            ELSE BEGIN                               redone := true;                                IF first_time THEN BEGIN                                   first_timestamp := timestamp;                                  first_time := false;                                  END;                                last_timestamp := timestamp;                               END;  (* else no error *)                             END;      (* if in redo list *)                          END;  (* dbput case *)                          dbupd_log_code : BEGIN                              WITH update DO BEGIN                            db_name := db_name_id;                            system_dbnum := sysdb_num;                            END;                              IF in_redo_list (update.trans_num,                                          db_name, system_dbnum)                          THEN BEGIN                              load_segment (dbrfr_del_upd_segment);                             IF redo_update (                                log_rec_ptr,                                NOT(abort_on_error),                                false, (* redo the update *)                               workhorse_data,                               return_status) THEN                               handle_redo_error (Return_status,                                                  log_rec_ptr)                            ELSE BEGIN                               redone := true;                                IF first_time THEN BEGIN                                   first_timestamp := timestamp;                                  first_time := false;                                  END;                                last_timestamp := timestamp;                                END;  (* else no error *)                             END;   (* if in redo list *)                         END;   (* dbupd case *)                          dbopn_log_code :  
                     BEGIN 
                         (**)                         (* Perform database opens.  This call                         (* may also cause a database to                          (* be closed if an entry is occupying the                            (* start table entry where this database                            (* indexes into. The index is the system                          (* database number at the time of the                         (* original open.                          (**)                             tbl_ix := open.sysdb_num;                          IF NOT (db_list_provided) THEN BEGIN #                           load_segment (dbrfr_initialization_segment); #                            database_open (                               tbl_ix,                                open.db_name_id,                               return_status);                            END;                      END;                                chunk_tail_log_code : end_of_chunk := true;                            otherwise  (* do nothing *)                               END;  (* case *)       
                     (**)  
 $                     (* Display the log record if detailed stats desired $ #                     (* and if the log record belongs to a transaction #                      (* we've redone.   
                     (**)  
     "                     IF (detail_statistics) and (redone) THEN BEGIN  "                         CASE rec_type OF                                 dbbeg_log_code,                             dbdel_log_code,                             dbend_log_code,                             dbmem_log_code,                             dbput_log_code,                             dbupd_log_code :                                  BEGIN  !                              load_segment (dbrfr_misc_segment);   !                               IF log_record_display (                                 log_rec_ptr,                                list_descriptor,                                return_status) THEN                                    fatal_error (return_status);                              END;                                  otherwise  (* do nothing *)                             END;  (* case *)                               END; (* if detail stats *)                           buf_word := buf_word + rec_len1;                           END;  (* with *)                    END;  (* while not end of chunk *)                  END;  (* else *)      
         END;  (* while *) 
       END;  (* for subvolumes *)        END;  (* for  volumes *)            write_blank_line (          one, 
         input_descriptor); 
 (*    temp_long_str := ' *** PASS TWO COMPLETE *** '; *)       (*:nl:#*1 1005 ' *** PASS TWO COMPLETE *** ' *)      
16:  (* NLS tests *) 
           (*:nl:$COPY '      length := nlread (&, #, nlerr, ' *)       length := nlread (MFR_MN, 1005, nlerr,                               temp_long_str, len);       blank_pad (temp_long_str, chars_in_long_str, length);       IF input_log_write_long_str (          temp_long_str,           return_status) THEN          fatal_error (return_status);      
99:  (* NLS tests *) 
END;  (* proc perform_redo *)          $ page $ (*************************************************************) (* MAIN                                                      *) (*************************************************************)     BEGIN            (* NOTE: Initialization code was moved to segment RFR.2 *)    (* due to size increases for support of CI files.       *)        (* initialize dbrfr environment *)     load_segment (dbrfr_passone_segment);     initialize;            load_segment (dbrfr_initialization_segment);        (**)    (* The workhorse initializer set 'log_before_images' to true    (* but we do not need this function.    (**)    workhorse_data.log_before_images := false;         (* display ready message *) 
   write_blank_line ( 
       one,        input_descriptor);  (* temp_long_str := ' *** DBRFR started ***'; *)    (*:nl:#*1 1006 ' *** DBRFR started ***' *)      
10:  (* NLS tests *) 
     %   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *) % !   length := nlread (MFR_MN, 1006, nlerr, temp_long_str, len);     !    blank_pad (temp_long_str, chars_in_long_str, length);    IF input_log_write_long_str(temp_long_str,return_status)       THEN fatal_error (return_status);      
11:  (* NLS tests *) 
        (* pre-pass processing *) 
   write_blank_line ( 
       one,        input_descriptor);        (* determine what log set we are to recover *)    determine_recov_set;      '   (* determine what databases we are to recover, if a db list is provided *)  ' 
   process_database_list;  
     "   (* if the user is to enter the log volume names, process that *)  "    IF volume_list_flag <> cur_dbcon  THEN BEGIN         write_blank_line (           one,            input_descriptor);   
      process_volume_list; 
       END;        (**)  "   (* If the user did not enter volume names, then we will determine "   (* which volume to begin with.  Otherwise we will begin with     (* the first volume entered when we processed the volume list.     (**)        determine_recov_start_vol;        (* write out the number of volumes to process *) 
   write_blank_line ( 
       one,        input_descriptor);  !(* temp_long_str := ' THE NUMBER OF LOG VOLUMES TO PROCESS:  '; *) !   (*:nl:$ ' ' *)     (*:nl:$ ' Max. 16 bytes string is appended to this message' *)      (*:nl:#*1 1007 ' THE NUMBER OF LOG VOLUMES TO PROCESS: ' *)      
12:  (* NLS tests *) 
     %   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *) % !   length := nlread (MFR_MN, 1007, nlerr, temp_long_str, len);     !    blank_pad (temp_long_str, chars_in_long_str, length);    temp_short_str := ' ';     convert_shortint_to_ascii (        num_recov_volumes,        temp_short_str);  
   positional_append_str ( 
 
      temp_long_str, 

      temp_short_str, 
      chars_in_short_str,        length);   (* char position of append *)    IF input_log_write_long_str(  
      temp_long_str, 
      return_status) THEN        fatal_error (return_status);      
13:  (* NLS tests *) 
       (* If there are no volumes to process, we terminate *)     IF num_recov_volumes <= zero THEN BEGIN       finish (normal_termination_flag);        GOTO 9999;        END;         (* pass one processing *)      20:  (* NLS message tests *)         load_segment (dbrfr_passone_segment);    determine_redo_list;             (* if there is nothing to recover, terminate *)    IF num_trans_to_redo = zero THEN BEGIN  %(*    temp_long_str := ' THERE ARE NO IMAGE TRANSACTIONS TO RECOVER. '; *) %#      (*:nl:#*1 1008 ' THERE ARE NO IMAGE TRANSACTIONS TO RECOVER. ' *) #     
14:  (* NLS tests *) 
          (*:nl:$COPY '      length := nlread (&, #, nlerr,' *)        length := nlread (MFR_MN, 1008, nlerr,                                        temp_long_str, len);       blank_pad (temp_long_str, chars_in_long_str, length);       IF write_long_str (          list_descriptor,          temp_long_str,           return_status) THEN          fatal_error (return_status);      
15:  (* NLS tests *) 
          finish (normal_termination_flag);            GOTO 9999;        END;         (* pass two processing *) 
   perform_redo_operations; 
        (* post all internal buffers *)    load_segment (dbrfr_initialization_segment);  
   IF post_buffers ( 

      workhorse_data, 
      return_status) THEN       fatal_error ( return_status);             (* report summary statistics *) 
   write_blank_line ( 
       2,       list_descriptor); (* temp_long_str := ' The number of deletes performed   : '; *)    (*:nl:$ ' ' *)     (*:nl:$ ' Max. 16 bytes string is appended to this message' *)      (*:nl:#*1 1009 ' The number of deletes performed   : ' *)      
16:  (* NLS tests *) 
     %   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *) % !   length := nlread (MFR_MN, 1009, nlerr, temp_long_str, len);     !    blank_pad (temp_long_str, chars_in_long_str, length);    long_int_to_readable_short_str (       num_deletes_done,        temp_short_str);  
   positional_append_str ( 
 
      temp_long_str, 

      temp_short_str, 
      chars_in_short_str,        length);     IF write_long_str (        list_descriptor,  
      temp_long_str, 
      return_status) THEN        fatal_error (Return_status);      
17:  (* NLS tests *) 
    (* temp_long_str := ' The number of puts performed      : '; *)    (*:nl:$ ' ' *)     (*:nl:$ ' Max. 16 bytes string is appended to this message' *)     (*:nl:#*1 1010  ' The number of puts performed      : ' *)  %   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *) % !   length := nlread (MFR_MN, 1010, nlerr, temp_long_str, len);     !    blank_pad (temp_long_str, chars_in_long_str, length);    long_int_to_readable_short_str (  
      num_puts_done, 
       temp_short_str);    positional_append_str(  
      temp_long_str, 

      temp_short_str, 
      chars_in_short_str,        length);     IF write_long_str (        list_descriptor,  
      temp_long_str, 
      return_status) THEN        fatal_error (Return_status);      
18:  (* NLS tests *) 
    (* temp_long_str := ' The number of updates performed   : '; *)    (*:nl:$ ' ' *)     (*:nl:$ ' Max. 16 bytes string is appended to this message' *)     (*:nl:#*1 1011  ' The number of updates performed   : ' *)  %   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *) % !   length := nlread (MFR_MN, 1011, nlerr, temp_long_str, len);     !    blank_pad (temp_long_str, chars_in_long_str, length);    long_int_to_readable_short_str (       num_updates_done,        temp_short_str);  
   positional_append_str ( 
 
      temp_long_str, 

      temp_short_str, 
      chars_in_short_str,        length);     IF write_long_str (        list_descriptor,  
      temp_long_str, 
      return_status) THEN        fatal_error (Return_status);      
19:  (* NLS tests *) 
        (* output timestamp of first and last log record *)    load_segment (dbrfr_misc_segment);    IF (num_puts_done <> zero ) OR (num_deletes_done <> zero) OR       (num_updates_done <> zero) THEN       display_timestamps;         999 :         (* close files and terminate *)     finish (normal_termination_flag);     9999:      END. 