 $PASCAL ',7 92081-1X506 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM REOPN;  (* Redo-Open and Undo-close a database *)       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18506                                        *)  ! !(* RELOC:   92081-16506                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <860121.0427>  !(*                                                             *)  ! !(***************************************************************)  !     !(***************************************************************)  ! !(*                                                             *)  ! !(*  This source code is used in the Roll Back and Roll Forward *)  ! !(*  recovery programs for opening a database (REDO-OPEN or     *)  ! !(*  UNDO-CLOSE).  Much of the open code is shared with the     *)  ! !(*  DBOPN intrinsic.  The primary difference between the two   *)  ! !(*  is that input comes from a message for DBOPN and from a    *)  ! !(*  transaction log record for REDO/UNDO OPEN.                 *)  ! !(*                                                             *)  ! !(***************************************************************)  !         $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)  $ Include '[BMCCT'  $    (* Workhorse constants and types *)      $ Include '[XWOCL'  $    (* Open/Close routines. *)   $ Include '[XWRTF'  $    (* Rootfile read/write routines. *)  $ Include '[XDFMP'  $    (* Disc transfer routines. *)  $ List ON $       $ Page $  (************************************************************)  (*                                                          *)  (* Functions REDO_OPEN and UNDO_CLOSE:                      *)  (*                                                          *)  (* Purpose:                                                 *)  (*    To open a specified database to a specified user.     *)  (*    This information can be found in any log record       *)  (*    since the database name and user ID are contained     *)  (*    in every log record.  The database is always opened   *)  (*    with highest level of access.  No action is taken     *)  (*    if the database is already open to the user.          *)  (*                                                          *)  (* Parameters:                                              *)  (*    (in) (1) Database description.                        *)  (*    (out)(2) Open database table index.                   *)  (* (in/out)(3) Workhorse information.                       *)  (*    (out)(4) IMAGE error if an error occurs.              *)  (*                                                          *)  (* Function result:                                         *)  (*    'True' if an error occurs, 'False' otherwise.         *)  (*                                                          *)  (* Possible errors:                                         *)  (*    Corrupt data structures.                              *)  (*    Not a root file.                                      *)  (*    Incorrect security code.                              *)  (*    Disc I/O failure.                                     *)  (*                                                          *)  (************************************************************)          FUNCTION reopn_uncls  $ Alias 'RCV.DbaseOpen' $   $ Heapparms ON $           (VAR root_desc      : new_file_name;   	$ Heapparms OFF $  	           VAR db_index       : Short_int;             VAR workhorse_data : workhorse_info_type;             VAR error_code     : Short_int ) : Boolean;           LABEL 99; (* For non-fatal OPEN errors.       *)          VAR      start_block   : short_int;      (* Rootfile block #. *)     header_block  : Rootfile_header_type;      BEGIN  (* functions REDO_OPEN and UNDO_CLOSE. *)      WITH workhorse_data DO BEGIN         reopn_uncls := true;          (**)       (* Determine if the rootfile is open.  (db_index<>0 if open).      (* If not open, open the rootfile.      (* Make certain the rootfile is valid.      (**)          IF find_open_root (root_desc,                        db_index,                         workhorse_data,                         error_code)   
      THEN GOTO 99;  
     	   IF db_index = 0 	           THEN BEGIN (* No room for rootfile DCB in table! *)            error_code := open_table_full_err;   	         GOTO 99;  	          END;          (**)      (* Negative db_index means database is not open.      (**)           IF db_index < 0   (* not open, but an empty entry exists! *)           THEN BEGIN     (* so let's open the database.          *)                 db_index := abs(db_index);                IF rt_open (root_desc,                        db_index,                       false, (* open root shared *)                       workhorse_data,                       error_code)  
            THEN GOTO 99;  
              WITH opn_tbl_ptr^[db_index] DO BEGIN               open_count := one;                   temp_file_descriptor.dcb.dcb_header := root_file_id;                   IF read_rootfile_hdr (temp_file_descriptor,                                     header_block,                                     error_code)                  THEN GOTO 99;                  rtbl_blk_len := header_block.bm_rt_len;               END;  (* with opn_tbl_ptr *)               END; (* then rootfile not open. *)          reopn_uncls := false;  (* No error! *)       
99: (* Error exit *) 
     END; (* with workhorse_data *)      END; (* functions REDO_OPEN and UNDO_CLOSE *)   .  