 $PASCAL ',7 92081-1X341 REV.5010'$  !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18341                                        *)  ! !(* RELOC:   92081-1X341                                        *)  ! !(*                                                             *)  ! (* Date last modified: <880829.1657>  !(*                                                             *)  ! !(* Altered: September 3, 1986 to call a routine IMG.OPSY       *)  ! !(*    to determine the O/S type, since a variety of numbers    *)  ! !(*    may exist to distinguish different O/S rev's. <MRL>      *)  ! !(*                                                             *)  ! !(***************************************************************)  !     $ Heap 0 $  	$ Recursive OFF $  	 $ Subprogram, Library $   $ Range OFF $       
PROGRAM remote_dbms; 
     $(*********************************************************************)  $ $(*                                                                   *)  $ $(* Remote IMAGE/1000 Data Base Management System Library             *)  $ $(*                                                                   *)  $ $(* Historical comment:                                               *)  $ $(*    The remote access library use to be written in Macro, which    *)  $ $(*    made it more difficult to maintain and inflexible for using    *)  $ $(*    with the RTE-A CDS feature.                                    *)  $ $(*    The RBxxx routines were coded in Pascal in June, 1984.         *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $ $ Page $  $ List OFF, Include '[IMAGE', List ON $       #(********************************************************************) # #(*                      CONSTANT DECLARATIONS                       *) # #(********************************************************************) #     CONST          exec_time_code = 11;          severe = 1;     non_severe = zero;          remote_set_entry_len = 6;     remote_item_entry_len = 5;          max_remote_run_table_size =         local_headr_len + (max_data_sets * remote_set_entry_len) +         (max_items * remote_item_entry_len) +   #      2; (* the 2 is for the # of sets and # of items in the ds msg *) #        min_remote_run_table_size =        local_headr_len +         remote_set_entry_len +        remote_item_entry_len;         get_entire_string_code = -1;      ibase_param_len = max_db + one;      
   mesg_ptr_tbl_index = 0; 
 
   max_return_info = 2048; 
        stat_array_word_len = 10;      %   want_item = 1;  (* flags to routines to indicate what info is needed *) %    want_set = 2;         (* DBINF return buffer length constants *)      m102_return_len = 13;     m202_return_len = 17;     m302_return_len = 2;      m401_return_len = 7;      m801_return_len = 4;          (* DBINF mode constants *)   	   mode202 = 202;  	 	   mode801 = 801;  	        (* DBINF data item type codes returned by dbinf *)   
   type_char = 'X';  
 
   type_real = 'R';  
    type_integer = 'I';         (* DBINF data set type codes returned by dbinf *)     type_manual = 'M';      type_automatic = 'A';     type_detail = 'D';          (* DBLCK lock request buffer length *)      words_in_lock_request_buffer = 2048;       chars_in_lock_request_buffer = words_in_lock_request_buffer *                                     chars_in_word;         max_chars_in_user_item_list = max_words_in_user_item_list *                                   chars_in_word;       $ Page $  #(********************************************************************) # #(*                      TYPE DECLARATIONS                           *) # #(********************************************************************) #     TYPE             status_array_type = ARRAY [1..10] OF short_int;         level_set_itm_type = ARRAY [1..3] OF short_int;         (**)       (* DS #MAST request buffer header and appendage definitions.       (**)          ds_request_buffer_type = RECORD  !      stream_num    : short_int; (* constant 10 going to RDBAM *)  !       sequence_num  : short_int; (* internal *)         source_node   : short_int; (* internal *)         dest_node     : short_int; (* node where RDBAM is *)        error_code1   : short_int; (* returned in reply *)        error_code2   : short_int; (* returned in reply *)         error_node    : short_int; (* node reporting the error *)           qual_and_lvl  : short_int; (* error qualifier: internal *)   "      MA_send_seq   : short_int; (* Message accounting: internal *)  " "      MA_recv_seq   : short_int; (* Message accounting: internal *)  " "      MA_cancel_flag: short_int; (* Message accounting: internal *)  " !      hop_count     : short_int; (* Number of intervening nodes *) !        session_id    : short_int; (* zero for talking to RDBAM *)             (**)        (* level_set_itm is set up as follows:        (*    for DBOPN, a 6 character level word.        (*    for all other calls:        (*       word 1 is a set or item number.  !      (*       word 2 is DBFND item or DBGET expected data length. !       (*       word 3 unused.         (*        (* rest_of_base is set up as follows:         (*    for DBBEG, DBEND, DBMEM and DBUND mode 2:         (*       the base-list of up to 11 databases.   "      (*    for all other calls: the base name (words 2-12 of ibase) "       (**)            rdba_index    : short_int; (* DB call index number *)         mode_num      : short_int; (* mode number of DB call *)         level_set_itm : level_set_itm_type;         max_runtable  : short_int; (* maximum runtable size *)        words_in_base : short_int; (* Number of words in base *)         base_number   : short_int; (* base number on db's node *)    !      rest_of_base  : ARRAY [1..11] OF short_int; (* base name *)  !       END;             ds_request_buffer_ptr_type = ^ds_request_buffer_type;         ds_reply_buffer_type = RECORD  !      stream_num    : short_int; (* constant 10 going to RDBAM *)  !       sequence_num  : short_int; (* internal *)         source_node   : short_int; (* internal *)         dest_node     : short_int; (* node where RDBAM is *)        error_code1   : short_int; (* returned in reply *)        error_code2   : short_int; (* returned in reply *)         error_node    : short_int; (* node reporting the error *)           qual_and_lvl  : short_int; (* error qualifier: internal *)   "      MA_send_seq   : short_int; (* Message accounting: internal *)  " "      MA_recv_seq   : short_int; (* Message accounting: internal *)  " "      MA_cancel_flag: short_int; (* Message accounting: internal *)  " !      hop_count     : short_int; (* Number of intervening nodes *) !        session_id    : short_int; (* zero for talking to RDBAM *)             status_array  : status_array_type;         dbopn_sysnum  : short_int; (* Sys DB num on remote node *)         END;         ds_reply_buffer_ptr_type = ^ds_reply_buffer_type;                 word_char_type =                (* very short string *)        PACKED ARRAY [1..chars_in_word] OF char;      #   ibase_type =                    (* user data base namr parameter *) #       ARRAY [1..ibase_param_len] OF short_int;      "   item_list_type = RECORD         (* list of item names/numbers *)  "       CASE short_int OF   $         1: (numbers : ARRAY [1..max_items_per_dataset+1] OF short_int); $          2: (chars   : PACKED ARRAY   #                           [1..max_chars_in_user_item_list] OF char);  #       END;         item_value_buffer_type =        (* list of item values *)        ARRAY [1..max_words_in_value_list] OF short_int;      !   lock_request_buffer =           (* DBLCK lock request buffer *) !       ARRAY [1..words_in_lock_request_buffer] OF short_int;           lock_request_char_buffer =      (* DBLCK set name list buf *)         PACKED ARRAY [1..chars_in_lock_request_buffer] OF char;          ptr_lock_char_buf = ^lock_request_char_buffer;           #   (*****************************************************************) # #   (* Following is a definition of the DBBUF table.                 *) # #   (* This table contains much of the information needed to manage  *) # #   (* message traffic between the user and the buffer manager,      *) # #   (* and manage the local database run tables.                     *) # #   (*****************************************************************) #     #   database_mesg_len_table_type =  (* database message length table *) #       ARRAY [1..max_db] OF short_int;           (* table of the worst size message required per data base *)       msg_tbl_type = ARRAY [1..max_db] OF short_int;       %   database_run_table_type =       (* database local run table pointers *) %       ARRAY [1..max_db] OF ptr_local_run_table_hdr;          statistics_table_type = (* statistics buffers pointers. *)         ARRAY [1..max_db] OF statistics_buffer_ptr_type;      CONST      max_remote_list_size = max_items_per_dataset + 1 +                             max_words_in_item_value;         max_remote_msg = max_items_per_dataset + one +                       max_data_in_a_record;       TYPE      remote_msg_buf_type = ARRAY [1..max_remote_msg] OF short_int;          remote_msg_buf_ptr_type = ^remote_msg_buf_type;      $   remote_item_list_type = ARRAY [1..max_remote_list_size] OF short_int; $        DBBUF_table_type =   (* contains local system info *)        RECORD  "         process_info:             (* current process information *) "             process_description_type;            open_count: short_int;    (* open database count *)  "         user_comm_id : short_int;  (* user communication id word *) " #         comm_info : image_comm_buffer_type;  (* global comm. info *)  #           cur_mesg_len: short_int;  (* current message length *)             max_mesg_len:             (* message length array *)               database_mesg_len_table_type;   $         cur_mesg_buf:             (* current message buffer pointer *)  $             remote_msg_buf_ptr_type;      %         db_run_table:             (* database run table pointer array *)  %             database_run_table_type;  &         cur_run_table:            (* current database run table pointer *)  &             ptr_local_run_table_hdr;               statistics_table :        (* Stat buffer pointers. *)              statistics_table_type;  !         cur_stat_buffer  :        (* Current stat buffer ptr. *)  !             statistics_buffer_ptr_type;                current_item_list : tempx_table_type;           current_set_and_db: short_int; (* set*256 + db# *)            current_num_keys  : short_int;       
         END; (* RECORD *) 
        ptr_dbbuf_table =               (* pointer definition *)         ^dbbuf_table_type;             remote_item_table_entry_type = RECORD        item_name : item_name_type;    (* 6 chars *)        item_num  : short_int;         (* 0..255  *)        item_len  : short_int;         (* in 2-byte words *)        END;      "   remote_item_table_entry_ptr_type = ^remote_item_table_entry_type; "        remote_item_table_type = ARRAY [1..max_items] OF                               remote_item_table_entry_type;          remote_item_table_ptr_type = ^remote_item_table_type;         ds_opn_items_type = RECORD         num_items : short_int;        itm_table : remote_item_table_type;         END;         ds_opn_items_ptr_type = ^ds_opn_items_type;             remote_set_table_entry_type = RECORD         set_name  : set_name_type;  (* 6 chars *)         set_num   : short_int;      (* 1..50   *)         set_len   : short_int;      (* data entry length *)   !      key_len   : short_int;      (* master set's key item len *)  !       END;      !   remote_set_table_entry_ptr_type = ^remote_set_table_entry_type; !        remote_set_table_type = ARRAY [1..max_data_sets] OF                             remote_set_table_entry_type;          remote_set_table_ptr_type = ^remote_set_table_type;         ds_opn_sets_type = RECORD        num_sets : short_int;         set_table: remote_set_table_type;         END;         ds_opn_sets_ptr_type = ^ds_opn_sets_type;      #   (*****************************************************************) # #   (* The following types are the structures of the status buffer   *) # #   (* returned after execution of an intrinsic. For DBINF, the      *) # #   (* records are the return buffer information for the various     *) # #   (* DBINF modes.                                                  *) # #   (*****************************************************************) #     "   beg_buffer =                    (* DBBEG return status buffer *)  "       RECORD           status: short_int;            logging_state : logging_states;           xaction_num : long_int;  
         END; (* RECORD *) 
     "   cls_buffer =                    (* DBCLS return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   ctl_buffer =                    (* DBCTL return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   del_buffer =                    (* DBDEL return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   end_buffer =                    (* DBEND return status buffer *)  " 	      beg_buffer;  	     "   fnd_buffer =                    (* DBFND return status buffer *)  "       RECORD           status: short_int;            unused: short_int;            current_rec: long_int;            current_chain_len: long_int;            current_chain_tail: long_int;           current_chain_head: long_int;  
         END; (* RECORD *) 
     "   get_buffer =                    (* DBGET return status buffer *)  "       RECORD           status: short_int;            return_data_len: short_int;           current_record_num: long_int;  
         unused: long_int; 
          prev_record_num: long_int;            next_record_num: long_int;   
         END; (* RECORD *) 
        lck_buffer =                    (* DBLCK return buffer *)        RECORD           status: short_int;   
         END; (* RECORD *) 
        inf_buffer = RECORD (* dbinf status buffer *)  
      status : short_int;  
       return_data_len : short_int;        logging_state : logging_states;         END;      #   m101_buffer =                   (* DBINF mode 101 return buffer *)  #       RECORD           item_num: short_int;   
         END; (* RECORD *) 
     #   m102_buffer =                   (* DBINF mode 102 return buffer *)  # 
      PACKED RECORD  
          item_name: item_name_type;            unused1: PACKED ARRAY [1..10] OF char;   
         item_type: char;  
          unused2: char;            sub_item_len: short_int;            sub_item_count: short_int;            unused3: long_int;   
         END; (* RECORD *) 
     '   MX03_MX04_buffer =              (* DBINF modes x03 and x04 return buffer *) '       RECORD           num_avail_items: short_int;           item_num: ARRAY [1..max_items] OF short_int;   
         END; (* RECORD *) 
     #   M201_buffer =                   (* DBINF mode 201 return buffer *)  #       RECORD           set_num: short_int;  
         END; (* RECORD *) 
     #   M202_buffer =                   (* DBINF mode 202 return buffer *)  # 
      PACKED RECORD  
 #         set_name: file_name;      (* set name must take up 8 words *) # $         unused0 : packed array [1..10] of char;   (* hence unused0  *)  $          set_type: char;           unused1: char;            entry_word_len: short_int;            blocking_factor: short_int;           unused2: long_int;            num_entries_in_set: long_int;           set_capacity: long_int;  
         END; (* RECORD *) 
     #   M301_buffer =                   (* DBINF mode 301 return buffer *)  #       RECORD           num_paths: short_int;           path_info: ARRAY [0..max_paths] OF   	            RECORD 	                set_num: short_int;                 search_item_num: short_int;                 sort_item_num: short_int;                 END; (* RECORD *)  
         END; (* RECORD *) 
     #   m302_buffer =                   (* DBINF mode 302 return buffer *)  #       RECORD           search_item_num: short_int;           master_num     : short_int;  
         END; (* RECORD *) 
     #   m40x_buffer =                   (* DBINF mode 40x return buffer *)  #       RECORD           last_accessed_rec: long_int;            previous_rec: long_int;           next_record: long_int;            current_path: short_int;   
         END; (* RECORD *) 
        m50x_buffer =           (* DBINF modes 505 and 506 *)        statistics_buffer_type;       #   m801_buffer =                   (* DBINF mode 801 return buffer *)  #       RECORD           num_blocks_used: long_int;            total_avail_blocks: long_int;   (* max number *)   
         END; (* RECORD *) 
     "   mem_buffer =                    (* DBMEM return status buffer *)  " 	      beg_buffer;  	     "   opn_buffer =                    (* DBOPN return status buffer *)  "       RECORD           status: short_int;            access_level: short_int;            length_run_table: short_int;            hi_access_indic: short_int;           db_access: db_access_type;            sys_log_stat: logging_states;  
         END; (* RECORD *) 
     "   put_buffer =                    (* DBPUT return status buffer *)  "       RECORD           status: short_int;            buffer_word_len: short_int;           new_rec_num: long_int;            num_rec_on_chain: long_int;           pred_rec_num: long_int;           succ_rec_num: long_int;  
         END; (* RECORD *) 
     "   und_buffer =                    (* DBUND return status buffer *)  " 	      beg_buffer;  	     "   unl_buffer =                    (* DBUNL return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   upd_buffer =                    (* DBUPD return status buffer *)  "       RECORD           status: short_int;            return_data_len: short_int;    (* word len *)  
         END; (* RECORD *) 
     #   return_buffer_type =            (* generic return status buffer *)  #       RECORD  
         CASE short_int OF 
 
            1: (* DBBEG *) 
                (beg: beg_buffer);   
            2: (* DBCLS *) 
                (cls: cls_buffer);   
            3: (* DBCTL *) 
                (ctl: ctl_buffer);   
            4: (* DBDEL *) 
                (del: del_buffer);   
            5: (* DBEND *) 
                (endb: end_buffer);  
            6: (* DBFND *) 
                (fnd: fnd_buffer);   
            7: (* DBGET *) 
                (get: get_buffer);               8: (* DBINF status buffer *)                 (inf: inf_buffer);               101: (* DBINF mode 101 *)                  (m101: m101_buffer);               102: (* DBINF mode 102 *)                  (m102: m102_buffer);               104: (* DBINF mode 104 *)                  (mx03_mx04: mx03_mx04_buffer);               201: (* DBINF mode 201 *)                  (m201: m201_buffer);               202: (* DBINF mode 202 *)                  (m202: m202_buffer);               301: (* DBINF mode 301 *)                  (m301: m301_buffer);               302: (* DBINF mode 302 *)                  (m302: m302_buffer);               401: (* DBINF mode 401 *)                  (m40x: m40x_buffer);               505: (* DBINF modes 505 and 506 *)                 (m50x: m50x_buffer);               801: (* DBINF mode 801 *)                  (m801: m801_buffer);   
            9: (* DBLCK *) 
                (lck: lck_buffer);   
            10:(* DBMEM *) 
                (mem: mem_buffer);               11: (* DBOPN *)                  (opn: opn_buffer);               12: (* DBPUT *)                  (put: put_buffer);               13: (* DBUND *)                  (und: und_buffer);               14: (* DBUNL *)                  (unl: unl_buffer);               15: (* DBUPD *)                  (upd: upd_buffer);               16: (status : status_array_type);       
         END; (* RECORD *) 
        ptr_return_buffer =             (* pointer definition *)   
      ^return_buffer_type; 
 $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #     (**** Get the operating system number ****)   FUNCTION opsys   $ Alias 'IMG.OPSY' $      : os_kinds;     EXTERNAL;      (**** Logoff the remote session ****)       PROCEDURE logoff_remote_session  $ Alias 'DLGOF' $     (VAR status : short_int;           node   : ibase_type);      EXTERNAL;          !(**** Move the root file name into the RBOPN message buffer ****)  !     PROCEDURE copy_root_name  $ Alias 'DBMVW' $       (    ibase : short_int; (* first word of root name *)        VAR rtnam : new_file_name;            length: short_int);      EXTERNAL;       $ List OFF, Include '[XDTDY', List ON $           (**** Get the program name: System Dependent! ****)       PROCEDURE get_program_name  $ Alias 'PNAME' $      (VAR program_name : prog_name);     EXTERNAL;              (**** Fill a buffer with a value ****)      PROCEDURE fill_with_value  $ Alias 'DBFWW' $     (    length : short_int;       VAR buffer : statistics_buffer_type;          value  : short_int);     EXTERNAL;      $(* Get_run_table_and_mesg_buf returns the current run table address  *)  $ $(* the message buffer address.                                       *)  $     PROCEDURE get_run_table_and_mesg_buf $ALIAS 'DBGRT'$     ( VAR run_table_index: short_int;       VAR run_table: ptr_local_run_table_hdr;       VAR mesg_buf: remote_msg_buf_ptr_type);     EXTERNAL;      PROCEDURE trim_run_table $ ALIAS 'DBTRM' $     ( VAR run_table_index : short_int;        VAR num_words_to_keep : short_int;        VAR return_status : short_int);     EXTERNAL;          (* Move a DBGET record number or key value into msg buffer *)       PROCEDURE move_value   $ Alias 'DBMVW' $     (    arg : argument_type;  (* argument to move *)      VAR buf : short_int;      (* word to begin moving to *)           len : short_int);     (* number of words to move *)      EXTERNAL;          (* Move a DBPUT value buffer into msg buffer *)       PROCEDURE move_value_buffer   $ Alias 'DBMVW' $      (    buf1: item_value_buffer_type; (* argument to move *)  "    VAR buf2: short_int;              (* word to begin moving to *)  " "        len : short_int);             (* number of words to move *)  "    EXTERNAL;          (**** Copy the statistics buffer. ****)       PROCEDURE copy_statistics_buffer  $ Alias 'DBMVW' $      (    accumulated_stats : statistics_buffer_type;       VAR user_buffer       : m50x_buffer;          number_of_words   : short_int);      EXTERNAL;          $(* DBBUF returns the address of the dbbuf table.                     *)  $     FUNCTION DBBUF: ptr_dbbuf_table;     EXTERNAL;      $(* DBFRT finds a local run table.                                    *)  $     PROCEDURE DBFRT   
   ( VAR ibase: short_int; 
 
         flag: short_int;  
 
     VAR index: short_int; 
      VAR stat: short_int );      EXTERNAL;      $(* DBGBF gets a buffer (slice of background memory)                  *)  $     PROCEDURE DBGBF   
   (     index: short_int; 
          len: short_int;  
     VAR avail: short_int; 
      VAR status: short_int);     EXTERNAL;      $(* DBRBF returns a buffer                                            *)  $     PROCEDURE DBRBF      (      index: short_int;        VAR  status: short_int);      EXTERNAL;      $(* Move_data_values moves a data value from one area into another.   *)  $     PROCEDURE move_data_values $ALIAS 'DBMVW'$     ( VAR from_data_values: data_record_type;       VAR to_data_values: short_int;            num_words: short_int);      EXTERNAL;      (* copy IBASE into DS message header *)       PROCEDURE move_ibase  $ Alias 'DBMVW' $      (VAR first_word_SOURCE:  short_int;      VAR first_word_dest   : short_int;          num_words         : short_int);      EXTERNAL;      #(* The following is a set of EXTERNAL declarations for assigning    *) # #(* pointer addresses (either directly or with an offset).           *) #     (* make ptr to lock request buffer as an array of chars *)  FUNCTION make_request_buf_ptr $ Alias '.DRCT', Direct $      (lock_buf : lock_request_buffer) : ptr_lock_char_buf;     EXTERNAL;      (**** Get the A-series session number of this program ****)       FUNCTION user_session_number  $ Alias 'USNUM' $      : short_int;      EXTERNAL;      (**** Get various pointers for database ****)       FUNCTION get_database_pointers   $ Alias 'Img.GetPointers' $     (    ibase : ibase_type;       VAR dbbuf_ptr     : ptr_dbbuf_table;      VAR message_ptr   : remote_msg_buf_ptr_type;      VAR run_table_ptr : ptr_local_run_table_hdr;      VAR stats_buf_ptr : statistics_buffer_ptr_type;       VAR error         : short_int) : Boolean;      EXTERNAL;          (**** Get various pointers for multi-database call ****)      FUNCTION multi_db_pointers   $ Alias 'Img.GetPointers' $     (    ibase         : short_int;      VAR dbbuf_ptr     : ptr_dbbuf_table;      VAR message_ptr   : remote_msg_buf_ptr_type;      VAR run_table_ptr : ptr_local_run_table_hdr;      VAR stats_buf_ptr : statistics_buffer_ptr_type;       VAR error         : short_int) : Boolean;      EXTERNAL;          (* Make a pointer to a remote item table *)       PROCEDURE make_rmt_itm_tbl_ptr  $ Alias 'DBPTR' $      (    runtable_ptr : ptr_local_run_table_hdr;           offset       : short_int;       VAR itm_tbl_ptr  : ds_opn_items_ptr_type);     EXTERNAL;          (* Make a pointer to a remote item table entry *)       PROCEDURE make_rmt_itm_tbl_ent_ptr  $ Alias 'DBPTR' $      (    runtable_ptr : ptr_local_run_table_hdr;           offset       : short_int;       VAR itm_ent_ptr  : remote_item_table_entry_ptr_type);      EXTERNAL;          (* Make a pointer to a remote set table entry *)      PROCEDURE make_rmt_set_tbl_ent_ptr  $ Alias 'DBPTR' $      (    runtable_ptr : ptr_local_run_table_hdr;           offset       : short_int;       VAR set_ent_ptr  : remote_set_table_entry_ptr_type);     EXTERNAL;          (* Make a pointer to a remote set table *)      PROCEDURE make_rmt_set_tbl_ptr  $ Alias 'DBPTR' $      (    itm_tbl_ptr  : ds_opn_items_ptr_type;           offset       : short_int;       VAR set_tbl_ptr  : ds_opn_sets_ptr_type);      EXTERNAL;          (* Compare set names *)       FUNCTION compare_set_names  $ Alias 'DBCMW' $      (set_name1, set_name2 : set_name_type;       name_len : short_int) : short_int;     EXTERNAL;          (* Compare item names *)      FUNCTION compare_item_names  $ Alias 'DBCMW' $     (item_name1, item_name2 : item_name_type;      item_name_len : short_int) : short_int;      EXTERNAL;          (* get pointers related to DS messages *)       PROCEDURE get_ds_request_ptrs  $ Alias 'Rmt.GetDsPtrs' $     (VAR ds_msg_ptr : ds_request_buffer_ptr_type;      VAR ds_rpl_ptr : ds_reply_buffer_ptr_type);      EXTERNAL;      (* Send and receive a DS message *)       FUNCTION send_receive_ds_msg   $ Alias 'RBMAS' $     (    to_rdbam_buf   : short_int; (* first word of buf *)           to_rdbam_len   : short_int; (* word length of buf *)      VAR from_rdbam_buf : short_int; (* first word of buf *)           from_rdbam_max : short_int; (* max expected words *)      VAR istat          : return_buffer_type) : boolean;      EXTERNAL;      $ Page $  #(********************************************************************) # #(*                        make_ibase_list                           *) # #(********************************************************************) # #(*                                                                  *) # #(* Purpose:                                                         *) # #(*    To verify that a mode 3 transaction call was given an at-sign *) # #(*    for the ibase parameter, and construct the ibase list         *) # #(*    for those open databases.                                     *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in)  (1) The supplied ibase.                                 *) # #(*    (out) (2) The constructed ibase list.                         *) # #(*    (out) (3) An error code if an error is found.                 *) # #(*                                                                  *) # #(* Function result: 'True' if an error occurs.                      *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION make_ibase_list   $ Alias 'Rmt.MakeBaseList' $      (VAR ibase : ibase_type;       VAR blist : ibase_type;       VAR status: short_int) : boolean;       LABEL 999; (* error exit *)       VAR      dbbuf_ptr : ptr_dbbuf_table;   
   i,ix      : short_int;  
    chars     : int_or_char;       BEGIN (* make ibase list *)          make_ibase_list := true;  (* assume an error will occur *)          chars.int_val :=  ibase[one];      !   IF (chars.char_val[one] <> '@') THEN BEGIN (* not an at-sign *) !       status := db_not_open_to_user_err;        GOTO 999;         END;         dbbuf_ptr := dbbuf;     ix := zero; (* number of db's open *)         WITH dbbuf_ptr^ DO      FOR i := one TO max_db DO  (* make ibase list *)             IF (db_run_table[i] <> nil) THEN BEGIN           ix := ix + one;           blist[ix+one] := i;           END;          IF (ix = zero) THEN BEGIN        status := db_not_open_to_user_err;        GOTO 999;         END;      
   blist[one] := ix; 
        make_ibase_list := false; (* no error *)       999: (* error exit *)       
END; (* make_ibase_list *) 
 $ Page $  #(********************************************************************) # #(*                                                                  *) # #(*  procedure find_set                                              *) # #(*                                                                  *) # #(*  purpose: To determine if a set reference is a name or number,   *) # #(*    and validate that it is legal for the database.               *) # #(*                                                                  *) # #(*  'True' is returned if the set is not legal.                     *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION find_set     $ Alias 'Rmt.FindSet' $      (VAR set_id    : item_set_name_type;       VAR run_table : ptr_local_run_table_hdr;      VAR set_number: short_int;      VAR dscb_ptr  : remote_set_table_entry_ptr_type;      VAR status    : short_int) : Boolean;       LABEL 99;  (* success exit *)       VAR      i            : short_int;  
   number_given : boolean; 
     
BEGIN (* find_set *) 
        find_set := false; (* assume the set is legal *)       !   IF (set_id.number <= max_data_sets) AND (set_id.number > zero)  !       THEN number_given := true         ELSE number_given := false;              FOR i := one TO run_table^.set_count DO BEGIN            make_rmt_set_tbl_ent_ptr  
         (run_table, 
           run_table^.set_off + ((i-one)*remote_set_entry_len),  
          dscb_ptr); 
           WITH dscb_ptr^ DO   
      CASE number_given OF 
              true: IF set_num = set_id.number THEN BEGIN                    set_number := set_num;  
                  GOTO 99; 
                   END; (* then set number found *)                false: IF compare_set_names (set_name, set_id.set_name,   $                                      words_in_set_name) = 0 THEN BEGIN  $                   (* match was found *)                     set_number := set_num;  
                  GOTO 99; 
                   END; (* then *)       
         OTHERWISE;  
          END; (* case *)      
      END; (* for *) 
     "   (* if we went through each set and didn't find a match, error! *) "     
   find_set := true; 
    status   := illegal_set_ref_err;       
99:  (* successful exit *) 
     
END; (* find_set *)  
 $ Page $  #(********************************************************************) # #(*                                                                  *) # #(*  procedure find_item                                             *) # #(*                                                                  *) # #(*  purpose: To determine if a item reference is a name or number,  *) # #(*    and validate that it is legal for the database.               *) # #(*                                                                  *) # #(*  'True' is returned if the item is not legal.                    *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION find_item     $ Alias 'Rmt.Finditem' $      (VAR item_id    : item_set_name_type;      VAR run_table  : ptr_local_run_table_hdr;       VAR item_number: short_int;       VAR ittb_ptr   : remote_item_table_entry_ptr_type;      VAR status     : short_int) : boolean;      LABEL 99; (* success exit *)      VAR      i            : short_int;  
   number_given : boolean; 
         BEGIN (* find_item *)          find_item := false; (* assume match will be found *)           IF (item_id.number <= max_items) AND (item_id.number > zero)          THEN number_given := true         ELSE number_given := false;              FOR i := one TO run_table^.itm_count DO BEGIN            make_rmt_itm_tbl_ent_ptr  
         (run_table, 
           run_table^.itm_off + ((i-1)*remote_item_entry_len),   
          ittb_ptr); 
           WITH ittb_ptr^ DO   
      CASE number_given OF 
              true: IF item_num = item_id.number THEN BEGIN                    item_number := item_num;  
                  GOTO 99; 
                   END; (* then *)       "         false: IF compare_item_names (item_name, item_id.item_name, " &                                       words_in_item_name) = zero THEN BEGIN &                    item_number := item_num;                      GOTO 99;                      END;       
         OTHERWISE;  
          END; (* case *)      
      END; (* for *) 
             (* if we fall through the loop, then the item was illegal *)           find_item := true;      status    := illegal_item_ref_err;       99:  (* success exit *)       
END; (* find_item *) 
 $ Page $  "(******************************************************************) " "(*                process_remote_item_list                        *) " "(******************************************************************) " "(*                                                                *) " "(* Purpose:                                                       *) " "(*    This routine will parse an item name/number list and        *) " "(*    build an item number list in the tempx table of DBBUF.      *) " "(*    Note: the remote 'current item list' is in reality an       *) " "(*    item number list, since we do not have complete details     *) " "(*    on the items.  (That is handled on the remote node).        *) " "(*                                                                *) " "(* Parameters:                                                    *) " "(*                                                                *) " "(* Function result: 'True' if an error occurs.                    *) " "(*                                                                *) " "(******************************************************************) "      FUNCTION process_remote_item_list  $ Alias 'Rmt.PrseItemList' $       (VAR setnum : short_int;       VAR item_list : item_list_type;       VAR run_table_ptr : ptr_local_run_table_hdr;      VAR list_len  : short_int; (* length of list in buffer *)       VAR value_len : short_int; (* length of returned values *)      VAR status    : short_int) : boolean;       LABEL 999; (* exit label *)       VAR      ittb_ptr   : remote_item_table_entry_ptr_type;   
   itnum      : short_int; 
    dscb_entry : remote_set_table_entry_ptr_type;      
   numitems   : short_int; 
 
   i          : short_int; 
    item_name  : item_set_name_type;          end_of_list: boolean;         dbbuf_ptr  : ptr_dbbuf_table;     cur_char   : char;   
   char_pos   : short_int; 
 
   cur_pos    : short_int; 
     BEGIN (* process_remote_item_list *)      "   process_remote_item_list := true;  (* Assume error will occur *)  "        dbbuf_ptr := dbbuf;         (**)      (* Check for special cases of item lists.     (**)          WITH dbbuf_ptr^ DO BEGIN         IF (item_list.chars[one] = '0') OR  "         (item_list.numbers[one] = zero) THEN BEGIN (* null list *)  "              cur_mesg_buf^[1] := one;  (* length of item list *)  #         cur_mesg_buf^[2] := zero; (* number of items in item list *)  #              list_len := 2; (* length of list to RDBAM *)            value_len     := zero; (* no values returned *)           process_remote_item_list := false;   	         GOTO 999; 	          END; (* then '0' or binary 0 *)      "      IF (item_list.chars[one] = '@') OR          (* entire rec   *) " "         (item_list.chars[one] = '*') THEN BEGIN  (* current list *) "          make_rmt_set_tbl_ent_ptr               (run_table_ptr,   %             run_table_ptr^.set_off + ((setnum-one)*remote_set_entry_len), % 
             dscb_entry);  
              cur_mesg_buf^[1] := one; (* words in item list *)           cur_mesg_buf^[2] := item_list.numbers[one];           list_len := 2;  (* length sent to RDBAM *)   !         value_len:= dscb_entry^.set_len; (* possibly overkill *)  !          process_remote_item_list := false;   	         GOTO 999; 	          END; (* then '@' or '*' *)                 (* We either have a number list or an name list *)            list_len := item_list.numbers[one];         value_len:= zero;       !      IF (list_len <= max_data_sets) THEN BEGIN (* number list *)  !              IF (list_len <= zero) THEN BEGIN               status := illegal_item_ref_err;               GOTO 999;               END;               FOR i := one TO list_len DO BEGIN                  item_name.number := item_list.numbers[i+one];                   IF find_item (item_name, run_table_ptr,                             itnum, ittb_ptr, status)                 THEN GOTO 999;                   cur_mesg_buf^[i+2] := itnum;              value_len := value_len + ittb_ptr^.item_len;  
            END; (* for *) 
     $         cur_mesg_buf^[one] := list_len + one; (* length of item list *) $          cur_mesg_buf^[2]   := list_len; (* number of items *)      "         list_len := list_len + 2; (* num items + 1 + length word*)  "              END (* then number list *)                 ELSE BEGIN (* item name list *)                end_of_list := false;           char_pos    := one;               cur_pos     := zero;            item_name.item_name := ' ';      
         list_len := zero; 
              WHILE NOT end_of_list DO BEGIN                   cur_char := item_list.chars[char_pos];              char_pos := char_pos + one;                   IF (cur_char = ' ') OR (cur_char = ';') OR  !               (ord(cur_char) = 0) OR (cur_char = ',') THEN BEGIN  !                    (* end of a token *)                  IF find_item (item_name, run_table_ptr, itnum,                                ittb_ptr, status)                    THEN GOTO 999;                     list_len := list_len + one;                 cur_mesg_buf^[list_len+2] := itnum;                     value_len := value_len + ittb_ptr^.item_len;                      item_name.item_name := ' ';                 cur_pos := zero;                      IF (cur_char <> ',') THEN end_of_list := true;                      END (* then end of token *)                  ELSE BEGIN (* non-terminating character *)                     cur_pos := cur_pos + one;                 IF (cur_pos > chars_in_item_name) THEN BEGIN                     status := illegal_item_ref_err;                     GOTO 999;                     END;                     item_name.item_name[cur_pos] := cur_char;                     END; (* else non-terminating char *)                   END; (* while not end of list *)               cur_mesg_buf^[1] := list_len + 1;           cur_mesg_buf^[2] := list_len; (* num of items *)       !         list_len := list_len + 2;  (* length to send to rdbam *)  !              END; (* else item name list *)             END; (* with dbbuf_ptr *)          process_remote_item_list := false; (* no error *)      999: (* exit *)       END; (* process_remote_item_list *)   $ Page $  $(*********************************************************************)  $ $(*                      Process_Text_Str                             *)  $ $(*********************************************************************)  $ $(*                                                                   *)  $ $(* Purpose:                                                          *)  $ $(*    To perform validity and legality checking of text strings      *)  $ $(*    supplied by the caller for placing in log records.  Current    *)  $ $(*    IMAGE definition is for text strings to be up to 256 words     *)  $ $(*    or 512 characters in length.  Characters are specified by      *)  $ $(*    a negative number and words by a positive number.              *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (in)     (1) User-supplied text.                               *)  $ $(*    (in)     (2) Length of user-supplied text in words or chars.   *)  $ $(*    (out)    (3) Positive word length of processed text.           *)  $ $(*    (out)    (4) IMAGE error number if text length was bad.        *)  $ $(*                                                                   *)  $ $(* Function result:                                                  *)  $ $(*    Boolean 'True' if an error occurs, otherwise 'false'.          *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION process_text_str  $ Alias 'Rmt.TextStr' $     (VAR user_text : text_str;       VAR user_len  : short_int;      VAR mesg_len  : short_int;      VAR status    : short_int) : Boolean;       LABEL 999;  (* error exit *)          VAR      abs_len : short_int;       BEGIN  (* function process_text_str *)         IF (user_len > words_in_logging_text) OR         (user_len < neg_chars_in_logging_text) THEN BEGIN         process_text_str := true;   (* error!! *)         status := text_length_err;        GOTO 999;         END; (* then the text length was not proper *)         IF (user_len < zero)         THEN mesg_len := (abs(user_len)+1) DIV 2        ELSE mesg_len := user_len;         process_text_str := false;  (* no error occurred *)      999: (* error exit *)       END; (* function process_text_str *)  $ Page $  #(*******************************************************************)  # #(*                    send_receive_message                         *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To consolidate the handling of communication between the     *)  # #(*    remote user program and RDBAM.    This routine fills in      *)  # #(*    the common portions of DS request message, waits for and     *)  # #(*    receives a reply, and checks for communication errors.       *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) The IMAGE call type.                            *)  # #(*    (in)     (2) The ibase parameter.                            *)  # #(*    (in)     (3) The mode number.                                *)  # #(*    (in)     (4) The to-RDBAM buffer.                            *)  # #(*    (in)     (5) Length of the to-RDBAM buffer.                  *)  # #(*    (out)    (6) The from-RDBAM reply buffer.                    *)  # #(*    (in)     (7) The from-RDBAM max reply length.                *)  # #(*    (out)    (8) The ISTAT array.  (Where error code will be)    *)  # #(*                                                                 *)  # #(* Function result: Boolean 'True' if an error, otherwise 'false'. *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION send_receive_message  $ Alias 'Rmt.SendReceive' $     (VAR ibase          : ibase_type;          mode           : short_int;       VAR lvl_set_itm    : level_set_itm_type;  !    VAR to_RDBAM_buf   : short_int; (* first word of the buffer *) !         to_RDBAM_len   : short_int;   !    VAR from_RDBAM_buf : short_int; (* first word of the buffer *) !         from_RDBAM_max : short_int; (* max reply length *)          intrinsic_code : call_types;      VAR istat          : return_buffer_type) : Boolean;       LABEL 999;      CONST       header_len = 32; (* length of DS msg header and appendage *)       rdbam_stream_number = 10; (* DS monitor stream number *)       words_of_ibase_in_ds_message = 11; (* Most that could fit *)        VAR      loop            : Short_int;          waiting_time    : long_int; (* time waiting for service *)      collecting_stats: Boolean;          ds_reply_ptr    : ds_reply_buffer_ptr_type;     ds_msg_ptr      : ds_request_buffer_ptr_type;     dbbuf_ptr       : ptr_dbbuf_table;      cur_stats_ptr   : statistics_buffer_ptr_type;     run_table_ptr   : ptr_local_run_table_hdr;          rdbam_code      : short_int;           BEGIN (* send_receive_message *)      !   send_receive_message := true;  (* Assume an error will occur *) !        get_ds_request_ptrs (ds_msg_ptr, ds_reply_ptr);         dbbuf_ptr := dbbuf;         WITH dbbuf_ptr^ DO BEGIN         cur_stats_ptr := cur_stat_buffer;         run_table_ptr := cur_run_table;         END;         IF (cur_stats_ptr = nil)         THEN collecting_stats := false        ELSE collecting_stats := true;      
   CASE intrinsic_code OF  
           db_begin   : rdbam_code := 46;        db_close   : rdbam_code := 38;        db_control : rdbam_code := 50;        db_delete  : rdbam_code := 43;        db_end     : rdbam_code := 47;        db_find    : rdbam_code := 39;        db_get     : rdbam_code := 40;        db_info    : rdbam_code := 37;        db_lock    : rdbam_code := 44;        db_memo    : rdbam_code := 48;        db_open    : rdbam_code := 36;        db_put     : rdbam_code := 42;        db_undo    : rdbam_code := 49;        db_unlock  : rdbam_code := 45;        db_update  : rdbam_code := 41;            OTHERWISE BEGIN            istat.beg.status := illegal_procedure_err;   	         GOTO 999; 	          END; (* otherwise *)             END; (* case *)                  (**)      (* First set up the standard part of the DS header.     (**)          WITH ds_msg_ptr^, run_table_ptr^ DO BEGIN        stream_num := rdbam_stream_number; (* Constant 10 *)            IF intrinsic_code = db_open THEN BEGIN           dest_node := ibase[1];            max_runtable := from_rdbam_max;           END (* then is DBOPN *)        ELSE dest_node := db_node;            rdba_index := rdbam_code;   
      mode_num   := mode;  
       level_set_itm := lvl_set_itm;         words_in_base := words_of_ibase_in_ds_message;            (* Do this for old node in network *)         move_ibase (ibase[2], rest_of_base[one], words_in_base);            CASE intrinsic_code OF               (* Transaction calls send an ibase-list *)   #         db_begin, db_end, db_memo, db_undo : base_number := ibase[1]; #              db_open : base_number := 8224; (* two blanks *)               OTHERWISE base_number := sys_dbnum;           END;             END; (* with *)                  (* Get time before sending message *)         IF collecting_stats        THEN waiting_time := get_start_time;             IF send_receive_ds_msg (to_rdbam_buf, to_rdbam_len,                             from_rdbam_buf, from_rdbam_max,                             istat)   
      THEN GOTO 999; 
            IF collecting_stats THEN BEGIN             (* Get the elapsed time waiting for service *)            waiting_time := get_elapsed_time (waiting_time);            (**)        (* Increment the proper counters and add to the proper        (* times for this intrinsic call.         (**)      %      WITH dbbuf_ptr^.cur_stat_buffer^.call_stats[intrinsic_code] DO BEGIN %          wait_time := wait_time + waiting_time;            END; (* with *)            END; (* then gather stats *)         (**)      (* Return the status array in the DS reply header.      (* If this was a successful DBOPN, return the system      (* DB number from the remote node to Remote_DBOPEN.     (**)          WITH ds_reply_ptr^ DO BEGIN        istat.status := status_array;             IF (intrinsic_code = db_open)            THEN lvl_set_itm[one] := dbopn_sysnum;         END; (* with *)          IF istat.status[one] <> zero THEN GOTO 999;         send_receive_message := false;  (* No error! *)      999 : (* error exit *)      END;  $ Page $  $(*********************************************************************)  $ $(*                      transaction_checker                          *)  $ $(*********************************************************************)  $ $(*                                                                   *)  $ $(* Purpose:                                                          *)  $ $(*    To do the ibase and transaction number checking for multi-db   *)  $ $(*    transactions (mode 2 for DBBEGIN, DBEND, DBMEMO and DBUNDO).   *)  $ $(*                                                                   *)  $ $(*    Illegal ibases are:                                            *)  $ $(*       1) if the ibase count is <= zero or >max_db (20).           *)  $ $(*       2) if any ibase number is outside the 1-max_db range.       *)  $ $(*       3) if any ibase number is not an open database.             *)  $ $(*       4) if the databases are not all on the same node.           *)  $ $(*       5) if any two ibase's have different transaction id's.      *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (in)     (1) 'dbbegin calling' boolean indicator.              *)  $ $(*    (in)     (2) node number on which transaction will begin.      *)  $ $(*    (in)     (3) dbbuf table pointer.                              *)  $ $(*    (in)     (4) the mode-2 ibase supplied by the user.            *)  $ $(*    (out)    (5) an IMAGE error number if an error occurs.         *)  $ $(*                                                                   *)  $ $(* Function result is 'True' for an error, otherwise 'false'.        *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION transaction_checker   $ Alias 'Rmt.TransCheck' $      (    is_dbbegin : boolean;           node_num   : short_int;       VAR dbbuf_table: ptr_dbbuf_table;       VAR ibase      : ibase_type;      VAR error      : short_int) : Boolean;      LABEL 999; (* error exit *)       VAR   
   loop : short_int; 
    trans_num : long_int;  
   basex     : short_int;  
     #   rdbap_clone_id : short_int; (* used by RDBAM for routing message *) #     BEGIN (* transaction checker *)       !   transaction_checker := true;  (* Assume an error will happen *) !        (**)      (* Make sure ibase[1] is in the proper range.     (**)          IF (ibase[one] <= zero) OR (ibase[one] > max_db) THEN BEGIN        error := db_not_open_to_user_err;         GOTO 999;         END;             (**)      (* For each ibase number, verify it is in the proper range,     (* is an open database, is not a remote database, and that      (* the transaction id is the same for all databases in the   !   (* ibase list.  Furthermore, for the calls other than DBBEGIN,  !    (* there must not be another locally open database with     (* the same transaction id which is NOT in the ibase list.      (* This is assured by comparing the number of bases in the      (* list with the 'multi_db_count' in the run table, which     (* is set by DBBEGIN.     (**)          trans_num := zero;          WITH dbbuf_table^ DO      FOR loop := one TO ibase[one] DO BEGIN         basex := ibase[loop+one];         IF (basex <= zero) OR (basex > max_db) THEN BEGIN            error := db_not_open_to_user_err;  	         GOTO 999; 	          END;             IF (db_run_table[basex] = nil) THEN BEGIN            error := db_not_open_to_user_err;  	         GOTO 999; 	          END;             WITH db_run_table[basex]^ DO BEGIN           (* isolate the rdbap clone number (high byte) *)            rdbap_clone_id := (sys_dbnum DIV 256) * 256;                IF (node_num <> db_node) THEN BEGIN              error := xaction_spans_nodes_err;               GOTO 999;               END;               IF (transaction_id = zero)               THEN IF (NOT is_dbbegin)  
               THEN BEGIN  
                   error := no_xaction_in_progress_err;                    GOTO 999;                     END                  ELSE (* it is dbbegin... no error. *)                  ELSE (* the transaction id is not zero *)                      IF (is_dbbegin)                    THEN BEGIN                       error := xaction_in_progress_err;                       GOTO 999;                       END                    ELSE IF (loop = one)  (* not dbbegin *)                        THEN IF (multi_db_count <> ibase[one])                           THEN BEGIN                             error := xaction_ibase_err;                             GOTO 999;                             END                          ELSE BEGIN                             trans_num := transaction_id;                              END      #                     ELSE IF (trans_num <> transaction_id) THEN BEGIN  #                         error := xaction_ibase_err;                           GOTO 999;                           END;                   (**)   #         (* For remote calls, the ibase list needs the local database  # "         (* number AS RDBAP SEES IT.  The RDBAP database number has  " !         (* the RDBAP clone number in the high byte and the local  ! "         (* database number in the low byte.  The number we want is  "          (* in the low order byte.           (* Note: Do NOT do a MOD function, since Pascal will            (* pull in the runtime error catcher routines.            (**)                 ibase[loop+1] := sys_dbnum - ((sys_dbnum DIV 256)*256);                END; (* with run table *)            END; (* with dbbuf...for *)          (* Now put the RDBAP clone id into the high byte of the *)   !   (* first word of ibase, which is the number of base numbers *)  !     (* in the ibase-list.  RDBAM will strip the high byte off *)       (* before making the IMAGE call. *)         ibase[one] := ibase[one] + rdbap_clone_id;          transaction_checker := false;  (* no error! *)       999: (* error exit *)       END; (* transaction_checker *)  $ Page $  $(*********************************************************************)  $ $(*                   Transaction_Base_Formatter                      *)  $ $(*********************************************************************)  $ $(*                                                                   *)  $ $(* This routine is used by IMAGE-II to collect together all databases*)  $ $(* which are, or will be, part of the same transaction for mode 1    *)  $ $(* operations.   The resulting IBASE is of the mode 2 format.        *)  $ $(* Only remote databases on the same node as the first in the ibase  *)  $ $(* list are considered.                                              *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (in)     (1) The transaction number to look for.               *)  $ $(*    (in)     (2) The pointer to the DBBUF table.                   *)  $ $(*    (out)    (3) The mode-2 format ibase list.                     *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $      PROCEDURE transaction_base_formatter  $ Alias 'Rmt.BaseFormat' $      (    transaction_number : long_int;      VAR node_num           : short_int;       VAR dbbuf_table        : ptr_dbbuf_table;       VAR result_ibase       : ibase_type);       VAR   	   i : short_int;  	     BEGIN (* ibase formatter *)          result_ibase[one] := zero;          WITH dbbuf_table^ DO      FOR i := one TO max_db DO         IF (db_run_table[i] <> nil) THEN WITH db_run_table[i]^ DO    "         IF (indicators.remote) AND (node_num = db_node) THEN BEGIN  "             result_ibase[one] := result_ibase[one] + one;               result_ibase[result_ibase[one]+one] := i;               END; (* then *)       
END; (* ibase formatter *) 
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure Remote_DBBEGIN                                          *)  $ $(*                                                                   *)  $ $(* Purpose:                                                          *)  $ $(*    To start a transaction for the caller.  All databases on the   *)  $ $(*    same node as the specified database will be considered part of *)  $ $(*    the same transaction, including any databases (on the same     *)  $ $(*    node) opened during the transaction.                           *)  $ $(*                                                                   *)  $ $(* input  : (1) A database identifier. (ibase parm)                  *)  $ $(*          (2) Text buffer (a comment for the log record).          *)  $ $(*          (3) Mode (1 or 2)                                        *)  $ $(*          (4) Status array.                                        *)  $ $(*          (5) Text length. (-512 bytes to +256 words).             *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE Remote_DBBEGIN  $ Alias 'RBBEG' $      (VAR ibase : ibase_type;   
    VAR itext : text_str;  
 
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len : short_int);          LABEL      999;       CONST   
   dbbegin_calling = true; 
    mode3 = 3;  (* we always pass an IBASE-LIST remotely *)      VAR      temp_ibase    : ibase_type;         dbbuf_ptr     : ptr_dbbuf_table;      mesg_buf_ptr  : remote_msg_buf_ptr_type;      run_table_ptr : ptr_local_run_table_hdr;      stat_buf_ptr  : statistics_buffer_ptr_type;      	   i : short_int;  	    start_time    : long_int;     save_transaction : long_int;          node_num : short_int;         lvl_set_itm : level_set_itm_type;     junk_buf    : short_int;      base        : short_int;       
BEGIN (* Remote_dbbegin *) 
        stat_buf_ptr := nil;  (* in case of bad mode *)         temp_ibase := ibase;          CASE mode OF         1: base := ibase[one];            3: IF ibase[one] <= max_db              THEN base := ibase[2]   %            ELSE IF make_ibase_list (ibase, temp_ibase, istat.beg.status)  %                THEN GOTO 999                 ELSE base := temp_ibase[2];            OTHERWISE BEGIN            istat.beg.status := invalid_mode_err;  	         GOTO 999; 	          END;         END;             IF multi_db_pointers (base,         (* given *)                           dbbuf_ptr,    (* returned *)                            mesg_buf_ptr,                           run_table_ptr,                            stat_buf_ptr,                           istat.beg.status)  
      THEN GOTO 999; 
            IF (stat_buf_ptr <> nil)         THEN start_time := get_start_time;         node_num := run_table_ptr^.db_node;         IF (mode = 1) THEN BEGIN         IF (run_table_ptr^.transaction_id <> zero) THEN BEGIN            istat.beg.status := xaction_in_progress_err;   	         GOTO 999; 	          END;       %      transaction_base_formatter (zero, node_num, dbbuf_ptr, temp_ibase);  %       END; (* then *)          (**)      (* Make sure all specified db's are valid and that      (* none are part of a transaction.      (**)          IF transaction_checker (dbbegin_calling,                              node_num,                             dbbuf_ptr,                              temp_ibase,                             istat.beg.status)        THEN GOTO 999; (* if error occurs *)                 (**)   !   (* This is a remote call... Send the message and receive reply. !    (**)          (* Set up specific beg message fields *)      (**)      (* Call text string processor to word-align and blank-fill.     (**)          IF process_text_str (itext,                          text_len,                           lvl_set_itm[one],                           istat.beg.status)   
      THEN GOTO 999; 
         #   (* We send the text, we don't expect anything except ISTAT back *)  #        IF send_receive_message (temp_ibase, mode3, lvl_set_itm,   !                            itext.word_str[one], lvl_set_itm[one], !                             junk_buf, zero,                               db_begin, istat)  
      THEN GOTO 999; 
            save_transaction := istat.beg.xaction_num;       !   (* Strip the RDBAP clone id off of the ibase-list first word *) !    (* We want the low order byte *)   $   temp_ibase[one] := temp_ibase[one] - ((temp_ibase[one] DIV 256)*256); $        (* update dbbuf table *)      WITH dbbuf_ptr^ DO      FOR i := one TO temp_ibase[one] DO      WITH db_run_table[temp_ibase[i+one]]^ DO BEGIN         transaction_id := save_transaction;         multi_db_count := temp_ibase[one];        END;      999: (* abnormal termination exit *)         IF (stat_buf_ptr <> nil)         THEN WITH stat_buf_ptr^.call_stats[db_begin] DO BEGIN             (**)        (* do any final stats for DBBEG.        (**)        calls_made   := calls_made + one;   !      elapsed_time := elapsed_time + get_elapsed_time(start_time); !       cpu_time := elapsed_time - wait_time;             END; (* then *)       
END; (* Remote_DBBEGIN *)  
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure Remote_DBCLOSE                                          *)  $ $(*                                                                   *)  $ $(* purpose:                                                          *)  $ $(*    To close the specified remote database.   Any dynamic memory   *)  $ $(*    used for this run table is released to the memory pool, such   *)  $ $(*    as the run table buffer, the message buffer (as necessary),    *)  $ $(*    and the statistics buffer if statistics were enabled.          *)  $ $(*                                                                   *)  $ $(* input  : (1) The ibase parameter of the database to close.        *)  $ $(*          (2) ID of set to close. (Backward compatibility).        *)  $ $(*          (3) Mode. (1 or 2)                                       *)  $ $(*          (4) Status array.                                        *)  $ $(*                                                                   *)  $ $(* returns: (1) status (0 if successful, else IMAGE error number)    *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE Remote_DBCLOSE   $ Alias 'RBCLS' $     (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;          mode   : short_int;       VAR istat  : return_buffer_type);       LABEL 999;      VAR      save_ibase  : short_int;          run_table : ptr_local_run_table_hdr;      dbbuf_table : ptr_dbbuf_table;      stat_buf_ptr: statistics_buffer_ptr_type;      
   set_number : short_int; 
    dscb_ptr   : remote_set_table_entry_ptr_type;      
   junk_buf   : short_int; 
    lvl_set_itm: level_set_itm_type;          to_mesg_buf: remote_msg_buf_ptr_type;     new_max_msg_size : short_int;  
   avail, i   : short_int; 
 
   dummy      : short_int; 
     
BEGIN (* Remote_DBCLOSE *) 
        (**)      (* Get the database pointers.     (**)          IF get_database_pointers (ibase,       (* given *)                                dbbuf_table, (* returned *)                               to_mesg_buf,                                run_table,                                stat_buf_ptr,                               istat.cls.status)  
      THEN GOTO 999; 
         "   (*Statistics not needed since the buffer is going to be removed*) "            (* Is a transaction in progress for this database? *)     IF (run_table^.transaction_id <> zero) THEN BEGIN        istat.cls.status := transaction_violation_err;        GOTO 999;         END;         (* Make sure the mode is 1 or 2 *)      istat.cls.status := zero;     IF (mode <> 1) AND (mode <> 2) THEN BEGIN        istat.cls.status := invalid_mode_err;         GOTO 999;         END;      
   IF mode = 2 THEN BEGIN  
       IF find_set (set_id, run_table, set_number,                           dscb_ptr, istat.cls.status)            THEN GOTO 999;   !      istat.cls.status := no_image_err; (* mode 2 does nothing *)  !       GOTO 999;   
      END; (* mode = 2 *)  
        (* Send along the remote close request to RDBAM *)          IF send_receive_message (ibase, mode, lvl_set_itm,                               junk_buf, zero,                               junk_buf, zero,                               db_close, istat)  
      THEN GOTO 999; 
         (* Zero out the entry for this db in the maximum msg table *)      dbbuf_table^.max_mesg_len[ibase[one]] := zero;          (**)   !   (* Determine if the current message buffer needs to be removed  !    (* and a smaller one allocated.     (**)          new_max_msg_size := zero;         WITH dbbuf_table^ DO BEGIN         FOR i := one TO max_db DO         IF max_mesg_len[i] > new_max_msg_size            THEN new_max_msg_size := max_mesg_len[i];            IF (cur_mesg_len > new_max_msg_size) THEN BEGIN                (**)            (* Release the old message buffer.            (**)            DBRBF (mesg_ptr_tbl_index,                   istat.cls.status);           IF (istat.cls.status <> zero) THEN GOTO 999;                cur_mesg_len := zero;               (**)            (* allocate the new message buffer if necessary.            (**)                IF (new_max_msg_size > zero) THEN BEGIN              DBGBF (mesg_ptr_tbl_index, new_max_msg_size,                     avail, istat.cls.status);              IF (istat.cls.status <> zero) THEN GOTO 999;                  cur_mesg_len := new_max_msg_size;                   END; (* allocate smaller message buffer *)           END; (* make message buffer smaller *)         END; (* with dbbuf_table *)          (* Restore the original ibase parameter *)      save_ibase := run_table^.db_node;      "   (* Remove the run table. To do so, we need the local database  *) " "   (* number which is also the index into the runtable pointer    *) " "   (* table.  If a statistics buffer was allocated, it to is      *) " "   (* released to the dynamic memory area.                        *) "        DBRBF (ibase[one], istat.cls.status);     IF istat.cls.status <> no_image_err THEN GOTO 999;          (* Deallocate the statistics buffer *)      IF (stat_buf_ptr <> nil) THEN BEGIN        DBRBF (max_db + one + ibase[one], istat.cls.status);        IF istat.cls.status <> no_image_err THEN GOTO 999;        END;         (* Decrement the open count *)      WITH dbbuf_table^ DO BEGIN         open_count := open_count - one;             ibase[one] := save_ibase;             (* Finally, if this is the last data base closed, *)        (* remove the remote session.                     *)      
      IF open_count = zero 
          THEN logoff_remote_session (dummy, ibase);             END; (* with *)          ibase[one] := save_ibase;      999: (* abnormal termination exit *)      
END; (* remote_DBCLOSE *)  
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure Remote_DBCONTROL                                        *)  $ $(*                                                                   *)  $ $(* purpose:                                                          *)  $ $(*    To send dbcontrol request to a remote node.                    *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) dummy parameter.                                           *)  $ $(*    (3) mode. (1,2,5,6).                                           *)  $ $(*    (4) Status array.                                              *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE remote_dbcontrol  $ Alias 'RBCTL' $      (VAR ibase : ibase_type;   
    VAR dummy : short_int; 
 
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);      LABEL 999;  (* abnormal termination exit *)       CONST   
   stat_buffer_len = 512;  
     VAR          mesg_buf  : remote_msg_buf_ptr_type;      run_table : ptr_local_run_table_hdr;      dbbuf_table : ptr_dbbuf_table;      stats_buf : statistics_buffer_ptr_type;         available_memory : short_int;     start_time       : long_int;          lvl_set_itm : level_set_itm_type;     junk_buf    : short_int;           BEGIN (* dbcontrol *)          (**)      (* Get database pointers.     (**)          IF get_database_pointers (ibase,                                dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.ctl.status)  
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;             WITH run_table^.indicators DO BEGIN            (* preset return status for good return *)        istat.ctl.status := no_image_err;       	      CASE mode OF 	     
         1,2 : BEGIN END;  
              (* Turn on collection of IMAGE statistics *)   	         5 : BEGIN 	             IF (stats_buf = nil) THEN BEGIN                      (* Try to allocate a statistics buffer. *)   %               DBGBF (max_db+one+ibase[one], (* 21=offset to stat table *) %                       stat_buffer_len,                        available_memory,                         istat.ctl.status);                     IF (istat.ctl.status <> zero) THEN BEGIN                     istat.ctl.status := no_more_space_err;                    GOTO 999;                     END; (* then *)                      statistics := true;                     stats_buf :=                       dbbuf_table^.statistics_table[ibase[one]];                     (* Initialize the statistics buffer *)                      fill_with_value (words_in_statistics_buffer,                                   stats_buf^,                                   zero);                     (* Avoid taking stats in this module *)                 stats_buf := nil;                     END; (* then *)              END; (* case mode 5 *)                   (* Turn off statistics gathering *)  	         6 : BEGIN 	             IF (stats_buf <> nil) THEN BEGIN                     (* Deallocate the statistics buffer *)   %               DBRBF (max_db+one+ibase[one], (* 21=offset to stat table *) %                       istat.ctl.status);                     IF (istat.ctl.status <> zero) THEN BEGIN                     istat.ctl.status := db_corrupt_err;                     GOTO 999;                     END; (* then *)                      stats_buf := nil;                     statistics := false;                      END; (* then *)              END; (* case mode 6 *)      	         OTHERWISE 	             istat.ctl.status := invalid_mode_err;       
         END;  (* case *)  
           END; (* WITH *)              (**)      (* Things are set up properly on this end.  Send the      (* request to the remote node.      (**)          IF send_receive_message (ibase, mode, lvl_set_itm,                               junk_buf, zero,                               junk_buf, zero,                               db_control, istat) THEN BEGIN   !      (* Error occurred: If we allocated a stat buf, release it *) !       IF (mode = 5) THEN BEGIN           (* Deallocate the statistics buffer *)   "         DBRBF (max_db+one+ibase[one], (* 21=offset to stat table *) "                 istat.ctl.status);               IF (istat.ctl.status <> zero) THEN GOTO 999;       
         stats_buf := nil; 
              run_table^.indicators.statistics := false;   
         END; (* mode=5 *) 
       GOTO 999;         END; (* then error occurred sending message *)          999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_control] DO BEGIN           calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;               END;       END; (* remote_DBCONTROL *)   $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* PROCEDURE Remote_DBDELETE                                        *) # #(*                                                                  *) # #(* purpose : This procedure handles  the syntax checking and        *) # #(*           buffer manager (DBMON) communication requirements      *) # #(*           of the DBDEL intrinsic.                                *) # #(*                                                                  *) # #(* input :   (1) ibase parameter.                                   *) # #(*           (2) set identifier.                                    *) # #(*           (3) mode. (must be 1)                                  *) # #(*           (4) istat array.                                       *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE Remote_DBDELETE  $ Alias 'RBDEL' $     (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type);       LABEL 999;      VAR      run_table : ptr_local_run_table_hdr;      mesg_buf  : remote_msg_buf_ptr_type;      dbbuf_table : ptr_dbbuf_table;      stat_buf  : statistics_buffer_ptr_type;      
   set_number : short_int; 
    dscb_entry : remote_set_table_entry_ptr_type;  #   return_length : short_int;    (* len of info returned from dbmon *) #     
   start_time : long_int;  
 
   junk_buf   : short_int; 
    lvl_set_itm: level_set_itm_type;       
BEGIN (* DBDELETE *) 
        (**)      (* Get database pointers.     (**)          IF get_database_pointers (ibase,                                dbbuf_table,                                mesg_buf,                               run_table,                                stat_buf,                               istat.del.status)  
      THEN GOTO 999; 
        IF (stat_buf <> nil)         THEN start_time := get_start_time;      "   (* Validify the data set name/number.  If it is valid, we are *)  " "   (* returned the data set number and the data set control block*)  " "   (* entry offset (relative to the start of the run table).     *)  "        IF find_set (set_id, run_table, lvl_set_itm[one],                  dscb_entry, istat.del.status)   
      THEN GOTO 999; 
        IF send_receive_message (ibase, mode, lvl_set_itm,                               junk_buf, zero,                               junk_buf, zero,                               db_delete, istat)   
      THEN GOTO 999; 
     999: (* abnormal termination exit *)         IF (stat_buf <> nil)         THEN WITH stat_buf^.call_stats[db_delete] DO BEGIN           calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       
END; (* remote_dbdelete *) 
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure Remote_DBEND                                            *)  $ $(*                                                                   *)  $ $(* purpose: To end a transaction for all databases on a particular   *)  $ $(*          node, using the ibase param to determine which node.     *)  $ $(*                                                                   *)  $ $(* parameters:                                                       *)  $ $(*    (1) ibase parameter.                                           *)  $ $(*    (2) user text to include in DBEND log record.                  *)  $ $(*    (3) mode (must be 1)                                           *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) user text length.                                          *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE remote_dbend  $ Alias 'RBEND' $      (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len  : short_int);       LABEL 999;      CONST      not_dbbegin = false;  (* for transaction_checker *)     mode3 = 3; (* we always pass an IBASE-LIST remotely *)       VAR      temp_ibase  : ibase_type;         run_table : ptr_local_run_table_hdr;      to_mesg_buf : remote_msg_buf_ptr_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf   : statistics_buffer_ptr_type;         i            : short_int;     start_time   : long_int;      lvl_set_itm  : level_set_itm_type;      junk_buf     : short_int;     base         : short_int;      BEGIN (* Remote_dbend *)      
   (* Legal mode? *) 
    stats_buf := nil;  (* in case of mode error *)          temp_ibase := ibase;          CASE mode OF         1: base := ibase[one];        3: IF ibase[one] <= max_db              THEN base := ibase[2]   %            ELSE IF make_ibase_list (ibase, temp_ibase, istat.endb.status) %                THEN GOTO 999                 ELSE base := temp_ibase[2];            OTHERWISE BEGIN            istat.endb.status := invalid_mode_err;   	         GOTO 999; 	          END;         END;             IF multi_db_pointers (base,                           dbbuf_table,                            to_mesg_buf,                            run_table,                            stats_buf,                            istat.endb.status)   
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;             (**)      (* Is there a transaction in progress?      (**)          WITH run_table^ DO BEGIN         IF (mode = one)            THEN transaction_base_formatter (transaction_id,                                             db_node,                                            dbbuf_table,                                            temp_ibase);            IF transaction_checker (not_dbbegin,                                db_node,                                dbbuf_table,                                temp_ibase,                                 istat.endb.status)           THEN GOTO 999;             END; (* with *)          IF Process_text_str (user_text,                          text_len,                           lvl_set_itm[one],                           istat.endb.status)  
      THEN GOTO 999; 
        IF send_receive_message (temp_ibase, mode3, lvl_set_itm,   #                            user_text.word_str[one], lvl_set_itm[one], #                             junk_buf, zero,                               db_end, istat)  
      THEN GOTO 999; 
     #   (* Strip the RDBAP clone id off the first word of the ibase-list *) # %   (* Do not use MOD as that brings in the pascal runtime error handler *) % $   temp_ibase[one] := temp_ibase[one] - ((temp_ibase[one] DIV 256)*256); $        (* Set specified DBs' transaction ID's to zero *)     WITH dbbuf_table^ DO      FOR i := one TO temp_ibase[one] DO      WITH db_run_table[temp_ibase[i+1]]^ DO BEGIN         transaction_id := zero;         multi_db_count := zero;         END;      999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_end] DO BEGIN           calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       END; (* remote_dbend *)   $ Page $  "(*****************************************************************)  " "(*                                                               *)  " "(* PROCEDURE Remote_DBFIND                                       *)  " "(*                                                               *)  " "(* purpose :                                                     *)  " "(*    To find the head, tail and length of a chain of detail     *)  " "(*    records.  The record numbers are returned to the caller.   *)  " "(*                                                               *)  " "(* Parameters:                                                   *)  " "(*    (1) ibase.                                                 *)  " "(*    (2) set id. (must be a detail)                             *)  " "(*    (3) mode. (must be 1)                                      *)  " "(*    (4) istat array.                                           *)  " "(*    (5) detail's key item for the chain.                       *)  " "(*    (6) key item value to find a chain for.                    *)  " "(*                                                               *)  " "(*****************************************************************)  "     PROCEDURE dbfind  $ Alias 'RBFND' $      (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type;      VAR item_id: item_set_name_type;      VAR item_value : item_value_type);      LABEL 999;      VAR      run_table : ptr_local_run_table_hdr;      dbbuf_table : ptr_dbbuf_table;      stats_buf : statistics_buffer_ptr_type;         item_number : short_int;        (* 'key' item number *)  $   item_entry_offset : short_int;  (* offset from start of run table *)  $    item_entry : remote_item_table_entry_ptr_type;      set_number : short_int;         (* 'detail' set number *)     dscb_entry : remote_set_table_entry_ptr_type;         start_time: long_int;      
   junk_buf  : short_int;  
    to_rdbam_len : short_int;     lvl_set_itm  : level_set_itm_type;      mesg_buf     : remote_msg_buf_ptr_type;          	BEGIN (* DBFIND *) 	        (**** get the database pointers ****)         IF get_database_pointers (ibase,                                dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.fnd.status)  
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;      !   (* Validify the set reference, returning the set number and *)  ! !   (* the offset to the data set control block table entry.    *)  !     IF find_set (set_id, run_table, lvl_set_itm[one], dscb_entry,                   istat.fnd.status)   
      THEN GOTO 999; 
     "   (* Validify the item name/number.  Return the item number and  *) " "   (* offset to the item table entry.                             *) "        IF find_item (item_id, run_table, lvl_set_itm[2],                   item_entry, istat.fnd.status)  
      THEN GOTO 999; 
            IF (mode <> one) THEN BEGIN        istat.fnd.status := invalid_mode_err;         GOTO 999;         END; (* THEN *)              (* Send the remote message *)         IF send_receive_message (ibase, mode, lvl_set_itm,   !                            item_value[one], item_entry^.item_len, !                             junk_buf, zero,                               db_find, istat)   
      THEN GOTO 999; 
     999:  (* error return label *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_find] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       END; (* remote_dbfind *)  $ Page $  %(***********************************************************************)  % %(*                                                                     *)  % %(*  PROCEDURE Remote_DBGET                                             *)  % %(*                                                                     *)  % %(*  Purpose :  This routine perform the syntax checking and            *)  % %(*             communications to DBMON for the DBGET intrinsic.        *)  % %(*                                                                     *)  % %(* Parameters:                                                         *)  % %(*    (1) ibase.                                                       *)  % %(*    (2) set id.                                                      *)  % %(*    (3) mode. (1-7)                                                  *)  % %(*    (4) istat array.                                                 *)  % %(*    (5) item list.                                                   *)  % %(*    (6) return buffer.                                               *)  % %(*    (7) argument (used for modes 4 and 7).                           *)  % %(*                                                                     *)  % %(*  Returns :  (6) buffer of item values, corresponding to the items   *)  % %(*                   as listed in the item list buffer.                *)  % %(*             (4) return status buffer                                *)  % %(*                 - status (0 if successful)                          *)  % %(*                 - return item values buffer length                  *)  % %(*                 - current record number                             *)  % %(*                 - previous record number (mode 5 only)              *)  % %(*                 - next record number  (mode 5 only)                 *)  % %(*                                                                     *)  % %(***********************************************************************)  %     PROCEDURE Remote_DBGET  $ Alias 'RBGET' $      (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR item_values_buffer : data_record_type;      VAR user_argument : argument_type);           LABEL 999;      VAR      run_table : ptr_local_run_table_hdr;      mesg_buf  : remote_msg_buf_ptr_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf : statistics_buffer_ptr_type;      
   set_number : short_int; 
    dscb_entry : remote_set_table_entry_ptr_type;  	   ix : short_int; 	 
   start_time : long_int;  
        to_rdbam_len : short_int;     lvl_set_itm  : level_set_itm_type;               BEGIN (* Remote_DBGET *)         IF get_database_pointers (ibase,                                dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.get.status)  
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;      #   (* Check the validity of the set name/number.  If valid, the     *) # #   (* routine 'set_getter' will return the set number and offset    *) # #   (* to the data set control block (relative to the beginning      *) # #   (* of the run table).  If not valid, an IMAGE error is returned. *) #         IF find_set (set_id, run_table, lvl_set_itm[one], dscb_entry,                     istat.get.status)   
      THEN GOTO 999; 
         (* Parse the item list.  This builds an item number list  *)        (* in the message buffer.                                 *)        $   IF process_remote_item_list (lvl_set_itm[one], item_list, run_table,  $                                 to_rdbam_len, lvl_set_itm[2],                                   istat.get.status)   
      THEN GOTO 999; 
        (**)      (* For modes 4 and 7 we need to send more data besides       (* just the item list.  For mode 4 there is a record number,       (* for mode 7 there is the argument.      (**)          CASE mode OF         4: BEGIN           (* append record number to end of item list *)            move_value (user_argument,                        mesg_buf^[to_rdbam_len+one],                        2);           to_rdbam_len := to_rdbam_len + 2;           END;             7: BEGIN           (* append user's key value to end of item list *)           move_value (user_argument,                        mesg_buf^[to_rdbam_len+one],                        dscb_entry^.key_len);           to_rdbam_len := to_rdbam_len + dscb_entry^.key_len;           END;             OTHERWISE;            END; (* CASE *)              IF send_receive_message (ibase, mode, lvl_set_itm,                               mesg_buf^[one], to_rdbam_len,   #                            item_values_buffer[zero], lvl_set_itm[2],  #                             db_get, istat)  
      THEN GOTO 999; 
     999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_get] DO BEGIN           calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       END; (* Remote_DBGET *)   $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure Remote_DBINFO                                          *)  $ $(*                                                                   *)  $ $(*  purpose : This procedure references the local run table          *)  $ $(*            to return information  on the structure and current    *)  $ $(*            state of the data base.  It also references DBMON      *)  $ $(*            to return information on the log status.  The          *)  $ $(*            type of information returned is based on the value     *)  $ $(*            of the mode parameter.                                 *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) set/item id.                                               *)  $ $(*    (3) mode.                                                      *)  $ $(*    (4) istat.                                                     *)  $ $(*    (5) buffer for information.                                    *)  $ $(*                                                                   *)  $ $(*  returns : (1) return_status[1] is the status (0:successful)      *)  $ $(*                return_status[2] is the length of the info in      *)  $ $(*                                 return_buffer.                    *)  $ $(*                return_buffer has various information, dependent   *)  $ $(*                                 upon the mode.                    *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE Remote_dbinfo   $ Alias 'RBINF' $      (VAR ibase : ibase_type;       VAR data_id : item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR buffer : return_buffer_type);       LABEL 999;      VAR      loop : call_types;          run_table : ptr_local_run_table_hdr;      mesg_buf  : remote_msg_buf_ptr_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf : statistics_buffer_ptr_type;     start_time: long_int;         dscb_entry : remote_set_table_entry_ptr_type;     ittb_ptr   : remote_item_table_entry_ptr_type;          to_rdbam_len : short_int;     from_rdbam_len : short_int;     lvl_set_itm  : level_set_itm_type;       BEGIN (* info *)         IF get_database_pointers (ibase,                                dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.inf.status)  
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;             (**)      (* Determine the validity of the set or item for the      (* appropriate modes.     (**)          CASE mode OF             101, 102, 204 :            IF find_item (data_id, run_table, lvl_set_itm[one],                         ittb_ptr, istat.inf.status)  
            THEN GOTO 999; 
           104, 201, 202, 301, 302, 401, 402 :            IF find_set (data_id, run_table, lvl_set_itm[one],                         dscb_entry, istat.inf.status)   
            THEN GOTO 999; 
           OTHERWISE;            END; (* case *)              (* Determine the length of the reply buffer *)      CASE mode OF             101, 201 : from_rdbam_len := one;             102 : from_rdbam_len := 13;             103 : from_rdbam_len := 256;            104 : from_rdbam_len := 128;            202 : from_rdbam_len := 17;             203, 204 : from_rdbam_len := 51;            301 : from_rdbam_len := 49;             302 : from_rdbam_len := 2;            401 : from_rdbam_len := 7;            402 : from_rdbam_len := 0;            505, 506 : from_rdbam_len := 512;             801 : from_rdbam_len := 4;            OTHERWISE BEGIN            istat.inf.status := illegal_info_mode_err;   	         GOTO 999; 	          END;         END; (* case *)       	   IF (mode = 402) 	       THEN to_rdbam_len := 7        ELSE to_rdbam_len := zero;             IF send_receive_message (ibase, mode, lvl_set_itm,                               buffer.inf.status, to_rdbam_len,                              buffer.inf.status, from_rdbam_len,                              db_info, istat)   
      THEN GOTO 999; 
         IF (mode = 505) OR (mode = 506) THEN BEGIN (* handle stats *)             (**)  !      (* We need to add the stats we've saved on the master node,  !        (* particularly the total elapsed time and total cpu time.   $      (* Because the master side does no I/O, we need not work with it.  $       (**)            WITH buffer.m50x.call_stats[db_summary] DO BEGIN           calls_made   := zero;           elapsed_time := zero;           cpu_time     := zero;           io_count     := zero;           io_time      := zero;           wait_time    := zero;           service_time := zero;           END;             FOR loop := db_begin TO db_update DO        WITH buffer.m50x.call_stats[loop], stats_buf^ DO BEGIN           calls_made   := call_stats[loop].calls_made;            elapsed_time := call_stats[loop].elapsed_time;            wait_time    := call_stats[loop].wait_time -                                cpu_time - io_time;           cpu_time     := call_stats[loop].cpu_time + cpu_time;           END;             FOR loop := db_begin TO db_update DO  
      WITH buffer.m50x DO  
          sum_up_intrinsic_stats               (call_stats[db_summary],               call_stats[loop],               number_of_intrinsic_statistics);                 IF (mode = 506)            THEN fill_with_value (words_in_statistics_buffer,                                 stats_buf^,                                 zero);             END; (* if returning statistics *)      999: (* error exit *)          IF (istat.inf.status = illegal_set_ref_err) OR         (istat.inf.status = illegal_item_ref_err) THEN        istat.inf.status := bad_item_or_set_err;         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_info] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       END; (* remote_dbinfo *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure Remote_DBLOCK                                           *)  $ $(*                                                                   *)  $ $(* purpose:                                                          *)  $ $(*    To lock a database, data set or multiple data sets, with or    *)  $ $(*    without wait.                                                  *)  $ $(*                                                                   *)  $ $(* parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) dummy (modes 1,2), set or sets (modes 3-8).                *)  $ $(*    (3) mode.                                                      *)  $ $(*    (4) istat array.                                               *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION Remote_dblock  $ Alias 'RBLCK' $      (VAR ibase : ibase_type;       VAR lock_request : lock_request_buffer;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type) : short_int;      LABEL 999; (* error exit *)       CONST      words_in_pred_lock = 9; (* length of predicate lock *)      max_to_rdbam_len = max_data_sets*words_in_pred_lock + one;   !   max_chars_in_set_list = max_data_sets*(chars_in_set_name+one);  !     VAR      set_name    : item_set_name_type;     to_rdbam_len: short_int;      lvl_set_itm : level_set_itm_type;     char_ptr    : ptr_lock_char_buf;      char_pos    : short_int;      end_found : boolean;          run_table : ptr_local_run_table_hdr;      req_mesg_buf : remote_msg_buf_ptr_type;     dbbuf_table  : ptr_dbbuf_table;     stats_buf    : statistics_buffer_ptr_type;      start_time   : long_int;          junk_buf     : short_int;     i            : short_int;     dscb_entry   : remote_set_table_entry_ptr_type;      	BEGIN (* dblock *) 	        remote_dblock := 0;  (* Assume an error will occur *)         IF get_database_pointers (ibase,                                dbbuf_table,                                req_mesg_buf,                               run_table,                                stats_buf,                                istat.lck.status)  
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;         (* preset return status for good return *)      istat.lck.status := no_image_err;         (* build lock table subentries *)     CASE mode OF             1, 2 : to_rdbam_len := zero;            3, 4 : BEGIN (* data set lock with/without wait *)               FOR i := one TO 3 DO               set_name.words[i] := lock_request[i];                (* calculate set identifier address *)            IF find_set (set_name, run_table, lvl_set_itm[one],                        dscb_entry, istat.lck.status)   
            THEN GOTO 999; 
              to_rdbam_len := zero;               END;             5, 6 : BEGIN (* predicate locks w/wo wait *)                (* 9 words per lock descriptor plus # of descriptors *)            to_rdbam_len := lock_request[one]*9 + one;       "         IF (to_rdbam_len <= 0) OR (to_rdbam_len > max_to_rdbam_len) "             THEN BEGIN  $               istat.lck.status := invalid_num_of_lock_descriptors_err;  $                GOTO 999;  
               END;  
          END; (* case of lock descriptors *)                7, 8 : BEGIN (* list of data sets to lock *)      '         IF (lock_request[one] <= max_data_sets) THEN BEGIN (* number list *)  '             IF (lock_request[one] <= 0) THEN BEGIN                 istat.lck.status := illegal_set_ref_err;                  GOTO 999;  
               END;  
                 to_rdbam_len := lock_request[one] + one;              END                ELSE BEGIN (* set name list *)                   char_ptr := make_request_buf_ptr (lock_request);              char_pos := one;              end_found := false;                   WHILE (NOT end_found) OR                    (char_pos > max_chars_in_set_list) DO                      IF (char_ptr^[char_pos] = ';') OR                    (char_ptr^[char_pos] = ' ')                     THEN end_found := true                    ELSE char_pos := char_pos + one;                      IF (end_found) THEN BEGIN                  istat.lck.status := illegal_set_ref_err;                  GOTO 999;  
               END;  
                 to_rdbam_len := (char_pos+one) DIV chars_in_word;                   END; (* else set name list *)                END; (* case of set list *)            OTHERWISE BEGIN (* unknown mode *)           istat.lck.status := invalid_mode_err;  	         GOTO 999; 	 
         END; (* BEGIN *)  
           END;  (* case *)             (* Runtable open modes of 3 and 8 are ignored *)      IF (run_table^.open_mode = 8) OR (run_table^.open_mode = 3)  
      THEN GOTO 999; 
        IF send_receive_message (ibase, mode, lvl_set_itm,                               lock_request[one], to_rdbam_len,                              junk_buf, zero,                               db_lock, istat)   
      THEN GOTO 999; 
        remote_dblock := -1;  (* Send back FTN77 'true' *)       999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_lock] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       END; (* Remote_DBLOCK *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure Remote_DBMEMO                                           *)  $ $(*                                                                   *)  $ $(* purpose: To place a user-specified comment in the log file.       *)  $ $(*                                                                   *)  $ $(* parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) user text.                                                 *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) user text length.                                          *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE Remote_dbmemo   $ Alias 'RBMEM' $      (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len : short_int);      LABEL 999;      CONST      not_dbbegin = false;      mode3 = 3; (* we always pass an IBASE-LIST remotely *)       VAR      base        : short_int;      temp_ibase  : ibase_type;         run_table   : ptr_local_run_table_hdr;      to_mesg_buf : remote_msg_buf_ptr_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf   : statistics_buffer_ptr_type;  
   start_time  : long_int; 
        lvl_set_itm : level_set_itm_type;     junk_buf    : short_int;       
BEGIN (* remote_dbmemo *)  
     
   stats_buf := nil; 
            temp_ibase := ibase;          CASE mode OF         1: base := ibase[one];        3: IF ibase[one] <= max_db              THEN base := ibase[2]   %            ELSE IF make_ibase_list (ibase, temp_ibase, istat.mem.status)  %                THEN GOTO 999                 ELSE base := temp_ibase[2];            OTHERWISE BEGIN            istat.mem.status := invalid_mode_err;  	         GOTO 999; 	          END;         END;         IF multi_db_pointers (base,                           dbbuf_table,                            to_mesg_buf,                            run_table,                            stats_buf,                            istat.mem.status)  
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;         WITH run_table^ DO BEGIN         IF (mode = one)            THEN transaction_base_formatter (transaction_id,                                             db_node,                                            dbbuf_table,                                            temp_ibase);            IF transaction_checker (not_dbbegin,                                db_node,                                dbbuf_table,                                temp_ibase,                                 istat.mem.status)            THEN GOTO 999;         END;         (* Set up specific memo message fields *)         (**)      (* Call text string processor to word-align and blank-pad.      (**)          IF process_text_str (user_text,                          text_len,                           lvl_set_itm[one],                           istat.mem.status)   
      THEN GOTO 999; 
        IF send_receive_message (temp_ibase, mode3, lvl_set_itm,   #                            user_text.word_str[one], lvl_set_itm[one], #                             junk_buf, zero,                               db_memo, istat)   
      THEN GOTO 999; 
     999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_memo] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       END; (* remote_dbmemo *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure get_buffer_area                                        *)  $ $(*                                                                   *)  $ $(*  purpose : This procedure allocates a buffer for the run table.   *)  $ $(*                                                                   *)  $ $(*            It calls DBGBF to obtain a buffer area where the       *)  $ $(*            run table will be placed.  The routines DBGBF          *)  $ $(*            (get buffer) and DBRBF (Return buffer) updates a       *)  $ $(*            table of pointers (addresses) to the message and       *)  $ $(*            run table buffer areas.  This table resides in         *)  $ $(*            the global dbbuf table.                                *)  $ $(*                                                                   *)  $ $(*            The maximum size run table buffer size is requested    *)  $ $(*            first.  If that is not availabe, all the               *)  $ $(*            remaining space is allocated for the buffer.           *)  $ $(*                                                                   *)  $ $(*            If this is the first time an open is performed, then   *)  $ $(*            a message buffer is allocated.  The minimum size       *)  $ $(*            buffer needed for an user to dbmon open message, is    *)  $ $(*            allocated.  After DBMON returns information to         *)  $ $(*            us, OPENR will then allocate the proper size message   *)  $ $(*            buffer.                                                *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION GET_BUFFER_AREA  $ Alias 'Rmt.GetBuffers' $     ( VAR ibase : ibase_type;       VAR dbbuf_table : ptr_dbbuf_table;        VAR index_run_tbl : short_int;        VAR avail_run_table_buf_len : short_int;   (* returned *)       VAR status : short_int) : Boolean;       LABEL 999;      CONST   
   flag_open = zero; 
     VAR   "   error : short_int;   (* either zero or an error from proc call *) " !   avail : short_int;   (* largest block avail from background *)  !    request_len : short_int;       BEGIN (* get_buffer_area *)          get_buffer_area := true;  (* assume an error will occur *)          (**)      (* Assign a data base number for this run table.  This      (* number is also the index into the run table buffer  
   (* pointer table. 
    (**)       	   Status := zero; 	    DBFRT ( ibase[one], flag_open, index_run_tbl, status);      IF (status <> zero) THEN BEGIN        status := db_not_open_to_user_err;        GOTO 999;       END;          (**)      (* Get a slice of memory for the run table      (**)          (* assume we will get all we ask for *)         request_len := max_remote_run_table_size;     avail_run_table_buf_len := request_len;     DBGBF ( index_run_tbl, request_len,  avail, error);     IF (error <> zero) THEN BEGIN        IF (avail < min_remote_run_table_size) THEN BEGIN             status := no_more_space_err;  
          GOTO 999;  
           END         ELSE BEGIN (* get what there is *)            request_len := avail;             DBGBF (index_run_tbl, request_len, avail, error);             IF (error <> zero) THEN BEGIN                status := db_corrupt_err;               GOTO 999;  	             END;  	           (* return the amount of space we got *)             avail_run_table_buf_len := request_len;             END;  (* end else *)        END;  (* end if *)         get_buffer_area := false;      999 :       
   IF status <> zero 
       THEN index_run_tbl := zero;       
END; (* get_buffer_area *) 
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure Remote_DBOPEN                                          *)  $ $(*                                                                   *)  $ $(*  purpose : This routine determines if                             *)  $ $(*            (a) there is a transaction in progress                 *)  $ $(*            (b) the open mode is valid                             *)  $ $(*            (c) the run table and needed message buffer            *)  $ $(*                will fit in the program space                      *)  $ $(*            (d) obtains the user run table                         *)  $ $(*                (via communication with DBMON)                     *)  $ $(*            (e) calculates item read/write access                  *)  $ $(*            (f) calculates dataset accessibility                   *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) level word.                                                *)  $ $(*    (3) mode. (1,3,5,8)                                            *)  $ $(*    (4) istat.                                                     *)  $ $(*                                                                   *)  $ $(*  returns : (1) index into the buffer pointer table which contains *)  $ $(*                the current run table (is the same as the local    *)  $ $(*                data base number)                                  *)  $ $(*            (4) status buffer                                      *)  $ $(*                - status (zero if successful)                      *)  $ $(*                - level word number                                *)  $ $(*                - indicator if highest level was obtained          *)  $ $(*                - data base read/write access                      *)  $ $(*                - logging status                                   *)  $ $(*                                                                   *)  $ $(*  NOTE :    This routine updates                                   *)  $ $(*            (1) DBBUF table                                        *)  $ $(*            (2) Run table                                          *)  $ $(*                - header information                               *)  $ $(*                - item and set table access indicators             *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE Remote_dbopen   $ Alias 'RBOPN' $      (VAR ibase : ibase_type;           ilevl : level_set_itm_type;       VAR op_mode : short_int;      VAR istat : return_buffer_type);      LABEL 999,  (* error exit: no cleanup needed *)         888,  (* run table needs to be deallocated *)         777;  (* need to do a remote DBCLOSE *)       CONST       pid_len = words_in_prog_name + one + words_in_new_file_name;            TYPE     program_id_type = RECORD         program_name : prog_name;         open_count   : short_int;         root_name    : new_file_name;         END;         prog_and_int_type = RECORD         CASE short_int OF            1: (int : short_int);           2: (pid : program_id_type);        END;      VAR      to_rdbam_len : short_int;     junk_buf     : short_int;         ds_opn_items_ptr : ds_opn_items_ptr_type;     ds_opn_sets_ptr  : ds_opn_sets_ptr_type;      mesg_buf     : remote_msg_buf_ptr_type;         dbbuf_table : ptr_dbbuf_table;      stats_buf   : statistics_buffer_ptr_type;     cur_mesg_area_size : short_int;     cur_run_table_index : short_int;       %   run_table : ptr_local_run_table_hdr;    (* pointer to user run table *) % %   needed_mesg_area_size : short_int;    (* msg size needed for this db *) % "   avail : short_int;                    (* buffer size available *) "     !   (* variables used in determining set and items accessibility *) !     !   ix : short_int;                        (* index into tables *)  ! &   dscb_table : ptr_local_dscb;           (* data set control block table *) & "   item_table : ptr_local_item_table;     (* data set item table *)  " %   dscb_offset : short_int;         (* dscb offset from run table start *) %     #   avail_run_table_area_size : Short_int; (* memory for run table. *)  #        time_stamp    : date_and_time_type;     save_ibase1   : short_int;      max_rec_size  : short_int;          dummy_item    : item_set_name_type;     dummy_istat   : return_buffer_type;     dummy         : short_int;      prog_and_int  : prog_and_int_type;       
BEGIN (* remote_dbopen *)  
        cur_run_table_index := zero;          (**)      (* Get the significant characters of the level word  
   (* and pad with blanks. 
    (**)          save_ibase1 := ibase[one];          IF get_database_pointers (ibase,                                dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.opn.status)  !      THEN istat.opn.status := zero;  (* Ignore any error here. *) !        WITH dbbuf_table^ DO         IF (open_count = zero) THEN BEGIN            process_info.process_id := user_session_number;               IF (opsys <> rte6) AND               (process_info.process_id <> zero) THEN BEGIN              istat.opn.status := remote_prog_nonsystem_err;              GOTO 999;               END;               get_program_name (process_info.pname);                (**)            (* Create a 'random' number from the time of day            (* to be used as an identifier for this program.            (**)                get_timestamp (time_stamp);           WITH time_stamp DO   "            process_info.unique_num := second+(minute*8)+(hour*64);  "              END; (* if *)         istat.opn.status := no_image_err;   (* assume no error *)         (**)      (* Get as much background as possible for the run table.      (* DBMON will return the an error if it does not fit.     (* If it does fit, we trim off any excess space that was   
   (* preallocated.  
    (**)          cur_mesg_area_size := dbbuf_table^.cur_mesg_len;          IF get_buffer_area (ibase, dbbuf_table,                         cur_run_table_index,   "                       avail_run_table_area_size, istat.opn.status)  " 
      THEN GOTO 999; 
     $   (* Get the run table and message area addresses.  These addresses *)  $ $   (* were set up in 'get_buffer_area'.                              *)  $     %   Get_run_table_and_mesg_buf (cur_run_table_index, run_table, mesg_buf);  %        make_rmt_itm_tbl_ptr (run_table,                            local_headr_len,                            ds_opn_items_ptr);           (* Send to RDBAM the master name, open count and root name *)          WITH prog_and_int, dbbuf^ DO BEGIN         pid.program_name := process_info.pname;         pid.open_count   := open_count;   $      copy_root_name (ibase[2], pid.root_name, words_in_new_file_name);  $       END;         IF send_receive_message (ibase, op_mode, ilevl,                              prog_and_int.int, pid_len,                              ds_opn_items_ptr^.num_items,                              avail_run_table_area_size,                              db_open, istat)   
      THEN GOTO 888; 
         #   ibase[one] := cur_run_table_index;  (* Replace with local db num *) #        make_rmt_set_tbl_ptr         (ds_opn_items_ptr,          1 + (ds_opn_items_ptr^.num_items*remote_item_entry_len),           ds_opn_sets_ptr);         WITH run_table^ DO BEGIN   (* fill in run table header *)        transaction_id := zero;         multi_db_count := zero;         sys_dbnum      := ilevl[one];         db_node        := save_ibase1;        db_num         := cur_run_table_index;            WITH indicators DO BEGIN           remote := true;           posting:= true;           statistics := false;            END;             open_mode := op_mode;             WITH ds_opn_items_ptr^, ds_opn_sets_ptr^ DO BEGIN            rtbl_len  := local_headr_len +                         1 + (num_items*remote_item_entry_len) +                         1 + (num_sets*remote_set_entry_len);               set_count := num_sets;            set_off   := local_headr_len + 2 +                         (num_items * remote_item_entry_len);               itm_count := num_items;           END; (* with *)            itm_off   := local_headr_len + 1;              setsort  := zero; (* no sort table for remote run table *)         itmsort  := zero; (* ditto *)                 (* Trim off excess run table buffer space *)      $      trim_run_table (cur_run_table_index, rtbl_len, istat.opn.status);  $           IF (istat.opn.status <> zero)            THEN GOTO 777;             END; (* with run_table *)              (* Allocate the proper size message buffer *)     (* Most we will need is # of items + 1 + longest rec + 1 *)             needed_mesg_area_size := ds_opn_items_ptr^.num_items + 2;         (* Now find the longest data record *)      max_rec_size := zero;         WITH ds_opn_sets_ptr^ DO      FOR ix := one TO num_sets DO      WITH set_table[ix] DO     IF set_len > max_rec_size  THEN max_rec_size := set_len;       !   needed_mesg_area_size := needed_mesg_area_size + max_rec_size;  !         &   dbbuf_table^.max_mesg_len[cur_run_table_index] := needed_mesg_area_size;  &     #   (* If the current is not sufficient, then allocate larger buffer *) #    IF cur_mesg_area_size < needed_mesg_area_size THEN BEGIN       
      (* return old one *) 
       IF (cur_mesg_area_size > zero)           THEN DBRBF (mesg_ptr_tbl_index, istat.opn.status);             IF istat.opn.status <> zero THEN BEGIN           istat.opn.status := db_corrupt_err;  	         GOTO 777; 	          END;             (* Get the new larger buffer *)         DBGBF(mesg_ptr_tbl_index, needed_mesg_area_size,              avail, istat.opn.status);       !      (* If we could not get a larger one, get the old one back *) !       IF istat.opn.status <> zero THEN BEGIN           IF (cur_mesg_area_size > zero)                THEN DBGBF (mesg_ptr_tbl_index, cur_mesg_area_size,                            avail, istat.opn.status)              ELSE istat.opn.status := zero;           IF istat.opn.status <> zero              THEN istat.opn.status := db_corrupt_err               ELSE istat.opn.status := no_more_space_err;   	         GOTO 777; 	          END;  (* IF *)              (* We have successfully allocated a new message buffer.*)           (* Update the current message area size variable.      *)          cur_mesg_area_size := needed_mesg_area_size;        dbbuf_table^.cur_mesg_len := cur_mesg_area_size;            END; (* else get a new message buffer *)      #   (* Get the run table and message area addresses. These pointers *)  # #   (* need to be re-assigned since the allocation of a new buffer  *)  # #   (* may have compacted space and moved the buffers around.       *)  #     %   Get_run_table_and_mesg_buf (cur_run_table_index, run_table, mesg_buf);  %        (* All is well! *)      istat.opn.status := no_image_err;         WITH dbbuf_table^ DO BEGIN         (* update dbbuf open count *)          open_count := open_count + one;  (*increment open count *)         END; (* WITH *)          GOTO 999; (* Skip around error processing *)            777:  (* we had an error after successfully opening remotely *)           (* we need to do a remote close operation.             *)        #   (* will remove the run table automatically and replace ibase[1] *)  #    remote_dbclose (ibase, dummy_item, one, dummy_istat);     GOTO 999;           888:  (* We had an error after allocating a run table buffer *)           (* but did not do a remote dbopn.  Deallocat the buffer*)           DBRBF (cur_run_table_index, dummy);          999: (* abnormal termination exit *)         IF (istat.opn.status <> no_image_err)        THEN ibase[one] := save_ibase1;       END; (* remote_dbopen *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure Remote_DBPUT                                            *)  $ $(*                                                                   *)  $ $(* purpose : This procedure is responsible for the following         *)  $ $(*           portions of the database PUT intrinsic :                *)  $ $(*              (1) syntax checking                                  *)  $ $(*              (2) formatting of the information which DBMON        *)  $ $(*                  requires in order to execute the PUT.            *)  $ $(*              (3) communication with DBMON                         *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) set id.                                                    *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) item list.                                                 *)  $ $(*    (6) value list.                                                *)  $ $(*                                                                   *)  $ $(* returns: (4) status buffer                                        *)  $ $(*             -status (0: successful)                               *)  $ $(*             -length of the item value buffer                      *)  $ $(*             -the new record number                                *)  $ $(*             -the number of records on the chain                   *)  $ $(*             -the chain predecessor record number                  *)  $ $(*             -the chain successor record number                    *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbput  $ Alias 'RBPUT' $     (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR item_value_buffer : item_value_buffer_type);      LABEL 999;      CONST      two_blanks = '  ';       VAR      dbbuf_table : ptr_dbbuf_table;      run_table : ptr_local_run_table_hdr;      mesg_buf  : remote_msg_buf_ptr_type;      stats_buf : statistics_buffer_ptr_type;     start_time: long_int;         dscb_entry : remote_set_table_entry_ptr_type;     set_number : short_int;             (* data set number *)         to_rdbam_len : short_int;     junk_buf     : short_int;     lvl_set_itm  : level_set_itm_type;      ilist_len    : short_int;     data_len     : short_int;      BEGIN (* Remote_dbput *)         IF get_database_pointers (ibase,                                dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.put.status)  
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;         (* check the validity of the SET parameter *)     IF find_set (set_id, run_table, lvl_set_itm[one],                  dscb_entry, istat.put.status)   
      THEN GOTO 999; 
        (* Now process the item list.*)  $   IF process_remote_item_list (lvl_set_itm[one], item_list, run_table,  $                                 ilist_len, data_len,                                  istat.put.status)   
      THEN GOTO 999; 
     "   (* Move the user's value buffer into the remote message buffer *) "    move_value_buffer (item_value_buffer,                        mesg_buf^[ilist_len+1],                         data_len);         to_rdbam_len := ilist_len + data_len;         IF send_receive_message (ibase, mode, lvl_set_itm,                               mesg_buf^[one], to_rdbam_len,                               junk_buf, zero,                               db_put, istat)  
      THEN GOTO 999; 
         999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_put] DO BEGIN           calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       END; (* remote_dbput *)   $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure Remote_DBUNDO                                           *)  $ $(*                                                                   *)  $ $(* purpose: This routine performs the following data base transaction*)  $ $(*          undo functions.                                          *)  $ $(*                                                                   *)  $ $(*          (1) Performs syntax checking.                            *)  $ $(*          (2) Communicates with DBMON, requesting that a           *)  $ $(*              the current transaction be undone.                   *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) user text.                                                 *)  $ $(*    (3) mode (must be 1).                                          *)  $ $(*    (4) istat.                                                     *)  $ $(*    (5) text length.                                               *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE Remote_dbundo   $ Alias 'RBUND' $      (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len  : short_int);       LABEL 999;      CONST      not_dbbegin = false;      mode3 = 3; (* we always pass an IBASE-LIST remotely *)       VAR      temp_ibase  : ibase_type;         dbbuf_table : ptr_dbbuf_table;      run_table   : ptr_local_run_table_hdr;      to_mesg_buf : remote_msg_buf_ptr_type;      stats_buf   : statistics_buffer_ptr_type;  
   start_time  : long_int; 
     	   i : short_int;  	        junk_buf    : short_int;      lvl_set_itm : level_set_itm_type;     base        : short_int;       	BEGIN (* dbundo *) 	        stats_buf := nil;  (* in case of mode error *)          temp_ibase := ibase;          CASE mode OF         1: base := ibase[one];        3: IF ibase[one] <= max_db              THEN base := ibase[2]   %            ELSE IF make_ibase_list (ibase, temp_ibase, istat.und.status)  %                THEN GOTO 999                 ELSE base := temp_ibase[2];            OTHERWISE BEGIN            istat.und.status := invalid_mode_err;  	         GOTO 999; 	          END;         END;         IF multi_db_pointers (base,                           dbbuf_table,                            to_mesg_buf,                            run_table,                            stats_buf,                            istat.und.status)  
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;         WITH run_table^ DO BEGIN         IF (mode = one)            THEN transaction_base_formatter (transaction_id,                                             db_node,                                            dbbuf_table,                                            temp_ibase);            IF transaction_checker (not_dbbegin,                                db_node,                                dbbuf_table,                                temp_ibase,                                 istat.und.status)            THEN GOTO 999;             END; (* with *)          (**)      (* Process text string to word-align and blank-pad.     (**)          IF process_text_str (user_text,                          text_len,                           lvl_set_itm[one],                           istat.und.status)   
      THEN GOTO 999; 
        IF send_receive_message (temp_ibase, mode3, lvl_set_itm,   #                            user_text.word_str[one], lvl_set_itm[one], #                             junk_buf, zero,                               db_undo, istat)   
      THEN GOTO 999; 
     #   (* Strip of the RDBAP clone id from the first word of ibase-list *) # $   (* Do not use MOD as it brings in the Pascal runtime error handler *) $ $   temp_ibase[one] := temp_ibase[one] - ((temp_ibase[one] DIV 256)*256); $            (* Zero out all trans ID's belonging to this transaction *)         WITH dbbuf_table^ DO      FOR i := one TO temp_ibase[one] DO      WITH db_run_table[temp_ibase[i+one]]^ DO BEGIN         transaction_id := zero;         multi_db_count := zero;         END;      999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_undo] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       END; (* remote_dbundo *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure Remote_DBUNLOCK                                         *)  $ $(*                                                                   *)  $ $(* purpose: To remove all locks on a database.                       *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) data set id                                                *)  $ $(*    (3) mode. (must be 1 or 2)                                     *)  $ $(*    (4) istat.                                                     *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE remote_dbunlock   $ Alias 'RBUNL' $      (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);      LABEL 999;      VAR      run_table    : ptr_local_run_table_hdr;     dbbuf_table  : ptr_dbbuf_table;     req_mesg_buf : remote_msg_buf_ptr_type;     stats_buf    : statistics_buffer_ptr_type;      start_time   : long_int;          junk_buf     : short_int;     lvl_set_itm  : level_set_itm_type;      to_rdbam_len : short_int;     dscb_entry   : remote_set_table_entry_ptr_type;      BEGIN (* remote_dbunlock *)          IF get_database_pointers (ibase,                                dbbuf_table,                                req_mesg_buf,                               run_table,                                stats_buf,                                istat.unl.status)  
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;      
   IF MODE = 2 THEN  
       IF find_set (set_id, run_table, lvl_set_itm[one],                   dscb_entry, istat.unl.status)            THEN GOTO 999;          to_rdbam_len := zero;         IF send_receive_message (ibase, mode, lvl_set_itm,                               junk_buf, to_rdbam_len,                               junk_buf, zero,                               db_unlock, istat)   
      THEN GOTO 999; 
     999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_unlock] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       
END; (* dbunlock *)  
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* PROCEDURE Remote_DBUPDATE                                         *)  $ $(*                                                                   *)  $ $(* Purpose:                                                          *)  $ $(*    Subroutine to provide remote database access for DBUPD calls.  *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) set id.                                                    *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) item list.                                                 *)  $ $(*    (6) value list.                                                *)  $ $(*                                                                   *)  $ $(* Returns:  (4) status buffer                                       *)  $ $(*               - status (0:successful)                             *)  $ $(*               - length of the buffer of item values               *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE Remote_dbupdate   $ Alias 'RBUPD' $      (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR user_buffer : data_record_type);      LABEL 999;      VAR      run_table : ptr_local_run_table_hdr;      mesg_buf  : remote_msg_buf_ptr_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf : statistics_buffer_ptr_type;     start_time: long_int;      
   set_number : short_int; 
    dscb_entry : remote_set_table_entry_ptr_type;      
   list_len   : short_int; 
 
   val_len    : short_int; 
    lvl_set_itm: level_set_itm_type;      to_rdbam_len : short_int;  
   junk_buf   : short_int; 
     BEGIN (* Remote_dbupdate *)          IF get_database_pointers (ibase,                                dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.upd.status)  
      THEN GOTO 999; 
        IF (stats_buf <> nil)        THEN start_time := get_start_time;      $   (* Validify the SET parameter.  If valid, we are returned the data *) $ $   (* set number and data set control block table entry offset,       *) $ $   (* relative to the start of the run table.                         *) $        IF find_set (set_id, run_table, lvl_set_itm[one],                  dscb_entry, istat.upd.status)   
      THEN GOTO 999; 
         #   IF process_remote_item_list (lvl_set_itm[one],item_list,run_table,  # "                                list_len, val_len, istat.upd.status) " 
      THEN GOTO 999; 
         %   (* Transfer the item values from the user buffer to the data record *)  % %   (* portion of the message to dbmon.  We need to know the word       *)  % %   (* length of the concatenated item values in the user buffer (this  *)  % %   (* was calculated while processing the item list above).            *)  %     "   move_data_values (user_buffer, mesg_buf^[list_len+one], val_len); "        to_rdbam_len := list_len + val_len;         IF send_receive_message (ibase, mode, lvl_set_itm,                               mesg_buf^[one], to_rdbam_len,                               junk_buf, zero,                               db_update, istat)   
      THEN GOTO 999; 
     999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_update] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - wait_time;           END;       
END; (* Remote_DBUPDATE *) 
 . (* The end *)  