 $PASCAL ',3,75 92081-1X731 REV.5000' $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18731                                        *)   (* RELOC:   92081-1X731                                        *)   (*                                                             *)   (* PGMR:        <MRL> <TH>                                     *)   (*                                                             *)   (* Date last modified: <870113.1609>  (*                                                             *)   (* Bug fix, February 1986 - DBRBR made a PRTN call too soon,   *)   (*    which allows the father to begin executing simultaneously*)   (*    with the son for a hopefully brief time.  DBRBR executed *)   (*    too long (closing files and such) before actually        *)   (*    terminating with the following symptoms resulting:       *)   (*    (1) On RTE-6 at the system console, if DBRBR was not     *)   (*        RP'ed, DBUTL would report DBRBR as having aborted    *)   (*        (FMP error -226). FmpRunProgram was doing the OF'ing.*)   (*    (2) On RTE-6 at system console, if DBRBR was RP'ed,      *)   (*        DBUTL would report error 8 when attempting to append *)   (*        DBRBR's output to its own list/log files.            *)   (*    Solution: Make the PRTN call just before the END. line.  *)   (*                                                             *)   (***************************************************************)       (**) (* Fixed for DSD 5.0:  Pascal changed the meaning of the $EMA (* directive to specify the actual number of mseg pages needed,  (* instead of 1 less than the number needed.  (* The original was  $ EMA '0,5' $ and was changed to '0,6'.  (**)     $ EMA '0,6' $  $ Heap 2 $ $ Recursive OFF $ $ Range OFF $      (***************************************************************)   (*                                                             *)   (* This is the DataBase Roll Back Recovery (DBRBR) program.    *)   (*                                                             *)   (* Its primary function is to recover databases physically and *)   (* logically a crash where data in memory is totally lost.     *)   (* (Typically a power failure).                                *)   (*                                                             *)   (* Secondarily, DBRBR recovers the Roll Forward Log if roll    *)   (* forward logging was enabled and the DBCON file exists.      *)   (*                                                             *)   (***************************************************************)       (**)  %(*:nl:$ '        SOURCE MESSAGE CATALOG                                  ' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '* (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984.  ALL RIGHTS      *' % %(*:nl:$ '* RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *' % %(*:nl:$ '* REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT *' % %(*:nl:$ '* THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        *' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '                                                                ' % %(*:nl:$ '                           SOURCE:   92081-18074                ' % %(*:nl:$ '         S. MESSAGE CATALOG NAME :   <RB000                     ' % %(*:nl:$ '                            RELOC:   92081-16074                ' % %(*:nl:$ '         B. MESSAGE CATALOG NAME :   %RB000                     ' % %(*:nl:$ '                            PGMR :   TH                         ' % %(*:nl:$ '         REV.2540 <870113.1609>                                 ' %(*:nl:$  (*:nl:$ '*NOTE*'  %(*:nl:$ 'All the messages in DBRBR must be within the number of chars_in ' % &(*:nl:$ 'long_str -1 (=127 bytes). And the length of parameter substitution' & %(*:nl:$ 'must be the length written in the comment line.                 ' % %(*:nl:$ '                                                                ' % %(*:nl:$ 'The messages between Begin mesaages and End messages are        ' %$(*:nl:$ 'displayed at one time. So you don't need translate these       ' $ %(*:nl:$ 'messages as they are, if each message is within 127 bytes.      ' %(*:nl:$ (*:nl:$ (*:nl:$LANGID 0 (*:nl:$ (*:nl:$  (**)      (**) %(*:nl:$ATB, mrbr_x, %rb000, relocatable, 92081-16074 REV.2540 <870113.1609> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)     PROGRAM Rollback_Recovery  $ Alias 'DBRBR' $;     LABEL 999,  (* Terminate DBRBR *)        10,11,12,13,14,15,16,17,18;  (* NLS message tests *)      $ List OFF $ $ Include '[IMAGE' $  (* Common IMAGE constants and types. *)  $ Include '[BMCCT' $  (* Database workhorse definitions *)      $ Include '[RBCTV' $  (* DBRBR const, type, var defn's. *)  $ Include '[RBSG' $   (* DBRBR segment names. *)      TYPE     rmpar_array_type = ARRAY [1..5] OF short_int;     VAR    prtn_array : rmpar_array_type;      $ Page $ "(*******************************************************************) ""(*                 External declarations.                          *) ""(*******************************************************************) "    $ List OFF, Include '[XURDO', List ON $     (* Process the DBRBR runstring *)     $ Heapparms OFF $      PROCEDURE process_runstring  $ Alias 'RBR.ProcRunStr' $;     EXTERNAL;          (* Check the status of IMAGE subsystem programs *)     "PROCEDURE check_image_subsystem_programs  $ Alias 'RBR.CheckProgs' $; "    EXTERNAL;         (* Check the status of IMAGE subsystem files *)      !PROCEDURE check_image_subsystem_files  $ Alias 'RBR.CheckFiles' $; !    EXTERNAL;             (* Initialize DBRBR variables and I/O. *)      "PROCEDURE initialize_dbrbr_environment  $ Alias 'RBR.InitEnviron' $; "    EXTERNAL;          (* Execute the PASTE PHASE of Roll-back Recovery. *)      PROCEDURE paste_phase  $ Alias 'RBR.PastePhase' $;     EXTERNAL;         (* Execute SCAN PHASE of Roll-back recovery. *)      PROCEDURE scan_phase  $ Alias 'RBR.ScanPhase' $;     EXTERNAL;          "(* Execute Roll-forward log recovery phase of Roll-back recovery. *) "     PROCEDURE recover_roll_forward_log  $ Alias 'RBR.RecoverRFLog' $;      EXTERNAL;         (* Determine if a given transaction should be redone *)     FUNCTION redo_transaction   $ Alias 'RBR.RedoTrans' $    (transaction_number : long_int) : Boolean;     EXTERNAL;             (* Execute REDO PHASE of Roll-back recovery. *)      PROCEDURE redo_phase  $ Alias 'RBR.RedoPhase' $;     EXTERNAL;             (* Execute the UNDO PHASE of roll-back recovery. *)     PROCEDURE undo_phase   $ Alias 'RBR.UndoPhase' $;     EXTERNAL;         (* Display summary statistics of roll-back recovery. *)     PROCEDURE print_summary   $ Alias 'RBR.PrintSummary' $;     EXTERNAL;         (* Display Roll-back recovery error. *)      PROCEDURE display_error   $ Alias 'RBR.DisplayErr' $    (image_error : short_int);     EXTERNAL;          (* Issue final DBRBR message, close files, etc. *)      PROCEDURE wrapup_dbrbr   $ Alias 'RBR.Wrapup' $;     EXTERNAL;     $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XDFMP', List ON $     $ List OFF, Include '[XDNLS', List ON $   (* NLS externals *)     (*:nl:$COPY 'PROCEDURE &; EXTERNAL;' *) PROCEDURE MRBR_X; EXTERNAL;         $ Heapparms OFF $      (**** Load a program segment:  System Dependent!!! ****)     PROCEDURE load_segment  $ Alias 'Pas.SegmentLoad' $     (segment_name : Prog_name);     EXTERNAL;      PROCEDURE prtn  (* system routine *)    (prtn_array : rmpar_array_type);     EXTERNAL;      $ Page $ "(*******************************************************************) " #(*                  Terminate_dbrbr                                *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To wrap up all of DBRBR's loose ends:  close all open files, *)  # #(*    print a termination message, return any required info in     *)  # #(*    the scheduling buffer back to the scheduler, etc.            *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(* Errors: Ignored.                                                *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     PROCEDURE terminate_dbrbr  $ Alias 'RBR.Terminate' $;       BEGIN          load_segment (termination_segment);         wrapup_dbrbr;         GOTO 999;      END;  $ Page $ "(*******************************************************************) ""(*                  display_dbrbr_error                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    When an error occurs during roll-back recovery, this routine *) ""(*    is called to display the error on the log file/device, and   *) ""(*    then terminates DBRBR.                                       *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)     (1) IMAGE error number.                             *) ""(*                                                                 *) ""(* Notes:                                                          *) " #(*    Only selected errors which may occur will have a full        *)  # #(*    description of the error displayed, mainly to conserve       *)  # #(*    space.  DBUTL can be used to fully display any error.        *)  # #(*                                                                 *)  #"(*******************************************************************) "    $ Heapparms OFF $      PROCEDURE display_dbrbr_error   $ Alias 'RBR.DisplayError' $     (image_error_code : short_int);     BEGIN        (* Save the last error, to be returned to scheduler *)    prtn_array[1] := image_error_code;         load_segment (termination_segment);        IF image_error_code <> no_image_err THEN BEGIN        error_abort := true;  (* do not reset the crash flag! *)       display_error (image_error_code);       END; (* display an error *)     	   terminate_dbrbr; 	     END; (* display_dbrbr_error *)  $ Page $ "(*******************************************************************) " #(*                       image_error                               *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To report an IMAGE error which is not fatal to roll-back     *)  # #(*    recovery.  These errors occur when redo-ing or undo-ing      *)  # #(*    log records.   The IMAGE error number and the affected       *)  # #(*    database name are displayed to the user on the log file.     *)  #"(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)     (1) Pointer to the offending log record.            *) ""(*    (in)     (2) The image error which occurred.                 *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE image_error   $ Alias 'RBR.ImageError' $     (logrec_ptr : ptr_log_record_header_type;      error_num  : short_int);     LABEL     10,99;  (* NLS message tests *)     CONST    len = 128;     (* Max. read length of NLS *)     VAR     dummy_err      : short_int;    display_string : long_str;    temp_long_str  : long_str;     number_string  : short_str;     file_descrip   : new_file_name;     length         : short_int;     nlerr          : short_int;      BEGIN  (* image_error *)        error_abort := true;  (* do not reset the crash flag! *)      (* display_string := 'IMAGE ERROR #'; *)         short_int_to_readable_short_str (error_num, number_string);     null_pad (number_string, chars_in_short_str);     (* append_str (display_string, number_string); *)      (* append_str (display_string, ' ON DATABASE--'); *)        file_descrip := logrec_ptr^.delete.db_name_id;    null_pad_fname (file_descrip, chars_in_new_file_name);     (* append_long_str (display_string, file_descrip); *)        (*:nl:$ ' ' *)      (*:nl:$ ' !1 is the error number of IMAGE (max. 15 bytes)' *)   "   (*:nl:$ ' !2 is the data base file descriptor (max. 63 bytes)' *) "   (*:nl:$ ' ' *)     (*:nl:#*1 1000 'IMAGE ERROR #!1 ON DATABASE--!2' *)      
10:  (* NLS tests *) 
    &   (*:nl:$COPY '   length := nlread_sf (&, #, nlerr, display_string, len,' *) &"   length := nlread_sf (MRBR_X, 1000, nlerr, display_string, len,     "                      number_string, file_descrip);          IF write_long_str (log_file, display_string, dummy_err) THEN;       (* temp_long_str := ' DATA BASE IS NOT LOGICALLY RECOVERED! '; *)     (*:nl:#*1 1001 ' DATA BASE IS NOT LOGICALLY RECOVERED~! ' *)  %   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_long_str, len);' *) % !   length := nlread (MRBR_X, 1001, nlerr, temp_long_str, len);     !   IF write_long_str (log_file, temp_long_str, dummy_err) THEN;        IF (NOT override_code)       THEN display_dbrbr_error (error_num);      
99:  (* NLS tests *) 
     END; (* image_error *)      $ Page $ "(*******************************************************************) ""(*                    calculate_tlf_pos                            *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To determine the TLF block number of the current chunk and   *) ""(*    the word offset of the current log record in the TUB.        *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)     (1) TUB pointer.                                    *) ""(*    (in)     (2) Log record pointer.                             *) ""(*    (out)    (3) Chunk block number.                             *) " #(*    (out)    (4) Chunk word offset.                              *)  # #(*                                                                 *)  # #(* Errors: None.                                                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     PROCEDURE calculate_tlf_pos   $ Alias 'RBR.CalcTlfPos' $     (VAR current_tub_ptr    : tub_ptr_type;      VAR current_logrec_ptr : ptr_log_record_header_type;      VAR chunk_block_number : Long_int;      VAR chunk_word_offset  : Short_int);      VAR      Any_ptr : All_pointers_type;      Any_ptr1: All_pointers_type;      Any_ptr2: All_pointers_type;           BEGIN (* calculate_tlf_pos *)          Any_ptr.tub := current_tub_ptr;         (**)   "   (* Assumption:  There must be a chunk_head log record in the TUB  "    (* and it must begin at the very first word of the TUB.    (**)         any_ptr1.value := any_ptr.value + log_rec_hdr_size;  "   chunk_block_number := any_ptr1.chunk_head_log_rec^.tuf_block_num; "        Any_ptr2.log_record_header := current_logrec_ptr;        chunk_word_offset := any_ptr2.value - any_ptr.value;      END; (* calcualte_tlf_pos *)  $ Page $ "(*******************************************************************) ""(*                  DBRBR main program code                        *) ""(*******************************************************************) "     BEGIN   (* DBRBR main *)        prtn_array[1] := 0; (* Assume no error will occur *)        (**)     (* Load the initialization segment.    (* Initialize datastructures in DBRBR.    (* Initialize datastructures in workhorse_info_type.     (* Process the run string parameters.    (**)        load_segment (dbrbr_initialization_segment);     
   process_runstring; 
     
10:  (* NLS tests *) 
        initialize_dbrbr_environment;      
11:  (* NLS tests *) 
    !   error_abort := false;  (* reset the crash flag upon finishing *) !       (**)      (* Hello!  I am DBRBR and here are the things which I will do  
   (* for you very shortly: 
   (*     (*    1. First I verified that the IMAGE subsystem has been     (*       shut down and that a crash truly has occurred.    (*    (*    2. I will take the contents of the Before-image file    (*       (+BIF) and use the before-images therein to paste     (*       databases and the TLF back to the last checkpoint.    (*     (*    3. Next, I start from the last checkpoint in the TLF and   !   (*       scan forward to the logical end of the TLF, and record !   (*       the transaction numbers of those transactions which 
   (*       must be undone. 
   (*     (*    4. If roll-forward logging was enabled, I will find    (*       the proper tape/file and recover the volume to be    (*       up-to-date with the TLF.  (This is more easily said    (*       than done).    (* !   (*    5. Again I start from the last checkpoint and scan forward !!   (*       redoing all transactions which must be re-done.  (These !!   (*       transactions are identified by not being in the 'trans- !    (*       actions-to-undo' list).  A checkpoint is forced after   "   (*       redo phase to insure that redo-phase is not redone after "    (*       a crash during recovery.    (*  "   (*    6. Next I start from the last checkpoint and work backwards "     (*       to the beginning of the TLF, undoing all log records  !   (*       which have transaction numbers in the 'transactions-to- !   (*       undo' list.    (*  !   (*    7. Finally, I post all buffers to disc, reset the BIF and ! "   (*       TLF, reset the crash flag in DBCON, and close all files. "   (*  "   (*    8. I wave goodbye to my scheduler and snuff it (terminate). "   (*    (**)        (**)     (* Step 1: Completed during initialization.    (**)             IF (rb_logging_was_on) THEN BEGIN            (**)       (* Step 2: Recover the Roll Forward Log if necessary.        (**)            load_segment (rfl_recovery_segment);      
12:  (* NLS tests *) 
           IF RF_logging_was_on  THEN      
13:  (* NLS tests *) 
                  recover_roll_forward_log;        END;            (**) !   (* Step 3: Apply before-images in the BIF to their proper files. !   (**)         load_segment (paste_phase_segment);      
14:  (* NLS tests *) 
       paste_phase;             IF (rb_logging_was_on) THEN BEGIN            (**)        (* Step 2: Scan the Transaction Log file and build the        (* Undo Transaction Table (UTT).        (**)            load_segment (scan_phase_segment);      
15:  (* NLS tests *) 
          scan_phase;                (**)       (* Next stage is to REDO transactions occurring after the       (* last checkpoint which are not recorded in the UTT.        (**)      
16:  (* NLS tests *) 
          redo_phase;                (**)       (* Finally, undo those transactions which are in the UTT.        (**)      
17:  (* NLS tests *) 
          undo_phase;           END; (* then RB logging was on *)            (**)      (* Each of the phases have been accumulating some statistical     (* information which we will print a summary of.    (**)      
18:  (* NLS tests *) 
        load_segment (summary_segment);        print_summary;         display_dbrbr_error (no_image_err);      999: (* termination label *)        (* Return any last error to scheduler *)     
   prtn (prtn_array); 
    END  .  