 $PASCAL ',7 92081-1X733 REV.2540' $       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18733                                        *)  ! !(* RELOC:   92081-16733                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL> <TH>                                     *)  ! !(*                                                             *)  ! (* Date last modified: <851118.1447>  !(*                                                             *)  ! !(***************************************************************)  !     (**)  &(*:nl:$ATB, mrbr_e, %rb000, relocatable, 92081-16074 REV.2540 <851118.1447>  & (*:nl:$   
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      
$ Include '[LBOPT' $ 
     PROGRAM redo_phase_library;       $ List OFF, Include '[IMAGE', List ON $   $ List OFF, Include '[BMCCT', List ON $       $ List OFF, Include '[RBCTV', List ON $   $ Page $  #(*******************************************************************)  # #(*                External references                              *)  # #(*******************************************************************)  #     $ List OFF, Include '[XDFMP', List ON $   $ List OFF, Include '[XRBRX', List ON $   $ List OFF, Include '[XRBCP', List ON $   $ List OFF, Include '[XLGLB', List ON $   $ List OFF, Include '[XURDO', List ON $   $ List OFF, Include '[XLDLR', List ON $   $ List OFF, Include '[XRBRI', List ON $   $ List OFF, Include '[XRBRL', List ON $       $ List OFF, Include '[XDNLS', List ON $   (*:nl:$COPY 'PROCEDURE &; EXTERNAL;' *)   PROCEDURE MRBR_E; EXTERNAL;               FUNCTION break_flag_set   $ Alias 'IFBRK' $      (dummy : short_int) : short_int;      EXTERNAL;      $ Page $  #(*******************************************************************)  # #(*                     redo_transaction                            *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To determine if a transaction is part of the undo-list of    *)  # #(*    transactions.  If the transaction number given is not in     *)  # #(*    the list, it must be redone.                                 *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (In)  (1) Transaction number to test for.                    *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    Boolean 'True' if the transaction is to be redone,           *)  # #(*    Boolean 'False' if the transaction is to be undone.          *)  # #(*                                                                 *)  # #(* No errors possible.                                             *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     FUNCTION redo_transaction   $ Alias 'RBR.RedoTrans' $      (transaction_number : long_int) : Boolean;   VAR      transaction_number_found : Boolean;  
   loop : short_int; 
     BEGIN  (* redo_transaction *)          transaction_number_found := false;      loop := one;          WHILE (NOT transaction_number_found) AND               (loop <= max_undo_transactions) DO        IF (utt[loop] = transaction_number)            THEN transaction_number_found := true           ELSE loop := loop + one;              redo_transaction := (NOT transaction_number_found);      END; (* redo_transaction *)   $ Page $  #(*******************************************************************)  # #(*                         redo_phase                              *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To re-execute log records belonging to transactions which    *)  # #(*    were active at the last checkpoint and which committed       *)  # #(*    prior to the crash.  Executions are made in the same order   *)  # #(*    as they were performed (Not that it should make any          *)  # #(*    difference since transactions must be different).            *)  # #(*                                                                 *)  # #(* Parameters: None                                                *)  # #(*                                                                 *)  # #(* All inputs and outputs are global to DBRBR.                     *)  # #(*                                                                 *)  # #(* Possible errors:                                                *)  # #(*    FMP, EMA, and standard database errors for DEL, PUT and UPD. *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     PROCEDURE redo_phase   $ Alias 'RBR.RedoPhase' $;       LABEL 99,  (* For skipping redo phase *)        10,11;  (* NLS message tests *)       $ List OFF, Include '[RBSG', List ON $      CONST      len = 128;  (* NlReadRel max read length *)      VAR      display_string : long_str;      tlf_eof_found  : Boolean;     transaction_num: Long_int;      dummy          : short_int;         length         : short_int;     nlerr          : short_int;      BEGIN (* redo-phase *)         (**)      (* Steps for performing redo phase of DBRBR:       (*    1: Position the TLF to the starting point determined in       (*       'scan-phase', which is either the last checkpoint or      (*       the logical BOF of the TLF.      (*      (*    2: Read serially forward through all log records up     (*       to the logical EOF of the TLF, and redo any which      (*       do not belong to transactions in the undo-list.      (*      (*    3: Execute a checkpoint to reset the BIF and to keep      (*       the redo-phase from being executed again, if by      (*       bad luck we should crash during recovery.      (*      (*    4: When the EOF is reached, we are done.      (**)          IF (NOT tuf_has_log_records) THEN GOTO 99;          (**)      (* Step 1: Position to the redo starting point in the TLF.      (**)          load_segment (log_record_segment);          initial_get_log_fctn (transaction_log_file,                           tlf_label,                            tub_ptr^,                           start_block_num,                            start_word_off,                           log_record_ptr,                           dummy_stats,                            dummy_stats,                            error_code);          IF (error_code = logical_end_of_TUF_err)         THEN tlf_eof_found := true        ELSE IF (error_code <> no_image_err)           THEN display_dbrbr_error (tlf_corrupt_err)            ELSE tlf_eof_found := false;              (**)   "   (* Step 2: Serially read through the TLF from the starting point  "     (*         and re-execute log records belonging to committed       (*         transactions.      (**)          WHILE (NOT tlf_eof_found) DO BEGIN             IF (break_flag_set(dummy) = -one)            THEN display_dbrbr_error (program_was_broken_err);             load_segment (log_record_segment);            get_adjacent_log_record (transaction_log_file,                                 tlf_label,                                  tub_ptr^,                                 foreward, (* read direction *)                                  log_record_ptr,                                 dummy_stats,                                  dummy_stats,                                  error_code);             IF (error_code = logical_end_of_tuf_err)           THEN tlf_eof_found := true            ELSE IF (error_code <> no_image_err)               THEN display_dbrbr_error (tlf_corrupt_err);             IF (NOT tlf_eof_found)           THEN CASE log_record_ptr^.rec_type OF                  dbdel_log_code : BEGIN      "               transaction_num := log_record_ptr^.delete.trans_num;  "                    IF redo_transaction (transaction_num)                    THEN BEGIN                       load_segment (redel_unput_segment);                       IF redelete (log_record_ptr,                                     override_code,                                    workhorse_data,                                     error_code)   #                        THEN image_error (log_record_ptr, error_code); #                      END (* then redelete the record *)                     ELSE undone_intrinsic_count :=                            undone_intrinsic_count + one;                      END; (* case of dbdel log record *)                      dbput_log_code : BEGIN                      transaction_num := log_record_ptr^.put.trans_num;                      IF redo_transaction (transaction_num)                    THEN BEGIN                       load_segment (reput_undel_segment);                       IF reput (log_record_ptr,                                 override_code,                                  workhorse_data,                                 error_code)  #                        THEN image_error (log_record_ptr, error_code); #                      END  (* then redo the put *)                     ELSE undone_intrinsic_count :=                            undone_intrinsic_count + one;                      END; (* case of dbput log record *)                      dbupd_log_code : BEGIN      "               transaction_num := log_record_ptr^.update.trans_num;  "                    IF redo_transaction (transaction_num)                    THEN BEGIN                       load_segment (reupd_unupd_segment);                       IF reupdate (log_record_ptr,                                     override_code,                                    false, (* redo the update *)                                    workhorse_data,                                     error_code)   #                        THEN image_error (log_record_ptr, error_code); #                      END (* then reupdate the record *)                     ELSE undone_intrinsic_count :=                            undone_intrinsic_count + one;                      END; (* case of dbupd log record *)                      OTHERWISE; (* do nothing with other log records *)                  END; (* case of log record type *)                       (**)   !         (* Report logically inconsistent database when necessary. !          (**)                IF (error_code = db_logically_inconsistent_err)              THEN BEGIN                      logical_error_count := logical_error_count + one;       (*             display_string :=      'LOGICAL INCONSISTENCY ON REDO OF FOLLOWING LOG RECORD:'; *)    '   (*:nl:#*1 1000 'LOGICAL INCONSISTENCY ON REDO OF FOLLOWING LOG RECORD:' *)  '     
10:  (* NLS tests *) 
     &   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *)  & "   length := nlread (MRBR_E, 1000, nlerr, display_string, len);      "    blank_pad (display_string, chars_in_long_str, length);                      IF write_long_str (log_file,                                     display_string,                                     error_code)                     THEN display_dbrbr_error (error_code);      
11:  (* NLS tests *) 
                    load_segment (log_record_segment);                      IF display_logrecord (log_record_ptr,                                       log_file,                                       error_code)                    THEN display_dbrbr_error (error_code);                      END; (* then display logically-bad log record *)                 END; (* while TLF eof not found *)          (**)       (* Step 3: Force a checkpoint to remove before-images and to        (*         keep the redo-phase from being executed should we    #   (*         happen to crash during recovery.  (This is accomplished  #     (*         by making making the last record in the TUF a ckpt       (*         record, so the redo-phase will have no log records      (*         to be redone).     (**)          IF check_point (workhorse_data, error_code)        THEN display_dbrbr_error (error_code);             (**)      (* Step 4:  Return to DBRBR main.     (**)       99: (* for skipping redo phase *)       END;  (* redo-phase *)  .  