$PASCAL ',7 92081-1X742 REV.5000' $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18742                                        *)   (* RELOC:   92081-1X742                                        *)   (*                                                             *)   (* PGMR:        <MRL> <TH>                                     *)   (*                                                             *)   (* Date last modified: <870113.1609>  (*                                                             *)   (* June 1985, <MRL> Workaround to FMP bug; FMP automatically   *)   (* allocated an extent if the last block of the RFLog was      *)   (* accessed.  Workaround was to open RFLog non-extendible.     *)   (*                                                             *)   (* Altered: July 1986 for new O/S numbers. <MRL>               *)   (*                                                             *)   (***************************************************************)       (**) %(*:nl:$ATB, mrbr_d, %rb000, relocatable, 92081-16074 REV.2540 <870113.1609> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      
$ Include '[LBOPT' $ 
     PROGRAM Roll_forward_log_recovery_library;     $ List OFF, Include '[IMAGE', List ON $ $ List OFF, Include '[BMCCT', List ON $     $ List OFF, Include '[RBCTV', List ON $  $ Page $ "(*******************************************************************) " #(*                External references                              *)  # #(*******************************************************************)  #     $ List OFF, Include '[XDFMP', List ON $   $ List OFF, Include '[XDCCP', List ON $   $ List OFF, Include '[XDGCB', List ON $   $ List OFF, Include '[XERWD', List ON $   $ List OFF, Include '[XRBRX', List ON $   $ List OFF, Include '[XLGLB', List ON $  $ List OFF, Include '[XDCIO', List ON $ $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XDSCD', List ON $ $ List OFF, Include '[XDLDP', List ON $ $ List OFF, Include '[XUSHF', List ON $ $ List OFF, Include '[XDMSG', List ON $     $ List OFF, Include '[XDNLS', List ON $     (*:nl:$COPY 'PROCEDURE &; EXTERNAL;' *) PROCEDURE MRBR_D; EXTERNAL;          FUNCTION make_log_record_ptr   $ Alias 'EMA.AddrToPtr' $  $ Heapparms ON $    (VAR tub        : transaction_log_buffer_type;      VAR logrec_ptr : ptr_log_record_header_type; $ Heapparms OFF $     VAR return_status : short_int) : Boolean;     EXTERNAL;             FUNCTION exchange_dbspl_message   $ Alias 'EMA.XchgMessage' $  $ Heapparms ON $     (VAR request_message : dbrbr_mesg_buf_type; $ Heapparms OFF $          request_len     : short_int;  $ Heapparms ON $      VAR reply_message   : dbrbr_mesg_buf_type;  	$ Heapparms OFF $  	     VAR reply_len       : short_int;          max_reply_len   : short_int;      VAR return_status   : short_int) : Boolean;      EXTERNAL;          (**** Send message to DBSPL: Do not wait for a reply. ****)       FUNCTION send_dbspl_message   $ Alias 'EMA.SendRequest' $   $ Heapparms ON $     (VAR message : dbrbr_mesg_buf_type;  	$ Heapparms OFF $  	         length  : short_int;      VAR status  : short_int) : Boolean;      EXTERNAL;          (**** Receive a DBSPL reply message. ****)      FUNCTION get_dbspl_reply   $ Alias 'EMA.ReceiveMsg' $   	$ Heapparms OFF $  	    (    comm_id   : short_int;          comm_lock : short_int;          wait_bit  : short_int;  $ Heapparms ON $      VAR buffer    : dbrbr_mesg_buf_type; $ Heapparms OFF $          reply_len : short_int;          max_len   : short_int;         error_code: short_int) : Boolean;     EXTERNAL;         $ Heapparms OFF $      FUNCTION magtape_control   $ Alias 'DBIOC' $     (    magtape_dcb      : dcb_type;         magtape_function : short_int;      VAR return_status    : short_int) : Boolean;     EXTERNAL;          FUNCTION make_rfl_label_ptr  $ Alias 'EMA.AddrToPtr' $  $ Heapparms ON $    (VAR roll_forward_log_buffer : rfl_tape_buffer_type;     VAR roll_forward_label_ptr  : ptr_rfl_label_type; $ Heapparms OFF $     VAR return_status           : short_int) : Boolean;     EXTERNAL;          PROCEDURE suspend_thyself   $ Alias 'EXEC' $    (exec_code : short_int); (* 7=suspend *)     EXTERNAL;          PROCEDURE take_a_nap   $ Alias 'Img.Sleep' $    (time_to_sleep : short_int);     EXTERNAL;          FUNCTION make_tuf_chunk_ptr  $ Alias 'EMA.AddrToPtr' $  $ Heapparms ON $    (VAR rfl_chunk_block : disc_block;     VAR tuf_chunk_ptr   : ptr_log_record_header_type; $ Heapparms OFF $     VAR return_status   : short_int) : Boolean;     EXTERNAL;          
(*** Do magtape read ****) 
$ Heapparms off $ FUNCTION read_rfl_magtape_chunk $ alias 'WKDIO' $    (     code          : short_int;       VAR dcb           : dcb_type;          word_len      : short_int;  $ heapparms on $       VAR buffer_addr   : rfl_tape_buffer_type; $ heapparms off $      VAR words_read    : short_int;       VAR return_status : short_int ) :    BOOLEAN;     EXTERNAL;          (*** Get the operating system number ****)  	$ Heapparms OFF $  	FUNCTION operating_system  $ Alias 'IMG.OPSY' $     : os_kinds;     EXTERNAL;      $ Page $ "(*******************************************************************) ""(*                   setup_dbspl_message                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To make sure DBSPL exists, then to formulate the message     *) ""(*    header for DBSPL.  The caller will fill in any message-      *) ""(*    dependent code.                                              *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)     (1) Message code.                                   *) ""(*    (out)    (2) Return status.                                  *) ""(*                                                                 *) ""(* Function result:                                                *) ""(*    Boolean 'True' if an error occurs, 'False' otherwise.        *) ""(*                                                                 *) " #(* Possible error:  'DBSPL not ready'.                             *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION setup_dbspl_message   $ Alias 'RBR.DBSPLMesg' $     (    message_code : short_int;       VAR return_status: short_int) : Boolean;     $ List OFF, Include '[PROG', List ON $       BEGIN (* setup_dbspl_message *)          setup_dbspl_message := false;  (* Assume no error *)          WITH mesg_buf_ptr^.dbspl, IMAGE_comm_buffer DO BEGIN         from_comm_id   := spl_reply_comm_id;        from_comm_lock := zero;         to_comm_id     := dbspl_comm_id;        to_comm_lock   := dbspl_comm_lock;        request        := message_code;         END;         IF local_dormant_program (dbspl_program)         THEN BEGIN           setup_dbspl_message := true;  (* error! *)            return_status := dbspl_comm_err;            END;       END; (* setup_dbspl_message *)  $ Page $ "(*******************************************************************) ""(*                   rfl_corrupt                                   *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To set appropriate indicators in the DBCON file to show that *) ""(*    the Roll-forward log is corrupt, then to inform the user     *) ""(*    of the fact.                                                 *) ""(*                                                                 *) ""(* No parameters required.                                         *) ""(*                                                                 *) ""(* No errors returned.                                             *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE rfl_corrupt    $ Alias 'RBR.RflCorrupt' $;     LABEL     10,99;  (* NLS message tests *)     CONST    len = 128;  (* NlReadRel max. read length *)     VAR    display_string : long_str; 
   nlerr : short_int; 

   length: short_int; 
    BEGIN (* rfl_corrupt *)        WITH dbcon_table.dbcon_status_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_status_blk,                            lock_dbcon_file,                            block,                             error_code)          THEN display_dbrbr_error (error_code);           flag.corrupt_rfl := true;           IF write_dbcon_table (dbcon_file,                             dbc_status_blk,                              unlock_dbcon_file,                              block,                             error_code)          THEN display_dbrbr_error (error_code);     
      END; (* with *) 
     
10:  (* NLS tests *) 
        (*:nl:$ 'Begin messages' *)    display_string := ' ';     IF write_long_str (log_file, display_string, error_code) THEN;       
(* display_string := 
 $      'THE ROLL-FORWARD LOG VOLUME IS CORRUPT!  YOU NEED TO START A'; *) $ !   (*:nl:#*1 1000 'THE ROLL-FORWARD LOG VOLUME IS CORRUPT~!  &' *) !    (*:nl:#        'YOU NEED TO START A' *) %   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) %!   length := nlread (MRBR_D, 1000, nlerr, display_string, len);     !   blank_pad (display_string, chars_in_long_str, length);     IF write_long_str (log_file, display_string, error_code) THEN;       
(* display_string := 
 #      'NEW ROLL-FORWARD LOG SET (''NS'' COMMAND) AND BACK UP YOUR'; *) # !   (*:nl:#*1 1001 'NEW ROLL-FORWARD LOG SET (''NS'' COMMAND) &' *) !   (*:nl:#        'AND BACK UP YOUR' *) %   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) %!   length := nlread (MRBR_D, 1001, nlerr, display_string, len);     !   blank_pad (display_string, chars_in_long_str, length);     IF write_long_str (log_file, display_string, error_code) THEN;       
(* display_string := 
$      'DATA BASES AS SOON AS POSSIBLE!  RESUMING ROLL-BACK RECOVERY.'; *) $    (*:nl:#*1 1002 'DATA BASES AS SOON AS POSSIBLE~!  &' *)    (*:nl:#        'RESUMING ROLL-BACK RECOVERY.' *) %   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) %!   length := nlread (MRBR_D, 1002, nlerr, display_string, len);     !   blank_pad (display_string, chars_in_long_str, length);     IF write_long_str (log_file, display_string, error_code) THEN;         display_string := ' ';     IF write_long_str (log_file, display_string, error_code) THEN;      (*:nl:$ 'End messages' *)  
   (*:nl:$ ' '    *) 
     
99:  (* NLS tests *) 
     END; (* rfl_corrupt *)  $ Page $ "(*******************************************************************) ""(*                 recover_roll_forward_log                        *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To bring the roll-forward log up-to-date to the transaction  *) ""(*    log file. DBSPL will be utilized to perform the actual copy  *) ""(*    from TUF to RFL volume, since that is what it was designed   *) ""(*    to do.  It also has the code for switching to the next vol.  *) ""(*    when the current one becomes full.                           *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(* All inputs/outputs are global.                                  *) ""(*                                                                 *) ""(* Possible errors:                                                *) ""(*    FMP errors, EMA errors, any error in DBSPL.                  *) ""(*                                                                 *) ""(*******************************************************************) "    $ Heapparms OFF $      PROCEDURE recover_roll_forward_log  $ Alias 'RBR.RecoverRFLog' $;       LABEL 99,  (* To skip recovery of the rfl *)        88,  (* If rfl is not initialized.  *)       77,  (* To shut down DBSPL nicely in case of error *)  &      10,11,12,13,14,15,16,17,18,19,20,21,22,23,24;  (* NLS message tests *) &     $ List OFF, Include '[PROG', List ON $     CONST  "   write_tape_eof = 1; (* EXEC function code to write EOF on tape *) " "   backspace_tape = 2; (* EXEC function code to backspace a record*) "    rewind_tape = 4;    (* EXEC function code to rewind magtape *)      sched_code  = -32758; (* -32768 + 10: Schedule no wait *)        len = 128;     (* NlReadRel max read length *)      TYPE     name_lu_type = RECORD       CASE short_int OF           1: (chars : file_name);           2: (lu_num: short_int);        END;     VAR    display_string : long_str;     number_string  : short_str;     blocks_in_chunk: short_int;         prompt_gotten  : boolean;    tuf_chunk_ptr  : ptr_log_record_header_type;     eotuf_found    : boolean;     eot_found      : boolean;    log_rec_ptr    : ptr_log_record_header_type;         last_chunk_sequence_number : short_int;    rfl_chunk_block            : long_int;     last_tuf_chunk             : boolean;    dbspl_startup_buffer       : dbspl_startup_request_mesg;    chunk_address              : long_int;         rfl_label     : rfl_label_type;     rfl_label_ptr : ptr_rfl_label_type;     rfl_chunk_len : short_int;      last_rfl_chunk_found : Boolean;     tub_blocks_read      : short_int;     reply_length         : short_int;         magtape_read_result  : Boolean;     save_image_error     : short_int;     save_error           : short_int;         length               : short_int;     nlerr                : short_int;     temp_string          : short_str;     temp_fname           : new_file_name;         BEGIN  (* recovering the roll-forward log. *)        last_chunk_sequence_number := -1;  (* no chunk found mark *)         IF TUF_header_io (transaction_log_file,                      read_from_device_code,                      tlf_header^,                      dummy_stats,                       error_code)       THEN display_dbrbr_error (tlf_corrupt_err);         tlf_label := tlf_header^.tuf_label;            (**)    (* Step 2: If the TUF is empty, skip RFL recovery.    (**)        tuf_has_log_records := true;  (* Assume log records exist *)      
   WITH tlf_label DO 
   IF (cur_ckpt_rec_block_num = zero) AND       (cur_ckpt_rec_word_off  = zero)       THEN IF (logical_beg_of_TUF = zero)           THEN GOTO 99;         (**)      (* RFL recovery overview:     (*      (*    (1) Open the RFL volume (file or tape).     (*    (2) Determine the last chunk which was written out.  !   (*        For files this involves reading the first block of a  ! !   (*        chunk to determine how many blocks are in the chunk.  !     (*        For tapes this means reading up to an EOF or parity   "   (*        error (which subsequently causes the tape to go down).  "    (*    (3) Save the last chunk number found in the RFL.      (*        If tape, up the device and write an EOF.      (*    (4) Start DBSPL. Ask it to continue the RFL.      (*    (5) Act like DBMON:  Ask DBSPL to spool out chunks.     (*    (6) After last chunk, tell DBSPL to shut down.   
   (*    (7) Voila!  
    (*      (**)              (**)      (* (1) Open the RFL volume (file or tape).      (**)         WITH dbcon_table.dbcon_rfl_info_block DO BEGIN        IF read_dbcon_table (dbcon_file,                             dbc_rfl_info_blk,                             do_not_lock_dbcon_file,                            block,                             error_code)          THEN display_dbrbr_error (error_code);           IF (rfl_new_log) THEN BEGIN  (* volume not initialized *) #(*       display_string := 'ROLL-FORWARD DOES NOT NEED RECOVERING.'; *) #!         (*:nl:#*1 1003 'ROLL-FORWARD DOES NOT NEED RECOVERING.' *) !     
10:  (* NLS tests *) 
     !         (*:nl:$COPY '         length := nlread (&, #, nlerr, ' *) !          length := nlread (MRBR_D, 1003, nlerr,                                          display_string, len);          blank_pad (display_string, chars_in_long_str, length);  !         IF write_long_str (list_file, display_string, error_code) !             THEN display_dbrbr_error (error_code);      
11:  (* NLS tests *) 
             GOTO 88;          END;               IF is_tape_file (roll_forward_log) THEN BEGIN      
(*       display_string := 
#                'PLEASE MOUNT THE FOLLOWING ROLL-FORWARD LOG TAPE:'; *) # '         (*:nl:#*1 1004 'PLEASE MOUNT THE FOLLOWING ROLL-FORWARD LOG TAPE:' *) '     
12:  (* NLS tests *) 
               (*:nl:$COPY '        length := nlread (&, #, nlerr,' *)           length := nlread (MRBR_D, 1004, nlerr,                                         display_string, len);          blank_pad (display_string, chars_in_long_str, length);               IF write_long_str (prompt_file,                             display_string,                             error_code)              THEN display_dbrbr_error (error_code);      (*       display_string := 'VOLUME='; *)              short_int_to_readable_short_str (rflf_vol_num,                                           number_string);      
22:  (* NLS tests *) 
              null_pad (number_string, chars_in_short_str);     (*       append_str (display_string, number_string); *)     (*       append_str (display_string, ', NAME='); *)      (*       append_str (display_string, rfl_logical_name); *)              temp_string := rfl_logical_name;      
23:  (* NLS tests *) 
              null_pad (temp_string, chars_in_short_str);      !(*       append_blank_and_str (display_string, 'ON TAPE LU #'); *) !      (*       long_dest_file_srce (display_string, chars_in_long_str,  &                              roll_forward_log.newfl, chars_in_new_file_name, &                              str_append, zero); *)               temp_fname := roll_forward_log.newfl;      
24:  (* NLS tests *) 
             null_pad_fname (temp_fname, chars_in_new_file_name);              (*:nl:$ ' ' *) "         (*:nl:$ ' !1 is Volume number of RFL File (max.15 bytes)' *) "$         (*:nl:$ ' !2 is The logical name of RFL File (max. 15 bytes)' *) $         (*:nl:$ ' !3 is The tape LU number (max. 63 bytes)' *)          (*:nl:$ ' ' *)              (*:nl:#*1 1005 'VOLUME =!1, NAME=!2 ON TAPE LU~#!3' *) "         (*:nl:$COPY '         length := nlread_ssf (&, #, nlerr,' *) "         length := nlread_ssf (MRBR_D, 1005, nlerr,                                      display_string, len,                                  number_string,                                  temp_string,                                  temp_fname);              blank_pad (display_string, chars_in_long_str, length);      "         IF write_long_str (prompt_file, display_string, error_code) "             THEN display_dbrbr_error (error_code);      
13:  (* NLS tests *) 
             display_string := ' ';      "         IF write_long_str (prompt_file, display_string, error_code) "             THEN display_dbrbr_error (error_code);               prompt_gotten := false;              REPEAT (* prompting *) (*          display_string :=  "                   'ENTER ''CO'' WHEN READY OR ''AB'' TO ABORT.'; *) "%            (*:nl:#*1 1006 'ENTER ''CO'' WHEN READY OR ''AB'' TO ABORT.' *) %     
14:  (* NLS tests *) 
    #            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *) #             length := nlread (MRBR_D, 1006, nlerr,                                           display_string, len);  !            blank_pad (display_string, chars_in_long_str, length); !    #            IF write_long_str (prompt_file, display_string, error_code) #               THEN display_dbrbr_error (error_code);      
15:  (* NLS tests *) 
     #            IF read_long_str (prompt_file, display_string, error_code) #                THEN; (* ignore errors *)                 upshift_long_str (display_string,                               display_string,                               chars_in_long_str);                  IF (display_string = 'CO')                THEN prompt_gotten := true                 ELSE IF (display_string = 'AB')                    THEN BEGIN !(*                   display_string := 'DBRBR ABORTED ON REQUEST!'; !!                     (*:nl:#*1 1007 'DBRBR ABORTED ON REQUEST~!' *) !     
16:  (* NLS tests *) 
     '    (*:nl:$COPY '      length := nlread (&, #, nlerr, display_string, len);'*) '"      length := nlread (MRBR_D, 1007, nlerr, display_string, len);    "%                     blank_pad (display_string, chars_in_long_str, length); % "                     IF write_long_str (prompt_file, display_string, "                                        error_code)                          THEN display_dbrbr_error (error_code);      
17:  (* NLS tests *) 
     !                     display_dbrbr_error (program_was_broken_err); !                      END                    ELSE BEGIN "(*                   display_string := '''CO'' OR ''AB'' PLEASE!'; *) " !                     (*:nl:#*1 1008 '''CO'' OR ''AB'' PLEASE~!' *) !     
18:  (* NLS tests *) 
    &   (*:nl:$COPY '     length := nlread (&, #, nlerr, display_string, len);' *) &"     length := nlread (MRBR_D, 1008, nlerr, display_string, len);     "%                     blank_pad (display_string, chars_in_long_str, length); % "                     IF write_long_str (prompt_file, display_string, "                                        error_code)                          THEN display_dbrbr_error (error_code);      
19:  (* NLS tests *) 
                         END;                  UNTIL (prompt_gotten);               END; (* if rfl is a tape volume. *)               roll_forward_log.newfl := rfl_name;           (* Open non-extendible and exclusive *)  %      IF open_existing_non_extendible (roll_forward_log, true, error_code) %         THEN display_dbrbr_error (error_code);            END; (* with dbcon rfl info block *)            (**)     (* (2) Scan log for last written chunk.     (*     Need to differentiate between file and tape.    (**)         IF is_tape_file (roll_forward_log) THEN BEGIN       (* magnetic tape *)            (**)        (* Rewind the magtape.         (* Check the header for validity.  (Abort if not correct).         (* Scan forward one chunk at a time.        (* If we hit an EOF, no recovery needed!        (* If we hit a parity error:       (*    Ask for the device to be up'ed.       (*    Write an EOF.        (**)                (**)        (* (A) Rewind the magtape.        (**)      $      IF magtape_control (roll_forward_log.dcb, rewind_tape, error_code) $         THEN display_dbrbr_error (error_code);                  (**)          (* (B) Read and verify the label header.          (**)               IF read_rfl_magtape_chunk (read_from_device_code,                                     roll_forward_log.dcb,                                      num_words_in_rfl_tape_buffer,                                      rfl_chunk_ptr^,                                      rfl_chunk_len,                                     error_code)              THEN display_dbrbr_error (error_code);              IF make_rfl_label_ptr (rfl_chunk_ptr^,                                  rfl_label_ptr,                                 error_code)              THEN display_dbrbr_error (error_code);              WITH rfl_label_ptr^,                DBCON_table.dbcon_rfl_info_block DO BEGIN               IF ((log_set_name <> rflf_set_name) OR                  (logical_vol_name <> rfl_logical_name) OR                   (vol_num <> rflf_vol_num))  "               THEN display_dbrbr_error (wrong_volume_mounted_err);  "                 END; (* with label and dbcon block *)                   (**)           (* Begin scanning tape until EOF or parity error.          (**)               eot_found := false;              WHILE (NOT eot_found) DO BEGIN                  magtape_read_result :=                read_rfl_magtape_chunk (read_from_device_code,                                         roll_forward_log.dcb,  "                                       num_words_in_rfl_tape_buffer, "                                        rfl_chunk_ptr^,                                        rfl_chunk_len,                                        error_code);                 IF ((magtape_read_result) AND                 (error_code <> bof_eof_err) AND                  (error_code <> rfl_parity_err) AND                 (error_code <> rfl_end_of_tape_err) AND                 (error_code <> rfl_device_not_ready_err))                THEN display_dbrbr_error (error_code);                  save_error := error_code;                   (**)              (* Detecting end-of-tape is not a critical error.               (**)                 IF ((magtape_read_result) AND                 (error_code = rfl_end_of_tape_err))                THEN magtape_read_result := false;                   IF ((magtape_read_result) OR (rfl_chunk_len = zero))                 THEN BEGIN      
20:  (* NLS tests *) 
    
   (*:nl:$ ' '     *) 
   (*:nl:$ 'Begin message' *)  
(* display_string := 
 #      'AN END-OF-FILE CONDITION HAS BEEN DETECTED ON THE MAGTAPE.'; *) # '   (*:nl:#*1 1009 'AN END-OF-FILE CONDITION HAS BEEN DETECTED ON THE MAGTAPE.' '     *) %   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) %!   length := nlread (MRBR_D, 1009, nlerr, display_string, len);     !   blank_pad (display_string, chars_in_long_str, length);     IF write_long_str (prompt_file, display_string, error_code)        THEN display_dbrbr_error (error_code);      
(* display_string := 
       'IF A PARITY ERROR OCCURRED, PLEASE UP THE MAGTAPE LU.'; *)   &   (*:nl:#*1 1010 'IF A PARITY ERROR OCCURRED, PLEASE UP THE MAGTAPE LU.' *) &%   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) %!   length := nlread (MRBR_D, 1010, nlerr, display_string, len);     !   blank_pad (display_string, chars_in_long_str, length);         IF write_long_str (prompt_file, display_string, error_code)        THEN display_dbrbr_error (error_code);      
(* display_string := 
 %      'DBRBR IS SUSPENDING...TYPE ''GO,DBRBR'' WHEN MAGTAPE IS UP''ED'; *) %     (*:nl:#*1 1011 'DBRBR IS SUSPENDING...TYPE ''GO,DBRBR'' &' *)     (*:nl:#        'WHEN MAGTAPE IS UP''ED' *)     (*:nl:$ 'End messages' *)  
   (*:nl:$ ' '    *) 
%   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) %!   length := nlread (MRBR_D, 1011, nlerr, display_string, len);     !   blank_pad (display_string, chars_in_long_str, length);         IF write_long_str (prompt_file, display_string, error_code)        THEN display_dbrbr_error (error_code);      
21:  (* NLS tests *) 
                         suspend_thyself(7);  (* Exec code 7 *)                          eot_found := true;                          (**)                      (* This may be a parity error or an EOF. "                     (* Backspace to just after the last good record. "                     (* Write an EOF, then rewind the tape.                      (**)                          (**)                      (* The A-series does not position the tape                      (* one record past a parity error, so if                       (* we are on an A-series, and a transmission  !                     (* error occurred, (RFL_device_not_ready_err), ! "                     (* then we do NOT want to backspace, or we will " !                     (* overwrite the last RFL chunk with the EOF. !                     (**)                          IF ((operating_system = rte6) OR "                         NOT (save_error = rfl_device_not_ready_err)) "                         THEN  "                           IF magtape_control (roll_forward_log.dcb, "                                                backspace_tape,                                                 error_code)  "                              THEN display_dbrbr_error (error_code); "                          IF magtape_control (roll_forward_log.dcb,                                           write_tape_eof,                                           error_code)                          THEN display_dbrbr_error (error_code);                           IF magtape_control (roll_forward_log.dcb,                                          rewind_tape,                                           error_code)                          THEN display_dbrbr_error (error_code);                          END (* parity error or EOF processing *)                         ELSE BEGIN (* we have read a magtape chunk *)         (**)      (* Each RFL chunk may consist of many TUF chunks.     (* Scan through each TUF chunk in the RFL chunk,      (* keeping the sequence # of last TUF chunk.      (**)          rfl_chunk_block := one; (* begins at block 1 *)         last_tuf_chunk  := false;         WHILE (NOT last_tuf_chunk) DO BEGIN      !      IF make_tuf_chunk_ptr (rfl_chunk_ptr^.blk[rfl_chunk_block],  !                              tuf_chunk_ptr,                                error_code)           THEN display_dbrbr_error (error_code);             WITH tuf_chunk_ptr^.chunk_head DO BEGIN            last_chunk_sequence_number := chunk_seq_num;                IF (blks_per_chunk < one) THEN BEGIN               rfl_corrupt;  
            GOTO 88; 
             END;              rfl_chunk_block := rfl_chunk_block + blks_per_chunk;           END; (* with *)             IF ((rfl_chunk_block*words_in_disc_block) > rfl_chunk_len)           THEN last_tuf_chunk := true;           END; (* while not last tuf chunk *)                        END; (* having read a RFL chunk *)                  END; (* while not eot found *)               END (* then magnetic tape rfl volume *)            ELSE BEGIN (* disc volume *)              (**)           (* Read and verify the RFL label.          (* Begin reading chunks similarly to reading the TUF  !         (* until the EOF is found, keeping track of last seq num. !         (**)              IF read_write_disc (read_code,                               roll_forward_log,                               rfl_label.reserved,                              num_blks_in_rfl_label,                              rfl_label_block_num,                               error_code)              THEN BEGIN 
               rfl_corrupt; 
               GOTO 88; 	               END; 	                  (**)            (* Verify that the label is correct.            (**)       !         WITH rfl_label, DBCON_table.dbcon_rfl_info_block DO BEGIN !             IF ((log_set_name <> rflf_set_name) OR                  (logical_vol_name <> rfl_logical_name) OR                   (vol_num <> rflf_vol_num))  "               THEN display_dbrbr_error (wrong_volume_mounted_err);  "                 END; (* with label and dbcon block *)                    (**)   !         (* Scan through each TUF chunk and collect sequence #'s.  !          (* Stop at TUF eol log record.            (**)                rfl_chunk_block := rfl_start_block;                eot_found := false;    (* RFL end-of-file indicator. *)                WHILE (NOT eot_found) DO BEGIN                   IF read_write_disc (read_code,                                  roll_forward_log,                                   rfl_chunk_ptr^.wds[one],                                  one, (* blocks to read *)   "                                rfl_chunk_block, (* block to read *) "                                 error_code)                  THEN display_dbrbr_error (error_code);                       IF make_tuf_chunk_ptr (rfl_chunk_ptr^.blk[one],                                      tuf_chunk_ptr,                                      error_code)                 THEN display_dbrbr_error (error_code);                   WITH tuf_chunk_ptr^ DO                 IF (rec_type = TUF_eof_indicator)                    THEN eot_found := true                    ELSE IF (rec_type <> chunk_head_log_code)                        THEN BEGIN                           rfl_corrupt; (* chunk head expected *)                          GOTO 88;                          END                        ELSE BEGIN                           last_chunk_sequence_number :=                                       chunk_head.chunk_seq_num;                           rfl_chunk_block := rfl_chunk_block +  #                                           chunk_head.blks_per_chunk;  #                         END; (* else look at chunk head *)                  END; (* while not eot found *)                   (* Update the rfl label to current RFL EOF block *)                rfl_label.current_eof_blk := rfl_chunk_block;                   IF read_write_disc (write_code,                                   roll_forward_log,                                   rfl_label.reserved,                                   num_blks_in_rfl_label,                                  rfl_label_block_num,                                  error_code)                  THEN display_dbrbr_error (error_code);                   END; (* case of rfl disc file *)        (**)  
   (* Close the rfl. 
   (**)         IF close_file (roll_forward_log, error_code) THEN;              (**)      (* (4) Start DBSPL and tell it to continue the RFL.     (**)          IF get_image_comm_buffer (image_comm_buffer)         THEN display_dbrbr_error (image_not_started_err);          (* set up the scheduling parameters for DBSPL *)      WITH dbspl_startup_buffer DO BEGIN         dbspl_comm_id := image_comm_buffer.dbspl_comm_id;        reply_comm_id := image_comm_buffer.spl_reply_comm_id;        END;        IF clear_comm_path (image_comm_buffer.dbspl_comm_id,                        image_comm_buffer.dbspl_comm_lock,                         error_code)        THEN display_dbrbr_error (error_code);        IF clear_comm_path (image_comm_buffer.spl_reply_comm_id,                         zero,                         error_code)        THEN display_dbrbr_error (error_code);        IF activate_dbspl ('XQ,DBSPL.RUN', dbspl_startup_buffer)       THEN display_dbrbr_error (dbspl_not_ready_err);        IF get_dbspl_reply (        image_comm_buffer.spl_reply_comm_id,  
      zero,  (* no lock *) 
      zero,  (* wait for message *)  
      mesg_buf_ptr^, 
	      reply_length, 	      universal_mesg_hdr_len,        error_code) THEN       display_dbrbr_error (dbspl_comm_err);      $   (* There is an A-series glitch where IDGET will not return DBSPL's *) $ $   (* ID segment address 'soon' after scheduling without wait, even   *) $ $   (* though DBSPL is obviously alive since it replies with the class *) $ $   (* message.                                                        *) $        take_a_nap (100);  (* 1 second nap *)             dbspl_is_scheduled := true;         IF setup_dbspl_message (to_spl_cont_log_code,                             error_code)        THEN display_dbrbr_error (error_code);             IF exchange_dbspl_message (mesg_buf_ptr^,                               to_spl_cont_log_mesg_len,                                mesg_buf_ptr^,                               reply_length,                               to_bm_max_mesg_len,                                error_code)         THEN display_dbrbr_error (error_code);         error_code := mesg_buf_ptr^.dbrbr.spl_contlog.status;         IF error_code <> no_image_err        THEN display_dbrbr_error (error_code);            (**)    (* Scan the TLF for matching chunk sequence number, then     (* spool everything past that point to the RFL.    (**)         IF make_log_record_ptr (tub_ptr^,                            log_rec_ptr,                             error_code) 	      THEN GOTO 77; 	           IF tuf_label_io (transaction_log_file,                      read_from_device_code,                      tlf_label,                      dummy_stats,                     error_code) 	      THEN GOTO 77; 	       chunk_address := tlf_label.logical_beg_of_tuf;        IF last_chunk_sequence_number = -1       THEN last_rfl_chunk_found := true       ELSE last_rfl_chunk_found := false;         eotuf_found := false;      "   WHILE ((NOT last_rfl_chunk_found) AND (NOT eotuf_found)) DO BEGIN "          Read_tuf_chunk (transaction_log_file,                        tlf_label,                       tub_ptr^,                        chunk_address,                        tub_blocks_read,                        dummy_stats,                        dummy_stats,                        error_code);            IF (error_code = logical_end_of_tuf_err)          THEN eotuf_found := true          ELSE IF (error_code <> no_image_err)              THEN GOTO 77              ELSE BEGIN                chunk_address := chunk_address +                     log_rec_ptr^.chunk_head.blks_per_chunk;                    IF ((chunk_address + tlf_label.num_dummy_blks) >                     transaction_log_file.fsize)                    THEN chunk_address := TUF_first_blk_num;                     IF (log_rec_ptr^.chunk_head.chunk_seq_num =                                 last_chunk_sequence_number)                    THEN last_rfl_chunk_found := true;                     END; (* else *)            END; (* while scanning for last spooled chunk *)            WHILE (NOT eotuf_found) DO BEGIN           read_tuf_chunk (transaction_log_file,                        tlf_label,                       tub_ptr^,                        chunk_address,                        tub_blocks_read,                        dummy_stats,                        dummy_stats,                        error_code);            IF (error_code = logical_end_of_tuf_err)          THEN eotuf_found := true          ELSE IF (error_code <> no_image_err)              THEN GOTO 77 	         ELSE BEGIN 	                 (**)              (* Tell DBSPL to spool out this chunk.              (**)      !            IF setup_dbspl_message (to_spl_spool_code, error_code) !                THEN GOTO 77;      #            blocks_in_chunk := log_rec_ptr^.chunk_head.blks_per_chunk; #                 WITH mesg_buf_ptr^.dbspl.spool DO BEGIN                  start_block := chunk_address;  "               end_block   := chunk_address + blocks_in_chunk - one; " 
               END;  
                IF send_dbspl_message                   (mesg_buf_ptr^,                    to_spl_spool_mesg_len,                     error_code)                 THEN GOTO 77;                     chunk_address := chunk_address + blocks_in_chunk;                 IF (chunk_address + tlf_label.num_dummy_blks) >                    transaction_log_file.fsize                THEN chunk_address := TUF_first_blk_num;                 WITH image_comm_buffer DO              IF get_dbspl_reply (spl_reply_comm_id,                                  zero, (* no comm lock *)                                  one,  (* don't wait for msg *)                                  mesg_buf_ptr^,                                 reply_length,                                 to_bm_spool_reply_mesg_len,                                 error_code)                THEN IF (error_code <> no_image_err)                    THEN GOTO 77                   ELSE (* no message *)  !               ELSE BEGIN (* spool reply received. Check status *) ! #                  error_code := mesg_buf_ptr^.dbrbr.spl_reply.status;  #                   IF (error_code <> no_image_err)                        THEN GOTO 77;                    END; (* else check dbspl status *)                  END; (* else spool out this chunk *)            END; (* while not eoTUF found *)             (**)      (* Tell DBSPL to end the log, then finish.      (**)          error_code := no_image_err;       77: (* Branch to here if an error occurs during RFL recovery *)           save_image_error := error_code;         IF setup_dbspl_message (to_spl_end_log_code, error_code)         THEN display_dbrbr_error (error_code);         IF send_dbspl_message (mesg_buf_ptr^,                            to_spl_end_log_mesg_len,                            error_code)         THEN display_dbrbr_error (error_code);         REPEAT  (* gobble up dbspl reply messages *)             WITH image_comm_buffer DO         IF get_dbspl_reply (spl_reply_comm_id,                            zero,  (* no comm lock *)                             zero,  (* wait for message *)                             mesg_buf_ptr^,                            reply_length,                             to_bm_spool_reply_mesg_len,                             error_code)            THEN display_dbrbr_error (error_code);             error_code := mesg_buf_ptr^.dbrbr.spl_endlog.status;            IF (error_code <> no_image_err)            THEN display_dbrbr_error (error_code);             UNTIL (mesg_buf_ptr^.dbrbr.request =                            to_bm_spl_endlog_reply_mesg_code);             (**)      (* DBSPL has finished, so tell it to terminate. *)      (**)          IF setup_dbspl_message (to_spl_finis_code, error_code)         THEN display_dbrbr_error (error_code);         IF send_dbspl_message (mesg_buf_ptr^,                            to_spl_finis_mesg_len,                            error_code)         THEN display_dbrbr_error (error_code);         error_code := mesg_buf_ptr^.dbrbr.spl_finis.status;         IF (error_code <> no_image_err)        THEN display_dbrbr_error (error_code);        dbspl_is_scheduled := false;         IF (save_image_error <> no_image_err)        THEN display_dbrbr_error (save_image_error);     99: (* Label to skip recovery of the rfl *)         display_string := ' ';  (* precede with a blank line *)         IF write_long_str (list_file, display_string, error_code)        THEN display_dbrbr_error (error_code);         (* display_string := 'ROLL-FORWARD LOG HAS BEEN RECOVERED.'; *)    (*:nl:#*1 1012 'ROLL-FORWARD LOG HAS BEEN RECOVERED.' *) %   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) %!   length := nlread (MRBR_D, 1012, nlerr, display_string, len);     !   blank_pad (display_string, chars_in_long_str, length);         IF write_long_str (list_file,                       display_string,                       error_code)        THEN display_dbrbr_error (error_code);      88: (* If roll-forward log does not need recovering *)      END; (* roll forward log recovery *)  .  