 $PASCAL ',7 92081-1X283 REV.5010'$  !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18283                                        *)  ! !(* RELOC:   92081-1X283                                        *)  ! !(*                                                             *)  ! (* Date last modified: <880829.1704>  !(*                                                             *)  ! !(***************************************************************)  !     $ Heap 0 $  	$ Recursive OFF $  	 $ Subprogram  $   $ Range OFF $       PROGRAM PDBMS;      $(*********************************************************************)  $ $(*                                                                   *)  $ $(* IMAGE/1000 Data Base Management System Library                    *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(* The IMAGE library subroutines allow users to write program to     *)  $ $(* enter, inquire about and manipulate data in an IMAGE/1000         *)  $ $(* data base.  Fourteen intrinsics are provided.  The intrinsics     *)  $ $(* and their functions are:                                          *)  $ $(*                                                                   *)  $ $(* DBBEG  Defines the beginning of a transaction (series of          *)  $ $(*        logically related intrinsics)                              *)  $ $(* DBCLS  Closes the data base files.                                *)  $ $(* DBCTL  Provides control data record posting.                      *)  $ $(* DBDEL  Deletes existing data records.                             *)  $ $(* DBEND  Defines the end of a transaction.                          *)  $ $(* DBFND  Locates the beginning of a data chain in prepration for    *)  $ $(*        access to entries in the chain.                            *)  $ $(* DBGET  Reads data items.  Several modes are provided.             *)  $ $(* DBINF  Provides information about the organization and components *)  $ $(*        of the data base being accessed.                           *)  $ $(* DBLCK  Locks a data base or data set temporarily to provide       *)  $ $(*        exclusive access.                                          *)  $ $(* DBMEM  Provides the means to store user data in a log record.     *)  $ $(* DBOPN  Initiates access to the data base and define's the user's  *)  $ $(*        level of access.                                           *)  $ $(* DBPUT  Adds new data records.                                     *)  $ $(* DBUNL  Unlocks a data base or set previously locked by DBLCK.     *)  $ $(* DBUPD  Modifies the values of data items in existing data records.*)  $ $(*                                                                   *)  $ $(* Historical comment:                                               *)  $ $(*   The 92069 IMAGE/1000 data base system provides the unstarred    *)  $ $(*   intrinsics listed above.  They were written entirely in         *)  $ $(*   HP1000 assembler language.  The 92081 IMAGE/1000 data base      *)  $ $(*   system additionally provides the four starred instrinsics,      *)  $ $(*   which are necessary for transaction processing and logging and  *)  $ $(*   recovery.                                                       *)  $ $(*      The responsibilities of each intrinsic have been divided     *)  $ $(*   into a 'user side' and 'global side'.  The user side is         *)  $ $(*   handled by the MACRO and PASCAL routines in this library.       *)  $ $(*   The global side is handled by the 'Data Base MONitor' program   *)  $ $(*   DBMON (also referred to as the buffer manager).  It controls    *)  $ $(*   all access to data base data records.  The user side is only    *)  $ $(*   responsible for syntax checking and maintenance of the local]   *)  $ $(*   run table.                                                      *)  $ $(*                                                                   *)  $ $(* PGMR: <STC> <EDB> <MRL>                                           *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $ $ Page $  $ List OFF, Include '[IMAGE', List ON $       #(********************************************************************) # #(*                      CONSTANT DECLARATIONS                       *) # #(********************************************************************) #     CONST          exec_time_code = 11;          severe = 1;     non_severe = zero;          max_local_run_table_size =              (* in words *)         local_headr_len +         (itmtbl_entry_len * max_items) +        (settbl_entry_len * max_data_sets) +  !      (((max_items + one) DIV 2) + (max_data_sets + one) DIV 2) +  !       (lc_path_table_len * max_paths * max_data_sets) +         (max_data_sets * (max_items_per_dataset + one) DIV 2 );          get_entire_string_code = -1;      ibase_param_len = max_db + one;      
   mesg_ptr_tbl_index = 0; 
 
   max_return_info = 2048; 
        stat_array_word_len = 10;      %   want_item = 1;  (* flags to routines to indicate what info is needed *) %    want_set = 2;         (* DBINF return buffer length constants *)      m102_return_len = 13;     m202_return_len = 17;     m302_return_len = 2;      m401_return_len = 7;      m801_return_len = 4;          (* DBINF mode constants *)   	   mode202 = 202;  	 	   mode801 = 801;  	        (* DBINF data item type codes returned by dbinf *)   
   type_char = 'X';  
 
   type_real = 'R';  
    type_integer = 'I';         (* DBINF data set type codes returned by dbinf *)     type_manual = 'M';      type_automatic = 'A';     type_detail = 'D';          (* DBLCK lock request buffer length *)      words_in_lock_request_buffer = 2048;       chars_in_lock_request_buffer = words_in_lock_request_buffer *                                     chars_in_word;  $ Page $  #(********************************************************************) # #(*                      TYPE DECLARATIONS                           *) # #(********************************************************************) #     TYPE     memory_type = ARRAY [1..32767] OF Short_int;          Ptr_to_memory_type = ^memory_type;              word_char_type =                (* very short string *)        PACKED ARRAY [1..chars_in_word] OF char;         stat_array =                    (* status array *)         ARRAY [1..stat_array_word_len] OF short_int;      #   ibase_type =                    (* user data base namr parameter *) #       ARRAY [1..ibase_param_len] OF short_int;         dbopn_ibase_type = RECORD        node_number : short_int;        root_name   : new_file_name;        END;      "   item_list_type =                (* list of item names/numbers *)  "       ARRAY [1..max_words_in_user_item_list] OF short_int;         item_value_buffer_type =        (* list of item values *)        ARRAY [1..max_words_in_value_list] OF short_int;      !   lock_request_buffer =           (* DBLCK lock request buffer *) !       ARRAY [1..words_in_lock_request_buffer] OF short_int;           lock_request_char_buffer =      (* DBLCK set name list buf *)         PACKED ARRAY [1..chars_in_lock_request_buffer] OF char;          ptr_lock_char_buf = ^lock_request_char_buffer;           #   (*****************************************************************) # #   (* Following is a definition of the DBBUF table.                 *) # #   (* This table contains much of the information needed to manage  *) # #   (* message traffic between the user and the buffer manager,      *) # #   (* and manage the local database run tables.                     *) # #   (*****************************************************************) #     #   database_mesg_len_table_type =  (* database message length table *) #       ARRAY [1..max_db] OF short_int;           (* table of the worst size message required per data base *)       msg_tbl_type = ARRAY [1..max_db] OF short_int;       %   database_run_table_type =       (* database local run table pointers *) %       ARRAY [1..max_db] OF ptr_local_run_table_hdr;          statistics_table_type = (* statistics buffers pointers. *)         ARRAY [1..max_db] OF statistics_buffer_ptr_type;         DBBUF_table_type =   (* contains local system info *)        RECORD  "         process_info:             (* current process information *) "             process_description_type;            open_count: short_int;    (* open database count *)  "         user_comm_id : short_int;  (* user communication id word *) " #         comm_info : image_comm_buffer_type;  (* global comm. info *)  #           cur_mesg_len: short_int;  (* current message length *)             max_mesg_len:             (* message length array *)               database_mesg_len_table_type;   $         cur_mesg_buf:             (* current message buffer pointer *)  $             ptr_to_bm_mesg_type;      %         db_run_table:             (* database run table pointer array *)  %             database_run_table_type;  &         cur_run_table:            (* current database run table pointer *)  &             ptr_local_run_table_hdr;               statistics_table :        (* Stat buffer pointers. *)              statistics_table_type;  !         cur_stat_buffer  :        (* Current stat buffer ptr. *)  !             statistics_buffer_ptr_type;                current_item_list : tempx_table_type;           current_set_and_db: short_int; (* set*256 + db# *)            current_num_keys  : short_int;       
         END; (* RECORD *) 
        ptr_dbbuf_table =               (* pointer definition *)         ^dbbuf_table_type;  $ Page $  #   (*****************************************************************) # #   (* The following types are the structures of the status buffer   *) # #   (* returned after execution of an intrinsic. For DBINF, the      *) # #   (* records are the return buffer information for the various     *) # #   (* DBINF modes.                                                  *) # #   (*****************************************************************) #     "   beg_buffer =                    (* DBBEG return status buffer *)  "       RECORD           status: short_int;            logging_state : logging_states;           xaction_num : long_int;  
         END; (* RECORD *) 
     "   cls_buffer =                    (* DBCLS return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   ctl_buffer =                    (* DBCTL return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   del_buffer =                    (* DBDEL return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   end_buffer =                    (* DBEND return status buffer *)  " 	      beg_buffer;  	     "   fnd_buffer =                    (* DBFND return status buffer *)  "       RECORD           status: short_int;            unused: short_int;            current_rec: long_int;            current_chain_len: long_int;            current_chain_tail: long_int;           current_chain_head: long_int;  
         END; (* RECORD *) 
     "   get_buffer =                    (* DBGET return status buffer *)  "       RECORD           status: short_int;            return_data_len: short_int;           current_record_num: long_int;  
         unused: long_int; 
          prev_record_num: long_int;            next_record_num: long_int;   
         END; (* RECORD *) 
        lck_buffer =                    (* DBLCK return buffer *)        RECORD           status: short_int;   
         END; (* RECORD *) 
     #   m101_buffer =                   (* DBINF mode 101 return buffer *)  #       RECORD           item_num: short_int;   
         END; (* RECORD *) 
     #   m102_buffer =                   (* DBINF mode 102 return buffer *)  # 
      PACKED RECORD  
          item_name: item_name_type;            unused1: PACKED ARRAY [1..10] OF char;   
         item_type: char;  
          unused2: char;            sub_item_len: short_int;            sub_item_count: short_int;            unused3: long_int;   
         END; (* RECORD *) 
     '   MX03_MX04_buffer =              (* DBINF modes x03 and x04 return buffer *) '       RECORD           num_avail_items: short_int;           item_num: ARRAY [1..max_items] OF short_int;   
         END; (* RECORD *) 
     #   M201_buffer =                   (* DBINF mode 201 return buffer *)  #       RECORD           set_num: short_int;  
         END; (* RECORD *) 
     #   M202_buffer =                   (* DBINF mode 202 return buffer *)  # 
      PACKED RECORD  
 #         set_name: file_name;      (* set name must take up 8 words *) # $         unused0 : packed array [1..10] of char;   (* hence unused0  *)  $          set_type: char;           unused1: char;            entry_word_len: short_int;            blocking_factor: short_int;           unused2: long_int;            num_entries_in_set: long_int;           set_capacity: long_int;  
         END; (* RECORD *) 
     #   M301_buffer =                   (* DBINF mode 301 return buffer *)  #       RECORD           num_paths: short_int;           path_info: ARRAY [0..max_paths] OF   	            RECORD 	                set_num: short_int;                 search_item_num: short_int;                 sort_item_num: short_int;                 END; (* RECORD *)  
         END; (* RECORD *) 
     #   m302_buffer =                   (* DBINF mode 302 return buffer *)  #       RECORD           search_item_num: short_int;           master_num     : short_int;  
         END; (* RECORD *) 
     #   m40x_buffer =                   (* DBINF mode 40x return buffer *)  #       RECORD           last_accessed_rec: long_int;            previous_rec: long_int;           next_record: long_int;            current_path: short_int;   
         END; (* RECORD *) 
        m50x_buffer =           (* DBINF modes 505 and 506 *)        statistics_buffer_type;       #   m801_buffer =                   (* DBINF mode 801 return buffer *)  #       RECORD           num_blocks_used: long_int;            total_avail_blocks: long_int;   (* max number *)   
         END; (* RECORD *) 
     "   mem_buffer =                    (* DBMEM return status buffer *)  " 	      beg_buffer;  	     "   opn_buffer =                    (* DBOPN return status buffer *)  "       RECORD           status: short_int;            access_level: short_int;            length_run_table: short_int;            hi_access_indic: short_int;           db_access: db_access_type;            sys_log_stat: logging_states;  
         END; (* RECORD *) 
     "   put_buffer =                    (* DBPUT return status buffer *)  "       RECORD           status: short_int;            buffer_word_len: short_int;           new_rec_num: long_int;            num_rec_on_chain: long_int;           pred_rec_num: long_int;           succ_rec_num: long_int;  
         END; (* RECORD *) 
     "   und_buffer =                    (* DBUND return status buffer *)  " 	      beg_buffer;  	     "   unl_buffer =                    (* DBUNL return status buffer *)  "       RECORD           status: short_int;   
         END; (* RECORD *) 
     "   upd_buffer =                    (* DBUPD return status buffer *)  "       RECORD           status: short_int;            return_data_len: short_int;    (* word len *)  
         END; (* RECORD *) 
     #   return_buffer_type =            (* generic return status buffer *)  #       RECORD  
         CASE short_int OF 
 
            1: (* DBBEG *) 
                (beg: beg_buffer);   
            2: (* DBCLS *) 
                (cls: cls_buffer);   
            3: (* DBCTL *) 
                (ctl: ctl_buffer);   
            4: (* DBDEL *) 
                (del: del_buffer);   
            5: (* DBEND *) 
                (endb: end_buffer);  
            6: (* DBFND *) 
                (fnd: fnd_buffer);   
            7: (* DBGET *) 
                (get: get_buffer);               101: (* DBINF mode 101 *)                  (m101: m101_buffer);               102: (* DBINF mode 102 *)                  (m102: m102_buffer);               104: (* DBINF mode 104 *)                  (mx03_mx04: mx03_mx04_buffer);               201: (* DBINF mode 201 *)                  (m201: m201_buffer);               202: (* DBINF mode 202 *)                  (m202: m202_buffer);               301: (* DBINF mode 301 *)                  (m301: m301_buffer);               302: (* DBINF mode 302 *)                  (m302: m302_buffer);               401: (* DBINF mode 401 *)                  (m40x: m40x_buffer);               505: (* DBINF modes 505 and 506 *)                 (m50x: m50x_buffer);               801: (* DBINF mode 801 *)                  (m801: m801_buffer);   
            8: (* DBLCK *) 
                (lck: lck_buffer);   
            9: (* DBMEM *) 
                (mem: mem_buffer);               10: (* DBOPN *)                  (opn: opn_buffer);               11: (* DBPUT *)                  (put: put_buffer);               12: (* DBUND *)                  (und: und_buffer);               13: (* DBUNL *)                  (unl: unl_buffer);               14: (* DBUPD *)                  (upd: upd_buffer);   
         END; (* RECORD *) 
        ptr_return_buffer =             (* pointer definition *)   
      ^return_buffer_type; 
 $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #     (**** Parse a list of data sets into a set number list ****)      FUNCTION parse_data_set_list   $ Alias 'Img.ParseSetList' $      (VAR set_list : lock_request_buffer;       VAR num_list : short_int; (* First word of the buffer *)      VAR error    : short_int) : Boolean;     EXTERNAL;          $ List OFF, Include '[XDTDY', List ON $   $ List OFF, Include '[XDFMP', List ON $           (**** Get the program name: System Dependent! ****)       PROCEDURE get_program_name  $ Alias 'PNAME' $      (VAR program_name : prog_name);     EXTERNAL;          #(* Fill_with_blanks fills the specified data record with blanks.    *) #     PROCEDURE fill_with_blanks $ALIAS 'DBFWW'$     (     length: short_int;        VAR data_rec: data_record_type;           word_blanks: word_char_type);     EXTERNAL;          (**** Fill a buffer with a value ****)      PROCEDURE fill_with_value  $ Alias 'DBFWW' $     (    length : short_int;       VAR buffer : statistics_buffer_type;          value  : short_int);     EXTERNAL;      $(* Retcl returns the specified class number.                         *)  $     FUNCTION RETCL $ALIAS 'RETCL'$     ( class_num: short_int): BOOLEAN;     EXTERNAL;      (* Lock/unlock resource number externals *)   
$ Include '[XDSEM' $ 
     $(* Gets the communication buffer information                         *)  $ 
$ Include '[XDGCB' $ 
      $ List OFF, Include '[XDMSG', List ON $ (* Message externals *)        "$ List OFF, Include '[XDLDP', List ON $ (* Local dormant program *)  "     $(* Get_run_table_and_mesg_buf returns the current run table address  *)  $ $(* the message buffer address.                                       *)  $     PROCEDURE get_run_table_and_mesg_buf $ALIAS 'DBGRT'$     ( VAR run_table_index: short_int;       VAR run_table: ptr_local_run_table_hdr;       VAR mesg_buf: ptr_to_bm_mesg_type);     EXTERNAL;      PROCEDURE trim_run_table $ ALIAS 'DBTRM' $     ( VAR run_table_index : short_int;        VAR num_words_to_keep : short_int;        VAR return_status : short_int);     EXTERNAL;      $(* Move_run_table moves a local run table from one area to another.  *)  $     PROCEDURE MOVE_RUN_TABLE $ALIAS 'DBMVW'$     ( VAR local_hdr : Local_run_table_header_type;        VAR dest_buf: local_run_table_header_type;            num_of_words: short_int);     EXTERNAL;          (**** Copy the statistics buffer. ****)       PROCEDURE copy_statistics_buffer  $ Alias 'DBMVW' $      (    accumulated_stats : statistics_buffer_type;       VAR user_buffer       : m50x_buffer;          number_of_words   : short_int);      EXTERNAL;          $(* DBBUF returns the address of the dbbuf table.                     *)  $     FUNCTION DBBUF: ptr_dbbuf_table;     EXTERNAL;      $(* DBFRT finds a local run table.                                    *)  $     PROCEDURE DBFRT   
   ( VAR ibase: short_int; 
 
         flag: short_int;  
 
     VAR index: short_int; 
      VAR stat: short_int );      EXTERNAL;      $(*Dbfdi finds a data item, given the data item name/number           *)  $     PROCEDURE DBFDI      ( VAR item_name: item_set_name_type;    (* input *)  $     VAR item_number: short_int;           (* returns the item number *) $ $     VAR accessibility_flag: short_int;    (* accessibility indicator *) $ $     VAR item_table_address: short_int);   (* item table offset       *) $    EXTERNAL;      $(* DBFDS finds the data set, given the set name/number                *) $     PROCEDURE DBFDS      ( VAR set_name: item_set_name_type;     (* input *)  $     VAR set_number: short_int;            (* returns the set number *)  $ $     VAR accessibility_flag: short_int;    (* accessibility indicator*)  $ $     VAR set_table_address: short_int);    (* data set control block *)  $ $   EXTERNAL;                               (*   offset within run tbl*)  $     $(* DBGBF gets a buffer (slice of background memory)                  *)  $     PROCEDURE DBGBF   
   (     index: short_int; 
          len: short_int;  
     VAR avail: short_int; 
      VAR status: short_int);     EXTERNAL;      $(* DBRBF returns a buffer                                            *)  $     PROCEDURE DBRBF      (      index: short_int;        VAR  status: short_int);      EXTERNAL;      $(* Process_item_list processes the item list,                        *)  $ $(* creating the tempx table in DBBUF's current_item_list.            *)  $     PROCEDURE process_item_list $ALIAS 'DBPIL'$      ( VAR item_list: item_list_type;        VAR dscb_entry_ptr: ptr_dscb_entry;       VAR num_keys: short_int;        VAR status: short_int);     EXTERNAL;      PROCEDURE process_item      $ALIAS 'DBPIL'$      ( VAR item_list: int_or_char;       VAR dscb_entry_ptr: ptr_dscb_entry;       VAR num_keys: short_int;        VAR status: short_int);     EXTERNAL;      $(* Move_item_values_to_data_record does just that, moves item values *)  $ $(* from the item value buffer to the data record.                    *)  $     PROCEDURE move_item_values_to_data_record $ALIAS 'DBMDR'$      ( VAR data_record: data_record_type;        VAR item_value_buffer: item_value_buffer_type;        VAR buf_word_len: short_int);     EXTERNAL;      $(* Move_one_item_value moves a item value from one area into         *)  $ $(* another.                                                          *)  $     PROCEDURE move_one_item_value $ALIAS 'DBMVW'$      ( VAR from_item: item_value_type;       VAR to_item: item_value_type;           num_words: short_int);      EXTERNAL;      $(* Move_data_values moves a data value from one area into another.   *)  $     PROCEDURE move_data_values $ALIAS 'DBMVW'$     ( VAR from_data_values: data_record_type;       VAR to_data_values: data_record_type;           num_words: short_int);      EXTERNAL;      $(* Find_item_in_user_buffer locates an item within the tempx table.  *)  $     PROCEDURE find_item_in_user_buffer $ALIAS 'DBCBI'$     (     item_number: item_num_type;  #     VAR return_index: short_int); (* returned index into user buf  *) # #   EXTERNAL;                       (* -1 if not in tempx table.     *) # $ Page $  #(* The following is a set of EXTERNAL declarations for assigning    *) # #(* pointer addresses (either directly or with an offset).           *) #     #(* Item_set_id_addr sets up a pointer to a item or set identifier.  *) # FUNCTION item_set_id_addr $ALIAS '.DRCT', DIRECT$      ( old_addr: short_int ): ptr_item_set_name_type;      EXTERNAL;      (* Set_name_addr creates a pointer to a set name *)   FUNCTION set_name_addr  $ Alias '.DRCT', Direct $      (name : short_str) : ptr_item_set_name_type;      EXTERNAL;      #(* Lock_table_entry_addr sets up a pointer to a lock table entry.   *) #     FUNCTION lock_table_addr $ALIAS '.DRCT', DIRECT$     ( old_addr: short_int ): ptr_lock_char_buf;     EXTERNAL;          (* Make pointer to detail set's path table. *)      PROCEDURE make_path_table_ptr  $ Alias 'DBPTR' $     (VAR run_table : ptr_local_run_table_hdr;          offset    : short_int;      VAR path_ptr  : ptr_path_table);     EXTERNAL;          #(* Rt_rm_set_ptr_addr changes a local run table offset into a       *) # #(* pointer to a user message buffer.                                *) #     PROCEDURE RT_RM_SET_PTR_ADDR $ALIAS 'DBPTR'$     ( VAR old_addr: ptr_local_run_table_hdr;            offset: short_int;        VAR new_addr: ptr_to_user_mesg_type);     EXTERNAL;      #(* Rt_bm_set_ptr_addr changes a local run table offset into a       *) # #(* pointer to a dbmon message buffer.                               *) #     PROCEDURE RT_BM_SET_PTR_ADDR $ALIAS 'DBPTR'$     ( VAR old_addr: ptr_local_run_table_hdr;            offset: short_int;        VAR new_addr: ptr_to_bm_mesg_type);     EXTERNAL;      #(* RM_rt_set_ptr_addr changes a user message buffer offset into a   *) # #(* pointer to the local run table.                                  *) #     PROCEDURE RM_RT_SET_PTR_ADDR $ALIAS 'DBPTR'$     ( VAR old_addr: ptr_to_user_mesg_type;            offset: short_int;        VAR new_addr: ptr_local_run_table_hdr);     EXTERNAL;      #(* Rt_it_set_ptr_addr changes a local run table offset into a       *) # #(* pointer to a local item table.                                   *) #     PROCEDURE RT_IT_SET_PTR_ADDR $ALIAS 'DBPTR'$     ( VAR old_addr: ptr_local_run_table_hdr;            offset: short_int;        VAR new_addr: ptr_local_item_table);      EXTERNAL;      #(* Rt_dscb_set_ptr_addr changes a local run table offset into a     *) # #(* pointer to a local dataset control block.                        *) #     PROCEDURE RT_DSCB_SET_PTR_ADDR $ALIAS 'DBPTR'$     ( VAR old_addr: ptr_local_run_table_hdr;            offset: short_int;        VAR new_addr: ptr_local_dscb);      EXTERNAL;      #(* Rt_dsit_set_ptr_addr changes a local run table offset into a     *) # #(* pointer to a local dataset information table.                    *) #     PROCEDURE RT_DSIT_SET_PTR_ADDR $ALIAS 'DBPTR'$     ( VAR old_addr: ptr_local_run_table_hdr;            offset: short_int;        VAR new_addr: ptr_local_ds_inf_table);      EXTERNAL;      #(* Rt_dscbe_set_ptr_addr changes a local run table offset into a    *) # #(* pointer to a local dataset control block entry.                  *) #     PROCEDURE RT_DSCBE_SET_PTR_ADDR $ALIAS 'DBPTR'$      ( VAR old_addr: ptr_local_run_table_hdr;            offset: short_int;        VAR new_addr: ptr_dscb_entry);      EXTERNAL;      #(* Dsit_pt_set_ptr_addr changes a dataset information table offset  *) # #(* into a pointer to a local path table.                            *) #     PROCEDURE DSIT_PT_SET_PTR_ADDR $ALIAS 'DBPTR'$     ( VAR old_addr: ptr_local_ds_inf_table;           offset: short_int;        VAR new_addr: ptr_path_table);      EXTERNAL;      #(* Rt_ite_set_ptr_addr changes a local run table offset into a      *) # #(* pointer to a local item table entry.                             *) #     PROCEDURE RT_ITE_SET_PTR_ADDR $ALIAS 'DBPTR'$      ( VAR old_addr: ptr_local_run_table_hdr;            offset: short_int;        VAR new_addr: ptr_item_table_entry);      EXTERNAL;      (* Change BM message buffer into user message buffer *)       PROCEDURE TM_RM_SET_PTR_ADDR $ALIAS 'DBPTR'$     ( VAR old_addr: ptr_to_bm_mesg_type;            offset: short_int;        VAR new_addr: ptr_to_user_mesg_type);     EXTERNAL;      (* Change BM message buffer into USR message buffer *)      PROCEDURE BM_USR_SET_PTR_ADDR $ALIAS 'DBPTR'$      ( VAR old_addr: ptr_to_bm_mesg_type;            offset: short_int;        VAR new_addr: ptr_to_user_mesg_type);     EXTERNAL;          (**** Get a communication id (class number) ****)       FUNCTION get_comm_id   $ Alias 'GETCL' $     (VAR comm_id : short_int;          local_global_indicator : short_int) : Boolean;     EXTERNAL;          (**** Release the user's communication id (class number) ****)      FUNCTION release_comm_id  $ Alias 'RETCL' $      (VAR comm_id : short_int) : Boolean;      EXTERNAL;          (* Get the user's Session ID word. *)       FUNCTION get_session_ID  $ Alias 'LOGLU' $     (VAR session_word : Short_int) : Short_int;     EXTERNAL;          (**** Get the A-series session number of this program ****)       FUNCTION user_session_number  $ Alias 'USNUM' $      : short_int;      EXTERNAL;      (**** Get various pointers for database ****)       FUNCTION get_database_pointers   $ Alias 'Img.GetPointers' $     (    ibase         : short_int;      VAR dbbuf_ptr     : ptr_dbbuf_table;      VAR message_ptr   : ptr_to_bm_mesg_type;      VAR run_table_ptr : ptr_local_run_table_hdr;      VAR stats_buf_ptr : statistics_buffer_ptr_type;       VAR error         : short_int) : Boolean;      EXTERNAL;          (**** Get various pointers for multi-database call ****)      FUNCTION multi_db_pointers   $ Alias 'Img.GetPointers' $     (    ibase         : short_int;      VAR dbbuf_ptr     : ptr_dbbuf_table;      VAR message_ptr   : ptr_to_bm_mesg_type;      VAR run_table_ptr : ptr_local_run_table_hdr;      VAR stats_buf_ptr : statistics_buffer_ptr_type;       VAR error         : short_int) : Boolean;      EXTERNAL;          (**** Remote dbbegin external ****)       PROCEDURE Remote_dbbegin $ Alias 'RBBEG' $     (VAR ibase : ibase_type;   
    VAR itext : text_str;  
 
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len : short_int);     EXTERNAL;          (**** Remote DBCLOSE external ****)       PROCEDURE remote_dbclose   $ Alias 'RBCLS' $     (VAR ibase  : short_int;       VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type);      EXTERNAL;      (**** Remote DBCONTROL external ****)       PROCEDURE remote_dbcontrol  $ Alias 'RBCTL' $      (VAR ibase : ibase_type;   
    VAR dummy : short_int; 
 
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);     EXTERNAL;          (**** Remote DBDELETE external ****)      PROCEDURE remote_dbdelete  $ Alias 'RBDEL' $     (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type);      EXTERNAL;          (**** remote DBEND external ****)       PROCEDURE remote_dbend  $ Alias 'RBEND' $      (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len  : short_int);      EXTERNAL;          (**** remote DBFIND external ****)      PROCEDURE remote_dbfind  $ Alias 'RBFND' $     (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type;      VAR item_id: item_set_name_type;      VAR item_value : item_value_type);     EXTERNAL;          (**** remote DBGET external ****)       PROCEDURE remote_dbget  $ Alias 'RBGET' $      (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR item_values_buffer : data_record_type;      VAR user_argument : argument_type);      EXTERNAL;          (**** remote DBINFO external ****)      PROCEDURE remote_dbinfo   $ Alias 'RBINF' $      (VAR ibase : ibase_type;       VAR data_id : item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : stat_array;       VAR buffer : return_buffer_type);      EXTERNAL;          (**** remote DBLOCK external ****)      PROCEDURE remote_dblock  $ Alias 'RBLCK' $     (VAR ibase : ibase_type;       VAR lock_request : lock_request_buffer;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);     EXTERNAL;          (**** remote DBMEMO external ****)      PROCEDURE remote_dbmemo   $ Alias 'RBMEM' $      (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len : short_int);     EXTERNAL;          (**** remote DBOPEN external ****)      PROCEDURE remote_dbopen   $ Alias 'RBOPN' $      (VAR ibase : dbopn_ibase_type;       VAR level : level_word_type;      VAR op_mode : short_int;      VAR istat : return_buffer_type);     EXTERNAL;          (**** remote DBPUT external ****)       PROCEDURE remote_dbput  $ Alias 'RBPUT' $      (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR item_value_buffer : item_value_buffer_type);     EXTERNAL;          (**** remote DBUNDO external ****)      PROCEDURE remote_dbundo   $ Alias 'RBUND' $      (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len  : short_int);      EXTERNAL;          (**** remote DBUNLOCK external ****)      PROCEDURE remote_dbunlock   $ Alias 'RBUNL' $      (VAR ibase : ibase_type;       VAR setlst: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);     EXTERNAL;          (**** remote DBUPDATE external ****)      PROCEDURE remote_dbupdate   $ Alias 'RBUPD' $      (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR user_buffer : data_record_type);     EXTERNAL;          (**** Create a pointer to extended message area for ****)   (**** DBOPN runtable chunks.                        ****)       PROCEDURE make_chunk_buf_ptr     $ Alias 'DBPTR' $            (VAR buffer_ptr : Ptr_to_user_mesg_type;                 offset     : Short_int;             VAR chunk_ptr  : Ptr_to_memory_type);     EXTERNAL;          (**** Overwrite the chunk header of a run table chunk. ****)      PROCEDURE overwrite_header   $ Alias 'DBMVW' $            (VAR source_buf : Short_int;             VAR dest_buf   : Short_int;                 num_words  : Short_int);      EXTERNAL;      $ Page $  #(********************************************************************) # #(*                        make_ibase_list                           *) # #(********************************************************************) # #(*                                                                  *) # #(* Purpose:                                                         *) # #(*    To verify that a mode 3 transaction call was given an at-sign *) # #(*    for the ibase parameter, and construct the ibase list         *) # #(*    for those open databases.                                     *) # #(*                                                                  *) # #(* Parameters:                                                      *) # #(*    (in)  (1) The supplied ibase.                                 *) # #(*    (out) (2) The constructed ibase list.                         *) # #(*    (out) (3) An error code if an error is found.                 *) # #(*                                                                  *) # #(* Function result: 'True' if an error occurs.                      *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION make_ibase_list   $ Alias 'Img.MakeBaseList' $      (VAR ibase : ibase_type;       VAR blist : ibase_type;       VAR status: short_int) : boolean;       LABEL 999; (* error exit *)       VAR      dbbuf_ptr : ptr_dbbuf_table;   
   i,ix      : short_int;  
    chars     : int_or_char;       BEGIN (* make ibase list *)          make_ibase_list := true;  (* assume an error will occur *)          chars.int_val :=  ibase[one];      !   IF (chars.char_val[one] <> '@') THEN BEGIN (* not an at-sign *) !       status := db_not_open_to_user_err;        GOTO 999;         END;         dbbuf_ptr := dbbuf;     ix := zero; (* number of db's open *)         WITH dbbuf_ptr^ DO      FOR i := one TO max_db DO  (* make ibase list *)             IF (db_run_table[i] <> nil) THEN BEGIN           ix := ix + one;           blist[ix+one] := i;           END;          IF (ix = zero) THEN BEGIN        status := db_not_open_to_user_err;        GOTO 999;         END;      
   blist[one] := ix; 
        make_ibase_list := false; (* no error *)       999: (* error exit *)       
END; (* make_ibase_list *) 
 $ Page $  #(********************************************************************) # #(*                                                                  *) # #(*  procedure set_getter                                            *) # #(*                                                                  *) # #(*  purpose: This procedure returns                                 *) # #(*                                                                  *) # #(*           (1) dataset number                                     *) # #(*           (2) dataset control block pointer.                     *) # #(*           (3) the error 'illegal set reference' if the           *) # #(*               dataset number is zero or the dataset is not       *) # #(*               accessible                                         *) # #(*                                                                  *) # #(********************************************************************) #     FUNCTION set_getter   $ Alias 'Img.SetGetter' $      (VAR set_id: item_set_name_type;       VAR run_table : ptr_local_run_table_hdr;      VAR set_number: short_int;      VAR dscb_ptr  : ptr_dscb_entry;       VAR status: short_int) : Boolean;       LABEL 999;  (* error exit *)      VAR   #   acc_flag: short_int;       (* <0:write, 0:read, >0:inaccessible *)  #    entry_offset : short_int;      BEGIN (* set_getter *)         set_getter := false;   
   status := no_image_err; 
        DBFDS (set_id, set_number, acc_flag, entry_offset);         IF (set_number = zero) OR (acc_flag > zero) THEN BEGIN         status:= illegal_set_ref_err;   
      set_getter := true;  
       GOTO 999;         END;         rt_dscbe_set_ptr_addr (run_table, entry_offset, dscb_ptr);       999:      END; (* set_getter *)   $ Page $  "(******************************************************************) " "(*                                                                *) " "(* FUNCTION check_modes                                           *) " "(*                                                                *) " "(* Purpose : This function checks that the user has the data      *) " "(* base is opened for write accessibility.  This routine is       *) " "(* used by DBUPD, DBDEL and DBPUT.                                *) " "(*                                                                *) " "(* Input :                                                        *) " "(*    (1) Intrinsic mode                                          *) " "(*    (2) database number                                         *) " "(*    (3) Pointer to the local run table                          *) " "(*    (4) Pointer to the dbbuf table                              *) " "(*                                                                *) " "(* Returns :                                                      *) " "(*    (5) Status (zero if no error, else IMAGE error number)      *) " "(*                                                                *) " "(* The function value 'false' is returned if theres no error      *) " "(*                    'true' if an error occurs                   *) " "(*                                                                *) " "(******************************************************************) "     FUNCTION check_modes   $ Alias 'Img.CheckModes' $   
   (VAR mode : short_int;  
     VAR run_table : ptr_local_run_table_hdr;      VAR return_status : short_int) : BOOLEAN;       LABEL 999;      BEGIN (* check modes *)          (* assume error *)      check_modes := true;          (* Make sure the DEL, PUT or UPD mode is 1. *)      IF (mode <> one) THEN BEGIN        return_status := invalid_mode_err;        GOTO 999;         END;         (* check the open mode for write accessibility *)     WITH run_table^ DO         IF (open_mode = read_only_shared_access_mode) OR           (open_mode = read_shared_access_mode) THEN BEGIN            return_status := mode_not_suff_err;  	         GOTO 999; 	          END;       	   (* ok status *) 	    check_modes := false;      999:      
END;  (* function *) 
 $ Page $  $(*********************************************************************)  $ $(*                      Process_Text_Str                             *)  $ $(*********************************************************************)  $ $(*                                                                   *)  $ $(* Purpose:                                                          *)  $ $(*    To perform validity and legality checking of text strings      *)  $ $(*    supplied by the caller for placing in log records.  Current    *)  $ $(*    IMAGE definition is for text strings to be up to 256 words     *)  $ $(*    or 512 characters in length.  Characters are specified by      *)  $ $(*    a negative number and words by a positive number.              *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (in)     (1) User-supplied text.                               *)  $ $(*    (in)     (2) Length of user-supplied text in words or chars.   *)  $ $(*    (out)    (3) Blank-padded text to be placed in log record.     *)  $ $(*    (out)    (4) Positive word length of processed text.           *)  $ $(*    (out)    (5) IMAGE error number if text length was bad.        *)  $ $(*                                                                   *)  $ $(* Function result:                                                  *)  $ $(*    Boolean 'True' if an error occurs, otherwise 'false'.          *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION process_text_str  $ Alias 'Img.TextStr' $     (VAR user_text : text_str;       VAR user_len  : short_int;      VAR mesg_text : text_str;       VAR mesg_len  : short_int;      VAR status    : short_int) : Boolean;       LABEL 999;  (* error exit *)      CONST      pad_char = ' ';     (* Constant blank character *)       VAR      abs_len : short_int;      blanks_to_pad : short_int;           BEGIN  (* function process_text_str *)         IF (user_len > words_in_logging_text) OR         (user_len < neg_chars_in_logging_text) THEN BEGIN         process_text_str := true;   (* error!! *)         status := text_length_err;        GOTO 999;         END; (* then the text length was not proper *)      
   mesg_text := user_text; 
        mesg_len := user_len;         IF (user_len < zero) THEN BEGIN (* byte length is given *)         abs_len := abs(user_len);             (**)        (* Blank-pad character string to a word boundary.         (* This is optimized for a 2-byte word.         (**)      '      blanks_to_pad := abs_len - ((abs_len DIV chars_in_word)*chars_in_word);  '           mesg_len := (abs_len + chars_in_word - one)                         DIV chars_in_word;            mesg_text.char_str[abs_len+one] := pad_char;        END; (* then we have a byte text string *)         process_text_str := false;  (* no error occurred *)      999: (* error exit *)       END; (* function process_text_str *)  $ Page $  #(*******************************************************************)  # #(*                    send_receive_message                         *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To consolidate the handling of communication between the     *)  # #(*    user program and DBMON.  This routine will fill in the       *)  # #(*    common portions of a message, send the request, receive      *)  # #(*    a reply, and determine if DBMON had an error.                *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) Message buffer ptr.                             *)  # #(*    (in)     (2) DBBUF table ptr.                                *)  # #(*    (in)     (3) Run table ptr.                                  *)  # #(*    (in)     (4) 'To DBMON' message code.                        *)  # #(*    (in)     (5) Length of the message to send.                  *)  # #(*    (out)    (6) Pointer to reply message buffer. (Equal to (1)).*)  # #(*    (out)    (7) Length of reply message received.               *)  # #(*    (out)    (8) Any comm. error or DBMON error.                 *)  # #(*                                                                 *)  # #(* Function result: Boolean 'True' if an error, otherwise 'false'. *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION send_receive_message  $ Alias 'Img.SendReceive' $     (VAR mesg_buf_ptr : ptr_to_bm_mesg_type;       VAR dbbuf_ptr    : ptr_dbbuf_table;       VAR runtable_ptr : ptr_local_run_table_hdr;           dbmon_code   : short_int;           dbmon_len    : short_int;       VAR reply_ptr    : ptr_to_user_mesg_type;       VAR reply_len    : short_int;           intrinsic    : call_types; (* for statistics *)       VAR error_code   : short_int) : Boolean;      LABEL 999;      CONST      wait_for_reply_bit = zero;           VAR       max_msg : short_int; (* maximum message length to receive *)       total_mesg_len  : Short_int;      chunks          : Short_int;          Memory_ptr      : Ptr_to_memory_type;     loop            : Short_int;      f_comm_id       : Short_int;      f_comm_lock     : Short_int;          waiting_time    : long_int; (* time waiting for service *)      collecting_stats: Boolean;           BEGIN (* send_receive_message *)      !   send_receive_message := true;  (* Assume an error will occur *) !        WITH mesg_buf_ptr^, dbbuf_ptr^ DO BEGIN        from_comm_id := user_comm_id;         from_comm_lock := zero;         to_comm_id   := comm_info.dbmon_comm_id;        to_comm_lock := comm_info.dbmon_comm_lock;        request      := dbmon_code;             IF (cur_stat_buffer = nil)           THEN collecting_stats := false            ELSE collecting_stats := true;             WITH beg.user, runtable_ptr^ DO BEGIN            proc:= process_info;            IF (dbmon_code <> to_bm_opn_code)              THEN BEGIN                 db_id := sys_dbnum;                 local_db_num := db_num;                 max_msg := cur_mesg_len;                  options.return_statistics := collecting_stats;                  END (* else *)               ELSE BEGIN                 db_id   := zero;                  max_msg := open.max_rt_size;                  options.return_statistics := false;                 END; (* else *)               END; (* with *)        END; (* with *)          tm_rm_set_ptr_addr (mesg_buf_ptr, zero, reply_ptr);                 (* Get time before sending message *)         IF collecting_stats        THEN waiting_time := get_start_time;             IF Send_to_DBMON (mesg_buf_ptr^,                        dbmon_len,                        error_code)  
      THEN GOTO 999; 
        WITH mesg_buf_ptr^ DO BEGIN        f_comm_id   := from_comm_id;        f_comm_lock := from_comm_lock;        END; (* with *)              IF collecting_stats THEN BEGIN             (**)        (* DBMON will first send us a statistics buffer.        (**)            IF Get_DBMON_message (f_comm_id,                              f_comm_lock,                              wait_for_reply_bit,                               reply_ptr^,                               reply_len,                              max_msg,                              error_code)            THEN GOTO 999;                 (* Get the elapsed time waiting for service *)            waiting_time := get_elapsed_time (waiting_time);                (**)        (* Add up the system statistics using a simulation of         (* a Matrix add, which would not be efficient in Pascal.        (* matrix A = matrix A + matrix B.        (**)      "      sum_up_system_stats (dbbuf_ptr^.cur_stat_buffer^.system_stats, "                             reply_ptr^.dbmon_stats.system_stats,                               number_of_system_statistics);                (**)        (* Increment the proper counters and add to the proper        (* times for this intrinsic call.         (**)            WITH dbbuf_ptr^.cur_stat_buffer^.call_stats[intrinsic],              reply_ptr^.dbmon_stats DO BEGIN           io_count     := io_count + dbmon_io_count;            io_time      := io_time + dbmon_io_time;   "         wait_time := wait_time + waiting_time - DBMON_service_time; "          service_time := service_time + dbmon_service_time;            END; (* with *)            END; (* then *)          (**)      (* Get the normal reply message.      (**)          IF Get_DBMON_message (f_comm_id,                            f_comm_lock,                            wait_for_reply_bit,                           reply_ptr^,                           reply_len,                            max_msg,                            error_code)  
      THEN GOTO 999; 
            WITH reply_ptr^ DO      IF (request = to_user_opn_code) AND  #      (open.reply.status = zero) THEN BEGIN (* this is a run table *)  #           chunks := open.num_chunks;            IF (chunks > one) THEN BEGIN               (**)            (* collect all run table chunks.            (**)                total_mesg_len := reply_len;                FOR loop := 2 TO chunks DO BEGIN               make_chunk_buf_ptr (reply_ptr,                                  total_mesg_len,                                   memory_ptr);                  IF get_message (f_comm_id,                              f_comm_lock,                              wait_for_reply_bit,                               memory_ptr^[one],                               reply_len,                              max_msg - total_mesg_len,                               error_code)                  THEN GOTO 999;       !            Overwrite_header (memory_ptr^[to_user_opn_mesg_len+1], !                               memory_ptr^[one],                                  reply_len - to_user_opn_mesg_len);                   total_mesg_len := total_mesg_len + reply_len -                                to_user_opn_mesg_len;       
            END; (* for *) 
              reply_len := total_mesg_len;                END; (* then chunks > one *)             END; (* then message type is run table reply *)              error_code := reply_ptr^.beg.reply.status;          IF (error_code <> zero) THEN GOTO 999;          send_receive_message := false;  (* No error! *)      999 : (* error exit *)      END;  $ Page $  $(*********************************************************************)  $ $(*                      transaction_checker                          *)  $ $(*********************************************************************)  $ $(*                                                                   *)  $ $(* Purpose:                                                          *)  $ $(*    To do the ibase and transaction number checking for multi-db   *)  $ $(*    transactions (mode 3 for DBBEGIN, DBEND, DBMEMO and DBUNDO).   *)  $ $(*                                                                   *)  $ $(*    Illegal ibases are:                                            *)  $ $(*       1) if the ibase count is <= zero or >max_db (20).           *)  $ $(*       2) if any ibase number is outside the 1-max_db range.       *)  $ $(*       3) if any ibase number is not an open database.             *)  $ $(*       4) if the database is a remote database. (A remote request  *)  $ $(*          should have gone to the remote node, not here).          *)  $ $(*       5) if any two ibase's have different transaction id's.      *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (in)     (1) 'dbbegin calling' boolean indicator.              *)  $ $(*    (in)     (2) dbbuf table pointer.                              *)  $ $(*    (in)     (3) the mode-3 ibase supplied by the user.            *)  $ $(*    (out)    (4) an IMAGE error number if an error occurs.         *)  $ $(*                                                                   *)  $ $(* Function result is 'True' for an error, otherwise 'false'.        *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION transaction_checker   $ Alias 'Img.TransCheck' $      (    is_dbbegin : boolean;       VAR dbbuf_table: ptr_dbbuf_table;       VAR ibase      : ibase_type;      VAR error      : short_int) : Boolean;      LABEL 999; (* error exit *)       VAR   
   loop : short_int; 
    trans_num : long_int;  
   basex     : short_int;  
     BEGIN (* transaction checker *)       !   transaction_checker := true;  (* Assume an error will happen *) !        (**)      (* Make sure ibase[1] is in the proper range.     (**)          IF (ibase[one] <= zero) OR (ibase[one] > max_db) THEN BEGIN        error := db_not_open_to_user_err;         GOTO 999;         END;             (**)      (* For each ibase number, verify it is in the proper range,     (* is an open database, is not a remote database, and that      (* the transaction id is the same for all databases in the   !   (* ibase list.  Furthermore, for the calls other than DBBEGIN,  !    (* there must not be another locally open database with     (* the same transaction id which is NOT in the ibase list.      (* This is assured by comparing the number of bases in the      (* list with the 'multi_db_count' in the run table, which     (* is set by DBBEGIN.     (**)          trans_num := zero;          WITH dbbuf_table^ DO      FOR loop := one TO ibase[one] DO BEGIN         basex := ibase[loop+one];         IF (basex <= zero) OR (basex > max_db) THEN BEGIN            error := db_not_open_to_user_err;  	         GOTO 999; 	          END;             IF (db_run_table[basex] = nil) THEN BEGIN            error := db_not_open_to_user_err;  	         GOTO 999; 	          END;             WITH db_run_table[basex]^ DO BEGIN           IF (indicators.remote) THEN BEGIN              error := xaction_spans_nodes_err;               GOTO 999;               END;               IF (transaction_id = zero)               THEN IF (NOT is_dbbegin)  
               THEN BEGIN  
                   error := no_xaction_in_progress_err;                    GOTO 999;                     END                  ELSE (* it is dbbegin... no error. *)                  ELSE (* the transaction id is not zero *)                      IF (is_dbbegin)                    THEN BEGIN                       error := xaction_in_progress_err;                       GOTO 999;                       END                    ELSE IF (loop = one)  (* not dbbegin *)                        THEN IF (multi_db_count <> ibase[one])                           THEN BEGIN                             error := xaction_ibase_err;                             GOTO 999;                             END                          ELSE trans_num := transaction_id  #                     ELSE IF (trans_num <> transaction_id) THEN BEGIN  #                         error := xaction_ibase_err;                           GOTO 999;                           END;                   END; (* with run table *)            END; (* with dbbuf...for *)          transaction_checker := false;  (* no error! *)       999: (* error exit *)       END; (* transaction_checker *)  $ Page $  $(*********************************************************************)  $ $(*                   Transaction_Base_Formatter                      *)  $ $(*********************************************************************)  $ $(*                                                                   *)  $ $(* This routine is used by IMAGE-II to collect together all databases*)  $ $(* which are, or will be, part of the same transaction for mode 1    *)  $ $(* operations.   The resulting IBASE is of the mode 3 format.        *)  $ $(* Only local databases are considered.  (Remote database            *)  $ $(* transactions are handled remotely).                               *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (in)     (1) The transaction number to look for.               *)  $ $(*    (in)     (2) The pointer to the DBBUF table.                   *)  $ $(*    (out)    (3) The mode-3 format ibase list.                     *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $      PROCEDURE transaction_base_formatter  $ Alias 'Img.BaseFormat' $      (    transaction_number : long_int;      VAR dbbuf_table        : ptr_dbbuf_table;       VAR result_ibase       : ibase_type);       VAR   	   i : short_int;  	     BEGIN (* ibase formatter *)          result_ibase[one] := zero;          WITH dbbuf_table^ DO      FOR i := one TO max_db DO         IF (db_run_table[i] <> nil) THEN WITH db_run_table[i]^ DO             IF (NOT indicators.remote) THEN BEGIN              result_ibase[one] := result_ibase[one] + one;               result_ibase[result_ibase[one]+one] := i;               END; (* then *)       
END; (* ibase formatter *) 
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBBEGIN                                                 *)  $ $(*                                                                   *)  $ $(* Purpose:                                                          *)  $ $(*    To start a transaction for the caller.  All databases on the   *)  $ $(*    same node as the specified database will be considered part of *)  $ $(*    the same transaction, including any databases (on the same     *)  $ $(*    node) opened during the transaction.                           *)  $ $(*                                                                   *)  $ $(* input  : (1) A database identifier. (ibase parm)                  *)  $ $(*          (2) Text buffer (a comment for the log record).          *)  $ $(*          (3) Mode (1 or 3)                                        *)  $ $(*          (4) Status array.                                        *)  $ $(*          (5) Text length. (-512 bytes to +256 words).             *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE DBBEGIN  $ Alias 'DBBEG' $     (VAR ibase : ibase_type;   
    VAR itext : text_str;  
 
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len : short_int);          LABEL 888,999;      CONST   
   dbbegin_calling = true; 
         VAR      base          : short_int;      temp_ibase    : ibase_type;         from_mesg_buf: ptr_to_user_mesg_type;     from_mesg_len: short_int;         dbbuf_ptr     : ptr_dbbuf_table;      mesg_buf_ptr  : ptr_to_bm_mesg_type;      run_table_ptr : ptr_local_run_table_hdr;      stat_buf_ptr  : statistics_buffer_ptr_type;      	   i : short_int;  	    start_time    : long_int;     save_transaction : long_int;           	BEGIN (* dbbeg *)  	        stat_buf_ptr := nil;  (* in case of bad mode *)         temp_ibase := ibase;          CASE mode OF         1: base := ibase[one];            3: IF ibase[one] <= max_db               THEN base := ibase[2] (* get first in ibase list *)    %            ELSE IF make_ibase_list (ibase, temp_ibase, istat.beg.status)  %                THEN GOTO 999                 ELSE base := temp_ibase[2];            OTHERWISE BEGIN            istat.beg.status := invalid_mode_err;  	         GOTO 999; 	          END;         END; (* case *)              IF multi_db_pointers (base,         (* given *)                           dbbuf_ptr,    (* returned *)                            mesg_buf_ptr,                           run_table_ptr,                            stat_buf_ptr,                           istat.beg.status)  
      THEN GOTO 999; 
        (* Is this a remote call? *)      IF (run_table_ptr^.indicators.remote) THEN BEGIN         remote_dbbegin (ibase, itext, mode, istat, text_len);         GOTO 888;         END;      
   IF stat_buf_ptr <> nil  
       THEN start_time := get_start_time;         IF (mode = 1) THEN BEGIN         IF (run_table_ptr^.transaction_id <> zero) THEN BEGIN            istat.beg.status := xaction_in_progress_err;   	         GOTO 999; 	          END;          transaction_base_formatter (zero, dbbuf_ptr, temp_ibase);          END; (* then *)          (* temp_ibase at this point is the ibase list *)          (**)      (* Make sure all specified db's are valid and that      (* none are part of a transaction.      (**)          IF transaction_checker (dbbegin_calling,                              dbbuf_ptr,                              temp_ibase,                             istat.beg.status)        THEN GOTO 999; (* if error occurs *)             (**)       (* This is a local call... Have DBMON set up the transaction.      (**)          (* Set up specific beg message fields *)      WITH mesg_buf_ptr^.beg DO BEGIN            (**)  !      (* Call text string processor to word-align and blank-fill.  !       (**)            IF process_text_str (itext,                              text_len,                             log_comment,                              log_comment_len,                              istat.beg.status)           THEN GOTO 999;             END;  (* end with message buffer *)       "   IF send_receive_message (mesg_buf_ptr, dbbuf_ptr, run_table_ptr,  " !                            to_bm_beg_code, to_bm_begin_mesg_len,  !                             from_mesg_buf, from_mesg_len,                               db_begin,                               istat.beg.status)   
      THEN GOTO 999; 
            WITH from_mesg_buf^.beg  DO BEGIN            save_transaction := xact_num;             (* return information to the user *)        WITH istat.beg DO BEGIN            xaction_num := save_transaction;            logging_state := reply.log_state;           END;  (* end with return buffer *)             END; (* with *)          (* update dbbuf table *)      WITH dbbuf_ptr^ DO      FOR i := one TO temp_ibase[one] DO      WITH db_run_table[temp_ibase[i+one]]^ DO BEGIN         transaction_id := save_transaction;         multi_db_count := temp_ibase[one];        END;      999: (* abnormal termination exit *)         IF (stat_buf_ptr <> nil)         THEN WITH stat_buf_ptr^.call_stats[db_begin] DO BEGIN             (**)        (* do any final stats for DBBEG.        (**)            calls_made   := calls_made + one;   !      elapsed_time := elapsed_time + get_elapsed_time(start_time); !       cpu_time := elapsed_time - io_time - wait_time;             END; (* then *)       888: (* skip stats if remote *)       	END; (* DBBEGIN *) 	 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBCLOSE                                                 *)  $ $(*                                                                   *)  $ $(* purpose:                                                          *)  $ $(*    To close the specified database.  Memory utilized by the       *)  $ $(*    run table and the statistics buffer (if requested) is released *)  $ $(*    to the dynamic memory area.                                    *)  $ $(*                                                                   *)  $ $(* input  : (1) The ibase parameter of the database to close.        *)  $ $(*          (2) ID of set to close. (Backward compatibility).        *)  $ $(*          (3) Mode. (1 or 2)                                       *)  $ $(*          (4) Status array.                                        *)  $ $(*                                                                   *)  $ $(* returns: (1) status (0 if successful, else IMAGE error number)    *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE DBCLOSE   $ Alias 'DBCLS' $      (VAR ibase  : short_int; (* only first word is needed *)       VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type);       LABEL 999;      VAR      save_ibase  : short_int;          run_table : ptr_local_run_table_hdr;      dbbuf_table : ptr_dbbuf_table;      to_mesg_buf : ptr_to_bm_mesg_type;      stat_buf_ptr: statistics_buffer_ptr_type;         from_mesg_buf: ptr_to_user_mesg_type;     from_mesg_len: short_int;         new_max_msg_size : short_int;     i, avail         : short_int;         set_num : short_int;      dscb_entry : ptr_dscb_entry;               
BEGIN (* DBCLOSE *)  
        (**)      (* Get the database pointers.     (**)          IF get_database_pointers (ibase,  (* given *)                               dbbuf_table, (* returned *)                               to_mesg_buf,                                run_table,                                stat_buf_ptr,                               istat.cls.status)  
      THEN GOTO 999; 
         "   (*Statistics not needed since the buffer is going to be removed*) "            (* Is a transaction in progress for this database? *)     IF (run_table^.transaction_id <> zero) THEN BEGIN        istat.cls.status := transaction_violation_err;        GOTO 999;         END;         (* Is the database remote? *)     IF (run_table^.indicators.remote) THEN BEGIN         remote_dbclose (ibase, set_id, mode, istat);        GOTO 999;         END;             (* Make sure the mode is 1 or 2;  ignore 2 *)     istat.cls.status := zero;     IF (mode = 2) THEN BEGIN         IF set_getter (set_id, run_table, set_num, dscb_entry,                       istat.cls.status) THEN;        GOTO 999;         END         ELSE IF (mode <> 1) THEN BEGIN           istat.cls.status := invalid_mode_err;  	         GOTO 999; 	          END;          (* Verify that the close is performed by DBMON *)         IF send_receive_message (to_mesg_buf,                              dbbuf_table,                              run_table,                              to_bm_cls_code,                               to_bm_close_mesg_len,                               from_mesg_buf,                              from_mesg_len,                              db_close,                               istat.cls.status)   
      THEN GOTO 999; 
             (* Zero out the entry for this db in the maximum msg table *)      dbbuf_table^.max_mesg_len[ibase] := zero;         (**)   !   (* Determine if the current message buffer needs to be removed  !    (* and a smaller one allocated.     (**)          new_max_msg_size := zero;         WITH dbbuf_table^ DO BEGIN         FOR i := one TO max_db DO         IF max_mesg_len[i] > new_max_msg_size            THEN new_max_msg_size := max_mesg_len[i];            IF (cur_mesg_len > new_max_msg_size) THEN BEGIN                (**)            (* Release the old message buffer.            (**)            DBRBF (mesg_ptr_tbl_index,                   istat.cls.status);           IF (istat.cls.status <> zero) THEN GOTO 999;                cur_mesg_len := zero;               (**)            (* allocate the new message buffer if necessary.            (**)                IF (new_max_msg_size > zero) THEN BEGIN              DBGBF (mesg_ptr_tbl_index, new_max_msg_size,                     avail, istat.cls.status);              IF (istat.cls.status <> zero) THEN GOTO 999;                  cur_mesg_len := new_max_msg_size;                   END; (* allocate smaller message buffer *)           END; (* make message buffer smaller *)         END; (* with dbbuf_table *)          (* Restore the original ibase parameter *)      save_ibase := run_table^.db_node;      "   (* Remove the run table. To do so, we need the local database  *) " "   (* number which is also the index into the runtable pointer    *) " "   (* table.  If a statistics buffer was allocated, it to is      *) " "   (* released to the dynamic memory area.                        *) "        DBRBF (ibase, istat.cls.status);      IF istat.cls.status <> no_image_err THEN GOTO 999;          (* Deallocate the statistics buffer *)      IF (stat_buf_ptr <> nil) THEN BEGIN        DBRBF (max_db + one + ibase, istat.cls.status);         IF istat.cls.status <> no_image_err THEN GOTO 999;        END;         (* Decrement the open count *)      WITH dbbuf_table^ DO BEGIN         open_count := open_count - one;             (* Finally, if this is the last data base closed, *)        (* release the class number.                      *)      
      IF open_count = zero 
          THEN IF NOT retcl (dbbuf_table^.user_comm_id)              THEN user_comm_id := zero; (* Make zero! *)         END; (* with *)          ibase := save_ibase;       999: (* abnormal termination exit *)      	END; (* DBCLOSE *) 	 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBCONTROL                                               *)  $ $(*                                                                   *)  $ $(* purpose:                                                          *)  $ $(*    To turn database posting on/off for this database.             *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) dummy parameter.                                           *)  $ $(*    (3) mode. (1,2,5,6).                                           *)  $ $(*    (4) Status array.                                              *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbcontrol  $ Alias 'DBCTL' $     (VAR ibase : ibase_type;   
    VAR dummy : short_int; 
 
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);      LABEL 888,999;  (* abnormal termination exit *)       CONST   
   stat_buffer_len = 512;  
     VAR   #   ret_mesg_buf:                   (* return message buffer pointer *) #       ptr_to_user_mesg_type;  #   ret_mesg_len: short_int;        (* return message buffer length *)  #        mesg_buf  : ptr_to_bm_mesg_type;      run_table : ptr_local_run_table_hdr;      dbbuf_table : ptr_dbbuf_table;      stats_buf : statistics_buffer_ptr_type;         available_memory : short_int;     start_time       : long_int;           BEGIN (* dbcontrol *)          (**)      (* Get database pointers.     (**)          IF get_database_pointers (ibase[one],                               dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.ctl.status)  
      THEN GOTO 999; 
            WITH run_table^.indicators DO BEGIN            IF (remote) THEN BEGIN           remote_dbcontrol (ibase, dummy, mode, istat);  	         GOTO 888; 	          END;             IF (stats_buf <> nil)            THEN start_time := get_start_time;             (* preset return status for good return *)        istat.ctl.status := no_image_err;       	      CASE mode OF 	           (* check for control mode 1 *)  	         1 : BEGIN 	             posting := false; (* Turn posting off *)              END; (* case 1 *)             (* check for control mode 2 *)  	         2 : BEGIN 	 !            IF (posting) THEN GOTO 999; (* return if already on *) !                 (* send checkpoint message to DBMON *)               IF send_receive_message (dbbuf_table^.cur_mesg_buf,                                         dbbuf_table,                                        run_table,                                        to_bm_checkpoint_code,                                         to_bm_checkpoint_mesg_len,                                         ret_mesg_buf,                                       ret_mesg_len,                                       db_control,                                       istat.ctl.status)                 THEN GOTO 999;                       (* obtain information from the return message *)                  posting := true;       (* set posting on *)               END; (* case 2 *)                    (* Turn on collection of IMAGE statistics *)   	         5 : BEGIN 	             IF (stats_buf = nil) THEN BEGIN                      (* Try to allocate a statistics buffer. *)   %               DBGBF (max_db+one+ibase[one], (* 21=offset to stat table *) %                       stat_buffer_len,                        available_memory,                         istat.ctl.status);                     IF (istat.ctl.status <> zero) THEN BEGIN                     istat.ctl.status := no_more_space_err;                    GOTO 999;                     END; (* then *)                      statistics := true;                     stats_buf :=                       dbbuf_table^.statistics_table[ibase[one]];                     (* Initialize the statistics buffer *)                      fill_with_value (words_in_statistics_buffer,                                   stats_buf^,                                   zero);                     (* Avoid taking stats in this module *)                 stats_buf := nil;                     END; (* then *)              END; (* case mode 5 *)                   (* Turn off statistics gathering *)  	         6 : BEGIN 	             IF (stats_buf <> nil) THEN BEGIN                     (* Deallocate the statistics buffer *)   %               DBRBF (max_db+one+ibase[one], (* 21=offset to stat table *) %                       istat.ctl.status);                     IF (istat.ctl.status <> zero) THEN BEGIN                     istat.ctl.status := db_corrupt_err;                     GOTO 999;                     END; (* then *)                      stats_buf := nil;                     statistics := false;                      END; (* then *)              END; (* case mode 6 *)      	         OTHERWISE 	             istat.ctl.status := invalid_mode_err;       
         END;  (* case *)  
           END; (* WITH *)       999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_control] DO BEGIN               calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;               END;       888: (* skip stats if remote *)       
END; (* DBCONTROL *) 
 $ Page $  #(********************************************************************) # #(*                                                                  *) # #(* PROCEDURE DBDELETE                                               *) # #(*                                                                  *) # #(* purpose : This procedure handles  the syntax checking and        *) # #(*           buffer manager (DBMON) communication requirements      *) # #(*           of the DBDEL intrinsic.                                *) # #(*                                                                  *) # #(* input :   (1) ibase parameter.                                   *) # #(*           (2) set identifier.                                    *) # #(*           (3) mode. (must be 1)                                  *) # #(*           (4) istat array.                                       *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE DBDELETE  $ Alias 'DBDEL' $      (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type);       LABEL 888,999;      VAR      run_table : ptr_local_run_table_hdr;      mesg_buf  : ptr_to_bm_mesg_type;      dbbuf_table : ptr_dbbuf_table;      stat_buf  : statistics_buffer_ptr_type;         reply_mesg_buf : ptr_to_user_mesg_type;  
   set_number : short_int; 
 "   dscb_entry : ptr_dscb_entry;  (* data set control block entry *)  " #   return_length : short_int;    (* len of info returned from dbmon *) #     
   start_time : long_int;  
     
BEGIN (* DBDELETE *) 
        (**)      (* Get database pointers.     (**)          IF get_database_pointers (ibase[one],                               dbbuf_table,                                mesg_buf,                               run_table,                                stat_buf,                               istat.del.status)  
      THEN GOTO 999; 
        IF (run_table^.indicators.remote) THEN BEGIN         remote_dbdelete (ibase, set_id, mode, istat);         GOTO 888;         END;         IF (stat_buf <> nil)         THEN start_time := get_start_time;      "   (* Check the open mode of the data base.  It must be 1 or 3 - *)  " "   (* read_write shared or exclusive access, respectively.       *)  " "   (* It also cannot be negative (sys db access is read only).   *)  " "   (* Also, check the delete mode.                               *)  "        IF check_modes (mode, run_table, istat.del.status)   
      THEN GOTO 999; 
         "   (* Validify the data set name/number.  If it is valid, we are *)  " "   (* returned the data set number and the data set control block*)  " "   (* entry offset (relative to the start of the run table).     *)  "        IF set_getter (set_id, run_table, set_number,                    dscb_entry,istat.del.status) THEN GOTO 999;          WITH dscb_entry^ DO BEGIN            (* The data set must be writeable. *)         IF NOT (set_indics.write_allowed) THEN BEGIN           istat.del.status := set_not_writable_err;  	         GOTO 999; 	          END; (* THEN *)      "      (* The data set must be either a manual master or a detail *)  " "      (* i.e. not an automatic master.                           *)  "       IF (set_indics.set_type = auto_master) THEN BEGIN            istat.del.status := auto_master_err;   	         GOTO 999; 	          END; (* THEN *)      !      (* Is there a current record?  If not, we have an error. *)  ! !      (* DBMON will check to assure that the current record is *)  ! !      (* not empty.                                            *)  !           IF (last_rec <= zero) THEN BEGIN           IF (last_rec = zero)               THEN istat.del.status := no_set_current_record_err              ELSE istat.del.status := db_corrupt_err;  	         GOTO 999; 	          END; (* THEN *)            END;  (* end with dscb_entry *)          (* Format the message to DBMON. *)          WITH mesg_buf^.delete DO BEGIN         xact_num := run_table^.transaction_id;        post_ind := run_table^.indicators.posting;        set_num := set_number;        current_rec_num := dscb_entry^.last_rec;        END;  (* with mesg_buf *)          IF send_receive_message (mesg_buf,                               dbbuf_table,                              run_table,                              to_bm_del_code,                               to_bm_delete_mesg_len,                              reply_mesg_buf,                               return_length,                              db_delete,                              istat.del.status)   
      THEN GOTO 999; 
     999: (* abnormal termination exit *)         IF (stat_buf <> nil)         THEN WITH stat_buf^.call_stats[db_delete] DO BEGIN               calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;           END;       888: (* skip stats if remote *)       
END; (* dbdelete *)  
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBEND                                                   *)  $ $(*                                                                   *)  $ $(* purpose: To end a transaction for all databases on a particular   *)  $ $(*          node, using the ibase param to determine which node.     *)  $ $(*                                                                   *)  $ $(* parameters:                                                       *)  $ $(*    (1) ibase parameter.                                           *)  $ $(*    (2) user text to include in DBEND log record.                  *)  $ $(*    (3) mode (1 or 3)                                              *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) user text length.                                          *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbend  $ Alias 'DBEND' $     (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len  : short_int);       LABEL 888,999;      CONST      not_dbbegin = false;  (* for transaction_checker *)      VAR      base        : short_int;      temp_ibase  : ibase_type;         run_table : ptr_local_run_table_hdr;      to_mesg_buf : ptr_to_bm_mesg_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf   : statistics_buffer_ptr_type;         from_mesg_buf: ptr_to_user_mesg_type;     from_mesg_len: short_int;     i            : short_int;     start_time   : long_int;       	BEGIN (* dbend *)  	     
   (* Legal mode? *) 
    stats_buf := nil;  (* in case of mode error *)          temp_ibase := ibase;          CASE mode OF             1: base := ibase[one];            3: IF ibase[one] <= max_db              THEN base := ibase[2]   %            ELSE IF make_ibase_list (ibase, temp_ibase, istat.endb.status) %                THEN GOTO 999                 ELSE base := temp_ibase[2];            OTHERWISE BEGIN            istat.endb.status := invalid_mode_err;   	         GOTO 999; 	          END;         END; (* case *)          IF multi_db_pointers (base,                           dbbuf_table,                            to_mesg_buf,                            run_table,                            stats_buf,                            istat.endb.status)   
      THEN GOTO 999; 
        (* Process remote dbend *)      IF (run_table^.indicators.remote) THEN BEGIN         remote_dbend (ibase, user_text, mode, istat, text_len);         GOTO 888;         END;         IF (stats_buf <> nil)        THEN start_time := get_start_time;         (**)      (* Is there a transaction in progress?      (**)       	   IF (mode = one) 	 !      THEN transaction_base_formatter (run_table^.transaction_id,  !                                        dbbuf_table,                                          temp_ibase);          IF transaction_checker (not_dbbegin,                              dbbuf_table,                              temp_ibase,                             istat.endb.status)   
      THEN GOTO 999; 
            (* Set up specific beg message fields *)      WITH to_mesg_buf^.endm DO BEGIN            (**)         (* Call text string processor to word-align and blank-pad.         (**)            IF Process_text_str (user_text,                              text_len,                             log_comment,                              log_comment_len,                              istat.endb.status)            THEN GOTO 999;             xact_num := run_table^.transaction_id;        END;  (* with *)         IF send_receive_message (to_mesg_buf,                              dbbuf_table,                              run_table,                              to_bm_end_code,                               to_bm_end_mesg_len,                               from_mesg_buf,                              from_mesg_len,                              db_end,                               istat.endb.status)        THEN IF (istat.endb.status <> logging_not_enabled_err)           THEN GOTO 999;             (**)        (* If logging was disabled during our transaction, clear        (* log bits so that close won't get an error... but         (* still return the error to the user.        (**)         WITH from_mesg_buf^.endm,dbbuf_table^ DO BEGIN             (* return information to the user *)        WITH istat.endb DO BEGIN           logging_state := reply.log_state;           xaction_num := run_table^.transaction_id;           END;  (* end with return buffer *)             (* Set specified DBs' transaction ID's to zero *)         FOR i := one TO temp_ibase[one] DO        WITH db_run_table[temp_ibase[i+1]]^ DO BEGIN           transaction_id := zero;           multi_db_count := zero;           END;       
      END;  (* end with *) 
     999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_end] DO BEGIN           calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;           END;       888: (* skip stats if remote *)       END; (* dbend *)  $ Page $  "(*****************************************************************)  " "(*                                                               *)  " "(* PROCEDURE DBFIND                                              *)  " "(*                                                               *)  " "(* purpose :                                                     *)  " "(*    To find the head, tail and length of a chain of detail     *)  " "(*    records.  The record numbers are returned to the caller.   *)  " "(*                                                               *)  " "(* Parameters:                                                   *)  " "(*    (1) ibase.                                                 *)  " "(*    (2) set id. (must be a detail)                             *)  " "(*    (3) mode. (must be 1)                                      *)  " "(*    (4) istat array.                                           *)  " "(*    (5) detail's key item for the chain.                       *)  " "(*    (6) key item value to find a chain for.                    *)  " "(*                                                               *)  " "(*****************************************************************)  "     PROCEDURE dbfind  $ Alias 'DBFND' $      (VAR ibase  : ibase_type;      VAR set_id : item_set_name_type;      VAR mode   : short_int;       VAR istat  : return_buffer_type;      VAR item_id: item_set_name_type;      VAR item_value : item_value_type);      LABEL 888,999;      VAR      run_table : ptr_local_run_table_hdr;      mesg_buf  : ptr_to_bm_mesg_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf : statistics_buffer_ptr_type;         reply_mesg_buf : ptr_to_user_mesg_type;     item_number : short_int;        (* 'key' item number *)  $   item_entry_offset : short_int;  (* offset from start of run table *)  $    item_entry : ptr_item_table_entry;      set_number : short_int;         (* 'detail' set number *)  &   dscb_entry : ptr_dscb_entry;    (* ptr to data set control block entry *) & #   num_fields : short_int;         (* # data set info table entries *) #    data_set_info_table : ptr_local_ds_inf_table;         data_set_info_table_offset : short_int;     path_table_offset : short_int;      path_table : ptr_path_table;    (* data set path table *)          master_set_number : short_int;  (* detail's related master *)   &   path : short_int;               (* path # used in searching path table *) & '   found : boolean;                (* true if item num is found in path tbl *) ' 
   num_paths : short_int;  
 #   return_length : short_int;      (* len of return info from dbmon *) # 
   acc_flag  : short_int;  
    start_time: long_int;          	BEGIN (* DBFIND *) 	        (**** get the database pointers ****)         IF get_database_pointers (ibase[one],                               dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.fnd.status)  
      THEN GOTO 999; 
        IF (run_table^.indicators.remote) THEN BEGIN   #      remote_dbfind (ibase, set_id, mode, istat, item_id,item_value);  #       GOTO 888;         END;         IF (stats_buf <> nil)        THEN start_time := get_start_time;      !   (* Validify the set reference, returning the set number and *)  ! !   (* the offset to the data set control block table entry.    *)  !    IF set_getter (set_id,run_table,set_number,dscb_entry,                     istat.fnd.status)   
      THEN GOTO 999; 
     #   (* Check that the set is a detail set.  If not, we have an error *) #    IF (dscb_entry^.set_indics.set_type <> detail) THEN BEGIN        istat.fnd.status := not_a_detail_err;         GOTO 999;         END; (* THEN *)       "   (* Validify the item name/number.  Return the item number and  *) " "   (* offset to the item table entry.                             *) "    DBFDI (item_id, item_number, acc_flag, item_entry_offset);      IF (item_number = zero) OR (acc_flag > zero) THEN BEGIN        istat.fnd.status := illegal_item_ref_err;         GOTO 999;         END;      "   rt_ite_set_ptr_addr ( run_table, item_entry_offset, item_entry);  "        (* Is the FND mode one? If not, we have an error *)     IF (mode <> one) THEN BEGIN        istat.fnd.status := invalid_mode_err;         GOTO 999;         END; (* THEN *)       !   (* Is the item number a KEY item?  IF not, we have an error *)  ! !   (* Check by looping through the path table.                 *)  ! !   (*      The path table address is a function of the length  *)  ! !   (*      of the data set info table which in turn is a       *)  ! !   (*      function of the number of items in the set.         *)  !        data_set_info_table_offset := dscb_entry^.info_off;      rt_dsit_set_ptr_addr (run_table, data_set_info_table_offset,                             data_set_info_table);     num_fields := dscb_entry^.set_indics.num_items;     path_table_offset := (num_fields + one) DIV 2;       dsit_pt_set_ptr_addr (data_set_info_table, path_table_offset,                            path_table);           (* We've got the path table address. Now loop through it. *)        (* (make sure there exists at least one path.)            *)           num_paths := dscb_entry^.set_indics.num_paths;      IF (num_paths = zero) THEN BEGIN         istat.fnd.status := detail_not_linked_to_master_err;        GOTO 999;         END; (* THEN *)          path := one;   	   found := false; 	    WHILE (path <= num_paths ) AND NOT (found) DO        IF (item_number = path_table^[path].detl_key)            THEN found := true            ELSE path := path + one;          IF NOT (found) THEN BEGIN        istat.fnd.status := item_not_key_err;         GOTO 999;         END; (* THEN *)          master_set_number := path_table^[path].rltd_set;       "   (* Send a message to DBMON.  The DBFND particulars we need are *) " "   (* the key item number, related master data set number, length *) " "   (* of the key item value and the item value.                   *) "        WITH mesg_buf^.find DO BEGIN         detail_set_num := set_number;         master_set_num := master_set_number;        key_item_num := item_number;        key_length := item_entry^.item_len;         move_one_item_value (item_value, key_value, key_length);            IF send_receive_message (mesg_buf,                                 dbbuf_table,                                  run_table,                                  to_bm_fnd_code,                                  to_bm_find_mesg_len + key_length,                                  reply_mesg_buf,                                 return_length,                                  db_find,                                  istat.fnd.status)           THEN GOTO 999;             END;      #   (* Look at the message returned by DBMON.  If everything is ok, *)  # #   (* (1) Set the current key in the dscb to the item number.      *)  # #   (* (2) Set the current path in the dscb to the path number.     *)  # #   (* (3) Set the current record number in the dscb to zero.       *)  # #   (* (4) Set the chain foot to the returned chain foot rec number.*)  # #   (* (5) Set the chain head likewise.                             *)  #        WITH reply_mesg_buf^.find DO BEGIN             WITH dscb_entry^ DO BEGIN            set_indics.last_key := item_number;           set_indics.last_path := path;  
         last_rec := zero; 
          prev_rec := chain_tail;           next_rec := chain_head;           END;    (* end with dscb_entry *)      $      (* Form the return status array.                               *)  $ $      (* The DBFND return particulars are the following: the current *)  $ $      (* record number (set to zero), the detail chain length, the   *)  $ $      (* chain foot record number and chain head record number.      *)  $           WITH istat.fnd DO BEGIN            current_rec := zero;            current_chain_len :=  chain_len;            current_chain_tail :=  chain_tail;            current_chain_head :=  chain_head;            END;    (* end with return buffer *)             END;    (* with dbmon reply mesg *)       999:  (* error return label *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_find] DO BEGIN                calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;           END;          (* word 2 is defined by the manual to contain zero *)     istat.fnd.unused := zero;      888: (* skip stats if remote *)       	END; (* dbfind *)  	 $ Page $  %(***********************************************************************)  % %(*                                                                     *)  % %(*  PROCEDURE DBGET                                                    *)  % %(*                                                                     *)  % %(*  Purpose :  This routine perform the syntax checking and            *)  % %(*             communications to DBMON for the DBGET intrinsic.        *)  % %(*                                                                     *)  % %(* Parameters:                                                         *)  % %(*    (1) ibase.                                                       *)  % %(*    (2) set id.                                                      *)  % %(*    (3) mode. (1-7)                                                  *)  % %(*    (4) istat array.                                                 *)  % %(*    (5) item list.                                                   *)  % %(*    (6) return buffer.                                               *)  % %(*    (7) argument (used for modes 4 and 7).                           *)  % %(*                                                                     *)  % %(*  Returns :  (6) buffer of item values, corresponding to the items   *)  % %(*                   as listed in the item list buffer.                *)  % %(*             (4) return status buffer                                *)  % %(*                 - status (0 if successful)                          *)  % %(*                 - return item values buffer length                  *)  % %(*                 - current record number                             *)  % %(*                 - previous record number (mode 5 only)              *)  % %(*                 - next record number  (mode 5 only)                 *)  % %(*                                                                     *)  % %(***********************************************************************)  %     PROCEDURE DBGET  $ Alias 'DBGET' $     (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR item_values_buffer : data_record_type;      VAR user_argument : argument_type);           LABEL 888,999;      VAR      run_table : ptr_local_run_table_hdr;      mesg_buf  : ptr_to_bm_mesg_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf : statistics_buffer_ptr_type;         reply_mesg_buf : ptr_to_user_mesg_type;  
   set_number : short_int; 
     dscb_entry : ptr_dscb_entry;     (* data set control block *)   %   num_keys : short_int;            (* # keys required by the data set *)  % !   return_length : short_int;       (* len of dbmon return msg *)  ! 	   ix : short_int; 	 
   start_time : long_int;  
    temp : int_or_char;      	BEGIN (* DBGET *)  	        IF get_database_pointers (ibase[one],                               dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.get.status)  
      THEN GOTO 999; 
        IF (run_table^.indicators.remote) THEN BEGIN         remote_dbget (ibase, set_id, mode, istat, item_list,                      item_values_buffer, user_argument);         GOTO 888;         END;         IF (stats_buf <> nil)        THEN start_time := get_start_time;          #   (* Check the validity of the set name/number.  If valid, the     *) # #   (* routine 'set_getter' will return the set number and offset    *) # #   (* to the data set control block (relative to the beginning      *) # #   (* of the run table).  If not valid, an IMAGE error is returned. *) #        IF set_getter (set_id,run_table,set_number,dscb_entry,                     istat.get.status)   
      THEN GOTO 999; 
         (* Parse the item list.  This builds a TEMPX table in the *)        (* current_item_list of the DBBUF table.                  *)               temp.int_val := item_list [1];          WITH mesg_buf^.get DO BEGIN      %      IF ((run_table^.indicators.levelnum = 15) and (temp.char_val = '@')) % %      OR ((run_table^.indicators.levelnum = 15) and (temp.char_val = '*')  % %          and (dbbuf_table^.current_item_list[1].flags.item_num = 0)) then %           BEGIN     (* indicate we want ENTIRE *)               tempx_table[one].start_word :=  zero;   '            tempx_table[one].flags.item_num := one;  (* any non-zero value *)  ' !            tempx_table[one].word_length := dscb_entry^.data_len;  ! "            tempx_table[2].flags.write_flag := false;    {andyjian}  "             tempx_table[2].flags.sort_flag := false;              tempx_table[2].flags.key_flag := false;   &            tempx_table[2].flags.item_num := zero;   {indicates end of info} &             table_length := tempx_entry_length + one;             END (* end if @ - all items *)        ELSE           BEGIN              process_item_list (item_list, dscb_entry,                            num_keys, istat.get.status);                   IF (istat.get.status <> zero) THEN GOTO 999;              tempx_table := dbbuf_table^.current_item_list;              ix := one;                  WHILE (tempx_table[ix].flags.item_num <> zero) DO                 ix := ix + one;                   table_length := ix * tempx_entry_length;           END; (* ELSE *)        END; (* WITH *)       #   (* The mode should be within the bounds [1,7] . If not, we have  *) # #   (* an error.  Now, we must decide what mode case to process.     *) # #   (* The mode determines what information should be put in the     *) # #   (* message to DBMON.                                             *) #     #   (* Mode 1 - reread the current record .                          *) # #   (*    DBMON requires the current record number from the dscb.    *) # #   (*                                                               *) # #   (* Mode 2,3 - read the next (previous) non_empty record (serial).*) # #   (*    DBMON requires the current record number.                  *) # #   (*                                                               *) # #   (* Mode 4 - read the record number specified by user.            *) # #   (*    DBMON requires that record number.                         *) # #   (*                                                               *) # #   (* Mode 5,6 - read the next (previous) non-empty record (chain). *) # #   (*    DBMON requires the next (previous) record number.          *) # #   (*                                                               *) # #   (* Mode 7 - hashed read into a master                            *) # #   (*    DBMON requires the key item value (set must be master).    *) # #   (*                                                               *) #        WITH mesg_buf^.get DO BEGIN     get_argument := user_argument;          CASE mode OF         1 : BEGIN            get_argument.record_number := dscb_entry^.last_rec;  #         IF (get_argument.record_number = zero) THEN BEGIN (* error *) #             istat.get.status := no_set_current_record_err;              GOTO 999;               END; (* THEN *)            END; (* case one *)           2,3 : BEGIN (* serial read *)           get_argument.record_number := dscb_entry^.last_rec;  "         (* DBMON will perform the serial read, checking for end *)  " "         (* condition errors.                                    *)  "          END;  (* end case mode 2,3 *)           4 : BEGIN (* directed read *)           WITH dscb_entry^, get_argument DO BEGIN              IF (record_number = zero) THEN BEGIN                 set_indics.last_path := zero;                 last_rec := zero;  !               istat.get.status := zero;   (* return successful *) !                    WITH istat.get DO BEGIN                    return_data_len := zero;                    current_record_num  := zero;                    unused := zero;                     END; (* with *)   #               GOTO 999;                (* no need to talk to dbmon *) #                END;(* THEN *)                   END;  (* end with *)           END;  (* end case mode 4 *)           5,6 : BEGIN (* chain read *)            WITH dscb_entry^, get_argument DO BEGIN              (* Must be a detail set *)              IF (set_indics.set_type <> detail) THEN BEGIN                  istat.get.status := not_a_detail_err;                 GOTO 999;                 END; (* THEN *)                  (* current path must be initialized *)              IF (set_indics.last_path = zero) THEN BEGIN                  istat.get.status :=  path_not_init_err;                 GOTO 999;                 END; (* THEN *)      %            (* Get the NEXT (mode5) or PREVIOUS (mode6) rec # on chain *)  % 
            IF (mode = 5)  
                THEN record_number := next_rec                  ELSE record_number := prev_rec;                  IF (record_number = zero) THEN BEGIN                 istat.get.status := chain_ends_found_err;                 GOTO 999;                 END; (* THEN *)                  END;   (* end with *)            END; (* case mode 5,6 *)       $      7 : BEGIN    (* hashed read - argument contains key item value *)  $ #            IF (dscb_entry^.set_indics.set_type  = detail) THEN BEGIN  #                istat.get.status := not_a_master_err;                 GOTO 999;                 END; (* THEN *)                  END; (* case mode 7 *)            OTHERWISE BEGIN            istat.get.status := invalid_mode_err;  	         GOTO 999; 	          END; (* otherwise *)             END; (* CASE *)          (* The mode checks out okay. *)  #   (* Form the mode independent portions of the message, as well   *)  # #   (* as the general message header.                               *)  #           set_num := set_number;        get_mode := mode;         path_num := dscb_entry^.set_indics.last_path;             IF send_receive_message (mesg_buf,                                 dbbuf_table,                                  run_table,                                  to_bm_get_code,                                 to_bm_get_mesg_len,                                 reply_mesg_buf,                                 return_length,                                  db_get,                                 istat.get.status)           THEN GOTO 999;       %      IF ((run_table^.indicators.levelnum = 15) and (temp.char_val = '@')) % !      THEN  dbbuf_table^.current_item_list[1].flags.item_num := 0; ! $      { to tell get/update/put that there is no real current item list } $     
      END;  (* end with *) 
        (* Look at the DBGET reply info  - update dscb *)     WITH reply_mesg_buf^.get , dscb_entry^ DO BEGIN  	      CASE mode OF 	          2,3,4,7 :    (* serial, directed or hashed read *)               set_indics.last_path := zero;            5,6 : BEGIN  (* chain read *)              prev_rec :=  prev_record_number;              next_rec :=  next_record_number;              END;  (* end case modes 5,6 *)  	         OTHERWISE 	          END;  (* end case *)             last_rec := current_record_number;            (* move the data values to user's buffer *)         move_data_values ( data_values, item_values_buffer,            return_data_length);       !      (* Form the return item values buffer to the user.       *)  !       WITH istat.get DO BEGIN            return_data_len := return_data_length;            current_record_num :=  current_record_number;           unused := zero;           prev_record_num :=  prev_record_number;           next_record_num :=  next_record_number;           END; (* end with return buffer *)            END; (* end with reply mesg buf and dscb_entry^ *)      999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_get] DO BEGIN               calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;           END;       888: (* skip stats if remote *)       END; (* DBGET *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure DBINFO                                                 *)  $ $(*                                                                   *)  $ $(*  purpose : This procedure references the local run table          *)  $ $(*            to return information  on the structure and current    *)  $ $(*            state of the data base.  It also references DBMON      *)  $ $(*            to return information on the log status.  The          *)  $ $(*            type of information returned is based on the value     *)  $ $(*            of the mode parameter.                                 *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) set/item id.                                               *)  $ $(*    (3) mode.                                                      *)  $ $(*    (4) istat.                                                     *)  $ $(*    (5) buffer for information.                                    *)  $ $(*                                                                   *)  $ $(*  returns : (1) return_status[1] is the status (0:successful)      *)  $ $(*                return_status[2] is the length of the info in      *)  $ $(*                                 return_buffer.                    *)  $ $(*                return_buffer has various information, dependent   *)  $ $(*                                 upon the mode.                    *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbinfo   $ Alias 'DBINF' $     (VAR ibase : ibase_type;       VAR data_id : item_set_name_type;   
    VAR mode  : short_int; 
     VAR return_status : stat_array;       VAR buffer : return_buffer_type);       LABEL 888,999;      VAR    (* variables global to DBINFO *)          run_table : ptr_local_run_table_hdr;      mesg_buf  : ptr_to_bm_mesg_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf : statistics_buffer_ptr_type;     start_time: long_int;      "   access_flag : short_int;     (* <0:write, 0:read, >0: inaccess *) " %   data_set_number : short_int; (* data set number - inbetween 1 and 50 *) %    item_count : short_int;      (* number of items counter *)   &   item_number : short_int;     (* data item number - inbetween 1 and 256 *) &    itx : short_int;             (* array indice *)     set_count : short_int;       (* number of sets counter *)  &   set_type_code : dataset_type;(* set type code - auto, detail or manual *) & '   item_entry_offset: short_int;(* start of item table entry within run tbl *) ' '   set_entry_offset: short_int; (* start of set table entry within run tbl *)  '         %   dscb_entry : ptr_dscb_entry; (* ptr to data set control block entry *)  % '   ds_inf_table : ptr_local_ds_inf_table;    (* data set information table *)  '    path_table : ptr_path_table; (* ptr to the path table *)       $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* function  inf_get_itm_or_set                                      *)  $ $(*                                                                   *)  $ $(* purpose : This procedure gets an item or set number and determines*)  $ $(*           its accessibility.  (for DBINF)                         *)  $ $(*                                                                   *)  $ $(* requires : (1) set_item_flag is (1) get item info                 *)  $ $(*                                 (2) get set info                  *)  $ $(*                                                                   *)  $ $(*            (2) severity level                                     *)  $ $(*                0 : if number is zero, bad_item_or_set error is    *)  $ $(*                       returned.                                   *)  $ $(*                1 : if number is zero, db corrupt error is returned*)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(* returns : (3) item or set number                                  *)  $ $(*                  + if item or set is read-only                    *)  $ $(*                  - if item or set is write and read-able          *)  $ $(*           (4) item/set's entry addr,relative to start of run table*)  $ $(*                                                                   *)  $ $(*           global return_status[one]                               *)  $ $(*                  0: successful                                    *)  $ $(*                  otherwise : error number                         *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION  inf_get_itm_or_set     (     item_set_flag :  short_int;           severity_level : short_int;       VAR data_id : item_set_name_type;       VAR number : short_int;       VAR entry_offset: short_int): BOOLEAN;           BEGIN (* inf_get_itm_or_set *)         IF (item_set_flag = want_item)         THEN DBFDI (data_id, number, access_flag, entry_offset)         ELSE DBFDS (data_id, number, access_flag, entry_offset);         return_status[one] := zero;     IF (number = zero)             THEN IF  severity_level = severe           THEN return_status[one] := db_corrupt_err           ELSE return_status[one] := bad_item_or_set_err             ELSE BEGIN           IF (access_flag > zero) (* inaccessible *)               THEN return_status[one] := bad_item_or_set_err;            IF (access_flag < zero) (* indicate writable *)              THEN number := -number;            END;          IF return_status[one] <> zero        THEN inf_get_itm_or_set := true         ELSE inf_get_itm_or_set := false;       END; (* inf_get_itm_or_set *)   $ Page $  $(**********************************************************************) $ $(*                                                                    *) $ $(* procedure inf_mode_x03                                             *) $ $(*                                                                    *) $ $(* purpose : This procedure returns the asscessibility of a group     *) $ $(*           of data set (or item) numbers.  It returns               *) $ $(*           a buffer which contains :                                *) $ $(*                ( 1 )  count of the number of set (item) numbers    *) $ $(*                (2-n)  + or - data set (or item) number             *) $ $(*           This procedure is used by dbinf modes 103 and 203.       *) $ $(*                                                                    *) $ $(**********************************************************************) $     PROCEDURE inf_mode_x03  
   (     flag : short_int; 
      VAR count : short_int);      LABEL      999;       VAR      index : short_int;      number, start_entry : short_int;      data_id : item_set_name_type;      BEGIN (* inf_mode_x03 *)         itx := zero;      WITH buffer.mx03_mx04 DO BEGIN         FOR index := one to count DO BEGIN           data_id.number := index;            IF inf_get_itm_or_set (flag, non_severe, data_id,                                  number,start_entry)               THEN IF (return_status[one] = bad_item_or_set_err)                 THEN return_status[one] := no_image_err                 ELSE GOTO 999                  ELSE BEGIN                 itx := succ (itx);                  item_num[itx] := number;   
               END;  
              END;    (* end for loop *)             num_avail_items := itx;         return_status[2] := itx + one;  
      END;  (* end with *) 
     999: (* error exit *)   END;   (* end inf_mode_x03 *)   $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure item_info_handler                                      *)  $ $(*                                                                   *)  $ $(*  purpose : This procedure provides information concerning data    *)  $ $(*            items (DBINF modes 101, 102, 103, 104).                *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE item_info_handler;      LABEL 999;      CONST      ten_blanks = '          ';       VAR      index : short_int;      start_item_table : short_int;     data_item : item_set_name_type;  '   rdt_offset : short_int;               (* record definition table offset *)  '    item_table_entry : ptr_item_table_entry;       BEGIN (* info_item_handler *)          CASE mode OF         101: BEGIN           IF inf_get_itm_or_set (want_item,non_severe, data_id,                                   item_number, item_entry_offset)    
            THEN GOTO 999; 
          buffer.m101.item_num := item_number;            return_status[2] := one;  (* length of return info *)           END; (* mode 101 *)            102: BEGIN           (* get the specified data item information *)           IF inf_get_itm_or_set (want_item, non_severe,data_id,                                   item_number, item_entry_offset)    
            THEN GOTO 999  
             ELSE return_status[2] := m102_return_len;                rt_ite_set_ptr_addr (run_table, item_entry_offset,                                 item_table_entry);               WITH buffer.m102 DO BEGIN              item_name := item_table_entry^.item_name;               unused1 := ten_blanks;               item_type := item_table_entry^.rw_access.item_type;                unused2 := one_blank;               sub_item_len := item_table_entry^.item_len *                              chars_in_word DIV   "                            item_table_entry^.rw_access.elem_count;  "                 IF (item_type <> type_char)   "               THEN sub_item_len := sub_item_len DIV chars_in_word;  " #            sub_item_count := item_table_entry^.rw_access.elem_count;  # 
            unused3 := 0;  
             END; (* WITH *)            END; (* mode 102 *)            103: BEGIN           (* Get the item count for the data base      *)           item_count := run_table^.itm_count;               (* Identify data items and accessibility *)           inf_mode_x03 (want_item, item_count);           END; (* mode 103 *)            104: BEGIN           WITH buffer.mx03_mx04 DO BEGIN                (* Get the item count for the specified data set  *)            (* as well as the record definition table offset. *)            itx := zero;            IF inf_get_itm_or_set (want_set,                                   non_severe,                                   data_id,                                  data_set_number,                                  set_entry_offset)   
            THEN GOTO 999; 
     %         rt_dscbe_set_ptr_addr (run_table, set_entry_offset, dscb_entry);  %          WITH dscb_entry^ DO BEGIN              item_count := set_indics.num_items;               rdt_offset := info_off;               END;  (* end with *)      "         rt_dsit_set_ptr_addr (run_table, rdt_offset, ds_inf_table); "              (* For each item in the data set info table,     *)           (* determine the item number and accessibility.  *)           FOR index := 1 to item_count DO BEGIN              data_item.number:=ds_inf_table^[index];   "            IF inf_get_itm_or_set (want_item, non_severe, data_item, " !                                   item_number,item_entry_offset)  ! !               THEN IF (return_status[one] = bad_item_or_set_err)  !                   THEN return_status[one] := no_image_err                     ELSE GOTO 999   
               ELSE BEGIN  
                   itx := itx + one;                     item_num[itx] := item_number;                     END; (* THEN *)   
            END; (* FOR *) 
          return_status[2] := itx + one;            num_avail_items := itx;               END;  (* end with *)   
      END; (* mode 104 *)  
           OTHERWISE;            END; (* CASE *)       999: (* error exit *)       END;   (* end item_info_handler *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* PROCEDURE get_used_record_count                                   *)  $ $(*                                                                   *)  $ $(* purpose : This procedure gets the used record count for a         *)  $ $(*           particular data set.  In order to do this, it must      *)  $ $(*           communicate with DBMON who has knowledge of it.         *)  $ $(*           It also returns the dataset's current capacity.         *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE get_used_record_count      ( VAR run_table : ptr_local_run_table_hdr;        VAR mesg_buf : ptr_to_bm_mesg_type;       VAR dbbuf_table : ptr_dbbuf_table;        VAR set_number : short_int;       VAR set_capac  : Long_int;        VAR used_record_count : long_int);       LABEL 999;      VAR   
   return_len : short_int; 
    ret_mesg_buf : ptr_to_user_mesg_type;      BEGIN (* get_used_record_count *)       #   (* form the message to DBMON - need only fill in what is needed *)  # #   (*  in the general message header.                              *)  #     
   WITH mesg_buf^ DO BEGIN 
 
      inf.mode := mode202; 
       inf.set_num := set_number;        END; (* with *)          IF send_receive_message (mesg_buf,                               dbbuf_table,                              run_table,                              to_bm_inf_code,                               to_bm_inf_202_mesg_len,                               ret_mesg_buf,                               return_len,                               db_info,                              return_status[one])   
      THEN GOTO 999; 
        WITH ret_mesg_buf^.inf202 DO BEGIN         used_record_count := num_used_records;        set_capac         := dataset_capacity;  
      END;  (* end with *) 
     999:      END; (* get_used_record_count *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure set_info_handler                                       *)  $ $(*                                                                   *)  $ $(*  purpose : This procedure provides information concerning data    *)  $ $(*            sets (DBINF modes 201, 202, 203, 204).                 *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE set_info_handler;       LABEL 999, 888;       VAR      index : short_int;      start_set_table : short_int;      start_set_info_table: short_int;      data_set :item_set_name_type;     num_sets_with_item : short_int;         num_used_records : long_int;      set_capac        : long_int;       
   num_items : short_int;  
 
   found : boolean;  
 
   word : short_int; 
    word_off : short_int;      BEGIN (* set_info_handler *)         CASE mode OF             201: BEGIN (* get the set's number and accessibility *)            IF inf_get_itm_or_set (want_set, non_severe,data_id,   !                                data_set_number, set_entry_offset) ! 
            THEN GOTO 999; 
          return_status[2] := one;   (* len of return info *)           buffer.m201.set_num := data_set_number;           END; (* mode 201 *)            202: BEGIN (* describe the data set *)           IF inf_get_itm_or_set (want_set, non_severe,data_id,   !                                data_set_number, set_entry_offset) ! 
            THEN GOTO 999  
             ELSE return_status[2] := m202_return_len;                IF (data_set_number < zero) (* make it positive *)               THEN data_set_number := zero - data_set_number;                 (* Now, get the used record count from DBMON before *)              (* we go any further ( in case theres a DBMON       *)              (* communication error.                             *)                  get_used_record_count (run_table,mesg_buf,dbbuf_table,                                    data_set_number, set_capac,                                   num_used_records);           IF (return_status[one] <> zero)  
            THEN GOTO 999; 
     %         rt_dscbe_set_ptr_addr (run_table, set_entry_offset, dscb_entry);  %              WITH buffer.m202 DO BEGIN              num_entries_in_set := num_used_records;               set_capacity := set_capac;              set_name := dscb_entry^.set_name;   "            unused0 := '          ';  (* 10 characters - 5 words *)  "             unused1 := ' ';               set_type_code := dscb_entry^.set_indics.set_type;               CASE set_type_code OF                  auto_master:                     set_type := type_automatic;   
               man_master: 
                   set_type := type_manual;                 detail:                    set_type := type_detail;                 OTHERWISE BEGIN                    return_status[one] := db_corrupt_err;                     GOTO 999;                     END;                 END; (* CASE for backward compatibility *)                   WITH dscb_entry^ DO BEGIN                  entry_word_len := data_len;                 unused2 := zero;                  END;  (* end with *)               END;  (* end with *)           END; (* mode 202 *)            203: BEGIN (* enumerate all accessible data sets *)            (* get the set count *)           set_count := run_table^.set_count;                (* Identify data sets and accessibility *)            inf_mode_x03 (want_set, set_count);           END; (* mode 203 *)            204: BEGIN (* enumerate all data sets which contain  *)                    (* a specific data item.                  *)                WITH buffer.mx03_mx04 DO BEGIN       "         (* First, lets check the data item's accessibility & num *) " %         IF inf_get_itm_or_set (want_item,non_severe,data_id, item_number, %                                 item_entry_offset)  
            THEN GOTO 999; 
          set_count := run_table^.set_count;            IF (item_number < zero) (* make it positive *)               THEN item_number := -item_number;       !         (* Look through all the data sets for the data item.  *)  !          num_sets_with_item := zero;           FOR index := one  TO set_count DO BEGIN              data_set.number := index;                (* check the set's accessibility and entry offset *)               IF inf_get_itm_or_set (want_set, severe, data_set,  "                                   data_set_number, start_set_table) " 
               THEN BEGIN  
                    return_status[one] := zero; (* reset status *)                     GOTO 888; (* set not accessible *)                    END; (* then *)       $            rt_dscbe_set_ptr_addr(run_table,start_set_table,dscb_entry); $             start_set_info_table := dscb_entry^.info_off;   !            rt_dsit_set_ptr_addr (run_table, start_set_info_table, !                                   ds_inf_table);              num_items := dscb_entry^.set_indics.num_items;                   (* Determine if the item number is in this table *)                item_count := one;              found := false;   "            WHILE (item_count<= num_items) AND not (found) DO BEGIN  "                IF (item_number = ds_inf_table^[item_count])                     THEN found := true                    ELSE item_count := item_count + 1;                 END;  (* end while *)      "            (* If so, return the set number and its accessibility *) "             IF (found) THEN BEGIN                  num_sets_with_item := num_sets_with_item + one;                  item_num[num_sets_with_item] := data_set_number;                   END; (* THEN *)      888: (* when set is not accessible *)                   END; (* FOR each set *)                num_avail_items := num_sets_with_item;            return_status[2] := num_sets_with_item + one;           return_status[one] := zero;           (* length of the return info *)           END;  (* end with *)       
      END; (* mode 204 *)  
         OTHERWISE;          END;  (* end case *)      999: (* error exit *)       END; (* set_info_handler *)   $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure path_info_handler                                      *)  $ $(*                                                                   *)  $ $(*  purpose : This procedure provides information on the data        *)  $ $(*            paths (DBINF modes 301, 302).                          *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE path_info_handler;      LABEL 10,999;       VAR      index : short_int;   
   num_paths : short_int;  
 
   num_fields : short_int; 
 
   path_count : short_int; 
    start_pt, pt_offset : short_int;      item_id : item_set_name_type;     info_table_offset: short_int;         master_set     : short_int;     path_table_ptr : ptr_path_table;           FUNCTION get_item_access : Boolean;       (**)  	(* globals used :  	 (*   item_id,   (*  
(* globals returned: 
 	(*   item_number,  	 	(*   access_flag,  	 (*   item_entry_offset  (**)          BEGIN       DBFDI (item_id, item_number, access_flag, item_entry_offset);      IF (item_number = zero) THEN BEGIN         return_status[one] := db_corrupt_err;         get_item_access := true;        END      ELSE         get_item_access := false;       END; (* end function *)           BEGIN (* path_info_handler *)          CASE mode OF       #      301: BEGIN (* Enumerate all data sets linked to a specific    *) # #                 (* data set, the detail data set search item nos.  *) # #                 (* used for the links & the sort item for the link.*) #              IF inf_get_itm_or_set (want_set, non_severe, data_id,  !                                data_set_number, set_entry_offset) ! 
            THEN GOTO 999; 
              (* get the set's number of paths from the DSCB *)      %         rt_dscbe_set_ptr_addr (run_table, set_entry_offset, dscb_entry);  %          num_paths := dscb_entry^.set_indics.num_paths;       #         (* get the path table address, relative to run table start *) #          WITH dscb_entry^ DO BEGIN              info_table_offset := info_off;              rt_dsit_set_ptr_addr(run_table,info_table_offset,                                    ds_inf_table);               num_fields := set_indics.num_items;               pt_offset := (num_fields + one) DIV 2;  $            dsit_pt_set_ptr_addr (ds_inf_table, pt_offset, path_table);  $             END;  (* end with *)               IF (num_paths > zero) THEN BEGIN               path_count := zero;               FOR index := one to num_paths DO BEGIN                     (* get search item number *)                  item_id.number := path_table^[index].detl_key;                      (* is it accessible ? *)                  IF get_item_access THEN GOTO 999;      "               IF (access_flag > zero) THEN GOTO 10; (* skip path *) "                    WITH buffer.m301.path_info[path_count] DO BEGIN                        (* store the related data set # *)                    set_num := path_table^[index].rltd_set;                     search_item_num := item_number;                         (* get the sort item number *)                     item_id.number :=path_table^[index].sort_itm;                      IF (item_id.number  <> zero) THEN BEGIN                        IF get_item_access THEN GOTO 999;      !                     IF (access_flag > zero) (* not accesssible *) !                         THEN sort_item_num :=zero                           ELSE sort_item_num := item_number;                       END (* THEN *)   &                           ELSE sort_item_num := zero; (* no sort number *)  &                       END;  (* end with *)                     (* DONE with this path - go on to next one *)                 path_count := path_count + one;  10:                  END; (* FOR *)                   buffer.m301.num_paths := path_count;  "            return_status[2] := path_count * 3 + one; (* length of*) "             END (* THEN *)          (* ret info *)               ELSE BEGIN (* no paths *)              buffer.m301.num_paths := zero;  !            return_status[2] := one;  (* length of return info *)  !             END; (* ELSE *)                END; (* mode 301 *)      #      302: BEGIN (* Determine the search item number of a specific *)  # #                 (* master data set.                               *)  #              IF inf_get_itm_or_set (want_set, non_severe, data_id,  !                                data_set_number, set_entry_offset) ! 
            THEN GOTO 999; 
              (* is the set a master ? *)  $         rt_dscbe_set_ptr_addr(run_table, set_entry_offset, dscb_entry); $          set_type_code := dscb_entry^.set_indics.set_type;      "         (* Get the search item number.  Check for accessibility *)  "          item_id.number := dscb_entry^.set_indics.last_key;                (* For a detail set, there must be a current path *)            IF (item_id.number = zero) THEN BEGIN              return_status[one] := path_not_init_err;              GOTO 999;               END;               IF get_item_access THEN GOTO 999;                   master_set := zero;  (* Assume set is a master *)               IF (set_type_code = detail) THEN BEGIN                   (**)              (* Determine which master's path is being               (* traversed, and return its set number.              (**)                  make_path_table_ptr (run_table,                                    dscb_entry^.info_off,                                   path_table_ptr);       
            master_set :=  
 '                  path_table_ptr^[dscb_entry^.set_indics.last_path].rltd_set;  '                 END; (* then set was a detail *)                   WITH buffer.m302 DO BEGIN              IF (access_flag > zero)                  THEN search_item_num := zero                  ELSE search_item_num := item_number;               master_num := master_set;               return_status[one] := zero;               return_status[2] := m302_return_len;              END;  (* end with *)               END; (* mode 302 *)            OTHERWISE;            END; (* case *)       999: (* error exit *)       END; (* path_info_handler *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure current_path_info_handler                              *)  $ $(*                                                                   *)  $ $(*  purpose : This procedure provides information on the             *)  $ $(*            CURRENT data structures (DBINF modes 401, 402).        *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE current_path_info_handler;      LABEL 999;      BEGIN      IF inf_get_itm_or_set (want_set, non_severe, data_id,                            data_set_number, set_entry_offset)  
      THEN GOTO 999; 
     "   rt_dscbe_set_ptr_addr (run_table, set_entry_offset, dscb_entry);  "        CASE mode OF   #      401: BEGIN (* return (1) most recently accessed record        *) # #                 (* (3) previous record, if detail (zero otherwise) *) # #                 (* (5) next record, if detail (zero otherwise)     *) # #                 (* All double word values.                         *) #              WITH buffer.m40x, dscb_entry^  DO BEGIN              last_accessed_rec := last_rec;              previous_rec := prev_rec;               next_record := next_rec;              current_path := set_indics.last_path;               END; (* with *)                END; (* mode 401 *)            402: BEGIN (* restore chain information *)           WITH buffer.m40x, dscb_entry^ DO BEGIN               last_rec := last_accessed_rec;              prev_rec := previous_rec;               next_rec := next_record;              set_indics.last_path := current_path;   
            END;(* with *) 
          END; (* mode 402 *)            OTHERWISE;            END; (* case *)          return_status[2] := m401_return_len;       999: (* error exit *)       END; (* current_path_info_handler *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure log_info_handler                                       *)  $ $(*                                                                   *)  $ $(*  purpose : This procedure provides information concerning the     *)  $ $(*            log status (DBINF mode 801).  To do so, we             *)  $ $(*            communicate with the data base monitor program DBMON.  *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE log_info_handler;       LABEL 999;      VAR      index : short_int;      ret_mesg_buf : ptr_to_user_mesg_type;  
   temp : long_int;  
 
   return_len : short_int; 
    num_transactions : short_int;      BEGIN (* log_info_handler *)         mesg_buf^.inf.mode := mode801;          IF send_receive_message (mesg_buf,                               dbbuf_table,                              run_table,                              to_bm_inf_code,                               to_bm_inf_801_mesg_len,                               ret_mesg_buf,                               return_len,                               db_info,                              return_status[one])   
      THEN GOTO 999; 
        WITH buffer.m801, ret_mesg_buf^ DO BEGIN         num_blocks_used := inf801.blocks_used;        total_avail_blocks := inf801.total_avail_blocks;        return_status[3] := ORD(inf801.reply.log_state);        END; (* WITH *)          return_status[one] := zero;     return_status[2] := m801_return_len;       999: (* error exit *)       END; (* log_info_handler *)   $ Page $  #(*******************************************************************)  # #(*                     statistics handler                          *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To return IMAGE performance statistics to the caller.        *)  # #(*                                                                 *)  # #(* The summary statistics are calculated from the sum of the       *)  # #(* intrinsic call information.                                     *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE statistics_handler;       VAR      loop : call_types;       BEGIN          (**)      (* Both modes 505 and 506 use the following code.     (**)          (* Calculate summary data *)          WITH stats_buf^.call_stats[db_summary] DO BEGIN        calls_made   := zero;         elapsed_time := zero;         cpu_time     := zero;         io_count     := zero;         io_time      := zero;         wait_time    := zero;         service_time := zero;         END;         (* Sum up individual stats to make summary *)         FOR loop := db_begin TO db_update DO         sum_up_intrinsic_stats           (stats_buf^.call_stats[db_summary],            stats_buf^.call_stats[loop],            number_of_intrinsic_statistics);         (**)      (* Summarize locking stats.  "   (* NOTE! This code is optimized for IMAGE-II in that it does not  " !   (* collect stats for record/page/predicate locks, and no stats  ! !   (* about shared locks since only exclusive locks are supported. !    (**)          WITH stats_buf^.lock_stats DO BEGIN        total_entities_locked := exclusive_db_locks +                                  exp_exclusive_sets +                                  imp_exclusive_sets;        exclusive_set_locks := exp_exclusive_sets +                                imp_exclusive_sets;        END;             copy_statistics_buffer (stats_buf^,                             buffer.m50x,                              words_in_statistics_buffer);       	   IF (mode = 506) 	       THEN fill_with_value (words_in_statistics_buffer,                               stats_buf^,                               zero);      END; (* statistics handling *)  $ Page $  BEGIN (* info *)         IF get_database_pointers (ibase[one],                               dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                return_status[one])  
      THEN GOTO 999; 
        IF (run_table^.indicators.remote) THEN BEGIN   !      remote_dbinfo (ibase, data_id, mode, return_status, buffer); !       GOTO 888;         END;         IF (stats_buf <> nil)        THEN start_time := get_start_time;         (* call the appropriate info handling routine *)      CASE mode OF             101, 102, 103, 104: (* item information request *)           item_info_handler;             201, 202, 203, 204: (* set information request *)   
         set_info_handler; 
           301, 302: (* specific path information request *)            path_info_handler;             401, 402: (* current path information request *)           current_path_info_handler;             505, 506: (* get statistics without/with reset. *)           IF (stats_buf <> nil) THEN statistics_handler;             801: (* log information request *)  
         log_info_handler; 
           OTHERWISE (* illegal mode *)           return_status[one] := illegal_info_mode_err;             END; (* CASE *)       999: (* error exit *)          IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_info] DO BEGIN                calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;           END;       888: (* skip stats if remote *)       END; (* info *)   $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure LOCKR                                                   *)  $ $(*                                                                   *)  $ $(* purpose:                                                          *)  $ $(*    To lock a database, data set or multiple data sets, with or    *)  $ $(*    without wait.                                                  *)  $ $(*                                                                   *)  $ $(* parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) dummy (modes 1,2), set or sets (modes 3-8).                *)  $ $(*    (3) mode.                                                      *)  $ $(*    (4) istat array.                                               *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION dblock  $ Alias 'DBLCK' $     (VAR ibase : ibase_type;       VAR lock_request : lock_request_buffer;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type) : short_int;      LABEL 888,999; (* error exit *)       VAR      run_table : ptr_local_run_table_hdr;      req_mesg_buf : ptr_to_bm_mesg_type;     dbbuf_table  : ptr_dbbuf_table;     stats_buf    : statistics_buffer_ptr_type;      start_time   : long_int;       "   set_id_ptr:                     (* dataset identifier pointer *)  "       ptr_item_set_name_type;      base_number: short_int;         (* database number *)     set_number: short_int;          (* dataset number *)      dummy: ptr_dscb_entry;          (* dummy parameter *)         ret_mesg_buf:                   (* return message buffer *)        ptr_to_user_mesg_type;  $   ret_mesg_len: short_int;        (* return message length in words *)  $     &   wait_for_lock: boolean;         (* flag for determining wait condition *) & #   status_ok: boolean;             (* flag for checking lock status *) #        lck_sets : short_int;     dummy_boolean : boolean;          conflict_occurred : boolean;      conflict_time     : long_int;     save_explicit_sets: short_int;       $ Page $  #(*******************************************************************)  # #(*                   build_predicate_table                         *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Build_predicate_table builds a lock table from the information  *)  # #(* in a lock request buffer.                                       *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE build_predicate_table;      TYPE  
   char_pair_type = RECORD 
       CASE short_int OF            1: (chars : PACKED ARRAY [1..2] OF char);           2: (word  : short_int);        END; (* record *)           CONST   	   blank   = ' ';  	 	   at_sign = '@';  	         VAR   "   lock_desc_off: short_int;       (* lock request buffer offset *)  " #   lock_desc_num: short_int;       (* current lock descriptor entry *) # $   lock_desc_len: short_int;       (* lock descriptor length in words *) $     "   char_pair    : char_pair_type;  (* For getting chars in a word *) "         BEGIN (* build_predicate_table *)          (* check 'number of lock descriptors' for validity *)     IF (lock_request[1] < 0) OR        (lock_request[1] > max_data_sets) THEN BEGIN        istat.lck.status := invalid_num_of_lock_descriptors_err;        GOTO 999;         END;         req_mesg_buf^.estab_locks.set_count := zero;          lock_desc_off := 2; (* Offset to a descriptor *)          (* loop for every lock descriptor *)      FOR lock_desc_num := one TO lock_request[one] DO BEGIN             (* get lock descriptor length *)        lock_desc_len := lock_request [lock_desc_off];            (* check lock descriptor length *)        IF lock_desc_len <> 9 THEN BEGIN (* bad length *)            istat.lck.status := lock_desc_wrong_length_err;  	         GOTO 999; 	          END; (* then *)            char_pair.word := lock_request [lock_desc_off+1];             (* check lock descriptor information *)         IF ((char_pair.word <> 0) AND            (char_pair.chars[1] <> blank)) THEN BEGIN               (* check for 'all' indicator *)           IF (char_pair.chars[1] = at_sign)              THEN BEGIN                 (* we have a database lock request *)                 (* Change the mode to DB lock mode *)                 req_mesg_buf^.estab_locks.mode :=                    req_mesg_buf^.estab_locks.mode - 4;                  END  (* then *)                  ELSE BEGIN (* we have a data set... *)                     (* check if dataset exists *)                 set_id_ptr := item_set_id_addr                                    (lock_request[lock_desc_off+1]);   !               IF set_getter (set_id_ptr^, run_table, set_number,  !                               dummy, istat.lck.status)                    THEN GOTO 999;                      (* insert dataset number into user lock table *)                   WITH req_mesg_buf^.estab_locks DO BEGIN                    set_count := set_count + one;                     set_nums[set_count] := set_number;                    END; (* with *)                  END; (* else *)                  END; (* then *)             (* bump to next lock descriptor and next subentry *)        lock_desc_off := lock_desc_off + lock_desc_len;             (**)  "      (* Theoretically, IMAGE should check to see that lock_desc_off " #      (* remains in the users program space, otherwise an unexplained  #        (* DM violation could occur and it would look like IMAGE's   !      (* fault when really the user had a much too large number of !       (* of lock descriptors.         (**)      
      END; (* for *) 
     END; (* build_predicate_table *)  $ Page $  	BEGIN (* dblock *) 	        IF get_database_pointers (ibase[one],                               dbbuf_table,                                req_mesg_buf,                               run_table,                                stats_buf,                                istat.lck.status)  
      THEN GOTO 999; 
            IF (run_table^.indicators.remote) THEN BEGIN         remote_dblock (ibase, lock_request, mode, istat);         GOTO 888;         END;         IF (stats_buf <> nil)        THEN start_time := get_start_time;         conflict_occurred := false;      conflict_time := get_start_time; (* for waiting for locks *)           (* try establishing locks *)      REPEAT          (* preset return status for good return *)      istat.lck.status := no_image_err;         (* build lock table from lock request *)       req_mesg_buf^.estab_locks.mode := mode;  (* Save lock mode *)              (* build lock table subentries *)     CASE mode OF             1,2: (* database lock request with or without wait *)            BEGIN              req_mesg_buf^.estab_locks.set_count := zero;           END;                 3,4: (* dataset lock request with or without wait *)           BEGIN                  (* build dataset lock *)                  (* calculate set identifier address *)              set_id_ptr := item_set_id_addr (lock_request [1]);                  (* check dataset validity *)              IF set_getter (set_id_ptr^, run_table, set_number,                             dummy, istat.lck.status)                  THEN GOTO 999;   (* generate error *)                  (* Place set number in message buffer *)              WITH req_mesg_buf^.estab_locks DO BEGIN                  set_count := one;                 set_nums[1] := set_number;                  END; (* with *)                  END; (* case of modes 3 and 4 *)                5,6: (* predicate lock request with or without wait *)    #            BEGIN                     (* build short predicate lock *) #                build_predicate_table;                  END; (* BEGIN *)       #         7,8: (* multiple dataset lock request with or without wait *) # 	            BEGIN  	                IF parse_data_set_list                          (lock_request,                           req_mesg_buf^.estab_locks.set_count,                          istat.lck.status)                     THEN GOTO 999;                 END; (* BEGIN *)                OTHERWISE BEGIN (* unknown mode *)               istat.lck.status := invalid_mode_err;               GOTO 999;               END; (* BEGIN *)      
         END;  (* case *)  
            (* Runtable open modes of 3 and 8 are ignored *)      IF (run_table^.open_mode = 8) OR (run_table^.open_mode = 3)  
      THEN GOTO 999; 
        save_explicit_sets := req_mesg_buf^.estab_locks.set_count;           #   (* determine wait condition - odd modes indicate lock with wait *)  #    wait_for_lock := odd(mode);                dblock := -1; (* in case the lock_comm_lock_id or *)                      (* unlock_comm_lock_id fail.        *)            IF send_receive_message (req_mesg_buf,                                 dbbuf_table,                                  run_table,                                  to_bm_estab_locks_code,                                 to_bm_estab_locks_msg_len,                                  ret_mesg_buf,                                 ret_mesg_len,                                 db_lock,                                  istat.lck.status)           THEN; (* check for lock conflict *)            (* check for lock conflict *)   "      IF (istat.lck.status = lock_conflict_err) AND (wait_for_lock)  " #         THEN BEGIN                (* wait for awhile and try again *) #             conflict_occurred := true;              istat.lck.status := zero;                   IF lock_comm_lock_id                    (dbbuf_table^.comm_info.dblck_wait_lock,                     istat.lck.status)                 THEN GOTO 999;               IF unlock_comm_lock_id                    (dbbuf_table^.comm_info.dblck_wait_lock,                     istat.lck.status)                 THEN GOTO 999;                   status_ok := false;   
            END (* then *) 
              ELSE status_ok := true;            UNTIL status_ok;         conflict_time := get_elapsed_time (conflict_time);          IF ((istat.lck.status = zero) AND (stats_buf <> nil))        THEN WITH stats_buf^.lock_stats DO BEGIN        (* Add to lock-conflict stats *)        IF (conflict_occurred)  
         THEN IF (mode<3)  
             THEN BEGIN  (* db lock *)                  db_wait_count := db_wait_count + one;                 db_wait_time  := db_wait_time + conflict_time;   	               END 	             ELSE BEGIN  (* set lock *)                 set_wait_count := set_wait_count + one;                  set_wait_time  := set_wait_time + conflict_time;    
               END;  
           (* Add to lock-successful stats *)  
      IF (mode < 3)  
          THEN exclusive_db_locks := exclusive_db_locks + one  
         ELSE BEGIN  
             exp_exclusive_sets := exp_exclusive_sets +                                    save_explicit_sets;               imp_exclusive_sets := imp_exclusive_sets +  #               ret_mesg_buf^.estab_locks.implicit_exclusive_set_locks; #             END;            END; (* then with stats do *)          dblock := zero;  (* Successful function result *)          999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_lock] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time -io_time - wait_time;            END;       888: (* skip stats if remote *)       	END; (* DBLOCK *)  	 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBMEMO                                                  *)  $ $(*                                                                   *)  $ $(* purpose: To place a user-specified comment in the log file.       *)  $ $(*                                                                   *)  $ $(* parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) user text.                                                 *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) user text length.                                          *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbmemo   $ Alias 'DBMEM' $     (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len : short_int);      LABEL 888,999;      CONST      not_dbbegin = false;       VAR      base        : short_int;      temp_ibase  : ibase_type;         run_table : ptr_local_run_table_hdr;      to_mesg_buf : ptr_to_bm_mesg_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf   : statistics_buffer_ptr_type;  
   start_time  : long_int; 
        from_mesg_buf: ptr_to_user_mesg_type;     from_mesg_len: short_int;          BEGIN (* memo *)      
   stats_buf := nil; 
        temp_ibase := ibase;          CASE mode OF             1: base := ibase[one];            3: IF ibase[one] <= max_db              THEN base := ibase[2]   %            ELSE IF make_ibase_list (ibase, temp_ibase, istat.mem.status)  %                THEN GOTO 999                 ELSE base := temp_ibase[2];        OTHERWISE BEGIN            istat.mem.status := invalid_mode_err;  	         GOTO 999; 	          END;         END; (* case *)              IF multi_db_pointers (base,                           dbbuf_table,                            to_mesg_buf,                            run_table,                            stats_buf,                            istat.mem.status)  
      THEN GOTO 999; 
        IF (run_table^.indicators.remote) THEN BEGIN         remote_dbmemo (ibase, user_text, mode, istat, text_len);        GOTO 888;         END;         IF (stats_buf <> nil)        THEN start_time := get_start_time;      	   IF (mode = one) 	 !      THEN transaction_base_formatter (run_table^.transaction_id,  !                                        dbbuf_table,                                          temp_ibase);       #   (* Make sure that all the databases are part of same transaction *) #    IF transaction_checker (not_dbbegin,                              dbbuf_table,                              temp_ibase,                             istat.mem.status)  
      THEN GOTO 999; 
            (* Set up specific memo message fields *)         (**)      (* Call text string processor to word-align and blank-pad.      (**)          WITH to_mesg_buf^.memo DO BEGIN        IF process_text_str (user_text,                              text_len,                             log_comment,                              log_comment_len,                              istat.mem.status)           THEN GOTO 999;             xact_num := run_table^.transaction_id;        END;             IF send_receive_message (to_mesg_buf,                              dbbuf_table,                              run_table,                              to_bm_mem_code,                               to_bm_memo_mesg_len,                              from_mesg_buf,                              from_mesg_len,                              db_memo,                              istat.mem.status)   
      THEN GOTO 999; 
     
   WITH istat.mem DO BEGIN 
       logging_state := from_mesg_buf^.memo.reply.log_state;         xaction_num   := run_table^.transaction_id;         END;      999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_memo] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;           END;       888: (* skip stats if remote *)       END; (* memo *)   $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure get_buffer_area                                        *)  $ $(*                                                                   *)  $ $(*  purpose : This procedure allocates a buffer for the run table.   *)  $ $(*                                                                   *)  $ $(*            It calls DBGBF to obtain a buffer area where the       *)  $ $(*            run table will be placed.  The routines DBGBF          *)  $ $(*            (get buffer) and DBRBF (Return buffer) updates a       *)  $ $(*            table of pointers (addresses) to the message and       *)  $ $(*            run table buffer areas.  This table resides in         *)  $ $(*            the global dbbuf table.                                *)  $ $(*                                                                   *)  $ $(*            The maximum size run table buffer size is requested    *)  $ $(*            first.  If that is not availabe, all the               *)  $ $(*            remaining space is allocated for the buffer.           *)  $ $(*                                                                   *)  $ $(*            If this is the first time an open is performed, then   *)  $ $(*            a message buffer is allocated.  The minimum size       *)  $ $(*            buffer needed for an user to dbmon open message, is    *)  $ $(*            allocated.  After DBMON returns information to         *)  $ $(*            us, OPENR will then allocate the proper size message   *)  $ $(*            buffer.                                                *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     FUNCTION GET_BUFFER_AREA  $ Alias 'Img.GetBuffers' $     ( VAR ibase : dbopn_ibase_type;       VAR dbbuf_table : ptr_dbbuf_table;        VAR index_run_tbl : short_int;        VAR avail_run_table_buf_len : short_int;   (* returned *)       VAR status : short_int) : Boolean;       LABEL 999;      CONST   
   flag_open = zero; 
 %   min_message_buffer = to_bm_open_mesg_len; (* Minimum message buffer *)  %     VAR   "   error : short_int;   (* either zero or an error from proc call *) " !   avail : short_int;   (* largest block avail from background *)  !    request_len : short_int;       BEGIN (* get_buffer_area *)          get_buffer_area := true;  (* assume an error will occur *)          (**)      (* Assign a data base number for this run table.  This      (* number is also the index into the run table buffer  
   (* pointer table. 
    (**)       	   Status := zero; 	     DBFRT ( ibase.node_number, flag_open, index_run_tbl, status);      IF (status <> zero) THEN BEGIN        status := db_not_open_to_user_err;        GOTO 999;       END;          (* Get the IMAGE communication buffer *)       IF get_image_comm_buffer (dbbuf_table^.comm_info) THEN BEGIN          status := image_not_started_err;        GOTO 999;         END;             (**)   "   (* Get a slice of memory for the run table (include mesg hdr size "     (* because the return message with local run table is passed    "   (* directly to where the run table will reside. Note though, that " $   (* openr will then move the run table up to overside the message hdr. $    (**)          (* assume we will get all we ask for *)      !   request_len := max_local_run_table_size + to_bm_open_mesg_len;  !    avail_run_table_buf_len := request_len;     DBGBF ( index_run_tbl, request_len,  avail, error);     IF (error <> zero) THEN BEGIN        IF (avail < min_message_buffer) THEN  BEGIN             status := no_more_space_err;  
          GOTO 999;  
           END         ELSE BEGIN (* get what there is *)            request_len := avail;             DBGBF (index_run_tbl, request_len, avail, error);             IF (error <> zero) THEN BEGIN                status := db_corrupt_err;               GOTO 999;  	             END;  	           (* return the amount of space we got *)             avail_run_table_buf_len := request_len;             END;  (* end else *)        END;  (* end if *)         get_buffer_area := false;      999 :       
   IF status <> zero 
       THEN index_run_tbl := zero;       
END; (* get_buffer_area *) 
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(*  procedure DBOPEN                                                 *)  $ $(*                                                                   *)  $ $(*  purpose : This routine determines if                             *)  $ $(*            (a) there is a transaction in progress                 *)  $ $(*            (b) the open mode is valid                             *)  $ $(*            (c) the run table and needed message buffer            *)  $ $(*                will fit in the program space                      *)  $ $(*            (d) obtains the user run table                         *)  $ $(*                (via communication with DBMON)                     *)  $ $(*            (e) calculates item read/write access                  *)  $ $(*            (f) calculates dataset accessibility                   *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) level word.                                                *)  $ $(*    (3) mode. (1,3,5,8)                                            *)  $ $(*    (4) istat.                                                     *)  $ $(*                                                                   *)  $ $(*  returns : (1) index into the buffer pointer table which contains *)  $ $(*                the current run table (is the same as the local    *)  $ $(*                data base number)                                  *)  $ $(*            (4) status buffer                                      *)  $ $(*                - status (zero if successful)                      *)  $ $(*                - level word number                                *)  $ $(*                - indicator if highest level was obtained          *)  $ $(*                - data base read/write access                      *)  $ $(*                - logging status                                   *)  $ $(*                                                                   *)  $ $(*  NOTE :    This routine updates                                   *)  $ $(*            (1) DBBUF table                                        *)  $ $(*            (2) Run table                                          *)  $ $(*                - header information                               *)  $ $(*                - item and set table access indicators             *)  $ $(*                                                                   *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbopen   $ Alias 'DBOPN' $     (VAR ibase : dbopn_ibase_type;       VAR ilevl : level_word_type;      VAR op_mode : short_int;      VAR istat : return_buffer_type);      LABEL 777, 888, 999;  (* error exits *)       
$ Include '[PROG' $  
     VAR      level : level_word_type;      blank_fill : boolean;     dbbuf_table : ptr_dbbuf_table;      stats_buf   : statistics_buffer_ptr_type;     cur_mesg_area_size : short_int;     cur_run_table_index : short_int;       $   save_access_level : short_int;      (* User data base access level *) $    save_run_table_len : short_int;  &   save_max_rec_size : short_int;       (* max size of record in this db *)  &    db_access_indic : db_access_type;      %   run_table : ptr_local_run_table_hdr;    (* pointer to user run table *) % &   mesg_buf : ptr_to_bm_mesg_type;          (* pointer to message area   *)  & #   ret_mesg_buf : ptr_to_user_mesg_type;    (* open return message *)  # %   open_ret_mesg_len : short_int;   (* length of mesg returned by DBMON *) % %   needed_mesg_area_size : short_int;    (* msg size needed for this db *) % "   avail : short_int;                    (* buffer size available *) "     !   (* variables used in determining set and items accessibility *) !     !   ix : short_int;                        (* index into tables *)  ! &   dscb_table : ptr_local_dscb;           (* data set control block table *) & "   item_table : ptr_local_item_table;     (* data set item table *)  " %   ds_inf_table : ptr_local_ds_inf_table; (* data set information table *) % %   dscb_offset : short_int;         (* dscb offset from run table start *) % $   it_offset : short_int;           (* item table offset             *)  $ $   dsit_offset : short_int;         (* data set information table    *)  $ "   read_flag, write_flag : boolean;  (* true if read/write - able *) " %   item_ct, num_items : short_int;   (* item count and number of items *)  %    item_num : item_num_type;         (* item number *)     ds_num : short_int;               (* data set number *)  &   access_flag : boolean;            (* true if at least read accessible *)  &    num_datasets : short_int;      %   can_write : boolean;              (* true if open mode is write-able *) % #   dummy : Short_int;                (* Dummy parameter for LOGLU. *)  #    dummy_set : item_set_name_type;  #   avail_run_table_area_size : Short_int; (* memory for run table. *)  #        time_stamp    : date_and_time_type;     mode1         : short_int;      save_ibase1   : short_int;      save_error    : short_int;       	BEGIN (* dbopen *) 	        cur_run_table_index := zero;          (**)      (* Get the significant characters of the level word  
   (* and pad with blanks. 
    (**)          blank_fill := false;      FOR ix := one TO chars_in_level_word DO BEGIN  !      IF (ilevl[ix]=' ') OR (ilevl[ix]=';') OR (ilevl[ix]=chr(0))  !          THEN blank_fill := true;   
      IF blank_fill  
          THEN level[ix] := ' '           ELSE level[ix] := ilevl[ix];         END;         save_ibase1 := ibase.node_number;         (* Node of -1 means local node *)     IF ibase.node_number = -1  THEN ibase.node_number := 8224;       !   IF ibase.node_number <> 8224 THEN BEGIN (* two ascii blanks *)  !       remote_dbopen (ibase, level, op_mode, istat);         GOTO 999;         END;         IF get_database_pointers (ibase.node_number,                                dbbuf_table, mesg_buf, run_table,                               stats_buf,                                istat.opn.status)  !      THEN istat.opn.status := zero;  (* Ignore any error here. *) !        WITH dbbuf_table^ DO BEGIN         IF (open_count = zero) THEN BEGIN            process_info.process_id := user_session_number;               get_program_name (process_info.pname);                (**)            (* Create a 'random' number from the time of day            (* to be used as an identifier for this program.            (**)                get_timestamp (time_stamp);           WITH time_stamp DO   "            process_info.unique_num := second+(minute*8)+(hour*64);  "                  END; (* if *)            (* Allocate a class number locally for this program *)        IF (user_comm_id = zero)           THEN IF get_comm_id (user_comm_id, zero) THEN BEGIN              istat.opn.status := class_number_err;               GOTO 999;   
            END; (* if *)  
           END; (* with dbbuf *)          istat.opn.status := no_image_err;   (* assume no error *)         (* check open mode - 1,3,5,8 *)  	   CASE op_mode OF 	       read_write_shared_access_mode,        exclusive_access_mode : BEGIN            can_write := true;            END; (* modes 1, 3 *)            read_only_shared_access_mode,         read_shared_access_mode : BEGIN            can_write := false;           END;  (* modes 5, 8 *)             OTHERWISE BEGIN            istat.opn.status := invalid_mode_err;  	         GOTO 999; 	          END; (* otherwise *)         END; (* CASE *)          (**)      (* Get as much background as possible for the run table.      (* DBMON will return the an error if it does not fit.     (* If it does fit, we trim off any excess space that was   
   (* preallocated.  
    (**)          cur_mesg_area_size := dbbuf_table^.cur_mesg_len;          IF get_buffer_area (ibase, dbbuf_table,                         cur_run_table_index,   "                       avail_run_table_area_size, istat.opn.status)  " 
      THEN GOTO 999; 
     $   (* Get the run table and message area addresses.  These addresses *)  $ $   (* were set up in 'get_buffer_area'.                              *)  $     %   Get_run_table_and_mesg_buf (cur_run_table_index, run_table, mesg_buf);  %        (* The run table is the message buffer *)     rt_bm_set_ptr_addr (run_table, zero, mesg_buf);      !   (* Construct the open request message to be sent to DBMON    *) ! !   (* Mesg_hdr_construction fills in the header of all BM msgs. *) ! !   (* We are  passing mesg_hdr_construction the run table addr  *) ! !   (* even though there is no info present because this routine *) ! !   (* uses info in the run table for all other intrinsics.      *) ! !   (* We will fill in the data base id field ourselves here,    *) ! !   (* although it is part of the header.                        *) !        IF local_dormant_program (dbmon_program) THEN BEGIN        istat.opn.status := bm_comm_err;        GOTO 888;         END;         WITH mesg_buf^.open DO BEGIN       %      (* Copy the significant portion of the root file name to msg buf *)  %       ix := one;        dbname := ' '; (* blank fill the root name *)   
      WITH ibase DO  
       WHILE (ix <= chars_in_new_file_name) AND  #            (root_name[ix] <> ';') AND (root_name[ix] <> ' ') DO BEGIN #          dbname[ix] := root_name[ix];            ix := ix + one;  
         END; (* while *)  
     "      (* Parse and rebuild the root file name for DBMON to access *) "       build_root_name (dbname);       
     level_word := level;  
      mode := op_mode;        max_rt_size := avail_run_table_area_size;       user.local_db_num := cur_run_table_index;  
     END; (* WITH *) 
        IF send_receive_message (mesg_buf,                               dbbuf_table,                              run_table,                              to_bm_opn_code,                               to_bm_open_mesg_len,                              ret_mesg_buf,                               open_ret_mesg_len,                              db_open,                              istat.opn.status)   
      THEN GOTO 888; 
            (* Look at info returned from DBMON *)       (* (1) Move the run table to overwrite the message header. *)   '   (* (2) Save the access level word for item and set access determination *)  ' '   (* (3) Save info for storing into the return user status buffer later.  *)  ' '   (* (4) Save info for storing into the run table later(after all is well)*)  '        WITH ret_mesg_buf^.open DO BEGIN         save_access_level := access_level;        istat.opn.hi_access_indic := hi_acc_indicator;        save_run_table_len := run_table_len;        save_max_rec_size := max_rec_size;        db_access_indic := db_access;         istat.opn.sys_log_stat := reply.log_state;        move_run_table (local, run_table^, run_table_len);        END; (* WITH *)          (* Trim off excess run table buffer space *)   
   trim_run_table (  
 
     cur_run_table_index,  
      save_run_table_len,       istat.opn.status);      IF (istat.opn.status <> zero) THEN         GOTO 777;          (* Allocate the proper size message buffer *)         WITH dbbuf_table^ DO BEGIN         max_mesg_len[cur_run_table_index] := to_bm_get_mesg_len;            ix := to_bm_update_mesg_len + save_max_rec_size;        IF (ix > max_mesg_len[cur_run_table_index])            THEN max_mesg_len[cur_run_table_index] := ix;      %      (* Find msg size among all databases which will satisfy them all *)  %       needed_mesg_area_size := zero;        FOR ix := one to max_db DO           IF (max_mesg_len[ix] > needed_mesg_area_size) THEN               needed_mesg_area_size := max_mesg_len[ix];        END; (* with dbbuf *)           #   (* If the current is not sufficient, then allocate larger buffer *) #    IF cur_mesg_area_size < needed_mesg_area_size THEN BEGIN       
      (* return old one *) 
       IF (cur_mesg_area_size > zero)           THEN DBRBF (mesg_ptr_tbl_index, istat.opn.status);             IF istat.opn.status <> zero THEN BEGIN           istat.opn.status := db_corrupt_err;  	         GOTO 777; 	          END;             (* Get the new larger buffer *)         DBGBF(mesg_ptr_tbl_index, needed_mesg_area_size,              avail, istat.opn.status);       !      (* If we could not get a larger one, get the old one back *) !       IF istat.opn.status <> zero THEN BEGIN           IF (cur_mesg_area_size > zero)                THEN DBGBF (mesg_ptr_tbl_index, cur_mesg_area_size,                            avail, istat.opn.status)              ELSE istat.opn.status := zero;           IF istat.opn.status <> zero              THEN istat.opn.status := db_corrupt_err               ELSE istat.opn.status := no_more_space_err;   	         GOTO 777; 	          END;  (* IF *)              (* We have successfully allocated a new message buffer.*)           (* Update the current message area size variable.      *)          cur_mesg_area_size := needed_mesg_area_size;        dbbuf_table^.cur_mesg_len := cur_mesg_area_size;            END;  (* end IF need new buffer *)      #   (* Get the run table and message area addresses. These pointers *)  # #   (* need to be re-assigned since the allocation of a new buffer  *)  # #   (* may have compacted space and moved the buffers around.       *)  #     %   Get_run_table_and_mesg_buf (cur_run_table_index, run_table, mesg_buf);  %        run_table^.indicators.levelnum := save_access_level;              (* Get information from local run table header *)     num_items := run_table^.itm_count;      it_offset := run_table^.itm_off;      RT_IT_set_ptr_addr (run_table, it_offset, item_table);       !   (* Determine the access the user has to each item by setting *) ! !   (* the write and read bits in the item's entry in the item   *) ! !   (* table.                                                    *) !        access_flag := false;     FOR item_num := one to num_items DO BEGIN  %     WITH item_table^[item_num] DO BEGIN  (* with each item table entry *) %             IF (can_write) THEN              IF (save_access_level >= rw_access.write_level)                THEN rw_access.write_access := TRUE;              IF (save_access_level >= rw_access.read_level)             THEN BEGIN                 rw_access.read_access := TRUE;                access_flag := true;                END; (* THEN *)           END; (* with *)   
     END; (* FOR *)  
        (* determine the user access to each data set *)          num_datasets := run_table^.set_count;     dscb_offset := run_table^.set_off;      rt_dscb_set_ptr_addr (run_table, dscb_offset, dscb_table);          FOR ds_num := one to num_datasets DO BEGIN              (* if the access level is greater than or equal to the  *)          (* data set's high_write_lev, then the set is writeable.*)          (* If greater or equal to low_read_lev, it is readable. *)             WITH dscb_table^[ds_num] DO BEGIN            IF set_indics.high_write_lev <= save_access_level              THEN set_indics.write_allowed := true               ELSE set_indics.write_allowed := false;                IF set_indics.low_read_lev <= save_access_level              THEN set_indics.read_allowed := true              ELSE set_indics.read_allowed := false;               END; (* with *)            END; (* for loop - for each data set *)          (* All is well! *)      istat.opn.status := no_image_err;         (**)      (* Use the info returned from DBMON to      (*     store info into the run table      (**)          (* Store info in the local run table. *)   #   (* And return in the user's ibase parameter, the local db number *) #        WITH run_table^ DO BEGIN   %      db_node := save_ibase1;  (* First save original user node number *)  %           (* Put local db number in first word of ibase *)        ibase.node_number := cur_run_table_index;       #      db_num := cur_run_table_index;      (* local data base number *) #       indicators.remote := false;             (**)        (* DBMON saved this away into the local run table:        (*    sys_dbnum         (*    log status        (*    allowed database open mode        (**)            IF NOT access_flag THEN BEGIN             istat.opn.status := no_access_with_this_level_err;  
          GOTO 777;  
           END;  (* end then *)                WITH dbbuf_table^ DO BEGIN           (* update dbbuf open count *)  "         open_count := succ (open_count);  (*increment open count *) "          END; (* WITH *)      !      indicators.posting := true;   (* initially posting is ON *)  !           END; (* with run table *)          (* Store return info for the user's status buffer *)      (* Most of the info comes from DBMON's return message *)   
   WITH istat.opn DO BEGIN 
       access_level := save_access_level;        length_run_table := save_run_table_len;         db_access := db_access_indic;         END; (* with return_status *)          GOTO 999;  (* skip over most error processing *)        777: (* for errors that occur after DBMON opens successfully *)           save_error := istat.opn.status;     mode1 := one;     dbclose (ibase.node_number, dummy_set, mode1, istat);     istat.opn.status := save_error;     cur_run_table_index := zero;       888:  (* for errors prior to a successful open by DBMON *)             (* Deallocate the run table if allocated before error. *)              IF (cur_run_table_index > zero)            THEN DBRBF (cur_run_table_index, dummy);           999:  (* for errors prior to allocating a run table *)            IF (istat.opn.status <> zero) THEN BEGIN               ibase.node_number := save_ibase1;      $         (* Release the class number if allocated but no DB is open. *)  $              WITH dbbuf_table^ DO            IF (open_count = zero)               THEN IF (user_comm_id <> zero)                 THEN IF release_comm_id (user_comm_id) THEN;                END; (* error cleanup *)       	END; (* dbopen *)  	 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBPUT                                                   *)  $ $(*                                                                   *)  $ $(* purpose : This procedure is responsible for the following         *)  $ $(*           portions of the database PUT intrinsic :                *)  $ $(*              (1) syntax checking                                  *)  $ $(*              (2) formatting of the information which DBMON        *)  $ $(*                  requires in order to execute the PUT.            *)  $ $(*              (3) communication with DBMON                         *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) set id.                                                    *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) item list.                                                 *)  $ $(*    (6) value list.                                                *)  $ $(*                                                                   *)  $ $(* returns: (4) status buffer                                        *)  $ $(*             -status (0: successful)                               *)  $ $(*             -length of the item value buffer                      *)  $ $(*             -the new record number                                *)  $ $(*             -the number of records on the chain                   *)  $ $(*             -the chain predecessor record number                  *)  $ $(*             -the chain successor record number                    *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbput  $ Alias 'DBPUT' $     (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR item_value_buffer : item_value_buffer_type);      LABEL 888,999;      CONST      two_blanks = '  ';       VAR      dbbuf_table : ptr_dbbuf_table;      run_table : ptr_local_run_table_hdr;      mesg_buf  : ptr_to_bm_mesg_type;      stats_buf : statistics_buffer_ptr_type;     start_time: long_int;          data_buffer_word_len : short_int;   (* length of put data *)    !   num_keys : short_int;     (* # keys required by the data set *) ! 
   record_len : short_int; 
    item_value_buffer_index : short_int;         (* >zero if item is in tempx table;  -1 if not there *)       dscb_entry : ptr_dscb_entry;     (* data set control block *)      set_number : short_int;             (* data set number *)     num_items_in_set : short_int;     item_num : short_int;     data_set_info_table : ptr_local_ds_inf_table;     data_set_info_table_offset : short_int;     path_table : ptr_path_table;      (* data set path table *)  &   num_fields : short_int;           (* number of fields in ds_inf table *)  &    path_table_offset : short_int;      set_ident : item_set_name_type;     reply_mesg_buf : ptr_to_user_mesg_type;     return_length : short_int;      ix,it_ix : short_int;               (* array index *)     log_status : logging_states;      dataset_array_ptr : Ptr_local_dscb;     iset : Short_int;   (* set index *)     item_table_ptr : ptr_local_item_table;      rec_filled_len : short_int;     temp : int_or_char;      	BEGIN (* dbput *)  	        IF get_database_pointers (ibase[one],                               dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.put.status)  
      THEN GOTO 999; 
            IF (run_table^.indicators.remote) THEN BEGIN         remote_dbput (ibase, set_id, mode, istat, item_list,                      item_value_buffer);         GOTO 888;         END;         IF (stats_buf <> nil)        THEN start_time := get_start_time;          (* check the open and put modes *)      IF check_modes (mode, run_table, istat.put.status)         THEN GOTO 999;           (* check the validity of the SET parameter *)       IF set_getter (set_id, run_table, set_number,                      dscb_entry, istat.put.status)         THEN GOTO 999;           WITH dscb_entry^ DO BEGIN          IF NOT(set_indics.write_allowed) THEN BEGIN            istat.put.status := set_not_writable_err;   
          GOTO 999;  
           END;         IF (set_indics.set_type = auto_master) THEN  BEGIN             istat.put.status := auto_master_err;  
          GOTO 999;  
           END;         num_items_in_set := set_indics.num_items;         record_len := data_len;         END;          (* create a pointer to the item table *)   "   rt_it_set_ptr_addr(run_table, run_table^.itm_off,item_table_ptr); "             (* Syntax checking is complete.  Now process the item list.*)       (* Make sure (1) all items that are in the list, exist     *)       (*           (2) they are all writeable                    *)       (*           (3) all key and sort items are included       *)       (*                                                         *)       (* As we process the item list, build a record of item     *)       (* values, blanking out the fields which the user has not  *)       (* provided an item value.                                 *)          temp.int_val := item_list[1];    { Andy Jian 2-23-88 }       $   IF ((run_table^.indicators.levelnum = 15) and (temp.char_val = '@'))  $ #   OR ((run_table^.indicators.levelnum = 15) and (temp.char_val = '*') # $       and (dbbuf_table^.current_item_list[1].flags.item_num = 0)) then  $        BEGIN     (* indicate we want ENTIRE *)           WITH dbbuf_table^ DO   	            BEGIN  	             current_item_list[one].start_word :=  zero;   '            current_item_list[one].flags.item_num := one;  (* any non-zero *)  ' $            current_item_list[one].word_length := dscb_entry^.data_len;  $ $            current_item_list[2].flags.write_flag := false; {andy jian}  $             current_item_list[2].flags.key_flag := false;               current_item_list[2].flags.sort_flag := false;              current_item_list[2].flags.item_num := zero;  #                                           (* indicates end of info *) # 
            END (* with *) 
        END (* end if @ - all items *)      ELSE         BEGIN                process_item_list (item_list, dscb_entry,                              num_keys,istat.put.status);            IF (istat.put.status <> zero) THEN GOTO 999;          (* create a pointer to the data set info table *)     data_set_info_table_offset := dscb_entry^.info_off;      rt_dsit_set_ptr_addr (run_table, data_set_info_table_offset,          data_set_info_table);              (* Is the number of keys correct and are they all there? *)     CASE dscb_entry^.set_indics.set_type OF        man_master : BEGIN           IF (num_keys <> one)               THEN istat.put.status := item_not_key_err               ELSE BEGIN  %               find_item_in_user_buffer (dscb_entry^.set_indics.last_key,  %                         item_value_buffer_index);                  IF (item_value_buffer_index < zero) THEN                     istat.put.status := item_not_key_err;   
               END;  
          END;  (* end case master *)      
      detail : BEGIN 
          IF (num_keys <> dscb_entry^.set_indics.num_paths)              THEN istat.put.status := item_not_key_err               ELSE BEGIN      #               (* get the path table whose address is a function of *) # #               (* the length of the data set info table which in    *) # #               (* turn is a function of the number of items.        *) #                    num_fields := dscb_entry^.set_indics.num_items;                 path_table_offset := (num_fields + one) DIV 2;                      dsit_pt_set_ptr_addr (data_set_info_table,                                        path_table_offset,                                        path_table);                      FOR ix := one to num_keys DO                  WITH path_table^[ix] DO BEGIN                    find_item_in_user_buffer (detl_key,                        item_value_buffer_index);                    IF (item_value_buffer_index < zero)                         THEN istat.put.status :=  item_not_key_err                         ELSE IF (sort_itm <> zero) THEN BEGIN                          find_item_in_user_buffer (sort_itm,                                    item_value_buffer_index);                          IF (item_value_buffer_index < zero)   #                           THEN istat.put.status := item_not_key_err;  # "                        END;  (* end else if sort_itm is expected *) "                   END;   (* end for - with for path table *)                 END;   (* end else number of keys is correct *)           END;    (* end case detail *)            OTHERWISE istat.put.status := db_corrupt_err;             END;   (* end case *)          IF (istat.put.status <> zero) THEN GOTO 999;       
   rec_filled_len := zero; 
    WITH dbbuf_table^, mesg_buf^.put DO BEGIN            (* intitialize entire record with blanks *)         fill_with_blanks ( record_len, data_rec, two_blanks);             (* initialize integer/real items with zeroes *)         FOR ix := 1 to num_items_in_set DO BEGIN           item_num := data_set_info_table^[ix];           WITH item_table_ptr^[item_num] DO BEGIN              IF rw_access.item_type <> type_char THEN                 FOR it_ix := zero TO item_len -one DO                    (* data rec starts at zero *)                     data_rec[rec_filled_len+it_ix] := zero;               rec_filled_len := rec_filled_len + item_len;              END;  (* with *)               END;  (* for *)     END; { with }     END; { else }         WITH dbbuf_table^, mesg_buf^.put DO BEGIN  "      move_item_values_to_data_record (data_rec, item_value_buffer,  "          data_buffer_word_len);            xact_num := run_table^.transaction_id;            post_ind := run_table^.indicators.posting;            set_num :=  set_number;           data_len := record_len;        END;   (* end with *)          IF send_receive_message (mesg_buf,                               dbbuf_table,                              run_table,                              to_bm_put_code,                               to_bm_put_mesg_len + record_len,                              reply_mesg_buf,                               return_length,                              db_put,                               istat.put.status)   
      THEN GOTO 999; 
     %      IF ((run_table^.indicators.levelnum = 15) and (temp.char_val = '@')) % !      THEN  dbbuf_table^.current_item_list[1].flags.item_num := 0; ! $      { to tell get/update/put that there is no real current item list } $        (* Look at the return message from DBMON *)     (*  and store the return status info.    *)         IF (istat.put.status = zero) THEN     WITH reply_mesg_buf^.put, istat.put DO BEGIN         buffer_word_len := data_buffer_word_len;        new_rec_num := record_num;        num_rec_on_chain :=  chain_len;         pred_rec_num :=  prev_record;         succ_rec_num := next_record;  
      END;  (* end with *) 
     999: (* abnormal termination exit *)      $   { 4-1-87 AHJ  enhance error 107 to put the bad set # in the 2nd word  $      or istat }          IF ISTAT.PUT.STATUS = NO_MASTER_FOR_KEY_ERR {107} THEN         ISTAT.PUT.BUFFER_WORD_LEN := REPLY_MESG_BUF^.PUT.BADSET;         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_put] DO BEGIN           calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;           END;       888: (* skip stats if remote *)       END; (* dbput *)  $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBUNDO                                                  *)  $ $(*                                                                   *)  $ $(* purpose: This routine performs the following data base transaction*)  $ $(*          undo functions.                                          *)  $ $(*                                                                   *)  $ $(*          (1) Performs syntax checking.                            *)  $ $(*          (2) Communicates with DBMON, requesting that a           *)  $ $(*              the current transaction be undone.                   *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) user text.                                                 *)  $ $(*    (3) mode (must be 1).                                          *)  $ $(*    (4) istat.                                                     *)  $ $(*    (5) text length.                                               *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbundo   $ Alias 'DBUND' $     (VAR ibase : ibase_type;       VAR user_text : text_str;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR text_len  : short_int);       LABEL 888,999;      CONST      not_dbbegin = false;       VAR      base        : short_int;      temp_ibase  : ibase_type;         dbbuf_table : ptr_dbbuf_table;      run_table   : ptr_local_run_table_hdr;      to_mesg_buf : ptr_to_bm_mesg_type;      stats_buf   : statistics_buffer_ptr_type;  
   start_time  : long_int; 
        from_mesg_buf: ptr_to_user_mesg_type;     from_mesg_len: short_int;  	   i : short_int;  	         	BEGIN (* dbundo *) 	        stats_buf := nil;  (* in case of mode error *)          temp_ibase := ibase;          CASE mode OF         1 : base := ibase[one];             3 : IF ibase[one] <= max_db               THEN base := ibase[2]   %            ELSE IF make_ibase_list (ibase, temp_ibase, istat.und.status)  %                THEN GOTO 999                 ELSE base := temp_ibase[2];        OTHERWISE BEGIN            istat.und.status := invalid_mode_err;  	         GOTO 999; 	          END;         END; (* case *)          IF multi_db_pointers (base,                           dbbuf_table,                            to_mesg_buf,                            run_table,                            stats_buf,                            istat.und.status)  
      THEN GOTO 999; 
        IF (run_table^.indicators.remote) THEN BEGIN         remote_dbundo (ibase, user_text, mode, istat, text_len);        GOTO 888;         END;         IF (stats_buf <> nil)        THEN start_time := get_start_time;      	   IF (mode = one) 	 !      THEN transaction_base_formatter (run_table^.transaction_id,  !                                        dbbuf_table,                                          temp_ibase);          IF transaction_checker (not_dbbegin,                              dbbuf_table,                              temp_ibase,                             istat.und.status)  
      THEN GOTO 999; 
        (**)      (* Process text string to word-align and blank-pad.     (**)          WITH to_mesg_buf^.undo DO BEGIN        IF process_text_str (user_text,                              text_len,                             log_comment,                              log_comment_len,                              istat.und.status)           THEN GOTO 999;             xact_num := run_table^.transaction_id;        END;             IF send_receive_message (to_mesg_buf,                              dbbuf_table,                              run_table,                              to_bm_und_code,                               to_bm_undo_mesg_len,                              from_mesg_buf,                              from_mesg_len,                              db_undo,                              istat.und.status)   
      THEN GOTO 999; 
        WITH from_mesg_buf^.undo, istat.und DO BEGIN         (* return information to the user *)        logging_state := reply.log_state;         xaction_num := run_table^.transaction_id;         END;  (* end with return buffer *)         (* Zero out all trans ID's belonging to this transaction *)         WITH dbbuf_table^ DO      FOR i := one TO temp_ibase[one] DO      WITH db_run_table[temp_ibase[i+one]]^ DO BEGIN         transaction_id := zero;         multi_db_count := zero;         END;      999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_undo] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;           END;       888: (* skip stats if remote *)       	END; (* dbundo *)  	 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* procedure DBUNLOCK                                                *)  $ $(*                                                                   *)  $ $(* purpose: To remove all locks on a database.                       *)  $ $(*                                                                   *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) data set list for mode 2.                                  *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat.                                                     *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbunlock   $ Alias 'DBUNL' $     (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type);      LABEL 888,999;      VAR      run_table    : ptr_local_run_table_hdr;     dbbuf_table  : ptr_dbbuf_table;     req_mesg_buf : ptr_to_bm_mesg_type;     stats_buf    : statistics_buffer_ptr_type;      start_time   : long_int;       #   ret_mesg_buf:                   (* return message buffer pointer *) #       ptr_to_user_mesg_type;     ret_mesg_len: short_int;        (* return message length *)         access, set_num, dscbptr : short_int;      
BEGIN (* dbunlock *) 
        IF get_database_pointers (ibase[one],                               dbbuf_table,                                req_mesg_buf,                               run_table,                                stats_buf,                                istat.unl.status)  
      THEN GOTO 999; 
        IF (run_table^.indicators.remote) THEN BEGIN         remote_dbunlock (ibase, set_id, mode, istat);         GOTO 888;         END;         IF (stats_buf <> nil)        THEN start_time := get_start_time;         (* Check for mode 1 or 2 *)     IF ((mode <> one) AND (mode <> 2)) THEN BEGIN        istat.unl.status := invalid_mode_err;         GOTO 999;         END;         (* Check for no transaction *)      IF (run_table^.transaction_id <> zero) THEN BEGIN        istat.unl.status := transaction_violation_err;        GOTO 999;         END;         (* preset return status for good return *)      istat.unl.status := no_image_err;         (* ignore the unlock request for modes 3 and 8 *)     IF (run_table^.open_mode = 8) OR (run_table^.open_mode = 3)  
      THEN GOTO 999; 
        (* For mode 2, determine the correct data set number *)     IF (mode = 2) THEN BEGIN         dbfds (set_id, set_num, access, dscbptr);         IF set_num = 0 THEN BEGIN            istat.unl.status := illegal_set_ref_err;   	         GOTO 999; 	          END;             WITH req_mesg_buf^.remove_locks DO BEGIN           set_count := 1;           set_nums[1] := set_num;           END;         END; (* then mode 2 *)         req_mesg_buf^.remove_locks.mode := mode;          IF send_receive_message (req_mesg_buf,                               dbbuf_table,                              run_table,                              to_bm_remove_locks_code,                              to_bm_remove_locks_msg_len,                               ret_mesg_buf,                               ret_mesg_len,                               db_unlock,                              istat.unl.status)   
      THEN GOTO 999; 
     999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_unlock] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;           END;       888: (* skip stats if remote *)       
END; (* dbunlock *)  
 $ Page $  $(*********************************************************************)  $ $(*                                                                   *)  $ $(* PROCEDURE DBUPDATE                                                *)  $ $(*                                                                   *)  $ $(* Purpose : This procedure performs the following functions of      *)  $ $(*           the DBUPD intrinsic:                                    *)  $ $(*           (1) Syntax checking                                     *)  $ $(*           (2) DBMON communication (dbmon performs the actual      *)  $ $(*                                    record update)                 *)  $ $(* Parameters:                                                       *)  $ $(*    (1) ibase.                                                     *)  $ $(*    (2) set id.                                                    *)  $ $(*    (3) mode. (must be 1)                                          *)  $ $(*    (4) istat array.                                               *)  $ $(*    (5) item list.                                                 *)  $ $(*    (6) value list.                                                *)  $ $(*                                                                   *)  $ $(* Returns:  (4) status buffer                                       *)  $ $(*               - status (0:successful)                             *)  $ $(*               - length of the buffer of item values               *)  $ $(*                                                                   *)  $ $(*********************************************************************)  $     PROCEDURE dbupdate   $ Alias 'DBUPD' $     (VAR ibase : ibase_type;       VAR set_id: item_set_name_type;   
    VAR mode  : short_int; 
     VAR istat : return_buffer_type;       VAR item_list : item_list_type;       VAR user_buffer : data_record_type);      LABEL 888,999;      VAR      run_table : ptr_local_run_table_hdr;      mesg_buf  : ptr_to_bm_mesg_type;      dbbuf_table : ptr_dbbuf_table;      stats_buf : statistics_buffer_ptr_type;     start_time: long_int;         reply_mesg_buf : ptr_to_user_mesg_type;  
   set_number : short_int; 
 "   dscb_entry : ptr_dscb_entry;   (* data set control block entry *) " #   num_keys : short_int;         (* # keys required by the data set *) # $   user_buffer_len : short_int;  (* word length of concatenated item *)  $ $                                 (*   values given us by the user.   *)  $ #   return_length : short_int;    (* len of info returned from dbmon *) #    n_items : short_int;          (* # items to be updated *)  	   ix : short_int; 	    temp  :  int_or_char;      
BEGIN (* dbupdate *) 
        IF get_database_pointers (ibase[one],                               dbbuf_table,                                mesg_buf,                               run_table,                                stats_buf,                                istat.upd.status)  
      THEN GOTO 999; 
        IF (run_table^.indicators.remote) THEN BEGIN         remote_dbupdate (ibase, set_id, mode, istat,                         item_list, user_buffer);         GOTO 888;         END;         IF (stats_buf <> nil)        THEN start_time := get_start_time;      %   (* Make sure the data base is open in the proper mode for updating. *)  % %   (* This means that the open mode must be either 1 or 3.             *)  % %   (* Also make sure the mode parameter is a correct.                  *)  %        IF check_modes (mode, run_table, istat.upd.status)   
      THEN GOTO 999; 
     $   (* Validify the SET parameter.  If valid, we are returned the data *) $ $   (* set number and data set control block table entry offset,       *) $ $   (* relative to the start of the run table.                         *) $        IF set_getter (set_id, run_table, set_number,                    dscb_entry, istat.upd.status)   
      THEN GOTO 999; 
        (* The set must NOT be an automatic master *)      IF (dscb_entry^.set_indics.set_type = auto_master) THEN BEGIN         istat.upd.status := auto_master_err;        GOTO 999;         END;     (* end auto master error *)         (* There must be a current record number for the set *)     IF (dscb_entry^.last_rec <= zero) THEN BEGIN         IF (dscb_entry^.last_rec = zero)           THEN istat.upd.status := no_set_current_record_err            ELSE istat.upd.status := DB_corrupt_err;         GOTO 999;         END;  (* end no current record *)          (* Process the item list given to us by the user. *)          temp.int_val := item_list[1];         WITH mesg_buf^.update DO BEGIN             IF (temp.char_val = '*') and  "         (dbbuf_table^.current_item_list[1].flags.item_num = 0) then " $         BEGIN { if a dbget cleared curr.item.list then force rebuild }  $             temp.char_val := '@';   $            process_item (temp, dscb_entry,num_keys, istat.upd.status);  $          END        ELSE              process_item_list (item_list, dscb_entry,                                  num_keys, istat.upd.status);             IF (istat.upd.status <> zero) THEN GOTO 999;        ix := one;        user_buffer_len := zero;            tempx_table := dbbuf_table^.current_item_list;            WHILE (tempx_table[ix].flags.item_num <> zero) DO BEGIN   %         user_buffer_len := user_buffer_len + tempx_table[ix].word_length; %          ix := ix + one;           END;   (* end while traversing tempx table *)  
      n_items := ix - one; 
     '      (* Table size is the max length even tho we may only use part of it  *)  ' '      (* This is because we must pass DBMON the entire table, since we have*)  ' '      (* two variable length fields within the message record structure.   *)  '       table_len := tempx_table_total_word_length;   
      END;  (* end with *) 
     %   (* Transfer the item values from the user buffer to the data record *)  % %   (* portion of the message to dbmon.  We need to know the word       *)  % %   (* length of the concatenated item values in the user buffer (this  *)  % %   (* was calculated while processing the item list above).            *)  %        move_data_values (user_buffer, mesg_buf^.update.data_rec,        user_buffer_len);          WITH mesg_buf^.update DO BEGIN         xact_num := run_table^.transaction_id;        post_ind := run_table^.indicators.posting;        set_num := set_number;        current_rec_num := dscb_entry^.last_rec;        num_items := n_items;   !      (* tempx_table_len and tempx_table values were set above *)  !       data_len := user_buffer_len;        END;         IF send_receive_message (mesg_buf,                               dbbuf_table,                              run_table,                              to_bm_upd_code,   "                            to_bm_update_mesg_len + user_buffer_len, "                             reply_mesg_buf,                               return_length,                              db_update,                              istat.upd.status)   
      THEN GOTO 999; 
        (* Form the return info to the user *)      istat.upd.return_data_len := user_buffer_len;          999: (* abnormal termination exit *)         IF (stats_buf <> nil)        THEN WITH stats_buf^.call_stats[db_update] DO BEGIN            calls_made   := calls_made + one;  #         elapsed_time := elapsed_time + get_elapsed_time(start_time);  #          cpu_time := elapsed_time - io_time - wait_time;           END;       888: (* skip stats if remote *)       
END; (* DBUPDATE *)  
 . (* The end *)  