 $PASCAL ',7 92081-1X282 REV.2540' $   $ Title 'IMAGE Parse Run String' $  $ Heap 0 $  	$ Recursive off $  	 $ Subprogram  $   $ Range off $       #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) # "(*****************************************************************)  " "(*                                                               *)  " "(* PURPOSE : A collection of parsing routines for IMAGE.         *)  " "(*                                                               *)  " "(* PGMR:        <edb>,<stc>                                      *)  " "(*                                                               *)  " "(* SOURCE:  92081-18282                                          *)  " "(*                                                               *)  " (* Date of last modification: <851115.1143>   "(*                                                               *)  " "(*****************************************************************)  "         PROGRAM PARSR;          $ List OFF, Include '[IMAGE', List ON $       CONST      chars_in_parm_str = 128;      max_entries_in_parm_buffer = 10;           TYPE     parm_str = packed array [1..chars_in_parm_str] of CHAR;         parm_entry =         RECORD           typ : (non, int, asc);   
         len : short_int;  
 
         ascii : parm_str; 
 
         value : long_int; 
       END;         parm_buffer =        RECORD           number_of_parms : short_int;   
         parameter : 
              array [1..max_entries_in_parm_buffer] of parm_entry;         END;          PROCEDURE ascii_to_long_int  $ alias 'CATDI' $  
   ( VAR ascii: parm_str;  
          start : short_int;   
         len : short_int;  
 
     VAR value : long_int; 
 
     VAR err : short_int); 
    EXTERNAL;      $ Page $  #(********************************************************************) # #(* Procedure parse_run_string                                       *) # #(*                                                                  *) # #(* Purpose : This procedure parses the run string, placing the      *) # #(* individual parameters (which are separated by commas or spaces)  *) # #(* into the specified parameter buffer.                             *) # #(*                                                                  *) # #(* Input :                                                          *) # #(*     (1) Run string                                               *) # #(*     (2) Run string length                                        *) # #(*                                                                  *) # #(* Returns :                                                        *) # #(*     (3) Parameter buffer, with each parameter in a buffer entry. *) # #(*     (4) Maimum number of parameters to parse                     *) # #(*     (5) Return status (0 if successful)                          *) # #(*                                                                  *) # #(********************************************************************) #     	$ Heapparms off $  	     PROCEDURE parse_run_string   $ Alias 'IMG.Parser' $      ( VAR command_line: long_str ;            command_line_len: short_int;        VAR parameter_buffer: parm_buffer;            entries_in_parm_buffer : short_int;       VAR return_status : short_int);      LABEL   !   999;                            (* abnormal termination exit *) !     CONST      empty_long_str = long_str [chars_in_long_str OF ' '];          VAR       parm: 0..max_entries_in_parm_buffer; (* parameter counter *)    $   c_ptr: 0..chars_in_long_str;    (* command line character pointer *)  $ %   p_ptr: 0..chars_in_long_str;    (* parameter entry character pointer *) % $   c_chr: char;                    (* current command line character *)  $     %   end_of_parm: boolean;           (* end of parameter indication flag *)  %     skip_blanks: boolean;           (* blank skipping allowed *)        BEGIN (* parse_run_string *)         (* first strip blanks *)   "   p_ptr := 0;                     (* start with first character *)  "    skip_blanks := true;            (* skip starting blanks *)          FOR c_ptr := 1 TO command_line_len DO BEGIN  %      c_chr := command_line[c_ptr]; (* get character from command line *)  % 
      IF c_chr = ',' 
 !         THEN BEGIN                (* convert comma into blank *)  ! 
            c_chr := ' ';  
             skip_blanks := false;               END  (* THEN *)         ELSE           IF c_chr = ' '               (* skip over blanks *)              THEN skip_blanks := true              ELSE skip_blanks := false;            IF (NOT skip_blanks) OR (c_chr <> ' ')           THEN BEGIN                (* keep character *)               p_ptr := succ (p_ptr);              command_line[p_ptr] := c_chr;               END; (* THEN *)   
      END; (* FOR *) 
        (* set new command line length *)     command_line_len := p_ptr;          (* clear parameter buffer *)      FOR parm := 1 TO entries_in_parm_buffer DO         parameter_buffer.parameter[parm].typ := non;         (* set parameter pointer and end of parameter flag *)  "   parm := 0;                      (* start with first parameter *)  "    end_of_parm := true;            (* start with parm *)         (* fill ascii parameter entries *)      FOR c_ptr := 1 TO command_line_len DO BEGIN  %      c_chr := command_line[c_ptr]; (* get character from command line *)  %     "      IF end_of_parm               (* check for end of parameter *)  " !         THEN BEGIN                (* set up for next parameter *) ! #            IF parm = entries_in_parm_buffer (* check for overflow *)  #                THEN BEGIN          (* generate error *)                     return_status := too_many_parameters_err;   $                  GOTO 999;        (* take abnormal termination exit *)  $                   END; (* THEN *)       "            parm := succ (parm);   (* increment parameter pointer *) " %            end_of_parm := false;  (* start with beginning of parameter *) % "            p_ptr := 0;            (* start with first character *)  " #            parameter_buffer.parameter[parm].ascii := empty_long_str;  #             END; (* THEN *)       
      IF c_chr = ' ' 
 !         THEN BEGIN                (* process end of parameter *)  !             end_of_parm := true;              parameter_buffer.parameter[parm].len := p_ptr;  
            END (* THEN *) 
              ELSE BEGIN                (* process character *)              (* check for overflow *)              IF p_ptr = chars_in_long_str                 THEN BEGIN          (* generate error *)                     return_status := parameter_too_long_err;  $                  GOTO 999;        (* take abnormal termination exit *)  $                   END; (* THEN *)                   (* bump pointer and add character *)              p_ptr := succ (p_ptr);  "            parameter_buffer.parameter[parm].ascii[p_ptr] := c_chr;  "                 END; (* ELSE *)       
      END; (* FOR *) 
        (* set last parameter length and number of parameters *)      IF parm > 0        THEN parameter_buffer.parameter[parm].len := p_ptr;      parameter_buffer.number_of_parms := parm;         (* determine parameter type and numeric value *)      FOR parm := 1 TO parameter_buffer.number_of_parms DO BEGIN         WITH parameter_buffer.parameter[parm] DO BEGIN            IF len = 0                (* check parameter length *)                THEN typ := non        (* parameter is none *)  "            ELSE BEGIN             (* check for numeric parameter *) "                ascii_to_long_int  $                  (ascii, 1, chars_in_short_str, value, return_status);  $                IF return_status = 0                     THEN typ := int                     ELSE typ := asc;                 END; (* ELSE *)               END; (* WITH *)      
      END; (* FOR *) 
           return_status := 0;   (* normal exit *)       999: (* abnormal termination exit *)      END; (* parse_run_string *)   .  