$PASCAL ',7 92081-1X502 REV.2440' $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18502                                        *)   (* RELOC:   92081-16502                                        *)   (*                                                             *)   (* PGMR:        <MRL>                                          *)   (*                                                             *)   (* Date last modified: <840912.1410>  (*                                                             *)   (***************************************************************)       
$ Include '[LBOPT' $ 
     PROGRAM display_arbitrary_text;   #(*******************************************************************)  # #(*                Global include files                             *)  # #(*******************************************************************)  #     $ List OFF, Include '[IMAGE', List ON $       #(*******************************************************************)  # #(*                External Routine Declarations                    *)  # #(*******************************************************************)  #     $ List OFF, Include '[XDFMP', List ON $   $ List OFF, Include '[XDSMR', List ON $       $ Page $  #(*******************************************************************)  # #(*                Get_Printable_chars                              *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To translate an arbitrary byte (character) value into a      *)  # #(*    printable ASCII character.   Unprintable values are          *)  # #(*    substituted with blanks.                                     *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) Word containing 2 characters.                   *)  # #(*    (out)    (2) High-byte printable character.                  *)  # #(*    (out)    (3) Low-byte printable character.                   *)  # #(*                                                                 *)  # #(* No errors possible.                                             *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE get_printable_chars  $ Alias 'LOG.PrintChars' $   $ Heapparms ON $     (VAR word_value : Short_int;   	$ Heapparms OFF $  	 
    VAR char1      : Char; 
     VAR char2      : Char);           CONST      (* Printable range of ASCII *)   	   low_ascii = 32; 	 
   high_ascii= 126;  
    (* Printable range of KATAKANA *)     low_katakana = 161;     high_katakana= 223;              TYPE  
   Char_pair_type =  
       RECORD  
         CASE short_int OF 
             1: (chars : PACKED ARRAY [1..2] OF CHAR);               2: (word  : short_int);         END;          VAR      char_pair : char_pair_type;  
   char_val  : short_int;  
     BEGIN  (* get_printable_chars *)         (**)      (* The ASCII printable characters are from 32 through 126.      (* KataKana lies in the range of 161-223.     (* Let's hope other character sets do not use other ranges.     (**)              char_pair.word := word_value;         char_val := ord(char_pair.chars[1]);          (* For the high order byte do...*)      (* Substitute a non-printable character with a blank *)         IF (char_val < low_ascii) OR          ((char_val > high_ascii) AND (char_val < low_katakana)) OR         (char_val > high_katakana)        THEN char1 := ' '         ELSE char1 := chr(char_val);             char_val := ord (char_pair.chars[2]);         (* For the low order byte do...*)     (* Substitute a non-printable character with a blank *)         IF (char_val < low_ascii) OR          ((char_val > high_ascii) AND (char_val < low_katakana)) OR         (char_val > high_katakana)        THEN char2 := ' '         ELSE char2 := chr(char_val);      END; (* get_printable_chars *)  $ Page $  #(*******************************************************************)  # #(*                Display_text                                     *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To display in meaningful format an arbitrary collection of   *)  # #(*    binary and/or ascii data to an output file or device.        *)  # #(*    This is presently used by DBRBR and DBRFR.                   *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) First word of text buffer.                      *)  # #(*    (in)     (2) Number of words to be printed.                  *)  # #(*    (in/out) (3) Output file descriptor.                         *)  # #(*    (out)    (4) IMAGE error if an error occurs.                 *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    Boolean 'True' if an error occurs, 'False' otherwise.        *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION display_text   $ Alias 'LOG.DisplayText' $   $ Heapparms ON $     (VAR text_buffer : data_record_type;       VAR text_len    : short_int;  	$ Heapparms OFF $  	     VAR output_file : file_descriptor;      VAR error_code  : short_int) : Boolean;       LABEL 99;  (* error exit *)       CONST      start_ascii_column = 60;       VAR      display_string : long_str;      number_string  : short_str;     short_number   : short_int;     current_text_word : short_int;      loop              : short_int;          char_in_display   : short_int;      char1             : char;     char2             : char;     lines             : short_int;       
BEGIN  (* display_text *)  
        display_text := true;  (* assume an error will occur *)         (**)      (* Begin by printing a blank line.      (**)       
   display_string := ' ';  
        IF write_long_str (output_file,                        display_string,                         error_code)   
      THEN GOTO 99;  
            (**)      (* The display will be of the format:     (* '   octval octval octval...octval*ASCII CHARACTERS'       (* where there is a 3-space indentation, followed by 8 octal        (* values separated by spaces (56+3 columns so far), followed   "   (* by an asterisk (column 60) and the 16-character representation " !   (* of the 8 octal words.  Similar to FMGR LI command for binary !    (* data.       (* Note!!! Binary 'characters' which do not have a printable       (* result are replaced with a blank.  This will not affect      (* Katakana and other language character sets.      (**)          current_text_word := zero;   	   lines := zero;  	        WHILE (current_text_word < text_len) DO BEGIN        display_string := '  :';   (* Colon acts as a filler *)             FOR loop := one TO 8 DO BEGIN            IF (current_text_word < text_len)              THEN BEGIN                 short_number := text_buffer[current_text_word];                 octal_to_readable_short_str (short_number,                                               number_string);   	               END 	             ELSE number_string := '......';                append_str (display_string, number_string);               append_str (display_string, ':'); (* space filler *)                current_text_word := current_text_word + one;           END; (* for eight text words *)            (* Overwrite last colon with an asterisk. *)        display_string[start_ascii_column-one] := '*';            current_text_word := current_text_word - 8;             char_in_display := start_ascii_column;            FOR loop := one TO 8 DO BEGIN            IF (current_text_word >= text_len)               THEN BEGIN                 char1 := ' ';                 char2 := ' ';  	               END 	             ELSE  "               get_printable_chars (text_buffer[current_text_word],  "                                     char1,                                      char2);            display_string[char_in_display] := char1;           display_string[char_in_display+one] := char2;               char_in_display := char_in_display + 2;               current_text_word := current_text_word + one;               END; (* for all ascii equivalents *)             (* Overwrite space-filler colons with blanks. *)        FOR loop := one TO 8 DO            display_string[3+((loop-1)*7)] := ' ';             (**)        (* Write the line to the output file.         (**)            IF write_long_str (output_file,                            display_string,                           error_code)           THEN GOTO 99;            (* Break after each 8 lines. *)         lines := lines + one;         IF (lines = 8) THEN BEGIN            display_string := ' ';            IF write_long_str (output_file,                              display_string,                               error_code)   
            THEN GOTO 99;  
          lines := zero;            END; (* then insert a space in the listing *)            END; (* while all text has not been displayed. *)          (**)      (* End the text listing with a blank line.      (**)       
   display_string := ' ';  
        IF write_long_str (output_file,                        display_string,                         error_code)   
      THEN GOTO 99;  
            display_text := false;  (* No error! *)      99:  (* error exit *)       END; (* display_text *)   .  