 $PASCAL ',7 92081-1X501 REV.2540' $       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18501                                        *)  ! !(* RELOC:   92081-16501                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL> <TH>                                     *)  ! !(*                                                             *)  ! (* Date last modified: <851206.1536>  !(*                                                             *)  ! !(***************************************************************)  !     (**)  %(*:nl:$ '        SOURCE MESSAGE CATALOG                                  ' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '* (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984.  ALL RIGHTS      *' % %(*:nl:$ '* RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *' % %(*:nl:$ '* REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT *' % %(*:nl:$ '* THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        *' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '                                                                ' % %(*:nl:$ '                           SOURCE:   92081-18070                ' % %(*:nl:$ '         S. MESSAGE CATALOG NAME :   <EM000                     ' % %(*:nl:$ '                            RELOC:   92081-16070                ' % %(*:nl:$ '         B. MESSAGE CATALOG NAME :   %EM000                     ' % %(*:nl:$ '                            PGMR :   TH                         ' % $(*:nl:$ '         REV.2540  <851206.1536>                              ' $ (*:nl:$   (*:nl:$   &(*:nl:$ATB, mlgdlr, %em000, relocatable, 92081-16070 REV.2540 <851206.1536>  & (*:nl:$   (*:nl:$LANGID,0   (*:nl:$   
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      
$ Include '[LBOPT' $ 
     PROGRAM log_record_printer;       #(*******************************************************************)  # #(*               Global Include Files                              *)  # #(*******************************************************************)  #     $ List OFF, Include '[IMAGE', List ON $       TYPE     nl_date_type =        (* date definition for NlFmtDate *)  
      PACKED RECORD  
          nl_year: 0..99;   (* year of century *)           nl_day: 0..366;   (* day of year *)        END; (* record *)          nl_time_type =        (* time definition for NlFmtDate *)  
      PACKED RECORD  
          unused1: 0..7;    (* unused area *)           nl_hour: 0..24;   (* hour of day *)           unused2: 0..3;    (* unused area *)           nl_minute: 0..59; (* minute of hour *)            unused3: 0..3;    (* unused area *)           nl_second: 0..59; (* second *)   "         unused4: 0..256;  (* tenths of second but not used here *)  "       END; (* record *)       #(*******************************************************************)  # #(*               External routine references                       *)  # #(*******************************************************************)  #     $ List OFF, Include '[XDFMP', List ON $   $ List OFF, Include '[XDSMR', List ON $   $ List OFF, Include '[XUSHF', List ON $       $ List OFF, Include '[XDNLS', List ON $   (*:nl:$COPY 'PROCEDURE &; EXTERNAL;' *)   PROCEDURE MLGDLR; EXTERNAL;           (**** Convert a word into 2 printable characters. ****)       PROCEDURE get_printable_chars  $ Alias 'LOG.PrintChars' $   $ Heapparms ON $     (VAR word_value : Short_int;   	$ Heapparms OFF $  	 
    VAR char1      : Char; 
     VAR char2      : Char); EXTERNAL;           (**** Display arbitrary text to an output file. ****)       FUNCTION display_text   $ Alias 'LOG.DisplayText' $   $ Heapparms ON $     (VAR text_buffer : short_int; (* first word of buffer *)       VAR text_len    : short_int;  	$ Heapparms OFF $  	     VAR output_file : file_descriptor;      VAR error_code  : short_int) : Boolean;      EXTERNAL;      
(* NLS Time intrinsics *)  
 PROCEDURE nl_format_date $ Alias 'NLFMTDATE' $     (    date     : nl_date_type;          time     : nl_time_type;      VAR string   : long_str;          langnum  : short_int;       VAR error    : short_int);     EXTERNAL;      $ Page $  #(*******************************************************************)  # #(*                Display_process_info                             *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To neatly print the process description id for a program     *)  # #(*    to some output file or device.                               *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) The process info type.                          *)  # #(*    (in/out) (2) The output file descriptor.                     *)  # #(*    (out)    (3) IMAGE error if an error occurs.                 *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    Boolean 'True' if an error occurs, 'False' otherwise.        *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION display_process_info   $ Alias 'LOG.DisplayProc' $   $ Heapparms ON $     (VAR process_info : process_description_type;  	$ Heapparms OFF $  	     VAR output_file  : file_descriptor;       VAR error_code   : short_int) : Boolean;      LABEL 99,  (* error exit *)         10;  (* NLS message tests *)      CONST      len = 128;  (* NlReadRel max. read length *)       VAR      display_string : long_str;      add_string     : short_str;     number_string  : short_str;     number         : short_int;     nlerr          : short_int;     length         : short_int;      BEGIN  (* display_process_info *)       !   display_process_info := true;  (* assume an error will occur *) !        (**)      (* Final output line from this routine is:   
   (* '   PROGRAM = XXXXX' 
    (**)       (* display_string := '   PROGRAM ='; *)   	   (*:nl:$ ' ' *)  	    (*:nl:$ ' !1 is the name of program (5 bytes)' *)     (*:nl:#*1 1000 '   PROGRAM = !1'; *)          add_string := process_info.pname;      (* append_blank_and_str (display_string, add_string); *)      
10:  (* NLS tests *) 
        null_pad (add_string, chars_in_short_str);          (*:nl:$COPY '   length := nlread_p1 (&, #, nlerr,' *)     length := nlread_p1 (MLGDLR, 1000, nlerr,                                   display_string, len, add_string);     blank_pad (display_string, chars_in_long_str, length);          (**)      (* String is constructed:  Display it!      (**)          IF write_long_str (output_file,                        display_string,                         error_code)   
      THEN GOTO 99;  
        display_process_info := false;  (* No error! *)      99:  (* error exit *)       END; (* display process info *)       $ Page $  #(*******************************************************************)  # #(*                Display_transaction_number                       *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To display a transaction number in an easily readable format *)  # #(*    for output for the programs DBRBR and DBRFR.                 *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) Transaction number.                             *)  # #(*    (in/out) (2) Output file descriptor.                         *)  # #(*    (out)    (3) IMAGE error code if an error occurs.            *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    Boolean 'True' if an error occurs, 'False' otherwise.        *)  # #(*                                                                 *)  # #(*******************************************************************)  #     !FUNCTION display_transaction_number   $ Alias 'LOG.DisplayXact' $  ! $ Heapparms ON $     (VAR transaction_number : Long_int;  	$ Heapparms OFF $  	     VAR output_file        : file_descriptor;       VAR error_code         : short_int) : Boolean;      LABEL 99;  (* error exit *)       CONST      len = 128; (* NlReadRel max. read length *)      VAR      display_string : long_str;      number_string  : short_str;     transaction    : long_int;      nlerr          : short_int;     length         : short_int;      BEGIN  (* display_transaction_number *)          display_transaction_number := true;  (* Assume error *)         transaction := transaction_number;           long_int_to_readable_short_str (transaction, number_string);        (* display_string := '   TRANSACTION NUMBER ='; *)         (*:nl:$ ' !1 is the transaction number (max. 10 bytes)' *)      (*:nl:#*1 1001 '   TRANSACTION NUMBER =!1' *)      (* append_str (display_string, number_string); *)          null_pad (number_string, chars_in_short_str);     (*:nl:$COPY '   length := nlread_p1 (&, #, nlerr,' *)     length := nlread_p1 (MLGDLR, 1001, nlerr,      !                             display_string, len, number_string);  !    blank_pad (display_string, chars_in_long_str, length);          IF write_long_str (output_file,                        display_string,                         error_code)   
      THEN GOTO 99;  
        display_transaction_number := false;  (* No error! *)      99:  (* error exit *)       END;  $ Page $  #(*******************************************************************)  # #(*                Display_record_info                              *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To display a database namr, dataset number and record number *)  # #(*    in an easily readable format for output to a text file.      *)  # #(*    Primary users will be DBRBR and DBRFR for log records.       *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) Database namr.                                  *)  # #(*    (in)     (2) Dataset number.                                 *)  # #(*    (in)     (3) Record number in dataset.                       *)  # #(*    (in)     (4) Transaction number assigned to record.          *)  # #(*    (in/out) (5) Output file descriptor.                         *)  # #(*    (out)    (6) IMAGE error code if an error occurs.            *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*     Boolean 'True' if an error occurs, 'False' otherwise.       *)  # #(*                                                                 *)  # #(*******************************************************************)  #     FUNCTION display_record_info   $ Alias 'LOG.DisplayRecrd' $   $ Heapparms ON $     (VAR database_name   : new_file_name;      VAR dataset_number  : short_int;      VAR record_number   : long_int;       VAR transaction_num : long_int;   	$ Heapparms OFF $  	     VAR output_file     : file_descriptor;      VAR error_code      : short_int) : Boolean;       LABEL 10,11,12,13,  (* NLS message tests *)         99;  (* error exit *)       CONST      len = 128;  (* NlReadRel max. read length *)       VAR      display_string : long_str;      short_number   : short_int;     long_number    : long_int;      number_string  : short_str;     number2_string : short_str;     add_string     : short_str;     file_string    : long_str;      nlerr          : short_int;     length         : short_int;     temp_fname     : new_file_name;          BEGIN (* display_record_info *)          display_record_info := true;  (* Assume error will occur *)         (**)      (* First display the transaction number.      (**)          IF display_transaction_number (transaction_num,                                    output_file,                                    error_code)   
      THEN GOTO 99;  
     (* display_string := '   DATABASE ='; *)  	   (*:nl:$ ' ' *)  	    (*:nl:$ ' !1 is the name of database (max. 63 bytes)' *)      (*:nl:$ ' !2 is the data set number (max. 5 bytes) ' *)     (*:nl:$ ' !3 is the record  number (max. 10 bytes) ' *)     (*:nl:#*1 1002 '   DATABASE = !1   SET/RECORD =!2/!3'; *)      (* long_dest_file_srce (display_string, chars_in_long_str,                          database_name, chars_in_new_file_name,                          str_append, zero); *)          temp_fname := database_name;       
10:  (* NLS tests *) 
        null_pad_fname (temp_fname, chars_in_new_file_name);          (**)   !   (* Display the dataset and record number in set in the format:  !    (* '   SET/RECORD =##/##########'     (**)       (* append_str (display_string,'   SET/RECORD ='); *)         short_number := dataset_number;      !   short_int_to_readable_short_str (short_number, number_string);  !     
11:  (* NLS tests *) 
        null_pad (number_string, chars_in_short_str);      (* append_str (display_string, number_string); *)       (* append_str (display_string, '/'); *)          long_number := record_number;          long_int_to_readable_short_str (long_number, number2_string);       
12:  (* NLS tests *) 
        null_pad (number2_string, chars_in_short_str);       (* append_str (display_string, number_string); *)       
13:  (* NLS tests *) 
     %   (*:nl:$COPY '   length := nlread_fss (&, #, nlerr, display_string,' *)  % !   length := nlread_fss (MLGDLR, 1002, nlerr, display_string,      ! #                      len, temp_fname, number_string, number2_string); #    blank_pad (display_string, chars_in_long_str, length);          IF write_long_str (output_file,                        display_string,                         error_code)   
      THEN GOTO 99;  
        display_record_info := false;  (* No error! *)       99:  (* error exit *)       END; (* display_record_info *)  $ Page $  #(*******************************************************************)  # #(*                      make_timestamp                             *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To turn a packed binary timestamp into a readable ascii long *)  # #(*    string which can be easily printed.                          *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) Packed Binary timestamp.  (May be in EMA).      *)  # #(*    (out)    (2) Ascii string with readable timestamp.           *)  # #(*                                                                 *)  # #(* Errors: None.                                                   *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE make_timestamp   $ Alias 'LOG.MakeTimestmp' $   $ Heapparms ON $     (VAR binary_timestamp   : date_and_time_type;  	$ Heapparms OFF $  	     VAR readable_timestamp : long_str);       LABEL      10,99;  (* NLS message tests *)      TYPE         days_in_month_array_type = ARRAY [1..12] OF short_int;       CONST      days_in_month = days_in_month_array_type          [31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];         len = 128;  (* NlReadREl max read length *)  VAR      month_number : short_int;     day_sum      : short_int;     local_var    : short_int;     add_string   : short_str;         langid       : short_int;     length       : short_int;     nlerr        : short_int;     nldate       : nl_date_type;      nltime       : nl_time_type;      nl_time_str  : long_str;       (**)  (* Determine if this month is February in a leap year.  (**)      	FUNCTION leap_day  	    (year : short_int;       month: short_int) : short_int;      BEGIN      IF ((year MOD 4) = zero) AND (month = 2)         THEN IF (year MOD 100) = zero            THEN IF (year MOD 400) = zero              THEN leap_day := one              ELSE leap_day := zero            ELSE leap_day := one         ELSE leap_day := zero   END;          
BEGIN (* make_timestamp *) 
        (* Get language ID *)     langid := nllangid;      
10:  (* NLS tests *) 
        IF langid <> 0 THEN BEGIN  
      WITH nldate DO BEGIN 
          nl_year := binary_timestamp.year mod 100;           nl_day  := binary_timestamp.day;         END; (* with *)       
      WITH nltime DO BEGIN 
          nl_hour := binary_timestamp.hour;           nl_minute := binary_timestamp.minute;           nl_second := binary_timestamp.second;        END; (* with *)       !      nl_format_date (nldate, nltime, nl_time_str, langid, nlerr); !       null_pad_lstr (nl_time_str, chars_in_long_str);       
      (*:nl:$ ' ' *) 
       (*:nl:$ ' !1 is the time stamp (max.26 bytes) ' *)        (*:nl:#*1 1003 ' TIME = !1' *)        (*:nl:$COPY '      length := nlread_l1 (&, #, nlerr,' *)        length := nlread_l1 (MLGDLR, 1003, nlerr,                                  readable_timestamp, len, nl_time_str);          blank_pad (readable_timestamp, chars_in_long_str, length);       &      (* NLS Time intrincics don't support second so make the second here *) &           local_var := nltime.nl_second;            short_int_to_readable_short_str (local_var, add_string);            append_blank_and_str (readable_timestamp, add_string);      	   END (* then *)  	        ELSE BEGIN   
   day_sum := zero;  
    month_number := one;          readable_timestamp := ' TIME =';          WITH binary_timestamp DO BEGIN             (* Determine which month this is *)             WHILE ((day_sum + days_in_month[month_number] +                leap_day (year,month_number) < day)              AND (month_number <= 12)) DO BEGIN               day_sum := day_sum + days_in_month[month_number] +                       leap_day (year,month_number);            month_number := month_number + one;           END;             day_sum := day - day_sum;  (* calculate day in month *)       
      CASE month_number OF 
          1 : add_string := ' JAN';           2 : add_string := ' FEB';           3 : add_string := ' MAR';           4 : add_string := ' APR';           5 : add_string := ' MAY';           6 : add_string := ' JUN';           7 : add_string := ' JUL';           8 : add_string := ' AUG';           9 : add_string := ' SEP';          10 : add_string := ' OCT';          11 : add_string := ' NOV';          12 : add_string := ' DEC';          OTHERWISE add_string := 'XXX';          END;            append_str (readable_timestamp, add_string);  (* MMM *)                 short_int_to_readable_short_str (day_sum, add_string);            positional_append_str (readable_timestamp,                               add_string,            (* DD *)                               chars_in_short_str,13);                add_string := ',';            append_str (readable_timestamp, add_string);  (* , *)                 local_var := year;            short_int_to_readable_short_str (local_var, add_string);            positional_append_str (readable_timestamp,    (* YYYY *)                               add_string,                               chars_in_short_str,17);            local_var := hour;            short_int_to_readable_short_str (local_var, add_string);            positional_append_str (readable_timestamp,    (* HH *)                               add_string,                               chars_in_short_str,22);            add_string := ':';            append_str (readable_timestamp, add_string);  (* : *)               
      local_var := minute; 
           short_int_to_readable_short_str (local_var, add_string);            append_str (readable_timestamp, add_string);  (* MM *)                add_string := ':';            append_str (readable_timestamp, add_string);  (* : *)           
      local_var := second; 
           short_int_to_readable_short_str (local_var, add_string);            append_str (readable_timestamp, add_string);            END; (* with binary timestamp *)  	   END; (* else *) 	     
99: (* NLS tests *)  
     
END; (* make_timestamp *)  
     $ Page $  #(*******************************************************************)  # #(*                Display_log_record                               *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To display the contents of an arbitrary log record to a      *)  # #(*    specified output file/device.  This routine was initially    *)  # #(*    designed to be of use to DBRBR and DBRFR where the only      *)  # #(*    'important' log records are DBBEG, DBEND, DBDEL, DBPUT and   *)  # #(*    DBUPD, so the others may well not be included in this code.  *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) The Heap 2 pointer to the log record.           *)  # #(*    (in/out) (2) The file descriptor for the output.             *)  # #(*    (out)    (3) An IMAGE error if an error occurs.              *)  # #(*                                                                 *)  # #(* Function result:                                                *)  # #(*    Boolean 'True' if an error occurs, 'false' otherwise.        *)  # #(*                                                                 *)  # #(* Possible errors:                                                *)  # #(*    FMP i/o errors;  EMA mapping errors.                         *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     FUNCTION display_log_record  $ Alias 'LOG.DisplayRec' $      (VAR log_record : ptr_log_record_header_type;      VAR outfile    : file_descriptor;       VAR error_code : short_int) : Boolean;      
LABEL 99, (* error exit *) 
        9,10,11,12,13,14,15,16,17,18,19;  (* NLS message tests *)        CONST      len = 128;  (* NlReadRel max. read length *)       VAR      display_string : long_str;      number_string  : short_str;     add_string     : short_str;     log_record_str : long_str;      time_string    : long_str;      nlerr          : short_int;     length         : short_int;     msgnum         : short_int;          BEGIN  (* display_log_record *)       
   display_string := ' ';  
        IF write_long_str (outfile,                        display_string,                         error_code)   
      THEN GOTO 99;  
        (**)      (* Display the log record type.     (**)          CASE log_record^.rec_type OF             tuf_eof_indicator  : msgnum := 10;        dbbeg_log_code     : msgnum := 11;        dbcls_log_code     : msgnum := 12;        dbdel_log_code     : msgnum := 13;        dbend_log_code     : msgnum := 14;        dbmem_log_code     : msgnum := 15;        dbopn_log_code     : msgnum := 16;        dbput_log_code     : msgnum := 17;        dbund_log_code     : msgnum := 18;        dbupd_log_code     : msgnum := 19;        chunk_head_log_code: msgnum := 20;        chunk_tail_log_code: msgnum := 21;        OTHERWISE            msgnum := 22;        END; (* case of log record type *)      
      (*:nl:$ ' ' *) 
       (*:nl:$ ' These are name of log record types.' *)         (*:nl:#10 ' TUF LOGICAL EOF MARK' *)        (*:nl:#11 ' DBBEG' *)         (*:nl:#12 ' DBCLS' *)         (*:nl:#13 ' DBDEL' *)         (*:nl:#14 ' DBEND' *)         (*:nl:#15 ' DBMEM' *)         (*:nl:#16 ' DBOPN' *)         (*:nl:#17 ' DBPUT' *)         (*:nl:#18 ' DBUND' *)         (*:nl:#19 ' DBUPD' *)         (*:nl:#20 ' TUF CHUNK HEADER' *)        (*:nl:#21 ' TUF CHUNK TAILER' *)        (*:nl:#22 ' UNDEFINED' *)   
      (*:nl:$ ' ' *) 
     
9:  (* NLS tests *)  
        (*:nl:$COPY '   length := nlread (&, msgnum, nlerr,' *)     length := nlread (MLGDLR, msgnum, nlerr,                                    log_record_str, len);     null_pad_lstr (log_record_str, chars_in_long_str);       (* add_string := ' LOG RECORD:'; *)       	   (*:nl:$ ' ' *)  	    (*:nl:$ ' !1 is the log record type' *)     (*:nl:$ ' !2 is the time string ' *)      (*:nl:#*1 1004 '!1 LOG RECORD: !2' *)      (* append_str (display_string, add_string); *)         (**)      (* Construct the timestamp:  MMM DD, YYYY HH:MM:SS   !   (* MMM=month, DD=day, YYYY=year, HH=hour, MM=minute, SS=second. !    (**)          make_timestamp (log_record^.timestamp, time_string);       (* append_long_str (display_string, time_string); *)  $   (*:nl:$COPY '   length := nlread_ll (&, #, nlerr, display_string,' *) $     length := nlread_ll (MLGDLR, 1004, nlerr, display_string,                                     len, log_record_str, time_string);       blank_pad (display_string, chars_in_long_str, length);          IF write_long_str (outfile,                        display_string,                         error_code)   
      THEN GOTO 99;  
     
10:  (* NLS tests *) 
        WITH log_record^ DO CASE rec_type OF             dbbeg_log_code,  (* Assumption is that these have *)        dbend_log_code,  (* identical log record formats. *)        dbmem_log_code,         dbund_log_code : BEGIN               (**)            (* Display the process information.           (**)       
11: (* NLS tests *)  
     #         IF display_process_info (beg.proc_info, outfile, error_code)  # 
            THEN GOTO 99;  
              (**)            (* Display the transaction number.            (**)       	12: (*NLS tests *) 	              IF display_transaction_number (beg.trans_num,                                          outfile,                                          error_code)   
            THEN GOTO 99;  
                  (**)            (* Display the user text.           (**)                IF display_text (beg.text.word_str[one],                             beg.text_len,                             outfile,                            error_code)   
            THEN GOTO 99;  
     "         END; (* case of DBBEG, DBEND, DBMEM and DBUND log records*) "               dbdel_log_code,  (* Assumes record formats identical *)         dbput_log_code : BEGIN               (**)            (* Display the process information.           (**)                IF display_process_info (delete.proc_info,                                     outfile,                                    error_code)   
            THEN GOTO 99;  
              (**)   #         (* Display the database, dataset and record number affected.  #          (**)                WITH delete DO BEGIN       
13:  (* NLS tests *) 
                 IF display_record_info (db_name_id,                                       ds_num,                                       rec_num,                                      trans_num,                                      outfile,                                      error_code)                  THEN GOTO 99;                      (**)              (* Display the data being deleted/added.              (**)                  IF display_text (buffer[dbdel_data_off+1],                               data_len,                               outfile,                                error_code)                 THEN GOTO 99;                  END; (* with delete-specific info *)               END; (* Case of DBDEL and DBPUT log records *)                 dbupd_log_code : BEGIN               (**)            (* Display process information.           (**)                IF display_process_info (update.proc_info,                                     outfile,                                    error_code)   
            THEN GOTO 99;  
              (**)            (* Display record information.            (**)                WITH update DO BEGIN               IF display_record_info (db_name_id,                                       ds_num,                                       rec_num,                                      trans_num,                                      outfile,                                      error_code)                  THEN GOTO 99;                  (**)              (* Display Old data and New data.               (**)                  display_string := ' ';                  IF write_long_str (outfile,                                  display_string,                                 error_code)                 THEN GOTO 99;      (*          display_string := '   DBUPD OLD DATA:'; *)              (*:nl:#*1 1005 '   DBUPD OLD DATA:' *)      
14:  (* NLS tests *) 
     $            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *)  $             length := nlread (MLGDLR, 1005, nlerr,                                            display_string, len);   !            blank_pad (display_string, chars_in_long_str, length); !                 IF write_long_str (outfile,                                  display_string,                                 error_code)                 THEN GOTO 99;      
15:  (* NLS tests *) 
                 IF display_text (buffer[dbupd_old_data_off+1],                               data_len,                               outfile,                                error_code)                 THEN GOTO 99;      (*          display_string := '   DBUPD NEW DATA:'; *)              (*:nl:#*1 1006 '   DBUPD NEW DATA:' *)      
16:  (* NLS tests *) 
     $            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *)  $             length := nlread (MLGDLR, 1006, nlerr,                                            display_string, len);   !            blank_pad (display_string, chars_in_long_str, length); !                 IF write_long_str (outfile,                                  display_string,                                 error_code)                 THEN GOTO 99;      
17:  (* NLS tests *) 
                 IF display_text (buffer[new_data_off+1],                               data_len,                               outfile,                                error_code)                 THEN GOTO 99;                  END; (* with update-specific info *)               END; (* case of dbupd log record *)                 OTHERWISE BEGIN (* Some log record we don't know about *)        #(*       display_string := 'NO INFO AVAILABLE FOR THIS LOG RECORD'; *) # "         (*:nl:#*1 1007  'NO INFO AVAILABLE FOR THIS LOG RECORD' *)  "     
18:  (* NLS tests *) 
     !         (*:nl:$COPY '         length := nlread (&, #, nlerr,' *)  !          length := nlread (MLGDLR, 1007, nlerr,                                          display_string, len);            blank_pad (display_string, chars_in_long_str, length);                 IF write_long_str (outfile,                              display_string,                               error_code)   
            THEN GOTO 99;  
     
19:  (* NLS tests *) 
              END; (* otherwise not a known log record. *)             END; (* case of log record type *)             (**)      (* Print a blank line to the output file.     (**)          display_log_record := false;  (* no error! *)      99:  (* error exit *)       END; (* display log record *)   .  