 $PASCAL ',7 92081-1X256 REV.2540' $   $ Title 'IMAGE: Issue error messages' $   $ Heap 0 $  	$ Recursive OFF $  	 $ Subprogram  $   $ Range off $       PROGRAM display_IMAGE_error;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) #     #(********************************************************************) # #(*                                                                  *) # #(* ROUTINE : Issue an IMAGE error message                           *) # #(*                                                                  *) # #(* PURPOSE : This file contains the routine which will write an     *) # #(*           error message to a given file.                         *) # #(*                                                                  *) # #(* PGMR:        <EDB> <stc>                                         *) # #(*              <TH> for NLS                                        *) # #(*                                                                  *) # #(* SOURCE:  92081-18256                                             *) # #(*                                                                  *) # (* Date of last modification <860206.0928>  #(*                                                                  *) # #(********************************************************************) #     (**)  &(*:nl:$ATB, mdperr, %lb000, relocatable, 92081-16071 REV.2540 <860206.0928>  & (*:nl:$   
(*:nl:$COUNTER, 1, 1000, 1 
 (**)  $ List OFF, Include '[IMAGE', List ON $       $ Page $  #(********************************************************************) # #(*                      EXTERNAL PROCEDURES                         *) # #(********************************************************************) #     $ List OFF, Include '[XDFMP', List ON $       
$ Include '[XUSHF' $ 
 
$ Include '[XDSMR' $ 
     $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)      $(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *)  $  PROCEDURE MDPERR; EXTERNAL;                                        	$ heapparms off $  	     #(********************************************************************) # #(*                      issue_error                                 *) # #(********************************************************************) # #(*                                                                  *) # #(* Issue_error displays an error message on the log file.           *) # #(*                                                                  *) # #(********************************************************************) #     PROCEDURE issue_error   $ Alias 'IMG.IssueError'$       (VAR log_file  : file_descriptor;            error_code: short_int);      LABEL      11,99;       CONST   #   chars_in_message = 50;          (* error message length in chars *) #    len = chars_in_long_str;        (* NLS read length limit *)      TYPE     message =                       (* error message *)        PACKED ARRAY [1..chars_in_message] OF char;           VAR   
   temp_string : Long_str; 
    temp_short_str : short_str;     return_status : Short_int;      length        : Short_int;      (* NLS read length *)     nlerr         : Short_int;      (* NLS eorror number *)     msgnum        : Short_int;      (* NLS message number *)           BEGIN (* issue_error *)       11:CASE error_code OF             (**** Common FMP errors ****)             device_already_locked_err :            (*:nl:#*1 1000 'FMP -36 :  Lock error on device' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1000 ;           
      cartridge_full_err,  
       fmp_cartridge_full_err :           (*:nl:#*1 1001 'FMP -33 :  Disc is full' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1001 ;                 cartridge_not_found_err,        fmp_cartridge_not_found_err :   #         (*:nl:#*1 1002 'FMP -32 :  Disc cartridge cannot be found' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1002 ;                 illegal_file_name_err,        fmp_illegal_file_name_err :            (*:nl:#*1 1003 'FMP -15 :  File name was illegal' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1003 ;                 disc_locked_err,        fmp_disc_locked_err :             (*:nl:#*1 1004 'FMP -13 :  Disc cartridge is locked' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1004 ;           	      bof_eof_err, 	       fmp_bof_eof_err :   &         (*:nl:#*1 1005 'FMP -12 :  Beginning or end of file encountered' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1005 ;                 dcb_not_open_err,         fmp_dcb_not_open_err :           (*:nl:#*1 1006 'FMP -11 :  DCB was not open' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1006 ;                 file_already_open_err,        fmp_file_already_open_err :   &         (*:nl:#*1 1007 'FMP  -8 :  File already open to another program' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1007 ;                 bad_security_code_err,        fmp_bad_security_code_err :   %         (*:nl:#*1 1008 'FMP  -7 :  File security code was not correct' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1008 ;           
      file_not_found_err,  
       fmp_file_not_found_err :            (*:nl:#*1 1009 'FMP  -6 :  File could not be found' *)             (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1009 ;           
      duplicate_file_err,  
       fmp_duplicate_file_err :  '         (*:nl:#*1 1010 'FMP  -2 :  File already exists with the same name' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1010 ;                 disc_failure_err,         fmp_disc_failure_err :  &         (*:nl:#*1 1011 'FMP  -1 :  Disc driver returned an error to FMP' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1011 ;                     (**** IMAGE intrinsic errors ****)      
      no_image_err : 
          (*:nl:#*1 1012 'Success~! :  No error occurred' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1012 ;                 illegal_set_ref_err :   "         (*:nl:#*1 1013 'IMAGE 100 :  Illegal data set reference' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1013 ;                 illegal_item_ref_err :            (*:nl:#*1 1014 'IMAGE 101 :  Illegal item reference' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1014 ;                 item_not_key_err :                                        &         (*:nl:#*1 1015 'IMAGE 102 :  Specified item was not a key item' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1015 ;           "      db_not_open_to_user_err :                                      " %         (*:nl:#*1 1016 'IMAGE 103 :  Database not open to the program' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1016 ;                 mode_not_suff_err :                                       '         (*:nl:#*1 1017 'IMAGE 104 :  Read-only database cannot be changed' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1017 ;                  detail_set_full_err :                                        #         (*:nl:#*1 1018 'IMAGE 105 :  The detail data set is full' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1018 ;                  master_set_full_err :                                        "         (*:nl:#*1 1019 'IMAGE 106 :  A master data set is full' *)  "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1019 ;           !      no_master_for_key_err :                                      ! &         (*:nl:#*1 1020 'IMAGE 107 :  No master record exists for a key' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1020 ;                 auto_master_err :                                       '         (*:nl:#*1 1021 'IMAGE 108 :  Cannot alter an automatic master set' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1021 ;           #      no_crash_has_occurred_err :                                      # !         (*:nl:#*1 1022 'IMAGE 109 :  A crash has not occurred' *) !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1022 ;           %      key_already_in_manual_set_err :                                      % %         (*:nl:#*1 1023 'IMAGE 110 :  Key already exists in master set' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1023 ;                 path_not_init_err :                                       "         (*:nl:#*1 1024 'IMAGE 111 :  Chain path not initialized' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1024 ;           $      key_change_not_allowed_err :                                       $ '         (*:nl:#*1 1025 'IMAGE 112 :  Key and sort items cannot be changed' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1025 ;           #      manual_master_delete_err :                                       # &         (*:nl:#*1 1026 'IMAGE 113 :  Master record has non-empty chain' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1026 ;                 record_empty_err :                                                 (*:nl:#*1 1027 'IMAGE 114 :  Record was empty' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1027 ;                 invalid_mode_err :                                        &         (*:nl:#*1 1028 'IMAGE 115 :  No such mode exists for this call' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1028 ;                  not_a_root_file_err :                                        !         (*:nl:#*1 1029 'IMAGE 116 :  Namr was not a root file' *) !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1029 ;                  wrong_sec_code_err :                                         $         (*:nl:#*1 1030 'IMAGE 117 :  Wrong root file security code' *)  $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1030 ;           !      set_not_writable_err :                                       ! "         (*:nl:#*1 1031 'IMAGE 118 :  Write access to set needed' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1031 ;                 no_root_file_err :                                                 (*:nl:#*1 1032 'IMAGE 119 :  Root file not found' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1032 ;                 not_a_detail_err :                                        !         (*:nl:#*1 1033 'IMAGE 120 :  Data set is not a detail' *) !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1033 ;           &      detail_not_linked_to_master_err :                                      &          (*:nl:#*1 1034 'IMAGE 121 :  No paths to detail' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1034 ;                 chain_read_err :                                        '         (*:nl:#*1 1035 'IMAGE 122 :  Chained read could not be performed' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1035 ;                 not_a_master_err :                                        !         (*:nl:#*1 1036 'IMAGE 123 :  Data set is not a master' *) !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1036 ;           !      illegal_info_mode_err :                                      !          (*:nl:#*1 1037 'IMAGE 124 :  Illegal DBINF mode' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1037 ;                 bad_item_or_set_err :   $         (*:nl:#*1 1038 'IMAGE 125 :  DBINF item or set was illegal' *)  $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1038 ;                 hard_crash_err :  '         (*:nl:#*1 1039 'IMAGE 126 :  HARD CRASH~!  Do hard crash recovery' *  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1039 ;                 class_number_err :  $         (*:nl:#*1 1040 'IMAGE 127 :  Class number allocation error' *)  $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1040 ;           
      no_more_space_err :  
 $         (*:nl:#*1 1041 'IMAGE 128 :  Program size must be increased' *) $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1041 ;           $      root_file_open_to_other_err :                                      $ '         (*:nl:#*1 1042 'IMAGE 129 :  Root file is open to another program' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1042 ;           %      database_needs_backing_up_err :                                      % "         (*:nl:#*1 1043 'IMAGE 130 :  Database must be backed up' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1043 ;                  open_table_full_err :                                                  (*:nl:#*1 1044 'IMAGE 131 :  100 databases are open' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1044 ;           #      resource_number_alloc_err :                                      # %         (*:nl:#*1 1045 'IMAGE 132 :  Resource number allocation error' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1045 ;                 class_get_err :                                                 (*:nl:#*1 1046 'IMAGE 133 :  Error in Class I/O GET' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1046 ;           !      image_not_active_err :                                       ! !         (*:nl:#*1 1047 'IMAGE 134 :  IMAGE must be started up' *) !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1047 ;           !      db_unlock_failed_err :                                       ! %         (*:nl:#*1 1048 'IMAGE 135 :  Unlock of locked database failed' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1048 ;                 lock_conflict_err :                                                (*:nl:#*1 1049 'IMAGE 136 :  Lock attempt failed' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1049 ;           #      resource_number_usage_err :                                      # &         (*:nl:#*1 1050 'IMAGE 137 :  Resource number lock/unlock error' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1050 ;           #      unrecognized_message_err :                                       # '         (*:nl:#*1 1051 'IMAGE 138 :  Unrecognizable message was received' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1051 ;           #      image_not_initialized_err :                                      # "         (*:nl:#*1 1052 'IMAGE 139 :  IMAGE programs are missing' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1052 ;           #      invalid_prog_request_err :                                       #          (*:nl:#*1 1053 'IMAGE 141 :  Unrecognized message' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1053 ;           %      transaction_log_file_full_err :                                      % #         (*:nl:#*1 1054 'IMAGE 142 :  Transaction log file is full' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1054 ;                 IMAGE_not_started_err :   '         (*:nl:#*1 1055 'IMAGE 143 :  IMAGE has not been started by DBUTL' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1055 ;                 bif_corrupt_err :   (         (*:nl:#*1 1056 'IMAGE 144 :  HARD CRASH~! Corrupt before-image file' *) (          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1056 ;                 db_logically_inconsistent_err :   '         (*:nl:#*1 1057 'IMAGE 145 :  The database is logically incorrect' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1057 ;                 soft_crash_err :  '         (*:nl:#*1 1058 'IMAGE 146 :  SOFT CRASH~!  Do soft crash recovery' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1058 ;                 fatal_comm_err :  %         (*:nl:#*1 1059 'IMAGE 147 :  Internal communications failure' *)  %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1059 ;                 corrupt_message_err :   #         (*:nl:#*1 1060 'IMAGE 148 :  Received message was corrupt' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1060 ;                  DBMON_internal_err :                                                  (*:nl:#*1 1061 'IMAGE 149 :  DBMON internal error' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1061 ;           !      databases_are_open_err :                                     ! (         (*:nl:#*1 1062 'IMAGE 150 :  Databases are open; cannot shut down.' *)  (          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1062 ;           "      Logging_not_enabled_err :                                      "           (*:nl:#*1 1063 'IMAGE 151 :  Logging is not enabled' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1063 ;           %      DB_incompatible_open_mode_err :                                      % (         (*:nl:#*1 1064 'IMAGE 152 :  Database is open in incompatible mode' *)  (          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1064 ;           %      no_access_with_this_level_err :                                      % '         (*:nl:#*1 1065 'IMAGE 153 :  Database is inaccessible to program' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1065 ;                 bad_path_ptrs_err :                                       #         (*:nl:#*1 1066 'IMAGE 154 :  Path pointers are incorrect' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1066 ;           !      chain_ends_found_err :                                       ! %         (*:nl:#*1 1067 'IMAGE 155 :  Beginning or end of chain found' *)  %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1067 ;           "      empty_detail_chain_err :                                       "           (*:nl:#*1 1068 'IMAGE 156 :  Detail chain is empty' *)             (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1068 ;           #      no_set_current_record_err :                                      # &         (*:nl:#*1 1069 'IMAGE 157 :  No current record for the data set' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1069 ;           #      remote_prog_nonsystem_err :                                      # (         (*:nl:#*1 1070 'IMAGE 158 : RTE-A remote progs must be non-session' *)  (          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1070 ;           "      modify_without_lock_err :                                      " &         (*:nl:#*1 1071 'IMAGE 159 :  Lock database before modifying it' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1071 ;                 db_corrupt_err :                                        &         (*:nl:#*1 1072 'IMAGE 160 :  The database is physically corrupt' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1072 ;                 data_corrupt_err :                                        &         (*:nl:#*1 1073 'IMAGE 161 :  A database record has corrupt data' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1073 ;           !      illegal_procedure_err :                                      ! "         (*:nl:#*1 1074 'IMAGE 163 :  That call is not supported' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1074 ;           "      xaction_in_progress_err :                                      " %         (*:nl:#*1 1075 'IMAGE 164 :  Transaction already in progress' *)  %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1075 ;           $      no_xaction_in_progress_err :                                       $ "         (*:nl:#*1 1076 'IMAGE 165 :  No transaction in progress' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1076 ;                 text_length_err :                                       !         (*:nl:#*1 1077 'IMAGE 166 :  Text length was invalid' *)  !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1077 ;                     att_full_err :                                        #         (*:nl:#*1 1078 'IMAGE 168 :  Too many active transactions' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1078 ;           )      IMAGE_program_scheduled_improperly_err :                                     ) &         (*:nl:#*1 1079 'IMAGE 169 :  IMAGE program scheduled improperly' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1079 ;                 DBSPL_comm_err :                                      !         (*:nl:#*1 1080 'IMAGE 170 : DBSPL communication error' *) !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1080 ;                 tlf_open_err :                                        %         (*:nl:#*1 1081 'IMAGE 171 :  Error in opening transaction log' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1081 ;                 dis_access_err :                                        #         (*:nl:#*1 1082 'IMAGE 172 :  Database access is disabled' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1082 ;           #      transaction_violation_err :                                      # '         (*:nl:#*1 1083 'IMAGE 173 :  Call cannot be made in a transaction' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1083 ;           "      max_transaction_id_err :                                       " %         (*:nl:#*1 1084 'IMAGE 175 :  Transaction numbers are used up' *)  %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1084 ;           "      Xaction_spans_nodes_err :                                      " &         (*:nl:#*1 1085 'IMAGE 176 :  A transaction cannot span DS nodes' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1085 ;           (      invalid_num_of_lock_descriptors_err :                                      ( &         (*:nl:#*1 1086 'IMAGE 177 :  Lock descriptor count was invalid' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1086 ;           $      lock_desc_wrong_length_err :                                       $ &         (*:nl:#*1 1087 'IMAGE 178 :  Lock descriptor length was invalid' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1087 ;           !      logical_end_of_tuf_err :                                     ! '         (*:nl:#*1 1088 'IMAGE 179 :  Encountered logical end of log file' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1088 ;                 bm_comm_err :                                                (*:nl:#*1 1089 'IMAGE 180 :  DBMON is not alive' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1089 ;                 rfl_open_err :                                        $         (*:nl:#*1 1090 'IMAGE 181 :  Error opening roll forward log' *) $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1090 ;                 ema_mapping_err :                                                 (*:nl:#*1 1091 'IMAGE 182 :  EMA violation in IMAGE' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1091 ;                 xaction_ibase_err :                                       %         (*:nl:#*1 1092 'IMAGE 184 :  IBASE must be same as DBBEG call' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1092 ;           %      read_only_modify_attempt_err :                                       % '         (*:nl:#*1 1093 'IMAGE 185 :  Attempt to modify in read only mode' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1093 ;           )      related_manual_masters_not_locked_err :                                      ) '         (*:nl:#*1 1094 'IMAGE 186 :  Lock masters pointing to detail set' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1094 ;           "      not_a_dataset_file_err :                                       " '         (*:nl:#*1 1095 'IMAGE 188 :  Expected data set file was not a set' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1095 ;                 tlf_corrupt_err :                                       #         (*:nl:#*1 1096 'IMAGE 189 :  Corrupt transaction log file' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1096 ;                 dbcon_open_err :                                        #         (*:nl:#*1 1097 'IMAGE 190 :  Error opening the DBCON file' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1097 ;                 dbcon_read_err :                                        #         (*:nl:#*1 1098 'IMAGE 191 :  Error reading the DBCON file' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1098 ;                 dbcon_write_err :                                       #         (*:nl:#*1 1099 'IMAGE 192 :  Error writing the DBCON file' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1099 ;           !      dbmon_spool_init_err :                                       ! $         (*:nl:#*1 1100 'IMAGE 193 :  Error in DBSPL initialization' *)  $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1100 ;                  warning_log_acc_err :                                        $         (*:nl:#*1 1101 'IMAGE 195 :  Warning log file access error' *)  $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1101 ;           (      modify_without_rfl_gap_occurred_err :                                      ( $         (*:nl:#*1 1102 'IMAGE 196 :  Modify attempted after rfl gap' *) $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1102 ;                 parity_err :                                                 (*:nl:#*1 1103 'IMAGE 199 :  Tape parity error' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1103 ;           "      bad_or_not_rfl_tape_err :                                      " #         (*:nl:#*1 1104 'IMAGE 330 :  Bad roll forward log volume' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1104 ;           "      spare_rfl_undefined_err :                                      " &         (*:nl:#*1 1105 'IMAGE 331 : Spare roll forward log not defined' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1105 ;                  rfl_end_of_tape_err :                                                 (*:nl:#*1 1106 'IMAGE 333 :  End of tape' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1106 ;           #      rfl_device_not_ready_err :                                       # !         (*:nl:#*1 1107 'IMAGE 334 :  Magtape down or offline' *)  !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1107 ;                 rfl_parity_err :                                        !         (*:nl:#*1 1108 'IMAGE 335 :  Parity error on magtape' *)  !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1108 ;                 rfl_access_err :                                      '         (*:nl:#*1 1109 'IMAGE 336 : Error accessing the roll forward log' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1109 ;           !      spare_rfl_missing_err :                                      ! '         (*:nl:#*1 1110 'IMAGE 337 : The spare roll forward log is missing' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1110 ;                 rfl_internal_err :                                               (*:nl:#*1 1111 'IMAGE 339 : DBSPL internal error' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1111 ;                  rfl_dev_xfer_len_err :                                       %         (*:nl:#*1 1112 'IMAGE 340 : RFL read buffer/tape length error' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1112 ;                 RFL_wrong_vol_err :                                       '         (*:nl:#*1 1113 'IMAGE 341: Wrong roll forward log volume mounted' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1113 ;                 tlf_disc_io_err :                                       #         (*:nl:#*1 1114 'IMAGE 342 : I/O error on transaction log' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1114 ;                  rfl_dbcon_access_err :                                       '         (*:nl:#*1 1115 'IMAGE 344 : DBSPL could not access the DBCON file' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1115 ;                 corrupt_rfl_err :                                       '         (*:nl:#*1 1116 'IMAGE 346 :  Illegal or corrupt roll forward log' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1116 ;                 tape_verify_err :                                       $         (*:nl:#*1 1117 'IMAGE 350 :  Tape did not verify correctly' *)  $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1117 ;           "      db_must_be_disabled_err :                                      " %         (*:nl:#*1 1118 'IMAGE 351 : Database access must be disabled' *)  %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1118 ;                  set_not_defined_err :                                                  (*:nl:#*1 1119 'IMAGE 352 : Log set must be defined' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1119 ;           !      auto_cleanup_warn_code :                                     ! %         (*:nl:#*1 1120 'IMAGE 360 : DBMON is performing auto cleanup' *)  %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1120 ;                  rfl_switch_warn_code :                                       #         (*:nl:#*1 1121 'IMAGE 361 : DBSPL switching to spare rfl' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1121 ;           
      tlf_full_warn_code : 
 #         (*:nl:#*1 1122 'IMAGE 362 : Transaction log file is full' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1122 ;                 tlf_90_percent_full_warn_code :   &         (*:nl:#*1 1123 'IMAGE 367 : Transaction log file is > 90~% full' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1123 ;                 max_transaction_id_warn_code :  &         (*:nl:#*1 1124 'IMAGE 368 : Maximum transaction number reached' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1124 ;                 dbspl_terminating_warn_code :            (*:nl:#*1 1125 'IMAGE 369 : DBSPL is terminating' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1125 ;                 rfl_full_warn_code :                                      !         (*:nl:#*1 1126 'IMAGE 370 : Roll forward log is full' *)  !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1126 ;                 (**** IMAGE utility errors ****)      #      illegal_database_name_err :                                      #           (*:nl:#*1 1127 'IMAGE 201 :  Illegal database name' *)             (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1127 ;           #      invalid_security_code_err :                                      # !         (*:nl:#*1 1128 'IMAGE 202 :  Incorrect security code' *)  !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1128 ;           #      no_data_in_input_file_err :                                      # #         (*:nl:#*1 1129 'IMAGE 203 :  Input device/file was empty' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1129 ;           %      data_too_short_or_omitted_err :                                      % &         (*:nl:#*1 1130 'IMAGE 204 :  Not enough data given for a record' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1130 ;           $      set_or_end_mark_missing_err :                                      $ #         (*:nl:#*1 1131 'IMAGE 205 :  $SET or $END line not found' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1131 ;                 invalid_integer_field_err :   #         (*:nl:#*1 1132 'IMAGE 206 :  Integer field was not valid' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1132 ;                 invalid_real_number_field_err :   &         (*:nl:#*1 1133 'IMAGE 207 :  Real number field not valid.     ' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1133 ;                 unrecoverable_db_error_occurred_err :   '         (*:nl:#*1 1134 'IMAGE 208 :  Utility error~! Database may be bad' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1134 ;                 premature_eof_from_input_err :           (*:nl:#*1 1135 'IMAGE 209 :  Unexpected input EOF' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1135 ;                 illegal_lu_given_err :  #         (*:nl:#*1 1136 'IMAGE 210 :  Specified device was illegal' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1136 ;           #      incorrect_level_word_err :                                       # "         (*:nl:#*1 1137 'IMAGE 211 :  Level word was not highest' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1137 ;                 bad_dblod_dbrst_input_err :   #         (*:nl:#*1 1138 'IMAGE 212 :  Backup storage input was bad' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1138 ;                 bad_db_security_code_err :  !         (*:nl:#*1 1139 'IMAGE 213 :  Incorrect security code' *)  !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1139 ;                 different_subchannels_err :   $         (*:nl:#*1 1140 'IMAGE 214 :  Database subchannels changed~!' *) $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1140 ;                 missing_backup_file_err :   $         (*:nl:#*1 1141 'IMAGE 215 :  Backup storage file not found' *)  $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1141 ;                 different_root_or_set_file_size_err :   (         (*:nl:#*1 1142 'IMAGE 216 :  Disc file size and backup size differ' *)  (          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1142 ;           !      no_data_to_unload_err :                                      ! "         (*:nl:#*1 1143 'IMAGE 217 :  There is no data to unload' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1143 ;           $      illegal_mode_or_column_err :                                       $ '         (*:nl:#*1 1144 'IMAGE 218 :  Mode or column parameter is illegal' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1144 ;           #      no_room_for_root_file_err :                                      # $         (*:nl:#*1 1145 'IMAGE 219 :  No room for root file on disc' *)  $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1145 ;                  dbbld_io_abort_err :                                         $         (*:nl:#*1 1146 'IMAGE 220 :  DBBLD encountered an I/O error' *) $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1146 ;                 dbrbr_internal_err :                                               (*:nl:#*1 1147 'IMAGE 221 : DBRBR internal error' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1147 ;                 dbrfr_internal_err :                                               (*:nl:#*1 1148 'IMAGE 222 : DBRFR internal error' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1148 ;           "      scratch_file_create_err :                                      " "         (*:nl:#*1 1149 'IMAGE 223 : Error creating scratch file' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1149 ;                  rfr_volume_open_err :                                        $         (*:nl:#*1 1150 'IMAGE 224 : DBRFR could not open log volume' *) $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1150 ;           $      rfr_scratch_file_access_err :                                      $ #         (*:nl:#*1 1151 'IMAGE 225 : DBRFR scratch file I/O error' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1151 ;           "      wrong_rev_store_file_err :                                     " '         (*:nl:#*1 1152 'IMAGE 226 :  Wrong version store file/tape error' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1152 ;           !      data_set_not_empty_err :                                     ! #         (*:nl:#*1 1153 'IMAGE 227 :  Data set not empty for DBLOD' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1153 ;           #      illegal_verify_option_err :                                      # &         (*:nl:#*1 1154 'IMAGE 228 : DBSTR verify option parameter error' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1154 ;                 backup_io_err :                                       )         (*:nl:#*1 1155 'IMAGE 229 : I/O error; tape LU may have been illegal' *)  )          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1155 ;           %      magtape_has_no_write_ring_err :                                      % &         (*:nl:#*1 1156 'IMAGE 230 :  Magtape does not have a write-ring' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1156 ;           "      magtape_is_off_line_err :                                      "          (*:nl:#*1 1157 'IMAGE 231 :  Magtape is off-line' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1157 ;                 device_lock_err :                                                (*:nl:#*1 1158 'IMAGE 232 :  Device lock error' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1158 ;                 device_unlock_err :                                                (*:nl:#*1 1159 'IMAGE 233 :  Device unlock error' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1159 ;           &      eof_before_end_of_database_err :                                       & '         (*:nl:#*1 1160 'IMAGE 235 :  Not enough room in file for database' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1160 ;           &      eot_before_end_of_database_err :                                       & '         (*:nl:#*1 1161 'IMAGE 236 :  Not enough room on tape for database' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1161 ;           '      specified_lu_aint_interactive_err :                                      ' &         (*:nl:#*1 1162 'IMAGE 241 :  Prompt device must be interactive' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1162 ;           #      wrong_volume_mounted_err :                                       # !         (*:nl:#*1 1163 'IMAGE 242 :  Wrong volume was mounted' *) !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1163 ;           .      root_file_name_and_storage_name_dont_match_err :                                       . %         (*:nl:#*1 1164 'IMAGE 243 :  Root namr does not match storage' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1164 ;           ,      different_root_file_cartridge_specified_err :                                      , (         (*:nl:#*1 1165 'IMAGE 244 :  DBRST must put root on same cartridge' *)  (          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1165 ;                 dbrfr_clone_err :                                                (*:nl:#*1 1166 'IMAGE 245 : Cannot clone DBRFR' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1166 ;           "      program_was_broken_err :                                       "          (*:nl:#*1 1167 'IMAGE 247 :  Program was broken' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1167 ;           *      illegal_abort_option_in_run_string_err :                                       *          (*:nl:#*1 1168 'IMAGE 248 :  Illegal abort option' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1168 ;           %      illegal_statistics_option_err :                                      % !         (*:nl:#*1 1169 'IMAGE 249 : Illegal statistics option' *) !          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1169 ;                  no_such_command_err :                                                 (*:nl:#*1 1170 'IMAGE 250 :  No such command' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1170 ;           "      maint_word_required_err :                                      " '         (*:nl:#*1 1171 'IMAGE 251 :  IMAGE maintenance password is needed' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1171 ;                  yes_no_required_err :                                                 (*:nl:#*1 1172 'IMAGE 252 :  YES or NO required' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1172 ;           !      illegal_lu_number_err :                                      !          (*:nl:#*1 1173 'IMAGE 253 :  Illegal LU number' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1173 ;                  illegal_option_err :                                         $         (*:nl:#*1 1174 'IMAGE 254 :  Optional parameter was illegal' *) $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1174 ;           "      illegal_numb_parms_err :                                       "           (*:nl:#*1 1175 'IMAGE 255 :  Not enough parameters' *)             (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1175 ;           "      too_many_parameters_err :                                      "          (*:nl:#*1 1176 'IMAGE 256 :  Too many parameters' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1176 ;           "      parameter_too_long_err :                                       "          (*:nl:#*1 1177 'IMAGE 257 :  Parameter too long' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1177 ;           "      illegal_recov_time_err :                                       " #         (*:nl:#*1 1178 'IMAGE 258 :  Do soft crash recovery first' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1178 ;           !      invalid_database_err :                                       ! &         (*:nl:#*1 1179 'IMAGE 259 :  Parameter was not a database namr' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1179 ;           "      log_file_too_small_err :                                       " #         (*:nl:#*1 1180 'IMAGE 260 :  File size was below minimum' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1180 ;           !      illegal_parm_type_err :                                      ! "         (*:nl:#*1 1181 'IMAGE 261 :  Parameter not proper type' *)  "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1181 ;           #      no_previous_cmd_file_err :                                       # &         (*:nl:#*1 1182 'IMAGE 262 :  No file/device to transfer back to' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1182 ;           #      cannot_nest_cmd_file_err :                                       # %         (*:nl:#*1 1183 'IMAGE 263 :  Transfer files cannot be nested' *)  %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1183 ;           $      wrong_maintenance_word_err :                                       $ '         (*:nl:#*1 1184 'IMAGE 264 :  Wrong maintenance password was given' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1184 ;           $      mw_change_not_confirmed_err :                                      $ '         (*:nl:#*1 1185 'IMAGE 265 :  New maintenance password unconfirmed' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1185 ;           "      help_file_not_found_err :                                      " "         (*:nl:#*1 1186 'IMAGE 266 :  DBUTL help file not found' *)  "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1186 ;           "      no_help_information_err :                                      " %         (*:nl:#*1 1187 'IMAGE 267 :  No help information is available' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1187 ;                 image_active_err :                                        (         (*:nl:#*1 1188 'IMAGE 268 :  Command not useable when IMAGE active' *)  (          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1188 ;                 unknown_image_err :                                       '         (*:nl:#*1 1189 'IMAGE 269 :  Unknown IMAGE error:  Consult manual' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1189 ;                 unknown_fmp_err :                                       &         (*:nl:#*1 1190 'IMAGE 270 :  Unknown FMP error:  Consult manual' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1190 ;                 not_disc_file_err :                                       #         (*:nl:#*1 1191 'IMAGE 271 :  Parameter must be disc file' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1191 ;                 not_tape_file_err :                                       #         (*:nl:#*1 1192 'IMAGE 272 :  Parameter must be a magtape' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1192 ;           "      illegal_log_option_err :                                       " "         (*:nl:#*1 1193 'IMAGE 273 :  Logging option was invalid' *) "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1193 ;           !      illegal_file_size_err :                                      !           (*:nl:#*1 1194 'IMAGE 274 :  File size was illegal' *)             (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1194 ;           #      max_volumes_exceeded_err :                                       # '         (*:nl:#*1 1195 'IMAGE 275 :  Roll Forward Log history table full' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1195 ;           %      cannot_unlock_dbcon_file_err :                                       % #         (*:nl:#*1 1196 'IMAGE 276 :  DBCON resource unlock error' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1196 ;                  dbutl_internal_err :                                                  (*:nl:#*1 1197 'IMAGE 277 :  DBUTL internal error' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1197 ;                 dbcon_create_err :                                        "         (*:nl:#*1 1198 'IMAGE 278 :  Error creating DBCON file' *)  "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1198 ;           !      cannot_lock_dbcon_err :                                      ! "         (*:nl:#*1 1199 'IMAGE 279 :  DBCON resource lock error' *)  "          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1199 ;                 same_device_err :                                       $         (*:nl:#*1 1200 'IMAGE 280 :  Spare is same device as RF Log' *) $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1200 ;           !      program_schedule_err :                                       ! $         (*:nl:#*1 1201 'IMAGE 281 :  Program could not be scheduled' *) $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1201 ;                  bif_not_defined_err :                                        $         (*:nl:#*1 1202 'IMAGE 282 :  Before-image file not defined' *)  $          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1202 ;                  tlf_not_defined_err :                                        %         (*:nl:#*1 1203 'IMAGE 283 :  Transaction log file not defined' *) %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1203 ;                  rfl_not_defined_err :                                        %         (*:nl:#*1 1204 'IMAGE 284 :  Roll Forward log is not defined' *)  %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1204 ;                  dbmon_not_ready_err :                                                  (*:nl:#*1 1205 'IMAGE 285 :  DBMON not schedulable' *)             (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1205 ;                  dbspl_not_ready_err :                                                  (*:nl:#*1 1206 'IMAGE 286 :  DBSPL not schedulable' *)             (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1206 ;                  DBCLN_not_ready_err :                                                  (*:nl:#*1 1207 'IMAGE 287 :  DBCLN not schedulable' *)             (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1207 ;           !      volume_not_found_err :                                       !          (*:nl:#*1 1208 'IMAGE 288 :  Volume not found' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1208 ;                 dbutl_cloning_err :                                                 (*:nl:#*1 1209 'IMAGE 289 :  DBUTL cannot be cloned' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1209 ;           $      IMAGE_must_be_shut_down_err :                                      $ '         (*:nl:#*1 1210 'IMAGE 290 :  Cannot execute while IMAGE is active' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1210 ;           $      illegal_during_shutdown_err :                                      $ '         (*:nl:#*1 1211 'IMAGE 291 :  Cannot execute while IMAGE shutdown' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1211 ;           !      missing_parameter_err :                                      !          (*:nl:#*1 1212 'IMAGE 293 :  Missing parameter' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1212 ;                 scratch_file_err :                                               (*:nl:#*1 1213 'IMAGE 294 :  Scratch file error' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1213 ;           "      new_log_set_required_err :                                     " #         (*:nl:#*1 1214 'IMAGE 295 :  New log set must be defined' *)  #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1214 ;           #      illegal_log_set_name_err :                                       # '         (*:nl:#*1 1215 'IMAGE 296 :  Old log set name cannot be specified' *) '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1215 ;                 spare_rename_err :                                               (*:nl:#*1 1216 'IMAGE 297 :  FMP rename error' *)           (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1216 ;                 DBCLN_comm_err  :                                                (*:nl:#*1 1217 'IMAGE 298 :  DBCLN is not active' *)            (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1217 ;           "      illegal_after_crash_err  :                                     " &         (*:nl:#*1 1218 'IMAGE 299 :  Illegal command after crash occurs' *) &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1218 ;           %      cant_archive_current_rfl_err  :                                      % '         (*:nl:#*1 1219 'IMAGE 300 :  Cannot archive the current rfl file' *)  '          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1219 ;           !      illegal_file_type_err  :                                     ! &         (*:nl:#*1 1220 'IMAGE 301 :  Illegal type for list or log file' *)  &          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1220 ;                 mon_samurai_err :   #         (*:nl:#*1 1221 'IMAGE 396 : DBMON VM file needs more room' *) #          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1221 ;           
      cleanup_err :  
 %         (*:nl:#*1 1222 'IMAGE 183 : Resources could not be recovered' *)  %          (*:nl:$COPY '         msgnum := # ;' *)           msgnum := 1222 ;                 OTHERWISE BEGIN            (*:nl:#*1 1223 'Unexpected non-IMAGE error  ' *)            (*:nl:$COPY '      length := nlread (&, #' *)        length := nlread (MDPERR, 1223                                  , nlerr, temp_string, len);   $         blank_pad (temp_string, chars_in_long_str, length);  (* NLS *)  $ #         short_int_to_readable_short_str (error_code, temp_short_str); #          append_blank_and_str (temp_string, temp_short_str);  	         goto 99;  	          END;             END; (* case *)              (* write message to log file *)     (*:nl:$COPY '   length := nlread (&, msgnum' *)     length := nlread (MDPERR, msgnum                          , nlerr, temp_string, len);  !   blank_pad (temp_string, chars_in_long_str, length);  (* NLS *)  ! !99:IF write_long_str (log_file, temp_string, return_status) THEN;  !     END; (* issue_error *)  .  