$PASCAL ',3,99 92081-16770 REV.5000'$      $ Heap 0 $ $ Recursive OFF $  $ Range ON $  	$ Run_String 128 $ 	     PROGRAM data_base_space   $ Alias 'DBSPA' $;      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18770                                        *)   (* RELOC:   92081-16770                                        *)   (*                                                             *)   (* PGMR:        <MRL>  <TH> for NLS                            *)   (*                                                             *)   (* Date last modified: <870501.1107>  (*                                                             *)   (***************************************************************)       (***************************************************************)   (*                                                             *)   (* Scheduling DBSPA:                                           *)   (*                                                             *)   (*    RU,DBSPA,prompt,list,root,level                          *)   (*                                                             *)   (* PROMPT must be interactive.                                 *)   (* LIST   is where DBULD output goes.                          *)   (* ROOT   is the database rootfile name.                       *)   (* LEVEL  is the database level word to open the DB.           *)   (*                                                             *)   (* Defaults:                                                   *)   (*    PROMPT  : the scheduling LU, typically LU 1.             *)   (*    LIST    : the scheduling LU.                             *)   (*    ROOT and LEVEL are not defaultable and                   *)   (*       are prompted for if omitted from the run string.      *)   (*                                                             *)   (* Overall program flow:                                       *)   (*                                                             *)   (*    1. Process the runstring parameters.                     *)   (*       Get the root file name and level word if not included *)   (*        in the runstring.                                    *)   (*                                                             *)   (*    2. Open the database.                                    *)   (*       If the database can be opened read-only, that's great.*)   (*       If the database must be opened mode 5, only display   *)   (*        the quick information.                               *)   (*                                                             *)   (*    3. Display the quick information from DBINF calls.       *)   (*                                                             *)   (*    4. If the database is read-only, do a serial read of     *)   (*        everything and print mis-match information.          *)   (*                                                             *)   (*    5. Close the database, input and list files.             *)   (*                                                             *)   (***************************************************************)       (**) %(*:nl:$ATB, mdbspa, %sa000, relocatable, 92081-16076 REV.5000 <870501.1107> %(*:nl:$ (*:nl:$LANGID,0 (*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)  (**)  %(*:nl:$ '        SOURCE MESSAGE CATALOG                                  ' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '* (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984.  ALL RIGHTS      *' % %(*:nl:$ '* RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *' % %(*:nl:$ '* REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT *' % %(*:nl:$ '* THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        *' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '                                                                ' % %(*:nl:$ '                           SOURCE:   92081-18076                ' % %(*:nl:$ '         S. MESSAGE CATALOG NAME :   <SA000                     ' % %(*:nl:$ '                            RELOC:   92081-16076                ' % %(*:nl:$ '         B. MESSAGE CATALOG NAME :   %SA000                     ' % %(*:nl:$ '                            PGMR :   TH                         ' % %(*:nl:$ '         REV.5000 <870501.1107>                                 ' %(*:nl:$  (*:nl:$ '*NOTE*'  %(*:nl:$ 'All the messages in DBSPA must be within the number of chars_in ' % %(*:nl:$ 'long_str -1 (=127 bytes).                                       ' %(*:nl:$ (*:nl:$  (**)         LABEL 999; (* termination exit *)     $ List OFF, Include '[IMAGE', List ON $      TYPE     ibase_type = RECORD       node : short_int; 
      root : new_file_name; 
   END;            istat_type = ARRAY [1..10] OF short_int;        set_list_type = RECORD 
      num_sets : short_int; 
      set_nums : ARRAY [1..max_data_sets] OF short_int;        END;         set_kind_type = PACKED RECORD       kind_of_set : char;       blank       : char;        END;        set_info_type = RECORD 
      set_name : short_str; 
      set_kind : set_kind_type; 
      ent_len  : short_int; 
      unused   : ARRAY [1..3] OF short_int;       entries  : long_int; (* in use *)  
      capacity : long_int; 
       END;         rmpar_type = ARRAY [1..5] OF short_int;         VAR     input_file : file_descriptor;     list_file  : file_descriptor;     
   ibase      : ibase_type; 

   istat      : istat_type; 
        set_list   : set_list_type;     set_info   : set_info_type;      
   last_error : short_int; 
     "   clean_db   : boolean;  (* true if database is opened read-only *) " 
   level      : short_str; 
        nlerr      : short_int;(* NLS error code *)     length     : short_int;(* NLS actual read length *)     temp_str   : long_str; (* NLS message buffer *)     temp1_str  : long_str; (* NLS message buffer *)      $ Page $ "(*******************************************************************) ""(*                    Main external definitions                    *) ""(*******************************************************************) "    $ List OFF, Include '[XDFMP', List ON $ $ List OFF, Include '[XDSMR', List ON $ $ List OFF, Include '[XUSHF', List ON $  $ List OFF, Include '[XDNLS', List ON $  (* NLS externals *)     PROCEDURE get_program_name  $ Alias 'PNAME' $     (VAR program_name : short_str);     EXTERNAL;          (* Returns status info to the scheduler *)  PROCEDURE prtn    (rmpars : rmpar_type);     EXTERNAL;          PROCEDURE upshift_new_file_name  $ Alias 'Upshift' $    (    name : new_file_name;     VAR upshifted_name : new_file_name;  
        len  : short_int); 
    EXTERNAL;         PROCEDURE dbopn 
   (VAR ibase : ibase_type; 
 
        level : short_str; 
 
        mode  : short_int; 
     VAR istat : istat_type);     EXTERNAL;          PROCEDURE dbinf_mode203  $ Alias 'DBINF' $ 
   (VAR ibase : ibase_type; 
 
        setid : short_int; 
 
        mode  : short_int; 

    VAR istat : istat_type; 
    VAR buffer: set_list_type);     EXTERNAL;      PROCEDURE dbinf_mode202  $ Alias 'DBINF' $ 
   (VAR ibase : ibase_type; 
 
        setid : short_int; 
 
        mode  : short_int; 

    VAR istat : istat_type; 
    VAR buffer: set_info_type);     EXTERNAL;          PROCEDURE dbget  $ Alias 'DBGET' $ 
   (VAR ibase : ibase_type; 
 
        setid : short_int; 
 
        mode  : short_int; 

    VAR istat : istat_type; 
 "        list  : short_int;   (* will be zero, i.e. no data wanted *) "     VAR buffer: short_int;   (* No data actually returned *)         arg   : long_int);   (* record number to get *)     EXTERNAL;         PROCEDURE dbcls 
   (VAR ibase : ibase_type; 
 
        dummy : short_int; 
 
        mode  : short_int; 
     VAR istat : istat_type);     EXTERNAL;      FUNCTION ifbrk     (dummy : short_int) : short_int; (* -1 means break flag set *)      EXTERNAL;     FUNCTION get_file_parm   $ Alias 'Pas.Parameters' $    (    parm_pos : short_int;     VAR parm_buf : new_file_name;          parm_len : short_int) : short_int;     EXTERNAL;      FUNCTION get_level_parm   $ Alias 'Pas.Parameters' $    (    parm_pos : short_int;     VAR parm_buf : short_str;          parm_len : short_int) : short_int;     EXTERNAL;     #(*:nl:$COPY 'PROCEDURE &; EXTERNAL;'* Declaration for message module *) #PROCEDURE MDBSPA; EXTERNAL;                                          $ Page $ "(*******************************************************************) ""(*                    DBSPA internal procedures                    *) ""(*******************************************************************) "    "(*******************************************************************) ""(*                    terminate_dbspa                              *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To close the database and various files.                     *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE terminate_dbspa  $ Alias 'DBSPA.Terminate' $;     VAR     status : short_int;     dummy  : short_int;    rmpars : rmpar_type;     
BEGIN (* terminate_dbspa *) 
    
   (* Close the database *) 
    dbcls (ibase, dummy, one, istat);         (* write a wrap-up message *)     IF write_long_str (input_file,' ',status) THEN;  #(* IF write_long_str (input_file, ' DBSPA finished.', status) THEN; *) #       (*:nl:#*1 1000 ' DBSPA finished.' *)    (*:nl:$COPY '   length := nlread (&, #' *)    length := nlread (MDBSPA, 1000      "                              , nlerr, temp_str, chars_in_long_str); "    blank_pad (temp_str, chars_in_long_str, length);  (* NLS *)        IF write_long_str (input_file, temp_str, status) THEN;        (* close input/output files *)    IF close_file (input_file, status) THEN;     IF close_file (list_file, status) THEN;      !   (* Return the last error to the scheduler in first PRTN word *) !    
   rmpars[1] := last_error; 
   prtn (rmpars);        (* Done!! *)      
END; (* terminate_dbspa *) 
 $ Page $ "(*******************************************************************) ""(*                           fatal_error                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To display a meaningful error message.                       *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) The file name on which the error was encountered.  *) ""(*    (in)  (2) The error number.                                  *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE fatal_error  $ Alias 'DBSPA.FatalErr' $     (VAR file_desc : file_descriptor;         error     : short_int);     VAR    display_string : long_str;     status         : short_int;     number_string  : short_str;             BEGIN (* fatal_error *)        last_error := error;     (* display_string := ' Error'; *)         short_int_to_readable_short_str (error, number_string);     null_pad (number_string, chars_in_short_str);     (* append_blank_and_str (display_string, number_string); *)      (* append_str (display_string, ' on file'); *)     (* long_dest_file_srce (display_string, chars_in_long_str, *)     long_dest_file_srce (temp_str, chars_in_long_str,                           file_desc.newfl, chars_in_new_file_name,                           str_assign, zero);        null_pad_lstr (temp_str, chars_in_long_str);        (*:nl:$ ' ' *)    (*:nl:$ ' !1 is an error number, !2 is a filename ' *)    (*:nl:#*1 1001 ' Error !1 on file !2' *)  $   (*:nl:$COPY '   length := nlread_sl (&, #, nlerr, display_string,' *) $    length := nlread_sl (MDBSPA, 1001, nlerr, display_string,                    chars_in_long_str, number_string, temp_str);    blank_pad (display_string, chars_in_long_str, length);     IF write_long_str (list_file, display_string, status) THEN;         GOTO 999;      END; (* fatal_error *)  $ Page $ "(*******************************************************************) ""(*                       dbase_error                               *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To return a meaningful database error message.               *) ""(*    Any IMAGE error is considered fatal.                         *) ""(*                                                                 *) ""(* Parameters:                                                     *) ""(*    (in)  (1) Description of the call with an error.             *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE dbase_error  $ Alias 'DBSPA.DBError' $ (* (message : short_str);  *)    (message : long_str);      (* NLS *)     VAR    display_string : long_str;     number_string  : short_str;     status         : short_int;         BEGIN (* dbase_error *)         last_error := istat[one];     (* display_string := ' Error'; *)        short_int_to_readable_short_str (istat[one], number_string);     null_pad (number_string, chars_in_short_str);     (* append_blank_and_str (display_string, number_string); *)     (* append_str (display_string, ' with'); *)     (* append_blank_and_str (display_string, message); *)      (*:nl:$ ' ' *)  (*:nl:$ ' !1 is an error number, !2 is an error message ' *) (*:nl:#*1 1002 ' Error !1 with !2' *)  #(*:nl:$COPY '   length := nlread_sl (&, #, nlerr, display_string, ' *) #    length := nlread_sl (MDBSPA, 1002, nlerr, display_string,                         chars_in_long_str, number_string, message);    blank_pad (display_string, chars_in_long_str, length);    IF write_long_str (input_file, ' ', status) OR       write_long_str (input_file, display_string, status)        THEN fatal_error (input_file, status);         GOTO 999;      END; (* dbase_error *)  $ Page $ "(*******************************************************************) ""(*                       process_runstring                         *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To parse the runstring parameters, make defaults where       *) ""(*    appropriate, and prompt for ommitted parameters.             *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE process_runstring  $ Alias 'DBSPA.RunString' $;     VAR     status : short_int;    temp_file : file_descriptor;     temp_str  : long_str;    len       : short_int;         PROCEDURE CHECK_RUN_STRING;       BEGIN                 { prevent overwriting root file }                (*:nl:#*1 1003 ' Check run string.' *)                (*:nl:$COPY '   length := nlread (&, #' *)                length := nlread (MDBSPA, 1003  "                              , nlerr, temp_str, chars_in_long_str); " %               blank_pad (temp_str, chars_in_long_str, length);  (* NLS *) %    "               IF write_long_str (input_file, temp_str, status) THEN; "                   LAST_ERROR := ILLEGAL_FILE_TYPE_ERR;        END;     BEGIN (* process_runstring *)          last_error := no_image_err;  (* Assume no error will occur *)         (* Open a default list file (scheduling terminal) *)     default_file (list_file.newfl);    IF open_file_for_write (list_file, status) THEN;        (* Get the input file name, and open it *)  %   IF get_file_parm (one, TEMP_file.newfl, chars_in_new_file_name) <= zero %       THEN default_file (TEMP_file.newfl);         { has to be an lu }    IF (NOT FMP_OPEN_HANDLER (TEMP_file, 'ROS', status)) AND       ( TEMP_file.dcb.dcb_header[2] = 0) then       BEGIN           IF close_file (TEMP_file, status) then;       END    ELSE           begin             IF STATUS = ILLEGAL_LU_ERR THEN                LAST_ERROR := ILLEGAL_LU_ERR              ELSE                LAST_ERROR := SPECIFIED_LU_AINT_INTERACTIVE_ERR;                  default_file (input_file.newfl);                  IF open_existing_file (input_file, status)             THEN fatal_error (input_file,status);                 FATAL_ERROR (TEMP_FILE,LAST_ERROR); 
            goto 999; 
         end;        INPUT_FILE.NEWFL := TEMP_FILE.NEWFL;        IF open_existing_file (input_file, status)       THEN fatal_error (input_file,status);            (* Get the list file name and open it *) #   IF get_file_parm (2, temp_file.newfl, chars_in_new_file_name) > zero #       THEN BEGIN            IF NOT FMP_OPEN_HANDLER (temp_file, 'ROS', status) THEN   #            IF (STATUS = 0) AND (TEMP_FILE.DCB.DCB_HEADER[2] <> 3) AND #               (TEMP_FILE.DCB.DCB_HEADER[2] <> 4) AND                 (TEMP_FILE.DCB.DCB_HEADER[2] <> 0) THEN BEGIN                     check_run_string;                 GOTO 999;              END;           IF CLOSE_FILE (TEMP_FILE, STATUS) THEN;              IF open_file_for_write (temp_file, status)          THEN fatal_error (temp_file, status) 	         ELSE BEGIN 	            IF close_file (temp_file, status) THEN;             list_file.newfl := temp_file.newfl;              IF open_file_for_write (list_file, status) THEN; 
            END; (* else *) 
           (* if defaulted, we already have the default open *)        END;        (* Get the root file name *) !   IF get_file_parm (3, ibase.root, chars_in_new_file_name) <= zero ! &(*    THEN IF write_long_str (input_file, 'Root file name? _', status) OR *) &           THEN BEGIN       (*:nl:#*1 1004 'Root file name? _' *) "      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str,' *) "       length := nlread (MDBSPA, 1004, nlerr, temp_str,                                 chars_in_long_str);        blank_pad (temp_str, chars_in_long_str, length);               IF write_long_str (input_file, temp_str, status) OR                read_long_str (input_file, temp_str, status)           THEN fatal_error (input_file, status)  #         ELSE file_dest_long_srce (ibase.root, chars_in_new_file_name, #                                   temp_str, chars_in_long_str,                                    str_assign, zero);        END;  (* THEN *)      %   upshift_new_file_name (ibase.root, ibase.root, chars_in_new_file_name); %        
   (* Get the level word *) 
   IF get_level_parm (4, level, chars_in_short_str) <= zero &(*    THEN IF write_long_str (input_file, 'Level code word? _', status) OR *) &           THEN BEGIN        (*:nl:#*1 1005 'Level code word? _' *)  #      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str, ' *) #      length := nlread (MDBSPA, 1005, nlerr, temp_str,                                  chars_in_long_str);        blank_pad (temp_str, chars_in_long_str, length);       IF write_long_str (input_file, temp_str, status) OR                read_short_str (input_file, level, status)          THEN fatal_error (input_file, status);        END;         upshift_short_str (level, level, chars_in_short_str);             
   (* Ok, we got it all! *) 
     END; (* process_runstring *)  $ Page $ "(*******************************************************************) ""(*                       open_database                             *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To open the database in the most desirable or necessary      *) ""(*    mode, and collect the list of accessible data sets.          *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE open_database  $ Alias 'DBSPA.OpenDB' $;     LABEL    91,92;  (* NLS test *)     VAR  
   dummy      : short_int; 
 
   setx       : short_int; 
    BEGIN (* open_database *)            clean_db := true; (* Assume we get read-only DB *)        ibase.node := 8224; (* two blanks *)        (* first try to open read-only shared *)     dbopn (ibase, level, 8, istat);        IF istat[one] = db_incompatible_open_mode_err THEN BEGIN        (* then try read-only shared with writers *)       dbopn (ibase, level, 5, istat);        clean_db := false;        END;         IF istat[one] <> no_image_err  (*    THEN dbase_error ('DBOPN'); *)        THEN BEGIN           (*:nl:#*1 1006 'DBOPN' *)  &         (*:nl:$COPY '91:      length := nlread (&, #, nlerr, temp_str, ' *) & 91:      length := nlread (MDBSPA, 1006, nlerr, temp_str,                              chars_in_long_str);          (* put terminator of parameter substitution for NLS *)           temp_str[length + 1] := chr(0);           dbase_error (temp_str);          END;        (* Get the data set number list *)         dbinf_mode203 (ibase, dummy, 203, istat, set_list);     IF istat[one] <> no_image_err (*    THEN dbase_error ('DBINF mode 203'); *)        THEN BEGIN          (*:nl:#*1 1007 'DBINF mode 203' *)  &         (*:nl:$COPY '92:      length := nlread (&, #, nlerr, temp_str, ' *) & 92:      length := nlread (MDBSPA, 1007, nlerr, temp_str,                                chars_in_long_str);          (* put terminator of parameter substitution for NLS *)           temp_str[length + 1] := chr(0);           dbase_error (temp_str);        END;         (* Make all the set numbers positive *) 	   WITH set_list DO 	   FOR setx := one TO num_sets DO        set_nums[setx] := abs(set_nums[setx]);        (* All done with opening the DB *)      END; (* open_database *)  $ Page $ "(*******************************************************************) ""(*                       do_quick_report                           *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To display information which is quickly obtained through     *) ""(*    DBINF calls.  Corruption lookup is done later.               *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "    PROCEDURE  do_quick_report  $ Alias 'DBSPA.QuickRep' $;     LABEL  
   91;      (* NLS test *) 
    VAR    display_string : long_str;     status         : short_int;     number_string  : short_str;     percent        : short_int;      
   setx : short_int; 
    
BEGIN (* do_quick_report *) 
       (* do a top-of-page on the list *)        IF write_long_str (list_file, '1', status)       THEN fatal_error (list_file, status);         (* write out the report header *)  
(* display_string := 
 #      ' Set name   Capacity   Free records   %Used   Used records'; *) # (*:nl:$ ' ' *) $(*:nl:$ ' The column positions can't be changed in the next messages.' *) $ '(*:nl:#*1 1008 ' Set name   Capacity   Free records   ~%Used   Used records'*) ' &      (*:nl:$COPY '      length := nlread (&, #, nlerr, display_string, ' *) &       length := nlread (MDBSPA, 1008, nlerr, display_string,                                 chars_in_long_str);        blank_pad (display_string, chars_in_long_str, length);     IF write_long_str (list_file, display_string, status)       THEN fatal_error (list_file, status);         (* For each set in the list, print its quick stats *)         FOR setx := one TO set_list.num_sets DO BEGIN            display_string := ' ';     %      dbinf_mode202 (ibase, set_list.set_nums[setx], 202, istat, set_info); %      IF istat[one] <> no_image_err (*       THEN dbase_error ('DBINF')  *) 	         THEN BEGIN 	         (*:nl:#*1 1009 'DBINF' )  &         (*:nl:$COPY '91:      length := nlread (&, #, nlerr, temp_str, ' *) & 91:      length := nlread (MDBSPA, 1009, nlerr, temp_str,                              chars_in_long_str);          (* put terminator of parameter substitution for NLS *)           temp_str[length + 1] := chr(0);           dbase_error (temp_str);          END (* THEN *)      !      ELSE WITH set_info DO BEGIN (* construct the display line *) !             append_blank_and_str (display_string, set_name);      !         long_int_to_readable_short_str (capacity, number_string); !              long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, 13);      %         long_int_to_readable_short_str (capacity-entries, number_string); %              long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, 24);              percent := (entries*100) DIV capacity;      !         short_int_to_readable_short_str (percent, number_string); !              long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, 39);               long_int_to_readable_short_str (entries, number_string);                long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, 47);               IF write_long_str (list_file, display_string, status)             THEN fatal_error (list_file, status);               END; (* else *)      
      END; (* for *) 
        (* End of quick report *)          
END; (* do_quick_report *) 
 $ Page $ "(*******************************************************************) ""(*                     do_slow_report                              *) ""(*******************************************************************) ""(*                                                                 *) ""(* Purpose:                                                        *) ""(*    To perform a serial read of each data set and report         *) ""(*    any discrepencies between DBINF's info and the actual        *) ""(*    number of used records in the data set.                      *) ""(*                                                                 *) ""(* Parameters: None.                                               *) ""(*                                                                 *) ""(*******************************************************************) "     PROCEDURE do_slow_report  $ Alias 'DBSPA.SlowRep' $;     LABEL    91,92,93;   (* NLS test *)     VAR    display_string : long_str;     number_string  : short_str;     status         : short_int;     program_name   : short_str;        serial_count   : long_int;     dummy          : short_int;     setx           : short_int;      
BEGIN (* do_slow_report *) 
     !   (* Only do the slow report if the database is open read-only *) !   IF NOT clean_db THEN BEGIN (*    display_string :=           ' DBSPA: Data base corruption scan will not be done'; *)   &      (*:nl:#*1 1010 ' DBSPA: Data base corruption scan will not be done' *) & &      (*:nl:$COPY '      length := nlread (&, #, nlerr, display_string, ' *) &       length := nlread (MDBSPA, 1010, nlerr, display_string,                               chars_in_long_str);        blank_pad (display_string, chars_in_long_str, length);        IF write_long_str (input_file, ' ', status) OR           write_long_str (input_file, display_string, status)          THEN fatal_error (input_file, status);     (*    display_string := "         '        since the data base is open to another program'; *) "$      (*:nl:#*1 1011 '        since the data base is open to another&' *) $       (*:nl:#        ' program' *)  &      (*:nl:$COPY '      length := nlread (&, #, nlerr, display_string, ' *) &       length := nlread (MDBSPA, 1011, nlerr, display_string,                               chars_in_long_str);        blank_pad (display_string, chars_in_long_str, length);        IF write_long_str (input_file, display_string, status)          THEN fatal_error (input_file, status);           GOTO 999; (* terminate *)        END;             (* Let the user know we are beginning the serial read phase *)       (*:nl:#*1 1012 ' DBSPA: Beginning serial read of database' *)   #   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, ' *) #    length := nlread (MDBSPA, 1012, nlerr, display_string,                            chars_in_long_str);    blank_pad (display_string, chars_in_long_str, length);        IF write_long_str (input_file, ' ', status) OR       write_long_str (input_file, "(*                    ' DBSPA: Beginning serial read of database', *) "                      display_string,                       status)        THEN fatal_error (input_file, status);      #   (* First, let the user know that he can break DBSPA if he wishes *) #   program_name := ' ';    get_program_name (program_name);  '(* display_string := ' DBSPA: You can break DBSPA with the command ''BR,';  *) '$   (*:nl:#*1 1013 ' DBSPA: You can break DBSPA with the command ''BR,' *) $ #   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, ' *) #    length := nlread (MDBSPA, 1013, nlerr, display_string,                            chars_in_long_str);    blank_pad (display_string, chars_in_long_str, length);    append_str (display_string, program_name);     append_str (display_string,'''');        IF write_long_str (input_file, display_string, status)        THEN fatal_error (input_file, status);             (* Do a top-of-form on the list file *)    IF write_long_str (list_file, '1', status)       THEN fatal_error (list_file, status);        (* Write the header for the slow report *)        (*:nl:$ ' ' *) %   (*:nl:$ ' The column positions can't be changed in the next message.' *) %&   (*:nl:#*1 1014 ' Set name   Used records   Serially read   Difference&' *) &    (*:nl:#        '   Corrupt?' *)  #   (*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, ' *) #    length := nlread (MDBSPA, 1014, nlerr, display_string,                            chars_in_long_str);    blank_pad (display_string, chars_in_long_str, length);         IF write_long_str (list_file,  &(*    ' Set name   Used records   Serially read   Difference   Corrupt?', *) &
      display_string, 
      status) THEN fatal_error (list_file, status);     &   (* For each data set, get its DBINF status and compare with serial read *) &    FOR setx := one TO set_list.num_sets DO BEGIN     
      serial_count := zero; 
          (* Reset data set to BOF *)  "      dbget (ibase, set_list.set_nums[setx], 4, istat, 0, dummy, 0); "      IF istat[one] <> no_image_err  (*       THEN dbase_error ('DBGET mode 4'); *) 	         THEN BEGIN 	             (*:nl:#*1 1015 'DBGET mode 4' *)  "            (*:nl:$COPY '91:      length := nlread (&, #, nlerr, '*) "91:      length := nlread (MDBSPA, 1015, nlerr,                                   temp_str, chars_in_long_str);  !            (* put terminator of parameter substitution for NLS *) !            temp_str[length + 1] := chr(0);             dbase_error (temp_str);          END;           (* Now do a serial read of all records *)        REPEAT               (* If the user sets the break flag, then terminate *)           IF ifbrk(dummy) = -1 THEN GOTO 999;     #         dbget (ibase, set_list.set_nums[setx], 2, istat, 0, dummy, 0); #          IF (istat[one] <> no_image_err)             THEN IF (istat[one] <> bof_eof_err) (*             THEN dbase_error ('DBGET mode 2')   *)                THEN BEGIN                (*:nl:#*1 1016 'DBGET mode 2' *) &               (*:nl:$COPY '92:            length := nlread (&, #, nlerr, '*) &92:            length := nlread (MDBSPA, 1016, nlerr,                               temp_str, chars_in_long_str); "               (* put terminator of parameter substitution for NLS *) "                temp_str[length + 1] := chr(0);                 dbase_error (temp_str);                 END  (* THEN *)                 ELSE (* do nothing *)              ELSE serial_count := serial_count + one;               UNTIL istat[one] = bof_eof_err;               (* Now get the DBINF information for the set *)     %      dbinf_mode202 (ibase, set_list.set_nums[setx], 202, istat, set_info); %      IF (istat[one] <> no_image_err) (*       THEN dbase_error ('DBINF mode 202');  *) 	         THEN BEGIN 	         (*:nl:#*1 1017 'DBINF mode 202' *)           (*:nl:$COPY '93:      length := nlread (&, #, nlerr, '*)  93:      length := nlread (MDBSPA, 1017, nlerr,                             temp_str, chars_in_long_str);          (* put terminator of parameter substitution for NLS *)           temp_str[length + 1] := chr(0);           dbase_error (temp_str);           END; (* THEN *)            display_string := ' ';            WITH set_info DO BEGIN          append_blank_and_str (display_string, set_name);               long_int_to_readable_short_str (entries, number_string);                long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, 13);      #         long_int_to_readable_short_str (serial_count, number_string); #              long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, 28);     &         long_int_to_readable_short_str (entries-serial_count,number_string); &              long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, 44);               (* Compare serial_count with used entries in set *)          IF serial_count = set_info.entries (*          THEN number_string := 'NO' *) (* not corrupt *)              THEN BEGIN  
            (*:nl:$ ' ' *) 
"            (*:nl:$ ' The next message should be within 15 bytes.' *) "             (*:nl:#*1 1018 'NO' *) (* not corrupt *)  %            (*:nl:$COPY '            length := nlread_s (&, #, nlerr, ' *) %            length := nlread_s (MDBSPA, 1018, nlerr,                                  number_string, chars_in_short_str);  "            blank_pad_s (number_string, chars_in_short_str, length); "            END              ELSE BEGIN  
            (*:nl:$ ' ' *) 
"            (*:nl:$ ' The next message should be within 15 bytes.' *) "            (*:nl:#*1 1019 'YES~!' *) (* corrupt *)  %            (*:nl:$COPY '            length := nlread_s (&, #, nlerr, ' *) %            length := nlread_s (MDBSPA, 1019, nlerr,                                  number_string, chars_in_short_str);  "            blank_pad_s (number_string, chars_in_short_str, length); ""            last_error := db_corrupt_err;  (* returned in $RETURN1 *) "             END;               long_dest_short_srce (display_string, chars_in_long_str,                                  number_string, chars_in_short_str,                                  str_overlay, 57);               END; (* with *)           IF write_long_str (list_file, display_string, status)           THEN fatal_error (list_file, status);           END; (* for each set *)     END; (* do_slow_report *)  $ Page $ "(*******************************************************************) ""(*                    Main program of DBSPA                        *) ""(*******************************************************************) "     BEGIN (* main *)        (**)     (* Process the runstring.    (**)     
   process_runstring; 
       open_database;     	   do_quick_report; 	     	   do_slow_report; 	     999: (* termination label *)     	   terminate_dbspa; 	     END. (* end program DBSPA *) 