 $PASCAL ',7 92081-1X655 REV.2540' $       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18655                                        *)  ! !(* RELOC:   92081-1X655                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! !(*          NLS localized by TH                                *)  ! !(*                                                             *)  ! (* Date last modified: <860131.1127>  !(*                                                             *)  ! !(* Fixed bug, January 1986 - DBDS would not accept 'special'   *)  ! !(*    characters (like !"#$%&'^@*?<>) as the first character   *)  ! !(*    of an item name, which the old DBDS did.  Furthermore,   *)  ! !(*    whether underscore was usable was ambiguous according    *)  ! !(*    to the manual 'Conventions' section.  Underscore is      *)  ! !(*    now accepted.                                            *)  ! !(*                                                             *)  ! !(***************************************************************)  !     (**)  (*:nl:$   &(*:nl:$ATB mdbds_suba %db000 relocatable, 92081-16069 REV.2540 <860131.1127> & (*:nl:$   (*:nl:$COUNTER 1 1000 1   (**)      $ List ON $   $ Heap 2 $  $ Range ON $  	$ Recursive OFF $  	 	$ Heapparms OFF $  	 $ Subprogram $      PROGRAM dbds_subs_for_segment_one;      #(*******************************************************************)  # #(*                      global constants and types                 *)  # #(*******************************************************************)  #     $ List OFF, Include '[IMAGE', List ON $   $ List OFF, Include '[DBDS ', List ON $       TYPE     rmpar_array_type = ARRAY [1..5] OF short_int;      $ Page $      #(*******************************************************************)  # #(*                   External definitions                          *)  # #(*******************************************************************)  #     $ List OFF, Include '[XDBDS', List ON $   $ List OFF, Include '[XDFMP', List ON $   $ List OFF, Include '[XUSHF', List ON $   $ List OFF, Include '[XDSMR', List ON $           PROCEDURE prtn   (* return parms to scheduler *)     (prtn_values : rmpar_array_type);     EXTERNAL;          FUNCTION get_parameter  $ Alias 'Pas.Parameters' $     (    parm_number : short_int;      VAR result      : new_file_name;  !        max_length  : short_int) : short_int; (* actual length *)  !    EXTERNAL;      (* The external declarations for NLS below *)       (*:nl:$COPY 'PROCEDURE &; EXTERNAL;'*)  PROCEDURE MDBDS_SUBA; EXTERNAL;       FUNCTION  nlread $ Alias 'NLREADREL' $  
   (PROCEDURE ext_module ; 
         msgnum   : short_int;           nlerror  : short_int;       VAR nlsbuff_string : long_str;          nllength : short_int) : short_int;     EXTERNAL;      FUNCTION get_langid  $ Alias 'NLLangId' $      : short_int;      EXTERNAL;      PROCEDURE get_langtable  $ Alias 'NLInfo' $      (    item_num : short_int;       VAR table    : nltable;           lang_num : short_int;       VAR error    : short_int);     EXTERNAL;      $ Heapparms ON $ (* must be turned on *)  $ Page $  #(*******************************************************************)  # #(*                   initialize_dbds                               *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To open DBDS files (input and list), and initialize key      *)  # #(*    variables for the rest of DBDS processing.                   *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE initialize_dbds   $ Alias 'DBDS.Initialize' $;      VAR      status : short_int;     len    : short_int;         purge_option : new_file_name;      BEGIN (* initialize_dbds *)          (* Initialize key variables *)       
   numitems := zero; 
 
   numsets  := zero; 
    last_error:= zero;      error_count := zero;      largest_data:= zero;          (* Allocate EMA buffers for ITEM and SET tables *)      new (set_table_ptr);      new (item_table_ptr);             (* Use the default LU (user's terminal) for initial list *)         default_file(list_file.newfl);      IF open_file_for_write (list_file, status)         THEN fatal_error (list_file, status);              (* Get the input parameters.  Default to LU 1 *)       #   len := get_parameter (1,input_file.newfl, chars_in_new_file_name);  #        IF len <= zero THEN default_file (input_file.newfl);          IF open_existing_file (input_file, status)         THEN fatal_error (input_file, status);             (* Get the real list parameter: Default to LU 6 *)       #   len := get_parameter (2, list_file.newfl, chars_in_new_file_name);  #        IF len <= zero THEN list_file.newfl := '6';         IF open_file_for_write (list_file, status)         THEN fatal_error (list_file, status);          (* Do a top-of-form to get listing on a fresh page *)     IF write_long_str (list_file, '1', status)         THEN fatal_error (list_file, status);              (* Set up the default DBDS options *)         WITH dbds_options DO BEGIN         list     := true;         root     := true;         sets     := true;         table    := false;        field    := false;        checksum := false;        errs     := 100;        access   := read_write;         logging  := true;         purge    := false;            (* See if PURGE was specified in the run string *)             next_char := one; (* fudge in case of bad purge option *)               IF get_parameter(3,purge_option,chars_in_long_str) > zero    !         THEN IF (purge_option = 'PU') OR (purge_option = 'PURGE') !             THEN purge := true               ELSE nonfatal_error (dbds_illegal_purge_option_err);         END; (* with *)       #   next_char := chars_in_long_str + one; (* force a line to be read *) #            (* Get NLS upshifting tables *)         langid := get_langid;         (* If not English, get the shift-translation table *)     IF langid <> 0 THEN BEGIN        get_langtable (12, chara_table, langid, status);        IF status <> zero            THEN nonfatal_error (2999);        get_langtable (15, shift_table, langid, status);        IF status <> zero            THEN nonfatal_error (2999);        END; (* then *)       
END; (* initialize_dbds *) 
 $ Page $  #(*******************************************************************)  # #(*                     process_control_options                     *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To analyze the list of options after the $CONTROL: command.  *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #      PROCEDURE process_control_options  $ Alias 'DBDS.ControlOpts' $;       LABEL 99; (* when a semicolon is found *)       VAR      cur_token : tokens_type;       BEGIN (* process_control_options *)          REPEAT (* until a semicolon is encountered *)            cur_token := get_token;             IF cur_token = semicolon THEN GOTO 99;            IF cur_token <> alpha_token            THEN nonfatal_error (dbds_illegal_control_option_err)            (**)  
      (* Valid tokens are: 
       (* LIST or NOLIST, ERRORS, ROOT or NOROOT, SET or NOSET,  !      (* ACCESS, LOG or NOLOG, CHECKSUM, FIELD, TABLE or NOTABLE.  !       (**)            ELSE WITH dbds_options, current_token.identifier DO                IF      keyword = 'LIST'     THEN list := true            ELSE IF keyword = 'NOLIST'   THEN list := false           ELSE IF keyword = 'ROOT'     THEN root := true            ELSE IF keyword = 'NOROOT'   THEN root := false           ELSE IF keyword = 'SET'      THEN sets := true            ELSE IF keyword = 'NOSET'    THEN sets := false           ELSE IF keyword = 'LOG'      THEN logging := true           ELSE IF keyword = 'NOLOG'    THEN logging := false            ELSE IF keyword = 'CHECKSUM' THEN checksum:= true           ELSE IF keyword = 'FIELD'    THEN field   := true           ELSE IF keyword = 'TABLE'    THEN table   := true           ELSE IF keyword = 'NOTABLE'  THEN table   := false                ELSE IF keyword = 'ERRORS'   THEN BEGIN              (* Syntax : ERRORS=n where 0<=n<=32767 *)               IF get_token <> equals  "               THEN nonfatal_error (dbds_illegal_control_option_err) "             ELSE IF get_token <> number_token   "               THEN nonfatal_error (dbds_illegal_control_option_err) "             ELSE errs := current_token.numeric_value;               END  (* then ERRORS *)               ELSE IF keyword = 'ACCESS'   THEN BEGIN                  (* Syntax : ACCESS=<access type>       *)               (* where <access type> is RW, RO or DI *)                   IF get_token <> equals  "               THEN nonfatal_error (dbds_illegal_control_option_err) "             ELSE IF get_token <> alpha_token  "               THEN nonfatal_error (dbds_illegal_control_option_err) "             ELSE IF keyword = 'RW' THEN access := read_write              ELSE IF keyword = 'RO' THEN access := read_only               ELSE IF keyword = 'DI' THEN access := disabled  !            ELSE nonfatal_error (dbds_illegal_control_option_err); !             END (* then ACCESS *)                 ELSE nonfatal_error (dbds_illegal_control_option_err);              (* Expect either a semicolon or comma *)            cur_token := get_token;             IF (cur_token <> comma) AND (cur_token <> semicolon)           THEN nonfatal_error (dbds_comma_expected_err);       99:   (* when a semicolon is found *)             UNTIL cur_token = semicolon;      END; (* process_control_options *)  $ Page $  #(*******************************************************************)  # #(*                       control_clause                            *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To parse a $CONTROL clause in the schema which contains      *)  # #(*    user-specified options for database creation.  (See the      *)  # #(*    IMAGE reference manual under $CONTROL).                      *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE control_clause   $ Alias 'DBDS.Control' $;      VAR      ttype : tokens_type;       
BEGIN (* control_clause *) 
        (**)      (* Syntax:      (*      (* $CONTROL: <option-list>;     (*      (* This statement is optional.      (* <option-list> may be null.     (* The BEGIN keyword is pre-fetched.      (*      (**)          next_significant; (* skip comments and blanks *)          IF get_token <> alpha_token THEN BEGIN         nonfatal_error (dbds_begin_database_expected_err);        semicolon_scan;         END      ELSE WITH current_token.identifier DO        IF keyword = '$CONTROL'            THEN IF get_token <> colon THEN BEGIN                   nonfatal_error (dbds_control_expected_err);                   semicolon_scan;  
                 END 
               ELSE BEGIN                   process_control_options;                    ttype := get_token;  (* prefetch the BEGIN *)                   END (* else *)            ELSE IF keyword[1] = '$' THEN BEGIN              nonfatal_error (dbds_control_expected_err);               semicolon_scan;               END;      &   (* At this point current_token has what we expect is the BEGIN keyword *) &        (* all done with $CONTROL *)       END;  $ Page $  #(*******************************************************************)  # #(*                     database_clause                             *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To process the BEGIN DATA BASE command.                      *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE database_clause  $ Alias 'DBDS.Database' $;       LABEL 99;       BEGIN (* database_clause *)          (* Syntax: BEGIN DATA BASE: <root file>; *)      %   (* NOTE: The BEGIN keyword was prefetched by the $CONTROL processor *)  %        WITH current_token.identifier DO   
   IF (keyword <> 'BEGIN') 
       THEN nonfatal_error (dbds_begin_database_expected_err)     ELSE IF (get_token <> alpha_token) OR (keyword <> 'DATA')        THEN nonfatal_error (dbds_begin_database_expected_err)     ELSE IF (get_token <> alpha_token) OR (keyword <> 'BASE')        THEN nonfatal_error (dbds_begin_database_expected_err)     ELSE IF (get_token <> colon)         THEN nonfatal_error (dbds_begin_database_expected_err)     ELSE BEGIN (* get the file name *)   
      get_filename;  
           root_file.newfl := current_token.file_value;      #      (* Make sure the immediately following token is a semicolon! *)  #       IF get_token <> semicolon            THEN nonfatal_error (dbds_illegal_file_name_err);        GOTO 99; (* skip the semicolon scan *)        END; (* else *)          semicolon_scan; (* done only if error occurred *)      99:  (* skip around scan *)       
END; (* database_clause *) 
 $ Page $  #(*******************************************************************)  # #(*                         terminate_dbds                          *)  # #(*******************************************************************)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To display a completion message and close all files.         *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(*******************************************************************)  #     PROCEDURE terminate_dbds  $ Alias 'DBDS.Terminate' $;       VAR      status : short_int;     display_string : long_str;      number_string  : short_str;     length         : short_int;     nlerr          : short_int;     prtn_array     : rmpar_array_type;       CONST      len = chars_in_long_str;       
BEGIN (* terminate_dbds *) 
        (**)   "   (* Display the total number of errors, then a completion message. "    (**)       
   display_string := ' ';  
    IF write_long_str (list_file, display_string, status) THEN;      (* display_string := ' Total number of errors:';  *NLS*)  (*:nl:#*1 1000 ' Total number of errors:'   *NLS*)  %(*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);'  *)  % $   length := nlread (MDBDS_SUBA, 1000, nlerr, display_string, len);      $        display_string[length+1] := ' ';     (*NLS*)           short_int_to_readable_short_str (error_count, number_string);      append_blank_and_str (display_string, number_string);         IF write_long_str (list_file, display_string, status) THEN;      (* display_string := ' Schema processor finished.';  *NLS*)      display_string := ' ';               (*NLS*)       (*:nl:#*1 1001 ' Schema processor finished.'  *NLS*)  $(*:nl:$COPY '   length := nlread (&, #, nlerr, display_string, len);' *) $ "   length := nlread (MDBDS_SUBA, 1001, nlerr, display_string, len);  "        display_string[length+1] := ' ';     (*NLS*)          IF write_long_str (list_file, display_string, status) THEN;             (**)   	   (* Close shop!  	    (**)          IF close_file (input_file, status) THEN;      IF close_file (list_file, status) THEN;         prtn_array[one] := last_error;      prtn (prtn_array);       
END; (* terminate_dbds *)  
 .  