 $PASCAL '92081-16630 REV.5000' $  $TITLE 'DBARC: DBUTL archive utility program'$ $SUBTITLE 'Main program'$  $HEAP 0$ $RANGE OFF$ $RECURSIVE OFF$      PROGRAM DBARC;      #(* **************************************************************** *) # #(* * (C) Copyright 1983 Hewlett-Packard.  All rights reserved.    * *) # #(* * No part of this program may be photocopied, reproduced or    * *) # #(* * translated to another program language without the express   * *) # #(* * written consent of Hewlett-Packard Company.                  * *) # #(* **************************************************************** *) #     #(********************************************************************) # #(*                                                                  *) # #(* PROGRAM : DBARC                                                  *) # #(*                                                                  *) # #(* PURPOSE : This program archives a roll forward log file from     *) # #(*           disc to tape.                                          *) # #(*                                                                  *) # #(* parameters:  log file       :  where errors are printed          *) # #(*              disc file name :  rflf to be archived               *) # #(*              magtape lu     :  magtape to be used                *) # #(*              VE or V        :  optional verify                   *) # #(*                                                                  *) # #(* PGMR:        <MES>                                               *) # #(*                                                                  *) # #(* SOURCE:  92081-18630                                             *) # #(* RELOC:   92081-16630                                             *) # #(*                                                                  *) #(* Last modified: <870127.1333>  #(*                                                                  *) # #(********************************************************************) #     (**)  %(*:nl:$ '        SOURCE MESSAGE CATALOG                                  ' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '* (C) COPYRIGHT HEWLETT-PACKARD COMPANY 1984.  ALL RIGHTS      *' % %(*:nl:$ '* RESERVED.  NO PART OF THIS PROGRAM MAY BE PHOTOCOPIED,       *' % %(*:nl:$ '* REPRODUCED OR TRANSLATED TO ANOTHER PROGRAM LANGUAGE WITHOUT *' % %(*:nl:$ '* THE PRIOR WRITTEN CONSENT OF HEWLETT-PACKARD COMPANY.        *' % %(*:nl:$ '****************************************************************' % %(*:nl:$ '                                                                ' % %(*:nl:$ '                           SOURCE:   92081-18067                ' % %(*:nl:$ '         S. MESSAGE CATALOG NAME :   <AR000                     ' % %(*:nl:$ '                            RELOC:   92081-16067                ' % %(*:nl:$ '         B. MESSAGE CATALOG NAME :   %AR000                     ' % %(*:nl:$ '                            PGMR :   TH                         ' % %(*:nl:$ '         REV.2540 <870127.1333>                                 ' %(*:nl:$  (*:nl:$ '*NOTE*'  %(*:nl:$ 'All the messages in DBARC must be within the number of chars_in ' % %(*:nl:$ 'long_str -1 (=127 bytes). And parameter substitution must be    ' % %(*:nl:$ 'within the number of chars_in_short_str -1 (=15 bytes).         ' %(*:nl:$ (*:nl:$ (*:nl:$LANGID 0 (*:nl:$ (*:nl:$  (**)      (**) %(*:nl:$ATB, mdbarc, %ar000, relocatable, 92081-16067 REV.2540 <870127.1333> %(*:nl:$  
(*:nl:$COUNTER, 1, 1000, 1 
 (**)      $PAGE$  #(********************************************************************) #LABEL    999,  (* end of program *)    26,27,28,29,30,31,32,  (* NLS message tests *) 	   101,102,103,104; 	     "$LIST OFF,Include '[IMAGE',LIST ON$  (* IMAGE constants and types *) "    CONST 
   chars_in_parm_str = 128; 
   entries_in_parm_buffer = 10;     do_not_extend_file = false;     lock_without_wait = -16383;     unlock_without_wait = -32768;     abort = short_str [ 'AB', chars_in_short_str-2 of ' '];     continue = short_str ['XX', chars_in_short_str-2 of ' '];         go = short_str ['go', chars_in_short_str-2 of ' '];    caps_go = short_str ['GO', chars_in_short_str-2 of ' '];     len = chars_in_long_str;   (* NlReadRel max. read length *)      $ Page $ "$ List OFF, Include '[LOG', List ON $  (* Structured log constants *) " #(********************************************************************) # #(*                      LOCAL TYPES                                 *) # #(********************************************************************) # TYPE         parm_str = packed array [1..chars_in_parm_str] of CHAR;             parm_entry =                    (* parameter entry *)        RECORD          typ: (non, int, asc);     (* parameter type *)          len: short_int;           (* ascii parameter length *)           ascii: parm_str;          (* ascii parameter value *)            value: long_int;          (* numeric parameter value *)   
         END; (* RECORD *) 
       parm_buffer =                   (* parameter buffer *)        RECORD "         number_of_parms: short_int; (* number of valid parameters *) "          parameter:                (* parameter array *)              ARRAY [1..entries_in_parm_buffer] OF parm_entry;  
         END; (* RECORD *) 
        rmpar_type = ARRAY [1..5] OF short_int;          $PAGE$  #(********************************************************************) # #(*                      LOCAL VARIABLES                             *) # #(********************************************************************) #    VAR     rmpar : rmpar_type;  
   last_error : short_int; 
    (*  input, prompt, log files & run string info *)    log_file :  file_descriptor;    input_file: file_descriptor; 
   run_str_len:  short_int; 
 
   run_string :  long_str; 
 #   parameter_buffer : parm_buffer;    (* parameters from run string *) # "   start :  short_int;              (* used for parsing file name *) "        (* temporary variables *)     temp_str :  long_str;    temp_short_str :  short_str;      user_response : short_str;     (* user's GO or AB response *)  &   dummy_status :  short_int; (* use when don't want return_status altered *) &    no_file_to_display:  new_file_name;         (* rfl file and tape variables *)    rfl_label :  disc_block;     (* first block in file *) !   rfl_label_ptr : ptr_rfl_label_type;  (* points to first block *) !   big_buffer :  rfl_tape_buffer_type;  (* from [log *)    buf_pos : short_int;    end_of_log :  boolean;    log_rec_typ : short_int;      (* log record type location *) 
   disc_blk_num : long_int; 
 "   word_pos :  short_int;        (* used to index into big buffer *) "    num_blocks_to_read :  short_int;      num_blocks_to_write : short_int;   $   end_of_chunk :  short_int;      (* end of current chunk in buffer *)  $ '   chunk_head_ptr :  ptr_chunk_head_log_rec_type;  (* points to chunk head *)  '        (* user parameters *)  %   archive_file :  file_descriptor;   (* file passed by user to archive *) % !   magtape :  file_descriptor;        (* magtape to archive to *)  !     magtape_lu:  short_int;            (* for locking purposes *)          (* error exit variables *)      return_status :  short_int;     file_name_to_display:  short_str;     disc_file_status   :  short_int;          (* for reading info from dbcon file *)      dbcon_file:  file_descriptor;     hist_entry:  history_table_entry_type;   
   vol_number:  short_int; 

   current_set:  short_str; 
    dbcon_table:  dbcon_table_type;        (* verification variables *)     verify_buffer:  rfl_tape_buffer_type;    verify_label:  disc_block;    verify_label_ptr:  ptr_rfl_label_type;     verify_option_selected:  boolean;    compare_value:  short_int;     verify_start_block:  short_int;         (* NLS variables *)  
   length:      short_int; 
 
   nlerr:       short_int; 
         $PAGE$  #(********************************************************************) # #(*                      EXTERNAL SYSTEM PROCEDURES                  *) # #(********************************************************************) #     $ LIST OFF $  $ Include '[XDMSG' $          (* message exchange externals *) !$ Include '[XDGDN' $          (* External to get dbcon file name *) !"$ Include '[XDFMP' $          (* Externals to non EMA I/O routines *) "!$ Include '[XDCIO' $          (* Externals to dbcon I/O routines *) !  $ Include '[XDTDY' $          (* External to create timestamp *)   $ Include '[XDGCB' $          (* Get the communications buffer *)   $ Include '[XDCCP' $          (* Clear the comm. buffer *) $ Include '[XDSLP' $          (* Sleep routine *)   $ Include '[XDSMR' $          (* String manipulation routines *)  $ Include '[XUSHF' $          (* Upshift externals *)     $ Include '[XDNLS' $          (* NLS externala *) (*:nl:$COPY 'PROCEDURE &; EXTERNAL;' *) 
PROCEDURE MDBARC; EXTERNAL; 
$ List on $      PROCEDURE prtn    (rmpars : rmpar_type);     EXTERNAL;         FUNCTION read_run_string $ alias 'PAS.PARAMETERS' $     (    position :  short_int;     VAR string   :  long_str;          str_len  :  short_int ) : short_int; EXTERNAL;      PROCEDURE parse_run_string  $ alias 'IMG.Parser' $    ( VAR run_string : long_str;          run_string_len :  short_int;     VAR parameter_buffer : parm_buffer;          entries_in_parm_buffer :  short_int;      VAR return_status : short_int ); EXTERNAL;         FUNCTION device_control_operation   $ alias 'DBIOC' $    ( VAR device_name :  dcb_type;           fctn_code   :  device_ctrl_fctn_type;      VAR return_status :  short_int ) :  BOOLEAN; EXTERNAL;     FUNCTION do_device_io $ alias 'DBDIO' $    (     rd_wt_code :  short_int;       VAR device_name:  dcb_type;          length     :  short_int;      VAR buffer     :  short_int;      VAR words_read :  short_int;      VAR return_status :  short_int ) :  BOOLEAN; EXTERNAL;      FUNCTION set_chunk_head_ptr $ alias '.DRCT' $ $ DIRECT $    ( value:  short_int ) : ptr_chunk_head_log_rec_type; EXTERNAL;      FUNCTION set_rfl_label_ptr  $ alias '.DRCT' $ $ DIRECT $     ( value:  short_int ) : ptr_rfl_label_type; EXTERNAL;          FUNCTION compare_buffers $ alias 'DBCMW' $     ( VAR buff1:  rfl_tape_buffer_type;       VAR buff2:  rfl_tape_buffer_type;       VAR number_of_words_to_compare:  short_int) : short_int;   EXTERNAL;       FUNCTION compare_labels $ alias 'DBCMW' $      ( VAR buff1:  disc_block;       VAR buff2:  disc_block;       VAR number_of_words_to_compare:  short_int) : short_int;   EXTERNAL;       	$ Heapparms off $  	 $page$  #(********************************************************************) # #(*                      error_handler                               *) # #(********************************************************************) # #(*                                                                  *) # #(* error_handler displays an error number and file name on the log  *) # #(* file and then either returns or exits the program based on the   *) # #(* parameter abort_option.                                          *) # #(*                                                                  *) # #(********************************************************************) #    PROCEDURE error_handler     (     error_code:  short_int;           error_file:  new_file_name;           abort_option :  short_str);     LABEL     10,11,12,13;  (* NLS message tests *)     CONST  #   chars_in_message = 50;          (* error message length in chars *) #     TYPE     message =                       (* error message *)       PACKED ARRAY [1..chars_in_message] OF char;         VAR    temp_str : Long_str;    return_status : Short_int;     printable_file_name :  short_str;     BEGIN (* error_handler *)        IF error_file = magtape.newfl THEN  "      short_dest_file_srce (printable_file_name, chars_in_short_str, " !                            magtape.newfl, chars_in_new_file_name, !                             str_assign, zero);         last_error := error_code;      (* temp_str :=  'ERROR NUMBER'; *)  !   short_int_to_readable_short_str ( error_code, temp_short_str ); !   null_pad (temp_short_str, chars_in_short_str);  (* append_blank_and_str ( temp_str, temp_short_str ); *)      
10:  (* NLS tests *) 
        IF error_file <> ' ' THEN BEGIN (*    temp_short_str := 'FOR'; *)        IF error_file <> magtape.newfl           THEN short_dest_file_srce                     (printable_file_name, chars_in_short_str,                     error_file, chars_in_new_file_name,                      str_assign, zero);            null_pad(printable_file_name, chars_in_short_str);      
      (*:nl:$ ' ' *) 
      (*:nl:$ ' !1 is the error code number (Max. 15 bytes)' *)        (*:nl:$ ' !2 is the file name  (Max. 15 bytes)' *)        (*:nl:#*1 1000 'ERROR NUMBER !1 FOR !2' *)        (*:nl:$COPY '      length := nlread_p2 (&, #, nlerr,' *)       length := nlread_p2 (MDBARC, 1000, nlerr,                temp_str, len, temp_short_str, printable_file_name);        blank_pad (temp_str, chars_in_long_str, length);      
11:  (* NLS tests *) 
          END     (*    append_blank_and_str ( temp_str, temp_short_str ); *)   (*    append_blank_and_str ( temp_str, printable_file_name ); *)             ELSE BEGIN      
12:  (* NLS tesst *) 
             (*:nl:$ ' ' *)          (*:nl:$ ' !1 is the error code number (Max. 15 bytes)' *)          (*:nl:#*1 1001 'ERROR NUMBER !1' *) !        (*:nl:$COPY '         length := nlread_p1 (&, #, nlerr,' *) !          length := nlread_p1 (MDBARC, 1001, nlerr,                                       temp_str, len, temp_short_str) ;           blank_pad (temp_str, chars_in_long_str, length);                END;         (* write message to log file *)     IF write_long_str (log_file, temp_str, return_status) THEN;      
13:  (* NLS tests *) 
     
   IF abort_option = abort 
       THEN BEGIN          IF close_file ( log_file, error_code ) THEN;          GOTO 999;   (* 999 = END of program *)        END;      END; (* error_handler *)  $page$  $(* This procedure closes the rollforward log file before calling the  *) $ $(* error exit routine.                                                *) $ PROCEDURE error_exit (VAR file_to_display:  new_file_name;                           return_status:  short_int);     LABEL  
   10,99;  (* NLS tests *) 
VAR  
   error_code:  short_int; 
    BEGIN  (* error_exit *)        IF close_file ( archive_file, error_code ) THEN;     IF close_file ( magtape, error_code ) THEN;    IF close_file ( dbcon_file, error_code ) THEN;    IF close_file ( input_file, error_code ) THEN;      
10:  (* NLS tests *) 
       error_handler ( return_status, file_to_display, abort );      
99:  (* NLS tests *) 
    
END; (* error_exit *) 
 $page$ #(*********************************************************************) ##(* This procedure checks parameters, opens files, and locks the tape *) ##(*********************************************************************) #    PROCEDURE pick_up_parameters;     LABEL     14,15,100;  (* NLS message tests *)     VAR    file_hdr, name_hdr, type_hdr, dir_hdr, ds_hdr : f7x_str;         filename : short_str;     typeext  : short_str;     dirpath  : short_str;     dsnode   : short_str;         sc, filetype, filesize, reclen : short_int;     save_log : new_file_name;     BEGIN  (* pick_up_parameters *)        (* pick up log file parameter *)     WITH parameter_buffer.parameter[3] DO     CASE typ OF            non: temp_str := '1';  (* make log file the console *)            int,asc:  temp_str := ascii;     
      END; (* case *) 
       file_dest_long_srce (log_file.newfl, chars_in_new_file_name,                          temp_str, chars_in_long_str,                          str_assign, zero);        IF open_file_for_append (log_file,                              return_status)        THEN BEGIN  (*       temp_str := 'Unable to open log file'; *)              last_error := return_status;      
14:  (* NLS tests *) 
              (*:nl:#*1 1002 'Unable to open log file' *)           (*:nl:$COPY '         length := nlread (&, #, nlerr,' *)           length := nlread (MDBARC, 1002, nlerr,                                       temp_str, len);          blank_pad (temp_str, chars_in_long_str, length); #         IF write_long_str ( input_file, temp_str, return_status) THEN; #     
15:  (* NLS tests *) 
              save_log := log_file.newfl;          log_file.newfl := '1';          IF open_file_for_write (log_file, return_status)  
            THEN GOTO 999; 
         error_handler (last_error, save_log, abort);        END;     
100:  (* NLS tests *) 
       (* check to see if verify option was selected *)     WITH parameter_buffer.parameter[6] DO BEGIN           CASE typ OF               non:;              int:  error_handler ( illegal_parm_type_err,                                no_file_to_display, abort );      
         asc:  BEGIN 
                  IF (ascii = 'V ') OR (ascii = 'VE')                       THEN verify_option_selected := true                        ELSE error_handler ( illegal_parm_type_err,                                            no_file_to_display,                                           abort);                     END;  (* begin *)            END;  (* case *)      	   END; (* with *) 	     #   (* pick up disc file parameter                                  *)  # #   (* NOTE:  since coming from DBUTL these parameters have already *)  # #   (*        been checked, so no parm errors are expected here.    *)  #    WITH parameter_buffer.parameter[4] DO BEGIN  	      CASE typ OF  	             non:  error_handler ( missing_parameter_err,                                no_file_to_display, abort );              int:  error_handler ( illegal_parm_type_err,                                no_file_to_display, abort );     	         asc: BEGIN 	     &            file_dest_long_srce (archive_file.newfl, chars_in_new_file_name, &                                  ascii, chars_in_long_str,                                  str_assign, zero);                 (* open disc file for read *)               (* if error, display number & file name and abort *)               IF open_existing_file (archive_file,                                    return_status)                 THEN error_handler ( return_status,                                       archive_file.newfl, abort );               END;     
      END; (* case *) 
 	   END; (* with *) 	    
   (* pick up magtape lu *) 
    WITH parameter_buffer.parameter[5] DO BEGIN       CASE typ OF              non:  error_handler ( missing_parameter_err,                                no_file_to_display, abort ); 	         int: BEGIN 	    #            file_dest_long_srce (magtape.newfl, chars_in_new_file_name, #                                  ascii, chars_in_long_str,                                  str_assign, zero);                  (* open magtape for write *)               (* if error, then report number & file, and abort *)              IF open_file_for_write ( magtape,                                       return_status )                THEN BEGIN  "                  IF close_file ( archive_file, dummy_status ) THEN; "                  error_handler (  return_status,                                     magtape.newfl, abort );                   END;  (* begin *)                     END; (* int case *)               asc:  error_handler (  illegal_parm_type_err,                                  no_file_to_display, abort );     
      END; (* case *) 
     	   END; (* with *) 	    #   (******************************************************************) ##   (* Open DBCON file, make sure it is a valid DBCON file and that   *) ##   (* an entry exists for the physical file name which was given.    *) ##   (******************************************************************) #        IF get_db_control_file_name (dbcon_file.newfl) THEN BEGIN       return_status := image_not_initialized_err;       error_exit (no_file_to_display, return_status);        END;        IF open_existing_file (dbcon_file,                           return_status )        THEN error_exit ( no_file_to_display, return_status );          END;  (* pick_up_parameters *)  $ Page $  (***************************************************************)   (*    Convert an integer volume number to character form.      *)   (***************************************************************)   (*                                                             *)   (* Routine: make_volume_num                                    *)   (*                                                             *)   (* Purpose: To take an integer value in the range of 1-99      *)   (*          and create a 2-character zero-filled result.       *)   (*          No error checking is done.                         *)   !(*                                                             *)  ! !(* PGMR:       <MRL>                                           *)  ! !(*                                                             *)  ! !(***************************************************************)  !     PROCEDURE make_volume_num   $ Alias 'Utl.MakeVolNum' $     (    volume_number : Short_int;      VAR result_string : Short_str);       CONST      empty_short_str = short_str [chars_in_short_str OF ' '];           BEGIN  (* make_volume_num *)         result_string := empty_short_str;     
   result_string[1] := '0'; 
        result_string[2] :=        CHR( ORD('0') + (volume_number MOD 100) DIV 10);        result_string[3] := CHR( ORD('0') + (Volume_number MOD 10));      
END; (* make_volume_num *) 
 $page$  "(******************************************************************) " "(* Read buffers from tape and verify against disc.  Start disc    *) " "(* read with first block on tape (verify_start_blk)               *) " "(******************************************************************) " PROCEDURE verify_tape;     LABEL     16,17,18,19;  (* NLS message tests *) VAR     verify_blk_num :  long_int; 
   words_read :  short_int; 
    num_blks_to_read : short_int;     BEGIN   (* verify_tape *)     (* temp_str := 'VERIFYING SUBVOLUME:'; *)      
16:  (* NLS tests *) 
       (*:nl:#*1 1003 'VERIFYING SUBVOLUME:' *) "   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *) "   length := nlread (MDBARC, 1003, nlerr, temp_str, len);        blank_pad (temp_str, chars_in_long_str, length);  !   make_volume_num ( rfl_label_ptr^.sub_vol_num, temp_short_str ); !   append_blank_and_str ( temp_str, temp_short_str );      IF write_long_str ( log_file, temp_str, return_status ) THEN;       
17:  (* NLS tests *) 
    
   (* first verify label *) 
   IF do_device_io ( read_code,                      magtape.dcb,                      words_in_disc_block,                      verify_label[one],                       words_read,                       return_status )       THEN error_exit ( magtape.newfl, return_status );         compare_value := compare_labels ( verify_label,                                    rfl_label,                                     words_read );     IF compare_value <> 0        THEN error_exit ( no_file_to_display, tape_verify_err );            (* verify_start_block is the first disc block on this *)    (* tape.  Start reading there.                        *)     verify_blk_num := verify_start_block;         (* start with read from tape to get length *)    IF do_device_io ( read_code,                      magtape.dcb,                       num_words_in_rfl_tape_buffer,                       verify_buffer.wds[one],                       words_read,                       return_status )       THEN IF return_status = rfl_end_of_tape_err          THEN error_exit ( magtape.newfl, return_status )          ELSE return_status := 0;        (********************************************************)    (* read and verify until end of file marker is hit      *)    (* Sometimes end of tape is returned even though buffer *)    (* contains information, so ignore return_status.       *)    (********************************************************)         WHILE words_read <> zero DO BEGIN           num_blks_to_read := words_read DIV words_in_disc_block;           (* read from disc file *)       IF do_block_transfer ( read_code,                               archive_file,                               verify_blk_num,                               num_blks_to_read,                              big_buffer.wds[one],                               return_status )          THEN error_exit ( archive_file.newfl, return_status );           (* set up for next disc read *)        verify_blk_num := verify_blk_num + num_blks_to_read;           compare_value := compare_buffers ( verify_buffer,                                           big_buffer,                                           words_read );     
      IF compare_value <> 0 
	         THEN BEGIN 	            error_exit ( no_file_to_display, tape_verify_err );          END;      
      (* read from tape *) 
       IF do_device_io ( read_code,                          magtape.dcb,                         num_words_in_rfl_tape_buffer,                         verify_buffer.wds[one],                         words_read,                         return_status ) 	         THEN BEGIN 	            IF return_status <> rfl_end_of_tape_err                 THEN error_exit (magtape.newfl,return_status)                ELSE return_status := 0;          END; (* begin *)      
   END;  (* while *) 
     (* temp_str := 'VERIFY COMPLETE'; *)      
18:  (* NLS tests *) 
       (*:nl:#*1 1004 'VERIFY COMPLETE'; *) "   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *) "   length := nlread (MDBARC, 1004, nlerr, temp_str, len);        blank_pad (temp_str, chars_in_long_str, length);      IF write_long_str ( log_file, temp_str, return_status ) THEN;       
19:  (* NLS tests *) 
     
   (* rewind tape *) 
   IF device_control_operation ( magtape.dcb,                                   rewind,                                   return_status )           THEN error_exit ( magtape.newfl, return_status );         END;    (* verify_tape *)  $page$  "(******************************************************************) " "(* This procedure handles everything necessary to mount a new     *) " "(* magtape.  It writes an end of file on the current tape,        *) " "(* rewinds the current tape, verifies it if specified, asks the   *) " "(* user to mount a new tape,  rewinds the new tape, updates the   *) " "(* subvolume count, and writes a label on the new tape.           *) " "(******************************************************************) "PROCEDURE handle_end_of_tape;     LABEL     20,21,22,23,24,25;  (* NLS tests *)     BEGIN         return_status := 0;         (* write EOF on current tape *)    IF device_control_operation ( magtape.dcb,                                  write_eof,                                  return_status)        THEN IF return_status <> rfl_end_of_tape_err                THEN error_exit (magtape.newfl, return_status)                ELSE return_status := 0;         (* let user know end of tape was reached *)  (* temp_str := 'END OF TAPE'; *)      
20:  (* NLS tests *) 
        (*:nl:#*1 1005 'END OF TAPE' *) "   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *) "   length := nlread (MDBARC, 1005, nlerr, temp_str, len);        blank_pad (temp_str, chars_in_long_str, length);  !   IF write_long_str ( input_file, temp_str, return_status ) THEN; !     
21:  (* NLS tests *) 
        (* rewind current tape *)    IF device_control_operation ( magtape.dcb,                                   rewind,                                   return_status )       THEN error_exit ( magtape.newfl, return_status );         IF verify_option_selected       THEN verify_tape;        (* set to what will be the first block on next tape *)     verify_start_block := disc_blk_num + num_blocks_to_write;         (* increase subvolume number *)     rfl_label_ptr^.sub_vol_num :=         rfl_label_ptr^.sub_vol_num + one;        (* make user mount a new tape *)      (* temp_str := 'MOUNT NEW TAPE FOR SUBVOLUME:'; *)      
22:  (* NLS tests *) 
        (*:nl:#*1 1006 'MOUNT NEW TAPE FOR SUBVOLUME:' *) "   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *) "   length := nlread (MDBARC, 1006, nlerr, temp_str, len);        blank_pad (temp_str, chars_in_long_str, length);  !   make_volume_num ( rfl_label_ptr^.sub_vol_num, temp_short_str ); !   append_blank_and_str ( temp_str, temp_short_str );  !   IF write_long_str ( input_file, temp_str, return_status ) THEN; !     
23:  (* NLS tests *) 
        user_response := ' ';        WHILE user_response <> 'GO' DO BEGIN      (*    temp_str := 'CONTINUE? (TYPE GO OR AB) :_'; *)      
24:  (* NLS tests *) 
           (*:nl:#*1 1007 'CONTINUE? (TYPE GO OR AB) :_' *) %      (*:nl:$COPY '      length := nlread (&, #, nlerr, temp_str, len);' *) %        length := nlread (MDBARC, 1007, nlerr, temp_str, len);             blank_pad (temp_str, chars_in_long_str, length); "      IF write_long_str ( input_file, temp_str, return_status ) THEN; "     
25:  (* NLS tests *) 
           (* wait for user's response before continuing *)       IF read_short_str ( input_file, temp_short_str,                           return_status ) THEN;  %      upshift_short_str (temp_short_str,user_response,chars_in_short_str); %      IF user_response = 'AB'           THEN error_exit ( no_file_to_display,                            program_was_broken_err);      
   END;  (* while *) 
            (* rewind new tape *)    IF device_control_operation ( magtape.dcb,                                   rewind,                                   return_status )       THEN error_exit ( magtape.newfl, return_status );        (* write new header *)    IF do_block_transfer ( write_code,                            magtape,                            one,                            one,                            rfl_label [one],                           return_status )       THEN error_exit ( magtape.newfl, return_status );      END;  (* handle_end_of_tape *)  $page$ BEGIN  (* main *)         last_error    := 0; !   return_status := 0;      (* initialize error return variables *) !   disc_file_status := 0;    no_file_to_display := ' ';     $   log_file.newfl := '1';  (* in case we cannot open the supplied file *) $    IF open_file_for_write (log_file, return_status) THEN BEGIN       (* Can't display an error message! *) &      last_error := return_status;  (* At least return unsuccessful status *) &      GOTO 999;        END;     
   input_file.newfl := '1'; 
   IF open_file_for_write ( input_file,                              return_status)  !      THEN error_handler (return_status, input_file.newfl, abort); !        (*    pick up run string and parse.  If error,     *)     (*    then print error number and abort.           *)     run_str_len := read_run_string (-1,                                     run_string,                                     chars_in_long_str);    parse_run_string ( run_string,                        chars_in_long_str,                       parameter_buffer,                       entries_in_parm_buffer,                        return_status );     
101:  (* NLS tests *) 
       IF return_status <> no_image_err        THEN BEGIN        log_file.newfl := '1';        IF open_file_for_write ( log_file,                                 return_status) THEN BEGIN          last_error := return_status;  	         GOTO 999; 	         END;           error_handler (  return_status,                          no_file_to_display, abort );        END;      #   (*****************************************************************) # #   (* pick up parameters and verify;  open files and lock magtape   *) # #   (*****************************************************************) #    
102:  (* NLS tests *) 
        pick_up_parameters;          #   (*****************************************************************) # #   (* read rfl_label from file to be archived, verify that it is a  *) # #   (* valid rfl file by checking rev_num, and pick up volume number *) # #   (*****************************************************************) #
   disc_blk_num := 1; 
    IF do_block_transfer ( read_code,                           archive_file,                            rfl_label_block_num,                            num_blks_in_rfl_label,                           rfl_label[one],                           return_status )          THEN error_exit ( archive_file.newfl, return_status );        rfl_label_ptr := set_rfl_label_ptr ( rfl_label[one] );            (* verify that the file is really a roll forward log file *)         vol_number := rfl_label_ptr^.vol_num;    IF (vol_number < 1) OR (vol_number > 999) OR        (rfl_label_ptr^.reserved <> current_rev_num) !      THEN error_exit (archive_file.newfl,bad_or_not_rfl_tape_err); !            (* read information about current roll forward log and *)     (* make sure the user isn't trying to archive it.      *)        WITH dbcon_table.dbcon_rfl_info_block DO BEGIN       IF read_dbcon_table ( dbcon_file,                             dbc_rfl_info_blk,                              do_not_lock_dbcon_file,                               block,                              return_status)            THEN error_exit (no_file_to_display, return_status);               current_set := rflf_set_name;        IF (rfl_label_ptr^.log_set_name = current_set) AND           (vol_number = rflf_vol_num)          THEN error_exit (archive_file.newfl,                            cant_archive_current_rfl_err);     	   END;  (* with *) 	         "   (* double check on current set - match set in label vs current *) " "   (* set read from dbcon file above.  Then make sure physical    *) " "   (* name supplied in run string really exists in the history    *) " "   (* history table in the dbcon file.                            *) "        IF read_history_table_entry ( dbcon_file,                                   do_not_lock_dbcon_file,                                   vol_number,                                   hist_entry,                                  return_status)        THEN error_exit ( no_file_to_display, return_status );     
   WITH hist_entry DO BEGIN 
       IF (rfl_label_ptr^.log_set_name <> current_set) OR          (archive_file.newfl <> log_name) 	         THEN BEGIN 	&(*temp_str := 'FILE IS NOT IN CURRENT SET, DBCON TABLE WILL NOT BE UPDATED.'; & *)      
26:  (* NLS tests *) 
     $           (*:nl:#*1 1008 'FILE IS NOT IN CURRENT SET, DBCON TABLE &' *) $            (*:nl:#        'WILL NOT BE UPDATED.'*)  #           (*:nl:$COPY '            length := nlread (&, #, nlerr,' *) #             length := nlread (MDBARC, 1008, nlerr,                                             temp_str, len);              blank_pad (temp_str, chars_in_long_str, length); %            IF write_long_str ( input_file, temp_str, return_status ) THEN; %     
27:  (* NLS tests *) 
                user_response := ' ';      #(*          temp_str := 'ENTER GO IF YOU STILL WANT TO CONTINUE:_'; *) #     
28:  (* NLS tests *) 
     $            (*:nl:#*1 1009 'ENTER GO IF YOU STILL WANT TO CONTINUE:_' *) $#            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *) #             length := nlread (MDBARC, 1009, nlerr,                                                     temp_str, len);              blank_pad (temp_str, chars_in_long_str, length); %            IF write_long_str ( input_file, temp_str, return_status ) THEN; %     
29:  (* NLS tests *) 
                IF read_short_str ( input_file, temp_short_str,                                 return_status ) THEN;              upshift_short_str ( temp_short_str, user_response,                                 chars_in_short_str );              IF user_response <> 'GO'                 THEN error_exit ( no_file_to_display,                                   program_was_broken_err );              END;  (* then *)           IF (used_volume_flag = false) 	         THEN BEGIN 	 %(*          temp_str := 'HISTORY TABLE INDICATES VOLUME WAS NOT USED.'; *) %     
30:  (* NLS tests *) 
     &            (*:nl:#*1 1010 'HISTORY TABLE INDICATES VOLUME WAS NOT USED.' *) &#            (*:nl:$COPY '            length := nlread (&, #, nlerr,' *) #             length := nlread (MDBARC, 1010, nlerr,                                                     temp_str, len);              blank_pad (temp_str, chars_in_long_str, length); $            IF write_long_str ( log_file, temp_str, return_status ) THEN; $     
31:  (* NLS tests *) 
                 error_exit ( archive_file.newfl,                          bad_or_not_rfl_tape_err );          END;      	   END; (* WITH *) 	    "   (****************************************************************) ""   (* Rewind magtape, set subvolume to zero in our copy of the     *) ""   (* rfl label, and write the label to tape.  Then, set disc      *) ""   (* block number to the first data block (block 2).              *) ""   (****************************************************************) "       IF device_control_operation ( magtape.dcb,                                   rewind,                                   return_status )       THEN error_exit ( magtape.newfl, return_status );            rfl_label_ptr^.sub_vol_num := 0;        IF do_block_transfer ( write_code,                            magtape,                            one,                            one,                            rfl_label [one],                           return_status )        THEN error_exit ( archive_file.newfl, return_status );        (* start reading from disc file at second block *)    disc_blk_num := rfl_start_block;    verify_start_block := rfl_start_block;     !   (**************************************************************) !!   (* The following code works thusly:  Read 5K words from       *) !!   (* the disc file to be archived.  If physical end of file is  *) !!   (* returned on the read ignore it until after processing what *) !!   (* was returned from that read since the buffer may have been *) !!   (* partially filled before the end of file was encountered.   *) !!   (* Read through the buffer to determine the block number of   *) ! "   (* the last complete chunk (pointers must be created to find  *)  " "   (* out the number of blocks in each chunk).  Write that many  *)  " "   (* blocks to tape. Increment the disc block number by that    *)  " "   (* many blocks so that the next disc read will start with     *)  " "   (* the next chunk (i.e. the data read from the disc will      *)  " "   (* always start at a chunk head).  If the logical end of      *)  " "   (* file record is found (log record type = 0) then set the    *)  " "   (* flag "end_of_log" so that we will exit from the loop       *)  " "   (* reading through the buffer.  Additionally, set physical    *)  " "   (* end of file so that the disc read loop will exit.  Note:   *)  " "   (* it is an error if physical end of file is reached before   *)  " "   (* the logical end of file.  This is checked on exit of the   *)  " "   (* disc reading loop.  If end of tape is reached before       *)  " "   (* logical end of file then have the user mount a new tape,   *)  " "   (* increase the subvol number in the rfl header and write the *)  " "   (* new header to the new tape.                                *)  " "   (**************************************************************)  "            (* not end of file until 0 log record type found *)     end_of_log := false;          WHILE disc_file_status <> bof_eof_err DO BEGIN            (* read from disc file *)       IF do_block_transfer ( read_code,                               archive_file,                               disc_blk_num,                              num_blks_in_rfl_tape_buffer,                              big_buffer.wds[one],                              disc_file_status )           THEN (* abort if read error other than end of file *)          IF (disc_file_status <> bof_eof_err)  "            THEN error_exit ( archive_file.newfl, disc_file_status); "           end_of_chunk := 0;            (* find end of last chunk in buffer *)        WHILE (end_of_chunk < num_blks_in_rfl_tape_buffer) AND             (NOT end_of_log) DO BEGIN               (* set blocks to write as end of last full chunk *)          num_blocks_to_write := end_of_chunk;      !         (* calculate address of next log record type in buffer *) !         log_rec_typ := end_of_chunk * words_in_disc_block + 2;               (* make sure record type is chunk head *)           IF big_buffer.wds[log_rec_typ] = 11              THEN BEGIN                     (* set word_pos to start of chunk     *)                  (* and create new pointer at word_pos *)                  word_pos := end_of_chunk * words_in_disc_block                              + log_rec_hdr_size + 1;                 chunk_head_ptr :=  "                  set_chunk_head_ptr ( big_buffer.wds [word_pos] );  "                    (* find end of next chunk *)                  end_of_chunk := end_of_chunk +                                 chunk_head_ptr^.blks_per_chunk;                   END            ELSE                   IF big_buffer.wds[log_rec_typ] = 0  
               THEN BEGIN  
                   end_of_log := true;                     disc_file_status := bof_eof_err;  	               END 	 %            ELSE error_exit ( no_file_to_display, DBUTL_internal_err );    %           END; (* while *)      #      (* see if last chunk ended at end of big buffer               *) # #      (* (loop exit is end_of_chunk >= num_blks_in_rfl_tape_buffer) *) #      IF end_of_chunk = num_blks_in_rfl_tape_buffer           THEN num_blocks_to_write := end_of_chunk;           (* write big buffer to magtape *)        IF do_block_transfer ( write_code,                              magtape,                              one,                              num_blocks_to_write,                              big_buffer.wds[one],                               return_status )        THEN BEGIN   (* write failed, was it end of tape? *)     
103:  (* NLS tests *) 
              IF (return_status = bof_eof_err) OR             (return_status = rfl_end_of_tape_err)           THEN handle_end_of_tape           ELSE error_exit ( magtape.newfl, return_status );           END;  (* begin *)            (* start next disc read where last chunk left off *)       disc_blk_num := disc_blk_num + num_blocks_to_write;          END;  (* WHILE *)  (* exit loop if logical or physical eof *)          (* make sure logical end of file was found *)     IF (disc_file_status = bof_eof_err) AND        (NOT end_of_log)        THEN error_exit ( archive_file.newfl, corrupt_rfl_err );        (* write end of file on tape and rewind *)    IF device_control_operation ( magtape.dcb,                                  write_eof,                                   return_status )  &      THEN IF return_status <> rfl_end_of_tape_err   (* ignore error here *) &         THEN error_exit ( magtape.newfl, return_status )          ELSE return_status := 0;        IF device_control_operation ( magtape.dcb,                                   rewind,                                   return_status )       THEN error_exit ( magtape.newfl, return_status );     
104:  (* NLS tests *) 
        IF verify_option_selected       THEN verify_tape;            (**)  "   (* open DBCON file and update history table for this log entry *) "   (**)          IF read_history_table_entry (dbcon_file,                                  lock_dbcon_file,                                   vol_number,                                   hist_entry,                                  return_status)        THEN error_exit ( no_file_to_display, return_status );         (* update history entry only if file is in current set *) 
   WITH hist_entry DO BEGIN 
       IF (rfl_label_ptr^.log_set_name = current_set) AND           (archive_file.newfl = log_name) 	         THEN BEGIN 	             log_name := magtape.newfl;             num_subvolumes := rfl_label_ptr^.sub_vol_num;             IF write_history_table_entry (dbcon_file,                                            unlock_dbcon_file,                                           vol_number,                                           hist_entry,                                            return_status)  !               THEN error_exit (no_file_to_display,return_status); !         END;  (* then *)  	   END; (* WITH *) 	        IF close_file ( dbcon_file, return_status ) THEN;    IF close_file ( magtape, return_status ) THEN;     IF close_file ( archive_file, return_status ) THEN;     IF close_file ( input_file, return_status ) THEN;     (* temp_str := 'ARCHIVE COMPLETE'; *)      
32:  (* NLS tests *) 
       (*:nl:#*1 1011 'ARCHIVE COMPLETE' *) "   (*:nl:$COPY '   length := nlread (&, #, nlerr, temp_str, len);' *) "   length := nlread (MDBARC, 1011, nlerr, temp_str, len);    blank_pad (temp_str, chars_in_long_str, length);     IF write_long_str ( log_file, temp_str, return_status )        THEN error_exit ( log_file.newfl, return_status );         IF close_file ( log_file, return_status ) THEN;  999:  
   rmpar[1] := last_error; 
    prtn (rmpar);      	END.   (* DBARC *) 	