 $PASCAL ',7 92081-1X684 REV.2540' $       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18684                                        *)  ! !(* RELOC:   92081-16684                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL> <JUF>                                    *)  ! !(*                                                             *)  ! (* Date last modified: <850416.1427>  !(*                                                             *)  ! !(***************************************************************)  !     $ Include '[LBOPT'  $       PROGRAM remove_transaction  $ Alias 'Mon.RemoveTrans' $;      #(*******************************************************************)  # #(*              GLOBAL CONSTANTS AND TYPES                         *)  # #(*******************************************************************)  #     $ List OFF, Include '[IMAGE' , List ON $      $ List OFF, Include '[BMCCT' , List ON $  $ List OFF, Include '[BMCTV' , List ON $  $ List OFF, Include '[BMSAM' , List ON $  $ List OFF, Include '[QA' ,    List ON $      $ Page $  #(*******************************************************************)  # #(*                  EXTERNAL REFERENCES                            *)  # #(*******************************************************************)  #     $ List OFF, Include '[XBLOG',  List ON $  $ List OFF, Include '[XLGLB',  List ON $  $ List OFF, Include '[XURDO',  List ON $  $ List OFF, Include '[XBINU',  List ON $  $ List OFF, Include '[XBQA',   List ON $  $ List OFF, Include '[XWOCL',  List ON $      	$ Heapparms OFF $  	     $ Page $  #(*******************************************************************)  # #(*                                                                 *)  # #(* Function  UNDO_TRANSACTION:                                     *)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To remove the effects of an arbitrary transaction from any   *)  # #(*    and all modified databases.                                  *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) ATT entry index.                                *)  # #(*                                                                 *)  # #(* Errors:                                                         *)  # #(*    Potential disc errors (hard crash).                          *)  # #(*                                                                 *)  # #(* Notes:                                                          *)  # #(*    Because this routine has to do backward reads and such,      *)  # #(*    it is necessary to save the 'last TUF block' where the       *)  # #(*    checkpoint records are to be written to the TUF, and         *)  # #(*    also, the current 'backward read block' needs to be          *)  # #(*    saved so that the undo routine will know where it is         *)  # #(*    in the TUF.  In essence, we are going to do some wool-pulling*)  # #(*    over TUF_CHUNK_IO and DRAIN_TUB's eyes.                      *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     FUNCTION undo_transaction   $ Alias 'Mon.TransCleanup' $     (    att_entry_index : short_int) : Boolean;       LABEL      99;  (* error exit *)      VAR      undo_complete   : Boolean;      logrecord_ptr   : ptr_log_record_header_type;     Current_block   : Long_int;     Current_word    : Short_int;          undo_trans_num  : Long_int;     tlf_label       : tuf_label_type;     db_index        : short_int;      db_name         : new_file_name;           BEGIN  (* undo_transaction *)       WITH workhorse_data DO BEGIN         undo_transaction := true;  (* assume an error will occur *)         IF (system_log_status = intr_only)         THEN BEGIN           error := logging_not_enabled_err;  	         GOTO 99;  	          END;       "   undo_trans_num := xaction_tbl_ptr^[att_entry_index].xaction_num;  "        (**)      (* Process the DBUND message, create a log record for     (* the call, and finally perform a checkpoint in order      (* to get buffers posted to disc.     (**)              IF init_trans_cleanup (att_entry_index,                            logrecord_ptr,                            tlf_label,                            error)  
      THEN GOTO 99;  
     
   undo_complete := false; 
        (**)   "   (* Now we loop backwards through the TLF, looking for log records "     (* belonging to the aborted transaction, undoing DBPUT, DBDEL      (* and DBUPD records, and completing at DBBEG.       (* Any other type of log record which is found, will signify       (* a corrupt TLF since we are not expecting any other kind.     (**)          IF qa_crash_code = qa_undo         THEN terminate_program (terminate_code);         WHILE (NOT undo_complete) DO BEGIN                 (**)         (* Get a log record belonging to the specific transaction          (* which we are supposed to UNDO.         (**)            IF common_undo_routine (tlf_descriptor,                                 tlf_label,                                scratch_tub_ptr,                                undo_trans_num,                                 backward,                                 current_block,                                current_word,                                 logrecord_ptr,                                error)           THEN GOTO 99;                WITH logrecord_ptr^ DO        CASE rec_type OF               dbbeg_log_code: BEGIN              undo_complete := true;              END;  (* case of DBBEG log record *)                   dbdel_log_code: BEGIN                  IF find_open_root (delete.db_name_id,                                  db_index,                                 workhorse_data,                                 error)                  THEN GOTO 99;                      IF reput_undel (logrecord_ptr,                              db_index,                               true, (* abort on logical error *)                              workhorse_data,                               error)                 THEN GOTO 99;              END;  (* case of DBDEL log record *)                   dbput_log_code: BEGIN                      IF find_open_root (put.db_name_id,                                 db_index,                                 workhorse_data,                                 error)                  THEN GOTO 99;                      IF redel_unput (logrecord_ptr,                              db_index,                               true, (* abort on logical error *)                              workhorse_data,                               error)                 THEN GOTO 99;              END;  (* case of DBPUT log record *)                   dbupd_log_code: BEGIN                      IF find_open_root (update.db_name_id,                                  db_index,                                 workhorse_data,                                 error)                  THEN GOTO 99;                      IF reupd_unupd (logrecord_ptr,                              db_index,                               true, (* abort on logical error *)                              true, (* undo the update *)                               workhorse_data,                               error)                 THEN GOTO 99;              END;  (* case of DBUPD log record *)                   OTHERWISE BEGIN  (* Unexpected log record! ERROR! *)               error := tlf_corrupt_err;   
            GOTO 99; 
             END; (* otherwise bad log record *)                END; (* Case of log record type *)                 WITH xaction_tbl_ptr^[att_entry_index] DO BEGIN            undoing     := true;            block_num   := current_block;           word_offset := current_word;            END; (* with ATT entry *)            END; (* while transaction not undone *)          undo_transaction := false;       99:  (* error exit *)       END; (* with workhorse data *)      END; (* undo_transaction *)   .  