$PASCAL ',7 92081-1X683 REV.2440' $      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* All rights reserved.                                        *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the written  *)   (* consent of Hewlett-Packard Company.                         *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18683                                        *)   (* RELOC:   92081-16683                                        *)   (*                                                             *)   (* PGMR:        <MRL> <JUF>                                    *)   (*                                                             *)   (* Date last modified: <840912.1408>  (*                                                             *)   (***************************************************************)      
$ Include '[LBOPT'  $ 
     PROGRAM undo_transaction  $ Alias 'Mon.UndoTransact' $;       #(*******************************************************************)  # #(*              GLOBAL CONSTANTS AND TYPES                         *)  # #(*******************************************************************)  #     $ List OFF, Include '[IMAGE' , List ON $      $ List OFF, Include '[BMCCT' , List ON $  $ List OFF, Include '[BMCTV' , List ON $  $ List OFF, Include '[BMSAM' , List ON $      $ Page $  #(*******************************************************************)  # #(*                  EXTERNAL REFERENCES                            *)  # #(*******************************************************************)  #     $ List OFF, Include '[XBLOG' , List ON $  $ List OFF, Include '[XLGLB' , List ON $  $ List OFF, Include '[XURDO' , List ON $  $ List OFF, Include '[XBINU' , List ON $  $ List OFF, Include '[XBUNT' , List ON $      	$ Heapparms OFF $  	     $ Page $  #(*******************************************************************)  # #(*                                                                 *)  # #(* Procedure UNDO_OPERATION:                                       *)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    To remove the effects of an arbitrary transaction from any   *)  # #(*    and all modified databases.                                  *)  # #(*                                                                 *)  # #(* Parameters: None.                                               *)  # #(*                                                                 *)  # #(* Inputs/Outputs: Global.                                         *)  # #(*                                                                 *)  # #(* Called by DBMON main.                                           *)  # #(*                                                                 *)  # #(* Errors:                                                         *)  # #(*    Potential disc errors (hard crash).                          *)  # #(*                                                                 *)  # #(* Notes:                                                          *)  # #(*    Because this routine has to do backward reads and such,      *)  # #(*    it is necessary to save the 'last TUF block' where the       *)  # #(*    checkpoint records are to be written to the TUF, and         *)  # #(*    also, the current 'backward read block' needs to be          *)  # #(*    saved so that the undo routine will know where it is         *)  # #(*    in the TUF.  In essence, we are going to do some wool-pulling*)  # #(*    over TUF_CHUNK_IO and DRAIN_TUB's eyes.                      *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     PROCEDURE undo_operation   $ Alias 'Mon.UndoTrans' $;       LABEL      99;  (* error exit *)      VAR      ATT_entry_index : Short_int;      undo_complete   : Boolean;      logrecord_ptr   : ptr_log_record_header_type;         tlf_label       : tuf_label_type;              BEGIN  (* undo_operation *)       WITH workhorse_data DO BEGIN         (**)      (* Process the DBUND message, create a log record for     (* the call, and finally perform a checkpoint in order      (* to get buffers posted to disc.     (**)              IF undo_initializer (att_entry_index,                          logrecord_ptr,                          tlf_label)  
      THEN GOTO 99;  
            IF undo_transaction (att_entry_index)  
      THEN GOTO 99;  
        IF undo_wrapup_operation (att_entry_index)   
      THEN GOTO 99;  
         99:  (* error exit *)          message_len := to_user_und_mesg_len;       END; (* with workhorse data *)      
END; (* undo_operation *)  
 .  