 $PASCAL ',7 92081-1X483 REV.2540' $       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18483                                        *)  ! !(* RELOC:   92081-16483                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <850822.1633>  !(*                                                             *)  ! !(***************************************************************)  !      $ List OFF, Include '[LBOPT' , List ON $  (* Library options *)        PROGRAM lock_unlock_operations;           !$ List OFF, Include '[IMAGE' , List ON $  (* IMAGE definitions *)  !     !$ List OFF, Include '[BMCCT' , List ON $  (* Workhorse defn's  *)  ! !$ List OFF, Include '[BMCTV' , List ON $  (* DBMON definitions *)  ! !$ List OFF, Include '[BMSAM' , List ON $  (* Main definitions  *)  !     $ List OFF, Include '[XBSDR' , List ON $  $ List OFF, Include '[XDSEM' , List ON $      $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(* This file contains algorithms for removing locks for a      *)  ! !(* specific program for a specific database and for finding the*)  ! !(* process ID index given the program's process description.   *)  ! !(* Close_operation and Lock/Unlock Operations use these.       *)  ! !(*                                                             *)  ! !(***************************************************************)  !     !(***************************************************************)  ! !(*                                                             *)  ! !(* Function FIND_PROCESS: Boolean                              *)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    Given a process description, to find the index into the  *)  ! !(*    IMAGE_USERS coordination table for that process.         *)  ! !(*    The table is initially set up by DBOPN when a process    *)  ! !(*    opens a particular database.                             *)  ! !(*                                                             *)  ! !(*    The database number is used as an initial index into     *)  ! !(*    the table.  If there is no match, then we start looking  *)  ! !(*    for a match from the end of the table.  This is the      *)  ! !(*    way the entry was added (function add_user in &WKOCL).   *)  ! !(*                                                             *)  ! !(* Parameters:                                                 *)  ! !(*    (in)     (1) System database number.                     *)  ! !(*    (in)     (2) Locally-assigned database number.           *)  ! !(*    (in)     (3) Process description.                        *)  ! !(*    (out)    (4) Index into coordination table.              *)  ! !(*    (in/out) (5) Workhorse information.                      *)  ! !(*    (out)    (6) IMAGE error number if an error occurs.      *)  ! !(*                                                             *)  ! !(* Function Result:                                            *)  ! !(*    Boolean 'True' if an error occurs, 'False' otherwise.    *)  ! !(*                                                             *)  ! !(* Possible errors:                                            *)  ! !(*    Process not found.                                       *)  ! !(*                                                             *)  ! !(***************************************************************)  !         	$ Heapparms OFF $  	     FUNCTION find_process  $ Alias 'Mon.FindProcess' $     (VAR database_num   : Short_int; (* assigned by DBMON *)   !    VAR local_db_num   : short_int; (* assigned in user's prog *)  !     VAR Process        : Process_description_type;      VAR coordx         : Short_int;       VAR workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;          LABEL 99;  (* error exit *)           VAR      process_id  : process_description_type;  
   entry_found : Boolean;  
         BEGIN (* find_process *)      WITH workhorse_data DO BEGIN          find_process := false;  (* Assume the entry will be found *)           entry_found  := false;  (* Set initial value to false *)          (**)      (* Check if the entry is at the index 'database number'.   $   (* It would be if this is the only or first process with the database $    (* open.      (**)       
   coordx := database_num; 
    WITH image_users^[coordx] DO   "   IF ((cmp_processes (process, prog_id, process_description_length) " 
                   = zero) 
           AND (local_db_num = local_db_id)      !      AND (open_mode <> 0))                            (*REV2540*) !           THEN entry_found := true;              (**)      (* If the entry was not found with the initial try, then      (* loop through each entry of the coordination table until      (* the entry containing the process id and database number      (* is found.  Error if no entry qualifies.      (**)          IF NOT (entry_found) THEN coordx := max_image_users;          WHILE (coordx > zero) AND (NOT entry_found) DO BEGIN         WITH image_users^[coordx] DO  "         IF (open_mode > zero) AND (opn_tbl_num = database_num) AND  "              (local_db_num = local_db_id)               THEN BEGIN                 process_id := prog_id;                  IF cmp_processes (process,                                    process_id,  "                                 process_description_length) = zero  "                   THEN entry_found := true;                  END; (* then *)            IF NOT entry_found           THEN coordx := coordx - one;             END; (* while *)          IF NOT entry_found  (* Proc not found: Should never happen *)         THEN BEGIN           error := db_not_open_to_user_err;           find_process := true;  (* Error Occurred *)           END; (* then *)      END; (* with workhorse_data *)      99:  (* error exit *)       END; (* find_process *)       $ Page $  #(*******************************************************************)  # #(*                                                                 *)  # #(* Procedure REMOVE_LOCKS;                                         *)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    Given a coordination table index and a database number,      *)  # #(*    to remove all locks owned by the process for that database.  *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) Database number.                                *)  # #(*    (in)     (2) Coordination table index.                       *)  # #(*    (in/out) (3) Workhorse information.                          *)  # #(*                                                                 *)  # #(* No errors possible.                                             *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     PROCEDURE remove_locks   $ Alias 'Mon.RemoveLocks' $     (VAR database_num   : Short_int;       VAR coord_index    : Short_int;       VAR workhorse_data : Workhorse_info_type);      VAR   
   loop : Short_int; 
         BEGIN (* remove_locks *)      WITH Workhorse_data DO BEGIN         WITH lock_table_ptr^[database_num] DO     FOR loop := one TO max_data_sets DO        IF entry[loop] = coord_index           THEN entry[loop] := zero;         IF unlock_comm_lock_id (image_comm_buffer.dblck_wait_lock,                              error)         THEN; (* ignore any error *)      END; (* with workhorse_data *)  END; (* remove_locks *)       $ Page $  #(*******************************************************************)  # #(*                                                                 *)  # #(* Function VERIFY_SET_LOCK : Boolean;                             *)  # #(*                                                                 *)  # #(* Purpose:                                                        *)  # #(*    Verifies that a specific dataset in a database is locked to  *)  # #(*    a specified program.  Because related masters are auto-      *)  # #(*    matically locked, it is not necessary to verify that they    *)  # #(*    also are locked.  This is overkill for DBUPD's, but better   *)  # #(*    than a multitude of IF statements.                           *)  # #(*                                                                 *)  # #(* Parameters:                                                     *)  # #(*    (in)     (1) Database number.                                *)  # #(*    (in)     (2) Dataset number.                                 *)  # #(*    (in)     (3) Coordination table index.                       *)  # #(*    (in/out) (4) Workhorse_information.                          *)  # #(*    (out)    (5) IMAGE error if set is not locked.               *)  # #(*                                                                 *)  # #(* Function Result:                                                *)  # #(*    Boolean 'True' if the set is not locked, 'False' otherwise.  *)  # #(*                                                                 *)  # #(*******************************************************************)  #     	$ Heapparms OFF $  	     FUNCTION verify_set_lock   $ Alias 'Mon.ChkSetLock' $      (VAR database_num   : Short_int;       VAR Dataset_num    : Short_int;       VAR Coord_index    : Short_int;       VAR Workhorse_data : Workhorse_info_type;       VAR error          : Short_int) : Boolean;          BEGIN (* verify_set_lock *)       WITH workhorse_data DO BEGIN      #   IF lock_table_ptr^[database_num].entry[dataset_num] <> coord_index  #       THEN BEGIN (* ERROR! Set not locked to program *)            error := modify_without_lock_err;           verify_set_lock := true;            END (* then *)         ELSE verify_set_lock := false;      END; (* with workhorse_data *)      
END; (* verify_set_lock *) 
 .  