 $PASCAL ',7 92081-1X708 REV.2540' $           !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* All rights reserved.                                        *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the written  *)  ! !(* consent of Hewlett-Packard Company.                         *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18708                                        *)  ! !(* RELOC:   92081-16708                                        *)  ! !(*                                                             *)  ! !(* PGMR:        <MRL>                                          *)  ! !(*                                                             *)  ! (* Date last modified: <850416.1426>  !(*                                                             *)  ! !(***************************************************************)  !     $ List OFF, Include '[LBOPT', List ON $  (* Library options *)      PROGRAM lock_unlock_operations;            $ List OFF, Include '[IMAGE', List ON $  (* IMAGE definitions *)        $ List OFF, Include '[BMCCT', List ON $  (* Workhorse defn's  *)    $ List OFF, Include '[BMCTV', List ON $  (* DBMON const/types *)    $ List OFF, Include '[BMSAM', List ON $  (* Main definitions  *)        $ List OFF, Include '[XDSEM', List ON $  (* Semaphore defn's  *)    $ List OFF, Include '[XDLDP', List ON $  (* Dormancy check    *)    $ List OFF, Include '[XDSLP', List ON $  (* Sleep for awhile  *)    $ List OFF, Include '[XWPTS', List ON $  (* Pointer defn's    *)    $ List OFF, Include '[XBLUR', List ON $  (* Lock/unlock defn's*)    $ List OFF, Include '[XBLOG', List ON $  (* Logging defn's    *)       $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(* This file contains algorithms for managing the global lock  *)  ! !(* table:  Lock_operation and Unlock_operation.   Only write-  *)  ! !(* locks are handled presently.  Read locks may someday be     *)  ! !(* implemented, in which case a less structured table will be  *)  ! !(* needed to handle the case of multiple programs read-locking *)  ! !(* the same information.                                       *)  ! !(*                                                             *)  ! !(***************************************************************)  !     !(***************************************************************)  ! !(*                                                             *)  ! !(* Also included here, to relieve DBMON space pressures, is    *)  ! !(* the interface to the routine SPOOL_REPLY_HANDLER.  This     *)  ! !(* is needed to get the spool reply code into a segment.       *)  ! !(*                                                             *)  ! !(***************************************************************)  ! $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(* Procedure LOCK_OPERATION;                                   *)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To receive a dblck request message from an IMAGE         *)  ! !(*    application program and lock the requested data.         *)  ! !(*                                                             *)  ! !(* Abstract:                                                   *)  ! !(*    The input message contains the following:                *)  ! !(*    (1) Program process description.                         *)  ! !(*    (2) Database number.                                     *)  ! !(*    (3) DBLCK mode.                                          *)  ! !(*    (4) List of datasets to be locked (for certain modes).   *)  ! !(*                                                             *)  ! !(*    The allowable modes are:                                 *)  ! !(*    (1/2) Lock a database with/without wait.                 *)  ! !(*    (3/4) Lock a dataset with/without wait.                  *)  ! !(*    (5/6) Lock a list of predicates with/without wait.       *)  ! !(*    (7/8) Lock a list of datasets with/without wait.         *)  ! !(*                                                             *)  ! !(* NOTE!                                                       *)  ! !(*    IMAGE/3000 predicates are not implemented in IMAGE/1000  *)  ! !(*    completely.  Only database and dataset 'predicates'      *)  ! !(*    are allowed.  In &PDBMS, if a predicate locks a database,*)  ! !(*    the mode is 'magically' transformed into 1 or 2 instead  *)  ! !(*    of 5 or 6.  For dataset locks the mode is unchanged,     *)  ! !(*    but follows the same algorithm as modes 7 and 8.         *)  ! !(*                                                             *)  ! !(*    It is doubtful that full predicate locks will ever be    *)  ! !(*    implemented in IMAGE/1000 due to a recovery dilemma:     *)  ! !(*    In order to be capable of recovering any arbitrary       *)  ! !(*    transaction, IMAGE must insure that all master records   *)  ! !(*    related to a detail record are locked.  This prevents    *)  ! !(*    another program from deleting/adding a master which      *)  ! !(*    would cause a transaction to be unrecoverable.           *)  ! !(*    So... Suppose we have a true predicate lock on some      *)  ! !(*    set of records in a detail set, say  FRUIT<='GRAPES'.    *)  ! !(*    To guarantee recoverability we have to lock all master   *)  ! !(*    records which are related to all records which satisfy   *)  ! !(*    the relation:  i.e. might as well lock all related       *)  ! !(*    master datasets.   This does not allow two programs to   *)  ! !(*    share a dataset which was the reason for predicates.     *)  ! !(*                                                             *)  ! !(* For a database lock:                                        *)  ! !(*    this routine verifies that no dataset in the database is *)  ! !(*    locked, then places the programs process index in each   *)  ! !(*    dataset entry in the lock table.                         *)  ! !(*                                                             *)  ! !(* For a dataset lock:                                         *)  ! !(*    this routine verifies each specified set for the database*)  ! !(*    is not locked and places the process index in each entry *)  ! !(*    corresponding to the requested sets.                     *)  ! !(*                                                             *)  ! !(* NOTE!                                                       *)  ! !(*    This routine optimizes for successful lock attempts.     *)  ! !(*    Performance will be markedly worse for unsuccessful      *)  ! !(*    calls.                                                   *)  ! !(*                                                             *)  ! !(* If a lock call is unsuccessful and the lock was requested   *)  ! !(* with wait, DBMON will lock the lock_wait_comm_lock resource *)  ! !(* number and return 'unsuccessful' to the caller.  The caller *)  ! !(* in turn tries to lock the same resource number and is       *)  ! !(* suspended by the O/S.  DBMON eventually receives an DBUNL   *)  ! !(* request or does some cleaning up of the lock table, at which*)  ! !(* time it unlocks the wait-lock.  The waiting program is      *)  ! !(* granted the wait-lock resource, unlocks it, and re-issues   *)  ! !(* the DBLCK request.  (Since the O/S queues resource number   *)  ! !(* locks, all programs which are suspended will be granted     *)  ! !(* the resource number lock serially and re-issue their        *)  ! !(* requests).                                                  *)  ! !(*                                                             *)  ! !(***************************************************************)  !         	$ Heapparms OFF $  	     PROCEDURE lock_operation   $ Alias 'Mon.LockProc' $;      LABEL 99;  (* error exit *)       CONST          (* Locking modes *)     db_lock_with_wait    = 1;      (* Lock one database *)      db_lock_no_wait      = 2;     set_lock_with_wait   = 3;      (* Lock one dataset  *)      set_lock_no_wait     = 4;     pred_lock_with_wait  = 5;      (* Lock Predicates   *)      pred_lock_no_wait    = 6;     sets_lock_with_wait  = 7;      (* Lock datasets     *)      sets_lock_no_wait    = 8;          VAR   
   mesg_mode : Short_int;  
 
   mesg_sets : Short_int;  
 
   mesg_db   : Short_int;  
 
   set_num   : Short_int;  
     
   proc_num   : Short_int; 
 
   proc_index : Short_int; 
    process    : process_description_type;          set_loop : Short_int;     rel_loop : Short_int;     rel_set  : Short_int;         lock_successful : Boolean;      num_related_sets: Short_int;      dataset_array   : ARRAY [1..max_data_sets] OF Boolean;          mst_set_ptr : Global_dataset_ctl_table_ptr_type;      mst_inf_ptr : Global_md_path_table_ptr_type;      mst_key_ptr : global_md_info_ptr_type;      mst_frt_ptr : Global_frt_entry_ptr_type;          owner          : short_int;     owning_program : process_description_type;       !   imp_exc_sets   : long_int; (* implicitly exclusive set locks *) !         
BEGIN (* lock_operation *) 
     WITH workhorse_data DO BEGIN         imp_exc_sets := zero;         WITH mb_ptr^.dbmon.estab_locks DO BEGIN        mesg_mode := mode;        mesg_sets := set_count;         process   := user.proc;         mesg_db   := user.db_id;        local_db_number := user.local_db_num;         END; (* with *)          mb_ptr^.user.request := to_user_estab_locks_code;         message_len := to_user_estab_locks_msg_len;         IF find_process (mesg_db,                      local_db_number,                      process,                      proc_index,                       workhorse_data,   
                    error) 
 
      THEN GOTO 99;  
     "   lock_successful := true;  (* Assume lock attempt will succeed *)  "     
   CASE mesg_mode OF 
           db_lock_with_wait,        db_lock_no_wait   : BEGIN  (* lock database *)                (* Verify that no set in the DB is locked to another *)            WITH lock_table_ptr^[mesg_db] DO BEGIN               FOR set_loop := one TO max_data_sets DO BEGIN                  owner := entry[set_loop];                 IF ((owner <> zero) AND                     (owner <> proc_index)) THEN BEGIN                    lock_successful := false;                      owning_program := image_users^[owner].prog_id;                     IF RTE_A2_local_dormant_program                             (owning_program.pname,                             owning_program.process_id)   %                     THEN IF (NOT real_lock_tbl_full_err_flag) THEN BEGIN  %                         auto_cleanup_needed := true;                          real_lock_tbl_full_err_flag := true;                          error := lock_conflict_err;                           GOTO 99;  "                        END; (* do autocleanup once for this user *) "                    END; (* if set is locked by another program *)                  END; (* for *)                   IF lock_successful                 THEN FOR set_loop := one TO max_data_sets DO                     entry[set_loop] := proc_index;                  END; (* with *)                END; (* case of database lock *)           
      set_lock_with_wait,  
       set_lock_no_wait,   
      pred_lock_with_wait, 
       pred_lock_no_wait,  
      sets_lock_with_wait, 
       sets_lock_no_wait : BEGIN  (* Lock one or more sets *)               FOR set_loop := one TO max_data_sets DO              dataset_array[set_loop] := false;                FOR set_loop := one TO mesg_sets DO BEGIN      "            set_num := mb_ptr^.dbmon.estab_locks.set_nums[set_loop]; "                 WITH lock_table_ptr^[mesg_db] DO BEGIN                 owner := entry[set_num];                  IF ((owner <> zero) AND                     (owner <> proc_index)) THEN BEGIN  !                  lock_successful := false; (* locked to other *)  !                    owning_program := image_users^[owner].prog_id;                     IF RTE_A2_local_dormant_program                              (owning_program.pname,                               owning_program.process_id)  %                     THEN IF (NOT real_lock_tbl_full_err_flag) THEN BEGIN  %                         auto_cleanup_needed := true;                          real_lock_tbl_full_err_flag := true;                          error := lock_conflict_err;                           GOTO 99;  "                        END; (* do cleanup once for this program *)  "                   END (* then locked by another *)                    ELSE dataset_array[set_num] := true;                 END; (* with *)                  IF make_master_pointers (mesg_db,                                        set_num,                                        mst_set_ptr,                                        mst_inf_ptr,                                        mst_key_ptr,                                        mst_frt_ptr,                                        workhorse_data,                                       error)                  THEN GOTO 99;                  (**)              (* If set to lock is a master, then lock              (* related details automatically.               (**)                  IF mst_set_ptr^.gdt.set_type <> detail THEN BEGIN                      num_related_sets := mst_set_ptr^.gdt.set_paths;                      FOR rel_loop := one TO num_related_sets DO BEGIN                       rel_set := mst_inf_ptr^[rel_loop].related_set;   "                  owner := lock_table_ptr^[mesg_db].entry[rel_set];  "                       IF (owner = zero) OR (owner = proc_index)                        THEN BEGIN                           IF (NOT dataset_array[rel_set])   "                           THEN imp_exc_sets := imp_exc_sets + one;  "                         dataset_array[rel_set] := true;                           END                        ELSE BEGIN                           lock_successful := false;                           owning_program :=                                 image_users^[owner].prog_id;                          IF RTE_A2_local_dormant_program                                   (owning_program.pname,                                   owning_program.process_id)   "                           THEN IF (NOT real_lock_tbl_full_err_flag) "                               THEN BEGIN                                   auto_cleanup_needed := true;   #                                 real_lock_tbl_full_err_flag := true;  #                                  error := lock_conflict_err;                                   GOTO 99;                                    END;                           END; (* else *)                     END; (* for *)                 END; (* then *)      
            END; (* for *) 
              IF lock_successful               THEN FOR set_loop := one TO max_data_sets DO                 WITH lock_table_ptr^[mesg_db] DO                     IF dataset_array[set_loop]                       THEN entry[set_loop] := proc_index;               END; (* case of dataset locks *)             OTHERWISE BEGIN            error := corrupt_message_err;  	         GOTO 99;  	          END; (* otherwise *)             END; (* case *)              IF NOT lock_successful THEN BEGIN        (**)        (* Lock attempt was unsuccessful, so see if the lock was        (* with wait.  If so, lock the wait_lock resource number        (* and return a conflict err to the calling program.        (**)            (**)         (* It is possible that other programs are waiting to grab          (* the lock-with-wait resource number due to locks being  !      (* released.  If we were to immediately lock the RN because  ! !      (* of this lock conflict, those other programs would remain  !       (* suspended, even though the lock they want might be         (* available.  Therefore, we will suspend DBMON for a         (* reasonable period of time to insure that all programs  !      (* are given a chance to grab and release the lock-with-wait !       (* RN.  This reasonable interval is 20 milliseconds for         (* our purposes, to allow for 2 clock ticks and other         (* high priority programs.        (**)            IF (mesg_mode MOD 2) = one THEN BEGIN            sleep (2);  (* twenty milliseconds *)      !         IF lock_wait_lock_id (image_comm_buffer.dblck_wait_lock,  !                                error)   
            THEN GOTO 99;  
              END; (* then *)            error := lock_conflict_err;         GOTO 99;        END; (* then *)          (**)      (* Return locking statistics to the caller.     (**)          WITH mb_ptr^.user.estab_locks DO BEGIN         implicit_exclusive_set_locks := imp_exc_sets;         implicit_exclusive_rec_locks := zero;         implicit_shared_set_locks := zero;        implicit_shared_rec_locks := zero;        END;      END; (* with workhorse_data *)      99:  (* error exit *)       
END; (* lock_operation *)  
     $ Page $  !(***************************************************************)  ! !(*                                                             *)  ! !(* Procedure UNLOCK_OPERATION;                                 *)  ! !(*                                                             *)  ! !(* Purpose:                                                    *)  ! !(*    To receive a dbunl request message from an IMAGE         *)  ! !(*    application program and unlock the specified database.   *)  ! !(*                                                             *)  ! !(* Abstract:                                                   *)  ! !(*    The input message contains the following:                *)  ! !(*    (1) Program process description.                         *)  ! !(*    (2) Database number.                                     *)  ! !(*                                                             *)  ! !(* Each entry of the global lock table which has the program's *)  ! !(* process ID number is set to zero, effectively unlocking it. *)  ! !(*                                                             *)  ! !(***************************************************************)  !         	$ Heapparms OFF $  	     PROCEDURE Unlock_operation   $ Alias 'Mon.UnlockProc' $;      LABEL 99;  (* error exit *)       VAR   
   mesg_db   : Short_int;  
 
   proc_index: Short_int;  
    process   : process_description_type;      
   set_loop  : Short_int;  
 
   mesg_mode : short_int;  
 
   num_sets  : short_int;  
     BEGIN (* unlock_operation *)      WITH workhorse_data DO BEGIN         WITH mb_ptr^.dbmon.remove_locks DO BEGIN         process   := user.proc;         mesg_db   := user.db_id;        local_db_number := user.local_db_num;         mesg_mode := mode;        num_sets  := set_count;         END; (* with *)          mb_ptr^.user.request := to_user_remove_locks_code;          message_len := to_user_remove_locks_msg_len;          IF find_process (mesg_db,                      local_db_number,                      process,                      proc_index,                       workhorse_data,   
                    error) 
 
      THEN GOTO 99;  
        IF (mesg_mode = one)  (* unlock the database *)        THEN remove_locks (mesg_db, proc_index, workhorse_data);         IF (mesg_mode = 2) (* unlock a list of data sets *)        THEN WITH lock_table_ptr^[mesg_db],                   mb_ptr^.dbmon.remove_locks DO BEGIN                 (* Only unlock those sets really locked to this user *)                FOR set_loop := one TO num_sets DO               IF (entry[set_nums[set_loop]] = proc_index)                  THEN entry[set_nums[set_loop]] := zero;      "         IF unlock_comm_lock_id (image_comm_buffer.dblck_wait_lock,  "                                   error) THEN; (* ignore error *)                END; (* then with *)       
   error := no_image_err;  
     END; (* with workhorse_data *)      99:  (* error exit *)       END; (* unlock_operation *)   .  