 $PASCAL ',7 92081-1X712 REV.2540' $       $ Include '[LBOPT'  $       PROGRAM database_get_operation;       !(***************************************************************)  ! !(* (C) Copyright 1983, Hewlett-Packard Company.                *)  ! !(* No part of this program may be photocopied, reproduced, or  *)  ! !(* translated to another program language without the prior    *)  ! !(* written consent of Hewlett-Packard Company.                 *)  ! !(***************************************************************)  ! !(*                                                             *)  ! !(* SOURCE:  92081-18712                                        *)  ! !(* RELOC:   92081-16712                                        *)  ! !(*                                                             *)  ! !(* PGMR:         <stc>                                         *)  ! !(*                                                             *)  ! (* Date last modified : <850416.1426>   !(*                                                             *)  ! !(***************************************************************)  !     $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)   $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)    #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XWBUF'  $    (* Data buffering routines. *)   $ Include '[XWHRD'  $    (* Hash Read routine. *)   $ Include '[XWPTS'  $    (* Pointer Construction routines. *)    $ Include '[XWBIF'  $    (* Before image buffer/file routines *)   $ List ON $       #(********************************************************************) # #(*                                                                  *) # #(*  PROCEDURE get_operation                                         *) # #(*                                                                  *) # #(*  Purpose :  This procedure is responsible for retrieving data    *) # #(*  from the data set specified by the user, pulling the values     *) # #(*  for any items the user specified, out of the data record of the *) # #(*  entry.  The user can specify which entry in the data set is to  *) # #(*  be read in seven different ways.  Each method of reading        *) # #(*  corresponds to a DBGET mode.  The modes are as follows:         *) # #(*                                                                  *) # #(*  mode 1 - reread the most recently accessed entry of the data set*) # #(*  mode 2 - find and read the NEXT non-empty entry of the data     *) # #(*           set from the most recently accessed entry and          *) # #(*           proceding in a serial monotonically increasing fashion *) # #(*  mode 3 - find and read the PREVIOUS non-empty entry, similiar   *) # #(*           to mode2, except in a decreasing direction.            *) # #(*  mode 4 - read the entry whose record number is specified by     *) # #(*           the user                                               *) # #(*  mode 5 - read the NEXT record, along the current path of the    *) # #(*           detail data set, from the most recently accessed one.  *) # #(*  mode 6 - read the PREVIOUS record, similiar to mode 5.          *) # #(*  mode 7 - find and read the record of the manual master set      *) # #(*           containing the user specified key value.               *) # #(*                                                                  *) # #(*  Input: The global message buffer: it contains                   *) # #(*         (1) the detail set number                                *) # #(*         (2) the get mode                                         *) # #(*         (3) the path number (needed for get modes 5 and 6)       *) # #(*         (4) the get argument (key value OR record number,        *) # #(*                               dependent upon the get mode)       *) # #(*         (5) the tempx table length                               *) # #(*         (6) the tempx table - this table describes each item     *) # #(*               specified by the user                              *) # #(*                                                                  *) # #(*                                                                  *) # #(*  Output:                                                         *) # #(*         The message buffer if successful. The specific get       *) # #(*         information returned is:                                 *) # #(*         (1) return data length                                   *) # #(*         (2) the previous record number                           *) # #(*         (3) the next record number                               *) # #(*         (4) the current record number                            *) # #(*         (5) the data item values                                 *) # #(*                                                                  *) # #(*  Errors:                                                         *) # #(*      12: EOF (end of file) OR BOF (beginning of file) encoutered *) # #(*            when serially reading a data set.                     *) # #(*     107: No master entry for the detail key value.               *) # #(*     114: The record accessed is empty.                           *) # #(*     154: Bad path pointers were encountered.                     *) # #(*     156: Detail does not contain any entries along the chain of  *) # #(*            key value.                                            *) # #(*     160: The run table is corrupt.                               *) # #(*                                                                  *) # #(********************************************************************) # $ List_Code ON $  	$ Heapparms OFF $  	     PROCEDURE get_operation   $ Alias 'Mon.GetRecord' $;      LABEL 99;  (* Error return label. *)      VAR          (**)      (* global variables used are :      (*      (*   rootx : database number      (*   error : latest error number      (*   message_len : return message length      (*   rt_header : pointer to the root file header      (*   dst_entry : pointer to the data set table entry      (*   itm_table : pointer to the item table      (*   frt_entry : pointer to the free record table entry     (*   mpt_table : pointer to the master path table     (*   mit_entry : pointer to the master information table      (*   dpt_table : pointer to the detail path table     (*      (**)       #   get_set_num : short_int;          (* detail or manual set number *) #    key_itm_num : short_int;          (* key item number *)      get_mode_num : short_int;         (* get mode number (1-7) *)      get_path_num : short_int;         (* current path number *)      get_rec_num : long_int;           (* record number to get *)    !   tempx_tbl_len : short_int;        (* word len of tempx table *) !    tempx_tbl : tempx_table_type;     (* table of item info *)      set_type : dataset_type;          (* data set types *)          key_val_ptr : data_record_ptr_type;     hash_bucket_rec : long_int;       (* record hashed into *)   #   hash_bucket_free : boolean;       (* true if hash bucket is free *) #     synonym_head_rec : long_int;      (* head of synonym chain *)       synonym_tail_rec : long_int;      (* tail of synonym chain *)   #   next_free_rec : long_int;         (* next free record for chain *)  # %   record_found : boolean;           (* true if sought record is found *)  %        item_val_ptr : item_value_ptr_type;  %   data_rec_ptr : data_record_ptr_type;    (* ptr to a data base record *) %    mstr_rec_ptr : master_media_record_ptr_type;      dtl_rec_ptr : detail_media_record_ptr_type;         mstr_dscb_entry : global_dataset_ctl_table_ptr_type;      mstr_path_table : global_md_path_table_ptr_type;      mstr_info_table : global_md_info_ptr_type;      mstr_free_rec_table : global_frt_entry_ptr_type;       "   first_word: short_int; (* Start word of adjacent item values. *)  "    total_len : short_int; (* word length of item values. *)      path : short_int;                 (* path number *)      '   num_paths : short_int;            (* number of paths for the master set *)  ' "   max_rec_num : long_int;           (* last record in a dataset *)  "    ix, dr_ix : short_int;            (* indice *)      decrement : boolean;              (* flag for mode 3 *)     chain_length : Long_int;          Any_ptr   : All_pointers_type;      set_capac : Long_int;         done, adjacent : boolean;              
BEGIN  (* get_operation *) 
        (**)   &   (* Retrieve some of the message buffer fields into simple variables now,  & #   (* to avoid pointer calculation every time we reference them later. # %   (* We also must remove the tempx table from the message buffer because  % %   (* we will later be processing the table AS we are filling the message  %    (* buffer with return information.      (**)          WITH MB_ptr^.dbmon.get DO BEGIN        get_set_num := set_num;         get_mode_num := get_mode;         get_path_num := path_num;   %      get_rec_num := get_argument.record_number; (* argument value is   *) %       tempx_tbl_len := table_length;        tempx_tbl := tempx_table;         END;  (* end with mb_ptr *)          rootx := MB_ptr^.dbmon.get.user.db_id;          (**)   !   (* Get the appropriate pointers to various portions of the run  !    (* table, even though we do not know the data set type yet.     (* The pointers are global variables.     (**)          IF make_global_ptrs (rootx,                          get_set_num,                          error)  
      THEN GOTO 99;  
        set_type := dst_entry^.gdt.set_type;          set_capac := frt_entry^.setcp;                  (**)   "   (* Next, we must decide what to do, dependent upon the get mode.  "    (**)          CASE get_mode_num OF             (**)  $      (* Mode 1 - reread the current record.  The current record number  $       (*          is given to us in the message buffer.         (* Mode 4 - read the user specified record number.  "      (* Mode 5 - read the next record along the current chain. That " $      (*          record number has been provided in the message buffer. $ $      (* Mode 6 - read the previous record in the chain.  Ditto mode 5.  $       (**)          1,4,      5,6: BEGIN                    IF (get_rec_num < zero) OR (get_rec_num > set_capac)               THEN BEGIN                   error := path_not_init_err;                   GOTO 99;                  END; (* then bad record number err *)       !          IF read_master_record (rootx,    (* system db number *)  !                                  get_set_num,                                    get_rec_num,                                    do_not_copy,                                    mstr_rec_ptr,                                   workhorse_data,                                   error)   
             THEN GOTO 99; 
              (* Check to see if record is empty *)           IF (mstr_rec_ptr^.entry_type = empty) THEN BEGIN               error := record_empty_err;  
            GOTO 99; 
             END;                   END;   (* end case one *)         2,3 : BEGIN  (* next or previous record serially *)                  (* Set up for read record loop *)               max_rec_num := frt_entry^.leof;               record_found := false;                  (**)  &            (* If we're doing a backward serial read and the current record  & $            (* number is zero, set the record number to the last record  $ $            (* so that we start at the end of the file.   Set a flag so  $             (* that we do not decrement right away.               (**)              decrement := true;              IF (get_mode_num = 3) THEN                 IF (get_rec_num = zero) THEN BEGIN                      get_rec_num := max_rec_num;                     decrement := false;                     END;               (**)  $            (* Read records serially until we encounter a non-empty one  $ %            (* OR: ( for mode 2)until we encounter the last physical data  % $            (* record in the data set ( that record number is stored in  $ %            (* the free record table entry).  This saves time over reading % !            (* until the end or beginning of file as in old IMAGE. !             (* : (for mode3) until the beginning of file.               (**)                  WHILE NOT (record_found) DO BEGIN                  IF (get_mode_num = 2) THEN BEGIN                     workhorse_data.read_ahead_flag := true;   $                  get_rec_num := succ (get_rec_num);  (* NEXT record *)  $                   IF (get_rec_num > max_rec_num) THEN BEGIN   %                     error := bof_eof_err;   (* we've hit the last one *)  %                      GOTO 99;                        END; (* end error *)                      END   (* end increment record number *)                     ELSE BEGIN   (* mode 3 *)  &                  (* Decrement, unless we are STARTing at the last record *) &                   IF (decrement) THEN   &                     get_rec_num := pred (get_rec_num)   (* PREVIOUS one *)  &                   ELSE  %                     decrement := true;  (* okay to decrement next time *) %                   IF (get_rec_num <= zero) THEN BEGIN   "                     error := bof_eof_err;   (* we've hit bottom *)  "                      GOTO 99;                        END;  (* end decrement record number *)                    END;  (* end else *)                     IF read_master_record (rootx,                                        get_set_num,                                        get_rec_num,                                        do_not_copy,                                        mstr_rec_ptr,                                         workhorse_data,                                         error)                    THEN GOTO 99;                      (* Is this entry empty? *)                  IF (mstr_rec_ptr^.entry_type = in_use) THEN                    record_found := true;  (* record is found *)                 END;  (* end while *)               END;   (* end case mode 2,3 *)                7 : BEGIN   (* hashed read into a master *)                  key_itm_num := mit_entry^.master_key;                   IF get_item_value_addr (                 mb_ptr^.dbmon.get.get_argument.item_value,                  key_val_ptr,   
               error) THEN 
                GOTO 99;       #            IF hash_read (rootx,                (* data base number *) # &                          get_set_num,          (* master data set number *) & #                          key_val_ptr,          (* ptr to key value *) # #                          do_not_copy,          (* No before_image *)  # "            (* returns *) get_rec_num,          (* Record number *)  " "                          record_found,         (* record exists? *) " $                          hash_bucket_rec,      (* Hash bucket record*)  $                           hash_bucket_free,     (* Empty?  *)   #                          synonym_head_rec,     (* Syn. chain head. *) # #                          synonym_tail_rec,     (* Syn. chain tail  *) # #                          chain_length,         (* Syn. chain len.  *) # #                          next_free_rec,        (* Next free record *) # $                          mstr_rec_ptr,         (* Ptr to data buffer *) $                           workhorse_data,                             error)                 THEN GOTO 99;                  IF NOT (record_found) THEN BEGIN                 error := no_master_for_key_err;                 GOTO 99;   
               END;  
          END;   (* end case mode 7 - hashed read *)                OTHERWISE BEGIN              error := invalid_mode_err;  
            GOTO 99; 
             END;            END;  (* end case mode *)          (**)   #   (* We now have the record we want.  We must move the values of the  # !   (* items which the user desires, from the data record into the  !     (* return message.  The TEMPX table (set up on the user side)      (* provides us with the information we need :  
   (*    - item num  
    (*    - word length of the item     (*    - index into data record of entry     (**)       $   dr_ix := zero;    (* index into message buffer's item values data *)  $    ix := one;        (* index into tempx table entry *)          Any_ptr.master_media_record := mstr_rec_ptr;      Any_ptr.value := any_ptr.value + dst_entry^.gdt.media_len;      Data_rec_ptr := any_ptr.data_record;              (**)   !   (* Find as many adjacent items in the TEMPX table as possible.  !    (* Move adjacent items together to minimize the number of     (* move-word calls and EMA mappings.       (* Especially when the '@' item list was given, this finding       (* of adjacent items will be a real time saver.     (**)          done := false;  (* end of table indicator. *)      
   WHILE NOT done DO BEGIN 
           IF (tempx_tbl[ix].flags.item_num = zero)  
         THEN done := true 
           ELSE BEGIN (* At least one item remains to be moved. *)                WITH tempx_tbl[ix] DO BEGIN              first_word := start_word;               total_len  := word_length;              END;      
         adjacent := true; 
     
         WHILE adjacent DO 
          WITH tempx_tbl[ix+1] DO           IF (flags.item_num <> zero)              THEN IF (start_word = (tempx_tbl[ix].start_word +                                      tempx_tbl[ix].word_length))                 THEN BEGIN (* They are adjacent! *)                    total_len := total_len + word_length;                     ix := ix + one;                     END                  ELSE adjacent := false               ELSE adjacent := false;                     (* Determine the offset to the beginning of the item *)             (* from the start of the data base record.           *)            Any_ptr.data_record := data_rec_ptr;            Any_ptr.value := any_ptr.value + first_word;            Item_val_ptr  := any_ptr.item_value;                    (* Move the item value from the data record to the *)           (* mesg buffer.                                    *)               IF move_one_item_value (item_val_ptr^,   #                                 mb_ptr^.user.get.data_values[dr_ix],  #                                  total_len,                                    error)   
            THEN GOTO 99;  
              dr_ix := dr_ix + total_len;           ix := ix + one;   (* next tempx table entry *)                END;(* else at least one item *)             END;   (* end while *)             (**)      (*  We are at the end of the item values move.  Set up the      (*  rest of the return message information for DBGET.     (**)          WITH mb_ptr^.user.get DO BEGIN             return_data_length := dr_ix;        current_record_number := get_rec_num;       "      (* Modes 5 and 6 REQUIRE the data set to be a detail.  This *) " "      (* restriction was already checked on the user side.        *) "           IF ( get_mode_num = 5) OR (get_mode_num = 6) THEN BEGIN            Any_ptr.master_media_record := mstr_rec_ptr;            dtl_rec_ptr := any_ptr.detail_media_record;               WITH dtl_rec_ptr^.chains[get_path_num] DO BEGIN              prev_record_number := prev_record;              next_record_number := next_record;              END;  (* end with *)               END   (* end if chained read *)        ELSE BEGIN           prev_record_number := zero;           next_record_number := zero;           END;  (* end else *)          99: (* error return point *)          IF error <> no_image_err         THEN message_len := to_user_get_mesg_len  "      ELSE message_len := to_user_get_mesg_len + return_data_length; "     
   END;  (* with *)  
     END;  .  