$PASCAL ',7 92081-1X692 REV.2440' $     
$ Include '[LBOPT'  $ 
    PROGRAM BMEND;  (* End a transaction *)      (***************************************************************)   (* (C) Copyright 1983, Hewlett-Packard Company.                *)   (* No part of this program may be photocopied, reproduced, or  *)   (* translated to another program language without the prior    *)   (* written consent of Hewlett-Packard Company.                 *)   (***************************************************************)   (*                                                             *)   (* SOURCE:  92081-18692                                        *)   (* RELOC:   92081-16692                                        *)   (*                                                             *)   (* PGMR:        <stc>                                          *)   (*                                                             *)   (* Date last modified: <840912.1406>  (*                                                             *)   (***************************************************************)           $ List OFF $  $ Include '[IMAGE'  $    (* General IMAGE defn's.   *)      $ Include '[BMCCT'  $    (* Workhorse constants and types *)   $ Include '[BMCTV'  $    (* DBMON Constants, Types and Vars. *)    #$ Include '[BMSAM'  $    (* Main globals used by Samurai Segmenter *)  #     $ Include '[XBSDR'  $    (* Commonly used externals. *)   $ Include '[XBLOG'  $    (* Log record routines. *)   $ Include '[XLGLB'  $    (* Log record routines. *)   $ List ON $       	$ Heapparms OFF $  	     "(******************************************************************) " "(*                                                                *) " "(* procedure END_OPERATION                                        *) " "(*                                                                *) " "(* Purpose: This routine allows the user to end his or her        *) " "(* current transaction.  Upon return to the user, it is           *) " "(* guaranteed (if logging is on) that the transaction has         *) " "(* committed.                                                     *) " "(*                                                                *) " "(* Inputs: The global message buffer.                             *) " "(*                                                                *) " "(* Output: Non-zero error if any error occurs.                    *) " "(*                                                                *) " "(* Possible errors: Disc read/write errors.                       *) " "(*                                                                *) " "(******************************************************************) "     	$ Heapparms OFF $  	     PROCEDURE end_operation   $ Alias 'Mon.EndTrans' $;       LABEL 99, (* error label *)         88; (* error label when log record must be removed *)       VAR   $   log_block_num : long_int;  (* TUF block # where log rec may reside *) $    ix : short_int;   (* loop index *)   &   user_xaction_num : long_int;   (* transaction number of xaction ended *)  &         (**)  	(* Globals used :  	 (*    logrec_ptr : pointer to a log record  (*    rootx : database number   (*    error : latest error number   (*    message_len : return user message length  (*  (**)      
BEGIN (* end_operation *)  
     WITH workhorse_data DO BEGIN         message_len := to_user_end_mesg_len;          (* has logging been disabled since we first began *)      IF system_log_status = intr_only THEN BEGIN          error := logging_not_enabled_err;         GOTO 99;        END;         (**)      (* Construct the DBEND log record.      (**)          WITH mb_ptr^.dbmon.endm, workhorse_data DO BEGIN             rootx := user.db_id; (*indx to OPN DB TBL*)         user_xaction_num := xact_num;             (**)        (* Removing entry from ATT automatically removes        (* entry from the OTT because an entry in the          (* ATT corresponds directly (by array index) with the OTT.          (* - Note : to add an entry into the OTT, search the ATT.          (**)      	      IX := zero;  	 !      WHILE (xaction_tbl_ptr^[IX].xaction_num <> user_xaction_num) !       DO BEGIN           IX := succ(IX);           IF (IX > max_IMAGE_users) THEN BEGIN               error := DBMON_internal_err;  
            GOTO 99; 
             END;           END;  (* end while *)     
      (* Are we logging? *) 
      IF opn_tbl_ptr^[rootx].logging_status 	         THEN BEGIN 	                (* YES - form a log record *)             IF make_log_record (dbend_log_code, "                                dbend_log_rec_size + log_comment_len, "                                logrec_ptr,                                  log_block_num,                                  error) 
              THEN GOTO 99; 
                 WITH logrec_ptr^.endm DO BEGIN                 proc_info := user.proc;                trans_num := user_xaction_num;                text_len := log_comment_len;                    IF move_log_text (log_comment,                                   text,                                  log_comment_len,                                  error)                   THEN GOTO 88;                    END;  (* end with *)              (* Flush the TUB to the TUF *)           IF get_new_TUB (error) THEN  
            GOTO 88; 
                 WITH xaction_tbl_ptr^[ix] DO BEGIN              xaction_num := -1;    (* free ATT entry *)              block_num := zero;              END;  (* with *)          END;  (* end if logging *)      
      END;  (* end with *) 
        88:  (* Error exit after log record was made *)         IF (error <> no_image_err) THEN        (* unnecessary, but precautionary check *)       IF opn_tbl_ptr^[rootx].logging_status           THEN remove_log_record;         END;  (* with workhorse data *)      99:  (* Error exit before log record was made *)     END; (* END_OPERATION procedure. *)      .  